/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undotab.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 17:00:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#endif

#pragma hdrstop

//------------------------------------------------------------------

// ?#define _MACRODLG_HXX
// ? #define _BIGINT_HXX
// ? #define _SVDXOUT_HXX
// ? #define _SVDATTR_HXX
// ? #define _SVDSURO_HXX

// INCLUDE ---------------------------------------------------------------


#include "undotab.hxx"
#include "docsh.hxx"
#include "globstr.hrc"
#include "bf_sc.hrc"
#include "undoolk.hxx"
#include "target.hxx"
#include "prnsave.hxx"

// for ScUndoRenameObject - might me moved to another file later
namespace binfilter {

extern BOOL bDrawIsInUndo;			//! irgendwo als Member !!!

using namespace ::com::sun::star;

// STATIC DATA -----------------------------------------------------------



// -----------------------------------------------------------------------
//
//		Tabelle einfuegen
//

/*N*/ ScUndoInsertTab::ScUndoInsertTab( ScDocShell* pNewDocShell,
/*N*/ 								  USHORT nTabNum,
/*N*/ 								  BOOL bApp,
/*N*/ 								  const String& rNewName) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	nTab( nTabNum ),
/*N*/ 	bAppend( bApp ),
/*N*/ 	sNewName( rNewName ),
/*N*/ 	pDrawUndo( NULL )
/*N*/ {
/*N*/ 	pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
/*N*/ 	SetChangeTrack();
/*N*/ }

/*N*/ __EXPORT ScUndoInsertTab::~ScUndoInsertTab()
/*N*/ {
/*N*/ 	DeleteSdrUndoAction( pDrawUndo );
/*N*/ }

/*N*/ String __EXPORT ScUndoInsertTab::GetComment() const
/*N*/ {
/*N*/ 	if (bAppend)
/*N*/ 		return ScGlobal::GetRscString( STR_UNDO_APPEND_TAB );
/*N*/ 	else
/*N*/ 		return ScGlobal::GetRscString( STR_UNDO_INSERT_TAB );
/*N*/ }

/*N*/ void ScUndoInsertTab::SetChangeTrack()
/*N*/ {
/*N*/ 	ScChangeTrack* pChangeTrack = pDocShell->GetDocument()->GetChangeTrack();
/*N*/ 	if ( pChangeTrack )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ScRange aRange( 0, 0, nTab, MAXCOL, MAXROW, nTab );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		nEndChangeAction = 0;
/*N*/ }




/*N*/ BOOL __EXPORT ScUndoInsertTab::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }

// -----------------------------------------------------------------------
//
//		Tabellen einfuegen
//










//----------------------------------------------------------------------------------
//
//		Tabelle loeschen
//











//---------------------------------------------------------------------------------
//
//		Tabelle umbenennen
//

/*N*/ ScUndoRenameTab::ScUndoRenameTab( ScDocShell* pNewDocShell,
/*N*/ 								  USHORT nT,
/*N*/ 								  const String& rOldName,
/*N*/ 								  const String& rNewName) :
/*N*/ 	ScSimpleUndo( pNewDocShell ),
/*N*/ 	nTab 	 ( nT )
/*N*/ {
/*N*/ 	sOldName = rOldName;
/*N*/ 	sNewName = rNewName;
/*N*/ }

/*N*/ __EXPORT ScUndoRenameTab::~ScUndoRenameTab()
/*N*/ {
/*N*/ }

/*N*/ String __EXPORT ScUndoRenameTab::GetComment() const
/*N*/ {
/*N*/ 	return ScGlobal::GetRscString( STR_UNDO_RENAME_TAB );
/*N*/ }





/*N*/ BOOL __EXPORT ScUndoRenameTab::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return FALSE;
/*N*/ }


//----------------------------------------------------------------------------------
//
//		Tabelle verschieben
//










//----------------------------------------------------------------------------------
//
//		Tabelle kopieren
//










// -----------------------------------------------------------------------
//
//		Szenario anlegen
//









// -----------------------------------------------------------------------
//
//		Tabelle einfuegen
//










// -----------------------------------------------------------------------
//
//		Tabellen-Verknuepfung aufheben
//










// -----------------------------------------------------------------------
//
//		Tabellen ein-/ausblenden
//

/*N*/ ScUndoShowHideTab::ScUndoShowHideTab( ScDocShell* pShell, USHORT nNewTab, BOOL bNewShow ) :
/*N*/ 	ScSimpleUndo( pShell ),
/*N*/ 	nTab( nNewTab ),
/*N*/ 	bShow( bNewShow )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoShowHideTab::~ScUndoShowHideTab()
/*N*/ {
/*N*/ }





/*N*/ BOOL __EXPORT ScUndoShowHideTab::CanRepeat(SfxRepeatTarget& rTarget) const
/*N*/ {
/*N*/ 	return (rTarget.ISA(ScTabViewTarget));
/*N*/ }

/*N*/ String __EXPORT ScUndoShowHideTab::GetComment() const
/*N*/ {
/*N*/ 	USHORT nId = bShow ? STR_UNDO_SHOWTAB : STR_UNDO_HIDETAB;
/*N*/ 	return ScGlobal::GetRscString( nId );
/*N*/ }

// -----------------------------------------------------------------------
//
//		Tabelle/Dokument schuetzen oder Schutz aufheben
//









// -----------------------------------------------------------------------
//
//		Druck-/Wiederholungsbereiche aendern
//

/*N*/ ScUndoPrintRange::ScUndoPrintRange( ScDocShell* pShell, USHORT nNewTab,
/*N*/ 									ScPrintRangeSaver* pOld, ScPrintRangeSaver* pNew ) :
/*N*/ 	ScSimpleUndo( pShell ),
/*N*/ 	nTab( nNewTab ),
/*N*/ 	pOldRanges( pOld ),
/*N*/ 	pNewRanges( pNew )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScUndoPrintRange::~ScUndoPrintRange()
/*N*/ {
/*N*/ 	delete pOldRanges;
/*N*/ 	delete pNewRanges;
/*N*/ }








//------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//
//		Szenario-Flags
//









//---------------------------------------------------------------------------------
//
//		rename object
//		(move to different file?)
//













}
