/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewfunc.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 16:32:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_VIEWFUNC_HXX
#define SC_VIEWFUNC_HXX

#ifndef SC_TABVIEW_HXX
#include "tabview.hxx"
#endif

#ifndef _SVSTDARR_USHORTS

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>

#endif

#ifndef _SVSTDARR_STRINGS

#define _SVSTDARR_STRINGS
#include <svtools/svstdarr.hxx>

#endif
namespace com { namespace sun { namespace star { namespace datatransfer { class XTransferable; } } } }
class SfxItemSet;
class SfxStyleSheet;
class SfxPoolItem; 
class SvInPlaceObject;
class Graphic;
namespace binfilter {

#define TABLEID_DOC		0xFFFF

class ScPatternAttr;
class ScAutoFormatData;
class SvxSearchItem;
class SvxBorderLine;
class SvxBoxItem;
class SvxBoxInfoItem;
class EditTextObject;
struct ScSolveParam;
struct ScTabOpParam;
class ScPostIt;
class ScConditionalFormat;
class ScValidationData;
class SdrModel;
class Exchange;
class ScRangeList;
class SvxHyperlinkItem;

//STRIP008 namespace com { namespace sun { namespace star { namespace datatransfer { class XTransferable; } } } }

// ---------------------------------------------------------------------------

class ScViewFunc : public ScTabView
{
private:
	ScAddress	aFormatSource;		// fuer automatisches Erweitern von Formatierung
	ScRange		aFormatArea;
	BOOL		bFormatValid;

public:
					ScViewFunc( Window* pParent, ScDocShell& rDocSh, ScTabViewShell* pViewShell );
					ScViewFunc( Window* pParent, const ScViewFunc& rViewFunc, ScTabViewShell* pViewShell );
					~ScViewFunc();

	const ScPatternAttr*    GetSelectionPattern	();

	BYTE			GetSelectionScriptType();














	long			DropRequestHdl( Exchange* pExchange );





	const SfxStyleSheet*	GetStyleSheetFromMarked();
	void			ShowMarkedColumns( BOOL bShow, BOOL bRecord = TRUE );
	void			ShowMarkedRows( BOOL bShow, BOOL bRecord = TRUE );






	BOOL			TestMergeCells();
	BOOL			TestRemoveMerge();
















	void			InsertDummyObject();
	void			InsertOleObject();

	void			InsertDraw();






	void			ForgetFormatArea()		{ bFormatValid = FALSE; }
	BOOL			SelectionEditable( BOOL* pOnlyNotBecauseOfMatrix = NULL );

												// interne Hilfsfunktionen
protected:



private:

};



} //namespace binfilter
#endif

