/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undoblk.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 16:31:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_UNDOBLK_HXX
#define SC_UNDOBLK_HXX

#ifndef SC_UNDOBASE_HXX
#include "undobase.hxx"
#endif
#ifndef SC_MARKDATA_HXX
#include "markdata.hxx"
#endif
namespace binfilter {

class ScDocShell;
class ScDocument;
class ScOutlineTable;
class ScRangeName;
class ScRangeList;
class ScDBCollection;
class ScPatternAttr;
class SvxBoxItem;
class SvxBoxInfoItem;
class SvxSearchItem;
class SdrUndoAction;

//----------------------------------------------------------------------------









struct ScUndoPasteOptions
{
	USHORT nFunction;
	BOOL bSkipEmpty;
	BOOL bTranspose;
	BOOL bAsLink;
	InsCellCmd eMoveMode;

	ScUndoPasteOptions() :
		nFunction( PASTE_NOFUNC ),
		bSkipEmpty( FALSE ),
		bTranspose( FALSE ),
		bAsLink( FALSE ),
		eMoveMode( INS_NONE )
	{}
};

class ScUndoPaste: public ScBlockUndo
{
public:
					ScUndoPaste( ScDocShell* pNewDocShell,
								 USHORT nStartX, USHORT nStartY, USHORT nStartZ,
								 USHORT nEndX, USHORT nEndY, USHORT nEndZ,
								 const ScMarkData& rMark,
								 ScDocument* pNewUndoDoc, ScDocument* pNewRedoDoc,
								 USHORT nNewFlags,
								 ScRefUndoData* pRefData, void* pFill1, void* pFill2, void* pFill3, 
								 BOOL bRedoIsFilled = TRUE,
								 const ScUndoPasteOptions* pOptions = NULL );
	virtual 		~ScUndoPaste();
private:
	ScMarkData		aMarkData;
	ScDocument*		pUndoDoc;
	ScDocument*		pRedoDoc;
	USHORT			nFlags;
	ScRefUndoData*	pRefUndoData;
	ScRefUndoData*	pRefRedoData;
	ULONG			nStartChangeAction;
	ULONG			nEndChangeAction;
	BOOL			bRedoFilled;
	ScUndoPasteOptions aPasteOptions;

};








class ScUndoSelectionAttr: public ScSimpleUndo
{
public:
					ScUndoSelectionAttr( ScDocShell* pNewDocShell,
										 const ScMarkData& rMark,
										 USHORT nStartX, USHORT nStartY, USHORT nStartZ,
										 USHORT nEndX, USHORT nEndY, USHORT nEndZ,
										 ScDocument* pNewUndoDoc, BOOL bNewMulti,
										 const ScPatternAttr* pNewApply,
										 const SvxBoxItem* pNewOuter = NULL,
										 const SvxBoxInfoItem* pNewInner = NULL );
	virtual 		~ScUndoSelectionAttr();

	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String	GetComment() const;

private:
	ScMarkData		aMarkData;
	ScRange			aRange;
	ScDocument*		pUndoDoc;
	BOOL			bMulti;
	ScPatternAttr*	pApplyPattern;
	SvxBoxItem*		pLineOuter;
	SvxBoxInfoItem*	pLineInner;

};


class ScUndoWidthOrHeight: public ScSimpleUndo
{
public:
							TYPEINFO();
							ScUndoWidthOrHeight( ScDocShell* pNewDocShell,
									const ScMarkData& rMark,
									USHORT nNewStart, USHORT nNewStartTab,
									USHORT nNewEnd, USHORT nNewEndTab,
									ScDocument* pNewUndoDoc,
									USHORT nNewCnt, USHORT* pNewRanges,
									ScOutlineTable* pNewUndoTab,
									ScSizeMode eNewMode, USHORT nNewSizeTwips,
									BOOL bNewWidth );
	virtual 				~ScUndoWidthOrHeight();

	virtual BOOL			CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String          GetComment() const;

private:
	ScMarkData		aMarkData;
	USHORT			nStart;
	USHORT			nEnd;
	USHORT			nStartTab;
	USHORT			nEndTab;
	ScDocument*		pUndoDoc;
	ScOutlineTable*	pUndoTab;
	USHORT			nRangeCnt;
	USHORT*			pRanges;
	USHORT			nNewSize;
	BOOL			bWidth;
	ScSizeMode		eMode;
	SdrUndoAction*	pDrawUndo;
};




class ScUndoMerge: public ScSimpleUndo
{
public:
					ScUndoMerge( ScDocShell* pNewDocShell,
								 USHORT nStartX, USHORT nStartY, USHORT nStartZ,
								 USHORT nEndX,   USHORT nEndY,   USHORT nEndZ,
								 BOOL bNewDoMerge, ScDocument* pNewUndoDoc = NULL );
	virtual 		~ScUndoMerge();

	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String	GetComment() const;

private:
	ScRange			aRange;
	BOOL			bDoMerge;				// Merge oder aufheben
	ScDocument*		pUndoDoc;				// wenn Daten zusammengefasst

};




class ScUndoReplace: public ScSimpleUndo
{
public:
					ScUndoReplace( ScDocShell* pNewDocShell,
								   const ScMarkData& rMark,
								   USHORT nCurX, USHORT nCurY, USHORT nCurZ,
								   const String& rNewUndoStr, ScDocument* pNewUndoDoc,
								   const SvxSearchItem* pItem );
	virtual 		~ScUndoReplace();



private:
	ScTripel		aCursorPos;
	ScMarkData		aMarkData;
	String			aUndoStr;			// Daten bei Einfachmarkierung
	ScDocument*		pUndoDoc;			// Blockmarkierung und geloeschte Daten
	SvxSearchItem*	pSearchItem;
	ULONG			nStartChangeAction;
	ULONG			nEndChangeAction;

};










class ScUndoSelectionStyle: public ScSimpleUndo
{
public:
					ScUndoSelectionStyle( ScDocShell* pNewDocShell,
										  const ScMarkData& rMark,
										  const ScRange& rRange,
										  const String& rName,
										  ScDocument* pNewUndoDoc );
	virtual 		~ScUndoSelectionStyle();

	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String	GetComment() const;

private:
	ScMarkData		aMarkData;
	ScDocument*		pUndoDoc;
	String			aStyleName;
	ScRange			aRange;

};


class ScUndoRefreshLink: public ScSimpleUndo
{
public:
					ScUndoRefreshLink( ScDocShell* pNewDocShell,
									   ScDocument* pNewUndoDoc );
	virtual 		~ScUndoRefreshLink();


private:
	ScDocument*		pUndoDoc;
	ScDocument*		pRedoDoc;
};


class ScUndoEnterMatrix: public ScBlockUndo
{
public:
					TYPEINFO();
					ScUndoEnterMatrix( ScDocShell* pNewDocShell,
									   const ScRange& rArea,
									   ScDocument* pNewUndoDoc,
									   const String& rForm );
	virtual 		~ScUndoEnterMatrix();

	virtual BOOL	CanRepeat(SfxRepeatTarget& rTarget) const;

	virtual String	GetComment() const;

private:
	ScDocument*		pUndoDoc;
	String			aFormula;
	ULONG			nStartChangeAction;
	ULONG			nEndChangeAction;

	void			SetChangeTrack();
};














class ScUndoRemoveBreaks: public ScSimpleUndo
{
public:
					ScUndoRemoveBreaks( ScDocShell* pNewDocShell,
									USHORT nNewTab, ScDocument* pNewUndoDoc );
	virtual 		~ScUndoRemoveBreaks();


private:
	USHORT			nTab;
	ScDocument*		pUndoDoc;
};




class ScUndoBorder: public ScBlockUndo
{
public:
					ScUndoBorder( ScDocShell* pNewDocShell,
									const ScRangeList& rRangeList,
									ScDocument* pNewUndoDoc,
									const SvxBoxItem& rNewOuter,
									const SvxBoxInfoItem& rNewInner );
	virtual 		~ScUndoBorder();



private:
	ScDocument*		pUndoDoc;
	ScRangeList*	pRanges;
	SvxBoxItem*		pOuter;
	SvxBoxInfoItem*	pInner;
};




} //namespace binfilter
#endif

