/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_ofaaccfg.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 14:11:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PRECOMPILED
#endif

#pragma hdrstop

#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SVXACORR_HXX
#include <bf_svx/svxacorr.hxx>
#endif

#include <svtools/pathoptions.hxx>
#include <svtools/urihelper.hxx>

#include "ofaaccfg.hxx"
#include "so3/staticbaseurl.hxx"
namespace binfilter {

using namespace utl;
using namespace rtl;
using namespace ::com::sun::star::uno;

#define C2U(cChar) OUString::createFromAscii(cChar)

/*--------------------------------------------------------------------
	Beschreibung:	Ctor Dtor
 --------------------------------------------------------------------*/

/*N*/ OfaAutoCorrCfg::OfaAutoCorrCfg() :
/*N*/ 	aBaseConfig(*this),
/*N*/ 	aSwConfig(*this),
/*N*/ 	bAutoFmtByInput(TRUE),
/*N*/ 	bAutoTextPreview(FALSE),
/*N*/ 	bFileRel(TRUE),
/*N*/ 	bNetRel(TRUE),
/*N*/ 	bAutoTextTip(TRUE)
/*N*/ {
/*N*/ 	SvtPathOptions aPathOpt;
/*N*/ 	String sSharePath, sUserPath, sAutoPath( aPathOpt.GetAutoCorrectPath() );
/*N*/ 
/*N*/ 	String* pS = &sSharePath;
/*N*/ 	for( USHORT n = 0; n < 2; ++n, pS = &sUserPath )
/*N*/ 	{
/*N*/     	*pS = sAutoPath.GetToken( n, ';' );
/*N*/     	INetURLObject aPath( so3::StaticBaseUrl::SmartRelToAbs( *pS ));
/*N*/     	aPath.insertName( String::CreateFromAscii("acor") );
/*N*/ 		*pS = aPath.GetMainURL(INetURLObject::DECODE_TO_IURI);
/*N*/ 	}
/*N*/     pAutoCorrect = new SvxAutoCorrect( sSharePath, sUserPath );
/*N*/ 
/*N*/ 	aBaseConfig.Load(sal_True);
/*N*/ 	aSwConfig.Load(sal_True);
/*N*/ }

/*N*/ OfaAutoCorrCfg::~OfaAutoCorrCfg()
/*N*/ {
/*N*/ 	delete pAutoCorrect;
/*N*/ }

/*String OfaAutoCorrCfg::GetName() const
{
	return String( OffResId( RID_STR_NAME_ACORRCFG ));
}
*/
/*N*/ void OfaAutoCorrCfg::SetAutoCorrect( SvxAutoCorrect* pNew )
/*N*/ {
/*N*/ 	if( pNew && pNew != pAutoCorrect )
/*N*/ 	{
/*N*/ 		if( pAutoCorrect->GetFlags() != pNew->GetFlags() )
/*N*/ 		{
/*?*/ 			aBaseConfig.SetModified();
/*?*/ 			aSwConfig.SetModified();
/*N*/ 		}
/*N*/ 		delete pAutoCorrect;
/*N*/ 		pAutoCorrect = pNew;
/*N*/ 	}
/*N*/ }
/*-- 12.10.00 11:44:17---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/ Sequence<OUString> 	OfaBaseAutoCorrCfg::GetPropertyNames()
/*N*/ {
/*N*/ 	static const char* aPropNames[] =
/*N*/ 	{
/*N*/ 		"Exceptions/TwoCapitalsAtStart",		//  0
/*N*/ 		"Exceptions/CapitalAtStartSentence",	//  1
/*N*/ 		"UseReplacementTable",					//  2
/*N*/ 		"TwoCapitalsAtStart",					//  3
/*N*/ 		"CapitalAtStartSentence",				//  4
/*N*/ 		"ChangeUnderlineWeight",				//  5
/*N*/ 		"SetInetAttribute",						//  6
/*N*/ 		"ChangeOrdinalNumber",					//  7
/*N*/ 		"ChangeFraction",						//  8
/*N*/ 		"ChangeDash",							//  9
/*N*/ 		"RemoveDoubleSpaces",					// 10
/*N*/ 		"ReplaceSingleQuote",					// 11
/*N*/ 		"SingleQuoteAtStart",					// 12
/*N*/ 		"SingleQuoteAtEnd",						// 13
/*N*/ 		"ReplaceDoubleQuote",					// 14
/*N*/ 		"DoubleQuoteAtStart",					// 15
/*N*/ 		"DoubleQuoteAtEnd"						// 16
/*N*/ 	};
/*N*/ 	const int nCount = 17;
/*N*/ 	Sequence<OUString> aNames(nCount);
/*N*/ 	OUString* pNames = aNames.getArray();
/*N*/ 	for(int i = 0; i < nCount; i++)
/*N*/ 		pNames[i] = OUString::createFromAscii(aPropNames[i]);
/*N*/ 	return aNames;
/*N*/ }
/*-- 12.10.00 11:44:18---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/ void OfaBaseAutoCorrCfg::Load(sal_Bool bInit)
/*N*/ {
/*N*/ 	Sequence<OUString> aNames = GetPropertyNames();
/*N*/ 	Sequence<Any> aValues = GetProperties(aNames);
/*N*/ 	if(bInit)
/*N*/ 		EnableNotification(aNames);
/*N*/ 	const Any* pValues = aValues.getConstArray();
/*N*/ 	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
/*N*/ 	if(aValues.getLength() == aNames.getLength())
/*N*/ 	{
/*N*/ 		long nFlags = 0;		// default alles aus
/*N*/ 		sal_Int32 nTemp = 0;
/*N*/ 		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
/*N*/ 		{
/*N*/ 			if(pValues[nProp].hasValue())
/*N*/ 			{
/*N*/ 				switch(nProp)
/*N*/ 				{
/*N*/ 					case  0:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= SaveWordCplSttLst;
/*N*/ 					break;//"Exceptions/TwoCapitalsAtStart",
/*N*/ 					case  1:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= SaveWordWrdSttLst;
/*N*/ 					break;//"Exceptions/CapitalAtStartSentence",
/*N*/ 					case  2:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= Autocorrect;
/*N*/ 					break;//"UseReplacementTable",
/*N*/ 					case  3:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= CptlSttWrd;
/*N*/ 					break;//"TwoCapitalsAtStart",
/*N*/ 					case  4:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= CptlSttSntnc;
/*N*/ 					break;//"CapitalAtStartSentence",
/*N*/ 					case  5:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= ChgWeightUnderl;
/*N*/ 					break;//"ChangeUnderlineWeight",
/*N*/ 					case  6:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= SetINetAttr;
/*N*/ 					break;//"SetInetAttribute",
/*N*/ 					case  7:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= ChgOrdinalNumber;
/*N*/ 					break;//"ChangeOrdinalNumber",
/*N*/ 					case  8:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= ChgFractionSymbol;
/*N*/ 					break;//"ChangeFraction",
/*N*/ 					case  9:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= ChgToEnEmDash;
/*N*/ 					break;//"ChangeDash",
/*N*/ 					case 10:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							nFlags |= IngnoreDoubleSpace;
/*N*/ 					break;//"RemoveDoubleSpaces",
/*N*/ 					case 11:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*?*/ 							nFlags |= ChgSglQuotes;
/*N*/ 					break;//"ReplaceSingleQuote",
/*N*/ 					case 12:
/*?*/ 						pValues[nProp] >>= nTemp;
/*?*/ 						rParent.pAutoCorrect->SetStartSingleQuote( nTemp );
/*N*/ 					break;//"SingleQuoteAtStart",
/*N*/ 					case 13:
/*?*/ 						pValues[nProp] >>= nTemp;
/*?*/ 						rParent.pAutoCorrect->SetEndSingleQuote( nTemp );
/*N*/ 					break;//"SingleQuoteAtEnd",
/*N*/ 					case 14:
/*N*/ 						if(*(sal_Bool*)pValues[nProp].getValue())
/*N*/ 							nFlags |= ChgQuotes;
/*N*/ 					break;//"ReplaceDoubleQuote",
/*N*/ 					case 15:
/*N*/ 						pValues[nProp] >>= nTemp;
/*N*/ 						rParent.pAutoCorrect->SetStartDoubleQuote( nTemp );
/*N*/ 					break;//"DoubleQuoteAtStart",
/*N*/ 					case 16:
/*?*/ 						pValues[nProp] >>= nTemp;
/*N*/ 						rParent.pAutoCorrect->SetEndDoubleQuote( nTemp );
/*N*/ 					break;//"DoubleQuoteAtEnd"
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 		if( nFlags )
/*N*/ 			rParent.pAutoCorrect->SetAutoCorrFlag( nFlags, TRUE );
/*N*/ 		rParent.pAutoCorrect->SetAutoCorrFlag( ( 0xffff & ~nFlags ), FALSE );
/*N*/ 
/*N*/ 	}
/*N*/ }
/*-- 12.10.00 11:44:19---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/ OfaBaseAutoCorrCfg::OfaBaseAutoCorrCfg(OfaAutoCorrCfg& rPar) :
/*N*/ 	::utl::ConfigItem(C2U("Office.Common/AutoCorrect")),
/*N*/ 	rParent(rPar)
/*N*/ {
/*N*/ }
/*-- 12.10.00 11:44:19---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/ OfaBaseAutoCorrCfg::~OfaBaseAutoCorrCfg()
/*N*/ {
/*N*/ }
/*-- 12.10.00 11:44:20---------------------------------------------------

  -----------------------------------------------------------------------*/
/*-- 12.10.00 11:44:21---------------------------------------------------

  -----------------------------------------------------------------------*/
/*-- 12.10.00 11:51:48---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/ Sequence<OUString> 	OfaSwAutoCorrCfg::GetPropertyNames()
/*N*/ {
/*N*/ 	static const char* aPropNames[] =
/*N*/ 	{
/*N*/ 		"Text/FileLinks",							  // 0
/*N*/ 		"Text/InternetLinks",						  // 1
/*N*/ 		"Text/ShowPreview",							  // 2
/*N*/ 		"Text/ShowToolTip",							  // 3
/*N*/ 		"Format/Option/UseReplacementTable",		  // 4
/*N*/ 		"Format/Option/TwoCapitalsAtStart",			  // 5
/*N*/ 		"Format/Option/CapitalAtStartSentence",		  // 6
/*N*/ 		"Format/Option/ChangeUnderlineWeight",		  // 7
/*N*/ 		"Format/Option/SetInetAttribute",			  // 8
/*N*/ 		"Format/Option/ChangeOrdinalNumber",		  // 9
/*N*/ 		"Format/Option/ChangeFraction",				  //10
/*N*/ 		"Format/Option/ChangeDash",					  //11
/*N*/ 		"Format/Option/DelEmptyParagraphs",			  //12
/*N*/ 		"Format/Option/ReplaceUserStyle",			  //13
/*N*/ 		"Format/Option/ChangeToBullets/Enable",		  //14
/*N*/ 		"Format/Option/ChangeToBullets/SpecialCharacter/Char",		  //15
/*N*/ 		"Format/Option/ChangeToBullets/SpecialCharacter/Font",		  //16
/*N*/ 		"Format/Option/ChangeToBullets/SpecialCharacter/FontFamily",	  //17
/*N*/ 		"Format/Option/ChangeToBullets/SpecialCharacter/FontCharset",	  //18
/*N*/ 		"Format/Option/ChangeToBullets/SpecialCharacter/FontPitch",	  //19
/*N*/ 		"Format/Option/ReplaceQuote",				  //20
/*N*/ 		"Format/Option/CombineParagraphs",			  //21
/*N*/ 		"Format/Option/CombineValue",				  //22
/*N*/ 		"Format/Option/DelSpacesAtStartEnd",		  //23
/*N*/ 		"Format/Option/DelSpacesBetween",			  //24
/*N*/ 		"Format/ByInput/Enable",					  //25
/*N*/ 		"Format/ByInput/ChangeDash",				  //26
/*N*/ 		"Format/ByInput/ApplyNumbering/Enable",		  //27
/*N*/ 		"Format/ByInput/ChangeToBorders",			  //28
/*N*/ 		"Format/ByInput/ChangeToTable",				  //29
/*N*/ 		"Format/ByInput/ReplaceStyle",				  //30
/*N*/ 		"Format/ByInput/DelSpacesAtStartEnd",		  //31
/*N*/ 		"Format/ByInput/DelSpacesBetween",			  //32
/*N*/ 		"Completion/Enable",						  //33
/*N*/ 		"Completion/MinWordLen",					  //34
/*N*/ 		"Completion/MaxListLen",					  //35
/*N*/ 		"Completion/CollectWords",					  //36
/*N*/ 		"Completion/EndlessList",					  //37
/*N*/ 		"Completion/AppendBlank",					  //38
/*N*/ 		"Completion/ShowAsTip",						  //39
/*N*/ 		"Completion/AcceptKey",						  //40
/*N*/         "Completion/KeepList",                        //41
/*N*/         "Format/ByInput/ApplyNumbering/SpecialCharacter/Char",        //42
/*N*/         "Format/ByInput/ApplyNumbering/SpecialCharacter/Font",        //43
/*N*/         "Format/ByInput/ApplyNumbering/SpecialCharacter/FontFamily",  //44
/*N*/         "Format/ByInput/ApplyNumbering/SpecialCharacter/FontCharset", //45
/*N*/         "Format/ByInput/ApplyNumbering/SpecialCharacter/FontPitch",   //46
/*N*/ 	};
/*N*/     const int nCount = 47;
/*N*/ 	Sequence<OUString> aNames(nCount);
/*N*/ 	OUString* pNames = aNames.getArray();
/*N*/ 	for(int i = 0; i < nCount; i++)
/*N*/ 		pNames[i] = OUString::createFromAscii(aPropNames[i]);
/*N*/ 	return aNames;
/*N*/ }
/*-- 12.10.00 11:51:48---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/ void OfaSwAutoCorrCfg::Load(sal_Bool bInit)
/*N*/ {
/*N*/ 	Sequence<OUString> aNames = GetPropertyNames();
/*N*/ 	Sequence<Any> aValues = GetProperties(aNames);
/*N*/ 	if(bInit)
/*N*/ 		EnableNotification(aNames);
/*N*/ 	const Any* pValues = aValues.getConstArray();
/*N*/ 	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
/*N*/ 	if(aValues.getLength() == aNames.getLength())
/*N*/ 	{
/*N*/ 		SvxSwAutoFmtFlags& rSwFlags = rParent.pAutoCorrect->GetSwFlags();
/*N*/ 		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
/*N*/ 		{
/*N*/ 			if(pValues[nProp].hasValue())
/*N*/ 			{
/*N*/ 				switch(nProp)
/*N*/ 				{
/*N*/ 					case   0: rParent.bFileRel = *(sal_Bool*)pValues[nProp].getValue(); break; // "Text/FileLinks",
/*N*/ 					case   1: rParent.bNetRel = *(sal_Bool*)pValues[nProp].getValue();  break; // "Text/InternetLinks",
/*N*/ 					case   2: rParent.bAutoTextPreview = *(sal_Bool*)pValues[nProp].getValue(); break; // "Text/ShowPreview",
/*N*/ 					case   3: rParent.bAutoTextTip = *(sal_Bool*)pValues[nProp].getValue();  break; // "Text/ShowToolTip",
/*N*/ 					case   4: rSwFlags.bAutoCorrect = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/UseReplacementTable",
/*N*/ 					case   5: rSwFlags.bCptlSttSntnc = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/TwoCapitalsAtStart",
/*N*/ 					case   6: rSwFlags.bCptlSttWrd = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/CapitalAtStartSentence",
/*N*/ 					case   7: rSwFlags.bChgWeightUnderl = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/ChangeUnderlineWeight",
/*N*/ 					case   8: rSwFlags.bSetINetAttr = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/SetInetAttribute",
/*N*/ 					case   9: rSwFlags.bChgOrdinalNumber = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/ChangeOrdinalNumber",
/*N*/ 					case  10: rSwFlags.bChgFracionSymbol = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/ChangeFraction",
/*N*/ // it doesn't exist here - the common flags are used for that -> LM
/*N*/ //					case  11: rSwFlags.bChgToEnEmDash = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/ChangeDash",
/*N*/ 					case  12: rSwFlags.bDelEmptyNode = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/DelEmptyParagraphs",
/*N*/ 					case  13: rSwFlags.bChgUserColl = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/ReplaceUserStyle",
/*N*/ 					case  14: rSwFlags.bChgEnumNum = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/ChangeToBullets/Enable",
/*N*/ 					case  15:
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.cBullet = nVal;
/*N*/ 					}
/*N*/ 					break; // "Format/Option/ChangeToBullets/SpecialCharacter/Char",
/*N*/ 					case  16:
/*N*/ 					{
/*N*/ 						OUString sTemp; pValues[nProp] >>= sTemp;
/*N*/ 						rSwFlags.aBulletFont.SetName(sTemp);
/*N*/ 					}
/*N*/ 					break; // "Format/Option/ChangeToBullets/SpecialCharacter/Font",
/*N*/ 					case  17:
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.aBulletFont.SetFamily(FontFamily(nVal));
/*N*/ 					}
/*N*/ 					break; // "Format/Option/ChangeToBullets/SpecialCharacter/FontFamily",
/*N*/ 					case  18:
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.aBulletFont.SetCharSet(CharSet(nVal));
/*N*/ 					}
/*N*/ 					break; // "Format/Option/ChangeToBullets/SpecialCharacter/FontCharset",
/*N*/ 					case  19:
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.aBulletFont.SetPitch(FontPitch(nVal));
/*N*/ 					}
/*N*/ 					break; // "Format/Option/ChangeToBullets/SpecialCharacter/FontPitch",
/*N*/ 					case  20: rSwFlags.bReplaceQuote = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/ReplaceQuote",
/*N*/ 					case  21: rSwFlags.bRightMargin = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/CombineParagraphs",
/*N*/ 					case  22:
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.nRightMargin = nVal;
/*N*/ 					}
/*N*/ 					break; // "Format/Option/CombineValue",
/*N*/ 					case  23: rSwFlags.bAFmtDelSpacesAtSttEnd =  *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/DelSpacesAtStartEnd",
/*N*/ 					case  24: rSwFlags.bAFmtDelSpacesBetweenLines = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/Option/DelSpacesBetween",
/*N*/ 					case  25: rParent.bAutoFmtByInput = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/ByInput/Enable",
/*N*/ 					case  26: rSwFlags.bChgToEnEmDash = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/ByInput/ChangeDash",
/*N*/ 					case  27: rSwFlags.bSetNumRule = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/ByInput/ApplyNumbering/Enable",
/*N*/ 					case  28: rSwFlags.bSetBorder = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/ByInput/ChangeToBorders",
/*N*/ 					case  29: rSwFlags.bCreateTable = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/ByInput/ChangeToTable",
/*N*/ 					case  30: rSwFlags.bReplaceStyles =  *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/ByInput/ReplaceStyle",
/*N*/ 					case  31: rSwFlags.bAFmtByInpDelSpacesAtSttEnd =  *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/ByInput/DelSpacesAtStartEnd",
/*N*/ 					case  32: rSwFlags.bAFmtByInpDelSpacesBetweenLines = *(sal_Bool*)pValues[nProp].getValue(); break; // "Format/ByInput/DelSpacesBetween",
/*N*/ 					case  33: rSwFlags.bAutoCompleteWords = *(sal_Bool*)pValues[nProp].getValue(); break; // "Completion/Enable",
/*N*/ 					case  34:
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.nAutoCmpltWordLen = nVal;
/*N*/ 					}
/*N*/ 					break; // "Completion/MinWordLen",
/*N*/ 					case  35:
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.nAutoCmpltListLen = nVal;
/*N*/ 					}
/*N*/ 					break; // "Completion/MaxListLen",
/*N*/ 					case  36: rSwFlags.bAutoCmpltCollectWords = *(sal_Bool*)pValues[nProp].getValue(); break; // "Completion/CollectWords",
/*N*/ 					case  37: rSwFlags.bAutoCmpltEndless = *(sal_Bool*)pValues[nProp].getValue(); break; // "Completion/EndlessList",
/*N*/ 					case  38: rSwFlags.bAutoCmpltAppendBlanc = *(sal_Bool*)pValues[nProp].getValue(); break; // "Completion/AppendBlank",
/*N*/ 					case  39: rSwFlags.bAutoCmpltShowAsTip = *(sal_Bool*)pValues[nProp].getValue(); break; // "Completion/ShowAsTip",
/*N*/ 					case  40:
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.nAutoCmpltExpandKey = nVal;
/*N*/ 					}
/*N*/ 					break; // "Completion/AcceptKey"
/*N*/                     case 41 :rSwFlags.bAutoCmpltKeepList = *(sal_Bool*)pValues[nProp].getValue(); break;//"Completion/KeepList"
/*N*/                     case 42 :
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.cByInputBullet = nVal;
/*N*/ 					}
/*N*/ 					break;// "Format/ByInput/ApplyNumbering/SpecialCharacter/Char",
/*N*/                     case 43 :
/*N*/ 					{
/*N*/ 						OUString sTemp; pValues[nProp] >>= sTemp;
/*N*/ 						rSwFlags.aByInputBulletFont.SetName(sTemp);
/*N*/ 					}
/*N*/ 					break;// "Format/ByInput/ApplyNumbering/SpecialCharacter/Font",
/*N*/                     case 44 :
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.aByInputBulletFont.SetFamily(FontFamily(nVal));
/*N*/ 					}
/*N*/ 					break;// "Format/ByInput/ApplyNumbering/SpecialCharacter/FontFamily",
/*N*/                     case 45 :
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.aByInputBulletFont.SetCharSet(CharSet(nVal));
/*N*/ 					}
/*N*/ 					break;// "Format/ByInput/ApplyNumbering/SpecialCharacter/FontCharset",
/*N*/                     case 46 :
/*N*/ 					{
/*N*/ 						sal_Int32 nVal; pValues[nProp] >>= nVal;
/*N*/ 						rSwFlags.aByInputBulletFont.SetPitch(FontPitch(nVal));
/*N*/ 					}
/*N*/ 					break;// "Format/ByInput/ApplyNumbering/SpecialCharacter/FontPitch",
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }
/*-- 12.10.00 11:51:48---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/ OfaSwAutoCorrCfg::OfaSwAutoCorrCfg(OfaAutoCorrCfg& rPar) :
/*N*/ 	::utl::ConfigItem(C2U("Office.Writer/AutoFunction")),
/*N*/ 	rParent(rPar)
/*N*/ {
/*N*/ }
/*-- 12.10.00 11:51:48---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/ OfaSwAutoCorrCfg::~OfaSwAutoCorrCfg()
/*N*/ {
/*N*/ }
/*-- 12.10.00 11:51:48---------------------------------------------------

  -----------------------------------------------------------------------*/
/*-- 12.10.00 11:51:49---------------------------------------------------

  -----------------------------------------------------------------------*/
}
