/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: offmgr_fltrcfg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2006/10/27 14:10:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PRECOMPILED
#endif

#pragma hdrstop

#ifndef _SVX_SVXIDS_HRC
#include <bf_svx/svxids.hrc>
#endif

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#include "fltrcfg.hxx"
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
namespace binfilter {

using namespace utl;
using namespace rtl;
using namespace ::com::sun::star::uno;
#define C2U(cChar) OUString::createFromAscii(cChar)

// -----------------------------------------------------------------------
#define FILTERCFG_WORD_CODE 			0x0001
#define FILTERCFG_WORD_STORAGE 			0x0002
#define FILTERCFG_EXCEL_CODE 			0x0004
#define FILTERCFG_EXCEL_STORAGE 		0x0008
#define FILTERCFG_PPOINT_CODE 			0x0010
#define FILTERCFG_PPOINT_STORAGE 		0x0020
#define FILTERCFG_MATH_LOAD				0x0100
#define FILTERCFG_MATH_SAVE				0x0200
#define FILTERCFG_WRITER_LOAD			0x0400
#define FILTERCFG_WRITER_SAVE			0x0800
#define FILTERCFG_CALC_LOAD				0x1000
#define FILTERCFG_CALC_SAVE				0x2000
#define FILTERCFG_IMPRESS_LOAD			0x4000
#define FILTERCFG_IMPRESS_SAVE			0x8000


/* -----------------------------22.01.01 10:23--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ class OfaAppFilterOptions_Impl : public ::utl::ConfigItem
/*N*/ {
/*N*/ 	sal_Bool				bLoadVBA;
/*N*/ 	sal_Bool				bSaveVBA;
/*N*/ public:
/*N*/ 	OfaAppFilterOptions_Impl(const OUString& rRoot) :
/*N*/ 		::utl::ConfigItem(rRoot),
/*N*/ 		bLoadVBA(sal_False),
/*N*/ 		bSaveVBA(sal_False)	 {}
/*N*/ 	~OfaAppFilterOptions_Impl();
/*N*/ 	void					Load();
/*N*/ 
/*N*/ 	sal_Bool				IsLoad() const {return bLoadVBA;}
/*N*/ 	void					SetLoad(sal_Bool bSet)
/*N*/ 							{
/*N*/ 								if(bSet != bLoadVBA)
/*N*/ 									SetModified();
/*N*/ 								bLoadVBA = bSet;
/*N*/ 							}
/*N*/ 	sal_Bool				IsSave() const {return bSaveVBA;}
/*N*/ 	void					SetSave(sal_Bool bSet)
/*N*/ 							{
/*N*/ 								if(bSet != bSaveVBA)
/*N*/ 									SetModified();
/*N*/ 								bSaveVBA = bSet;
/*N*/ 							}
/*N*/ };
/* -----------------------------22.01.01 11:08--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ OfaAppFilterOptions_Impl::~OfaAppFilterOptions_Impl()
/*N*/ {
/*N*/ 	if(IsModified())
/*?*/ 		Commit();
/*N*/ }
/* -----------------------------22.01.01 10:38--------------------------------

 ---------------------------------------------------------------------------*/
/* -----------------------------22.01.01 10:38--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ void	OfaAppFilterOptions_Impl::Load()
/*N*/ {
/*N*/ 	Sequence<OUString> aNames(2);
/*N*/ 	OUString* pNames = aNames.getArray();
/*N*/ 	pNames[0] = C2U("Load");
/*N*/ 	pNames[1] = C2U("Save");
/*N*/ 
/*N*/ 	Sequence<Any> aValues = GetProperties(aNames);
/*N*/ 	const Any* pValues = aValues.getConstArray();
/*N*/ 
/*N*/ 	const Type& rType = ::getBooleanCppuType();
/*N*/ 	if(pValues[0].hasValue())
/*N*/ 		bLoadVBA = *(sal_Bool*)pValues[0].getValue();
/*N*/ 	if(pValues[1].hasValue())
/*N*/ 		bSaveVBA = *(sal_Bool*)pValues[1].getValue();
/*N*/ }
/* -----------------------------22.01.01 10:32--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ struct OfaFilterOptions_Impl
/*N*/ {
/*N*/ 	ULONG nFlags;
/*N*/ 	OfaAppFilterOptions_Impl	aWriterCfg;
/*N*/ 	OfaAppFilterOptions_Impl	aCalcCfg;
/*N*/ 	OfaAppFilterOptions_Impl	aImpressCfg;
/*N*/ 
/*N*/ 	OfaFilterOptions_Impl() :
/*N*/ 		aWriterCfg(C2U("Office.Writer/Filter/Import/VBA")),
/*N*/ 		aCalcCfg(C2U("Office.Calc/Filter/Import/VBA")),
/*N*/ 		aImpressCfg(C2U("Office.Impress/Filter/Import/VBA"))
/*N*/ 		{
/*N*/ 			nFlags = FILTERCFG_WORD_CODE		| FILTERCFG_WORD_STORAGE |
/*N*/ 					FILTERCFG_EXCEL_CODE	| FILTERCFG_EXCEL_STORAGE |
/*N*/ 					FILTERCFG_PPOINT_CODE	| FILTERCFG_PPOINT_STORAGE |
/*N*/ 					FILTERCFG_MATH_LOAD		| FILTERCFG_MATH_SAVE |
/*N*/ 					FILTERCFG_WRITER_LOAD	| FILTERCFG_WRITER_SAVE |
/*N*/ 					FILTERCFG_CALC_LOAD		| FILTERCFG_CALC_SAVE	|
/*N*/ 					FILTERCFG_IMPRESS_LOAD	| FILTERCFG_IMPRESS_SAVE;
/*N*/ 		   Load();
/*N*/ 		}
/*N*/ 
/*N*/ 	void SetFlag( ULONG nFlag, BOOL bSet );
/*N*/ 	BOOL IsFlag( ULONG nFlag ) const;
/*N*/ 	void	Load()
/*N*/ 	{
/*N*/ 		aWriterCfg.Load();
/*N*/ 		aCalcCfg.Load();
/*N*/ 		aImpressCfg.Load();
/*N*/ 	}
/*N*/ };
/* -----------------------------22.01.01 10:34--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ void OfaFilterOptions_Impl::SetFlag( ULONG nFlag, BOOL bSet )
/*N*/ {
/*N*/ 	switch(nFlag)
/*N*/ 	{
/*?*/ 		case FILTERCFG_WORD_CODE:		aWriterCfg.SetLoad(bSet);break;
/*?*/ 		case FILTERCFG_WORD_STORAGE:	aWriterCfg.SetSave(bSet);break;
/*?*/ 		case FILTERCFG_EXCEL_CODE:		aCalcCfg.SetLoad(bSet);break;
/*?*/ 		case FILTERCFG_EXCEL_STORAGE:	aCalcCfg.SetSave(bSet);break;
/*?*/ 		case FILTERCFG_PPOINT_CODE:		aImpressCfg.SetLoad(bSet);break;
/*?*/ 		case FILTERCFG_PPOINT_STORAGE:	aImpressCfg.SetSave(bSet);break;
/*N*/ 		default:
/*N*/ 			if( bSet )
/*N*/ 				nFlags |= nFlag;
/*N*/ 			else
/*N*/ 				nFlags &= ~nFlag;
/*N*/ 	}
/*N*/ }
/* -----------------------------22.01.01 10:35--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ BOOL OfaFilterOptions_Impl::IsFlag( ULONG nFlag ) const
/*N*/ {
/*N*/ 	BOOL bRet;
/*N*/ 	switch(nFlag)
/*N*/ 	{
/*?*/ 		case FILTERCFG_WORD_CODE 		: bRet = aWriterCfg.IsLoad();break;
/*?*/ 		case FILTERCFG_WORD_STORAGE   	: bRet = aWriterCfg.IsSave();break;
/*?*/ 		case FILTERCFG_EXCEL_CODE 	    : bRet = aCalcCfg.IsLoad();break;
/*N*/ 		case FILTERCFG_EXCEL_STORAGE    : bRet = aCalcCfg.IsSave();break;
/*?*/ 		case FILTERCFG_PPOINT_CODE 	 	: bRet = aImpressCfg.IsLoad();break;
/*N*/ 		case FILTERCFG_PPOINT_STORAGE	: bRet = aImpressCfg.IsSave();break;
/*N*/ 		default:
/*?*/ 			bRet = 0 != (nFlags & nFlag );
/*N*/ 	}
/*N*/ 	return bRet;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ OfaFilterOptions::OfaFilterOptions() :
/*N*/ 	ConfigItem( C2U("Office.Common/Filter/Microsoft") ),
/*N*/ 	pImp(new OfaFilterOptions_Impl)
/*N*/ {
/*N*/ 	EnableNotification(GetPropertyNames());
/*N*/ 	Load();
/*N*/ }
// -----------------------------------------------------------------------
/*N*/ OfaFilterOptions::~OfaFilterOptions()
/*N*/ {
/*N*/ 	delete pImp;
/*N*/ }
/* -----------------------------22.01.01 08:45--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ const Sequence<OUString>& OfaFilterOptions::GetPropertyNames()
/*N*/ {
/*N*/ 	static Sequence<OUString> aNames;
/*N*/ 	if(!aNames.getLength())
/*N*/ 	{
/*N*/ 		int nCount = 8;
/*N*/ 		aNames.realloc(nCount);
/*N*/ 		static const char* aPropNames[] =
/*N*/ 		{
/*N*/ 			"Import/MathTypeToMath",			//  0
/*N*/ 			"Import/WinWordToWriter",			//  1
/*N*/ 			"Import/PowerPointToImpress",		//  2
/*N*/ 			"Import/ExcelToCalc",				//  3
/*N*/ 			"Export/MathToMathType",            //  4
/*N*/ 			"Export/WriterToWinWord",           //  5
/*N*/ 			"Export/ImpressToPowerPoint",       //  6
/*N*/ 			"Export/CalcToExcel"            	//  7
/*N*/ 		};
/*N*/ 		OUString* pNames = aNames.getArray();
/*N*/ 		for(int i = 0; i < nCount; i++)
/*N*/ 			pNames[i] = C2U(aPropNames[i]);
/*N*/ 	}
/*N*/ 	return aNames;
/*N*/ }
//-----------------------------------------------------------------------
/*N*/ ULONG lcl_GetFlag(sal_Int32 nProp)
/*N*/ {
/*N*/ 	ULONG nFlag = 0;
/*N*/ 	switch(nProp)
/*N*/ 	{
/*N*/ 		case  0: nFlag = FILTERCFG_MATH_LOAD; break;
/*N*/ 		case  1: nFlag = FILTERCFG_WRITER_LOAD; break;
/*N*/ 		case  2: nFlag = FILTERCFG_IMPRESS_LOAD; break;
/*N*/ 		case  3: nFlag = FILTERCFG_CALC_LOAD; break;
/*N*/ 		case  4: nFlag = FILTERCFG_MATH_SAVE; break;
/*N*/ 		case  5: nFlag = FILTERCFG_WRITER_SAVE; break;
/*N*/ 		case  6: nFlag = FILTERCFG_IMPRESS_SAVE; break;
/*N*/ 		case  7: nFlag = FILTERCFG_CALC_SAVE; break;
/*N*/ 		default: DBG_ERROR("illegal value");
/*N*/ 	}
/*N*/ 	return nFlag;
/*N*/ }
/*-- 22.01.01 08:53:03---------------------------------------------------

  -----------------------------------------------------------------------*/
/*-- 22.01.01 08:53:04---------------------------------------------------

  -----------------------------------------------------------------------*/
/*-- 22.01.01 08:53:04---------------------------------------------------

  -----------------------------------------------------------------------*/
/*N*/ void OfaFilterOptions::Load()
/*N*/ {
/*N*/ 	pImp->Load();
/*N*/ 	const Sequence<OUString>& rNames = GetPropertyNames();
/*N*/ 	Sequence<Any> aValues = GetProperties(rNames);
/*N*/ 	const Any* pValues = aValues.getConstArray();
/*N*/ 	DBG_ASSERT(aValues.getLength() == rNames.getLength(), "GetProperties failed")
/*N*/ 	if(aValues.getLength() == rNames.getLength())
/*N*/ 	{
/*N*/ 		for(int nProp = 0; nProp < rNames.getLength(); nProp++)
/*N*/ 		{
/*N*/ 			if(pValues[nProp].hasValue())
/*N*/ 			{
/*N*/ 				sal_Bool bVal = *(sal_Bool*)pValues[nProp].getValue();
/*N*/ 				ULONG nFlag = lcl_GetFlag(nProp);
/*N*/ 				pImp->SetFlag( nFlag, bVal);
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }
// -----------------------------------------------------------------------





// -----------------------------------------------------------------------




/*N*/ BOOL OfaFilterOptions::IsLoadExcelBasicStorage() const
/*N*/ {
/*N*/ 	return pImp->IsFlag( FILTERCFG_EXCEL_STORAGE );
/*N*/ }

// -----------------------------------------------------------------------




/*N*/ BOOL OfaFilterOptions::IsLoadPPointBasicStorage() const
/*N*/ {
/*N*/ 	return pImp->IsFlag( FILTERCFG_PPOINT_STORAGE );
/*N*/ }

// -----------------------------------------------------------------------






// -----------------------------------------------------------------------





// -----------------------------------------------------------------------





// -----------------------------------------------------------------------







}
