/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TransGradientStyle.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:30:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLOFF_TRANSGRADIENTSTYLE_HXX
#include "TransGradientStyle.hxx"
#endif

#ifndef _COM_SUN_STAR_AWT_GRADIENT_HPP_
#include <com/sun/star/awt/Gradient.hpp>
#endif

#ifndef _XMLOFF_ATTRLIST_HXX
#include "attrlist.hxx"
#endif

#ifndef _XMLOFF_NMSPMAP_HXX
#include "nmspmap.hxx"
#endif

#ifndef _XMLOFF_XMLUCONV_HXX
#include "xmluconv.hxx"
#endif

#ifndef _XMLOFF_XMLNMSPE_HXX
#include "xmlnmspe.hxx"
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring>
#endif

#ifndef _TOOLS_DEBUG_HXX 
#include <tools/debug.hxx>
#endif

#ifndef _XMLOFF_XMLTKMAP_HXX
#include "xmltkmap.hxx"
#endif

#ifndef _XMLOFF_XMLEXP_HXX
#include "xmlexp.hxx"
#endif

#ifndef _XMLOFF_XMLIMP_HXX
#include "xmlimp.hxx"
#endif


using namespace ::com::sun::star;
using namespace ::rtl;
using namespace ::xmloff::token;

enum SvXMLTokenMapAttrs
{
	XML_TOK_GRADIENT_NAME,
	XML_TOK_GRADIENT_DISPLAY_NAME,
	XML_TOK_GRADIENT_STYLE,
	XML_TOK_GRADIENT_CX,
	XML_TOK_GRADIENT_CY,
	XML_TOK_GRADIENT_START,
	XML_TOK_GRADIENT_END,
	XML_TOK_GRADIENT_ANGLE,
	XML_TOK_GRADIENT_BORDER,
	XML_TOK_TABSTOP_END=XML_TOK_UNKNOWN
};

static __FAR_DATA SvXMLTokenMapEntry aTrGradientAttrTokenMap[] =
{
	{ XML_NAMESPACE_DRAW, XML_NAME, XML_TOK_GRADIENT_NAME },
	{ XML_NAMESPACE_DRAW, XML_DISPLAY_NAME, XML_TOK_GRADIENT_DISPLAY_NAME },
	{ XML_NAMESPACE_DRAW, XML_STYLE, XML_TOK_GRADIENT_STYLE },
	{ XML_NAMESPACE_DRAW, XML_CX, XML_TOK_GRADIENT_CX },
	{ XML_NAMESPACE_DRAW, XML_CY, XML_TOK_GRADIENT_CY },
	{ XML_NAMESPACE_DRAW, XML_START, XML_TOK_GRADIENT_START },
	{ XML_NAMESPACE_DRAW, XML_END, XML_TOK_GRADIENT_END },
	{ XML_NAMESPACE_DRAW, XML_GRADIENT_ANGLE, XML_TOK_GRADIENT_ANGLE },
	{ XML_NAMESPACE_DRAW, XML_GRADIENT_BORDER, XML_TOK_GRADIENT_BORDER },
	XML_TOKEN_MAP_END 
};

SvXMLEnumMapEntry __READONLY_DATA pXML_GradientStyle_Enum[] =
{
	{ XML_GRADIENTSTYLE_LINEAR,		    awt::GradientStyle_LINEAR },
	{ XML_GRADIENTSTYLE_AXIAL,			awt::GradientStyle_AXIAL },
	{ XML_GRADIENTSTYLE_RADIAL,		    awt::GradientStyle_RADIAL },
	{ XML_GRADIENTSTYLE_ELLIPSOID,		awt::GradientStyle_ELLIPTICAL },
	{ XML_GRADIENTSTYLE_SQUARE,		    awt::GradientStyle_SQUARE },
	{ XML_GRADIENTSTYLE_RECTANGULAR,	awt::GradientStyle_RECT },
	{ XML_TOKEN_INVALID,                0 }
};


//-------------------------------------------------------------
// Import
//-------------------------------------------------------------

XMLTransGradientStyleImport::XMLTransGradientStyleImport( SvXMLImport& rImp )
    : rImport(rImp)
{
}

XMLTransGradientStyleImport::~XMLTransGradientStyleImport()
{
}

sal_Bool XMLTransGradientStyleImport::importXML( 
    const uno::Reference< xml::sax::XAttributeList >& xAttrList, 
    uno::Any& rValue, 
    OUString& rStrName )
{
	sal_Bool bRet           = sal_False;
	sal_Bool bHasName       = sal_False;
	sal_Bool bHasStyle      = sal_False;
	OUString aDisplayName;

	awt::Gradient aGradient;
	aGradient.XOffset = 0;
	aGradient.YOffset = 0;
	aGradient.StartIntensity = 100;
	aGradient.EndIntensity = 100;
	aGradient.Angle = 0;
	aGradient.Border = 0;

	SvXMLTokenMap aTokenMap( aTrGradientAttrTokenMap );
    SvXMLNamespaceMap& rNamespaceMap = rImport.GetNamespaceMap();
    SvXMLUnitConverter& rUnitConverter = rImport.GetMM100UnitConverter();

	sal_Int16 nAttrCount = xAttrList.is() ? xAttrList->getLength() : 0;
	for( sal_Int16 i=0; i < nAttrCount; i++ )
	{
		const OUString& rFullAttrName = xAttrList->getNameByIndex( i );
		OUString aStrAttrName;
		sal_uInt16 nPrefix = rNamespaceMap.GetKeyByAttrName( rFullAttrName, &aStrAttrName );
		const OUString& rStrValue = xAttrList->getValueByIndex( i );

		sal_Int32 nTmpValue;

		switch( aTokenMap.Get( nPrefix, aStrAttrName ) )
		{
		case XML_TOK_GRADIENT_NAME:
			{
				rStrName = rStrValue;
				bHasName = sal_True;
			}			
			break;
		case XML_TOK_GRADIENT_DISPLAY_NAME:
			{
				aDisplayName = rStrValue;
			}			
			break;
		case XML_TOK_GRADIENT_STYLE:
			{
				sal_uInt16 eValue;
				if( rUnitConverter.convertEnum( eValue, rStrValue, pXML_GradientStyle_Enum ) )
				{
					aGradient.Style = (awt::GradientStyle) eValue;
					bHasStyle = sal_True;
				}
			}
			break;
		case XML_TOK_GRADIENT_CX:
			rUnitConverter.convertPercent( nTmpValue, rStrValue );
			aGradient.XOffset = nTmpValue;
			break;
		case XML_TOK_GRADIENT_CY:
			rUnitConverter.convertPercent( nTmpValue, rStrValue );
			aGradient.YOffset = nTmpValue;
			break;
		case XML_TOK_GRADIENT_START:
			{
				sal_Int32 aStartTransparency;
				rUnitConverter.convertPercent( aStartTransparency, rStrValue );

				aStartTransparency = ( (100 - aStartTransparency) * 255 ) / 100;
				
				Color aColor(aStartTransparency, aStartTransparency, aStartTransparency );
				aGradient.StartColor = (sal_Int32)( aColor.GetColor() );
			}
			break;
		case XML_TOK_GRADIENT_END:
			{
				sal_Int32 aEndTransparency;
				rUnitConverter.convertPercent( aEndTransparency, rStrValue );

				aEndTransparency = ( (100 - aEndTransparency) * 255 ) / 100;

				Color aColor( aEndTransparency, aEndTransparency, aEndTransparency );
				aGradient.EndColor = (sal_Int32)( aColor.GetColor() );
			}
			break;
		case XML_TOK_GRADIENT_ANGLE:
			{
				sal_Int32 nValue;
				rUnitConverter.convertNumber( nValue, rStrValue, 0, 360 );
				aGradient.Angle = sal_Int16( nValue );
			}
			break;
		case XML_TOK_GRADIENT_BORDER:
			rUnitConverter.convertPercent( nTmpValue, rStrValue );
			aGradient.Border = nTmpValue;
			break;

		default:
			DBG_WARNING( "Unknown token at import transparency gradient style" )
			;
		}
	}

	rValue <<= aGradient;

	if( aDisplayName.getLength() )
	{
		rImport.AddStyleDisplayName( XML_STYLE_FAMILY_SD_GRADIENT_ID, rStrName, 
									 aDisplayName );
		rStrName = aDisplayName;
	}

	bRet = bHasName && bHasStyle;

	return bRet;
}


//-------------------------------------------------------------
// Export
//-------------------------------------------------------------

#ifndef SVX_LIGHT

XMLTransGradientStyleExport::XMLTransGradientStyleExport( SvXMLExport& rExp )
    : rExport(rExp)
{
}

XMLTransGradientStyleExport::~XMLTransGradientStyleExport()
{
}


sal_Bool XMLTransGradientStyleExport::exportXML( 
    const OUString& rStrName, 
    const uno::Any& rValue )
{
	sal_Bool bRet = sal_False;
	awt::Gradient aGradient;

	if( rStrName.getLength() )
	{
		if( rValue >>= aGradient )
		{
			OUString aStrValue;
			OUStringBuffer aOut;

            SvXMLUnitConverter& rUnitConverter = 
                rExport.GetMM100UnitConverter();

			// Style
			if( !rUnitConverter.convertEnum( aOut, aGradient.Style, pXML_GradientStyle_Enum ) )
			{
				bRet = sal_False;
			}
			else
			{
				// Name
				sal_Bool bEncoded = sal_False;
				rExport.AddAttribute( XML_NAMESPACE_DRAW, XML_NAME, 
									  rExport.EncodeStyleName( rStrName,
										 					   &bEncoded ) );
				if( bEncoded )
					rExport.AddAttribute( XML_NAMESPACE_DRAW, XML_DISPLAY_NAME, 
									  	  rStrName );
				
				aStrValue = aOut.makeStringAndClear();
				rExport.AddAttribute( XML_NAMESPACE_DRAW, XML_STYLE, aStrValue );
				
				// Center x/y
				if( aGradient.Style != awt::GradientStyle_LINEAR &&
					aGradient.Style != awt::GradientStyle_AXIAL   )
				{
					rUnitConverter.convertPercent( aOut, aGradient.XOffset );
					aStrValue = aOut.makeStringAndClear();
					rExport.AddAttribute( XML_NAMESPACE_DRAW, XML_CX, aStrValue );
					
					rUnitConverter.convertPercent( aOut, aGradient.YOffset );
					aStrValue = aOut.makeStringAndClear();
					rExport.AddAttribute( XML_NAMESPACE_DRAW, XML_CY, aStrValue );
				}
				

				Color aColor;

				// Transparency start
				aColor.SetColor( aGradient.StartColor );
				sal_Int32 aStartValue = 100 - (sal_Int32)(((aColor.GetRed() + 1) * 100) / 255);
				rUnitConverter.convertPercent( aOut, aStartValue );
				aStrValue = aOut.makeStringAndClear();
				rExport.AddAttribute( XML_NAMESPACE_DRAW, XML_START, aStrValue );
				
				// Transparency end
				aColor.SetColor( aGradient.EndColor );
				sal_Int32 aEndValue = 100 - (sal_Int32)(((aColor.GetRed() + 1) * 100) / 255);
				rUnitConverter.convertPercent( aOut, aEndValue );
				aStrValue = aOut.makeStringAndClear();
				rExport.AddAttribute( XML_NAMESPACE_DRAW, XML_END, aStrValue );
				
				// Angle
				if( aGradient.Style != awt::GradientStyle_RADIAL )
				{
					rUnitConverter.convertNumber( aOut, sal_Int32( aGradient.Angle ) );
					aStrValue = aOut.makeStringAndClear();
					rExport.AddAttribute( XML_NAMESPACE_DRAW, XML_GRADIENT_ANGLE, aStrValue );
				}
				
				// Border
				rUnitConverter.convertPercent( aOut, aGradient.Border );
				aStrValue = aOut.makeStringAndClear();
				rExport.AddAttribute( XML_NAMESPACE_DRAW, XML_GRADIENT_BORDER, aStrValue );

				// Do Write
				SvXMLElementExport rElem( rExport, 
										  XML_NAMESPACE_DRAW, XML_OPACITY,
										  sal_True, sal_False );
			}
		}
	}

	return bRet;
}

#endif // #ifndef SVX_LIGHT
