/*
 * MacroCreator.java
 *
 * Created on 28. M?rz 2003, 23:00
 */
package com.sun.star.wizards.tutorial.executer.util;

import java.awt.Component;

import javax.swing.JOptionPane;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.XLibraryContainer;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;

/**
 * This class can create macros in StarOffice.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class MacroCreator {
	/**
	 * Creates a new macro.
	 *
	 * @param xmsf
	 * @param libName
	 * @param name
	 * @param content
	 *
	 * @return result
	 */
	public static String createMacro(XMultiServiceFactory xmsf, String libName, String name, String content) {
		return createMacro(null, xmsf, libName, name, content);
	}

	/**
	 * Creates a new macro.
	 *
	 * @param parentComponent
	 * @param xmsf
	 * @param libName
	 * @param name
	 * @param content
	 *
	 * @return result
	 */
	public static String createMacro(Component parentComponent, XMultiServiceFactory xmsf, String libName, String name, String content) {
		String result = "";

		try {
			XMultiServiceFactory msf = xmsf;
			Object obj = msf.createInstance("com.sun.star.script.ApplicationScriptLibraryContainer");
			XLibraryContainer xl = (XLibraryContainer) UnoRuntime.queryInterface(XLibraryContainer.class, obj);
			XNameAccess as = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, obj);
			XNameContainer xcon;

			if (as.hasByName(libName)) {
				obj = as.getByName(libName);
				xcon = (XNameContainer) UnoRuntime.queryInterface(XNameContainer.class, obj);
			} else {
				xcon = xl.createLibrary(libName);
			}

			if (xcon.hasByName(name)) {
				String message = name + " already exists.\n Do you want to replace it?";
				int resultOptions = JOptionPane.showConfirmDialog(parentComponent, message, "Create macro", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

				if (resultOptions == 0) {
					xcon.removeByName(name);
				} else {
					name = JOptionPane.showInputDialog(parentComponent, "Please insert new macro name:");

					if ((name == null) || name.equals("")) {
						return "Macro create failed";
					} else if (xcon.hasByName(name)) {
						return "Macro create failed.\nNew macro name exists. ";
					}
				}
			}

			xcon.insertByName(name, content);
			result = "Macro create succesfull";
		} catch (IllegalArgumentException ex) {
			ex.printStackTrace();
			result = "com.sun.star.lang.IllegalArgumentException";
		} catch (ElementExistException ex2) {
			ex2.printStackTrace();
			result = "com.sun.star.container.ElementExistException";
		} catch (WrappedTargetException ex3) {
			ex3.printStackTrace();
			result = "com.sun.star.lang.WrappedTargetException";
		} catch (Exception ex4) {
			result = "com.sun.star.uno.Exception";
		}

		return result;
	}

	/**
	 * Creates a new macro by document.
	 *
	 * @param xm
	 * @param libName
	 * @param name
	 * @param content
	 * @param overwrite DOCUMENT ME!
	 *
	 * @return result
	 */
	public static String createDocumentMacro(XModel xm, String libName, String name, String content, boolean overwrite) {
		return createDocumentMacro(null, xm, libName, name, content, overwrite);
	}

	/**
	 * Creates a new macro.
	 *
	 * @param parentComponent
	 * @param xm
	 * @param libName
	 * @param name
	 * @param content
	 * @param overwrite DOCUMENT ME!
	 *
	 * @return result
	 */
	public static String createDocumentMacro(Component parentComponent, XModel xm, String libName, String name, String content, boolean overwrite) {
		String result = "";

		try {
			XPropertySet xsba = (XPropertySet) UnoRuntime.queryInterface(XPropertySet.class, xm);

			Object obj = xsba.getPropertyValue("BasicLibraries");
			XLibraryContainer xl = (XLibraryContainer) UnoRuntime.queryInterface(XLibraryContainer.class, obj);

			XNameAccess as = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, obj);
			XNameContainer xcon;

			if (as.hasByName(libName)) {
				obj = as.getByName(libName);
				xcon = (XNameContainer) UnoRuntime.queryInterface(XNameContainer.class, obj);
			} else {
				xcon = xl.createLibrary(libName);
			}

			if (xcon.hasByName(name)) {
				int resultOptions = 0;

				if (!overwrite) {
					String message = name + " already exists.\n Do you want to replace it?";
					resultOptions = JOptionPane.showConfirmDialog(parentComponent, message, "Create macro", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
				}

				if (resultOptions == 0) {
					xcon.replaceByName(name, content);
				} else {
					name = JOptionPane.showInputDialog(parentComponent, "Please insert new macro name:");

					if ((name == null) || name.equals("")) {
						return "Macro create failed";
					} else if (xcon.hasByName(name)) {
						return "Macro create failed.\nNew macro name exists. ";
					} else {
						xcon.insertByName(name, content);
					}
				}
			} else {
				xcon.insertByName(name, content);
			}

			result = "Macro create succesfull";
		} catch (IllegalArgumentException ex) {
			ex.printStackTrace();
			result = "com.sun.star.lang.IllegalArgumentException";
		} catch (ElementExistException ex2) {
			ex2.printStackTrace();
			result = "com.sun.star.container.ElementExistException";
		} catch (WrappedTargetException ex3) {
			ex3.printStackTrace();
			result = "com.sun.star.lang.WrappedTargetException";
		} catch (Exception ex4) {
			result = "com.sun.star.uno.Exception";
		}

		return result;
	}
}
