package com.sun.star.wizards.tutorial.executer.util;

import java.io.IOException;

import java.util.Enumeration;
import java.util.Vector;

import com.sun.star.accessibility.AccessibleRole;
import com.sun.star.accessibility.AccessibleStateType;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XWindow;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sheet.XCellAddressable;
import com.sun.star.table.XCell;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;

/**
 * This class provides accessibility. Singleton class, can have only one instance.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class AccessibilityTools {
	private static AccessibilityTools m_acces;
	private static int m_LIMIT = 300;
	private static int m_MAX_COUNT = 5;
	private static int m_LEVEL = 1;
	private static int m_SHEET_LIMIT = 8000000;
	public static final String SERCH_FORM_NAME = "NAME";
	public static final String SERCH_FORM_INDEX = "INDEX";
	private static String m_current_search_form = SERCH_FORM_NAME;

	/**
	 * Static initializer for this class. Creates the only instance for that.
	 */
	static {
		new AccessibilityTools();
	}

	/**
	 * Creates a new AccessibilityTools object.
	 */
	private AccessibilityTools() {
		m_acces = this;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param form DOCUMENT ME!
	 *
	 * @throws Exception DOCUMENT ME!
	 */
	public static void setSearchForm(String form) throws Exception {
		if (form.equals(SERCH_FORM_NAME) || form.equals(SERCH_FORM_INDEX)) {
			m_current_search_form = form;
		} else {
			throw new Exception("Search form invalid!");
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public static String getSearchForm() {
		return m_current_search_form;
	}

	/**
	 * Queries the argument object to XAccessible object.
	 *
	 * @param xObject is an interface and muss be supported through XAccessible interface
	 *
	 * @return if the xObject is supported, returns XAccessible object, otherwise null.
	 */
	public static XAccessible getAccessibleObject(XInterface xObject) {
		XAccessible xAccessible = null;

		try {
			xAccessible = (XAccessible) UnoRuntime.queryInterface(XAccessible.class, xObject);
		} catch (Exception e) {
			Helper.log("caught exception while getting accessible object" + e);
			e.printStackTrace();
		}

		return xAccessible;
	}

	/**
	 * Query this argument object in XAccessibleEditableText object.
	 *
	 * @param xObject is an interface and muss be supported through
	 *        XAccessibleEditableText interface
	 *
	 * @return if the xObject is supported, returns XAccessibleEditableText object,
	 *         otherwise null.
	 */
	public static XAccessibleEditableText getAccessibleEditableTextObject(XInterface xObject) {
		XAccessibleEditableText xacclEditText = null;

		try {
			xacclEditText = (XAccessibleEditableText) UnoRuntime.queryInterface(XAccessibleEditableText.class, xObject);
		} catch (Exception e) {
			Helper.log("caught exception while getting accessible object" + e);
			e.printStackTrace();
		}

		return xacclEditText;
	}

	/**
	 * Query this argument objekt in XAccessibleText objekt.
	 *
	 * @param xObject is an interface and muss be supported through XAccessibleText
	 *        interface
	 *
	 * @return if the xObject is supported, returns XAccessibleText object, otherwise
	 *         null.
	 */
	public static XAccessibleText getAccessibleTextObject(XInterface xObject) {
		XAccessibleText xacclText = null;

		try {
			xacclText = (XAccessibleText) UnoRuntime.queryInterface(XAccessibleText.class, xObject);
		} catch (Exception e) {
			Helper.log("caught exception while getting accessible object" + e);
			e.printStackTrace();
		}

		return xacclText;
	}

	/**
	 * Query this argument objekt in XCell objekt.
	 *
	 * @param xObject is an interface and muss be supported through XCell interface
	 *
	 * @return if the xObject is supported, returns XCell object, otherwise null.
	 */
	public static XCell getAccessibleCell(XInterface xObject) {
		XCell xcell = null;

		try {
			xcell = (XCell) UnoRuntime.queryInterface(XCell.class, xObject);
		} catch (Exception e) {
			Helper.log("caught exception while getting accessible object" + e);
			e.printStackTrace();
		}

		return xcell;
	}

	/**
	 * Query this argument objekt in XCellAddressable objekt.
	 *
	 * @param xObject is an interface and muss be supported through XCellAddressable
	 *        interface
	 *
	 * @return if the xObject is supported, returns XCellAddressable object, otherwise
	 *         null.
	 */
	public static XCellAddressable getCellAddressable(XInterface xObject) {
		XCellAddressable xcellAdd = null;

		try {
			xcellAdd = (XCellAddressable) UnoRuntime.queryInterface(XCellAddressable.class, xObject);
		} catch (Exception e) {
			Helper.log("caught exception while getting accessible object" + e);
			e.printStackTrace();
		}

		return xcellAdd;
	}

	/**
	 * Query this argument objekt in XAccessibleSelection objekt.
	 *
	 * @param xObject is an interface and muss be supported through XAccessibleSelection
	 *        interface
	 *
	 * @return if the xObject is supported, returns XAccessibleSelection object,
	 *         otherwise null.
	 */
	public static XAccessibleSelection getXAccessibleSelection(XInterface xObject) {
		XAccessibleSelection xAccessibleSel = null;

		try {
			xAccessibleSel = (XAccessibleSelection) UnoRuntime.queryInterface(XAccessibleSelection.class, xObject);
		} catch (Exception e) {
			Helper.log("caught exception while getting accessible object" + e);
			e.printStackTrace();
		}

		return xAccessibleSel;
	}

	/**
	 * Query this argument objekt in XAccessibleContext objekt.
	 *
	 * @param xObject is an interface and muss be supported through XAccessibleContext
	 *        interface
	 *
	 * @return if the xObject is supported, returns XAccessibleContext object, otherwise
	 *         null.
	 */
	public static XAccessibleContext getXAccessibleContext(XInterface xObject) {
		XAccessibleContext xcon = null;

		try {
			xcon = (XAccessibleContext) com.sun.star.uno.UnoRuntime.queryInterface(XAccessibleContext.class, xObject);
		} catch (Exception e) {
			Helper.log("caught exception while getting accessible object" + e);
			e.printStackTrace();
		}

		return xcon;
	}

	/**
	 * Places all children, who have the parameters "role" and "name" from the
	 * XAccessibleContext into a vector.
	 *
	 * @param ac tree
	 * @param role role
	 * @param name name
	 * @param vec result vector for the found children
	 */
	private void getAllXAccessibleContexts(XAccessibleContext ac, short role, String name, Vector vec) {
		try {
			short roleTemp = ac.getAccessibleRole();
			String nameTemp = ac.getAccessibleName().trim();

			if ((roleTemp == role) && nameTemp.equals(name)) {
				vec.add(ac);
			} else {
				XAccessibleContext ac1 = null;
				int k = ac.getAccessibleChildCount();

				if (k > m_SHEET_LIMIT) {
					if (role == AccessibleRole.TABLE_CELL) {
						ac1 = m_acces.getXAccessibleCellContext(ac, name, 0, ac.getAccessibleChildCount());

						vec.add(ac1);
					}
				} else if (role == AccessibleRole.PARAGRAPH) {
					int indexof = name.indexOf("Paragraph:");

					if (indexof > -1) {
						String sIndex = (name.substring(indexof + "Paragraph:".length())).trim();
						int index = Integer.parseInt(sIndex);
						XAccessible xacc = ac.getAccessibleChild(index);

						if (xacc != null) {
							ac1 = xacc.getAccessibleContext();

							vec.add(ac1);
						}
					}
				} else if (k < m_SHEET_LIMIT) {
					if (k > m_LIMIT) {
						k = m_LIMIT;
					}

					for (int i = 0; i < k; i++) {
						ac1 = ac.getAccessibleChild(i).getAccessibleContext();

						roleTemp = ac1.getAccessibleRole();
						nameTemp = (ac1.getAccessibleName()).trim();

						if ((roleTemp == role) && nameTemp.equals(name)) {
							Helper.log("ROLE4 = " + ac1.getAccessibleRole());
							Helper.log("NAME4 = " + ac1.getAccessibleName());
							Helper.log("***************************");
							vec.add(ac1);
							i = k;
						}
					}
				}
			}
		} catch (com.sun.star.lang.IndexOutOfBoundsException e) {
			Helper.log("Couldn't get Child");
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param acc DOCUMENT ME!
	 * @param path DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	private XAccessibleContext getAllXAccessibleContexts(XAccessibleContext acc, String[] path) {
		int leng = path.length;
		XAccessibleContext ac = acc;

		try {
			for (int i = 1; i < leng; i++) {
				PathProperties.putPath(path, i);

				int index = PathProperties.getIndex();
				short role = PathProperties.getRole();
				Helper.log("**************************************");
				Helper.log("Search child : " + index);
				Helper.log("childer : " + ac.getAccessibleChildCount());

				if ((ac != null) && (ac.getAccessibleChildCount() > index)) {
					for (int ii = 0; ii < ac.getAccessibleChildCount(); ii++) {
						Helper.log("child : " + ac.getAccessibleChild(ii).getAccessibleContext().getAccessibleRole() + " **** " + ac.getAccessibleChild(ii).getAccessibleContext().getAccessibleName());
					}

					ac = ac.getAccessibleChild(index).getAccessibleContext();

					Helper.log("Find child for index :" + ac.getAccessibleRole() + " ** " + ac.getAccessibleName());
					Helper.log("**************************************");

					if (ac.getAccessibleRole() != role) {
						ac = null;

						break;
					}
				} else {
					ac = null;

					break;
				}
			}
		} catch (Exception e) {
			ac = null;
			e.printStackTrace();
		}

		return ac;
	}

	/**
	 * Calls the method "getAllXAccessibleContexts" for all XAccessibleContexts
	 *
	 * @param role role
	 * @param name name
	 * @param vec result vector for the found children
	 *
	 * @return DOCUMENT ME!
	 */
	private Vector getAllXAccessibleContextsHelp(short role, String name, Vector vec) {
		Vector resultVec = new Vector();

		for (Enumeration e = vec.elements(); e.hasMoreElements();) {
			XAccessibleContext ac1 = (XAccessibleContext) e.nextElement();

			Helper.log("ROLE3 = " + ac1.getAccessibleRole());
			Helper.log("NAME3 = " + ac1.getAccessibleName());
			Helper.log("***************************");
			getAllXAccessibleContexts(ac1, role, name, resultVec);
		}

		return resultVec;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param path DOCUMENT ME!
	 * @param vec DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	private XAccessibleContext getAllXAccessibleIndexContextsHelp(String[] path, Vector vec) {
		XAccessibleContext ac = null;

		for (Enumeration e = vec.elements(); e.hasMoreElements();) {
			ac = (XAccessibleContext) e.nextElement();
			Helper.log("ROLE4 = " + ac.getAccessibleRole());
			Helper.log("NAME4 = " + ac.getAccessibleName());
			Helper.log("***************************");
			ac = getAllXAccessibleContexts(ac, path);

			if (ac != null) {
				break;
			}
		}

		return ac;
	}

	/**
	 * Is top window active
	 *
	 * @param xWindows DOCUMENT ME!
	 * @param role DOCUMENT ME!
	 * @param name DOCUMENT ME!
	 *
	 * @return true: is active, otherwise false.
	 */
	public static boolean isTopWindowActive(XWindow[] xWindows, short role, String name) {
		if (xWindows != null) {
			Debug.printXWindows(xWindows);

			for (int i = 0; i < xWindows.length; i++) {
				XWindow xWindow = xWindows[i];
				XAccessibleContext ac = getAccessibleObject(xWindow).getAccessibleContext();

				while (ac.getAccessibleIndexInParent() > -1) {
					ac = ac.getAccessibleParent().getAccessibleContext();
				}

				if ((ac.getAccessibleRole() == role) && ac.getAccessibleName().equals(name)) {
					return true;
				}
			}
		}

		return false;
	}

	/**
	 * Is top window active
	 *
	 * @param xWindows DOCUMENT ME!
	 * @param role DOCUMENT ME!
	 *
	 * @return true: is active, otherwise false.
	 */
	public static boolean isTopWindowActive(XWindow[] xWindows, short role) {
		if (xWindows != null) {
			Debug.printXWindows(xWindows);

			for (int i = 0; i < xWindows.length; i++) {
				XWindow xWindow = xWindows[i];

				if (xWindow == null) {
					continue;
				}

				XAccessibleContext ac = getAccessibleObject(xWindow).getAccessibleContext();

				if (ac == null) {
					continue;
				}

				while (ac.getAccessibleIndexInParent() > -1) {
					ac = ac.getAccessibleParent().getAccessibleContext();
				}

				if (ac.getAccessibleRole() == role) {
					return true;
				}
			}
		}

		return false;
	}

	/**
	 * Searches in the Accessibility tree for the child identified by the path.
	 *
	 * @param xacc tree
	 * @param role role
	 * @param name name
	 *
	 * @return child node
	 */
	public static XAccessibleContext getXAccessibleContext(XAccessibleContext xacc, short role, String name) {
		return m_acces.findXAccessibleContextHelp(xacc, role, name);
	}

	//*******************************************************************
	//                                                                  *
	//                             tools                                *
	//                                                                  *
	//*******************************************************************

	/**
	 * Get role name for role id
	 *
	 * @param nRole role id
	 *
	 * @return XAccessible name
	 */
	public static String getRoleName(int nRole) {
		return NameProvider.getRoleName(nRole);
	}

	/**
	 * Checks if the given state is a member of the state set of the called XAccessible
	 * object.
	 *
	 * @param xacc object
	 * @param accessibleStateType state for which to check membership. This has to be one
	 *        of the constants of AccessibleStateType .
	 *
	 * @return Returns true if the given state is a memeber of this object's state set
	 *         and false otherwise.
	 */
	public static boolean checkState(XAccessibleContext xacc, short accessibleStateType) {
		XAccessibleStateSet state = xacc.getAccessibleStateSet();

		return (state.contains(accessibleStateType));
	}

	/**
	 * Get all properties for the XAccessible object.
	 *
	 * @param xacc object
	 *
	 * @return all properties
	 */
	public static Vector getXAllAccessibleProperties(XAccessible xacc) {
		Vector properties = new Vector();
		m_acces.setAllAccessibleProperties(xacc, properties, "");

		return properties;
	}

	/**
	 * Get the implementation's name for the object. The object must provide the
	 * XServiceInfo.
	 *
	 * @param aObject
	 *
	 * @return Implementation's name
	 */
	public static String getImplName(Object aObject) {
		String res = "Error getting Implementation name";

		try {
			XServiceInfo xSI = (XServiceInfo) UnoRuntime.queryInterface(XServiceInfo.class, aObject);
			res = xSI.getImplementationName();
		} catch (Exception e) {
			res = "Error getting Implementation name ( " + e + " )";
		}

		return res;
	}

	/**
	 * Get the supported service names for the Object.The object must provide the
	 * XServiceInfo.
	 *
	 * @param aObject
	 *
	 * @return supported service names
	 */
	public static String[] getSupportedServiceNames(Object aObject) {
		String[] res = null;

		try {
			XServiceInfo xSI = (XServiceInfo) UnoRuntime.queryInterface(XServiceInfo.class, aObject);

			if (xSI != null) {
				res = xSI.getSupportedServiceNames();
			}
		} catch (Exception e) {
		}

		return res;
	}

	/**
	 * Returns the coordinates that are for sure located on the given object as absolute
	 * screen coordinates.
	 *
	 * @param xIf object
	 *
	 * @return the assured point coordinates for this object
	 */
	public static int[] getPoints(XInterface xIf) {
		Point point = getObjPoint(xIf);
		Rectangle rec = getObjRectangle(xIf);
		int recWidth = new Long(rec.Width).intValue();

		if (recWidth > 25) {
			recWidth = 25;
		}

		int recHeight = new Long(rec.Height).intValue();
		int[] result = new int[2];
		result[0] = point.X + (recWidth / 2);
		result[1] = point.Y + (recHeight / 2);

		return result;
	}

	/**
	 * Returns the bounding box of this object. The returned bounding box has the form of
	 * a rectangle. Its coordinates are relative to the object's parent coordinate
	 * system. Note that the two methods getLocation and getSize return the same
	 * information. With method getLocationOnScreen you can get the bound box position
	 * in screen coordinates.
	 *
	 * @param xif onject
	 *
	 * @return The coordinates of the returned rectangle are relative to this object's
	 *         parent or relative to the screen on which this object is rendered if it
	 *         has no parent. If the object is not on any screen the returnred rectangle
	 *         is empty and located at position (0,0).
	 */
	public static Rectangle getObjRectangle(XInterface xif) {
		XAccessibleComponent xAcc = (XAccessibleComponent) UnoRuntime.queryInterface(XAccessibleComponent.class, xif);
		Rectangle bounds = xAcc.getBounds();

		return bounds;
	}

	/**
	 * Returns the location of the upper left corner of the object's bounding box in
	 * screen coordinates. This method returns the same point as does the method
	 * getLocation . The difference is that the coordinates are absolute screen
	 * coordinates of the screen to which the object is rendered instead of being
	 * relative to the object's parent.
	 *
	 * @param xif onject
	 *
	 * @return The coordinates of the returned position are relative to the screen on
	 *         which this object is rendered. If the object is not on any screen the
	 *         returnred position is (0,0).
	 */
	public static Point getObjPoint(XInterface xif) {
		XAccessibleComponent xAcc = (XAccessibleComponent) UnoRuntime.queryInterface(XAccessibleComponent.class, xif);
		Point point = xAcc.getLocationOnScreen();

		return point;
	}

	/**
	 * Print the XAccessible tree properties
	 *
	 * @param xacc tree
	 * @param printForm form parameter can be either "Line" or "Tree"
	 */
	public static void printAccessibleTree(XAccessible xacc, String printForm) {
		printAccessibleTree(xacc, null, printForm);
	}

	/**
	 * Save the XAccessible tree properties in file
	 *
	 * @param xacc tree
	 * @param filePath file path
	 * @param printForm form parameter can be either "Line" or "Tree"
	 */
	public static void printAccessibleTree(XAccessible xacc, String filePath, String printForm) {
		try {
			if ((xacc != null) && (printForm.equals("Line") || printForm.equals("Tree"))) {
				PropertiesFileWriter f = null;
				String indent = "";

				if (filePath != null) {
					f = new PropertiesFileWriter(filePath);
				}

				if (printForm.equals("Line")) {
					printAccessibleTree_LineForm(xacc, new StringBuffer(indent), f, "RootRole", "RootName");
				} else if (printForm.equals("Tree")) {
					printAccessibleTree_TreeForm(xacc, indent, f);
				}

				if (f != null) {
					f.close();
				}
			}
		} catch (IOException e) {
			Helper.log("Can't create/write to file Error");
		}
	}

	/**
	 * Print the XAccessible tree properties in line form.
	 *
	 * @param xacc tree
	 * @param buff
	 * @param f
	 * @param sRole node role
	 * @param sName node name
	 */
	public static void printAccessibleTree_LineForm(XAccessible xacc, StringBuffer buff, PropertiesFileWriter f, String sRole, String sName) {
		XAccessibleContext ac = xacc.getAccessibleContext();

		String temp = "<" + sRole + ": " + NameProvider.getRoleName(ac.getAccessibleRole());

		if (getImplName(ac).equals("ScAccessibleCell")) {
			String addition = ", CellContent: " + "\t" + ((XAccessibleText) UnoRuntime.queryInterface(XAccessibleText.class, ac)).getText();
			temp += (", " + sName + ": " + ac.getAccessibleName() + addition + " />");
		} else if ((ac.getAccessibleRole() == AccessibleRole.PARAGRAPH) && (ac.getAccessibleDescription().indexOf("Paragraph") > -1)) {
			String desc = ac.getAccessibleDescription();
			int indexof = desc.indexOf("Paragraph:");
			String addition = (desc.substring(indexof + "Paragraph:".length())).trim();
			temp += (", " + sName + ": Paragraph:" + ac.getAccessibleIndexInParent() + ", Content: " + addition + " " + " />");
		} else {
			temp += (", " + sName + ": " + ac.getAccessibleName() + " />");
		}

		if (f != null) {
			f.println(buff.toString() + temp);
		} else {
			Helper.log(buff.toString() + temp);
		}

		int k = ac.getAccessibleChildCount();

		if (k > m_LIMIT) {
			k = m_LIMIT;
		}

		for (int i = 0; i < k; i++) {
			try {
				printAccessibleTree_LineForm(ac.getAccessibleChild(i), buff.append(temp), f, "Role", "Name");
				buff = buff.delete((buff.length() - temp.length()), buff.length());
			} catch (com.sun.star.lang.IndexOutOfBoundsException e) {
				Helper.log("Couldn't get Child");
			}
		}

		if (ac.getAccessibleChildCount() > m_LIMIT) {
			k = ac.getAccessibleChildCount();

			int st = ac.getAccessibleChildCount() - 50;

			if (f != null) {
				f.println(" ...... [skipped] ......");
			} else {
				Helper.log(" ...... [skipped] ......");
			}

			for (int i = st; i < k; i++) {
				try {
					printAccessibleTree_LineForm(ac.getAccessibleChild(i), buff.append(temp), f, "Role", "Name");
					buff = buff.delete((buff.length() - temp.length()), buff.length());
				} catch (com.sun.star.lang.IndexOutOfBoundsException e) {
					Helper.log("Couldn't get Child");
				}
			}
		}
	}

	/**
	 * Print the XAccessible tree properties in tree form.
	 *
	 * @param xacc tree
	 * @param indent
	 * @param f
	 */
	public static void printAccessibleTree_TreeForm(XAccessible xacc, String indent, PropertiesFileWriter f) {
		XAccessibleContext ac = xacc.getAccessibleContext();
		String temp = indent + ac.getAccessibleRole() + ",";

		if (getImplName(ac).equals("ScAccessibleCell")) {
			String addition = ", ( CellContent: " + "\t" + ((XAccessibleText) UnoRuntime.queryInterface(XAccessibleText.class, ac)).getText() + ")";
			temp += (ac.getAccessibleName() + addition);
		} else if ((ac.getAccessibleRole() == AccessibleRole.PARAGRAPH) && (ac.getAccessibleDescription().indexOf("Paragraph") > -1)) {
			String desc = ac.getAccessibleDescription();
			int indexof = desc.indexOf("Paragraph:");
			String addition = (desc.substring(indexof + "Paragraph:".length())).trim();
			temp += (" Paragraph:" + ac.getAccessibleIndexInParent() + ", ( Content: " + addition + " )");
		} else {
			Point point = getObjPoint(ac);
			temp += (ac.getAccessibleName() + getImplName(ac) + " show :" + AccessibilityTools.checkState(ac, AccessibleStateType.SHOWING) + " visible :" + AccessibilityTools.checkState(ac, AccessibleStateType.VISIBLE) + " points : " + point.X + "  " + point.Y);
		}

		//temp +=  " ( Description : " + ac.getAccessibleDescription() + " )";
		if (f != null) {
			f.println(temp);
		} else {
			Helper.log(temp);
		}

		int k = ac.getAccessibleChildCount();

		if (k > m_LIMIT) {
			k = m_LIMIT;
		}

		for (int i = 0; i < k; i++) {
			try {
				printAccessibleTree_TreeForm(ac.getAccessibleChild(i), indent + "  ", f);
			} catch (com.sun.star.lang.IndexOutOfBoundsException e) {
				Helper.log("Couldn't get Child");
			}
		}

		if (ac.getAccessibleChildCount() > m_LIMIT) {
			k = ac.getAccessibleChildCount();

			int st = ac.getAccessibleChildCount() - 50;

			if (f != null) {
				f.println(" ...... [skipped] ......");
			} else {
				Helper.log(" ...... [skipped] ......");
			}

			for (int i = st; i < k; i++) {
				try {
					printAccessibleTree_TreeForm(ac.getAccessibleChild(i), indent + "  ", f);
				} catch (com.sun.star.lang.IndexOutOfBoundsException e) {
					Helper.log("Couldn't get Child");
				}
			}
		}
	}

	/**
	 * Get accessibility child context
	 *
	 * @param activeXWindow object path
	 * @param xWindows DOCUMENT ME!
	 * @param path DOCUMENT ME!
	 *
	 * @return accessibility child
	 */
	public static synchronized XAccessibleContext getXAccessibleContext(XWindow activeXWindow, XWindow[] xWindows, String[] path) {
		XAccessibleContext xcon = null;

		if (m_current_search_form.equals(SERCH_FORM_NAME)) {
			XAccessible access = getXAccessible(xWindows, path);

			if (access != null) {
				xcon = m_acces.getXAccessibleContext(access.getAccessibleContext(), path);
			}
		} else if (m_current_search_form.equals(SERCH_FORM_INDEX)) {
			xcon = m_acces.getXAccessibleContext_Index(activeXWindow, xWindows, path);
		}

		if (xcon != null) {
			Helper.log("END Gefundene ROLE = " + xcon.getAccessibleRole());
			Helper.log("END Gefundene NAME = " + xcon.getAccessibleName());
			Helper.log("***************************");
		} else {
			Helper.log("END Gefundene ROLE = NULL");
			Helper.log("END Gefundene NAME = NULL");
		}

		return xcon;
	}

	/**
	 * Searches in the Accessibility tree for the child identified by the path.
	 *
	 * @param xacc tree
	 * @param path child node path
	 *
	 * @return searches the whole tree according to the path to the bottom, if the bottom
	 *         is reached - return the last found child
	 */
	public static XAccessibleContext getXAccessibleContext(XAccessibleContext xacc, String[] path) {
		int leng = path.length;
		Vector vec = new Vector();
		XAccessibleContext ac = xacc;

		if (ac != null) {
			vec.add(ac);

			try {
				short role = -1;
				String name = "";

				for (int i = 0;(i < leng) && !vec.isEmpty(); i++) {
					String identify = path[i].trim();
					String[] idents = identify.split("#", 3);

					if (idents.length == 3) {
						String sRole = idents[0].trim();

						if (sRole.indexOf("{D}") > -1) {
							sRole = sRole.substring("{D}".length());
						}

						if (NameProvider.getRoleId(sRole) > -1) {
							role = (short) NameProvider.getRoleId(sRole);
							name = idents[1].trim();
							vec = m_acces.getAllXAccessibleContextsHelp(role, name, vec);
						} else {
							i = leng;
						}
					} else {
						i = leng;
					}

					if (!vec.isEmpty()) {
						ac = (XAccessibleContext) vec.get(0);
					}
				}
			} catch (java.lang.NumberFormatException e) {
				Helper.log("Is not in the correct number format ");
			}
		}

		return ac;
	}

	/**
	 * Searches in the Accessibility tree for the child identified by the path.
	 *
	 * @param activeXWindow tree
	 * @param xWindows child node path
	 * @param path DOCUMENT ME!
	 *
	 * @return searches the whole tree according to the path to the bottom, if the bottom
	 *         is reached - return the last found child
	 */
	public static XAccessibleContext getXAccessibleContext_Index(XWindow activeXWindow, XWindow[] xWindows, String[] path) {
		int leng = path.length;
		Vector vec = new Vector();
		int index = -1;
		XAccessibleContext ac = null;

		if (xWindows.length > 0) {
			PathProperties.putPath(path, 0);

			if (activeXWindow != null) {
				ac = getAccessibleObject(activeXWindow).getAccessibleContext();

				if ((ac != null) && (ac.getAccessibleRole() == PathProperties.getRole())) {
					Helper.log("activeName : " + ac.getAccessibleName());
					Helper.log("activeRole : " + ac.getAccessibleRole());
					vec.add(ac);
					ac = m_acces.getAllXAccessibleIndexContextsHelp(path, vec);
				} else {
					ac = null;
				}
			}

			if (ac == null) {
				for (int j = 0; j < xWindows.length; j++) {
					XWindow xWindow = xWindows[j];
					XAccessible xacces = getAccessibleObject(xWindow);

					if ((xacces != null) && (xacces.getAccessibleContext() != null)) {
						ac = xacces.getAccessibleContext();

						while (ac.getAccessibleIndexInParent() > -1) {
							ac = ac.getAccessibleParent().getAccessibleContext();
						}

						Helper.log("*****************************************");
						Helper.log("search index : " + PathProperties.getIndex());
						Helper.log("search name : " + PathProperties.getName());
						Helper.log("search role : " + PathProperties.getRole());
						Helper.log("ac role : " + ac.getAccessibleRole());
						Helper.log("ac name : " + ac.getAccessibleName());
						Helper.log("ac index : " + ac.getAccessibleIndexInParent());
						Helper.log("*****************************************");

						if ((ac != null) && (ac.getAccessibleRole() == PathProperties.getRole())) {
							vec.add(ac);
						}
					}
				}

				if (!vec.isEmpty()) {
					ac = m_acces.getAllXAccessibleIndexContextsHelp(path, vec);
				}
			}
		}

		return ac;
	}

	/**
	 * Get accessibility child
	 *
	 * @param xWindows object path
	 * @param path DOCUMENT ME!
	 *
	 * @return accessibility child
	 */
	private static XAccessible getXAccessible(XWindow[] xWindows, String[] path) {
		String accessName = "";
		short role = -1;

		if (path.length > 0) {
			String[] idents = (path[0].trim()).split("#", 3);

			if (idents.length == 3) {
				String sRole = idents[0].trim();

				if (sRole.indexOf("{D}") > -1) {
					sRole = sRole.substring("{D}".length());
				}

				role = (short) NameProvider.getRoleId(sRole);
				accessName = idents[1].trim();
			}
		}

		return getXAccessible(xWindows, accessName, role);
	}

	/**
	 * Get accessibility child
	 *
	 * @param xWindows name
	 * @param accessName role
	 * @param role DOCUMENT ME!
	 *
	 * @return accessibility child
	 */
	public static XAccessible getXAccessible(XWindow[] xWindows, String accessName, short role) {
		XAccessible access = null;
		XAccessible[] xAcess = getXAccessibles(xWindows);
		int leng = xAcess.length;

		for (int i = 0; i < leng; i++) {
			if (xAcess[i] == null) {
				continue;
			}

			XAccessibleContext xcon = xAcess[i].getAccessibleContext();
			String t1 = xcon.getAccessibleName().trim();
			String t2 = accessName.trim();

			if (t1.equals(t2) && (xcon.getAccessibleRole() == role)) {
				access = xAcess[i];
				i = leng;
			}
		}

		return access;
	}

	/**
	 * Get all accessibility childs of staroffice
	 *
	 * @param xWindows DOCUMENT ME!
	 *
	 * @return childs
	 */
	public static XAccessible[] getXAccessibles(XWindow[] xWindows) {
		XAccessible[] xAcess = null;

		if ((xWindows != null) && (xWindows.length > 0)) {
			xAcess = new XAccessible[xWindows.length];

			for (int i = 0; i < xWindows.length; i++) {
				XWindow xWindow = xWindows[i];

				XAccessible xRootTemp = AccessibilityTools.getAccessibleObject(xWindow);

				if (xRootTemp != null) {
					XAccessibleContext ac = xRootTemp.getAccessibleContext();

					if (ac == null) {
						continue;
					}

					while (ac.getAccessibleIndexInParent() > -1) {
						xRootTemp = ac.getAccessibleParent();
						ac = xRootTemp.getAccessibleContext();
					}

					xAcess[i] = xRootTemp;
				}
			}
		}

		return xAcess;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param xWindows DOCUMENT ME!
	 * @param name DOCUMENT ME!
	 * @param role DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public static int getXWindowIndex(XWindow[] xWindows, String name, short role) {
		int index = -1;
		Debug.printXWindows(xWindows);

		if (xWindows != null) {
			for (int i = 0; i < xWindows.length; i++) {
				XWindow xWindow = xWindows[i];

				XAccessible xRootTemp = AccessibilityTools.getAccessibleObject(xWindow);

				if (xRootTemp != null) {
					XAccessibleContext ac = xRootTemp.getAccessibleContext();

					if (ac == null) {
						continue;
					}

					while (ac.getAccessibleIndexInParent() > -1) {
						xRootTemp = ac.getAccessibleParent();
						ac = xRootTemp.getAccessibleContext();
					}

					if ((ac.getAccessibleRole() == role) && ac.getAccessibleName().equals(name)) {
						index = i;

						break;
					}
				}
			}
		}

		return index;
	}

	//*******************************************************************
	//                                                                  *
	//                      Privates Methods                            *
	//                                                                  *
	//*******************************************************************

	/**
	 * For a spreedsheet document get the XAccessible cell child for the arguments. the
	 * search is perfomed with the help of BinarySearch
	 *
	 * @param ac tree
	 * @param childName name
	 * @param minIndex index
	 * @param maxIndex index
	 *
	 * @return XAccessible child
	 *
	 * @throws com.sun.star.lang.IndexOutOfBoundsException
	 */
	private XAccessibleContext getXAccessibleCellContext(XAccessibleContext ac, String childName, int minIndex, int maxIndex) throws com.sun.star.lang.IndexOutOfBoundsException {
		XAccessibleContext rAc = null;
		int ref = -1;

		if (minIndex == 0) {
			ref = maxIndex / 2;
		} else {
			ref = minIndex + ((maxIndex - minIndex) / 2);
		}

		XAccessibleContext refAc = ac.getAccessibleChild(ref).getAccessibleContext();
		int com = compare(childName, refAc.getAccessibleName());

		if (com == 0) {
			rAc = refAc;
		} else if ((com < 0) && (ref != maxIndex)) {
			rAc = getXAccessibleCellContext(ac, childName, minIndex, ref);
		} else if ((com > 0) && (ref != minIndex)) {
			rAc = getXAccessibleCellContext(ac, childName, ref, maxIndex);
		}

		return rAc;
	}

	/**
	 * compares the names.
	 *
	 * @param name XAccessible Object name
	 * @param refName XAccessible Object name
	 *
	 * @return zero if the names are identical, otherwise "-1" if "name"'s length is less
	 *         than "refName"'s length or "1" in the other case.
	 */
	private int compare(String name, String refName) {
		int result = compareNumber(getNumber(name), getNumber(refName));

		if (result == 0) {
			int leng = name.length();
			int lengref = refName.length();

			if (leng == lengref) {
				result = name.compareTo(refName);
			} else if (leng < lengref) {
				result = -1;
			} else {
				result = 1;
			}
		}

		return result;
	}

	/**
	 * Compares this String object to another object.
	 *
	 * @param number number
	 * @param refNumber refNumber
	 *
	 * @return the string will be converted to Integer and compared
	 */
	private int compareNumber(String number, String refNumber) {
		Integer num = Integer.decode(number);
		Integer refNum = Integer.decode(refNumber);

		return (num.compareTo(refNum));
	}

	/**
	 * Get the number for the String. Example : Cell name is: AB100 --> result:100
	 *
	 * @param name name
	 *
	 * @return cell number
	 */
	private String getNumber(String name) {
		String res = "";

		for (int i = (name.length() - 1); i > -1; i--) {
			char c = name.charAt(i);

			if (Character.isDigit(c)) {
				res = c + res;
			} else {
				i = -1;
			}
		}

		return res;
	}

	/**
	 * Get XAccessible child object for the params.
	 *
	 * @param xacc tree
	 * @param role role
	 * @param name name
	 *
	 * @return find child for the role and name in tree
	 */
	private XAccessibleContext findXAccessibleContextHelp(XAccessible xacc, short role, String name) {
		return findXAccessibleContextHelp(xacc.getAccessibleContext(), role, name);
	}

	/**
	 * Get XAccessible child object for the params.
	 *
	 * @param ac tree
	 * @param role role
	 * @param name name
	 *
	 * @return find child for the role and name in tree
	 */
	private XAccessibleContext findXAccessibleContextHelp(XAccessibleContext ac, short role, String name) {
		Vector vec = new Vector();
		XAccessibleContext ac1 = findXAccessibleContext(ac, role, name, 0, vec);

		if (ac1 == null) {
			while (!vec.isEmpty()) {
				Child child = (Child) vec.elementAt(0);
				ac1 = findXAccessibleContext(child.getXAccessibleContext(), role, name, child.getIndex(), vec);

				if (ac1 != null) {
					break;
				} else {
					vec.removeElementAt(0);
				}
			}
		}

		return ac1;
	}

	/**
	 * Get XAccessible child object for the params.
	 *
	 * @param ac tree
	 * @param role role
	 * @param name name
	 * @param count search child count for one node
	 * @param vec container
	 *
	 * @return find child for the role and name in tree
	 */
	private XAccessibleContext findXAccessibleContext(XAccessibleContext ac, short role, String name, int count, Vector vec) {
		if ((ac.getAccessibleRole() == role) && ac.getAccessibleName().equals(name)) {
			return ac;
		} else {
			try {
				XAccessibleContext ac1 = null;
				int k = ac.getAccessibleChildCount();

				if ((k > m_SHEET_LIMIT) && (role == AccessibleRole.TABLE_CELL)) {
					ac1 = m_acces.getXAccessibleCellContext(ac, name, 0, ac.getAccessibleChildCount());

					return ac1;
				} else if ((k > m_SHEET_LIMIT) && (role != AccessibleRole.TABLE_CELL)) {
					return null;
				} else {
					if (k > m_LIMIT) {
						k = m_LIMIT;
					}

					for (int i = count; i < k; i++) {
						ac1 = findXAccessibleContext(ac.getAccessibleChild(i).getAccessibleContext(), role, name, 0, vec);

						if (ac1 != null) {
							Helper.log("Find Role : " + ac1.getAccessibleRole());
							Helper.log("Find Name : " + ac1.getAccessibleName());
							Helper.log("Parent Child Count : " + ac1.getAccessibleParent().getAccessibleContext().getAccessibleChildCount());
							Helper.log("Find IndexinParent : " + ac1.getAccessibleIndexInParent());

							return ac1;
						}

						if ((k > (count + m_MAX_COUNT)) && (i == (count + m_MAX_COUNT))) {
							Child child = Child.createNewChild(ac, i);
							vec.add(child);

							return null;
						}
					}
				}
			} catch (com.sun.star.lang.IndexOutOfBoundsException e) {
				Helper.log("Couldn't get Child");
			}
		}

		return null;
	}

	/**
	 * Search all properties for the XAccessible tree and insert the properties into the
	 * vector object
	 *
	 * @param xacc tree
	 * @param properties container
	 * @param indent
	 */
	private void setAllAccessibleProperties(XAccessible xacc, Vector properties, String indent) {
		XAccessibleContext ac = xacc.getAccessibleContext();
		properties.add(indent + accessibleToString(ac));

		int k = ac.getAccessibleChildCount();

		for (int i = 0; i < k; i++) {
			try {
				setAllAccessibleProperties(ac.getAccessibleChild(i), properties, indent + "  ");
			} catch (com.sun.star.lang.IndexOutOfBoundsException e) {
				Helper.log("Couldn't get Child");
			}
		}
	}

	/**
	 * Returns a String object representing the specified XAccessible object.
	 *
	 * @param AC object
	 *
	 * @return XAccessible object representing
	 */
	private String accessibleToString(XAccessibleContext AC) {
		String result = "";
		XAccessibleContext xAC = AC;

		if (xAC != null) {
			result = "Role : " + xAC.getAccessibleRole() + ", Name : " + xAC.getAccessibleName() + "(" + xAC.getAccessibleDescription() + "), Implementation name : " + getImplName(xAC);
		}

		return result;
	}
}
