/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: intnwnt.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:26:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVWIN_H
#include <svwin.h>
#endif

#ifndef _INTNTAB_HXX
#include <intntab.hxx>
#endif

static LanguageType eImplSystemLanguage = LANGUAGE_DONTKNOW;

// =======================================================================

void SetSystemLanguage( LanguageType eLang )
{
    eImplSystemLanguage = eLang;
}

// =======================================================================

static LanguageType GetSVLang( ULONG nWinLangId )
{
    LANGID  nLangId         = (LANGID)nWinLangId;
    USHORT  nPrimaryLangId  = PRIMARYLANGID( nLangId );
    USHORT  nSubLangId      = SUBLANGID( nLangId );

    // No Translation, we work with the original MS code without the SORT_ID.
    // So we can get never LANG-ID's from MS, which are currently not
    // defined from us
    return (LanguageType)MAKELANGID( nPrimaryLangId, nSubLangId );
}

// =======================================================================

USHORT ImplGetSystemLanguageCount()
{
    return 0;
}

// -----------------------------------------------------------------------

LanguageType GetSystemLanguage( USHORT nIndex )
{
    // Soll die im System eingestellte Sprache ermittelt werden
    if ( nIndex == INTERNATIONAL_SYSTEM_DEFAULT )
    {
        if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
        {
            LANGID nLangId;

            nLangId = GetUserDefaultLangID();
            eImplSystemLanguage = GetSVLang( nLangId );

            if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
            {
                nLangId = GetSystemDefaultLangID();
                eImplSystemLanguage = GetSVLang( nLangId );
            }
        }

        return eImplSystemLanguage;
    }
    else
        return LANGUAGE_DONTKNOW;
}

// -----------------------------------------------------------------------

LanguageType GetSystemUILanguage( USHORT nIndex )
{
    return GetSystemLanguage( nIndex );
}

// =======================================================================

void ImplUpdateSystemLanguage( LanguageType, LanguageTable* )
{
}

// =======================================================================

USHORT ImplGetSystemFormatCount()
{
    return 0;
}

// -----------------------------------------------------------------------

LanguageType GetSystemFormatLanguage( USHORT nIndex )
{
    return GetSystemLanguage( nIndex );
}

// -----------------------------------------------------------------------

void ImplUpdateSystemFormat( LanguageType, FormatTable* )
{
}
