/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: intntab.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:44:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _INTNTAB_HXX
#define _INTNTAB_HXX

#ifndef _TOOLS_H
#include <tools.h>
#endif

#ifndef _INTN_HXX
#include <intn.hxx>
#endif

// ------------------------------------------------
// - Interne Methoden fuer INTN.CXX und INTN2.CXX -
// ------------------------------------------------

void ImplCopyIntnData( International* pIntn );
void ImplDeleteIntnData( InternationalData* pData );

// ----------------------------
// - ImplRegisterLanguageData -
// ----------------------------

struct ImplRegisterLanguageData
{
	ImplRegisterLanguageData*	pNext;			// Pointer auf naechsten Eintrag
	LanguageTable*				pTable; 		// Pointer auf Language-Tabelle
	LanguageType				eLanguage;		// Language
	BOOL						bStandard;		// Standard-Tabelle
	BOOL						bSystem;		// System-Tabelle
};

ImplRegisterLanguageData* ImplGetFirstLanguageData();
LanguageTable* ImplGetLanguageTable( LanguageType eLanguage );

// --------------------------
// - ImplRegisterFormatData -
// --------------------------

struct ImplRegisterFormatData
{
	ImplRegisterFormatData* 	pNext;			// Pointer auf naechsten Eintrag
	FormatTable*				pTable; 		// Pointer auf Format-Tabelle
	LanguageType				eLanguage;		// Sprach-Region
	BOOL						bStandard;		// Standard-Tabelle
	BOOL						bSystem;		// System-Tabelle
};

ImplRegisterFormatData* ImplGetFirstFormatData();
FormatTable* ImplGetFormatTable( LanguageType eLanguage );

// -------------------------------------
// - Interne Methoden fuer TOOLSIN.CXX -
// -------------------------------------

// in INTN.CXX implementiert
void ImplDeleteIntnListData();

// ---------------------
// - Language-Tabellen -
// ---------------------

#define STD_LANGUAGE	33

USHORT ImplGetSystemLanguageCount();
void   ImplUpdateSystemLanguage( LanguageType eLanguage, LanguageTable* pTable );
void   ImplUpdateStandardLanguage( LanguageType eLanguage, LanguageTable* pTable );

// -------------------
// - Format-Tabellen -
// -------------------

#define STD_FORMAT		51

USHORT ImplGetSystemFormatCount();
void   ImplUpdateSystemFormat( LanguageType eLanguage, FormatTable* pTable );
void   ImplUpdateStandardFormat( LanguageType eLanguage, FormatTable* pTable );

// ---------------------
// - Language-Tabellen -
// ---------------------

// CharSet bei Unicode ueberfluessig
StringCompare ImplStdLanguageCompare( const UniString& rStr1, const UniString& rStr2,
									  USHORT nFlags, LanguageType eLang );

// Compare-Methoden (Sprachabhaengig)
StringCompare ImplGermanLanguageCompare( const UniString& rStr1, const UniString& rStr2,
										 USHORT nFlags, LanguageType eLang );
StringCompare ImplFrenchLanguageCompare( const UniString& rStr1, const UniString& rStr2,
										 USHORT nFlags, LanguageType eLang );
StringCompare ImplSpanishLanguageCompare( const UniString& rStr1, const UniString& rStr2,
										  USHORT nFlags, LanguageType eLang );

#endif // _INTNTAB_HXX
