/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: swstbctl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:30:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include "hintids.hxx"

#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif

#include <utlui.hrc>
#include "errhdl.hxx"
#include "wrtsh.hxx"
#include "cmdid.h"
#include "swstbctl.hxx"

#define C2S(cChar) UniString::CreateFromAscii(cChar)

// STATIC DATA -----------------------------------------------------------

SFX_IMPL_STATUSBAR_CONTROL(SwHyperlinkControl, SfxBoolItem);

// class SwHyperlinkControl ------------------------------------------------

SwHyperlinkControl::SwHyperlinkControl( USHORT nSlotId,
                                        USHORT nId,
									    StatusBar& rStb ) :
	SfxStatusBarControl( nSlotId, nId, rStb ),
	bState( TRUE )
{
}

// -----------------------------------------------------------------------

void SwHyperlinkControl::StateChanged( USHORT nSID, SfxItemState eState,
									 const SfxPoolItem* pState )
{
	if ( SFX_ITEM_AVAILABLE != eState )
		GetStatusBar().SetItemText( GetId(), aEmptyStr );
	else
	{
		DBG_ASSERT( pState->ISA( SfxBoolItem ), "invalid item type" );
		SfxBoolItem* pItem = (SfxBoolItem*)pState;
		bState = pItem->GetValue();
		DrawItemText_Impl();
	}
}

// -----------------------------------------------------------------------

void SwHyperlinkControl::Paint( const UserDrawEvent& rUsrEvt )
{
	DrawItemText_Impl();
}

// -----------------------------------------------------------------------


void SwHyperlinkControl::DrawItemText_Impl()
{
    USHORT nResId = bState ? STR_HYPERCTRL_HYP : STR_HYPERCTRL_SEL;
    GetStatusBar().SetItemText( GetId(), SW_RESSTR(nResId) );
}

// -----------------------------------------------------------------------


void SwHyperlinkControl::Click()
{
	SfxBoolItem aState( GetSlotId(), !bState );
	SfxViewFrame::Current()->GetDispatcher()->Execute( GetSlotId(), SFX_CALLMODE_RECORD, &aState, 0L );
}



