package org.netbeans.modules.openoffice;


import java.awt.Component;

import javax.swing.event.ChangeListener;
import javax.swing.JPanel;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.MessageFormat;
import java.util.Properties;

import org.netbeans.modules.openoffice.InstallationPanel;

import org.openide.modules.ModuleInstall;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.WizardDescriptor;


public class OOIDLInstaller extends ModuleInstall {
    
    public void installed() {
        OOIDLGlobalSettings oGlobalSettings = OOIDLGlobalSettings.getDefault();
        String[] stringInstallationPath = getInstallationPaths();
        setSDKDirectory( stringInstallationPath[ 0 ] );
        setOfficeDirectory( stringInstallationPath[ 1 ] );
        oGlobalSettings.setSDKDirectory( getSDKDirectory() );
        oGlobalSettings.setOfficeDirectory( getOfficeDirectory() );
        OOTools.installFiles( getSDKDirectory(), getOfficeDirectory() );
        restored();
    }
    
    public void restored() {
    }
    
    public void uninstalled() {
        OOTools.uninstallFiles( getSDKDirectory(), getOfficeDirectory() );
    }
    
    public String getSDKDirectory(){
        return (String)getProperty(
        NbBundle.getMessage( OOIDLInstaller.class,
        "PROP_sdk_directory") );
    }
    
    public void readExternal( ObjectInput objectinput )
    throws IOException, ClassNotFoundException {
        super.readExternal( objectinput );
        setSDKDirectory( ( String ) objectinput.readObject() );
        setOfficeDirectory( ( String ) objectinput.readObject() );
    }
    
    public void setSDKDirectory( String stringSDKDirectory ) {
        putProperty( NbBundle.getMessage( OOIDLInstaller.class,
        "PROP_sdk_directory"), stringSDKDirectory, true );
    }
    
    public void writeExternal(ObjectOutput objectoutput)
    throws IOException {
        super.writeExternal( objectoutput );
        objectoutput.writeObject( getSDKDirectory() );
        objectoutput.writeObject( getOfficeDirectory() );
    }
    
    private String[] getInstallationPaths() {
        //        final JPanel panel = new JPanel(new BorderLayout());
        //        JPanel panelnorth = new JPanel();
        //        panel.add("North", panelnorth);
        //        JLabel lab = new JLabel("Installation directory of the OpenOffice.org SDK");
        //        panelnorth.add(lab);
        //        final JTextField directoryName = new JTextField(30);
        //        panelnorth.add(directoryName);
        //        String txt = "The OpenOffice.org software is a complete,feature-rich office productivity product, that provides in combination with the OpenOffice.org Developer Kit (ODK) all the essential tools for " +
        //                     " building and deploying custom solutions to build on, or integrate with, the OpenOffice.org suite of products.\n\n"
        //                   + "The ODK is a set of tools, libraries, jar files, header files and idl files which are necessary to develop components for the OpenOffice.org using the OpenOffice API and the OpenOffice.org component "
        //                   + "technology UNO (Universal Network Objects).\n\nFurther on, the ODK is the basic stuff for external developers to develop components in any language for which a binding exists. Currently there are language bindings for OpenOffice.org Basic, "
        //                   + "Java and different C++ compilers on different platforms for OpenOffice.org without using OpenOffice.org build environment, thus covering the two most commonly used programming languages. There will be "
        //                   + "no limit for office automation in heterogeneous environments. Currently supported platforms of the ODK are Linux, Solaris (sparc) and Windows.\n\n"
        //                   + "In order to get to know the OpenOffice.org reference manual and some examples (C++, Java, and Basic), which demonstrate the UNO technology and the use of the OpenOffice.org API, you can visit "
        //                   +" http://api.openoffice.org/.";
        //        JTextArea comment = new JTextArea(txt, 3, 40);
        //        comment.setEditable(false);
        //        comment.setLineWrap(true);
        //        comment.setWrapStyleWord(true);
        //        panel.add("Center", comment);
        //        JButton browse = new JButton("Browse");
        //        //browse.setMnemonic(bundle.getString("Mnemonic_Browse").charAt(0));
        //        browse.addActionListener(new ActionListener() {
        //
        //            public void actionPerformed(ActionEvent e)
        //            {
        //                JFileChooser fc = new JFileChooser();
        //                fc.setFileSelectionMode(1);
        //                Component parent = ((JButton)e.getSource()).getParent();
        //                fc.setDialogTitle("Select the OpenOffice.org SDK directory");
        //                if(fc.showDialog(parent, "Select") == 0)
        //                {
        //                    File selectedFile = fc.getSelectedFile();
        //                    if(selectedFile != null)
        //                        directoryName.setText(selectedFile.getPath());
        //                }
        //            }
        //
        //        });
        //        panelnorth.add(browse);
        //
        //        // Begin
        //        JLabel jlabelOfficeDirectory = new JLabel(
        //        "Installation directory of the OpenOffice.org");
        //        panelnorth.add( "North", jlabelOfficeDirectory );
        //        final JTextField jtextfieldOfficeDirectory = new JTextField(30);
        //        panelnorth.add( jtextfieldOfficeDirectory );
        //
        //        JButton jbuttonOfficeDirectory = new JButton("Browse");
        //        jbuttonOfficeDirectory.addActionListener(
        //        new ActionListener() {
        //
        //            public void actionPerformed( ActionEvent actionevent ) {
        //                JFileChooser jfilechooser = new JFileChooser();
        //                jfilechooser.setFileSelectionMode( 1 );
        //                Component componentParent =
        //                ( ( JButton ) actionevent.getSource() ).getParent();
        //                jfilechooser.setDialogTitle(
        //                "Select the OpenOffice.org installation directory" );
        //                if ( jfilechooser.showDialog(
        //                componentParent, "Select" ) == 0 ) {
        //                    File file = jfilechooser.getSelectedFile();
        //                    if ( file != null )
        //                        jtextfieldOfficeDirectory.setText( file.getPath() );
        //                }
        //            }
        //
        //        }
        //        );
        //        panelnorth.add( jbuttonOfficeDirectory );
        //
        //        // End
        
        final JPanel panel = new InstallationPanel();
        
        String[] stringInstallationPath = new String[ 2 ];
        boolean incorrect = true;
        while ( incorrect ) {
            org.openide.WizardDescriptor.Iterator iter = new org.openide.WizardDescriptor.Iterator() {
                
                public void addChangeListener(ChangeListener changelistener) {
                }
                
                public org.openide.WizardDescriptor.Panel current() {
                    org.openide.WizardDescriptor.Panel pane = new org.openide.WizardDescriptor.Panel() {
                        
                        public void addChangeListener(ChangeListener changelistener) {
                        }
                        
                        public Component getComponent() {
                            panel.putClientProperty("WizardPanel_contentData", new String[] {
                                "Select OpenOffice.org SDK directory"
                            });
                            panel.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
                            return panel;
                        }
                        
                        public HelpCtx getHelp() {
                            return null;
                        }
                        
                        public boolean isValid() {
                            return true;
                        }
                        
                        public void readSettings(Object obj) {
                        }
                        
                        public void removeChangeListener(ChangeListener changelistener) {
                        }
                        
                        public void storeSettings(Object obj) {
                        }
                        
                    };
                    return pane;
                }
                
                public boolean hasNext() {
                    return false;
                }
                
                public boolean hasPrevious() {
                    return false;
                }
                
                public String name() {
                    return "BundleString5";
                }
                
                public void nextPanel() {
                }
                
                public void previousPanel() {
                }
                
                public void removeChangeListener(ChangeListener changelistener) {
                }
                
                
            };
            WizardDescriptor dd = new WizardDescriptor(iter);
            dd.putProperty("WizardPanel_autoWizardStyle", new Boolean(true));
            dd.putProperty("WizardPanel_contentNumbered", new Boolean(true));
            dd.putProperty("WizardPanel_contentDisplayed", new Boolean(true));
            MessageFormat format = new MessageFormat(
            "Choose the directory where the OpenOffice.org SDK is installed.");
            dd.setTitle("OpenOffice.org SDK Setup");
            dd.setTitleFormat(format);
            TopManager.getDefault().createDialog(dd).show();
            if(dd.getValue() == NotifyDescriptor.OK_OPTION) {
                boolean dirty = true;
                
                //                directory = directoryName.getText();
                stringInstallationPath[ 0 ] =
                ( ( InstallationPanel ) panel ).getSDKDirectory();
                File file = new File( stringInstallationPath[ 0 ] );
                if( !file.exists() ) {
                    TopManager.getDefault().notify(
                    new org.openide.NotifyDescriptor.Message(
                    "You have not choosen the install directory of the SDK."));
                }
                
                stringInstallationPath[ 1 ] =
                ( ( InstallationPanel ) panel ).getOfficeDirectory();
                file = new File( stringInstallationPath[ 1 ] );
                if( file.exists() ) {
                    return stringInstallationPath;
                }
                else {
                    TopManager.getDefault().notify(
                    new org.openide.NotifyDescriptor.Message(
                    "You have not choosen the install directory of the OpenOffice.org."));
                }
            }
            else {
                return null;
            }
        }
        
        
        return null;
        
    }
    
    public final String getOfficeDirectory() {
        return ( String ) getProperty( NbBundle.getMessage(
        OOIDLGlobalSettings.class,
        "PROP_office_directory") );
    }
    
    public final void setOfficeDirectory( final String stringOfficeDirectory ) {
        putProperty( NbBundle.getMessage( OOIDLGlobalSettings.class,
        "PROP_office_directory"), stringOfficeDirectory, true );
    }
    
}
