/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SchItemPool.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:24:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef SCH_ITEMPOOL_HXX
#define SCH_ITEMPOOL_HXX

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif
#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif

namespace chart
{
namespace wrapper
{

class SchItemPool: public SfxItemPool
{
private:
	SfxPoolItem**	ppPoolDefaults;
	SfxItemInfo*    pItemInfos;

public:
	SchItemPool();
	SchItemPool(const SchItemPool& rPool);
	virtual ~SchItemPool();

	virtual SfxItemPool* Clone() const;
	SfxMapUnit GetMetric( USHORT nWhich ) const;

    /// creates a pure chart item pool
    static SfxItemPool* CreateSchItemPool();
};

/** global function to get a singleton SchItemPool
 */
SchItemPool * GetSchItemPool();

} //  namespace wrapper
} //  namespace chart

#endif
// SCH_ITEMPOOL_HXX
