/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_fldref.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:06:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #include "swtypes.hxx"
//STRIP001 
//STRIP001 #ifndef _SWVIEW_HXX //autogen
//STRIP001 #include <view.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _BOOKMRK_HXX //autogen
//STRIP001 #include <bookmrk.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _EXPFLD_HXX //autogen
//STRIP001 #include <expfld.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWMODULE_HXX
//STRIP001 #include <swmodule.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _FLDREF_HXX
//STRIP001 #include <fldref.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _REFFLD_HXX
//STRIP001 #include <reffld.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _WRTSH_HXX
//STRIP001 #include <wrtsh.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _FLDUI_HRC
//STRIP001 #include <fldui.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _FLDTDLG_HRC
//STRIP001 #include <fldtdlg.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _GLOBALS_HRC
//STRIP001 #include <globals.hrc>
//STRIP001 #endif
//STRIP001 
//STRIP001 #define REFFLDFLAG			0x4000
//STRIP001 #define REFFLDFLAG_BOOKMARK	0x4800
//STRIP001 #define REFFLDFLAG_FOOTNOTE	0x5000
//STRIP001 #define REFFLDFLAG_ENDNOTE	0x6000
//STRIP001 
//STRIP001 USHORT	nFldDlgFmtSel		= 0;
//STRIP001 
//STRIP001 #define USER_DATA_VERSION_1 "1"
//STRIP001 #define USER_DATA_VERSION USER_DATA_VERSION_1
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SwFldRefPage::SwFldRefPage(Window* pParent, const SfxItemSet& rCoreSet ) :
//STRIP001 	SwFldPage( pParent, SW_RES( TP_FLD_REF ), rCoreSet ),
//STRIP001 
//STRIP001 	aTypeFT			(this, SW_RES(FT_REFTYPE)),
//STRIP001 	aTypeLB			(this, SW_RES(LB_REFTYPE)),
//STRIP001 	aSelectionFT	(this, SW_RES(FT_REFSELECTION)),
//STRIP001 	aSelectionLB	(this, SW_RES(LB_REFSELECTION)),
//STRIP001 	aFormatFT		(this, SW_RES(FT_REFFORMAT)),
//STRIP001 	aFormatLB		(this, SW_RES(LB_REFFORMAT)),
//STRIP001 	aNameFT			(this, SW_RES(FT_REFNAME)),
//STRIP001 	aNameED			(this, SW_RES(ED_REFNAME)),
//STRIP001 	aValueFT		(this, SW_RES(FT_REFVALUE)),
//STRIP001 	aValueED		(this, SW_RES(ED_REFVALUE)),
//STRIP001 
//STRIP001 	sBookmarkTxt	(SW_RES(STR_REFBOOKMARK)),
//STRIP001 	sFootnoteTxt	(SW_RES(STR_REFFOOTNOTE)),
//STRIP001 	sEndnoteTxt		(SW_RES(STR_REFENDNOTE))
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aNameED.SetModifyHdl(LINK(this, SwFldRefPage, ModifyHdl));
//STRIP001 
//STRIP001 //	SwWrtShell* pSh = (SwWrtShell*)ViewShell::GetCurrShell();
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SwFldRefPage::~SwFldRefPage()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwFldRefPage::Reset(const SfxItemSet& )
//STRIP001 {
//STRIP001 	if (!IsFldEdit())
//STRIP001 		SavePos(&aTypeLB);
//STRIP001 	SetSelectionSel(LISTBOX_ENTRY_NOTFOUND);
//STRIP001 	SetTypeSel(LISTBOX_ENTRY_NOTFOUND);
//STRIP001 	Init();	// Allgemeine initialisierung
//STRIP001 
//STRIP001 	// TypeListBox initialisieren
//STRIP001 	aTypeLB.SetUpdateMode(FALSE);
//STRIP001 	aTypeLB.Clear();
//STRIP001 
//STRIP001 	// Typ-Listbox fuellen
//STRIP001 
//STRIP001 	// mit den Sequence-Typen auffuellen
//STRIP001 	SwView *pView = ::GetActiveView();
//STRIP001 	ASSERT(pView, View fehlt);
//STRIP001 	SwWrtShell &rSh = pView->GetWrtShell();
//STRIP001 	USHORT nPos;
//STRIP001 
//STRIP001 	USHORT nFldTypeCnt = rSh.GetFldTypeCount(RES_SETEXPFLD);
//STRIP001 
//STRIP001 	for (USHORT n = 0; n < nFldTypeCnt; ++n)
//STRIP001 	{
//STRIP001 		SwSetExpFieldType* pType = (SwSetExpFieldType*)rSh.GetFldType(n, RES_SETEXPFLD);
//STRIP001 
//STRIP001 		if ((GSE_SEQ & pType->GetType()) && pType->GetDepends() && rSh.IsUsed(*pType))
//STRIP001 		{
//STRIP001 			nPos = aTypeLB.InsertEntry(pType->GetName());
//STRIP001 			aTypeLB.SetEntryData(nPos, (void*)(REFFLDFLAG | n));
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Textmarken - jetzt immer (wegen Globaldokumenten)
//STRIP001 	nFldTypeCnt = rSh.GetBookmarkCnt(TRUE);
//STRIP001 	nPos = aTypeLB.InsertEntry(sBookmarkTxt);
//STRIP001 	aTypeLB.SetEntryData(nPos, (void*)REFFLDFLAG_BOOKMARK);
//STRIP001 
//STRIP001 	// Fussnoten:
//STRIP001 	if( rSh.HasFtns() )
//STRIP001 	{
//STRIP001 		nPos = aTypeLB.InsertEntry(sFootnoteTxt);
//STRIP001 		aTypeLB.SetEntryData(nPos, (void*)REFFLDFLAG_FOOTNOTE);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Endnoten:
//STRIP001 	if( rSh.HasFtns(TRUE) )
//STRIP001 	{
//STRIP001 		nPos = aTypeLB.InsertEntry(sEndnoteTxt);
//STRIP001 		aTypeLB.SetEntryData(nPos, (void*)REFFLDFLAG_ENDNOTE);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Referenz setzen / einfuegen
//STRIP001 	const SwFldGroupRgn& rRg = GetFldMgr().GetGroupRange(IsFldDlgHtmlMode(), GetGroup());
//STRIP001 
//STRIP001 	for (short i = rRg.nStart; i < rRg.nEnd; ++i)
//STRIP001 	{
//STRIP001 		const USHORT nTypeId = GetFldMgr().GetTypeId(i);
//STRIP001 
//STRIP001 		if (!IsFldEdit() || nTypeId != TYP_SETREFFLD)
//STRIP001 		{
//STRIP001 			nPos = aTypeLB.InsertEntry(GetFldMgr().GetTypeStr(i), i - rRg.nStart);
//STRIP001 			aTypeLB.SetEntryData(nPos, (void*)nTypeId);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// alte Pos selektieren
//STRIP001 	if (!IsFldEdit())
//STRIP001 		RestorePos(&aTypeLB);
//STRIP001 
//STRIP001 	aTypeLB.SetUpdateMode(TRUE);
//STRIP001 	aTypeLB.SetDoubleClickHdl		(LINK(this, SwFldRefPage, InsertHdl));
//STRIP001 	aTypeLB.SetSelectHdl			(LINK(this, SwFldRefPage, TypeHdl));
//STRIP001 	aSelectionLB.SetSelectHdl		(LINK(this, SwFldRefPage, SubTypeHdl));
//STRIP001 	aSelectionLB.SetDoubleClickHdl	(LINK(this, SwFldRefPage, InsertHdl));
//STRIP001 	aFormatLB.SetDoubleClickHdl		(LINK(this, SwFldRefPage, InsertHdl));
//STRIP001 
//STRIP001 	nFldDlgFmtSel = 0;
//STRIP001 
//STRIP001 	if( !IsRefresh() )
//STRIP001 	{
//STRIP001 		String sUserData = GetUserData();
//STRIP001 		if(!IsRefresh() && sUserData.GetToken(0, ';').
//STRIP001 								EqualsIgnoreCaseAscii(USER_DATA_VERSION_1))
//STRIP001 		{
//STRIP001 			String sVal = sUserData.GetToken(1, ';');
//STRIP001 			USHORT nVal = sVal.ToInt32();
//STRIP001 			if(nVal != USHRT_MAX)
//STRIP001 			{
//STRIP001 				for(USHORT i = 0; i < aTypeLB.GetEntryCount(); i++)
//STRIP001 					if(nVal == (USHORT)(ULONG)aTypeLB.GetEntryData(i))
//STRIP001 					{
//STRIP001 						aTypeLB.SelectEntryPos(i);
//STRIP001 						break;
//STRIP001 					}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	TypeHdl(0);
//STRIP001 
//STRIP001 	if (IsFldEdit())
//STRIP001 	{
//STRIP001 		aTypeLB.SaveValue();
//STRIP001 		aSelectionLB.SaveValue();
//STRIP001 		aFormatLB.SaveValue();
//STRIP001 		aNameED.SaveValue();
//STRIP001 		aValueED.SaveValue();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwFldRefPage, TypeHdl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	// Alte ListBoxPos sichern
//STRIP001 	const USHORT nOld = GetTypeSel();
//STRIP001 
//STRIP001 	// Aktuelle ListBoxPos
//STRIP001 	SetTypeSel(aTypeLB.GetSelectEntryPos());
//STRIP001 
//STRIP001 	if(GetTypeSel() == LISTBOX_ENTRY_NOTFOUND)
//STRIP001 	{
//STRIP001 		if (IsFldEdit())
//STRIP001 		{
//STRIP001 			// Positionen selektieren
//STRIP001 			String sName;
//STRIP001 			USHORT nFlag = 0;
//STRIP001 
//STRIP001 			switch( GetCurField()->GetSubType() )
//STRIP001 			{
//STRIP001 				case REF_BOOKMARK:
//STRIP001 					sName = sBookmarkTxt;
//STRIP001 					nFlag = REFFLDFLAG_BOOKMARK;
//STRIP001 					break;
//STRIP001 
//STRIP001 				case REF_FOOTNOTE:
//STRIP001 					sName = sFootnoteTxt;
//STRIP001 					nFlag = REFFLDFLAG_FOOTNOTE;
//STRIP001 					break;
//STRIP001 
//STRIP001 				case REF_ENDNOTE:
//STRIP001 					sName = sEndnoteTxt;
//STRIP001 					nFlag = REFFLDFLAG_ENDNOTE;
//STRIP001 					break;
//STRIP001 
//STRIP001 				case REF_SETREFATTR:
//STRIP001 					sName = SW_RESSTR(STR_GETREFFLD);
//STRIP001 					nFlag = REF_SETREFATTR;
//STRIP001 					break;
//STRIP001 
//STRIP001 				case REF_SEQUENCEFLD:
//STRIP001 					sName = ((SwGetRefField*)GetCurField())->GetSetRefName();
//STRIP001 					nFlag = REFFLDFLAG;
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			if (aTypeLB.GetEntryPos(sName) == LISTBOX_ENTRY_NOTFOUND)	// Referenz zu gelschter Marke
//STRIP001 			{
//STRIP001 				USHORT nPos = aTypeLB.InsertEntry(sName);
//STRIP001 				aTypeLB.SetEntryData(nPos, (void*)nFlag);
//STRIP001 			}
//STRIP001 
//STRIP001 			aTypeLB.SelectEntry(sName);
//STRIP001 			SetTypeSel(aTypeLB.GetSelectEntryPos());
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SetTypeSel(0);
//STRIP001 			aTypeLB.SelectEntryPos(0);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nOld != GetTypeSel())
//STRIP001 	{
//STRIP001 		USHORT nTypeId = (USHORT)(ULONG)aTypeLB.GetEntryData(GetTypeSel());
//STRIP001 
//STRIP001 		// Auswahl-Listbox fuellen
//STRIP001 		UpdateSubType();
//STRIP001 
//STRIP001 		BOOL bName = FALSE;
//STRIP001 		nFldDlgFmtSel = 0;
//STRIP001 
//STRIP001 		if ((!IsFldEdit() || aSelectionLB.GetEntryCount()) && nOld != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 		{
//STRIP001 			aNameED.SetText(aEmptyStr);
//STRIP001 			aValueED.SetText(aEmptyStr);
//STRIP001 		}
//STRIP001 
//STRIP001 		switch (nTypeId)
//STRIP001 		{
//STRIP001 			case TYP_GETREFFLD:
//STRIP001 				if (REFFLDFLAG & (USHORT)(ULONG)aTypeLB.GetEntryData(nOld))
//STRIP001 					// dann bleibt die alte bestehen
//STRIP001 					nFldDlgFmtSel = aFormatLB.GetSelectEntryPos();
//STRIP001 				bName = TRUE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TYP_SETREFFLD:
//STRIP001 				bName = TRUE;
//STRIP001 				break;
//STRIP001 
//STRIP001 			case REFFLDFLAG_BOOKMARK:
//STRIP001 				bName = TRUE;
//STRIP001 				// kein break!!!
//STRIP001 			default:
//STRIP001 				if( REFFLDFLAG & nTypeId )
//STRIP001 				{
//STRIP001 					USHORT nOldId = (USHORT)(ULONG)aTypeLB.GetEntryData(nOld);
//STRIP001 					if( nOldId & REFFLDFLAG || nOldId == TYP_GETREFFLD )
//STRIP001 						// dann bleibt die alte bestehen
//STRIP001 						nFldDlgFmtSel = aFormatLB.GetSelectEntryPos();
//STRIP001 				}
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 		aNameED.Enable(bName);
//STRIP001 		aNameFT.Enable(bName);
//STRIP001 
//STRIP001 		// Format-Listbox fuellen
//STRIP001 		USHORT nSize = FillFormatLB(nTypeId);
//STRIP001 		BOOL bFormat = nSize != 0;
//STRIP001 		aFormatLB.Enable(bFormat);
//STRIP001 		aFormatFT.Enable(bFormat);
//STRIP001 
//STRIP001 		SubTypeHdl();
//STRIP001 		ModifyHdl();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwFldRefPage, SubTypeHdl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	USHORT nTypeId = (USHORT)(ULONG)aTypeLB.GetEntryData(GetTypeSel());
//STRIP001 
//STRIP001 	switch(nTypeId)
//STRIP001 	{
//STRIP001 		case TYP_GETREFFLD:
//STRIP001 			if (!IsFldEdit() || aSelectionLB.GetSelectEntryCount())
//STRIP001 			{
//STRIP001 				aNameED.SetText(aSelectionLB.GetSelectEntry());
//STRIP001 				ModifyHdl(&aNameED);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 		case TYP_SETREFFLD:
//STRIP001 			aValueED.SetText(::GetActiveView()->GetWrtShell().GetSelTxt());
//STRIP001 			break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			if (!IsFldEdit() || aSelectionLB.GetSelectEntryCount())
//STRIP001 				aNameED.SetText(aSelectionLB.GetSelectEntry());
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung: Typen in SelectionLB erneuern
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwFldRefPage::UpdateSubType()
//STRIP001 {
//STRIP001 	SwWrtShell *pSh = ::GetActiveView()->GetWrtShellPtr();
//STRIP001 	SwGetRefField* pRefFld = (SwGetRefField*)GetCurField();
//STRIP001 	USHORT nTypeId = (USHORT)(ULONG)aTypeLB.GetEntryData(GetTypeSel());
//STRIP001 
//STRIP001 	String sOldSel;
//STRIP001 
//STRIP001 	USHORT nSelectionSel = aSelectionLB.GetSelectEntryPos();
//STRIP001 	if (nSelectionSel != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 		sOldSel = aSelectionLB.GetEntry(nSelectionSel);
//STRIP001 
//STRIP001 	aSelectionLB.SetUpdateMode(FALSE);
//STRIP001 	aSelectionLB.Clear();
//STRIP001 
//STRIP001 	if (IsFldEdit() && !sOldSel.Len())
//STRIP001 		sOldSel = String::CreateFromInt32( pRefFld->GetSeqNo() + 1 );
//STRIP001 
//STRIP001 	if( REFFLDFLAG & nTypeId )
//STRIP001 	{
//STRIP001 		if (nTypeId == REFFLDFLAG_BOOKMARK)		// TextMarken!
//STRIP001 		{
//STRIP001 			aSelectionLB.SetStyle(aSelectionLB.GetStyle()|WB_SORT);
//STRIP001 			// alle Textmarken besorgen
//STRIP001 			USHORT nCnt = pSh->GetBookmarkCnt(TRUE);
//STRIP001 			for( USHORT n = 0; n < nCnt; ++n )
//STRIP001 			{
//STRIP001 				const SwBookmark& rBkmk = pSh->GetBookmark( n, TRUE );
//STRIP001 				aSelectionLB.InsertEntry( rBkmk.GetName() );
//STRIP001 			}
//STRIP001 			if (IsFldEdit())
//STRIP001 				sOldSel = pRefFld->GetSetRefName();
//STRIP001 		}
//STRIP001 		else if (nTypeId == REFFLDFLAG_FOOTNOTE)
//STRIP001 		{
//STRIP001 			aSelectionLB.SetStyle(aSelectionLB.GetStyle() & ~WB_SORT);
//STRIP001 			SwSeqFldList aArr;
//STRIP001 			USHORT nCnt = pSh->GetSeqFtnList( aArr );
//STRIP001 			USHORT nFnd = 0;
//STRIP001 
//STRIP001 			for( USHORT n = 0; n < nCnt; ++n )
//STRIP001 			{
//STRIP001 				aSelectionLB.InsertEntry( aArr[ n ]->sDlgEntry );
//STRIP001 				if (IsFldEdit() && pRefFld->GetSeqNo() == aArr[ n ]->nSeqNo)
//STRIP001 					sOldSel = aArr[n]->sDlgEntry;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if (nTypeId == REFFLDFLAG_ENDNOTE)
//STRIP001 		{
//STRIP001 			aSelectionLB.SetStyle(aSelectionLB.GetStyle() & ~WB_SORT);
//STRIP001 			SwSeqFldList aArr;
//STRIP001 			USHORT nCnt = pSh->GetSeqFtnList( aArr, TRUE );
//STRIP001 			USHORT nFnd = 0;
//STRIP001 
//STRIP001 			for( USHORT n = 0; n < nCnt; ++n )
//STRIP001 			{
//STRIP001 				aSelectionLB.InsertEntry( aArr[ n ]->sDlgEntry );
//STRIP001 				if (IsFldEdit() && pRefFld->GetSeqNo() == aArr[ n ]->nSeqNo)
//STRIP001 					sOldSel = aArr[n]->sDlgEntry;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aSelectionLB.SetStyle(aSelectionLB.GetStyle()|WB_SORT);
//STRIP001 			// zum Seq-FeldTyp die Felder besorgen:
//STRIP001 
//STRIP001 			SwSetExpFieldType* pType = (SwSetExpFieldType*)pSh->GetFldType(
//STRIP001 								nTypeId & ~REFFLDFLAG, RES_SETEXPFLD );
//STRIP001 			if( pType )
//STRIP001 			{
//STRIP001 				SwSeqFldList aArr;
//STRIP001 				// old selection should be kept in non-edit mode
//STRIP001 				if(IsFldEdit())
//STRIP001 					sOldSel.Erase();
//STRIP001 
//STRIP001 				USHORT nCnt = pType->GetSeqFldList( aArr );
//STRIP001 				for( USHORT n = 0; n < nCnt; ++n )
//STRIP001 				{
//STRIP001 					aSelectionLB.InsertEntry( aArr[ n ]->sDlgEntry );
//STRIP001 					if (IsFldEdit() && !sOldSel.Len() &&
//STRIP001 						aArr[ n ]->nSeqNo == pRefFld->GetSeqNo())
//STRIP001 						sOldSel = aArr[ n ]->sDlgEntry;
//STRIP001 				}
//STRIP001 
//STRIP001 				if (IsFldEdit() && !sOldSel.Len())
//STRIP001 					sOldSel = String::CreateFromInt32( pRefFld->GetSeqNo() + 1);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SvStringsDtor& rLst = GetFldMgr().GetSubTypes(nTypeId);
//STRIP001 		for (USHORT i = 0; i < rLst.Count(); ++i)
//STRIP001 			aSelectionLB.InsertEntry(*rLst[i]);
//STRIP001 
//STRIP001 		if (IsFldEdit())
//STRIP001 			sOldSel = pRefFld->GetSetRefName();
//STRIP001 	}
//STRIP001 
//STRIP001 	aSelectionLB.SetUpdateMode(TRUE);
//STRIP001 
//STRIP001 	// Enable oder Disable
//STRIP001 	BOOL bEnable = aSelectionLB.GetEntryCount() != 0;
//STRIP001 	aSelectionLB.Enable( bEnable );
//STRIP001 	aSelectionFT.Enable( bEnable );
//STRIP001 
//STRIP001 	if ( bEnable )
//STRIP001 	{
//STRIP001 		aSelectionLB.SelectEntry(sOldSel);
//STRIP001 		if (!aSelectionLB.GetSelectEntryCount() && !IsFldEdit())
//STRIP001 			aSelectionLB.SelectEntryPos(0);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (IsFldEdit() && !aSelectionLB.GetSelectEntryCount())	// Falls die Referenz schon geloescht wurde...
//STRIP001 		aNameED.SetText(sOldSel);
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 USHORT SwFldRefPage::FillFormatLB(USHORT nTypeId)
//STRIP001 {
//STRIP001 	String sOldSel;
//STRIP001 
//STRIP001 	USHORT nFormatSel = aFormatLB.GetSelectEntryPos();
//STRIP001 	if (nFormatSel != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 		sOldSel = aFormatLB.GetEntry(nFormatSel);
//STRIP001 
//STRIP001 	// Format-Listbox fuellen
//STRIP001 	aFormatLB.Clear();
//STRIP001 
//STRIP001 	// Referenz hat weniger als die Beschriftung
//STRIP001 	USHORT nSize;
//STRIP001 	switch (nTypeId)
//STRIP001 	{
//STRIP001 	case TYP_GETREFFLD:
//STRIP001 	case REFFLDFLAG_BOOKMARK:
//STRIP001 	case REFFLDFLAG_FOOTNOTE:
//STRIP001 	case REFFLDFLAG_ENDNOTE:
//STRIP001 		nSize = FMT_REF_PAGE_PGDSC - FMT_REF_BEGIN + 1;
//STRIP001 		break;
//STRIP001 
//STRIP001 	default:
//STRIP001 		nSize = GetFldMgr().GetFormatCount( (REFFLDFLAG & nTypeId)
//STRIP001 												? TYP_GETREFFLD : nTypeId,
//STRIP001 											FALSE, IsFldDlgHtmlMode() );
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (REFFLDFLAG & nTypeId)
//STRIP001 		nTypeId = TYP_GETREFFLD;
//STRIP001 
//STRIP001 	for (USHORT i = 0; i < nSize; i++)
//STRIP001 	{
//STRIP001 		USHORT nPos = aFormatLB.InsertEntry(GetFldMgr().GetFormatStr( nTypeId, i ));
//STRIP001 		aFormatLB.SetEntryData( nPos, (void*)GetFldMgr().GetFormatId( nTypeId, i ));
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nSize)
//STRIP001 	{
//STRIP001 		if (!IsFldEdit())
//STRIP001 			aFormatLB.SelectEntry(sOldSel);
//STRIP001 		else
//STRIP001 			aFormatLB.SelectEntry(SW_RESSTR(FMT_REF_BEGIN + (USHORT)GetCurField()->GetFormat()));
//STRIP001 
//STRIP001 		if (!aFormatLB.GetSelectEntryCount())
//STRIP001 		{
//STRIP001 			aFormatLB.SelectEntryPos(nFldDlgFmtSel);
//STRIP001 			if (!aFormatLB.GetSelectEntryCount())
//STRIP001 				aFormatLB.SelectEntryPos(0);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nSize;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung: Modify
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwFldRefPage, ModifyHdl, Edit *, EMPTYARG )
//STRIP001 {
//STRIP001 	String aName(aNameED.GetText());
//STRIP001 	const USHORT nLen = aName.Len();
//STRIP001 
//STRIP001 	BOOL bEnable = TRUE;
//STRIP001 	USHORT nTypeId = (USHORT)(ULONG)aTypeLB.GetEntryData(GetTypeSel());
//STRIP001 
//STRIP001 	if ((nTypeId == TYP_SETREFFLD && !GetFldMgr().CanInsertRefMark(aName)) ||
//STRIP001 		(nLen == 0 && (nTypeId == TYP_GETREFFLD || nTypeId == TYP_SETREFFLD ||
//STRIP001 					   nTypeId == REFFLDFLAG_BOOKMARK)))
//STRIP001 		bEnable = FALSE;
//STRIP001 
//STRIP001 	EnableInsert(bEnable);
//STRIP001 
//STRIP001 	aSelectionLB.SelectEntry(aName);
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 BOOL SwFldRefPage::FillItemSet(SfxItemSet& )
//STRIP001 {
//STRIP001 	BOOL bPage = FALSE;
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	USHORT nTypeId = (USHORT)(ULONG)aTypeLB.GetEntryData(GetTypeSel());
//STRIP001 
//STRIP001 	USHORT nSubType = 0;
//STRIP001 	ULONG nFormat;
//STRIP001 
//STRIP001 	nFormat = aFormatLB.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if(nFormat == LISTBOX_ENTRY_NOTFOUND)
//STRIP001 		nFormat = 0;
//STRIP001 	else
//STRIP001 		nFormat = (ULONG)aFormatLB.GetEntryData((USHORT)nFormat);
//STRIP001 
//STRIP001 	String aVal(aValueED.GetText());
//STRIP001 	String aName(aNameED.GetText());
//STRIP001 
//STRIP001 	switch(nTypeId)
//STRIP001 	{
//STRIP001 		case TYP_GETREFFLD:
//STRIP001 			// aName = aSelectionLB.GetSelectEntry();
//STRIP001 			nSubType = REF_SETREFATTR;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case TYP_SETREFFLD:
//STRIP001 		{
//STRIP001 			SwFieldType* pType = GetFldMgr().GetFldType(RES_SETEXPFLD, aName);
//STRIP001 
//STRIP001 			if(!pType)	// Nur einfuegen, wenn es den Namen noch nicht gibt
//STRIP001 			{
//STRIP001 				aSelectionLB.InsertEntry(aName);
//STRIP001 				aSelectionLB.Enable();
//STRIP001 				aSelectionFT.Enable();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SwGetRefField* pRefFld = (SwGetRefField*)GetCurField();
//STRIP001 
//STRIP001 	if (REFFLDFLAG & nTypeId)
//STRIP001 	{
//STRIP001 		SwView *pView = ::GetActiveView();
//STRIP001 		ASSERT(pView, View fehlt);
//STRIP001 		SwWrtShell &rSh = pView->GetWrtShell();
//STRIP001 
//STRIP001 		if (nTypeId == REFFLDFLAG_BOOKMARK)		// TextMarken!
//STRIP001 		{
//STRIP001 			aName = aNameED.GetText();
//STRIP001 			nTypeId = TYP_GETREFFLD;
//STRIP001 			nSubType = REF_BOOKMARK;
//STRIP001 		}
//STRIP001 		else if (REFFLDFLAG_FOOTNOTE == nTypeId) 		// Fussnoten
//STRIP001 		{
//STRIP001 			SwSeqFldList aArr;
//STRIP001 			_SeqFldLstElem aElem( aSelectionLB.GetSelectEntry(), 0 );
//STRIP001 
//STRIP001 			USHORT nPos;
//STRIP001 
//STRIP001 			nTypeId = TYP_GETREFFLD;
//STRIP001 			nSubType = REF_FOOTNOTE;
//STRIP001 			aName.Erase();
//STRIP001 
//STRIP001 			if (rSh.GetSeqFtnList(aArr) && aArr.SeekEntry(aElem, &nPos))
//STRIP001 			{
//STRIP001 				aVal = String::CreateFromInt32( aArr[nPos]->nSeqNo );
//STRIP001 
//STRIP001 				if (IsFldEdit() && aArr[nPos]->nSeqNo == pRefFld->GetSeqNo())
//STRIP001 					bModified = TRUE; // Kann bei Feldern passieren, deren Referenz geloescht wurde
//STRIP001 			}
//STRIP001 			else if (IsFldEdit())
//STRIP001 				aVal = String::CreateFromInt32( pRefFld->GetSeqNo() );
//STRIP001 		}
//STRIP001 		else if (REFFLDFLAG_ENDNOTE == nTypeId) 		// Endnoten
//STRIP001 		{
//STRIP001 			SwSeqFldList aArr;
//STRIP001 			_SeqFldLstElem aElem( aSelectionLB.GetSelectEntry(), 0 );
//STRIP001 
//STRIP001 			USHORT nPos;
//STRIP001 
//STRIP001 			nTypeId = TYP_GETREFFLD;
//STRIP001 			nSubType = REF_ENDNOTE;
//STRIP001 			aName.Erase();
//STRIP001 
//STRIP001 			if (rSh.GetSeqFtnList(aArr, TRUE) && aArr.SeekEntry(aElem, &nPos))
//STRIP001 			{
//STRIP001 				aVal = String::CreateFromInt32( aArr[nPos]->nSeqNo );
//STRIP001 
//STRIP001 				if (IsFldEdit() && aArr[nPos]->nSeqNo == pRefFld->GetSeqNo())
//STRIP001 					bModified = TRUE; // Kann bei Feldern passieren, deren Referenz geloescht wurde
//STRIP001 			}
//STRIP001 			else if (IsFldEdit())
//STRIP001 				aVal = String::CreateFromInt32( pRefFld->GetSeqNo() );
//STRIP001 		}
//STRIP001 		else								// SeqenceFelder
//STRIP001 		{
//STRIP001 			// zum Seq-FeldTyp die Felder besorgen:
//STRIP001 			SwSetExpFieldType* pType = (SwSetExpFieldType*)rSh.GetFldType(
//STRIP001 									nTypeId & ~REFFLDFLAG, RES_SETEXPFLD );
//STRIP001 			if( pType )
//STRIP001 			{
//STRIP001 				SwSeqFldList aArr;
//STRIP001 				_SeqFldLstElem aElem( aSelectionLB.GetSelectEntry(), 0 );
//STRIP001 
//STRIP001 				USHORT nPos;
//STRIP001 
//STRIP001 				nTypeId = TYP_GETREFFLD;
//STRIP001 				nSubType = REF_SEQUENCEFLD;
//STRIP001 				aName = pType->GetName();
//STRIP001 
//STRIP001 				if (pType->GetSeqFldList(aArr) && aArr.SeekEntry(aElem, &nPos))
//STRIP001 				{
//STRIP001 					aVal = String::CreateFromInt32( aArr[nPos]->nSeqNo );
//STRIP001 
//STRIP001 					if (IsFldEdit() && aArr[nPos]->nSeqNo == pRefFld->GetSeqNo())
//STRIP001 						bModified = TRUE; // Kann bei Feldern passieren, deren Referenz geloescht wurde
//STRIP001 				}
//STRIP001 				else if (IsFldEdit())
//STRIP001 					aVal = String::CreateFromInt32( pRefFld->GetSeqNo() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (IsFldEdit() && nTypeId == TYP_GETREFFLD)
//STRIP001 	{
//STRIP001 		aVal.Insert('|', 0);
//STRIP001 		aVal.Insert(String::CreateFromInt32(nSubType), 0);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!IsFldEdit() || bModified ||
//STRIP001 		aNameED.GetSavedValue() != aNameED.GetText() ||
//STRIP001 		aValueED.GetSavedValue() != aValueED.GetText() ||
//STRIP001 		aTypeLB.GetSavedValue() != aTypeLB.GetSelectEntryPos() ||
//STRIP001 		aSelectionLB.GetSavedValue() != aSelectionLB.GetSelectEntryPos() ||
//STRIP001 		aFormatLB.GetSavedValue() != aFormatLB.GetSelectEntryPos())
//STRIP001 	{
//STRIP001 		InsertFld( nTypeId, nSubType, aName, aVal, nFormat );
//STRIP001 	}
//STRIP001 
//STRIP001 	ModifyHdl();	// Insert ggf enablen/disablen
//STRIP001 
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 SfxTabPage* SwFldRefPage::Create( 	Window* pParent,
//STRIP001 						const SfxItemSet& rAttrSet )
//STRIP001 {
//STRIP001 	return ( new SwFldRefPage( pParent, rAttrSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 USHORT SwFldRefPage::GetGroup()
//STRIP001 {
//STRIP001 	return GRP_REF;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------12.01.99 10:09-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void	SwFldRefPage::FillUserData()
//STRIP001 {
//STRIP001 	String sData( String::CreateFromAscii(
//STRIP001 					RTL_CONSTASCII_STRINGPARAM( USER_DATA_VERSION )));
//STRIP001 	sData += ';';
//STRIP001 	USHORT nTypeSel = aTypeLB.GetSelectEntryPos();
//STRIP001 	if( LISTBOX_ENTRY_NOTFOUND == nTypeSel )
//STRIP001 		nTypeSel = USHRT_MAX;
//STRIP001 	else
//STRIP001 		nTypeSel = (ULONG)aTypeLB.GetEntryData( nTypeSel );
//STRIP001 	sData += String::CreateFromInt32( nTypeSel );
//STRIP001 	SetUserData(sData);
//STRIP001 }

}
