/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_srcedtw.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:49:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _HINTIDS_HXX
//STRIP001 #include <hintids.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _CMDID_H
//STRIP001 #include <cmdid.h>
//STRIP001 #endif
//STRIP001 
//STRIP001 
//STRIP001 #ifndef _TEXTVIEW_HXX
//STRIP001 #include <svtools/textview.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_SVXIDS_HRC
//STRIP001 #include <bf_svx/svxids.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _SCRBAR_HXX //autogen
//STRIP001 #include <vcl/scrbar.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXDISPATCH_HXX //autogen
//STRIP001 #include <bf_sfx2/dispatch.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFX_BINDINGS_HXX //autogen
//STRIP001 #include <bf_sfx2/bindings.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXAPP_HXX //autogen
//STRIP001 #include <bf_sfx2/app.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _HTMLTOKN_H
//STRIP001 #include <svtools/htmltokn.h>
//STRIP001 #endif
//STRIP001 #ifndef _TXTATTR_HXX //autogen
//STRIP001 #include <svtools/txtattr.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVTOOLS_SOURCEVIEWCONFIG_HXX
//STRIP001 #include <svtools/sourceviewconfig.hxx>
//STRIP001 #endif
//STRIP001 #ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
//STRIP001 #include <svtools/colorcfg.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_FLSTITEM_HXX
//STRIP001 #include <bf_svx/flstitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_METRIC_HXX
//STRIP001 #include <vcl/metric.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _CTRLTOOL_HXX
//STRIP001 #include <svtools/ctrltool.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWMODULE_HXX
//STRIP001 #include <swmodule.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOCSH_HXX
//STRIP001 #include <docsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SRCVIEW_HXX
//STRIP001 #include <srcview.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SRCEDTW_HXX
//STRIP001 #include <srcedtw.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _HELPID_H
//STRIP001 #include <helpid.h>
//STRIP001 #endif
//STRIP001 
//STRIP001 
//STRIP001 enum SwHtmlTextType {
//STRIP001     TT_SGML     = svtools::HTMLSGML   ,
//STRIP001     TT_COMMENT  = svtools::HTMLCOMMENT,
//STRIP001     TT_KEYWORD  = svtools::HTMLKEYWORD,
//STRIP001     TT_UNKNOWN  = svtools::HTMLUNKNOWN
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 struct SwTextPortion
//STRIP001 {
//STRIP001 	USHORT nLine;
//STRIP001 	USHORT nStart, nEnd;
//STRIP001 	SwHtmlTextType eType;
//STRIP001 };
//STRIP001 
//STRIP001 #define MAX_SYNTAX_HIGHLIGHT 20
//STRIP001 #define MAX_HIGHLIGHTTIME 200
//STRIP001 #define SYNTAX_HIGHLIGHT_TIMEOUT 200
//STRIP001 
//STRIP001 SV_DECL_VARARR(SwTextPortions, SwTextPortion,16,16)
//STRIP001 
//STRIP001 /* -----------------15.01.97 12.07-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 SV_IMPL_VARARR(SwTextPortions, SwTextPortion)
//STRIP001 
//STRIP001 /*-----------------15.01.97 12.08-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 void lcl_Highlight(const String& rSource, SwTextPortions& aPortionList)
//STRIP001 {
//STRIP001 	const sal_Unicode cOpenBracket = '<';
//STRIP001 	const sal_Unicode cCloseBracket= '>';
//STRIP001 	const sal_Unicode cSlash		= '/';
//STRIP001 	const sal_Unicode cExclamation = '!';
//STRIP001 	const sal_Unicode cQuote		= '"';
//STRIP001 	const sal_Unicode cSQuote      = '\'';
//STRIP001 	const sal_Unicode cMinus		= '-';
//STRIP001 	const sal_Unicode cSpace		= ' ';
//STRIP001 	const sal_Unicode cTab			= 0x09;
//STRIP001 	const sal_Unicode cLF          = 0x0a;
//STRIP001 	const sal_Unicode cCR          = 0x0d;
//STRIP001 
//STRIP001 
//STRIP001 	const USHORT nStrLen = rSource.Len();
//STRIP001 	USHORT nInsert = 0;			// Anzahl der eingefuegten Portions
//STRIP001 	USHORT nActPos = 0;			//Position, an der '<' gefunden wurde
//STRIP001 	USHORT nOffset = 0; 		//Offset von nActPos zur '<'
//STRIP001 	USHORT nPortStart = USHRT_MAX; 	// fuer die TextPortion
//STRIP001 	USHORT nPortEnd  = 	0;  //
//STRIP001 	SwTextPortion aText;
//STRIP001 	while(nActPos < nStrLen)
//STRIP001 	{
//STRIP001 		SwHtmlTextType eFoundType = TT_UNKNOWN;
//STRIP001 		if(rSource.GetChar(nActPos) == cOpenBracket && nActPos < nStrLen - 2 )
//STRIP001 		{
//STRIP001 			// 'leere' Portion einfuegen
//STRIP001 			if(nPortEnd < nActPos - 1 )
//STRIP001 			{
//STRIP001 				aText.nLine = 0;
//STRIP001 				// am Anfang nicht verschieben
//STRIP001 				aText.nStart = nPortEnd;
//STRIP001 				if(nInsert)
//STRIP001 					aText.nStart += 1;
//STRIP001 				aText.nEnd = nActPos - 1;
//STRIP001 				aText.eType = TT_UNKNOWN;
//STRIP001 				aPortionList.Insert(aText, nInsert++);
//STRIP001 			}
//STRIP001 			sal_Unicode cFollowFirst = rSource.GetChar((xub_StrLen)(nActPos + 1));
//STRIP001 			sal_Unicode cFollowNext = rSource.GetChar((xub_StrLen)(nActPos + 2));
//STRIP001 			if(cExclamation == cFollowFirst)
//STRIP001 			{
//STRIP001 				// "<!" SGML oder Kommentar
//STRIP001 				if(cMinus == cFollowNext &&
//STRIP001 					nActPos < nStrLen - 3 && cMinus == rSource.GetChar((xub_StrLen)(nActPos + 3)))
//STRIP001 				{
//STRIP001 					eFoundType = TT_COMMENT;
//STRIP001 				}
//STRIP001 				else
//STRIP001 					eFoundType = TT_SGML;
//STRIP001 				nPortStart = nActPos;
//STRIP001 				nPortEnd = nActPos + 1;
//STRIP001 			}
//STRIP001 			else if(cSlash == cFollowFirst)
//STRIP001 			{
//STRIP001 				// "</" Slash ignorieren
//STRIP001 				nPortStart = nActPos;
//STRIP001 				nActPos++;
//STRIP001 				nOffset++;
//STRIP001 			}
//STRIP001 			if(TT_UNKNOWN == eFoundType)
//STRIP001 			{
//STRIP001 				//jetzt koennte hier ein keyword folgen
//STRIP001 				USHORT nSrchPos = nActPos;
//STRIP001 				while(++nSrchPos < nStrLen - 1)
//STRIP001 				{
//STRIP001 					sal_Unicode cNext = rSource.GetChar(nSrchPos);
//STRIP001 					if( cNext == cSpace	||
//STRIP001 						cNext == cTab 	||
//STRIP001 						cNext == cLF 	||
//STRIP001 						cNext == cCR)
//STRIP001 						break;
//STRIP001 					else if(cNext == cCloseBracket)
//STRIP001 					{
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if(nSrchPos > nActPos + 1)
//STRIP001 				{
//STRIP001 					//irgend ein String wurde gefunden
//STRIP001 					String sToken = rSource.Copy(nActPos + 1, nSrchPos - nActPos - 1 );
//STRIP001 					sToken.ToUpperAscii();
//STRIP001 					int nToken = ::GetHTMLToken(sToken);
//STRIP001 					if(nToken)
//STRIP001 					{
//STRIP001 						//Token gefunden
//STRIP001 						eFoundType = TT_KEYWORD;
//STRIP001 						nPortEnd = nSrchPos;
//STRIP001 						nPortStart = nActPos;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						//was war das denn?
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001 						DBG_ERROR("Token nicht erkannt!")
//STRIP001 						DBG_ERROR(ByteString(sToken, gsl_getSystemTextEncoding()).GetBuffer())
//STRIP001 #endif
//STRIP001 					}
//STRIP001 
//STRIP001 				}
//STRIP001 			}
//STRIP001 			// jetzt muss noch '>' gesucht werden
//STRIP001 			if(TT_UNKNOWN != eFoundType)
//STRIP001 			{
//STRIP001 				BOOL bFound = FALSE;
//STRIP001 				for(USHORT i = nPortEnd; i < nStrLen; i++)
//STRIP001 					if(cCloseBracket == rSource.GetChar(i))
//STRIP001 					{
//STRIP001 						bFound = TRUE;
//STRIP001 						nPortEnd = i;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				if(!bFound && (eFoundType == TT_COMMENT))
//STRIP001 				{
//STRIP001 					// Kommentar ohne Ende in dieser Zeile
//STRIP001 					bFound  = TRUE;
//STRIP001 					nPortEnd = nStrLen - 1;
//STRIP001 				}
//STRIP001 
//STRIP001 				if(bFound ||(eFoundType == TT_COMMENT))
//STRIP001 				{
//STRIP001 					SwTextPortion aText;
//STRIP001 					aText.nLine = 0;
//STRIP001 					aText.nStart = nPortStart + 1;
//STRIP001 					aText.nEnd = nPortEnd;
//STRIP001 					aText.eType = eFoundType;
//STRIP001 					aPortionList.Insert(aText, nInsert++);
//STRIP001 					eFoundType = TT_UNKNOWN;
//STRIP001 				}
//STRIP001 
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nActPos++;
//STRIP001 	}
//STRIP001 	if(nInsert && nPortEnd < nActPos - 1)
//STRIP001 	{
//STRIP001 		aText.nLine = 0;
//STRIP001 		aText.nStart = nPortEnd + 1;
//STRIP001 		aText.nEnd = nActPos - 1;
//STRIP001 		aText.eType = TT_UNKNOWN;
//STRIP001 		aPortionList.Insert(aText, nInsert++);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SwSrcEditWindow::SwSrcEditWindow( Window* pParent, SwSrcView* pParentView ) :
//STRIP001 	Window( pParent, WB_BORDER|WB_CLIPCHILDREN ),
//STRIP001 	pTextEngine(0),
//STRIP001 	pOutWin(0),
//STRIP001 	pHScrollbar(0),
//STRIP001 	pVScrollbar(0),
//STRIP001 	pSrcView(pParentView),
//STRIP001     pSourceViewConfig(new svt::SourceViewConfig),
//STRIP001 	nCurTextWidth(0),
//STRIP001 	bDoSyntaxHighlight(TRUE),
//STRIP001 	bHighlighting(FALSE),
//STRIP001     nStartLine(USHRT_MAX),
//STRIP001     eSourceEncoding(gsl_getSystemTextEncoding())
//STRIP001 {
//STRIP001 	SetHelpId(HID_SOURCE_EDITWIN);
//STRIP001 	CreateTextEngine();
//STRIP001     StartListening(*pSourceViewConfig);
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001  SwSrcEditWindow::~SwSrcEditWindow()
//STRIP001 {
//STRIP001     EndListening(*pSourceViewConfig);
//STRIP001     delete pSourceViewConfig;
//STRIP001     aSyntaxIdleTimer.Stop();
//STRIP001 	if ( pTextEngine )
//STRIP001 	{
//STRIP001 		EndListening( *pTextEngine );
//STRIP001 		pTextEngine->RemoveView( pTextView );
//STRIP001 
//STRIP001 		delete pHScrollbar;
//STRIP001 		delete pVScrollbar;
//STRIP001 
//STRIP001 		delete pTextView;
//STRIP001 		delete pTextEngine;
//STRIP001 	}
//STRIP001 	delete pOutWin;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void SwSrcEditWindow::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	switch ( rDCEvt.GetType() )
//STRIP001 	{
//STRIP001 	case DATACHANGED_SETTINGS:
//STRIP001 		// ScrollBars neu anordnen bzw. Resize ausloesen, da sich
//STRIP001 		// ScrollBar-Groesse geaendert haben kann. Dazu muss dann im
//STRIP001 		// Resize-Handler aber auch die Groesse der ScrollBars aus
//STRIP001 		// den Settings abgefragt werden.
//STRIP001 		if( rDCEvt.GetFlags() & SETTINGS_STYLE )
//STRIP001 			Resize();
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void  SwSrcEditWindow::Resize()
//STRIP001 {
//STRIP001 	// ScrollBars, etc. passiert in Adjust...
//STRIP001 	if ( pTextView )
//STRIP001 	{
//STRIP001 		long nVisY = pTextView->GetStartDocPos().Y();
//STRIP001 		pTextView->ShowCursor();
//STRIP001 		Size aOutSz( GetOutputSizePixel() );
//STRIP001 		long nMaxVisAreaStart = pTextView->GetTextEngine()->GetTextHeight() - aOutSz.Height();
//STRIP001 		if ( nMaxVisAreaStart < 0 )
//STRIP001 			nMaxVisAreaStart = 0;
//STRIP001 		if ( pTextView->GetStartDocPos().Y() > nMaxVisAreaStart )
//STRIP001 		{
//STRIP001 			Point aStartDocPos( pTextView->GetStartDocPos() );
//STRIP001 			aStartDocPos.Y() = nMaxVisAreaStart;
//STRIP001 			pTextView->SetStartDocPos( aStartDocPos );
//STRIP001 			pTextView->ShowCursor();
//STRIP001 		}
//STRIP001         long nScrollStd = GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001 		Size aScrollSz(aOutSz.Width() - nScrollStd, nScrollStd );
//STRIP001 		Point aScrollPos(0, aOutSz.Height() - nScrollStd);
//STRIP001 
//STRIP001 		pHScrollbar->SetPosSizePixel( aScrollPos, aScrollSz);
//STRIP001 
//STRIP001 		aScrollSz.Width() = aScrollSz.Height();
//STRIP001 		aScrollSz.Height() = aOutSz.Height();
//STRIP001 		aScrollPos = Point(aOutSz.Width() - nScrollStd, 0);
//STRIP001 
//STRIP001 		pVScrollbar->SetPosSizePixel( aScrollPos, aScrollSz);
//STRIP001 		aOutSz.Width() 	-= nScrollStd;
//STRIP001 		aOutSz.Height() 	-= nScrollStd;
//STRIP001 		pOutWin->SetOutputSizePixel(aOutSz);
//STRIP001         InitScrollBars();
//STRIP001 
//STRIP001         // Zeile im ersten Resize setzen
//STRIP001 		if(USHRT_MAX != nStartLine)
//STRIP001 		{
//STRIP001 			if(nStartLine < pTextEngine->GetParagraphCount())
//STRIP001 			{
//STRIP001 				TextSelection aSel(TextPaM( nStartLine, 0 ), TextPaM( nStartLine, 0x0 ));
//STRIP001 				pTextView->SetSelection(aSel);
//STRIP001 				pTextView->ShowCursor();
//STRIP001 			}
//STRIP001 			nStartLine = USHRT_MAX;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nVisY != pTextView->GetStartDocPos().Y() )
//STRIP001 			Invalidate();
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 void TextViewOutWin::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	switch( rDCEvt.GetType() )
//STRIP001 	{
//STRIP001 	case DATACHANGED_SETTINGS:
//STRIP001 		// den Settings abgefragt werden.
//STRIP001 		if( rDCEvt.GetFlags() & SETTINGS_STYLE )
//STRIP001 		{
//STRIP001 			const Color &rCol = GetSettings().GetStyleSettings().GetWindowColor();
//STRIP001 			SetBackground( rCol );
//STRIP001 			Font aFont( pTextView->GetTextEngine()->GetFont() );
//STRIP001 			aFont.SetFillColor( rCol );
//STRIP001 			pTextView->GetTextEngine()->SetFont( aFont );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void  TextViewOutWin::MouseMove( const MouseEvent &rEvt )
//STRIP001 {
//STRIP001 	if ( pTextView )
//STRIP001 		pTextView->MouseMove( rEvt );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  TextViewOutWin::MouseButtonUp( const MouseEvent &rEvt )
//STRIP001 {
//STRIP001 	if ( pTextView )
//STRIP001 	{
//STRIP001 		pTextView->MouseButtonUp( rEvt );
//STRIP001 		((SwSrcEditWindow*)GetParent())->GetSrcView()->GetViewFrame()->
//STRIP001 						GetBindings().Invalidate( SID_TABLE_CELL );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  TextViewOutWin::MouseButtonDown( const MouseEvent &rEvt )
//STRIP001 {
//STRIP001 	GrabFocus();
//STRIP001 	if ( pTextView )
//STRIP001 		pTextView->MouseButtonDown( rEvt );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  TextViewOutWin::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	switch(rCEvt.GetCommand())
//STRIP001 	{
//STRIP001 		case COMMAND_CONTEXTMENU:
//STRIP001 			((SwSrcEditWindow*)GetParent())->GetSrcView()->GetViewFrame()->
//STRIP001 				GetDispatcher()->ExecutePopup();
//STRIP001 		break;
//STRIP001 		case COMMAND_WHEEL:
//STRIP001 		case COMMAND_STARTAUTOSCROLL:
//STRIP001 		case COMMAND_AUTOSCROLL:
//STRIP001 		{
//STRIP001 			const CommandWheelData* pWData = rCEvt.GetWheelData();
//STRIP001 			if( !pWData || COMMAND_WHEEL_ZOOM != pWData->GetMode() )
//STRIP001 			{
//STRIP001 				((SwSrcEditWindow*)GetParent())->HandleWheelCommand( rCEvt );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			if ( pTextView )
//STRIP001 			pTextView->Command( rCEvt );
//STRIP001 		else
//STRIP001 			Window::Command(rCEvt);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  TextViewOutWin::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	BOOL bDone = FALSE;
//STRIP001 	SwSrcEditWindow* pSrcEditWin = (SwSrcEditWindow*)GetParent();
//STRIP001 	BOOL bChange = !pSrcEditWin->IsReadonly() || !TextEngine::DoesKeyChangeText( rKEvt );
//STRIP001 	if(bChange)
//STRIP001 		bDone = pTextView->KeyInput( rKEvt );
//STRIP001 
//STRIP001 	if ( !bDone )
//STRIP001 	{
//STRIP001 		if ( !SfxViewShell::Current()->KeyInput( rKEvt ) )
//STRIP001 			Window::KeyInput( rKEvt );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxBindings& rBindings = ((SwSrcEditWindow*)GetParent())->GetSrcView()->GetViewFrame()->GetBindings();
//STRIP001 		rBindings.Invalidate( SID_TABLE_CELL );
//STRIP001 		if ( rKEvt.GetKeyCode().GetGroup() == KEYGROUP_CURSOR )
//STRIP001 			rBindings.Update( SID_BASICIDE_STAT_POS );
//STRIP001 		if (pSrcEditWin->GetTextEngine()->IsModified() )
//STRIP001 		{
//STRIP001 			rBindings.Invalidate( SID_SAVEDOC );
//STRIP001 			rBindings.Invalidate( SID_DOC_MODIFIED );
//STRIP001 		}
//STRIP001 		if( rKEvt.GetKeyCode().GetCode() == KEY_INSERT )
//STRIP001 			rBindings.Invalidate( SID_ATTR_INSERT );
//STRIP001 	}
//STRIP001 	SwDocShell* pDocShell = pSrcEditWin->GetSrcView()->GetDocShell();
//STRIP001 	if(pSrcEditWin->GetTextEngine()->IsModified())
//STRIP001 	{
//STRIP001 		pDocShell->SetModified();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void  TextViewOutWin::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	pTextView->Paint( rRect );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwSrcEditWindow::CreateTextEngine()
//STRIP001 {
//STRIP001 	const Color &rCol = GetSettings().GetStyleSettings().GetWindowColor();
//STRIP001 	pOutWin = new TextViewOutWin(this, 0);
//STRIP001 	pOutWin->SetBackground(Wallpaper(rCol));
//STRIP001 	pOutWin->SetPointer(Pointer(POINTER_TEXT));
//STRIP001 	pOutWin->Show();
//STRIP001 
//STRIP001 	//Scrollbars anlegen
//STRIP001 	pHScrollbar = new ScrollBar(this, WB_3DLOOK |WB_HSCROLL|WB_DRAG);
//STRIP001         pHScrollbar->EnableRTL( false ); // #107300# --- RTL --- no mirroring for scrollbars
//STRIP001 	pHScrollbar->SetScrollHdl(LINK(this, SwSrcEditWindow, ScrollHdl));
//STRIP001 	pHScrollbar->Show();
//STRIP001 
//STRIP001 	pVScrollbar = new ScrollBar(this, WB_3DLOOK |WB_VSCROLL|WB_DRAG);
//STRIP001         pVScrollbar->EnableRTL( false ); // #107300# --- RTL --- no mirroring for scrollbars
//STRIP001 	pVScrollbar->SetScrollHdl(LINK(this, SwSrcEditWindow, ScrollHdl));
//STRIP001 	pHScrollbar->EnableDrag();
//STRIP001 	pVScrollbar->Show();
//STRIP001 
//STRIP001 	pTextEngine = new ExtTextEngine;
//STRIP001 	pTextView = new ExtTextView( pTextEngine, pOutWin );
//STRIP001 	pTextView->SetAutoIndentMode(TRUE);
//STRIP001 	pOutWin->SetTextView(pTextView);
//STRIP001 
//STRIP001 	pTextEngine->SetUpdateMode( FALSE );
//STRIP001 	pTextEngine->InsertView( pTextView );
//STRIP001 
//STRIP001 	Font aFont;
//STRIP001 	aFont.SetTransparent( FALSE );
//STRIP001 	aFont.SetFillColor( rCol );
//STRIP001 	SetPointFont( aFont );
//STRIP001 	aFont = GetFont();
//STRIP001 	aFont.SetFillColor( rCol );
//STRIP001 	pOutWin->SetFont( aFont );
//STRIP001 	pTextEngine->SetFont( aFont );
//STRIP001 
//STRIP001     aSyntaxIdleTimer.SetTimeout( SYNTAX_HIGHLIGHT_TIMEOUT );
//STRIP001 	aSyntaxIdleTimer.SetTimeoutHdl( LINK( this, SwSrcEditWindow, SyntaxTimerHdl ) );
//STRIP001 
//STRIP001 	pTextEngine->EnableUndo( TRUE );
//STRIP001 	pTextEngine->SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 	pTextView->ShowCursor( TRUE, TRUE );
//STRIP001 	InitScrollBars();
//STRIP001 	StartListening( *pTextEngine );
//STRIP001 
//STRIP001 	SfxBindings& rBind = GetSrcView()->GetViewFrame()->GetBindings();
//STRIP001 	rBind.Invalidate( SID_TABLE_CELL );
//STRIP001 //	rBind.Invalidate( SID_ATTR_CHAR_FONTHEIGHT );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwSrcEditWindow::SetScrollBarRanges()
//STRIP001 {
//STRIP001 	// Extra-Methode, nicht InitScrollBars, da auch fuer TextEngine-Events.
//STRIP001 
//STRIP001 	pHScrollbar->SetRange( Range( 0, nCurTextWidth-1 ) );
//STRIP001 	pVScrollbar->SetRange( Range(0, pTextEngine->GetTextHeight()-1) );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwSrcEditWindow::InitScrollBars()
//STRIP001 {
//STRIP001 	SetScrollBarRanges();
//STRIP001 
//STRIP001     Size aOutSz( pOutWin->GetOutputSizePixel() );
//STRIP001     pVScrollbar->SetVisibleSize( aOutSz.Height() );
//STRIP001 	pVScrollbar->SetPageSize(  aOutSz.Height() * 8 / 10 );
//STRIP001 	pVScrollbar->SetLineSize( pOutWin->GetTextHeight() );
//STRIP001 	pVScrollbar->SetThumbPos( pTextView->GetStartDocPos().Y() );
//STRIP001 	pHScrollbar->SetVisibleSize( aOutSz.Width() );
//STRIP001 	pHScrollbar->SetPageSize( aOutSz.Width() * 8 / 10 );
//STRIP001 	pHScrollbar->SetLineSize( pOutWin->GetTextWidth( 'x' ) );
//STRIP001 	pHScrollbar->SetThumbPos( pTextView->GetStartDocPos().X() );
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK(SwSrcEditWindow, ScrollHdl, ScrollBar*, pScroll)
//STRIP001 {
//STRIP001 	if(pScroll == pVScrollbar)
//STRIP001 	{
//STRIP001 		long nDiff = pTextView->GetStartDocPos().Y() - pScroll->GetThumbPos();
//STRIP001 		GetTextView()->Scroll( 0, nDiff );
//STRIP001 		pTextView->ShowCursor( FALSE, TRUE );
//STRIP001 		pScroll->SetThumbPos( pTextView->GetStartDocPos().Y() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nDiff = pTextView->GetStartDocPos().X() - pScroll->GetThumbPos();
//STRIP001 		GetTextView()->Scroll( nDiff, 0 );
//STRIP001 		pTextView->ShowCursor( FALSE, TRUE );
//STRIP001 		pScroll->SetThumbPos( pTextView->GetStartDocPos().X() );
//STRIP001 	}
//STRIP001 	GetSrcView()->GetViewFrame()->GetBindings().Invalidate( SID_TABLE_CELL );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------15.01.97 09.22-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwSrcEditWindow, SyntaxTimerHdl, Timer *, pTimer )
//STRIP001 {
//STRIP001     Time aSyntaxCheckStart;
//STRIP001     DBG_ASSERT( pTextView, "Noch keine View, aber Syntax-Highlight ?!" );
//STRIP001 	pTextEngine->SetUpdateMode( FALSE );
//STRIP001 
//STRIP001 	bHighlighting = TRUE;
//STRIP001 	USHORT nLine;
//STRIP001 	USHORT nCount  = 0;
//STRIP001 	// zuerst wird der Bereich um dem Cursor bearbeitet
//STRIP001 	TextSelection aSel = pTextView->GetSelection();
//STRIP001     USHORT nCur = (USHORT)aSel.GetStart().GetPara();
//STRIP001 	if(nCur > 40)
//STRIP001 		nCur -= 40;
//STRIP001 	else
//STRIP001 		nCur = 0;
//STRIP001 	if(aSyntaxLineTable.Count())
//STRIP001 		for(USHORT i = 0; i < 80 && nCount < 40; i++, nCur++)
//STRIP001 		{
//STRIP001 			void * p = aSyntaxLineTable.Get(nCur);
//STRIP001 			if(p)
//STRIP001 			{
//STRIP001 				DoSyntaxHighlight( nCur );
//STRIP001 				aSyntaxLineTable.Remove( nCur );
//STRIP001 				nCount++;
//STRIP001                 if(!aSyntaxLineTable.Count())
//STRIP001                     break;
//STRIP001                 if((Time().GetTime() - aSyntaxCheckStart.GetTime()) > MAX_HIGHLIGHTTIME )
//STRIP001                 {
//STRIP001                     pTimer->SetTimeout( 2 * SYNTAX_HIGHLIGHT_TIMEOUT );
//STRIP001                     break;
//STRIP001                 }
//STRIP001             }
//STRIP001 		}
//STRIP001 
//STRIP001 	// wenn dann noch etwas frei ist, wird von Beginn an weitergearbeitet
//STRIP001 	void* p = aSyntaxLineTable.First();
//STRIP001 	while ( p && nCount < MAX_SYNTAX_HIGHLIGHT)
//STRIP001 	{
//STRIP001 		nLine = (USHORT)aSyntaxLineTable.GetCurKey();
//STRIP001 		DoSyntaxHighlight( nLine );
//STRIP001 		USHORT nCur = (USHORT)aSyntaxLineTable.GetCurKey();
//STRIP001 		p = aSyntaxLineTable.Next();
//STRIP001 		aSyntaxLineTable.Remove(nCur);
//STRIP001 		nCount ++;
//STRIP001         if(Time().GetTime() - aSyntaxCheckStart.GetTime() > MAX_HIGHLIGHTTIME)
//STRIP001         {
//STRIP001             pTimer->SetTimeout( 2 * SYNTAX_HIGHLIGHT_TIMEOUT );
//STRIP001             break;
//STRIP001         }
//STRIP001 	}
//STRIP001 	// os: #43050# hier wird ein TextView-Problem umpopelt:
//STRIP001 	// waehrend des Highlightings funktionierte das Scrolling nicht
//STRIP001 	TextView* pTmp = pTextEngine->GetActiveView();
//STRIP001 	pTextEngine->SetActiveView(0);
//STRIP001 	pTextEngine->SetUpdateMode( TRUE );
//STRIP001 	pTextEngine->SetActiveView(pTmp);
//STRIP001 	pTextView->ShowCursor(FALSE, FALSE);
//STRIP001 
//STRIP001 	if(aSyntaxLineTable.Count() && !pTimer->IsActive())
//STRIP001 		pTimer->Start();
//STRIP001 	// SyntaxTimerHdl wird gerufen, wenn Text-Aenderung
//STRIP001 	// => gute Gelegenheit, Textbreite zu ermitteln!
//STRIP001 	long nPrevTextWidth = nCurTextWidth;
//STRIP001 	nCurTextWidth = pTextEngine->CalcTextWidth() + 25;	// kleine Toleranz
//STRIP001 	if ( nCurTextWidth != nPrevTextWidth )
//STRIP001 		SetScrollBarRanges();
//STRIP001 	bHighlighting = FALSE;
//STRIP001 
//STRIP001     return 0;
//STRIP001 }
//STRIP001 /*-----------------15.01.97 10.01-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 void SwSrcEditWindow::DoSyntaxHighlight( USHORT nPara )
//STRIP001 {
//STRIP001 	// Durch das DelayedSyntaxHighlight kann es passieren,
//STRIP001 	// dass die Zeile nicht mehr existiert!
//STRIP001 	if ( nPara < pTextEngine->GetParagraphCount() )
//STRIP001 	{
//STRIP001 		BOOL bTempModified = IsModified();
//STRIP001 		pTextEngine->RemoveAttribs( nPara );
//STRIP001 		String aSource( pTextEngine->GetText( nPara ) );
//STRIP001 		pTextEngine->SetUpdateMode( FALSE );
//STRIP001 		ImpDoHighlight( aSource, nPara );
//STRIP001 		// os: #43050# hier wird ein TextView-Problem umpopelt:
//STRIP001 		// waehrend des Highlightings funktionierte das Scrolling nicht
//STRIP001 		TextView* pTmp = pTextEngine->GetActiveView();
//STRIP001 		pTmp->SetAutoScroll(FALSE);
//STRIP001 		pTextEngine->SetActiveView(0);
//STRIP001 		pTextEngine->SetUpdateMode( TRUE );
//STRIP001 		pTextEngine->SetActiveView(pTmp);
//STRIP001 		// Bug 72887 show the cursor
//STRIP001 		pTmp->SetAutoScroll(TRUE);
//STRIP001 		pTmp->ShowCursor( FALSE/*pTmp->IsAutoScroll()*/ );
//STRIP001 
//STRIP001 		if(!bTempModified)
//STRIP001 			ClearModifyFlag();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------15.01.97 09.49-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 void SwSrcEditWindow::DoDelayedSyntaxHighlight( USHORT nPara )
//STRIP001 {
//STRIP001 	if ( !bHighlighting && bDoSyntaxHighlight )
//STRIP001 	{
//STRIP001 		aSyntaxLineTable.Insert( nPara, (void*)(USHORT)1 );
//STRIP001 		aSyntaxIdleTimer.Start();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------15.01.97 11.32-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 void SwSrcEditWindow::ImpDoHighlight( const String& rSource, USHORT nLineOff )
//STRIP001 {
//STRIP001 	SwTextPortions aPortionList;
//STRIP001 	lcl_Highlight(rSource, aPortionList);
//STRIP001 
//STRIP001 	USHORT nCount = aPortionList.Count();
//STRIP001 	if ( !nCount )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SwTextPortion& rLast = aPortionList[nCount-1];
//STRIP001 	if ( rLast.nStart > rLast.nEnd ) 	// Nur bis Bug von MD behoeben
//STRIP001 	{
//STRIP001 		nCount--;
//STRIP001 		aPortionList.Remove( nCount);
//STRIP001 		if ( !nCount )
//STRIP001 			return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Evtl. Optimieren:
//STRIP001 	// Wenn haufig gleiche Farbe, dazwischen Blank ohne Farbe,
//STRIP001 	// ggf. zusammenfassen, oder zumindest das Blank,
//STRIP001 	// damit weniger Attribute
//STRIP001 	BOOL bOptimizeHighlight = TRUE; // war in der BasicIDE static
//STRIP001 	if ( bOptimizeHighlight )
//STRIP001 	{
//STRIP001 		// Es muessen nur die Blanks und Tabs mit attributiert werden.
//STRIP001 		// Wenn zwei gleiche Attribute hintereinander eingestellt werden,
//STRIP001 		// optimiert das die TextEngine.
//STRIP001 		USHORT nLastEnd = 0;
//STRIP001 		USHORT nLine = aPortionList[0].nLine;
//STRIP001 		for ( USHORT i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			SwTextPortion& r = aPortionList[i];
//STRIP001 			DBG_ASSERT( r.nLine == nLine, "doch mehrere Zeilen ?" );
//STRIP001 			if ( r.nStart > r.nEnd ) 	// Nur bis Bug von MD behoeben
//STRIP001 				continue;
//STRIP001 
//STRIP001 			if ( r.nStart > nLastEnd )
//STRIP001 			{
//STRIP001 				// Kann ich mich drauf verlassen, dass alle ausser
//STRIP001 				// Blank und Tab gehighlightet wird ?!
//STRIP001 				r.nStart = nLastEnd;
//STRIP001 			}
//STRIP001 			nLastEnd = r.nEnd+1;
//STRIP001 			if ( ( i == (nCount-1) ) && ( r.nEnd < rSource.Len() ) )
//STRIP001 				r.nEnd = rSource.Len();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < aPortionList.Count(); i++ )
//STRIP001 	{
//STRIP001 		SwTextPortion& r = aPortionList[i];
//STRIP001 		if ( r.nStart > r.nEnd ) 	// Nur bis Bug von MD behoeben
//STRIP001 			continue;
//STRIP001 		USHORT nCol = r.eType;
//STRIP001         if(r.eType !=  svtools::HTMLSGML    &&
//STRIP001             r.eType != svtools::HTMLCOMMENT &&
//STRIP001             r.eType != svtools::HTMLKEYWORD &&
//STRIP001             r.eType != svtools::HTMLUNKNOWN)
//STRIP001                 r.eType = (SwHtmlTextType)svtools::HTMLUNKNOWN;
//STRIP001         Color aColor((ColorData)SW_MOD()->GetColorConfig().GetColorValue((svtools::ColorConfigEntry)r.eType).nColor);
//STRIP001         USHORT nLine = nLineOff+r.nLine; //
//STRIP001         pTextEngine->SetAttrib( TextAttribFontColor( aColor ), nLine, r.nStart, r.nEnd+1 );
//STRIP001 	}
//STRIP001 }
//STRIP001 /*-----------------21.04.97 09:42-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 void SwSrcEditWindow::SyntaxColorsChanged()
//STRIP001 {
//STRIP001 	for(USHORT i = 0; i < pTextEngine->GetParagraphCount(); i++)
//STRIP001 		aSyntaxLineTable.Insert( i, (void*)(USHORT)1 );
//STRIP001 	if(!aSyntaxIdleTimer.IsActive())
//STRIP001 		aSyntaxIdleTimer.Start();
//STRIP001 
//STRIP001 }
//STRIP001 /*-----------------30.06.97 09:12-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 void SwSrcEditWindow::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 {
//STRIP001 	if ( rHint.ISA( TextHint ) )
//STRIP001 	{
//STRIP001 		const TextHint& rTextHint = (const TextHint&)rHint;
//STRIP001 		if( rTextHint.GetId() == TEXT_HINT_VIEWSCROLLED )
//STRIP001 		{
//STRIP001 			pHScrollbar->SetThumbPos( pTextView->GetStartDocPos().X() );
//STRIP001 			pVScrollbar->SetThumbPos( pTextView->GetStartDocPos().Y() );
//STRIP001 		}
//STRIP001 		else if( rTextHint.GetId() == TEXT_HINT_TEXTHEIGHTCHANGED )
//STRIP001 		{
//STRIP001 			if ( (long)pTextEngine->GetTextHeight() < pOutWin->GetOutputSizePixel().Height() )
//STRIP001 				pTextView->Scroll( 0, pTextView->GetStartDocPos().Y() );
//STRIP001 			pVScrollbar->SetThumbPos( pTextView->GetStartDocPos().Y() );
//STRIP001 			SetScrollBarRanges();
//STRIP001 		}
//STRIP001 		else if( rTextHint.GetId() == TEXT_HINT_FORMATPARA )
//STRIP001 		{
//STRIP001             DoDelayedSyntaxHighlight( (USHORT)rTextHint.GetValue() );
//STRIP001 		}
//STRIP001 	}
//STRIP001     else if(&rBC == pSourceViewConfig)
//STRIP001         SetFont();
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------30.06.97 13:22-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 
//STRIP001 void	SwSrcEditWindow::Invalidate()
//STRIP001 {
//STRIP001 	pOutWin->Invalidate();
//STRIP001 	Window::Invalidate();
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 void SwSrcEditWindow::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	switch(rCEvt.GetCommand())
//STRIP001 	{
//STRIP001 		case COMMAND_WHEEL:
//STRIP001 		case COMMAND_STARTAUTOSCROLL:
//STRIP001 		case COMMAND_AUTOSCROLL:
//STRIP001 		{
//STRIP001 			const CommandWheelData* pWData = rCEvt.GetWheelData();
//STRIP001 			if( !pWData || COMMAND_WHEEL_ZOOM != pWData->GetMode() )
//STRIP001 				HandleScrollCommand( rCEvt, pHScrollbar, pVScrollbar );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		default:
//STRIP001 			Window::Command(rCEvt);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SwSrcEditWindow::HandleWheelCommand( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	pTextView->Command(rCEvt);
//STRIP001 	HandleScrollCommand( rCEvt, pHScrollbar, pVScrollbar );
//STRIP001 }
//STRIP001 
//STRIP001 void SwSrcEditWindow::GetFocus()
//STRIP001 {
//STRIP001 	pOutWin->GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 /*void SwSrcEditWindow::LoseFocus()
//STRIP001 {
//STRIP001 	Window::LoseFocus();
//STRIP001 //	pOutWin->LoseFocus();
//STRIP001 //	rView.LostFocus();
//STRIP001 } */
//STRIP001 /* -----------------------------29.08.2002 13:21------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 BOOL  lcl_GetLanguagesForEncoding(rtl_TextEncoding eEnc, LanguageType aLanguages[])
//STRIP001 {
//STRIP001     switch(eEnc)
//STRIP001     {
//STRIP001         case RTL_TEXTENCODING_UTF7             :
//STRIP001         case RTL_TEXTENCODING_UTF8             :
//STRIP001             // don#t fill - all LANGUAGE_SYSTEM means unicode font has to be used
//STRIP001         break;
//STRIP001 
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_ISO_8859_3:
//STRIP001         case RTL_TEXTENCODING_ISO_8859_1  :
//STRIP001         case RTL_TEXTENCODING_MS_1252     :
//STRIP001         case RTL_TEXTENCODING_APPLE_ROMAN :
//STRIP001         case RTL_TEXTENCODING_IBM_850     :
//STRIP001         case RTL_TEXTENCODING_ISO_8859_14 :
//STRIP001         case RTL_TEXTENCODING_ISO_8859_15 :
//STRIP001             //fill with western languages
//STRIP001             aLanguages[0] = LANGUAGE_GERMAN;
//STRIP001             aLanguages[1] = LANGUAGE_FRENCH;
//STRIP001             aLanguages[2] = LANGUAGE_ITALIAN;
//STRIP001             aLanguages[3] = LANGUAGE_SPANISH;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_IBM_865     :
//STRIP001             //scandinavian
//STRIP001             aLanguages[0] = LANGUAGE_FINNISH;
//STRIP001             aLanguages[1] = LANGUAGE_NORWEGIAN;
//STRIP001             aLanguages[2] = LANGUAGE_SWEDISH;
//STRIP001             aLanguages[3] = LANGUAGE_DANISH;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_ISO_8859_10      :
//STRIP001         case RTL_TEXTENCODING_ISO_8859_13      :
//STRIP001         case RTL_TEXTENCODING_ISO_8859_2  :
//STRIP001         case RTL_TEXTENCODING_IBM_852     :
//STRIP001         case RTL_TEXTENCODING_MS_1250     :
//STRIP001         case RTL_TEXTENCODING_APPLE_CENTEURO   :
//STRIP001             aLanguages[0] = LANGUAGE_POLISH;
//STRIP001             aLanguages[1] = LANGUAGE_CZECH;
//STRIP001             aLanguages[2] = LANGUAGE_HUNGARIAN;
//STRIP001             aLanguages[3] = LANGUAGE_SLOVAK;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_ISO_8859_4  :
//STRIP001         case RTL_TEXTENCODING_IBM_775     :
//STRIP001         case RTL_TEXTENCODING_MS_1257          :
//STRIP001             aLanguages[0] = LANGUAGE_LATVIAN   ;
//STRIP001             aLanguages[1] = LANGUAGE_LITHUANIAN;
//STRIP001             aLanguages[2] = LANGUAGE_ESTONIAN  ;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_IBM_863       : aLanguages[0] = LANGUAGE_FRENCH_CANADIAN; break;
//STRIP001         case RTL_TEXTENCODING_APPLE_FARSI   : aLanguages[0] = LANGUAGE_FARSI; break;
//STRIP001         case RTL_TEXTENCODING_APPLE_ROMANIAN:aLanguages[0] = LANGUAGE_ROMANIAN; break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_IBM_861     :
//STRIP001         case RTL_TEXTENCODING_APPLE_ICELAND    :
//STRIP001             aLanguages[0] = LANGUAGE_ICELANDIC;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_APPLE_CROATIAN:aLanguages[0] = LANGUAGE_CROATIAN; break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_IBM_437     :
//STRIP001         case RTL_TEXTENCODING_ASCII_US    : aLanguages[0] = LANGUAGE_ENGLISH; break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_IBM_862     :
//STRIP001         case RTL_TEXTENCODING_MS_1255     :
//STRIP001         case RTL_TEXTENCODING_APPLE_HEBREW     :
//STRIP001         case RTL_TEXTENCODING_ISO_8859_8  :
//STRIP001             aLanguages[0] = LANGUAGE_HEBREW;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_IBM_857     :
//STRIP001         case RTL_TEXTENCODING_MS_1254     :
//STRIP001         case RTL_TEXTENCODING_APPLE_TURKISH:
//STRIP001         case RTL_TEXTENCODING_ISO_8859_9  :
//STRIP001             aLanguages[0] = LANGUAGE_TURKISH;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_IBM_860     :
//STRIP001             aLanguages[0] = LANGUAGE_PORTUGUESE;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_IBM_869     :
//STRIP001         case RTL_TEXTENCODING_MS_1253     :
//STRIP001         case RTL_TEXTENCODING_APPLE_GREEK :
//STRIP001         case RTL_TEXTENCODING_ISO_8859_7  :
//STRIP001         case RTL_TEXTENCODING_IBM_737     :
//STRIP001             aLanguages[0] = LANGUAGE_GREEK;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_KOI8_R      :
//STRIP001         case RTL_TEXTENCODING_ISO_8859_5  :
//STRIP001         case RTL_TEXTENCODING_IBM_855     :
//STRIP001         case RTL_TEXTENCODING_MS_1251     :
//STRIP001         case RTL_TEXTENCODING_IBM_866     :
//STRIP001         case RTL_TEXTENCODING_APPLE_CYRILLIC   :
//STRIP001             aLanguages[0] = LANGUAGE_RUSSIAN;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_APPLE_UKRAINIAN:
//STRIP001         case RTL_TEXTENCODING_KOI8_U:
//STRIP001             aLanguages[0] = LANGUAGE_UKRAINIAN;
//STRIP001             break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_IBM_864     :
//STRIP001         case RTL_TEXTENCODING_MS_1256          :
//STRIP001         case RTL_TEXTENCODING_ISO_8859_6  :
//STRIP001         case RTL_TEXTENCODING_APPLE_ARABIC :
//STRIP001             aLanguages[0] = LANGUAGE_ARABIC;
//STRIP001          break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_APPLE_CHINTRAD   :
//STRIP001         case RTL_TEXTENCODING_MS_950           :
//STRIP001         case RTL_TEXTENCODING_GBT_12345        :
//STRIP001         case RTL_TEXTENCODING_BIG5             :
//STRIP001         case RTL_TEXTENCODING_EUC_TW           :
//STRIP001         case RTL_TEXTENCODING_BIG5_HKSCS       :
//STRIP001             aLanguages[0] = LANGUAGE_CHINESE_TRADITIONAL;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_EUC_JP           :
//STRIP001         case RTL_TEXTENCODING_ISO_2022_JP      :
//STRIP001         case RTL_TEXTENCODING_JIS_X_0201       :
//STRIP001         case RTL_TEXTENCODING_JIS_X_0208       :
//STRIP001         case RTL_TEXTENCODING_JIS_X_0212       :
//STRIP001         case RTL_TEXTENCODING_APPLE_JAPANESE   :
//STRIP001         case RTL_TEXTENCODING_MS_932           :
//STRIP001         case RTL_TEXTENCODING_SHIFT_JIS        :
//STRIP001             aLanguages[0] = LANGUAGE_JAPANESE;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_GB_2312          :
//STRIP001         case RTL_TEXTENCODING_MS_936           :
//STRIP001         case RTL_TEXTENCODING_GBK              :
//STRIP001         case RTL_TEXTENCODING_GB_18030         :
//STRIP001         case RTL_TEXTENCODING_APPLE_CHINSIMP   :
//STRIP001         case RTL_TEXTENCODING_EUC_CN           :
//STRIP001         case RTL_TEXTENCODING_ISO_2022_CN      :
//STRIP001             aLanguages[0] = LANGUAGE_CHINESE_SIMPLIFIED;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_APPLE_KOREAN     :
//STRIP001         case RTL_TEXTENCODING_MS_949           :
//STRIP001         case RTL_TEXTENCODING_EUC_KR           :
//STRIP001         case RTL_TEXTENCODING_ISO_2022_KR      :
//STRIP001         case RTL_TEXTENCODING_MS_1361          :
//STRIP001             aLanguages[0] = LANGUAGE_KOREAN;
//STRIP001         break;
//STRIP001 
//STRIP001         case RTL_TEXTENCODING_APPLE_THAI       :
//STRIP001         case RTL_TEXTENCODING_MS_874      :
//STRIP001         case RTL_TEXTENCODING_TIS_620          :
//STRIP001             aLanguages[0] = LANGUAGE_THAI;
//STRIP001         break;
//STRIP001 //        case RTL_TEXTENCODING_SYMBOL      :
//STRIP001 //        case RTL_TEXTENCODING_DONTKNOW:        :
//STRIP001         default: aLanguages[0] = Application::GetSettings().GetUILanguage();
//STRIP001     }
//STRIP001     return aLanguages[0] != LANGUAGE_SYSTEM;
//STRIP001 }
//STRIP001 void SwSrcEditWindow::SetFont()
//STRIP001 {
//STRIP001     String sFontName = pSourceViewConfig->GetFontName();
//STRIP001     if(!sFontName.Len())
//STRIP001     {
//STRIP001         LanguageType aLanguages[5] =
//STRIP001         {
//STRIP001             LANGUAGE_SYSTEM, LANGUAGE_SYSTEM, LANGUAGE_SYSTEM, LANGUAGE_SYSTEM, LANGUAGE_SYSTEM
//STRIP001         };
//STRIP001         Font aFont;
//STRIP001         if(lcl_GetLanguagesForEncoding(eSourceEncoding, aLanguages))
//STRIP001         {
//STRIP001             //TODO: check for multiple languages
//STRIP001             aFont = OutputDevice::GetDefaultFont(DEFAULTFONT_FIXED, aLanguages[0], 0, this);
//STRIP001         }
//STRIP001         else
//STRIP001             aFont = OutputDevice::GetDefaultFont(DEFAULTFONT_SANS_UNICODE,
//STRIP001                         Application::GetSettings().GetLanguage(), 0, this);
//STRIP001         sFontName = aFont.GetName();
//STRIP001     }
//STRIP001     const SvxFontListItem* pFontListItem =
//STRIP001         (const SvxFontListItem* )pSrcView->GetDocShell()->GetItem( SID_ATTR_CHAR_FONTLIST );
//STRIP001 	const FontList*	 pList = pFontListItem->GetFontList();
//STRIP001     FontInfo aInfo = pList->Get(sFontName,WEIGHT_NORMAL, ITALIC_NONE);
//STRIP001 
//STRIP001     const Font& rFont = GetTextEngine()->GetFont();
//STRIP001 	Font aFont(aInfo);
//STRIP001     Size aSize(rFont.GetSize());
//STRIP001     //font height is stored in point and set in twip
//STRIP001     aSize.Height() = pSourceViewConfig->GetFontHeight() * 20;
//STRIP001     aFont.SetSize(pOutWin->LogicToPixel(aSize, MAP_TWIP));
//STRIP001     GetTextEngine()->SetFont( aFont );
//STRIP001     pOutWin->SetFont(aFont);
//STRIP001 }
//STRIP001 /* -----------------------------29.08.2002 13:47------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwSrcEditWindow::SetTextEncoding(rtl_TextEncoding eEncoding)
//STRIP001 {
//STRIP001     eSourceEncoding = eEncoding;
//STRIP001     SetFont();
//STRIP001 }

}
