/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_multipat.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:33:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _FILEDLGHELPER_HXX
#include <bf_sfx2/filedlghelper.hxx>
#endif
#pragma hdrstop

#include "multipat.hxx"
#include "dialmgr.hxx"

#include "multipat.hrc"
#include "dialogs.hrc"

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef  _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef  _COM_SUN_STAR_UI_DIALOGS_XFOLDERPICKER_HPP_
#include <com/sun/star/ui/dialogs/XFolderPicker.hpp>
#endif
#ifndef  _COM_SUN_STAR_UI_DIALOGS_EXECUTABLEDIALOGRESULTS_HPP_
#include <com/sun/star/ui/dialogs/ExecutableDialogResults.hpp>
#endif

#include <unotools/localfilehelper.hxx>
#include <svtools/pathoptions.hxx>
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::ui::dialogs;
using namespace ::com::sun::star::uno;

// struct MultiPath_Impl -------------------------------------------------

//STRIP001 struct MultiPath_Impl
//STRIP001 {
//STRIP001 	BOOL	bEmptyAllowed;
//STRIP001 	BOOL	bIsClassPathMode;
//STRIP001 
//STRIP001 	MultiPath_Impl( BOOL bAllowed ) : bEmptyAllowed( bAllowed ), bIsClassPathMode( FALSE ) {}
//STRIP001 };

// class SvxMultiPathDialog ----------------------------------------------

//STRIP001 IMPL_LINK( SvxMultiPathDialog, SelectHdl_Impl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	BOOL bEnable = ( pImpl->bEmptyAllowed || pBox->GetEntryCount() > 1 );
//STRIP001 	aDelBtn.Enable( bEnable && pBox->GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND );
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxMultiPathDialog, AddHdl_Impl, PushButton *, EMPTYARG )
//STRIP001 {
//STRIP001     ::rtl::OUString aService( RTL_CONSTASCII_USTRINGPARAM( FOLDER_PICKER_SERVICE_NAME ) );
//STRIP001     Reference < XMultiServiceFactory > xFactory( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001 	Reference < XFolderPicker > xFolderPicker( xFactory->createInstance( aService ), UNO_QUERY );
//STRIP001 
//STRIP001 	if ( xFolderPicker->execute() == ExecutableDialogResults::OK )
//STRIP001 	{
//STRIP001 		INetURLObject aPath( xFolderPicker->getDirectory() );
//STRIP001 		aPath.removeFinalSlash();
//STRIP001         String aURL = aPath.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001         String sInsPath;
//STRIP001         ::utl::LocalFileHelper::ConvertURLToSystemPath( aURL, sInsPath );
//STRIP001 
//STRIP001 		if ( LISTBOX_ENTRY_NOTFOUND != aPathLB.GetEntryPos( sInsPath ) )
//STRIP001 		{
//STRIP001 			String sMsg( SVX_RES( RID_MULTIPATH_DBL_ERR ) );
//STRIP001 			sMsg.SearchAndReplaceAscii( "%1", sInsPath );
//STRIP001 			InfoBox( this, sMsg ).Execute();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			USHORT nPos = aPathLB.InsertEntry( sInsPath, LISTBOX_APPEND );
//STRIP001             aPathLB.SetEntryData( nPos, (void*)new String( aURL ) );
//STRIP001 		}
//STRIP001 		SelectHdl_Impl( &aPathLB );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxMultiPathDialog, DelHdl_Impl, PushButton *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nPos = aPathLB.GetSelectEntryPos();
//STRIP001 	aPathLB.RemoveEntry( nPos );
//STRIP001 	USHORT nCnt = aPathLB.GetEntryCount();
//STRIP001 
//STRIP001 	if ( nCnt )
//STRIP001 	{
//STRIP001 		nCnt--;
//STRIP001 
//STRIP001 		if ( nPos > nCnt )
//STRIP001 			nPos = nCnt;
//STRIP001 		aPathLB.SelectEntryPos( nPos );
//STRIP001 	}
//STRIP001 	SelectHdl_Impl( &aPathLB );
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxMultiPathDialog::SvxMultiPathDialog( Window* pParent, BOOL bEmptyAllowed ) :
//STRIP001 
//STRIP001 	ModalDialog( pParent, SVX_RES( RID_SVXDLG_MULTIPATH ) ),
//STRIP001 
//STRIP001 	aPathLB		( this, ResId( LB_MULTIPATH ) ),
//STRIP001 	aAddBtn		( this, ResId( BTN_ADD_MULTIPATH ) ),
//STRIP001 	aDelBtn		( this, ResId( BTN_DEL_MULTIPATH ) ),
//STRIP001 	aPathGB		( this, ResId( GB_MULTIPATH) ),
//STRIP001 	aOKBtn		( this, ResId( BTN_MULTIPATH_OK ) ),
//STRIP001 	aCancelBtn	( this, ResId( BTN_MULTIPATH_CANCEL ) ),
//STRIP001 	aHelpButton	( this, ResId( BTN_MULTIPATH_HELP ) ),
//STRIP001 	pImpl		( new MultiPath_Impl( bEmptyAllowed ) )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	aPathLB.SetSelectHdl( LINK( this, SvxMultiPathDialog, SelectHdl_Impl ) );
//STRIP001 	aAddBtn.SetClickHdl( LINK( this, SvxMultiPathDialog, AddHdl_Impl ) );
//STRIP001 	aDelBtn.SetClickHdl( LINK( this, SvxMultiPathDialog, DelHdl_Impl ) );
//STRIP001 	SelectHdl_Impl( &aPathLB );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxMultiPathDialog::~SvxMultiPathDialog()
//STRIP001 {
//STRIP001 	USHORT nPos = aPathLB.GetEntryCount();
//STRIP001 	while(nPos--)
//STRIP001 		delete (String*)aPathLB.GetEntryData(nPos);
//STRIP001 	delete pImpl;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 String SvxMultiPathDialog::GetPath() const
//STRIP001 {
//STRIP001 	String aPath;
//STRIP001 	sal_Unicode cDelim = pImpl->bIsClassPathMode ? CLASSPATH_DELIMITER : SVT_SEARCHPATH_DELIMITER;
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < aPathLB.GetEntryCount(); ++i )
//STRIP001 	{
//STRIP001 		aPath += *(String*)aPathLB.GetEntryData(i);
//STRIP001 		aPath += cDelim;
//STRIP001 	}
//STRIP001 	aPath.EraseTrailingChars( cDelim );
//STRIP001 	return aPath;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxMultiPathDialog::SetPath( const String& rPath )
//STRIP001 {
//STRIP001 	sal_Unicode cDelim = pImpl->bIsClassPathMode ? CLASSPATH_DELIMITER : SVT_SEARCHPATH_DELIMITER;
//STRIP001 	USHORT nPos;
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < rPath.GetTokenCount( cDelim ); ++i )
//STRIP001 	{
//STRIP001         String aTmp;
//STRIP001         if ( ::utl::LocalFileHelper::ConvertURLToSystemPath( rPath.GetToken( i, cDelim ), aTmp ) )
//STRIP001             nPos = aPathLB.InsertEntry( aTmp, LISTBOX_APPEND );
//STRIP001         else
//STRIP001             nPos = aPathLB.InsertEntry( rPath.GetToken( i, cDelim ), LISTBOX_APPEND );
//STRIP001 		aPathLB.SetEntryData( nPos, (void*)new String( rPath.GetToken( i, cDelim ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	SelectHdl_Impl( &aPathLB );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxMultiPathDialog::SetClassPathMode()
//STRIP001 {
//STRIP001 	pImpl->bIsClassPathMode = TRUE;
//STRIP001 	SetText( SVX_RES( RID_SVXSTR_ARCHIVE_TITLE ));
//STRIP001 	aPathGB.SetText( SVX_RES( RID_SVXSTR_ARCHIVE_HEADLINE ) );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SvxMultiPathDialog::IsClassPathMode() const
//STRIP001 {
//STRIP001 	return pImpl->bIsClassPathMode;
//STRIP001 }

}
