/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_msdffimp.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:26:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil -*- */

#include <math.h>

#include <limits.h>

#ifndef _SOLAR_H
#include <tools/solar.h>               // UINTXX
#endif
#ifndef INCLUDED_RTL_MATH_HXX
#include <rtl/math.hxx>
#endif

#pragma hdrstop

// SvxItem-Mapping. Wird benoetigt um die SvxItem-Header erfolgreich zu includen

#ifndef _EDITDATA_HXX
#include <editdata.hxx>
#endif

#include <svtools/urihelper.hxx>

#ifndef _OSL_ENDIAN_H_
#include <osl/endian.h>
#endif

//      textitem.hxx        editdata.hxx
#define ITEMID_COLOR        EE_CHAR_COLOR
#define ITEMID_FONT         EE_CHAR_FONTINFO
#define ITEMID_FONTHEIGHT   EE_CHAR_FONTHEIGHT
#define ITEMID_FONTWIDTH    EE_CHAR_FONTWIDTH
#define ITEMID_WEIGHT       EE_CHAR_WEIGHT
#define ITEMID_UNDERLINE    EE_CHAR_UNDERLINE
#define ITEMID_CROSSEDOUT   EE_CHAR_STRIKEOUT
#define ITEMID_POSTURE      EE_CHAR_ITALIC
#define ITEMID_CONTOUR      EE_CHAR_OUTLINE
#define ITEMID_SHADOWED     EE_CHAR_SHADOW
#define ITEMID_ESCAPEMENT   EE_CHAR_ESCAPEMENT
#define ITEMID_AUTOKERN     EE_CHAR_PAIRKERNING
#define ITEMID_WORDLINEMODE EE_CHAR_WLM
//      paraitem.hxx       editdata.hxx
#define ITEMID_ADJUST      EE_PARA_JUST
#define ITEMID_FIELD       EE_FEATURE_FIELD

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _TOOLS_ZCODEC_HXX
#include <tools/zcodec.hxx>
#endif
#ifndef _UNOTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif
#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif
#ifndef _SVX_ESCHEREX_HXX
#include <escherex.hxx>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XIDENTIFIERCONTAINER_HPP_
#include <com/sun/star/container/XIdentifierContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XGLUEPOINTSSUPPLIER_HPP_
#include <com/sun/star/drawing/XGluePointsSupplier.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_GLUEPOINT2_HPP_
#include <com/sun/star/drawing/GluePoint2.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XSHAPES_HPP_
#include <com/sun/star/drawing/XShapes.hpp>
#endif
#ifndef _FILTER_HXX //autogen
#include <svtools/filter.hxx>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _TOOLS_URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif
#ifndef _SV_BMPACC_HXX
#include <vcl/bmpacc.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif

#ifndef _SFX_OBJFAC_HXX
#include <bf_sfx2/docfac.hxx>
#endif
#ifndef _SFX_DOCFILT_HACK_HXX
#include <bf_sfx2/docfilt.hxx>
#endif
#ifndef _SFXDOCFILE_HXX
#include <bf_sfx2/docfile.hxx>
#endif
#ifndef _SFX_FCONTNR_HXX
#include <bf_sfx2/fcontnr.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#ifndef _SFX_INTERNO_HXX
#include <bf_sfx2/interno.hxx>
#endif

#ifndef _EEITEM_HXX //autogen
#include <eeitem.hxx>
#endif

#ifndef _SDGCPITM_HXX
#ifndef ITEMID_GRF_CROP
#define ITEMID_GRF_CROP	0
#endif
#include <sdgcpitm.hxx>
#endif

#ifndef _SDGMOITM_HXX
#include <sdgmoitm.hxx>
#endif
#ifndef _EEITEMID_HXX
#include "eeitemid.hxx"
#endif
#ifndef _SVX_TSPTITEM_HXX
#include "tstpitem.hxx"
#endif
#ifndef _SVX_FMMODEL_HXX
#include "fmmodel.hxx"
#endif
#ifndef _SVDMODEL_HXX
#include "svdmodel.hxx"
#endif
#ifndef _SVDOBJ_HXX
#include "svdobj.hxx"
#endif
#ifndef _SVDPAGE_HXX
#include "svdpage.hxx"
#endif
#ifndef _SVDOGRP_HXX
#include "svdogrp.hxx"
#endif
#ifndef _SVDOGRAF_HXX
#include "svdograf.hxx"
#endif
#ifndef _SVDOTEXT_HXX
#include "svdotext.hxx"
#endif
#ifndef _SVDORECT_HXX
#include "svdorect.hxx"
#endif
#ifndef _SVDOCAPT_HXX
#include "svdocapt.hxx"
#endif

#ifndef _SVDOEDGE_HXX
#include "svdoedge.hxx"
#endif

#ifndef _SVDOCIRC_HXX
#include "svdocirc.hxx"
#endif
#ifndef _SVDOUTL_HXX
#include "svdoutl.hxx"
#endif
#ifndef _SVDOOLE2_HXX
#include <svdoole2.hxx>
#endif
#ifndef _SVDOPATH_HXX
#include <svdopath.hxx>
#endif

#ifndef _SVDTRANS_HXX
#include <svdtrans.hxx>
#endif
#ifndef _SXENDITM_HXX
#include <sxenditm.hxx>
#endif
#ifndef _SDGLUITM_HXX
#include <sdgluitm.hxx>
#endif
#ifndef _SVX_FHGTITEM_HXX //autogen
#include <fhgtitem.hxx>
#endif
#ifndef _SVX_WGHTITEM_HXX //autogen
#include <wghtitem.hxx>
#endif
#ifndef _SVX_POSTITEM_HXX //autogen
#include <postitem.hxx>
#endif
#ifndef _SVX_UDLNITEM_HXX //autogen
#include <udlnitem.hxx>
#endif
#ifndef _SVX_CRSDITEM_HXX //autogen
#include <crsditem.hxx>
#endif
#ifndef _SVX_SHDDITEM_HXX //autogen
#include <shdditem.hxx>
#endif
#ifndef _SVX_FONTITEM_HXX //autogen
#include <fontitem.hxx>
#endif
#ifndef _SVX_COLRITEM_HXX //autogen
#include <colritem.hxx>
#endif
#ifndef _SXEKITM_HXX
#include <sxekitm.hxx>
#endif

#ifndef _SVX_BULITEM_HXX
#include <bulitem.hxx>
#endif
#ifndef _E3D_POLYSC3D_HXX
#include "polysc3d.hxx"
#endif
#ifndef _E3D_EXTRUD3D_HXX
#include "extrud3d.hxx"
#endif
#ifndef _SVDITER_HXX
#include "svditer.hxx"
#endif

#ifndef _XPOLY_HXX
#include "xpoly.hxx"
#endif

#ifndef _XATTR_HXX
#include "xattr.hxx"
#endif

#ifndef _IMPGRF_HXX //autogen
#include "impgrf.hxx"
#endif

#ifndef _MSDFFIMP_HXX
#include "msdffimp.hxx" // extern sichtbare Header-Datei
#endif
#ifndef _MSASHAPE_HXX
#include "msashape.hxx"
#endif
#ifndef _MSASHAPE3D_HXX
#include "msashape3d.hxx"
#endif
#ifndef _GALLERY_HXX_
#include "gallery.hxx"
#endif

#ifndef _SFXITEMPOOL_HXX
#include <svtools/itempool.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SVX3DITEMS_HXX
#include <svx3ditems.hxx>
#endif

#ifndef _UCBHELPER_CONTENT_HXX_
#include <ucbhelper/content.hxx>
#endif
#ifndef _UCBHELPER_CONTENTBROKER_HXX_
#include <ucbhelper/contentbroker.hxx>
#endif
#include <vos/xception.hxx>
#ifndef _VOS_NO_NAMESPACE
#include "so3/staticbaseurl.hxx"
namespace binfilter {
using namespace vos;
#endif

using namespace ::com::sun::star    ;
using namespace uno		            ;
using namespace beans		        ;
using namespace drawing	            ;
using namespace container	        ;

//STRIP001 #define ITEMVALUE(ItemSet,Id,Cast)  ((const Cast&)(ItemSet).Get(Id)).GetValue()
//STRIP001 
//STRIP001 // static counter for OLE-Objects
//STRIP001 static sal_uInt32 nMSOleObjCntr = 0;
//STRIP001 
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 //  Hilfs Klassen aus MSDFFDEF.HXX
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvStream& operator>>( SvStream& rIn, DffRecordHeader& rRec )
//STRIP001 {
//STRIP001 	rRec.nFilePos = rIn.Tell();
//STRIP001 	UINT16 nTmp;
//STRIP001 	rIn >> nTmp;
//STRIP001 	rRec.nImpVerInst = nTmp;
//STRIP001 	rRec.nRecVer = nTmp & 0x000F;
//STRIP001 	rRec.nRecInstance = nTmp >> 4;
//STRIP001 	rIn >> rRec.nRecType;
//STRIP001 	rIn >> rRec.nRecLen;
//STRIP001 	return rIn;
//STRIP001 }
//STRIP001 
//STRIP001 // Masse fuer dashed lines
//STRIP001 #define LLEN_MIDDLE         (450)
//STRIP001 #define LLEN_SPACE_MIDDLE   (360)
//STRIP001 #define LLEN_LONG           (LLEN_MIDDLE * 2)
//STRIP001 #define LLEN_SPACE_LONG     (LLEN_SPACE_MIDDLE + 20)
//STRIP001 #define LLEN_POINT          (LLEN_MIDDLE / 4)
//STRIP001 #define LLEN_SPACE_POINT    (LLEN_SPACE_MIDDLE / 4)
//STRIP001 
//STRIP001 SvStream& operator>>( SvStream& rIn, DffPropSet& rRec )
//STRIP001 {
//STRIP001 	rRec.InitializePropSet();
//STRIP001 
//STRIP001 	DffRecordHeader aHd;
//STRIP001 	rIn >> aHd;
//STRIP001 	UINT32 nPropCount = aHd.nRecInstance;
//STRIP001 
//STRIP001 	// FilePos der ComplexData merken
//STRIP001 	UINT32 nComplexDataFilePos = rIn.Tell() + ( nPropCount * 6 );
//STRIP001 
//STRIP001 	for( UINT32 nPropNum = 0; nPropNum < nPropCount; nPropNum++ )
//STRIP001 	{
//STRIP001 		sal_uInt16 nTmp;
//STRIP001 		sal_uInt32 nRecType, nContent, nContentEx = 0xffff0000;
//STRIP001 		rIn >> nTmp
//STRIP001 			>> nContent;
//STRIP001 
//STRIP001 		nRecType = nTmp & 0x3fff;
//STRIP001 
//STRIP001 		if ( nRecType > 0x3ff )
//STRIP001 			break;
//STRIP001 		if ( ( nRecType & 0x3f ) == 0x3f )
//STRIP001 		{	// clear flags that have to be cleared
//STRIP001 			rRec.mpContents[ nRecType ] &= ( ( nContent >> 16 ) ^ 0xffffffff );
//STRIP001 			// set flags that have to be set
//STRIP001 			rRec.mpContents[ nRecType ] |= nContent;
//STRIP001 			nContentEx |= nContent & ( nContent >> 16 );
//STRIP001 			rRec.Replace( nRecType, (void*)nContentEx );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DffPropFlags aPropFlag = { 1, 0, 0, 0 };
//STRIP001 			if ( nTmp & 0x4000 )
//STRIP001 				aPropFlag.bBlip = sal_True;
//STRIP001 			if ( nTmp & 0x8000 )
//STRIP001 				aPropFlag.bComplex = sal_True;
//STRIP001 			if ( aPropFlag.bComplex && nContent && ( nComplexDataFilePos < aHd.GetRecEndFilePos() ) )
//STRIP001             {
//STRIP001                 // normally nContent is the complete size of the complex property,
//STRIP001                 // but this is not always true for IMsoArrays ( what the hell is a IMsoArray ? )
//STRIP001 
//STRIP001                 // I love special threatments :-(
//STRIP001 				if ( ( nRecType == DFF_Prop_pVertices ) || ( nRecType == DFF_Prop_pSegmentInfo )
//STRIP001                     || ( nRecType == DFF_Prop_fillShadeColors ) || ( nRecType == DFF_Prop_lineDashStyle )
//STRIP001                         || ( nRecType == DFF_Prop_pWrapPolygonVertices ) )
//STRIP001 				{
//STRIP001                     // now check if the current content size is possible, or 6 bytes too small
//STRIP001 					sal_uInt32  nOldPos = rIn.Tell();
//STRIP001 					sal_Int16   nNumElem, nNumElemReserved, nSize;
//STRIP001 
//STRIP001                     rIn.Seek( nComplexDataFilePos );
//STRIP001 					rIn >>  nNumElem >> nNumElemReserved >> nSize;
//STRIP001                     if ( nNumElemReserved >= nNumElem )
//STRIP001                     {
//STRIP001                         // the size of these array elements is nowhere defined,
//STRIP001                         // what if the size is negative ?
//STRIP001                         // ok, we will make it positive and shift it.
//STRIP001                         // for -16 this works
//STRIP001 						if ( nSize < 0 )
//STRIP001 							nSize = ( -nSize ) >> 2;
//STRIP001                         sal_uInt32 nDataSize = (sal_uInt32)( nSize * nNumElem );
//STRIP001 
//STRIP001                         // sometimes the content size is 6 bytes too small (array header information is missing )
//STRIP001                         if ( nDataSize == nContent )
//STRIP001                             nContent += 6;
//STRIP001 
//STRIP001                         // check if array fits into the PropertyContainer
//STRIP001                         if ( ( nComplexDataFilePos + nContent ) > aHd.GetRecEndFilePos() )
//STRIP001                             nContent = 0;
//STRIP001                     }
//STRIP001                     else
//STRIP001                         nContent = 0;
//STRIP001 					rIn.Seek( nOldPos );
//STRIP001 				}
//STRIP001                 if ( nContent )
//STRIP001                 {
//STRIP001         		    nContentEx = nComplexDataFilePos;   // insert the filepos of this property;
//STRIP001                     nComplexDataFilePos += nContent;    // store filepos, that is used for the next complex property
//STRIP001                 }
//STRIP001                 else                                    // a complex property needs content
//STRIP001                     aPropFlag.bSet = sal_False;         // otherwise something is wrong
//STRIP001 			}
//STRIP001 			rRec.mpContents[ nRecType ] = nContent;
//STRIP001 			rRec.mpFlags[ nRecType ] = aPropFlag;
//STRIP001 			rRec.Insert( nRecType, (void*)nContentEx );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aHd.SeekToEndOfRecord( rIn );
//STRIP001 	return rIn;
//STRIP001 }
//STRIP001 
//STRIP001 void DffPropSet::InitializePropSet() const
//STRIP001 {
//STRIP001     /*
//STRIP001     cmc:
//STRIP001     " Boolean properties are grouped in bitfields by property set; note that
//STRIP001     the Boolean properties in each property set are contiguous. They are saved
//STRIP001     under the property ID of the last Boolean property in the set, and are
//STRIP001     placed in the value field in reverse order starting with the last property
//STRIP001     in the low bit. "
//STRIP001 
//STRIP001     e.g.
//STRIP001 
//STRIP001     fEditedWrap
//STRIP001     fBehindDocument
//STRIP001     fOnDblClickNotify
//STRIP001     fIsButton
//STRIP001     fOneD
//STRIP001     fHidden
//STRIP001     fPrint
//STRIP001 
//STRIP001     are all part of a group and all are by default false except for fPrint,
//STRIP001     which equates to a default bit sequence for the group of 0000001 -> 0x1
//STRIP001 
//STRIP001     If at a later stage word sets fBehindDocument away from the default it
//STRIP001     will be done by having a property named fPrint whose bitsequence will have
//STRIP001     the fBehindDocument bit set. e.g. a DFF_Prop_fPrint with value 0x200020
//STRIP001     has set bit 6 on so as to enable fBehindDocument (as well as disabling
//STRIP001     everything else)
//STRIP001     */
//STRIP001 
//STRIP001 	memset( ( (DffPropSet*) this )->mpFlags, 0, 0x400 * sizeof(DffPropFlags) );
//STRIP001 	( (DffPropSet*) this )->Clear();
//STRIP001 
//STRIP001 	DffPropFlags nFlags = { 1, 0, 0, 1 };
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_LockAgainstGrouping ] = 0x0000;		//0x01ff0000;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_LockAgainstGrouping ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_LockAgainstGrouping, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_FitTextToShape ] = 0x0010;				//0x001f0010;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_FitTextToShape ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_FitTextToShape, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_gtextFStrikethrough ] = 0x0000;		//0xffff0000;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_gtextFStrikethrough ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_gtextFStrikethrough, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_pictureActive ] = 0x0000;				//0x000f0000;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_pictureActive ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_pictureActive, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fFillOK ] = 0x0039;					//0x003f0039;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fFillOK ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fFillOK, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fNoFillHitTest ] = 0x001c;				//0x001f001c;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fNoFillHitTest ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fNoFillHitTest, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fNoLineDrawDash ] = 0x001e;			//0x001f000e;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fNoLineDrawDash ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fNoLineDrawDash, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fshadowObscured ] = 0x0000;			//0x00030000;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fshadowObscured ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fshadowObscured, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fPerspective ] = 0x0000;				//0x00010000;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fPerspective ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fPerspective, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fc3DLightFace ] = 0x0001;				//0x000f0001;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fc3DLightFace ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fc3DLightFace, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fc3DFillHarsh ] = 0x0016;				//0x001f0016;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fc3DFillHarsh ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fc3DFillHarsh, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fBackground ] = 0x0000;				//0x001f0000;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fBackground ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fBackground, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fCalloutLengthSpecified ] = 0x0010;	//0x00ef0010;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fCalloutLengthSpecified ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fCalloutLengthSpecified, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fPrint ] = 0x0001;						//0x00ef0001;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fPrint ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fPrint, (void*)0xffff0000 );
//STRIP001 
//STRIP001 	( (DffPropSet*) this )->mpContents[ DFF_Prop_fillColor ] = 0xffffff;
//STRIP001 	( (DffPropSet*) this )->mpFlags[ DFF_Prop_fillColor ] = nFlags;
//STRIP001 	( (DffPropSet*) this )->Insert( DFF_Prop_fillColor, (void*)0xffff0000 );
//STRIP001 }
//STRIP001 
//STRIP001 void DffPropSet::Merge( DffPropSet& rMaster ) const
//STRIP001 {
//STRIP001 	for ( void* pDummy = rMaster.First(); pDummy; pDummy = rMaster.Next() )
//STRIP001 	{
//STRIP001 		UINT32 nRecType = rMaster.GetCurKey();
//STRIP001 		if ( ( nRecType & 0x3f ) == 0x3f )		// this is something called FLAGS
//STRIP001 		{
//STRIP001 			UINT32 nCurrentFlags = mpContents[ nRecType ];
//STRIP001 			UINT32 nMergeFlags = rMaster.mpContents[ nRecType ];
//STRIP001 			nMergeFlags &=  ( nMergeFlags >> 16 ) | 0xffff0000;				// clearing low word
//STRIP001 			nMergeFlags &= ( ( nCurrentFlags & 0xffff0000 )					// remove allready hard set
//STRIP001 							| ( nCurrentFlags >> 16 ) ) ^ 0xffffffff;		// attributes from mergeflags
//STRIP001 			nCurrentFlags &= ( ( nMergeFlags & 0xffff0000 )					// apply zero master bits
//STRIP001 							| ( nMergeFlags >> 16 ) ) ^ 0xffffffff;
//STRIP001 			nCurrentFlags |= (UINT16)nMergeFlags;							// apply filled master bits
//STRIP001 			( (DffPropSet*) this )->mpContents[ nRecType ] = nCurrentFlags;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( !IsProperty( nRecType ) || !IsHardAttribute( nRecType ) )
//STRIP001 			{
//STRIP001 				( (DffPropSet*) this )->mpContents[ nRecType ] = rMaster.mpContents[ nRecType ];
//STRIP001 				DffPropFlags nFlags( rMaster.mpFlags[ nRecType ] );
//STRIP001 				nFlags.bSoftAttr = TRUE;
//STRIP001 				( (DffPropSet*) this )->mpFlags[ nRecType ] = nFlags;
//STRIP001 				( (DffPropSet*) this )->Insert( nRecType, pDummy );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 BOOL DffPropSet::IsHardAttribute( UINT32 nId ) const
//STRIP001 {
//STRIP001 	BOOL bRetValue = TRUE;
//STRIP001 	nId &= 0x3ff;
//STRIP001 	if ( ( nId & 0x3f ) >= 48 )	// is this a flag id
//STRIP001 	{
//STRIP001 		if ( ((DffPropSet*)this)->Seek( nId | 0x3f ) )
//STRIP001 		{
//STRIP001 			UINT32 nContentEx = (UINT32)GetCurObject();
//STRIP001 			bRetValue = ( nContentEx & ( 1 << ( 0xf - ( nId & 0xf ) ) ) ) != 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bRetValue = ( mpFlags[ nId ].bSoftAttr == 0 );
//STRIP001 	return bRetValue;
//STRIP001 };
//STRIP001 
//STRIP001 UINT32 DffPropSet::GetPropertyValue( UINT32 nId, UINT32 nDefault ) const
//STRIP001 {
//STRIP001 	nId &= 0x3ff;
//STRIP001 	return ( mpFlags[ nId ].bSet ) ? mpContents[ nId ] : nDefault;
//STRIP001 };
//STRIP001 
//STRIP001 void DffPropSet::SetPropertyValue( UINT32 nId, UINT32 nValue ) const
//STRIP001 {
//STRIP001 	if ( !mpFlags[ nId ].bSet )
//STRIP001 	{
//STRIP001 		( (DffPropSet*) this )->Insert( nId, (void*)nValue );
//STRIP001 		( (DffPropSet*) this )->mpFlags[ nId ].bSet = TRUE;
//STRIP001 	}
//STRIP001 	( (DffPropSet*) this )->mpContents[ nId ] = nValue;
//STRIP001 };
//STRIP001 
//STRIP001 BOOL DffPropSet::SeekToContent( UINT32 nRecType, SvStream& rStrm ) const
//STRIP001 {
//STRIP001 	nRecType &= 0x3ff;
//STRIP001 	if ( mpFlags[ nRecType ].bSet )
//STRIP001 	{
//STRIP001 		if ( mpFlags[ nRecType ].bComplex )
//STRIP001 		{
//STRIP001 			if ( ((DffPropSet*)this)->Seek( nRecType ) )
//STRIP001 			{
//STRIP001 				UINT32 nOffset = (UINT32)GetCurObject();
//STRIP001 				if ( nOffset && ( ( nOffset & 0xffff0000 ) != 0xffff0000 ) )
//STRIP001 				{
//STRIP001 					rStrm.Seek( nOffset );
//STRIP001 					return TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 DffPropertyReader::DffPropertyReader( const SvxMSDffManager& rMan ) :
//STRIP001 	rManager( rMan ),
//STRIP001 	pDefaultPropSet( NULL )
//STRIP001 {
//STRIP001 	InitializePropSet();
//STRIP001 }
//STRIP001 
//STRIP001 void DffPropertyReader::SetDefaultPropSet( SvStream& rStCtrl, UINT32 nOffsDgg ) const
//STRIP001 {
//STRIP001 	delete pDefaultPropSet;
//STRIP001 	UINT32 nMerk = rStCtrl.Tell();
//STRIP001 	rStCtrl.Seek( nOffsDgg );
//STRIP001 	DffRecordHeader aRecHd;
//STRIP001 	rStCtrl >> aRecHd;
//STRIP001 	if ( aRecHd.nRecType == DFF_msofbtDggContainer )
//STRIP001 	{
//STRIP001 		if ( rManager.SeekToRec( rStCtrl, DFF_msofbtOPT, aRecHd.GetRecEndFilePos() ) )
//STRIP001 		{
//STRIP001 			( (DffPropertyReader*) this )->pDefaultPropSet = new DffPropSet;
//STRIP001 			rStCtrl >> *pDefaultPropSet;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	rStCtrl.Seek( nMerk );
//STRIP001 }
//STRIP001 
//STRIP001 #ifdef DBG_AUTOSHAPE
//STRIP001 void DffPropertyReader::ReadPropSet( SvStream& rIn, void* pClientData, UINT32 nShapeId ) const
//STRIP001 #else
//STRIP001 void DffPropertyReader::ReadPropSet( SvStream& rIn, void* pClientData ) const
//STRIP001 #endif
//STRIP001 {
//STRIP001 	ULONG nFilePos = rIn.Tell();
//STRIP001 	rIn >> (DffPropertyReader&)*this;
//STRIP001 
//STRIP001 	if ( IsProperty( DFF_Prop_hspMaster ) )
//STRIP001 	{
//STRIP001 		if ( rManager.SeekToShape( rIn, pClientData, GetPropertyValue( DFF_Prop_hspMaster ) ) )
//STRIP001 		{
//STRIP001 			DffRecordHeader aRecHd;
//STRIP001 			rIn >> aRecHd;
//STRIP001 			if ( rManager.SeekToRec( rIn, DFF_msofbtOPT, aRecHd.GetRecEndFilePos() ) )
//STRIP001 			{
//STRIP001 				DffPropSet aMasterPropSet;
//STRIP001 				rIn >> aMasterPropSet;
//STRIP001 				Merge( aMasterPropSet );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 //	if ( pDefaultPropSet )
//STRIP001 //		Merge( *( pDefaultPropSet ) );
//STRIP001 
//STRIP001 	( (DffPropertyReader*) this )->mnFix16Angle = Fix16ToAngle( GetPropertyValue( DFF_Prop_Rotation, 0 ) );
//STRIP001 
//STRIP001 #ifdef DBG_AUTOSHAPE
//STRIP001 
//STRIP001 	String aURLStr;
//STRIP001 
//STRIP001 	if( ::utl::LocalFileHelper::ConvertPhysicalNameToURL( String( RTL_CONSTASCII_STRINGPARAM( "d:\\ashape.dbg" ) ), aURLStr ) )
//STRIP001 	{
//STRIP001 		SvStream* pOut = ::utl::UcbStreamHelper::CreateStream( aURLStr, STREAM_WRITE );
//STRIP001 
//STRIP001 		if( pOut )
//STRIP001 		{
//STRIP001 			pOut->Seek( STREAM_SEEK_TO_END );
//STRIP001 
//STRIP001 			if ( IsProperty( DFF_Prop_adjustValue ) || IsProperty( DFF_Prop_pVertices ) )
//STRIP001 			{
//STRIP001 				pOut->WriteLine( "" );
//STRIP001 				ByteString aString( "ShapeId: " );
//STRIP001 				aString.Append( ByteString::CreateFromInt32( nShapeId ) );
//STRIP001 				pOut->WriteLine( aString );
//STRIP001 			}
//STRIP001 			for ( sal_uInt32 i = DFF_Prop_adjustValue; i <=	DFF_Prop_adjust10Value; i++ )
//STRIP001 			{
//STRIP001 				if ( IsProperty( i ) )
//STRIP001 				{
//STRIP001 					ByteString aString( "Prop_adjustValue" );
//STRIP001 					aString.Append( ByteString::CreateFromInt32( ( i - DFF_Prop_adjustValue ) + 1 ) );
//STRIP001 					aString.Append( ":" );
//STRIP001 					aString.Append( ByteString::CreateFromInt32( GetPropertyValue( i ) ) );
//STRIP001 					pOut->WriteLine( aString );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			for ( i = 320; i < 383; i++ )
//STRIP001 			{
//STRIP001 				if ( ( i >= DFF_Prop_adjustValue ) && ( i <= DFF_Prop_adjust10Value ) )
//STRIP001 					continue;
//STRIP001 				if ( IsProperty( i ) )
//STRIP001 				{
//STRIP001 					if ( SeekToContent( i, rIn ) )
//STRIP001 					{
//STRIP001 						INT32 nLen = (INT32)GetPropertyValue( i );
//STRIP001 						if ( nLen )
//STRIP001 						{
//STRIP001 							pOut->WriteLine( "" );
//STRIP001 							ByteString aDesc( "Property:" );
//STRIP001 							aDesc.Append( ByteString::CreateFromInt32( i ) );
//STRIP001 							aDesc.Append( ByteString( "  Size:" ) );
//STRIP001 							aDesc.Append( ByteString::CreateFromInt32( nLen ) );
//STRIP001 							pOut->WriteLine( aDesc );
//STRIP001 							INT16	nNumElem, nNumElemMem, nNumSize;
//STRIP001 							rIn >> nNumElem >> nNumElemMem >> nNumSize;
//STRIP001 							aDesc = ByteString( "Entries: " );
//STRIP001 							aDesc.Append( ByteString::CreateFromInt32( nNumElem ) );
//STRIP001 							aDesc.Append( ByteString(  "  Size:" ) );
//STRIP001 							aDesc.Append( ByteString::CreateFromInt32( nNumSize ) );
//STRIP001 							pOut->WriteLine( aDesc );
//STRIP001 							if ( nNumSize < 0 )
//STRIP001 								nNumSize = ( ( -nNumSize ) >> 2 );
//STRIP001 							if ( !nNumSize )
//STRIP001 								nNumSize = 16;
//STRIP001 							nLen -= 6;
//STRIP001 							while ( nLen > 0 )
//STRIP001 							{
//STRIP001 								ByteString aString;
//STRIP001 								for ( UINT32 j = 0; nLen && ( j < ( nNumSize >> 1 ) ); j++ )
//STRIP001 								{
//STRIP001 									for ( UINT32 k = 0; k < 2; k++ )
//STRIP001 									{
//STRIP001 										if ( nLen )
//STRIP001 										{
//STRIP001 											BYTE nVal;
//STRIP001 											rIn >> nVal;
//STRIP001 											if ( ( nVal >> 4 ) > 9 )
//STRIP001 												*pOut << (BYTE)( ( nVal >> 4 ) + 'A' - 10 );
//STRIP001 											else
//STRIP001 												*pOut << (BYTE)( ( nVal >> 4 ) + '0' );
//STRIP001 
//STRIP001 											if ( ( nVal & 0xf ) > 9 )
//STRIP001 												*pOut << (BYTE)( ( nVal & 0xf ) + 'A' - 10 );
//STRIP001 											else
//STRIP001 												*pOut << (BYTE)( ( nVal & 0xf ) + '0' );
//STRIP001 
//STRIP001 											nLen--;
//STRIP001 										}
//STRIP001 									}
//STRIP001 									*pOut << (char)( ' ' );
//STRIP001 								}
//STRIP001 								pOut->WriteLine( aString );
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						ByteString aString( "Property" );
//STRIP001 						aString.Append( ByteString::CreateFromInt32( i ) );
//STRIP001 						aString.Append( ":" );
//STRIP001 						aString.Append( ByteString::CreateFromInt32( GetPropertyValue( i ) ) );
//STRIP001 						pOut->WriteLine( aString );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			delete pOut;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 #endif
//STRIP001 
//STRIP001 	rIn.Seek( nFilePos );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 INT32 DffPropertyReader::Fix16ToAngle( INT32 nContent ) const
//STRIP001 {
//STRIP001 	INT32 nAngle = 0;
//STRIP001 	if ( nContent )
//STRIP001 	{
//STRIP001 		nAngle = ( (INT16)( nContent >> 16) * 100L ) + ( ( ( nContent & 0x0000ffff) * 100L ) >> 16 );
//STRIP001 		nAngle = NormAngle360( -nAngle );
//STRIP001 	}
//STRIP001 	return nAngle;
//STRIP001 }
//STRIP001 
//STRIP001 DffPropertyReader::~DffPropertyReader()
//STRIP001 {
//STRIP001 	delete pDefaultPropSet;
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 SvStream& operator>>( SvStream& rIn, SvxMSDffConnectorRule& rRule )
//STRIP001 {
//STRIP001 	rIn >> rRule.nRuleId
//STRIP001 		>> rRule.nShapeA
//STRIP001 		>> rRule.nShapeB
//STRIP001 		>> rRule.nShapeC
//STRIP001 		>> rRule.ncptiA
//STRIP001 		>> rRule.ncptiB;
//STRIP001 
//STRIP001 	return rIn;
//STRIP001 }
//STRIP001 
//STRIP001 SvxMSDffSolverContainer::SvxMSDffSolverContainer()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SvxMSDffSolverContainer::~SvxMSDffSolverContainer()
//STRIP001 {
//STRIP001 	for ( SvxMSDffConnectorRule* pPtr = (SvxMSDffConnectorRule*)aCList.First();
//STRIP001 			pPtr; pPtr = (SvxMSDffConnectorRule*)aCList.Next() )
//STRIP001 		delete pPtr;
//STRIP001 }
//STRIP001 
//STRIP001 SvStream& operator>>( SvStream& rIn, SvxMSDffSolverContainer& rContainer )
//STRIP001 {
//STRIP001 	DffRecordHeader aHd;
//STRIP001 	rIn >> aHd;
//STRIP001 	if ( aHd.nRecType == DFF_msofbtSolverContainer )
//STRIP001 	{
//STRIP001 		DffRecordHeader aCRule;
//STRIP001 		while ( ( rIn.GetError() == 0 ) && ( rIn.Tell() < aHd.GetRecEndFilePos() ) )
//STRIP001 		{
//STRIP001 			rIn >> aCRule;
//STRIP001 			if ( aCRule.nRecType == DFF_msofbtConnectorRule )
//STRIP001 			{
//STRIP001 				SvxMSDffConnectorRule* pRule = new SvxMSDffConnectorRule;
//STRIP001 				rIn >> *pRule;
//STRIP001 				rContainer.aCList.Insert( pRule, LIST_APPEND );
//STRIP001 			}
//STRIP001 			aCRule.SeekToEndOfRecord( rIn );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return rIn;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::SolveSolver( const SvxMSDffSolverContainer& rSolver )
//STRIP001 {
//STRIP001     sal_Int32 i, nCount;
//STRIP001     for ( i = 0, nCount = rSolver.aCList.Count(); i < nCount; i++ )
//STRIP001     {
//STRIP001         SvxMSDffConnectorRule* pPtr = (SvxMSDffConnectorRule*)rSolver.aCList.GetObject( i );
//STRIP001 		if ( pPtr->pCObj )
//STRIP001 		{
//STRIP001 			for ( int nN = 0; nN < 2; nN++ )
//STRIP001 			{
//STRIP001 				SdrObject*  pO;
//STRIP001 				sal_uInt32  nC, nSpFlags;
//STRIP001 				sal_Bool    bTail;
//STRIP001 				if ( !nN )
//STRIP001 				{
//STRIP001 					bTail = sal_True;
//STRIP001 					pO = pPtr->pAObj;
//STRIP001 					nC = pPtr->ncptiA;
//STRIP001                     nSpFlags = pPtr->nSpFlagsA;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					bTail = sal_False;
//STRIP001 					pO = pPtr->pBObj;
//STRIP001 					nC = pPtr->ncptiB;
//STRIP001                     nSpFlags = pPtr->nSpFlagsB;
//STRIP001 				}
//STRIP001 				if ( pO )
//STRIP001 				{
//STRIP001 					Any aAny;
//STRIP001 					SdrGluePoint aGluePoint;
//STRIP001 					Reference< XShape > aXShape( pO->getUnoShape(), UNO_QUERY );
//STRIP001 					Reference< XShape > aXConnector( pPtr->pCObj->getUnoShape(), UNO_QUERY );
//STRIP001 					SdrGluePointList* pList = pO->ForceGluePointList();
//STRIP001 
//STRIP001                     sal_Bool bValidGluePoint = sal_False;
//STRIP001 					sal_Int32 nId = nC;
//STRIP001                     sal_uInt32 nInventor = pO->GetObjInventor();
//STRIP001 
//STRIP001 					if( nInventor == SdrInventor )
//STRIP001 					{
//STRIP001 						if ( pList && ( pList->GetCount() > nC ) )
//STRIP001 						{
//STRIP001 							bValidGluePoint = sal_True;
//STRIP001 							nId = (sal_Int32)((*pList)[ (sal_uInt16)nC].GetId() + 4 );
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							sal_uInt32 nObjId = pO->GetObjIdentifier();
//STRIP001 							switch( nObjId )
//STRIP001 							{
//STRIP001 								case OBJ_GRUP :
//STRIP001 								case OBJ_GRAF :
//STRIP001 								case OBJ_RECT :
//STRIP001 								case OBJ_TEXT :
//STRIP001 								case OBJ_PAGE :
//STRIP001 								case OBJ_TEXTEXT :
//STRIP001 								case OBJ_wegFITTEXT :
//STRIP001 								case OBJ_wegFITALLTEXT :
//STRIP001 								case OBJ_TITLETEXT :
//STRIP001 								case OBJ_OUTLINETEXT :
//STRIP001 								{
//STRIP001 									if ( nC & 1 ) 
//STRIP001 									{
//STRIP001 										if ( nSpFlags & SP_FFLIPH )
//STRIP001 											nC ^= 2;    // 1 <-> 3
//STRIP001 									}
//STRIP001 									else
//STRIP001 									{
//STRIP001 										if ( nSpFlags & SP_FFLIPV )
//STRIP001 											nC ^= 1;    // 0 <-> 2
//STRIP001 									}
//STRIP001 									switch( nC )
//STRIP001 									{
//STRIP001 										case 0 :
//STRIP001 											nId = 0;	// SDRVERTALIGN_TOP;
//STRIP001 										break;
//STRIP001 										case 1 :
//STRIP001 											nId = 3;	// SDRHORZALIGN_RIGHT;
//STRIP001 										break;
//STRIP001 										case 2 :
//STRIP001 											nId = 2;	// SDRVERTALIGN_BOTTOM;
//STRIP001 										break;
//STRIP001 										case 3 :
//STRIP001 											nId = 1; // SDRHORZALIGN_LEFT;
//STRIP001 										break;
//STRIP001 									}
//STRIP001 									if ( nId <= 3 )
//STRIP001 										bValidGluePoint = sal_True;
//STRIP001 								}
//STRIP001 								break;
//STRIP001 								case OBJ_POLY :
//STRIP001 								case OBJ_PLIN :
//STRIP001 								case OBJ_LINE :
//STRIP001 								case OBJ_PATHLINE :
//STRIP001 								case OBJ_PATHFILL :
//STRIP001 								case OBJ_FREELINE :
//STRIP001 								case OBJ_FREEFILL :
//STRIP001 								case OBJ_SPLNLINE :
//STRIP001 								case OBJ_SPLNFILL :
//STRIP001 								case OBJ_PATHPOLY :
//STRIP001 								case OBJ_PATHPLIN :
//STRIP001 								{
//STRIP001 									sal_Bool bNotFound = sal_True;
//STRIP001 
//STRIP001 									PolyPolygon aPolyPoly( EscherPropertyContainer::GetPolyPolygon( aXShape ) );
//STRIP001 									sal_uInt16 i, j, nPolySize = aPolyPoly.Count();
//STRIP001 									if ( nPolySize )
//STRIP001 									{
//STRIP001 										sal_uInt32  nPointCount = 0;
//STRIP001 										Rectangle aBoundRect( aPolyPoly.GetBoundRect() );                                    
//STRIP001 										if ( aBoundRect.GetWidth() && aBoundRect.GetHeight() )
//STRIP001 										{
//STRIP001 											for ( i = 0; bNotFound && ( i < nPolySize ); i++ )
//STRIP001 											{
//STRIP001 												const Polygon& rPolygon = aPolyPoly.GetObject( i );
//STRIP001 												for ( j = 0; bNotFound && ( j < rPolygon.GetSize() ); j++ )
//STRIP001 												{
//STRIP001 													PolyFlags eFlags = rPolygon.GetFlags( j );
//STRIP001 													if ( eFlags == POLY_NORMAL )
//STRIP001 													{
//STRIP001 														if ( nC == nPointCount )
//STRIP001 														{
//STRIP001 															const Point& rPoint = rPolygon.GetPoint( j );
//STRIP001 															double fXRel = rPoint.X() - aBoundRect.Left();
//STRIP001 															double fYRel = rPoint.Y() - aBoundRect.Top();
//STRIP001 															fXRel = fXRel / aBoundRect.GetWidth() * 10000;
//STRIP001 															fYRel = fYRel / aBoundRect.GetHeight() * 10000;
//STRIP001 															aGluePoint.SetPos( Point( (sal_Int32)fXRel, (sal_Int32)fYRel ) );
//STRIP001 															aGluePoint.SetPercent( sal_True );
//STRIP001 															aGluePoint.SetAlign( SDRVERTALIGN_TOP | SDRHORZALIGN_LEFT );
//STRIP001 															aGluePoint.SetEscDir( SDRESC_SMART );
//STRIP001 															nId = (sal_Int32)((*pList)[ pList->Insert( aGluePoint ) ].GetId() + 4 );
//STRIP001 															bNotFound = sal_False;
//STRIP001 														}
//STRIP001 														nPointCount++;
//STRIP001 													}    
//STRIP001 												}
//STRIP001 											}
//STRIP001 										}
//STRIP001 									}
//STRIP001 									if ( !bNotFound )
//STRIP001 									{
//STRIP001 										bValidGluePoint = sal_True;
//STRIP001 									}
//STRIP001 								}
//STRIP001 								break;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						if ( bValidGluePoint )
//STRIP001 						{
//STRIP001 							Reference< XPropertySet > xPropSet( aXConnector, UNO_QUERY );
//STRIP001 							if ( xPropSet.is() )
//STRIP001 							{
//STRIP001 								if ( nN )
//STRIP001 								{
//STRIP001 									String aPropName( RTL_CONSTASCII_USTRINGPARAM( "EndShape" ) );
//STRIP001 									aAny <<= aXShape;
//STRIP001 									SetPropValue( aAny, xPropSet, aPropName, sal_True );
//STRIP001 									aPropName  = String( RTL_CONSTASCII_USTRINGPARAM( "EndGluePointIndex" ) );
//STRIP001 									aAny <<= nId;
//STRIP001 									SetPropValue( aAny, xPropSet, aPropName, sal_True );
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									String aPropName( RTL_CONSTASCII_USTRINGPARAM( "StartShape" ) );
//STRIP001 									aAny <<= aXShape;
//STRIP001 									SetPropValue( aAny, xPropSet, aPropName, sal_True );
//STRIP001 									aPropName = String( RTL_CONSTASCII_USTRINGPARAM( "StartGluePointIndex" ) );
//STRIP001 									aAny <<= nId;
//STRIP001 									SetPropValue( aAny, xPropSet, aPropName, sal_True );
//STRIP001 								}
//STRIP001 								pO->SendRepaintBroadcast();
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 static void GetLineArrow( const sal_Int32 nLineWidth, const MSO_LineEnd eLineEnd,
//STRIP001 							const MSO_LineEndWidth eLineWidth, const MSO_LineEndLength eLineLenght,
//STRIP001 								sal_Int32& rnArrowWidth, XPolygon& rXPoly, sal_Bool& rbArrowCenter,
//STRIP001 									String& rsArrowName )
//STRIP001 {
//STRIP001 	double		fLineWidth = nLineWidth < 70 ? 70.0 : nLineWidth;
//STRIP001 	double		fLenghtMul, fWidthMul;
//STRIP001 	sal_Int32	nLineNumber;
//STRIP001 	switch( eLineLenght )
//STRIP001 	{
//STRIP001 		default :
//STRIP001 		case mso_lineMediumLenArrow		: fLenghtMul = 3.0; nLineNumber = 2; break;
//STRIP001 		case mso_lineShortArrow			: fLenghtMul = 2.0; nLineNumber = 1; break;
//STRIP001 		case mso_lineLongArrow			: fLenghtMul = 5.0; nLineNumber = 3; break;
//STRIP001 	}
//STRIP001 	switch( eLineWidth )
//STRIP001 	{
//STRIP001 		default :
//STRIP001 		case mso_lineMediumWidthArrow	: fWidthMul = 3.0; nLineNumber += 3; break;
//STRIP001 		case mso_lineNarrowArrow		: fWidthMul = 2.0; break;
//STRIP001 		case mso_lineWideArrow			: fWidthMul = 5.0; nLineNumber += 6; break;
//STRIP001 	}
//STRIP001 	rbArrowCenter = sal_False;
//STRIP001 	switch ( eLineEnd )
//STRIP001 	{
//STRIP001 		case mso_lineArrowEnd :
//STRIP001 		{
//STRIP001 			XPolygon aTriangle( 4 );
//STRIP001 			aTriangle[ 0 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), 0 );
//STRIP001 			aTriangle[ 1 ] = Point( (sal_Int32)( fWidthMul * fLineWidth ), (sal_Int32)( fLenghtMul * fLineWidth ) );
//STRIP001 			aTriangle[ 2 ] = Point( 0, (sal_Int32)( fLenghtMul * fLineWidth ) );
//STRIP001 			aTriangle[ 3 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), 0 );
//STRIP001 			rXPoly = aTriangle;
//STRIP001 			rsArrowName = String( RTL_CONSTASCII_STRINGPARAM( "msArrowEnd " ), RTL_TEXTENCODING_UTF8 );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case mso_lineArrowOpenEnd :
//STRIP001 		{
//STRIP001 			switch( eLineLenght )
//STRIP001 			{
//STRIP001 				default :
//STRIP001 				case mso_lineMediumLenArrow		: fLenghtMul = 4.5; break;
//STRIP001 				case mso_lineShortArrow			: fLenghtMul = 3.5; break;
//STRIP001 				case mso_lineLongArrow			: fLenghtMul = 6.0; break;
//STRIP001 			}
//STRIP001 			switch( eLineWidth )
//STRIP001 			{
//STRIP001 				default :
//STRIP001 				case mso_lineMediumWidthArrow	: fWidthMul = 4.5; break;
//STRIP001 				case mso_lineNarrowArrow		: fWidthMul = 3.5; break;
//STRIP001 				case mso_lineWideArrow			: fWidthMul = 6.0; break;
//STRIP001 			}
//STRIP001 			XPolygon aTriangle( 7 );
//STRIP001 			aTriangle[ 0 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), 0 );
//STRIP001 			aTriangle[ 1 ] = Point( (sal_Int32)( fWidthMul * fLineWidth ), (sal_Int32)( fLenghtMul * fLineWidth * 0.91 ) );
//STRIP001 			aTriangle[ 2 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.85 ), (sal_Int32)( fLenghtMul * fLineWidth ) );
//STRIP001 			aTriangle[ 3 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), (sal_Int32)( fLenghtMul * fLineWidth * 0.36 ) );
//STRIP001 			aTriangle[ 4 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.15 ), (sal_Int32)( fLenghtMul * fLineWidth ) );
//STRIP001 			aTriangle[ 5 ] = Point( 0, (sal_Int32)( fLenghtMul * fLineWidth * 0.91 ) );
//STRIP001 			aTriangle[ 6 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), 0 );
//STRIP001 			rXPoly = aTriangle;
//STRIP001 			rsArrowName = String( RTL_CONSTASCII_STRINGPARAM( "msArrowOpenEnd " ), RTL_TEXTENCODING_UTF8 );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case mso_lineArrowStealthEnd :
//STRIP001 		{
//STRIP001 			XPolygon aTriangle( 5 );
//STRIP001 			aTriangle[ 0 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), 0 );
//STRIP001 			aTriangle[ 1 ] = Point( (sal_Int32)( fWidthMul * fLineWidth ), (sal_Int32)( fLenghtMul * fLineWidth ) );
//STRIP001 			aTriangle[ 2 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), (sal_Int32)( fLenghtMul * fLineWidth * 0.60 ) );
//STRIP001 			aTriangle[ 3 ] = Point( 0, (sal_Int32)( fLenghtMul * fLineWidth ) );
//STRIP001 			aTriangle[ 4 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), 0 );
//STRIP001 			rXPoly = aTriangle;
//STRIP001 			rsArrowName = String( RTL_CONSTASCII_STRINGPARAM( "msArrowStealthEnd " ), RTL_TEXTENCODING_UTF8 );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case mso_lineArrowDiamondEnd :
//STRIP001 		{
//STRIP001 			XPolygon aTriangle( 5 );
//STRIP001 			aTriangle[ 0 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), 0 );
//STRIP001 			aTriangle[ 1 ] = Point( (sal_Int32)( fWidthMul * fLineWidth ), (sal_Int32)( fLenghtMul * fLineWidth * 0.50 ) );
//STRIP001 			aTriangle[ 2 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), (sal_Int32)( fLenghtMul * fLineWidth ) );
//STRIP001 			aTriangle[ 3 ] = Point( 0, (sal_Int32)( fLenghtMul * fLineWidth * 0.50 ) );
//STRIP001 			aTriangle[ 4 ] = Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), 0 );
//STRIP001 			rXPoly = aTriangle;
//STRIP001 			rbArrowCenter = sal_True;
//STRIP001 			rsArrowName = String( RTL_CONSTASCII_STRINGPARAM( "msArrowDiamondEnd " ), RTL_TEXTENCODING_UTF8 );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case mso_lineArrowOvalEnd :
//STRIP001 		{
//STRIP001 			rXPoly = XPolygon( Point( (sal_Int32)( fWidthMul * fLineWidth * 0.50 ), 0 ),
//STRIP001 								(sal_Int32)( fWidthMul * fLineWidth * 0.50 ),
//STRIP001 									(sal_Int32)( fLenghtMul * fLineWidth * 0.50 ), 0, 3600 );
//STRIP001 			rbArrowCenter = sal_True;
//STRIP001 			rsArrowName = String( RTL_CONSTASCII_STRINGPARAM( "msArrowOvalEnd " ), RTL_TEXTENCODING_UTF8 );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	rsArrowName.Append( String::CreateFromInt32( nLineNumber ) );
//STRIP001 	rnArrowWidth = (sal_Int32)( fLineWidth * fWidthMul );
//STRIP001 }
//STRIP001 
//STRIP001 void DffPropertyReader::ApplyAttributes( SvStream& rIn, SfxItemSet& rSet, SdrObject* pObj ) const
//STRIP001 {
//STRIP001 	MapUnit eMap( rManager.GetModel()->GetScaleUnit() );
//STRIP001 
//STRIP001 	for ( void* pDummy = ((DffPropertyReader*)this)->First(); pDummy; pDummy = ((DffPropertyReader*)this)->Next() )
//STRIP001 	{
//STRIP001 		UINT32 nRecType = GetCurKey();
//STRIP001 		UINT32 nContent = mpContents[ nRecType ];
//STRIP001 		switch ( nRecType )
//STRIP001 		{
//STRIP001 			case DFF_Prop_gtextSize :
//STRIP001 				rSet.Put( SvxFontHeightItem( rManager.ScalePt( nContent ) ) );
//STRIP001 			break;
//STRIP001 			// GeoText
//STRIP001 			case DFF_Prop_gtextFStrikethrough :
//STRIP001 			{
//STRIP001 				if ( nContent & 0x20 )
//STRIP001 					rSet.Put( SvxWeightItem( nContent ? WEIGHT_BOLD : WEIGHT_NORMAL ) );
//STRIP001 				if ( nContent & 0x10 )
//STRIP001 					rSet.Put( SvxPostureItem( nContent ? ITALIC_NORMAL : ITALIC_NONE ) );
//STRIP001 				if ( nContent & 0x08 )
//STRIP001 					rSet.Put( SvxUnderlineItem( nContent ? UNDERLINE_SINGLE : UNDERLINE_NONE ) );
//STRIP001 				if ( nContent & 0x40 )
//STRIP001 					rSet.Put(SvxShadowedItem( nContent != 0 ) );
//STRIP001 //				if ( nContent & 0x02 )
//STRIP001 //					rSet.Put( SvxCaseMapItem( nContent ? SVX_CASEMAP_KAPITAELCHEN : SVX_CASEMAP_NOT_MAPPED ) );
//STRIP001 				if ( nContent & 0x01 )
//STRIP001 					rSet.Put( SvxCrossedOutItem( nContent ? STRIKEOUT_SINGLE : STRIKEOUT_NONE ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case DFF_Prop_fillColor :
//STRIP001 				rSet.Put( XFillColorItem( String(), rManager.MSO_CLR_ToColor( nContent, DFF_Prop_fillColor ) ) );
//STRIP001 			break;
//STRIP001 
//STRIP001 			// ShadowStyle
//STRIP001 			case DFF_Prop_shadowType :
//STRIP001 			{
//STRIP001 				MSO_ShadowType eShadowType = (MSO_ShadowType)nContent;
//STRIP001 				if( eShadowType != mso_shadowOffset )
//STRIP001 				{
//STRIP001 					//   mso_shadowDouble
//STRIP001 					//   mso_shadowRich
//STRIP001 					//   mso_shadowEmbossOrEngrave
//STRIP001 					// koennen wir nicht, kreiere Default-Schatten mit default-
//STRIP001 					// Abstand
//STRIP001 					rSet.Put( SdrShadowXDistItem( 35 ) ); // 0,35 mm Schattendistanz
//STRIP001 					rSet.Put( SdrShadowYDistItem( 35 ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case DFF_Prop_shadowColor :
//STRIP001 				rSet.Put( SdrShadowColorItem( String(), rManager.MSO_CLR_ToColor( nContent, DFF_Prop_shadowColor ) ) );
//STRIP001 			break;
//STRIP001             case DFF_Prop_shadowOpacity :
//STRIP001                 rSet.Put( SdrShadowTransparenceItem( (sal_uInt16)( nContent / 655 ) ) );
//STRIP001             break;
//STRIP001 			case DFF_Prop_shadowOffsetX :
//STRIP001 			{
//STRIP001 				INT32 nVal = (INT32)nContent;
//STRIP001 				rManager.ScaleEmu( nVal );
//STRIP001 				if ( nVal )
//STRIP001 					rSet.Put( SdrShadowXDistItem( nVal ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case DFF_Prop_shadowOffsetY :
//STRIP001 			{
//STRIP001 				INT32 nVal = (INT32)nContent;
//STRIP001 				rManager.ScaleEmu( nVal );
//STRIP001 				if ( nVal )
//STRIP001 					rSet.Put( SdrShadowYDistItem( nVal ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case DFF_Prop_fshadowObscured :
//STRIP001             {
//STRIP001                 sal_Bool bHasShadow = ( nContent & 2 ) != 0;
//STRIP001 				rSet.Put( SdrShadowItem( bHasShadow ) );
//STRIP001 				if ( bHasShadow )
//STRIP001                 {
//STRIP001 					if ( !IsProperty( DFF_Prop_shadowOffsetX ) )
//STRIP001 						rSet.Put( SdrShadowXDistItem( 35 ) );
//STRIP001 					if ( !IsProperty( DFF_Prop_shadowOffsetY ) )
//STRIP001 						rSet.Put( SdrShadowYDistItem( 35 ) );
//STRIP001                 }
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			// Protection
//STRIP001 			case DFF_Prop_LockPosition :
//STRIP001 			{
//STRIP001 				if ( pObj )
//STRIP001 					pObj->SetMoveProtect( nContent != 0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case DFF_Prop_LockAgainstSelect :
//STRIP001 			{
//STRIP001 				if ( pObj )
//STRIP001 					pObj->SetMarkProtect( nContent != 0 );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	UINT32 nLineFlags = GetPropertyValue( DFF_Prop_fNoLineDrawDash );
//STRIP001 	if ( nLineFlags & 8 )
//STRIP001 	{
//STRIP001 		// Linienattribute
//STRIP001 		sal_Int32 nLineWidth = (INT32)GetPropertyValue( DFF_Prop_lineWidth, 9525 );
//STRIP001 
//STRIP001 		MSO_LineDashing eLineDashing = (MSO_LineDashing)GetPropertyValue( DFF_Prop_lineDashing, mso_lineSolid );
//STRIP001 		if ( eLineDashing == mso_lineSolid )
//STRIP001 			rSet.Put(XLineStyleItem( XLINE_SOLID ) );
//STRIP001 		else
//STRIP001 		{
//STRIP001 //			MSO_LineCap eLineCap = (MSO_LineCap)GetPropertyValue( DFF_Prop_lineEndCapStyle, mso_lineEndCapSquare );
//STRIP001 
//STRIP001 			XDashStyle  eDash = XDASH_RECT;
//STRIP001 			sal_uInt16	nDots = 1;
//STRIP001 			sal_uInt32	nDotLen	= nLineWidth / 360;
//STRIP001 			sal_uInt16	nDashes = 0;
//STRIP001 			sal_uInt32	nDashLen = ( 8 * nLineWidth ) / 360;
//STRIP001 			sal_uInt32	nDistance = ( 3 * nLineWidth ) / 360;;
//STRIP001 
//STRIP001 			switch ( eLineDashing )
//STRIP001 			{
//STRIP001 				default:
//STRIP001 				case mso_lineDotSys :
//STRIP001 				{
//STRIP001 					nDots = 1;
//STRIP001 					nDashes = 0;
//STRIP001 					nDistance = nDotLen;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case mso_lineDashGEL :
//STRIP001 				{
//STRIP001 					nDots = 0;
//STRIP001 					nDashes = 1;
//STRIP001 					nDashLen = ( 4 * nLineWidth ) / 360;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case mso_lineDashDotGEL :
//STRIP001 				{
//STRIP001 					nDots = 1;
//STRIP001 					nDashes = 1;
//STRIP001 					nDashLen = ( 4 * nLineWidth ) / 360;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case mso_lineLongDashGEL :
//STRIP001 				{
//STRIP001 					nDots = 0;
//STRIP001 					nDashes = 1;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case mso_lineLongDashDotGEL :
//STRIP001 				{
//STRIP001 					nDots = 1;
//STRIP001 					nDashes = 1;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 				case mso_lineLongDashDotDotGEL:
//STRIP001 				{
//STRIP001 					nDots = 2;
//STRIP001 					nDashes = 1;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			rSet.Put( XLineDashItem( String(), XDash( eDash, nDots, nDotLen, nDashes, nDashLen, nDistance ) ) );
//STRIP001 			rSet.Put( XLineStyleItem( XLINE_DASH ) );
//STRIP001 		}
//STRIP001 		rSet.Put( XLineColorItem( String(), rManager.MSO_CLR_ToColor( GetPropertyValue( DFF_Prop_lineColor ), DFF_Prop_lineColor ) ) );
//STRIP001 		if ( IsProperty( DFF_Prop_lineOpacity ) )
//STRIP001         {
//STRIP001 			double nTrans = GetPropertyValue(DFF_Prop_lineOpacity, 0x10000);
//STRIP001             nTrans = (nTrans * 100) / 65536;
//STRIP001 			rSet.Put(XLineTransparenceItem(
//STRIP001                 sal_uInt16(100 - ::rtl::math::round(nTrans))));
//STRIP001         }
//STRIP001 
//STRIP001 		rManager.ScaleEmu( nLineWidth );
//STRIP001 		rSet.Put( XLineWidthItem( nLineWidth ) );
//STRIP001 
//STRIP001 		if ( nLineFlags & 0x10 )
//STRIP001 		{
//STRIP001 			///////////////
//STRIP001 			// LineStart //
//STRIP001 			///////////////
//STRIP001 			if ( IsProperty( DFF_Prop_lineStartArrowhead ) )
//STRIP001 			{
//STRIP001 				MSO_LineEnd			eLineEnd = (MSO_LineEnd)GetPropertyValue( DFF_Prop_lineStartArrowhead );
//STRIP001 				MSO_LineEndWidth	eWidth = (MSO_LineEndWidth)GetPropertyValue( DFF_Prop_lineStartArrowWidth, mso_lineMediumWidthArrow );
//STRIP001 				MSO_LineEndLength	eLenght = (MSO_LineEndLength)GetPropertyValue( DFF_Prop_lineStartArrowLength, mso_lineMediumLenArrow );
//STRIP001 
//STRIP001 				XPolygon	aPoly;
//STRIP001 				sal_Int32	nArrowWidth;
//STRIP001 				sal_Bool	bArrowCenter;
//STRIP001 				String		aArrowName;
//STRIP001 				GetLineArrow( nLineWidth, eLineEnd, eWidth, eLenght, nArrowWidth, aPoly, bArrowCenter, aArrowName );
//STRIP001 
//STRIP001 				rSet.Put( XLineStartWidthItem( nArrowWidth ) );
//STRIP001 				rSet.Put( XLineStartItem( aArrowName, aPoly ) );
//STRIP001 				rSet.Put( XLineStartCenterItem( bArrowCenter ) );
//STRIP001 			}
//STRIP001 			/////////////
//STRIP001 			// LineEnd //
//STRIP001 			/////////////
//STRIP001 			if ( IsProperty( DFF_Prop_lineEndArrowhead ) )
//STRIP001 			{
//STRIP001 				MSO_LineEnd			eLineEnd = (MSO_LineEnd)GetPropertyValue( DFF_Prop_lineEndArrowhead );
//STRIP001 				MSO_LineEndWidth	eWidth = (MSO_LineEndWidth)GetPropertyValue( DFF_Prop_lineEndArrowWidth, mso_lineMediumWidthArrow );
//STRIP001 				MSO_LineEndLength	eLenght = (MSO_LineEndLength)GetPropertyValue( DFF_Prop_lineEndArrowLength, mso_lineMediumLenArrow );
//STRIP001 
//STRIP001 				XPolygon	aPoly;
//STRIP001 				sal_Int32	nArrowWidth;
//STRIP001 				sal_Bool	bArrowCenter;
//STRIP001 				String		aArrowName;
//STRIP001 				GetLineArrow( nLineWidth, eLineEnd, eWidth, eLenght, nArrowWidth, aPoly, bArrowCenter, aArrowName );
//STRIP001 
//STRIP001 				rSet.Put( XLineEndWidthItem( nArrowWidth ) );
//STRIP001 				rSet.Put( XLineEndItem( aArrowName, aPoly ) );
//STRIP001 				rSet.Put( XLineEndCenterItem( bArrowCenter ) );
//STRIP001 			}
//STRIP001 			if ( IsProperty( DFF_Prop_lineEndCapStyle ) )
//STRIP001 			{
//STRIP001 				MSO_LineCap eLineCap = (MSO_LineCap)GetPropertyValue( DFF_Prop_lineEndCapStyle );
//STRIP001 				const SfxPoolItem* pPoolItem = NULL;
//STRIP001 				if ( rSet.GetItemState( XATTR_LINEDASH, FALSE, &pPoolItem ) == SFX_ITEM_SET )
//STRIP001 				{
//STRIP001 					XDashStyle eNewStyle = XDASH_RECT;
//STRIP001 					if ( eLineCap == mso_lineEndCapRound )
//STRIP001 						eNewStyle = XDASH_ROUND;
//STRIP001 					const XDash& rOldDash = ( (const XLineDashItem*)pPoolItem )->GetValue();
//STRIP001 					if ( rOldDash.GetDashStyle() != eNewStyle )
//STRIP001 					{
//STRIP001 						XDash aNew( rOldDash );
//STRIP001 						aNew.SetDashStyle( eNewStyle );
//STRIP001 						rSet.Put( XLineDashItem( XubString(), aNew ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rSet.Put( XLineStyleItem( XLINE_NONE ) );
//STRIP001 
//STRIP001 	if ( GetPropertyValue( DFF_Prop_fNoFillHitTest ) & 0x10 )
//STRIP001 	{
//STRIP001 		MSO_FillType eMSO_FillType = (MSO_FillType)GetPropertyValue( DFF_Prop_fillType, mso_fillSolid );
//STRIP001 		XFillStyle eXFill = XFILL_NONE;
//STRIP001 		switch( eMSO_FillType )
//STRIP001 		{
//STRIP001 			case mso_fillSolid :			// Fill with a solid color
//STRIP001 				eXFill = XFILL_SOLID;
//STRIP001 			break;
//STRIP001 			case mso_fillPattern :			// Fill with a pattern (bitmap)
//STRIP001 			case mso_fillTexture :			// A texture (pattern with its own color map)
//STRIP001 			case mso_fillPicture :			// Center a picture in the shape
//STRIP001 				eXFill = XFILL_BITMAP;
//STRIP001 			break;
//STRIP001 			case mso_fillShade :			// Shade from start to end points
//STRIP001 			case mso_fillShadeCenter :		// Shade from bounding rectangle to end point
//STRIP001 			case mso_fillShadeShape :		// Shade from shape outline to end point
//STRIP001 			case mso_fillShadeScale :		// Similar to mso_fillShade, but the fillAngle
//STRIP001 			case mso_fillShadeTitle :		// special type - shade to title ---  for PP
//STRIP001 				eXFill = XFILL_GRADIENT;
//STRIP001 			break;
//STRIP001 //			case mso_fillBackground	:		// Use the background fill color/pattern
//STRIP001 		}
//STRIP001 		rSet.Put( XFillStyleItem( eXFill ) );
//STRIP001 
//STRIP001         if (IsProperty(DFF_Prop_fillOpacity))
//STRIP001         {
//STRIP001 			double nTrans = GetPropertyValue(DFF_Prop_fillOpacity);
//STRIP001             nTrans = (nTrans * 100) / 65536;
//STRIP001 			rSet.Put(XFillTransparenceItem(
//STRIP001                 sal_uInt16(100 - ::rtl::math::round(nTrans))));
//STRIP001         }
//STRIP001 
//STRIP001 		if ( eXFill == XFILL_GRADIENT )
//STRIP001 		{
//STRIP001 			sal_Int32 nAngle = 3600 - ( ( Fix16ToAngle( GetPropertyValue( DFF_Prop_fillAngle, 0 ) ) + 5 ) / 10 );
//STRIP001 
//STRIP001 			// Rotationswinkel in Bereich zwingen
//STRIP001 			while ( nAngle >= 3600 )
//STRIP001 				nAngle -= 3600;
//STRIP001 			while ( nAngle < 0 )
//STRIP001 				nAngle += 3600;
//STRIP001 
//STRIP001 			sal_Int32 nFocus = GetPropertyValue( DFF_Prop_fillFocus, 0 );
//STRIP001 			XGradientStyle eGrad = XGRAD_LINEAR;
//STRIP001 			sal_Int32 nChgColors = 0;
//STRIP001 
//STRIP001 			if ( !nAngle )
//STRIP001 				nChgColors ^= 1;
//STRIP001 
//STRIP001 			if ( !nFocus )
//STRIP001 				nChgColors ^= 1;
//STRIP001 			else if ( nFocus < 0 )		// Bei negativem Focus sind die Farben zu tauschen
//STRIP001 			{
//STRIP001 				nFocus =- nFocus;
//STRIP001 				nChgColors ^= 1;
//STRIP001 			}
//STRIP001 			if( nFocus > 40 && nFocus < 60 )
//STRIP001 			{
//STRIP001 				eGrad = XGRAD_AXIAL;	// Besser gehts leider nicht
//STRIP001 				nChgColors ^= 1;
//STRIP001 			}
//STRIP001 			USHORT nFocusX = (USHORT)nFocus;
//STRIP001 			USHORT nFocusY = (USHORT)nFocus;
//STRIP001 
//STRIP001 			switch( eMSO_FillType )
//STRIP001 			{
//STRIP001 				case mso_fillShadeShape :
//STRIP001 				{
//STRIP001 					eGrad = XGRAD_RECT;
//STRIP001 					nFocusY = nFocusX = 50;
//STRIP001 					nChgColors ^= 1;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case mso_fillShadeCenter :
//STRIP001 				{
//STRIP001 					eGrad = XGRAD_RECT;
//STRIP001 					nFocusX = ( IsProperty( DFF_Prop_fillToRight ) ) ? 100 : 0;
//STRIP001 					nFocusY = ( IsProperty( DFF_Prop_fillToBottom ) ) ? 100 : 0;
//STRIP001 					nChgColors ^= 1;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			Color aCol1( rManager.MSO_CLR_ToColor( GetPropertyValue( DFF_Prop_fillColor, COL_WHITE ), DFF_Prop_fillColor ) );
//STRIP001 			Color aCol2( rManager.MSO_CLR_ToColor( GetPropertyValue( DFF_Prop_fillBackColor, COL_WHITE ), DFF_Prop_fillBackColor ) );
//STRIP001 
//STRIP001 			if ( nChgColors )
//STRIP001 			{
//STRIP001 				Color aZwi( aCol1 );
//STRIP001 				aCol1 = aCol2;
//STRIP001 				aCol2 = aZwi;
//STRIP001 			}
//STRIP001 			XGradient aGrad( aCol2, aCol1, eGrad, nAngle, nFocusX, nFocusY );
//STRIP001 			aGrad.SetStartIntens( 100 );
//STRIP001 			aGrad.SetEndIntens( 100 );
//STRIP001 			rSet.Put( XFillGradientItem( String(), aGrad ) );
//STRIP001 		}
//STRIP001 		else if ( eXFill == XFILL_BITMAP )
//STRIP001 		{
//STRIP001 			if( IsProperty( DFF_Prop_fillBlip ) )
//STRIP001 			{
//STRIP001 				Graphic aGraf;
//STRIP001                 // first try to get BLIP from cache
//STRIP001                 BOOL bOK = rManager.GetBLIP( GetPropertyValue( DFF_Prop_fillBlip ), aGraf );
//STRIP001                 // then try directly from stream (i.e. Excel chart hatches/bitmaps)
//STRIP001                 if ( !bOK )
//STRIP001                     bOK = SeekToContent( DFF_Prop_fillBlip, rIn ) && rManager.GetBLIPDirect( rIn, aGraf );
//STRIP001                 if ( bOK )
//STRIP001 				{
//STRIP001 					Bitmap aBmp( aGraf.GetBitmap() );
//STRIP001 
//STRIP001 					if ( eMSO_FillType == mso_fillPattern )
//STRIP001 					{
//STRIP001 						Color aCol1( COL_WHITE ), aCol2( COL_WHITE );
//STRIP001 						if ( IsProperty( DFF_Prop_fillColor ) )
//STRIP001 							aCol1 = rManager.MSO_CLR_ToColor( GetPropertyValue( DFF_Prop_fillColor ), DFF_Prop_fillColor );
//STRIP001 						if ( IsProperty( DFF_Prop_fillBackColor ) )
//STRIP001 							aCol2 = rManager.MSO_CLR_ToColor( GetPropertyValue( DFF_Prop_fillBackColor ), DFF_Prop_fillBackColor );
//STRIP001 
//STRIP001 						XOBitmap aXOBitmap;
//STRIP001 
//STRIP001 						// Bitmap einsetzen
//STRIP001 						aXOBitmap.SetBitmap( aBmp );
//STRIP001 						aXOBitmap.SetBitmapType( XBITMAP_IMPORT );
//STRIP001 
//STRIP001 						if( aBmp.GetSizePixel().Width() == 8 && aBmp.GetSizePixel().Height() == 8 && aBmp.GetColorCount() == 2)
//STRIP001 						{
//STRIP001 							aXOBitmap.Bitmap2Array();
//STRIP001 							aXOBitmap.SetBitmapType( XBITMAP_8X8 );
//STRIP001 							aXOBitmap.SetPixelSize( aBmp.GetSizePixel() );
//STRIP001 
//STRIP001 							if( aXOBitmap.GetBackgroundColor() == COL_BLACK )
//STRIP001 							{
//STRIP001 								aXOBitmap.SetPixelColor( aCol1 );
//STRIP001 								aXOBitmap.SetBackgroundColor( aCol2 );
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001 								aXOBitmap.SetPixelColor( aCol2 );
//STRIP001 								aXOBitmap.SetBackgroundColor( aCol1 );
//STRIP001 							}
//STRIP001 						}
//STRIP001 						rSet.Put( XFillBitmapItem( String(), aXOBitmap ) );
//STRIP001 					}
//STRIP001 					else if ( eMSO_FillType == mso_fillTexture )
//STRIP001 					{
//STRIP001 						XOBitmap aXBmp( aBmp, XBITMAP_STRETCH );
//STRIP001 						rSet.Put( XFillBmpTileItem( sal_True ) );
//STRIP001 						rSet.Put( XFillBitmapItem( String(), aXBmp ) );
//STRIP001 						rSet.Put( XFillBmpSizeXItem( GetPropertyValue( DFF_Prop_fillWidth, 0 ) / 360 ) );
//STRIP001 						rSet.Put( XFillBmpSizeYItem( GetPropertyValue( DFF_Prop_fillHeight, 0 ) / 360 ) );
//STRIP001 						rSet.Put( XFillBmpSizeLogItem( sal_True ) );
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						XOBitmap aXBmp( aBmp, XBITMAP_STRETCH );
//STRIP001 						rSet.Put( XFillBitmapItem( String(), aXBmp ) );
//STRIP001 						rSet.Put( XFillBmpTileItem( sal_False ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 }
//STRIP001 
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 //- Record Manager ----------------------------------------------------------
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 
//STRIP001 DffRecordList::DffRecordList( DffRecordList* pList ) :
//STRIP001 	nCount					( 0 ),
//STRIP001 	nCurrent				( 0 ),
//STRIP001 	pPrev					( pList ),
//STRIP001 	pNext					( NULL )
//STRIP001 {
//STRIP001 	if ( pList )
//STRIP001 		pList->pNext = this;
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordList::~DffRecordList()
//STRIP001 {
//STRIP001 	delete pNext;
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordManager::DffRecordManager() :
//STRIP001 	DffRecordList	( NULL ),
//STRIP001 	pCList			( (DffRecordList*)this )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordManager::DffRecordManager( SvStream& rIn ) :
//STRIP001 	DffRecordList	( NULL ),
//STRIP001 	pCList			( (DffRecordList*)this )
//STRIP001 {
//STRIP001 	Consume( rIn );
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordManager::~DffRecordManager()
//STRIP001 {
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 void DffRecordManager::Consume( SvStream& rIn, BOOL bAppend, UINT32 nStOfs )
//STRIP001 {
//STRIP001 	if ( !bAppend )
//STRIP001 		Clear();
//STRIP001 	UINT32 nOldPos = rIn.Tell();
//STRIP001 	if ( !nStOfs )
//STRIP001 	{
//STRIP001 		DffRecordHeader aHd;
//STRIP001 		rIn >> aHd;
//STRIP001 		if ( aHd.nRecVer == DFF_PSFLAG_CONTAINER )
//STRIP001 			nStOfs = aHd.GetRecEndFilePos();
//STRIP001 	}
//STRIP001 	if ( nStOfs )
//STRIP001 	{
//STRIP001 		pCList = (DffRecordList*)this;
//STRIP001 		while ( pCList->pNext )
//STRIP001 			pCList = pCList->pNext;
//STRIP001 		while ( ( rIn.GetError() == 0 ) && ( ( rIn.Tell() + 8 ) <=  nStOfs ) )
//STRIP001 		{
//STRIP001 			if ( pCList->nCount == DFF_RECORD_MANAGER_BUF_SIZE )
//STRIP001 				pCList = new DffRecordList( pCList );
//STRIP001 			rIn >> pCList->mHd[ pCList->nCount ];
//STRIP001 			pCList->mHd[ pCList->nCount++ ].SeekToEndOfRecord( rIn );
//STRIP001 		}
//STRIP001 		rIn.Seek( nOldPos );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void DffRecordManager::Clear()
//STRIP001 {
//STRIP001 	pCList = (DffRecordList*)this;
//STRIP001 	delete pNext, pNext = NULL;
//STRIP001 	nCurrent = 0;
//STRIP001 	nCount = 0;
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordHeader* DffRecordManager::Current()
//STRIP001 {
//STRIP001 	DffRecordHeader* pRet = NULL;
//STRIP001 	if ( pCList->nCurrent < pCList->nCount )
//STRIP001 		pRet = &pCList->mHd[ pCList->nCurrent ];
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordHeader* DffRecordManager::First()
//STRIP001 {
//STRIP001 	DffRecordHeader* pRet = NULL;
//STRIP001 	pCList = (DffRecordList*)this;
//STRIP001 	if ( pCList->nCount )
//STRIP001 	{
//STRIP001 		pCList->nCurrent = 0;
//STRIP001 		pRet = &pCList->mHd[ 0 ];
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordHeader* DffRecordManager::Next()
//STRIP001 {
//STRIP001 	DffRecordHeader* pRet = NULL;
//STRIP001 	UINT32 nC = pCList->nCurrent + 1;
//STRIP001 	if ( nC < pCList->nCount )
//STRIP001 	{
//STRIP001 		pCList->nCurrent++;
//STRIP001 		pRet = &pCList->mHd[ nC ];
//STRIP001 	}
//STRIP001 	else if ( pCList->pNext )
//STRIP001 	{
//STRIP001 		pCList = pCList->pNext;
//STRIP001 		pCList->nCurrent = 0;
//STRIP001 		pRet = &pCList->mHd[ 0 ];
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordHeader* DffRecordManager::Prev()
//STRIP001 {
//STRIP001 	DffRecordHeader* pRet = NULL;
//STRIP001 	UINT32 nCurrent = pCList->nCurrent;
//STRIP001 	if ( !nCurrent && pCList->pPrev )
//STRIP001 	{
//STRIP001 		pCList = pCList->pPrev;
//STRIP001 		nCurrent = pCList->nCount;
//STRIP001 	}
//STRIP001 	if ( nCurrent-- )
//STRIP001 	{
//STRIP001 		pCList->nCurrent = nCurrent;
//STRIP001 		pRet = &pCList->mHd[ nCurrent ];
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordHeader* DffRecordManager::Last()
//STRIP001 {
//STRIP001 	DffRecordHeader* pRet = NULL;
//STRIP001 	while ( pCList->pNext )
//STRIP001 		pCList = pCList->pNext;
//STRIP001 	UINT32 nCount = pCList->nCount;
//STRIP001 	if ( nCount-- )
//STRIP001 	{
//STRIP001 		pCList->nCurrent = nCount;
//STRIP001 		pRet = &pCList->mHd[ nCount ];
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL DffRecordManager::SeekToContent( SvStream& rIn, UINT16 nRecId, DffSeekToContentMode eMode )
//STRIP001 {
//STRIP001 	DffRecordHeader* pHd = GetRecordHeader( nRecId, eMode );
//STRIP001 	if ( pHd )
//STRIP001 	{
//STRIP001 		pHd->SeekToContent( rIn );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 DffRecordHeader* DffRecordManager::GetRecordHeader( UINT16 nRecId, DffSeekToContentMode eMode )
//STRIP001 {
//STRIP001 	UINT32 nOldCurrent = pCList->nCurrent;
//STRIP001 	DffRecordList* pOldList = pCList;
//STRIP001 	DffRecordHeader* pHd;
//STRIP001 
//STRIP001 	if ( eMode == SEEK_FROM_BEGINNING )
//STRIP001 		pHd = First();
//STRIP001 	else
//STRIP001 		pHd = Next();
//STRIP001 
//STRIP001 	while ( pHd )
//STRIP001 	{
//STRIP001 		if ( pHd->nRecType == nRecId )
//STRIP001 			break;
//STRIP001 		pHd = Next();
//STRIP001 	}
//STRIP001 	if ( !pHd && eMode == SEEK_FROM_CURRENT_AND_RESTART )
//STRIP001 	{
//STRIP001 		DffRecordHeader* pBreak = &pOldList->mHd[ nOldCurrent ];
//STRIP001 		pHd = First();
//STRIP001 		if ( pHd )
//STRIP001 		{
//STRIP001 			while ( pHd != pBreak )
//STRIP001 			{
//STRIP001 				if ( pHd->nRecType == nRecId )
//STRIP001 					break;
//STRIP001 				pHd = Next();
//STRIP001 			}
//STRIP001 			if ( pHd->nRecType != nRecId )
//STRIP001 				pHd = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( !pHd )
//STRIP001 	{
//STRIP001 		pCList = pOldList;
//STRIP001 		pOldList->nCurrent = nOldCurrent;
//STRIP001 	}
//STRIP001 	return pHd;
//STRIP001 }
//STRIP001 
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 //  private Methoden
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 
//STRIP001 struct EscherBlipCacheEntry
//STRIP001 {
//STRIP001 	ByteString	aUniqueID;
//STRIP001     sal_uInt32  nBlip;
//STRIP001 
//STRIP001     EscherBlipCacheEntry( sal_uInt32 nBlipId, const ByteString& rUniqueID ) :
//STRIP001         nBlip( nBlipId ),
//STRIP001         aUniqueID( rUniqueID ) {}
//STRIP001 };
//STRIP001 
//STRIP001 void SvxMSDffManager::Scale( long& rVal ) const
//STRIP001 {
//STRIP001 	if ( bNeedMap )
//STRIP001 		rVal = BigMulDiv( rVal, nMapMul, nMapDiv );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::Scale( Point& rPos ) const
//STRIP001 {
//STRIP001 	rPos.X() += nMapXOfs;
//STRIP001 	rPos.Y() += nMapYOfs;
//STRIP001 	if ( bNeedMap )
//STRIP001 	{
//STRIP001 		rPos.X() = BigMulDiv( rPos.X(), nMapMul, nMapDiv );
//STRIP001 		rPos.Y() = BigMulDiv( rPos.Y(), nMapMul, nMapDiv );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::Scale( Size& rSiz ) const
//STRIP001 {
//STRIP001 	if ( bNeedMap )
//STRIP001 	{
//STRIP001 		rSiz.Width() = BigMulDiv( rSiz.Width(), nMapMul, nMapDiv );
//STRIP001 		rSiz.Height() = BigMulDiv( rSiz.Height(), nMapMul, nMapDiv );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::Scale( Rectangle& rRect ) const
//STRIP001 {
//STRIP001 	rRect.Move( nMapXOfs, nMapYOfs );
//STRIP001 	if ( bNeedMap )
//STRIP001 	{
//STRIP001 		rRect.Left()  =BigMulDiv( rRect.Left()  , nMapMul, nMapDiv );
//STRIP001 		rRect.Top()   =BigMulDiv( rRect.Top()   , nMapMul, nMapDiv );
//STRIP001 		rRect.Right() =BigMulDiv( rRect.Right() , nMapMul, nMapDiv );
//STRIP001 		rRect.Bottom()=BigMulDiv( rRect.Bottom(), nMapMul, nMapDiv );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::Scale( Polygon& rPoly ) const
//STRIP001 {
//STRIP001 	if ( !bNeedMap )
//STRIP001 		return;
//STRIP001 	USHORT nPointAnz = rPoly.GetSize();
//STRIP001 	for ( USHORT nPointNum = 0; nPointNum < nPointAnz; nPointNum++ )
//STRIP001 		Scale( rPoly[ nPointNum ] );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::Scale( PolyPolygon& rPoly ) const
//STRIP001 {
//STRIP001 	if ( !bNeedMap )
//STRIP001 		return;
//STRIP001 	USHORT nPolyAnz = rPoly.Count();
//STRIP001 	for ( USHORT nPolyNum = 0; nPolyNum < nPolyAnz; nPolyNum++ )
//STRIP001 		Scale( rPoly[ nPolyNum ] );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::Scale( XPolygon& rPoly ) const
//STRIP001 {
//STRIP001 	if ( !bNeedMap )
//STRIP001 		return;
//STRIP001 	USHORT nPointAnz = rPoly.GetPointCount();
//STRIP001 	for ( USHORT nPointNum = 0; nPointNum < nPointAnz; nPointNum++ )
//STRIP001 		Scale( rPoly[ nPointNum ] );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::Scale( XPolyPolygon& rPoly ) const
//STRIP001 {
//STRIP001 	if ( !bNeedMap )
//STRIP001 		return;
//STRIP001 	USHORT nPolyAnz = rPoly.Count();
//STRIP001 	for ( USHORT nPolyNum = 0; nPolyNum < nPolyAnz; nPolyNum++ )
//STRIP001 		Scale( rPoly[ nPolyNum ] );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::ScaleEmu( long& rVal ) const
//STRIP001 {
//STRIP001 	rVal = BigMulDiv( rVal, nEmuMul, nEmuDiv );
//STRIP001 }
//STRIP001 
//STRIP001 UINT32 SvxMSDffManager::ScalePt( UINT32 nVal ) const
//STRIP001 {
//STRIP001 	MapUnit eMap = pSdrModel->GetScaleUnit();
//STRIP001 	Fraction aFact( GetMapFactor( MAP_POINT, eMap ).X() );
//STRIP001 	long aMul = aFact.GetNumerator();
//STRIP001 	long aDiv = aFact.GetDenominator() * 65536;
//STRIP001 	aFact = Fraction( aMul, aDiv ); // nochmal versuchen zu kuerzen
//STRIP001 	return BigMulDiv( nVal, aFact.GetNumerator(), aFact.GetDenominator() );
//STRIP001 }
//STRIP001 
//STRIP001 INT32 SvxMSDffManager::ScalePoint( INT32 nVal ) const
//STRIP001 {
//STRIP001 	return BigMulDiv( nVal, nPntMul, nPntDiv );
//STRIP001 };
//STRIP001 
//STRIP001 void SvxMSDffManager::SetModel(SdrModel* pModel, long nApplicationScale)
//STRIP001 {
//STRIP001 	pSdrModel = pModel;
//STRIP001 	if( pModel && (0 < nApplicationScale) )
//STRIP001 	{
//STRIP001 		// PPT arbeitet nur mit Einheiten zu 576DPI
//STRIP001 		// WW hingegen verwendet twips, dh. 1440DPI.
//STRIP001 		MapUnit eMap = pSdrModel->GetScaleUnit();
//STRIP001 		Fraction aFact( GetMapFactor(MAP_INCH, eMap).X() );
//STRIP001 		long nMul=aFact.GetNumerator();
//STRIP001 		long nDiv=aFact.GetDenominator()*nApplicationScale;
//STRIP001 		aFact=Fraction(nMul,nDiv); // nochmal versuchen zu kuerzen
//STRIP001 		// Bei 100TH_MM -> 2540/576=635/144
//STRIP001 		// Bei Twip     -> 1440/576=5/2
//STRIP001 		nMapMul  = aFact.GetNumerator();
//STRIP001 		nMapDiv  = aFact.GetDenominator();
//STRIP001 		bNeedMap = nMapMul!=nMapDiv;
//STRIP001 
//STRIP001 		// MS-DFF-Properties sind grossteils in EMU (English Metric Units) angegeben
//STRIP001 		// 1mm=36000emu, 1twip=635emu
//STRIP001 		aFact=GetMapFactor(MAP_100TH_MM,eMap).X();
//STRIP001 		nMul=aFact.GetNumerator();
//STRIP001 		nDiv=aFact.GetDenominator()*360;
//STRIP001 		aFact=Fraction(nMul,nDiv); // nochmal versuchen zu kuerzen
//STRIP001 		// Bei 100TH_MM ->                            1/360
//STRIP001 		// Bei Twip     -> 14,40/(25,4*360)=144/91440=1/635
//STRIP001 		nEmuMul=aFact.GetNumerator();
//STRIP001 		nEmuDiv=aFact.GetDenominator();
//STRIP001 
//STRIP001 		// Und noch was fuer typografische Points
//STRIP001 		aFact=GetMapFactor(MAP_POINT,eMap).X();
//STRIP001 		nPntMul=aFact.GetNumerator();
//STRIP001 		nPntDiv=aFact.GetDenominator();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pModel = 0;
//STRIP001 		nMapMul = nMapDiv = nMapXOfs = nMapYOfs = nEmuMul = nEmuDiv = nPntMul = nPntDiv = 0;
//STRIP001 		bNeedMap = FALSE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SvxMSDffManager::SeekToShape( SvStream& rSt, void* pClientData, UINT32 nId ) const
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if ( mpFidcls )
//STRIP001 	{
//STRIP001 		UINT32 nMerk = rSt.Tell();
//STRIP001 		UINT32 nShapeId, nSec = ( nId >> 10 ) - 1;
//STRIP001 		if ( nSec < mnIdClusters )
//STRIP001 		{
//STRIP001 			UINT32 nOfs = (UINT32)maDgOffsetTable.Get( mpFidcls[ nSec ].dgid );
//STRIP001 			if ( nOfs )
//STRIP001 			{
//STRIP001 				rSt.Seek( nOfs );
//STRIP001 				DffRecordHeader aEscherF002Hd;
//STRIP001 				rSt >> aEscherF002Hd;
//STRIP001 				ULONG nEscherF002End = aEscherF002Hd.GetRecEndFilePos();
//STRIP001 				DffRecordHeader aEscherObjListHd;
//STRIP001 				while ( rSt.Tell() < nEscherF002End )
//STRIP001 				{
//STRIP001 					rSt >> aEscherObjListHd;
//STRIP001 					if ( aEscherObjListHd.nRecVer != 0xf )
//STRIP001 						aEscherObjListHd.SeekToEndOfRecord( rSt );
//STRIP001 					else if ( aEscherObjListHd.nRecType == DFF_msofbtSpContainer )
//STRIP001 					{
//STRIP001 						DffRecordHeader aShapeHd;
//STRIP001 						if ( SeekToRec( rSt, DFF_msofbtSp, aEscherObjListHd.GetRecEndFilePos(), &aShapeHd ) )
//STRIP001 						{
//STRIP001 							rSt >> nShapeId;
//STRIP001 							if ( nId == nShapeId )
//STRIP001 							{
//STRIP001 								aEscherObjListHd.SeekToBegOfRecord( rSt );
//STRIP001 								bRet = TRUE;
//STRIP001 								break;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						aEscherObjListHd.SeekToEndOfRecord( rSt );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( !bRet )
//STRIP001 			rSt.Seek( nMerk );
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SvxMSDffManager::SeekToRec( SvStream& rSt, USHORT nRecId, ULONG nMaxFilePos, DffRecordHeader* pRecHd, ULONG nSkipCount ) const
//STRIP001 {
//STRIP001 	FASTBOOL bRet = FALSE;
//STRIP001 	ULONG nFPosMerk = rSt.Tell(); // FilePos merken fuer ggf. spaetere Restauration
//STRIP001 	DffRecordHeader aHd;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		rSt >> aHd;
//STRIP001 		if ( aHd.nRecType == nRecId )
//STRIP001 		{
//STRIP001 			if ( nSkipCount )
//STRIP001 				nSkipCount--;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				bRet = TRUE;
//STRIP001 				if ( pRecHd != NULL )
//STRIP001 					*pRecHd = aHd;
//STRIP001 				else
//STRIP001 					aHd.SeekToBegOfRecord( rSt );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( !bRet )
//STRIP001 			aHd.SeekToEndOfRecord( rSt );
//STRIP001 	}
//STRIP001 	while ( rSt.GetError() == 0 && rSt.Tell() < nMaxFilePos && !bRet );
//STRIP001 	if ( !bRet )
//STRIP001 		rSt.Seek( nFPosMerk );	// FilePos restaurieren
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SvxMSDffManager::SeekToRec2( USHORT nRecId1, USHORT nRecId2, ULONG nMaxFilePos, DffRecordHeader* pRecHd, ULONG nSkipCount ) const
//STRIP001 {
//STRIP001 	FASTBOOL bRet = FALSE;
//STRIP001 	ULONG nFPosMerk = rStCtrl.Tell();	// FilePos merken fuer ggf. spaetere Restauration
//STRIP001 	DffRecordHeader aHd;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		rStCtrl >> aHd;
//STRIP001 		if ( aHd.nRecType == nRecId1 || aHd.nRecType == nRecId2 )
//STRIP001 		{
//STRIP001 			if ( nSkipCount )
//STRIP001 				nSkipCount--;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				bRet = TRUE;
//STRIP001 				if ( pRecHd )
//STRIP001 					*pRecHd = aHd;
//STRIP001 				else
//STRIP001 					aHd.SeekToBegOfRecord( rStCtrl );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( !bRet )
//STRIP001 			aHd.SeekToEndOfRecord( rStCtrl );
//STRIP001 	}
//STRIP001 	while ( rStCtrl.GetError() == 0 && rStCtrl.Tell() < nMaxFilePos && !bRet );
//STRIP001 	if ( !bRet )
//STRIP001 		rStCtrl.Seek( nFPosMerk ); // FilePos restaurieren
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 FASTBOOL SvxMSDffManager::GetColorFromPalette( USHORT nNum, Color& rColor ) const
//STRIP001 {
//STRIP001 	// diese Methode ist in der zum Excel-Import
//STRIP001 	// abgeleiteten Klasse zu ueberschreiben...
//STRIP001 	rColor.SetColor( COL_WHITE );
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 Color SvxMSDffManager::MSO_CLR_ToColor( sal_uInt32 nColorCode, sal_uInt16 nContentProperty ) const
//STRIP001 {
//STRIP001 	Color aColor( mnDefaultColor );
//STRIP001 
//STRIP001 	// Fuer Textfarben: Header ist 0xfeRRGGBB
//STRIP001 	if ( ( nColorCode & 0xfe000000 ) == 0xfe000000 )
//STRIP001 		nColorCode &= 0x00ffffff;
//STRIP001 
//STRIP001 	sal_uInt8 nUpper = (sal_uInt8)( nColorCode >> 24 );
//STRIP001 	if( nUpper & 0x1b )		// if( nUpper & 0x1f )
//STRIP001 	{
//STRIP001 		if( ( nUpper & 0x08 ) || ( ( nUpper & 0x10 ) == 0 ) )
//STRIP001 		{
//STRIP001 			// SCHEMECOLOR
//STRIP001 			if ( !GetColorFromPalette( ( nUpper & 8 ) ? (sal_uInt16)nColorCode : nUpper, aColor ) )
//STRIP001 			{
//STRIP001 				switch( nContentProperty )
//STRIP001 				{
//STRIP001 					case DFF_Prop_pictureTransparent :
//STRIP001 					case DFF_Prop_shadowColor :
//STRIP001 					case DFF_Prop_fillBackColor :
//STRIP001 					case DFF_Prop_fillColor :
//STRIP001 						aColor = Color( COL_WHITE );
//STRIP001 					break;
//STRIP001 					case DFF_Prop_lineColor :
//STRIP001 					{
//STRIP001 						aColor = Color( COL_BLACK );
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else	// SYSCOLOR
//STRIP001 		{
//STRIP001 //			UINT16 nParameter = (BYTE)( nColorCode >> 16);		// SJ: nice compiler optimization bug on windows, though downcasting
//STRIP001 			UINT16 nParameter = ( nColorCode >> 16 ) & 0x00ff;	// the HiByte of nParameter is not zero, an exclusive AND is helping :o
//STRIP001 
//STRIP001 			UINT16 nFunctionBits = (UINT16)( ( nColorCode & 0x00000f00 ) >> 8 );
//STRIP001 			UINT16 nAdditionalFlags = (UINT16)( ( nColorCode & 0x0000f000) >> 8 );
//STRIP001 			UINT16 nColorIndex = nColorCode & 0x00ff;
//STRIP001 			UINT32 nPropColor;
//STRIP001 
//STRIP001 			sal_uInt16	nCProp = DFF_Prop_lineColor;
//STRIP001 			switch ( nColorIndex )
//STRIP001 			{
//STRIP001 				case 0xf0 :	// msocolorFillColor
//STRIP001 				{
//STRIP001 					nPropColor = GetPropertyValue( DFF_Prop_fillColor, 0xffffff );
//STRIP001 					nCProp = DFF_Prop_fillColor;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0xf1 : // msocolorLineOrFillColor ( use the line color only if there is a line )
//STRIP001 				{
//STRIP001 					if ( GetPropertyValue( DFF_Prop_fNoLineDrawDash ) & 8 )
//STRIP001 					{
//STRIP001 						nPropColor = GetPropertyValue( DFF_Prop_lineColor, 0 );
//STRIP001 						nCProp = DFF_Prop_lineColor;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						nPropColor = GetPropertyValue( DFF_Prop_fillColor, 0xffffff );
//STRIP001 						nCProp = DFF_Prop_fillColor;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0xf2 : // msocolorLineColor
//STRIP001 				{
//STRIP001 					nPropColor = GetPropertyValue( DFF_Prop_lineColor, 0 );
//STRIP001 					nCProp = DFF_Prop_lineColor;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0xf3 : // msocolorShadowColor
//STRIP001 				{
//STRIP001 					nPropColor = GetPropertyValue( DFF_Prop_shadowColor, 0x808080 );
//STRIP001 					nCProp = DFF_Prop_shadowColor;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0xf4 : // msocolorThis	( use this color ... )
//STRIP001 				{
//STRIP001 					nPropColor = GetPropertyValue( DFF_Prop_fillColor, 0xffffff );	//?????????????
//STRIP001 					nCProp = DFF_Prop_fillColor;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0xf5 : // msocolorFillBackColor
//STRIP001 				{
//STRIP001 					nPropColor = GetPropertyValue( DFF_Prop_fillBackColor, 0xffffff );
//STRIP001 					nCProp = DFF_Prop_fillBackColor;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0xf6 : // msocolorLineBackColor
//STRIP001 				{
//STRIP001 					nPropColor = GetPropertyValue( DFF_Prop_lineBackColor, 0xffffff );
//STRIP001 					nCProp = DFF_Prop_lineBackColor;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0xf7 : // msocolorFillThenLine	( use the fillcolor unless no fill and line )
//STRIP001 				{
//STRIP001 					nPropColor = GetPropertyValue( DFF_Prop_fillColor, 0xffffff );	//?????????????
//STRIP001 					nCProp = DFF_Prop_fillColor;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0xff : // msocolorIndexMask ( extract the color index )
//STRIP001 				{
//STRIP001 					nPropColor = GetPropertyValue( DFF_Prop_fillColor, 0xffffff );	//?????????????
//STRIP001 					nCProp = DFF_Prop_fillColor;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			if ( ( nPropColor & 0x10000000 ) == 0 )	// beware of looping recursive
//STRIP001 				aColor = MSO_CLR_ToColor( nPropColor, nCProp );
//STRIP001 			if( nAdditionalFlags & 0x80 )			// make color gray
//STRIP001 			{
//STRIP001 				UINT8 nZwi = aColor.GetLuminance();
//STRIP001 				aColor = Color( nZwi, nZwi, nZwi );
//STRIP001 			}
//STRIP001 			switch( nFunctionBits )
//STRIP001 			{
//STRIP001 				case 0x01 :		// darken color by parameter
//STRIP001 				{
//STRIP001 					aColor.SetRed( ( nParameter * aColor.GetRed() ) >> 8 );
//STRIP001 					aColor.SetGreen( ( nParameter * aColor.GetGreen() ) >> 8 );
//STRIP001 					aColor.SetBlue( ( nParameter * aColor.GetBlue() ) >> 8 );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0x02 :		// lighten color by parameter
//STRIP001 				{
//STRIP001 					UINT16 nInvParameter = ( 0x00ff - nParameter ) * 0xff;
//STRIP001 					aColor.SetRed( ( nInvParameter + ( nParameter * aColor.GetRed() ) ) >> 8 );
//STRIP001 					aColor.SetGreen( ( nInvParameter + ( nParameter * aColor.GetGreen() ) ) >> 8 );
//STRIP001 					aColor.SetBlue( ( nInvParameter + ( nParameter * aColor.GetBlue() ) ) >> 8 );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0x03 :		// add grey level RGB(p,p,p)
//STRIP001 				{
//STRIP001 					INT16 nR = (INT16)aColor.GetRed() + (INT16)nParameter;
//STRIP001 					INT16 nG = (INT16)aColor.GetGreen() + (INT16)nParameter;
//STRIP001 					INT16 nB = (INT16)aColor.GetBlue() + (INT16)nParameter;
//STRIP001 					if ( nR > 0x00ff )
//STRIP001 						nR = 0x00ff;
//STRIP001 					if ( nG > 0x00ff )
//STRIP001 						nG = 0x00ff;
//STRIP001 					if ( nB > 0x00ff )
//STRIP001 						nB = 0x00ff;
//STRIP001 					aColor = Color( (UINT8)nR, (UINT8)nG, (UINT8)nB );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0x04 :		// substract grey level RGB(p,p,p)
//STRIP001 				{
//STRIP001 					INT16 nR = (INT16)aColor.GetRed() - (INT16)nParameter;
//STRIP001 					INT16 nG = (INT16)aColor.GetGreen() - (INT16)nParameter;
//STRIP001 					INT16 nB = (INT16)aColor.GetBlue() - (INT16)nParameter;
//STRIP001 					if ( nR < 0 )
//STRIP001 						nR = 0;
//STRIP001 					if ( nG < 0 )
//STRIP001 						nG = 0;
//STRIP001 					if ( nB < 0 )
//STRIP001 						nB = 0;
//STRIP001 					aColor = Color( (UINT8)nR, (UINT8)nG, (UINT8)nB );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0x05 :		// substract from grey level RGB(p,p,p)
//STRIP001 				{
//STRIP001 					INT16 nR = (INT16)nParameter - (INT16)aColor.GetRed();
//STRIP001 					INT16 nG = (INT16)nParameter - (INT16)aColor.GetGreen();
//STRIP001 					INT16 nB = (INT16)nParameter - (INT16)aColor.GetBlue();
//STRIP001 					if ( nR < 0 )
//STRIP001 						nR = 0;
//STRIP001 					if ( nG < 0 )
//STRIP001 						nG = 0;
//STRIP001 					if ( nB < 0 )
//STRIP001 						nB = 0;
//STRIP001 					aColor = Color( (UINT8)nR, (UINT8)nG, (UINT8)nB );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case 0x06 :		// per component: black if < p, white if >= p
//STRIP001 				{
//STRIP001 					aColor.SetRed( aColor.GetRed() < nParameter ? 0x00 : 0xff );
//STRIP001 					aColor.SetGreen( aColor.GetGreen() < nParameter ? 0x00 : 0xff );
//STRIP001 					aColor.SetBlue( aColor.GetBlue() < nParameter ? 0x00 : 0xff );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			if ( nAdditionalFlags & 0x40 )					// top-bit invert
//STRIP001 				aColor = Color( aColor.GetRed() ^ 0x80, aColor.GetGreen() ^ 0x80, aColor.GetBlue() ^ 0x80 );
//STRIP001 
//STRIP001 			if ( nAdditionalFlags & 0x20 )					// invert color
//STRIP001 				aColor = Color(0xff - aColor.GetRed(), 0xff - aColor.GetGreen(), 0xff - aColor.GetBlue());
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( ( nUpper & 4 ) && ( ( nColorCode & 0xfffff8 ) == 0 ) )
//STRIP001 	{	// case of nUpper == 4 powerpoint takes this as agrument for a colorschemecolor
//STRIP001 		GetColorFromPalette( nUpper, aColor );
//STRIP001 	}
//STRIP001 	else	// hart attributiert, eventuell mit Hinweis auf SYSTEMRGB
//STRIP001 		aColor = Color( (BYTE)nColorCode, (BYTE)( nColorCode >> 8 ), (BYTE)( nColorCode >> 16 ) );
//STRIP001 	return aColor;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SvxMSDffManager::ReadDffString(SvStream& rSt, String& rTxt) const
//STRIP001 {
//STRIP001 	FASTBOOL bRet=FALSE;
//STRIP001 	DffRecordHeader aStrHd;
//STRIP001 	if( !ReadCommonRecordHeader(aStrHd, rSt) )
//STRIP001 		rSt.Seek( aStrHd.nFilePos );
//STRIP001 	else if ( aStrHd.nRecType == DFF_PST_TextBytesAtom || aStrHd.nRecType == DFF_PST_TextCharsAtom )
//STRIP001 	{
//STRIP001 		FASTBOOL bUniCode=aStrHd.nRecType==DFF_PST_TextCharsAtom;
//STRIP001 		bRet=TRUE;
//STRIP001 		ULONG nBytes = aStrHd.nRecLen;
//STRIP001 		MSDFFReadZString( rSt, rTxt, nBytes, bUniCode );
//STRIP001 		if( !bUniCode )
//STRIP001 		{
//STRIP001 			for ( xub_StrLen n = 0; n < nBytes; n++ )
//STRIP001 			{
//STRIP001 				if( rTxt.GetChar( n ) == 0x0B )
//STRIP001 					rTxt.SetChar( n, ' ' );		// Weicher Umbruch
//STRIP001 				// TODO: Zeilenumbruch im Absatz via Outliner setzen.
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aStrHd.SeekToEndOfRecord( rSt );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aStrHd.SeekToBegOfRecord( rSt );
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SvxMSDffManager::ReadObjText(SvStream& rSt, SdrObject* pObj) const
//STRIP001 {
//STRIP001 	FASTBOOL bRet=FALSE;
//STRIP001 	SdrTextObj* pText = PTR_CAST(SdrTextObj, pObj);
//STRIP001 	if( pText )
//STRIP001 	{
//STRIP001 		DffRecordHeader aTextHd;
//STRIP001 		if( !ReadCommonRecordHeader(aTextHd, rSt) )
//STRIP001 			rSt.Seek( aTextHd.nFilePos );
//STRIP001 		else if ( aTextHd.nRecType==DFF_msofbtClientTextbox )
//STRIP001 		{
//STRIP001 			bRet=TRUE;
//STRIP001 			ULONG nRecEnd=aTextHd.GetRecEndFilePos();
//STRIP001 			DffRecordHeader aHd;
//STRIP001 			String aText;
//STRIP001 			UINT32 nInvent=pText->GetObjInventor();
//STRIP001 			UINT16 nIdent=pText->GetObjIdentifier();
//STRIP001 
//STRIP001 			SdrOutliner& rOutliner=pText->ImpGetDrawOutliner();
//STRIP001 			USHORT nMinDepth = rOutliner.GetMinDepth();
//STRIP001 			USHORT nOutlMode = rOutliner.GetMode();
//STRIP001 
//STRIP001 			{ // Wohl 'nen kleiner Bug der EditEngine, das die
//STRIP001 			  // Absastzattribute bei Clear() nicht entfernt werden.
//STRIP001 				FASTBOOL bClearParaAttribs = TRUE;
//STRIP001 				rOutliner.SetStyleSheet( 0, NULL );
//STRIP001 				SfxItemSet aSet(rOutliner.GetEmptyItemSet());
//STRIP001 				aSet.Put(SvxColorItem( COL_BLACK ));
//STRIP001 				rOutliner.SetParaAttribs(0,aSet);
//STRIP001 				pText->SetItemSet(aSet);
//STRIP001 
//STRIP001 				bClearParaAttribs = FALSE;
//STRIP001 				if( bClearParaAttribs )
//STRIP001 				{
//STRIP001 					// Wohl 'nen kleiner Bug der EditEngine, dass die
//STRIP001 					// Absastzattribute bei Clear() nicht entfernt werden.
//STRIP001 					rOutliner.SetParaAttribs(0,rOutliner.GetEmptyItemSet());
//STRIP001 				}
//STRIP001 			}
//STRIP001 			rOutliner.Init( OUTLINERMODE_TEXTOBJECT );
//STRIP001 			rOutliner.SetMinDepth(0);
//STRIP001 
//STRIP001 			ULONG nFilePosMerker=rSt.Tell();
//STRIP001 			////////////////////////////////////
//STRIP001 			// TextString und MetaChars lesen //
//STRIP001 			////////////////////////////////////
//STRIP001 			do
//STRIP001 			{
//STRIP001 				if( !ReadCommonRecordHeader(aHd, rSt) )
//STRIP001 					rSt.Seek( aHd.nFilePos );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					switch (aHd.nRecType)
//STRIP001 					{
//STRIP001 						//case TextHeaderAtom
//STRIP001 						//case TextSpecInfoAtom
//STRIP001 						case DFF_PST_TextBytesAtom:
//STRIP001 						case DFF_PST_TextCharsAtom:
//STRIP001 						{
//STRIP001 							aHd.SeekToBegOfRecord(rSt);
//STRIP001 							ReadDffString(rSt, aText);
//STRIP001 						}
//STRIP001 						break;
//STRIP001 						case DFF_PST_TextRulerAtom               :
//STRIP001 						{
//STRIP001 							UINT16 nLen = (UINT16)aHd.nRecLen;
//STRIP001 							if(nLen)
//STRIP001 							{
//STRIP001 								UINT16 nVal1, nVal2, nVal3;
//STRIP001 								UINT16 nDefaultTab = 2540; // PPT def: 1 Inch //rOutliner.GetDefTab();
//STRIP001 								UINT16 nMostrightTab = 0;
//STRIP001 								SfxItemSet aSet(rOutliner.GetEmptyItemSet());
//STRIP001 								SvxTabStopItem aTabItem(0, 0);
//STRIP001 
//STRIP001 								rSt >> nVal1;
//STRIP001 								rSt >> nVal2;
//STRIP001 								nLen -= 4;
//STRIP001 
//STRIP001 								// Allg. TAB verstellt auf Wert in nVal3
//STRIP001 								if(nLen && (nVal1 & 0x0001))
//STRIP001 								{
//STRIP001 									rSt >> nVal3;
//STRIP001 									nLen -= 2;
//STRIP001 									nDefaultTab = (UINT16)(((UINT32)nVal3 * 1000) / 240);
//STRIP001 								}
//STRIP001 
//STRIP001 								// Weitere, frei gesetzte TABs
//STRIP001 								if(nLen && (nVal1 & 0x0004))
//STRIP001 								{
//STRIP001 									rSt >> nVal1;
//STRIP001 									nLen -= 2;
//STRIP001 
//STRIP001 									// fest gesetzte TABs importieren
//STRIP001 									while(nLen && nVal1--)
//STRIP001 									{
//STRIP001 										rSt >> nVal2;
//STRIP001 										rSt >> nVal3;
//STRIP001 										nLen -= 4;
//STRIP001 
//STRIP001 										UINT16 nNewTabPos = (UINT16)(((UINT32)nVal2 * 1000) / 240);
//STRIP001 										if(nNewTabPos > nMostrightTab)
//STRIP001 											nMostrightTab = nNewTabPos;
//STRIP001 
//STRIP001 										SvxTabStop aTabStop(nNewTabPos);
//STRIP001 										aTabItem.Insert(aTabStop);
//STRIP001 									}
//STRIP001 								}
//STRIP001 
//STRIP001 								// evtl. noch default-TABs ergaenzen (immer)
//STRIP001 								UINT16 nObjWidth = pObj->GetSnapRect().GetWidth() + 1;
//STRIP001 								UINT16 nDefaultTabPos = nDefaultTab;
//STRIP001 
//STRIP001 								while(nDefaultTabPos <= nObjWidth && nDefaultTabPos <= nMostrightTab)
//STRIP001 									nDefaultTabPos += nDefaultTab;
//STRIP001 
//STRIP001 								while(nDefaultTabPos <= nObjWidth)
//STRIP001 								{
//STRIP001 									SvxTabStop aTabStop(nDefaultTabPos);
//STRIP001 									aTabItem.Insert(aTabStop);
//STRIP001 									nDefaultTabPos += nDefaultTab;
//STRIP001 								}
//STRIP001 
//STRIP001 								// Falls TABs angelegt wurden, setze diese
//STRIP001 								if(aTabItem.Count())
//STRIP001 								{
//STRIP001 									aSet.Put(aTabItem);
//STRIP001 									rOutliner.SetParaAttribs(0, aSet);
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					}
//STRIP001 					aHd.SeekToEndOfRecord( rSt );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			while ( rSt.GetError() == 0 && rSt.Tell() < nRecEnd );
//STRIP001 
//STRIP001 			////////////////////////
//STRIP001 			// SHIFT-Ret ersetzen //
//STRIP001 			////////////////////////
//STRIP001 			if ( aText.Len() )
//STRIP001 			{
//STRIP001 				aText += ' ';
//STRIP001 				aText.SetChar( aText.Len()-1, 0x0D );
//STRIP001 				rOutliner.SetText( aText, rOutliner.GetParagraph( 0 ) );
//STRIP001 
//STRIP001 				// SHIFT-Ret ersetzen im Outliner
//STRIP001 				if(aText.GetTokenCount(0x0B) > 1)
//STRIP001 				{
//STRIP001 					UINT32 nParaCount = rOutliner.GetParagraphCount();
//STRIP001 					for(UINT16 a=0;a<nParaCount;a++)
//STRIP001 					{
//STRIP001 						Paragraph* pActPara = rOutliner.GetParagraph(a);
//STRIP001 						String aParaText = rOutliner.GetText(pActPara);
//STRIP001 						for(UINT16 b=0;b<aParaText.Len();b++)
//STRIP001 						{
//STRIP001 							if( aParaText.GetChar( b ) == 0x0B)
//STRIP001 							{
//STRIP001 								ESelection aSelection(a, b, a, b+1);
//STRIP001 								rOutliner.QuickInsertLineBreak(aSelection);
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			OutlinerParaObject* pNewText=rOutliner.CreateParaObject();
//STRIP001 			rOutliner.Init( nOutlMode );
//STRIP001 			rOutliner.SetMinDepth(nMinDepth);
//STRIP001 			pText->NbcSetOutlinerParaObject(pNewText);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aTextHd.SeekToBegOfRecord(rSt);
//STRIP001 
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::MSDFFReadZString( SvStream& rIn, String& rStr,
//STRIP001 									ULONG nRecLen, FASTBOOL bUniCode ) const
//STRIP001 {
//STRIP001 	sal_uInt16 nLen = (sal_uInt16)nRecLen;
//STRIP001 	if( nLen )
//STRIP001 	{
//STRIP001 		if ( bUniCode )
//STRIP001 			nLen >>= 1;
//STRIP001 
//STRIP001 		String sBuf;
//STRIP001 		sal_Unicode* pBuf = sBuf.AllocBuffer( nLen );
//STRIP001 
//STRIP001 		if( bUniCode )
//STRIP001 		{
//STRIP001 			rIn.Read( (sal_Char*)pBuf, nLen << 1 );
//STRIP001 
//STRIP001 #ifdef OSL_BIGENDIAN
//STRIP001 			for( sal_uInt16 n = 0; n < nLen; ++n, ++pBuf )
//STRIP001     	    	*pBuf = SWAPSHORT( *pBuf );
//STRIP001 #endif // ifdef OSL_BIGENDIAN
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// use the String-Data as buffer for the 8bit characters and
//STRIP001 			// change then all to unicode
//STRIP001 			sal_Char* pReadPos = ((sal_Char*)pBuf) + nLen;
//STRIP001 			rIn.Read( (sal_Char*)pReadPos, nLen );
//STRIP001 			for( sal_uInt16 n = 0; n < nLen; ++n, ++pBuf, ++pReadPos )
//STRIP001 				*pBuf = ByteString::ConvertToUnicode( *pReadPos, RTL_TEXTENCODING_MS_1252 );
//STRIP001 		}
//STRIP001 
//STRIP001 		rStr = sBuf.EraseTrailingChars( 0 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rStr.Erase();
//STRIP001 }
//STRIP001 
//STRIP001 SdrObject* SvxMSDffManager::ImportWordArt( SvStream& rStCtrl, SfxItemSet& rSet, Rectangle& rBoundRect ) const
//STRIP001 {
//STRIP001 	SdrObject*	pRet = NULL;
//STRIP001 	String		aObjectText;
//STRIP001 	String		aFontName;
//STRIP001 	BOOL		bTextRotate = FALSE;
//STRIP001 
//STRIP001 	((SvxMSDffManager*)this)->mnFix16Angle = 0;	// we don't want to use this property in future
//STRIP001 	if ( SeekToContent( DFF_Prop_gtextUNICODE, rStCtrl ) )
//STRIP001 		MSDFFReadZString( rStCtrl, aObjectText, GetPropertyValue( DFF_Prop_gtextUNICODE ), TRUE );
//STRIP001 	if ( SeekToContent( DFF_Prop_gtextFont, rStCtrl ) )
//STRIP001 		MSDFFReadZString( rStCtrl, aFontName, GetPropertyValue( DFF_Prop_gtextFont ), TRUE );
//STRIP001 	if ( GetPropertyValue( DFF_Prop_gtextFStrikethrough, 0 ) & 0x2000 )
//STRIP001 	{
//STRIP001 		// Text ist senkrecht formatiert, Box Kippen
//STRIP001 		INT32 nHalfWidth = ( rBoundRect.GetWidth() + 1) >> 1;
//STRIP001 		INT32 nHalfHeight = ( rBoundRect.GetHeight() + 1) >> 1;
//STRIP001 		Point aTopLeft( rBoundRect.Left() + nHalfWidth - nHalfHeight,
//STRIP001 				rBoundRect.Top() + nHalfHeight - nHalfWidth);
//STRIP001 		Size aNewSize( rBoundRect.GetHeight(), rBoundRect.GetWidth() );
//STRIP001 		Rectangle aNewRect( aTopLeft, aNewSize );
//STRIP001 		rBoundRect = aNewRect;
//STRIP001 
//STRIP001 		String aSrcText( aObjectText );
//STRIP001 		aObjectText.Erase();
//STRIP001 		for( UINT16 a = 0; a < aSrcText.Len(); a++ )
//STRIP001 		{
//STRIP001 			aObjectText += aSrcText.GetChar( a );
//STRIP001 			aObjectText += '\n';
//STRIP001 		}
//STRIP001 		rSet.Put( SdrTextHorzAdjustItem( SDRTEXTHORZADJUST_CENTER ) );
//STRIP001 		bTextRotate = TRUE;
//STRIP001 	}
//STRIP001 	if ( aObjectText.Len() )
//STRIP001 	{	// WordArt-Objekt Mit dem Text in aObjectText erzeugen
//STRIP001 		SdrObject* pNewObj = new SdrRectObj( OBJ_TEXT, rBoundRect );
//STRIP001 		if( pNewObj )
//STRIP001 		{
//STRIP001 			pNewObj->SetModel( pSdrModel );
//STRIP001 			((SdrRectObj*)pNewObj)->SetText( aObjectText );
//STRIP001 			SdrFitToSizeType eFTS = SDRTEXTFIT_PROPORTIONAL;
//STRIP001 			rSet.Put( SdrTextFitToSizeTypeItem( eFTS ) );
//STRIP001 			rSet.Put( SdrTextAutoGrowHeightItem( FALSE ) );
//STRIP001 			rSet.Put( SdrTextAutoGrowWidthItem( FALSE ) );
//STRIP001 			rSet.Put( SvxFontItem( FAMILY_DONTKNOW, aFontName, String() ) );
//STRIP001 			pNewObj->SetItemSet(rSet);
//STRIP001 
//STRIP001 			pRet = pNewObj->ConvertToPolyObj( FALSE, FALSE );
//STRIP001 			if( !pRet )
//STRIP001 				pRet = pNewObj;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pRet->NbcSetSnapRect( rBoundRect );
//STRIP001 				delete pNewObj;
//STRIP001 			}
//STRIP001 			if( bTextRotate )
//STRIP001 			{
//STRIP001 				double a = 9000 * nPi180;
//STRIP001 				pRet->NbcRotate( rBoundRect.Center(), 9000, sin( a ), cos( a ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 static Size lcl_GetPrefSize(const Graphic& rGraf, MapMode aWanted)
//STRIP001 {
//STRIP001     MapMode aPrefMapMode(rGraf.GetPrefMapMode());
//STRIP001     if (aPrefMapMode == aWanted)
//STRIP001         return rGraf.GetPrefSize();
//STRIP001     Size aRetSize;
//STRIP001     if (aPrefMapMode == MAP_PIXEL)
//STRIP001     {
//STRIP001         aRetSize = Application::GetDefaultDevice()->PixelToLogic(
//STRIP001             rGraf.GetPrefSize(), aWanted);
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001 	    aRetSize = Application::GetDefaultDevice()->LogicToLogic(
//STRIP001 		    rGraf.GetPrefSize(), rGraf.GetPrefMapMode(), aWanted);
//STRIP001     }
//STRIP001     return aRetSize;
//STRIP001 }
//STRIP001 
//STRIP001 SdrObject* SvxMSDffManager::ImportGraphic( SvStream& rSt, SfxItemSet& rSet, Rectangle& aBoundRect, const DffObjData& rObjData ) const
//STRIP001 {
//STRIP001 	SdrObject* pRet = NULL;
//STRIP001 	String aFilename;
//STRIP001 
//STRIP001 	MSO_BlipFlags eFlags = (MSO_BlipFlags)GetPropertyValue( DFF_Prop_pibFlags, mso_blipflagDefault );
//STRIP001 	sal_uInt32 nBlipId = GetPropertyValue( DFF_Prop_pib, 0 );
//STRIP001 	sal_Bool bGrfRead = sal_False,
//STRIP001 
//STRIP001 	// Grafik verlinkt
//STRIP001 	bLinkGrf = 0 != ( eFlags & mso_blipflagLinkToFile );
//STRIP001 	{
//STRIP001 		Graphic aGraf;	// be sure this graphic is deleted before swapping out
//STRIP001 		if( SeekToContent( DFF_Prop_pibName, rSt ) )
//STRIP001 			MSDFFReadZString( rSt, aFilename, GetPropertyValue( DFF_Prop_pibName ), TRUE );
//STRIP001 
//STRIP001 		//   UND, ODER folgendes:
//STRIP001 		if( !( eFlags & mso_blipflagDoNotSave ) ) // Grafik embedded
//STRIP001 		{
//STRIP001 			if (!(bGrfRead = GetBLIP(nBlipId, aGraf)))
//STRIP001 			{
//STRIP001 				/*
//STRIP001 				Still no luck, lets look at the end of this record for a FBSE pool,
//STRIP001 				this fallback is a specific case for how word does it sometimes
//STRIP001 				*/
//STRIP001 				rObjData.rSpHd.SeekToEndOfRecord( rSt );
//STRIP001 				DffRecordHeader aHd;
//STRIP001 				rSt >> aHd;
//STRIP001 				if( DFF_msofbtBSE == aHd.nRecType )
//STRIP001 				{
//STRIP001 					const ULONG nSkipBLIPLen = 20;
//STRIP001 					const ULONG nSkipShapePos = 4;
//STRIP001 					const ULONG nSkipBLIP = 4;
//STRIP001 					const ULONG nSkip =
//STRIP001 						nSkipBLIPLen + 4 + nSkipShapePos + 4 + nSkipBLIP;
//STRIP001 
//STRIP001 					if (nSkip <= aHd.nRecLen)
//STRIP001 					{
//STRIP001 						rSt.SeekRel(nSkip);
//STRIP001 						if (0 == rSt.GetError())
//STRIP001 							bGrfRead = GetBLIPDirect( rSt, aGraf );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( bGrfRead )
//STRIP001 		{	// the writer is doing it's own cropping, so this part affects only impress and calc
//STRIP001 			if ( GetSvxMSDffSettings() & SVXMSDFF_SETTINGS_CROP_BITMAPS )
//STRIP001 			{
//STRIP001 				sal_Int32 nCropTop		= (sal_Int32)GetPropertyValue( DFF_Prop_cropFromTop, 0 );
//STRIP001 				sal_Int32 nCropBottom	= (sal_Int32)GetPropertyValue( DFF_Prop_cropFromBottom, 0 );
//STRIP001 				sal_Int32 nCropLeft		= (sal_Int32)GetPropertyValue( DFF_Prop_cropFromLeft, 0 );
//STRIP001 				sal_Int32 nCropRight	= (sal_Int32)GetPropertyValue( DFF_Prop_cropFromRight, 0 );
//STRIP001 
//STRIP001 				if( nCropTop || nCropBottom || nCropLeft || nCropRight )
//STRIP001 				{
//STRIP001 					double      fFactor;
//STRIP001 					Size        aCropSize;
//STRIP001 					BitmapEx    aCropBitmap;
//STRIP001 					sal_uInt32  nTop( 0 ),  nBottom( 0 ), nLeft( 0 ), nRight( 0 );
//STRIP001 					sal_Bool    bUseCropAttributes = ( rObjData.nSpFlags & SP_FOLESHAPE ) == 0; // we do not support cropping attributes on ole objects
//STRIP001 	                
//STRIP001 					if (bUseCropAttributes)
//STRIP001 						aCropSize = lcl_GetPrefSize(aGraf, MAP_100TH_MM);
//STRIP001 					else
//STRIP001 					{
//STRIP001 						aCropBitmap = aGraf.GetBitmapEx();
//STRIP001 						aCropSize = aCropBitmap.GetSizePixel();
//STRIP001 					}
//STRIP001 					if ( nCropTop )
//STRIP001 					{
//STRIP001 						fFactor = (double)nCropTop / 65536.0;
//STRIP001 						nTop = (sal_uInt32)( ( (double)( aCropSize.Height() + 1 ) * fFactor ) + 0.5 );
//STRIP001 					}
//STRIP001 					if ( nCropBottom )
//STRIP001 					{
//STRIP001 						fFactor = (double)nCropBottom / 65536.0;
//STRIP001 						nBottom = (sal_uInt32)( ( (double)( aCropSize.Height() + 1 ) * fFactor ) + 0.5 );
//STRIP001 					}
//STRIP001 					if ( nCropLeft )
//STRIP001 					{
//STRIP001 						fFactor = (double)nCropLeft / 65536.0;
//STRIP001 						nLeft = (sal_uInt32)( ( (double)( aCropSize.Width() + 1 ) * fFactor ) + 0.5 );
//STRIP001 					}
//STRIP001 					if ( nCropRight )
//STRIP001 					{
//STRIP001 						fFactor = (double)nCropRight / 65536.0;
//STRIP001 						nRight = (sal_uInt32)( ( (double)( aCropSize.Width() + 1 ) * fFactor ) + 0.5 );
//STRIP001 					}
//STRIP001 					if ( bUseCropAttributes )
//STRIP001 						rSet.Put( SdrGrafCropItem( nLeft, nTop, nRight, nBottom ) );
//STRIP001 					else
//STRIP001 					{
//STRIP001     					Rectangle aCropRect( nLeft, nTop, aCropSize.Width() - nRight, aCropSize.Height() - nBottom );
//STRIP001 	    				aCropBitmap.Crop( aCropRect );
//STRIP001 		    			aGraf = aCropBitmap;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if ( IsProperty( DFF_Prop_pictureTransparent ) )
//STRIP001 			{
//STRIP001 				UINT32 nTransColor = GetPropertyValue( DFF_Prop_pictureTransparent, 0 );
//STRIP001 
//STRIP001 				if ( aGraf.GetType() == GRAPHIC_BITMAP )
//STRIP001 				{
//STRIP001 					BitmapEx	aBitmapEx( aGraf.GetBitmapEx() );
//STRIP001 					Bitmap		aBitmap( aBitmapEx.GetBitmap() );
//STRIP001 					Bitmap		aMask( aBitmap.CreateMask( MSO_CLR_ToColor( nTransColor, DFF_Prop_pictureTransparent ), 9 ) );
//STRIP001 					if ( aBitmapEx.IsTransparent() )
//STRIP001 						aMask.CombineSimple( aBitmapEx.GetMask(), BMP_COMBINE_OR );
//STRIP001 					aGraf = BitmapEx( aBitmap, aMask );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			sal_Int32 nContrast = GetPropertyValue( DFF_Prop_pictureContrast, 0x10000 );
//STRIP001 			/*
//STRIP001 			0x10000 is msoffice 50%
//STRIP001 			< 0x10000 is in units of 1/50th of 0x10000 per 1%
//STRIP001 			> 0x10000 is in units where
//STRIP001 			a msoffice x% is stored as 50/(100-x) * 0x10000
//STRIP001 
//STRIP001 			plus, a (ui) microsoft % ranges from 0 to 100, OOO
//STRIP001 			from -100 to 100, so also normalize into that range
//STRIP001 			*/
//STRIP001 			if ( nContrast > 0x10000 )
//STRIP001 			{
//STRIP001 				double fX = nContrast;
//STRIP001 				fX /= 0x10000;
//STRIP001 				fX /= 51;	// 50 + 1 to round
//STRIP001 				fX = 1/fX;
//STRIP001 				nContrast = static_cast<sal_Int32>(fX);
//STRIP001 				nContrast -= 100;
//STRIP001 				nContrast = -nContrast;
//STRIP001 				nContrast = (nContrast-50)*2;
//STRIP001 			}
//STRIP001 			else if ( nContrast == 0x10000 )
//STRIP001 				nContrast = 0;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nContrast *= 101;	//100 + 1 to round
//STRIP001 				nContrast /= 0x10000;
//STRIP001 				nContrast -= 100;
//STRIP001 			}
//STRIP001 			sal_Int16	nBrightness		= (sal_Int16)( (sal_Int32)GetPropertyValue( DFF_Prop_pictureBrightness, 0 ) / 327 );
//STRIP001 			sal_Int32	nGamma			= GetPropertyValue( DFF_Prop_pictureGamma, 0x10000 );
//STRIP001 			GraphicDrawMode eDrawMode	= GRAPHICDRAWMODE_STANDARD;
//STRIP001 			switch ( GetPropertyValue( DFF_Prop_pictureActive ) & 6 )
//STRIP001 			{
//STRIP001 				case 4 : eDrawMode = GRAPHICDRAWMODE_GREYS; break;
//STRIP001 				case 6 : eDrawMode = GRAPHICDRAWMODE_MONO; break;
//STRIP001 				case 0 :
//STRIP001 				{
//STRIP001 					//office considers the converted values of (in OOo) 70 to be the
//STRIP001 					//"watermark" values, which can vary slightly due to rounding from the
//STRIP001 					//above values
//STRIP001 					if (( nContrast == -70 ) && ( nBrightness == 70 ))
//STRIP001 					{
//STRIP001 						nContrast = 0;
//STRIP001 						nBrightness = 0;
//STRIP001 						eDrawMode = GRAPHICDRAWMODE_WATERMARK;
//STRIP001 					};
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( nContrast || nBrightness || ( nGamma != 0x10000 ) || ( eDrawMode != GRAPHICDRAWMODE_STANDARD ) )
//STRIP001 			{
//STRIP001 
//STRIP001 				// Was: currently the luminance and contrast items are available
//STRIP001 				// in impress only
//STRIP001 				// Now: available in writer as well, so logically only do
//STRIP001 				// hackery for excel import
//STRIP001 				if ( !(GetSvxMSDffSettings() & SVXMSDFF_SETTINGS_IMPORT_EXCEL)
//STRIP001 						&& ( ( rObjData.nSpFlags & SP_FOLESHAPE ) == 0 ) )
//STRIP001 				{
//STRIP001 					if ( nBrightness )
//STRIP001 						rSet.Put( SdrGrafLuminanceItem( nBrightness ) );
//STRIP001 					if ( nContrast )
//STRIP001 						rSet.Put( SdrGrafContrastItem( (sal_Int16)nContrast ) );
//STRIP001 					if ( nGamma != 0x10000 )
//STRIP001 						rSet.Put( SdrGrafGamma100Item( nGamma / 655 ) );
//STRIP001 					if ( eDrawMode != GRAPHICDRAWMODE_STANDARD )
//STRIP001 						rSet.Put( SdrGrafModeItem( eDrawMode ) );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if ( eDrawMode == GRAPHICDRAWMODE_WATERMARK )
//STRIP001 					{
//STRIP001 						nContrast = 60;
//STRIP001 						nBrightness = 70;
//STRIP001 						eDrawMode = GRAPHICDRAWMODE_STANDARD;
//STRIP001 					}
//STRIP001 					switch ( aGraf.GetType() )
//STRIP001 					{
//STRIP001 						case GRAPHIC_BITMAP :
//STRIP001 						{
//STRIP001 							BitmapEx	aBitmapEx( aGraf.GetBitmapEx() );
//STRIP001 							if ( nBrightness || nContrast || ( nGamma != 0x10000 ) )
//STRIP001 								aBitmapEx.Adjust( nBrightness, (sal_Int16)nContrast, 0, 0, 0, (double)nGamma / 0x10000, FALSE );
//STRIP001 							if ( eDrawMode == GRAPHICDRAWMODE_GREYS )
//STRIP001 								aBitmapEx.Convert( BMP_CONVERSION_8BIT_GREYS );
//STRIP001 							else if ( eDrawMode == GRAPHICDRAWMODE_MONO )
//STRIP001 								aBitmapEx.Convert( BMP_CONVERSION_1BIT_THRESHOLD );
//STRIP001 							aGraf = aBitmapEx;
//STRIP001 
//STRIP001 						}
//STRIP001 						break;
//STRIP001 
//STRIP001 						case GRAPHIC_GDIMETAFILE :
//STRIP001 						{
//STRIP001 							GDIMetaFile aGdiMetaFile( aGraf.GetGDIMetaFile() );
//STRIP001 							if ( nBrightness || nContrast || ( nGamma != 0x10000 ) )
//STRIP001 								aGdiMetaFile.Adjust( nBrightness, (sal_Int16)nContrast, 0, 0, 0, (double)nGamma / 0x10000, FALSE );
//STRIP001 							if ( eDrawMode == GRAPHICDRAWMODE_GREYS )
//STRIP001 								aGdiMetaFile.Convert( MTF_CONVERSION_8BIT_GREYS );
//STRIP001 							else if ( eDrawMode == GRAPHICDRAWMODE_MONO )
//STRIP001 								aGdiMetaFile.Convert( MTF_CONVERSION_1BIT_THRESHOLD );
//STRIP001 							aGraf = aGdiMetaFile;
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// sollte es ein OLE-Object sein?
//STRIP001 		if( bGrfRead && !bLinkGrf && IsProperty( DFF_Prop_pictureId ) )
//STRIP001 			pRet = ImportOLE( GetPropertyValue( DFF_Prop_pictureId ), aGraf, aBoundRect );
//STRIP001 		if( !pRet )
//STRIP001 		{
//STRIP001 			pRet = new SdrGrafObj;
//STRIP001 			if( bGrfRead )
//STRIP001 				((SdrGrafObj*)pRet)->SetGraphic( aGraf );
//STRIP001 			if( bLinkGrf )
//STRIP001 			{
//STRIP001 				UniString aName( so3::StaticBaseUrl::SmartRelToAbs( aFilename, FALSE,
//STRIP001 																	INetURLObject::WAS_ENCODED,
//STRIP001 																		INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 				sal_Bool bSetFileName = TRUE;
//STRIP001 
//STRIP001 				if ( bGrfRead )
//STRIP001 				{
//STRIP001 
//STRIP001 					// There is still an embedded graphic that could be used. Sometimes
//STRIP001 					// a graphiclink is also set. The problem is that the graphic cache will
//STRIP001 					// not swapout graphics when a graphiclink exists, so a validity check has to be done
//STRIP001 
//STRIP001 					if ( ( eFlags & mso_blipflagLinkToFile ) == mso_blipflagComment )
//STRIP001 						bSetFileName = FALSE;
//STRIP001 					else
//STRIP001 					{
//STRIP001 						try
//STRIP001 						{
//STRIP001 							::ucb::Content	aCnt( aName, uno::Reference<
//STRIP001 								::com::sun::star::ucb::XCommandEnvironment >() );
//STRIP001 							::rtl::OUString		aTitle;
//STRIP001 
//STRIP001 							aCnt.getPropertyValue( ::rtl::OUString::createFromAscii( "Title" ) ) >>= aTitle;
//STRIP001 							bSetFileName = ( aTitle.getLength() > 0 );
//STRIP001 						}
//STRIP001 						catch( ... )
//STRIP001 						{
//STRIP001 							// this file did not exist, so we will not set this as graphiclink
//STRIP001 							bSetFileName = FALSE;
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if ( bSetFileName )
//STRIP001 					((SdrGrafObj*)pRet)->SetFileName( aName );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if ( !pRet->GetName().Len() )					// SJ 22.02.00 : PPT OLE IMPORT:
//STRIP001 		{												// name is already set in ImportOLE !!
//STRIP001 			// JP 01.12.99: SetName before SetModel - because in the other order the Bug 70098 is active
//STRIP001 			if ( ( eFlags & mso_blipflagType ) != mso_blipflagComment )
//STRIP001 			{
//STRIP001 				INetURLObject aURL;
//STRIP001 				aURL.SetSmartURL( aFilename );
//STRIP001 				pRet->SetName( aURL.getBase() );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pRet->SetName( aFilename );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	pRet->SetModel( pSdrModel ); // fuer GraphicLink erforderlich
//STRIP001 	pRet->SetLogicRect( aBoundRect );
//STRIP001 	if ( pRet->ISA( SdrGrafObj ) )
//STRIP001 		((SdrGrafObj*)pRet)->ForceSwapOut();
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 // PptSlidePersistEntry& rPersistEntry, SdPage* pPage
//STRIP001 SdrObject* SvxMSDffManager::ImportObj( SvStream& rSt, void* pClientData,
//STRIP001 									   const Rectangle* pRect,
//STRIP001 									   int nCalledByGroup )
//STRIP001 {
//STRIP001     SdrObject* pRet = NULL;
//STRIP001     ULONG nFPosMerk = rSt.Tell(); // FilePos merken fuer spaetere Restauration
//STRIP001     DffRecordHeader aObjHd;
//STRIP001     rSt >> aObjHd;
//STRIP001     ULONG nFPosMerk1 = rSt.Tell();
//STRIP001     ULONG nObjRecEnd = aObjHd.GetRecEndFilePos();
//STRIP001     Rectangle aBoundRect;
//STRIP001 	if ( pRect )
//STRIP001 		aBoundRect = *pRect;
//STRIP001 	if ( aObjHd.nRecType == DFF_msofbtSpgrContainer )
//STRIP001 	{
//STRIP001 		mnFix16Angle = 0;
//STRIP001         FASTBOOL b1st = TRUE;
//STRIP001 		INT32	nGroupRotateAngle = 0;
//STRIP001 		INT32	nSpFlags = 0;
//STRIP001 		Rectangle aGroupBound( aBoundRect );
//STRIP001         while ( rSt.GetError() == 0 && rSt.Tell() < nObjRecEnd )
//STRIP001 		{
//STRIP001             DffRecordHeader aRecHd;
//STRIP001             rSt >> aRecHd;
//STRIP001             if ( aObjHd.nRecType == DFF_msofbtSpContainer ||
//STRIP001 				 aObjHd.nRecType == DFF_msofbtSpgrContainer )
//STRIP001 			{
//STRIP001                 aRecHd.SeekToBegOfRecord( rSt );
//STRIP001 				SdrObject* pTmp = ImportObj( rSt, pClientData, &aGroupBound, nCalledByGroup+1);
//STRIP001                 if( b1st )
//STRIP001 				{	// Gruppenattribute, ...
//STRIP001 		            b1st = FALSE;
//STRIP001 					if ( !pTmp )
//STRIP001 						break;
//STRIP001 					pRet = pTmp;
//STRIP001 					aGroupBound = pRet->GetSnapRect();
//STRIP001 					nGroupRotateAngle = mnFix16Angle;
//STRIP001 					nSpFlags = nGroupShapeFlags;
//STRIP001 				}
//STRIP001 				else if ( pTmp )
//STRIP001 					((SdrObjGroup*)pRet)->GetSubList()->NbcInsertObject( pTmp );
//STRIP001             }
//STRIP001             aRecHd.SeekToEndOfRecord( rSt );
//STRIP001         }
//STRIP001 		if( !aGroupBound.IsEmpty() )
//STRIP001 		{
//STRIP001 			pRet->NbcSetSnapRect( aGroupBound );
//STRIP001 			if ( nGroupRotateAngle )
//STRIP001 			{
//STRIP001 				double a = nGroupRotateAngle * nPi180;
//STRIP001 				pRet->NbcRotate( aGroupBound.Center(), nGroupRotateAngle, sin( a ), cos( a ) );
//STRIP001 			}
//STRIP001 			if ( nSpFlags & SP_FFLIPV )		// Vertikal gespiegelt?
//STRIP001 			{	// BoundRect in aBoundRect
//STRIP001 				Point aLeft( aGroupBound.Left(), ( aGroupBound.Top() + aGroupBound.Bottom() ) >> 1 );
//STRIP001 				Point aRight( aLeft.X() + 1000, aLeft.Y() );
//STRIP001 				pRet->NbcMirror( aLeft, aRight );
//STRIP001 			}
//STRIP001 			if ( nSpFlags & SP_FFLIPH )		// Horizontal gespiegelt?
//STRIP001 			{	// BoundRect in aBoundRect
//STRIP001 				Point aTop( ( aGroupBound.Left() + aGroupBound.Right() ) >> 1, aGroupBound.Top() );
//STRIP001 				Point aBottom( aTop.X(), aTop.Y() + 1000 );
//STRIP001 				pRet->NbcMirror( aTop, aBottom );
//STRIP001 			}
//STRIP001 		}
//STRIP001     }
//STRIP001     else if ( aObjHd.nRecType == DFF_msofbtSpContainer )
//STRIP001 	{
//STRIP001 		DffObjData aObjData( aObjHd, aBoundRect, nCalledByGroup, nFPosMerk );
//STRIP001 		aObjHd.SeekToBegOfRecord( rSt );
//STRIP001 		maShapeRecords.Consume( rSt, FALSE );
//STRIP001 		aObjData.bShapeType = maShapeRecords.SeekToContent( rSt, DFF_msofbtSp, SEEK_FROM_BEGINNING );
//STRIP001 		if ( aObjData.bShapeType )
//STRIP001 		{
//STRIP001 			rSt >> aObjData.nShapeId
//STRIP001 				>> aObjData.nSpFlags;
//STRIP001 			aObjData.eShapeType = (MSO_SPT)maShapeRecords.Current()->nRecInstance;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aObjData.nShapeId = 0;
//STRIP001 			aObjData.nSpFlags = 0;
//STRIP001 			aObjData.eShapeType = mso_sptNil;
//STRIP001 		}
//STRIP001 		aObjData.bOpt = maShapeRecords.SeekToContent( rSt, DFF_msofbtOPT, SEEK_FROM_CURRENT_AND_RESTART );
//STRIP001 		if ( aObjData.bOpt )
//STRIP001 		{
//STRIP001             maShapeRecords.Current()->SeekToBegOfRecord( rSt );
//STRIP001 #ifdef DBG_AUTOSHAPE
//STRIP001 			ReadPropSet( rSt, pClientData, (UINT32)aObjData.eShapeType );
//STRIP001 #else
//STRIP001 			ReadPropSet( rSt, pClientData );
//STRIP001 #endif
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			InitializePropSet();	// get the default PropSet
//STRIP001 			( (DffPropertyReader*) this )->mnFix16Angle = 0;
//STRIP001 		}
//STRIP001 
//STRIP001 		aObjData.bChildAnchor = maShapeRecords.SeekToContent( rSt, DFF_msofbtChildAnchor, SEEK_FROM_CURRENT_AND_RESTART );
//STRIP001 		if ( aObjData.bChildAnchor )
//STRIP001 		{
//STRIP001             INT32 l, o, r, u;
//STRIP001             rSt >> l >> o >> r >> u;
//STRIP001             Scale( l );
//STRIP001             Scale( o );
//STRIP001             Scale( r );
//STRIP001             Scale( u );
//STRIP001             aObjData.aChildAnchor = Rectangle( l, o, r, u );
//STRIP001 		}
//STRIP001 
//STRIP001 		aObjData.bClientAnchor = maShapeRecords.SeekToContent( rSt, DFF_msofbtClientAnchor, SEEK_FROM_CURRENT_AND_RESTART );
//STRIP001 		if ( aObjData.bClientAnchor )
//STRIP001 			ProcessClientAnchor2( rSt, *maShapeRecords.Current(), pClientData, aObjData );
//STRIP001 
//STRIP001 		if ( aObjData.bChildAnchor )
//STRIP001 			aBoundRect = aObjData.aChildAnchor;
//STRIP001 
//STRIP001 		if ( aObjData.nSpFlags & SP_FBACKGROUND )
//STRIP001 			aBoundRect = Rectangle( Point(), Size( 1, 1 ) );
//STRIP001 
//STRIP001 		Rectangle aTextRect;
//STRIP001         if ( !aBoundRect.IsEmpty() )
//STRIP001 		{	// Rotation auf BoundingBox anwenden, BEVOR ien Objekt generiert wurde
//STRIP001 			rSt.Seek( nFPosMerk );
//STRIP001 			if( mnFix16Angle )
//STRIP001 			{
//STRIP001 				long nAngle = mnFix16Angle;
//STRIP001 				if ( ( nAngle > 4500 && nAngle <= 13500 ) || ( nAngle > 22500 && nAngle <= 31500 ) )
//STRIP001 				{
//STRIP001 					INT32 nHalfWidth = ( aBoundRect.GetWidth() + 1 ) >> 1;
//STRIP001 					INT32 nHalfHeight = ( aBoundRect.GetHeight() + 1 ) >> 1;
//STRIP001 					Point aTopLeft( aBoundRect.Left() + nHalfWidth - nHalfHeight,
//STRIP001 									aBoundRect.Top() + nHalfHeight - nHalfWidth );
//STRIP001 					Size aNewSize( aBoundRect.GetHeight(), aBoundRect.GetWidth() );
//STRIP001 					Rectangle aNewRect( aTopLeft, aNewSize );
//STRIP001 					aBoundRect = aNewRect;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			aTextRect = aBoundRect;
//STRIP001 			FASTBOOL bGraphic = IsProperty( DFF_Prop_pib ) ||
//STRIP001 								IsProperty( DFF_Prop_pibName ) ||
//STRIP001 								IsProperty( DFF_Prop_pibFlags );
//STRIP001 
//STRIP001 			if ( aObjData.nSpFlags & SP_FGROUP )
//STRIP001 			{
//STRIP001 				pRet = new SdrObjGroup;
//STRIP001 				pRet->NbcSetLogicRect( aBoundRect );
//STRIP001 				nGroupShapeFlags = aObjData.nSpFlags;		// #73013#
//STRIP001 			}
//STRIP001 			else if ( ( aObjData.eShapeType != mso_sptNil ) || IsProperty( DFF_Prop_pVertices ) || bGraphic )
//STRIP001 			{
//STRIP001 				UINT32		nSpecialGroupSettings = 0;
//STRIP001 				SfxItemSet	aSet( pSdrModel->GetItemPool() );
//STRIP001 
//STRIP001 				sal_Bool	bIsConnector = ( ( aObjData.eShapeType >= mso_sptStraightConnector1 ) && ( aObjData.eShapeType <= mso_sptCurvedConnector5 ) );
//STRIP001 				sal_Bool	bIsAutoShape = FALSE;
//STRIP001 				sal_Int32	nObjectRotation = mnFix16Angle;
//STRIP001 				sal_uInt32	nSpFlags = aObjData.nSpFlags;
//STRIP001 
//STRIP001 				if ( bGraphic )
//STRIP001 				{
//STRIP001 					pRet = ImportGraphic( rSt, aSet, aBoundRect, aObjData );
//STRIP001 					if ( pRet )
//STRIP001 					{
//STRIP001 						if ( !IsHardAttribute( DFF_Prop_fFilled ) )		// the default for graphic objects is: not filled
//STRIP001 						{
//STRIP001 							UINT32 nOldProp = GetPropertyValue( DFF_Prop_fNoFillHitTest );
//STRIP001 							if ( nOldProp & 0x10 )
//STRIP001 								SetPropertyValue( DFF_Prop_fNoFillHitTest, nOldProp &~0x10 );
//STRIP001 						}
//STRIP001 						if ( !IsHardAttribute( DFF_Prop_fLine ) )		// the default for graphic objects is: no line
//STRIP001 						{
//STRIP001 							UINT32 nOldProp = GetPropertyValue( DFF_Prop_fNoLineDrawDash );
//STRIP001 							if ( nOldProp & 8 )
//STRIP001 								SetPropertyValue( DFF_Prop_fNoLineDrawDash, nOldProp &~8 );
//STRIP001 						}
//STRIP001 						if ( GetSvxMSDffSettings() & ( SVXMSDFF_SETTINGS_IMPORT_PPT | SVXMSDFF_SETTINGS_IMPORT_EXCEL ) )
//STRIP001 						{	// impress does not support line propertys on graphic objects
//STRIP001 							BOOL bFilled = ( GetPropertyValue( DFF_Prop_fNoFillHitTest ) & 16 ) != 0;
//STRIP001 							BOOL bLine = ( GetPropertyValue( DFF_Prop_fNoLineDrawDash ) & 8 ) != 0;
//STRIP001 							if ( bLine || bFilled )
//STRIP001 							{
//STRIP001 								SdrObject* pRect;
//STRIP001 								SdrObject* pGroup = new SdrObjGroup;
//STRIP001 								if ( pGroup )
//STRIP001 								{
//STRIP001 									if ( bFilled )
//STRIP001 									{
//STRIP001 										pRect = new SdrRectObj( aBoundRect );
//STRIP001 										if ( pRect )
//STRIP001 										{
//STRIP001 											pGroup->GetSubList()->NbcInsertObject( pRect );
//STRIP001 											nSpecialGroupSettings = 2;
//STRIP001 										}
//STRIP001 									}
//STRIP001 									pGroup->GetSubList()->NbcInsertObject( pRet );
//STRIP001 									if ( bLine )
//STRIP001 									{
//STRIP001 										pRect = new SdrRectObj( aBoundRect );
//STRIP001 										if ( pRect )
//STRIP001 											pGroup->GetSubList()->NbcInsertObject( pRect );
//STRIP001 									}
//STRIP001 									pRet = pGroup;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					nSpFlags &=~ ( SP_FFLIPH | SP_FFLIPV );			// #68396#
//STRIP001 				}
//STRIP001 				else  if ( ( aObjData.eShapeType == mso_sptCurvedLeftArrow )    // #97935# not taking the autoshapes from msashape,
//STRIP001                         || ( aObjData.eShapeType == mso_sptCurvedRightArrow )   // instead we are using our precalculated ones
//STRIP001                         || ( aObjData.eShapeType == mso_sptCurvedUpArrow )
//STRIP001                         || ( aObjData.eShapeType == mso_sptCurvedDownArrow ) )
//STRIP001                 {
//STRIP001 						pRet = GetAutoForm( aObjData.eShapeType );
//STRIP001 						if ( pRet )
//STRIP001 							pRet->NbcSetSnapRect( aBoundRect );	// Groesse setzen
//STRIP001                 }
//STRIP001 				else
//STRIP001 				{
//STRIP001 					SvxMSDffAutoShape aAutoShape( *this, rSt, aObjData, aBoundRect, nObjectRotation );
//STRIP001 					if ( !aAutoShape.IsEmpty() )
//STRIP001 					{
//STRIP001 						ApplyAttributes( rSt, aSet, NULL );
//STRIP001 						pRet = aAutoShape.GetObject( pSdrModel, aSet, TRUE );
//STRIP001 						aTextRect = aAutoShape.GetTextRect();
//STRIP001 						bIsAutoShape = TRUE;
//STRIP001 					}
//STRIP001 					else if ( aObjData.eShapeType == mso_sptTextBox )
//STRIP001 					{
//STRIP001 						if ( ( GetPropertyValue( DFF_Prop_fNoLineDrawDash ) & 8 )
//STRIP001 							|| ( GetPropertyValue( DFF_Prop_fNoFillHitTest ) & 0x10 ) )
//STRIP001                         {
//STRIP001 							pRet = new SdrRectObj( aBoundRect );  // SJ: changed the type from OBJ_TEXT to OBJ_RECT (#88277#)
//STRIP001                         }
//STRIP001 					}
//STRIP001 					else if (
//STRIP001 						mso_sptWedgeRectCallout == aObjData.eShapeType ||
//STRIP001 						mso_sptWedgeRRectCallout == aObjData.eShapeType ||
//STRIP001 						mso_sptWedgeEllipseCallout == aObjData.eShapeType ||
//STRIP001 						mso_sptBalloon == aObjData.eShapeType ||
//STRIP001 						mso_sptCloudCallout == aObjData.eShapeType )
//STRIP001 					{
//STRIP001 						// Balloon mappen
//STRIP001 						if( mso_sptBalloon == aObjData.eShapeType )
//STRIP001 							aObjData.eShapeType = mso_sptWedgeRRectCallout;
//STRIP001 
//STRIP001 						pRet = GetAutoForm( aObjData.eShapeType );
//STRIP001 						if ( pRet )
//STRIP001 							pRet->NbcSetSnapRect( aBoundRect );	// Groesse setzen
//STRIP001 					}
//STRIP001 					else if ( ( ( aObjData.eShapeType >= mso_sptCallout1 ) && ( aObjData.eShapeType <= mso_sptAccentBorderCallout3 ) )
//STRIP001 								|| ( aObjData.eShapeType == mso_sptCallout90 )
//STRIP001 								|| ( aObjData.eShapeType == mso_sptAccentCallout90 )
//STRIP001 								|| ( aObjData.eShapeType == mso_sptBorderCallout90 )
//STRIP001 								|| ( aObjData.eShapeType == mso_sptAccentBorderCallout90 ) )
//STRIP001 					{
//STRIP001 						pRet = new SdrCaptionObj( aBoundRect );
//STRIP001 						INT32 nAdjust0 = GetPropertyValue( DFF_Prop_adjustValue, 0 );
//STRIP001 						INT32 nAdjust1 = GetPropertyValue( DFF_Prop_adjust2Value, 0 );
//STRIP001 						if( nAdjust0 | nAdjust1 )
//STRIP001 						{	// AdjustValues anwenden, nur welche ?!?
//STRIP001 							nAdjust0 = ( nAdjust0 * 100 ) / 850;
//STRIP001 							nAdjust1 = ( nAdjust1 * 100 ) / 1275;
//STRIP001 							Point aTailPos( nAdjust0 + aBoundRect.Left(), nAdjust1 + aBoundRect.Top() );
//STRIP001 							((SdrCaptionObj*)pRet)->NbcSetTailPos( aTailPos );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else if( ( aObjData.eShapeType >= mso_sptTextPlainText ) && ( aObjData.eShapeType <= mso_sptTextCanDown ) )	// WordArt
//STRIP001 					{
//STRIP001 						aObjData.bIsAutoText = TRUE;
//STRIP001 						pRet = ImportWordArt( rSt, aSet, aBoundRect );
//STRIP001 					}
//STRIP001 					else if ( aObjData.eShapeType == mso_sptLine )
//STRIP001 					{
//STRIP001 						pRet = new SdrPathObj( aBoundRect.TopLeft(), aBoundRect.BottomRight() );
//STRIP001 					}
//STRIP001 					else if( bIsConnector )
//STRIP001 					{
//STRIP001 						// Konnektoren
//STRIP001 						MSO_ConnectorStyle eConnectorStyle = (MSO_ConnectorStyle)GetPropertyValue( DFF_Prop_cxstyle, mso_cxstyleStraight );
//STRIP001 
//STRIP001 						pRet = new SdrEdgeObj();
//STRIP001 						if( pRet )
//STRIP001 						{
//STRIP001 							pRet->SetLogicRect(aBoundRect);
//STRIP001 
//STRIP001 							((SdrEdgeObj*)pRet)->ConnectToNode(TRUE, NULL);
//STRIP001 							((SdrEdgeObj*)pRet)->ConnectToNode(FALSE, NULL);
//STRIP001 
//STRIP001 							Point aPoint1( aBoundRect.TopLeft() );
//STRIP001 							Point aPoint2( aBoundRect.BottomRight() );
//STRIP001 
//STRIP001 							// Rotationen beachten
//STRIP001 							if ( nObjectRotation )
//STRIP001 							{
//STRIP001 								double a = nObjectRotation * nPi180;
//STRIP001 								Point aCenter( aBoundRect.Center() );
//STRIP001 								double ss = sin(a);
//STRIP001 								double cc = cos(a);
//STRIP001 
//STRIP001 								RotatePoint(aPoint1, aCenter, ss, cc);
//STRIP001 								RotatePoint(aPoint2, aCenter, ss, cc);
//STRIP001 							}
//STRIP001 
//STRIP001 							// Linie innerhalb des Bereiches zurechtdrehen/spiegeln
//STRIP001 							if ( nSpFlags & SP_FFLIPH )
//STRIP001 							{
//STRIP001 								INT32 n = aPoint1.X();
//STRIP001 								aPoint1.X() = aPoint2.X();
//STRIP001 								aPoint2.X() = n;
//STRIP001 							}
//STRIP001 							if ( nSpFlags & SP_FFLIPV )
//STRIP001 							{
//STRIP001 								INT32 n = aPoint1.Y();
//STRIP001 								aPoint1.Y() = aPoint2.Y();
//STRIP001 								aPoint2.Y() = n;
//STRIP001 							}
//STRIP001 							nSpFlags &= ~( SP_FFLIPV | SP_FFLIPH );
//STRIP001 
//STRIP001 							pRet->NbcSetPoint(aPoint1, 0);	// Startpunkt
//STRIP001 							pRet->NbcSetPoint(aPoint2, 1);	// Endpunkt
//STRIP001 
//STRIP001 							switch( eConnectorStyle )
//STRIP001 							{
//STRIP001 								case mso_cxstyleBent:
//STRIP001 									aSet.Put( SdrEdgeKindItem( SDREDGE_ORTHOLINES ) );
//STRIP001 								break;
//STRIP001 								case mso_cxstyleCurved:
//STRIP001 									aSet.Put( SdrEdgeKindItem( SDREDGE_BEZIER ) );
//STRIP001 								break;
//STRIP001 								default: // mso_cxstyleStraight || mso_cxstyleNone
//STRIP001 									aSet.Put( SdrEdgeKindItem( SDREDGE_ONELINE ) );
//STRIP001 								break;
//STRIP001 							}
//STRIP001 							aSet.Put( SdrEdgeNode1HorzDistItem( 0 ) );
//STRIP001 							aSet.Put( SdrEdgeNode1VertDistItem( 0 ) );
//STRIP001 							aSet.Put( SdrEdgeNode2HorzDistItem( 0 ) );
//STRIP001 							aSet.Put( SdrEdgeNode2VertDistItem( 0 ) );
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else if ( ( (int)aObjData.eShapeType > (int)mso_sptRectangle ) && ( (int)aObjData.eShapeType < (int)mso_sptTextBox ) )
//STRIP001 					{
//STRIP001 						pRet = GetAutoForm( aObjData.eShapeType );
//STRIP001 						if ( pRet )
//STRIP001 							pRet->NbcSetSnapRect( aBoundRect );	// Groesse setzen
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if ( pRet )
//STRIP001 				{
//STRIP001 					if ( !bIsAutoShape )
//STRIP001 					{
//STRIP001  						ApplyAttributes( rSt, aSet, pRet );
//STRIP001 						if ( !GetPropertyValue( DFF_Prop_gtextSize, 0 ) )
//STRIP001 							aSet.Put( SvxFontHeightItem( ScalePt( 24 << 16 ) ) );
//STRIP001 						if ( aObjData.eShapeType == mso_sptTextBox )
//STRIP001 							aSet.Put( SdrTextMinFrameHeightItem( aBoundRect.GetHeight() ) );
//STRIP001 						pRet->SetModel( pSdrModel );
//STRIP001 						pRet->SetItemSet(aSet);
//STRIP001 						// Rotieren
//STRIP001                         if ( pRet->ISA( SdrCaptionObj ) )       // sj: #96758# SetModel is changing
//STRIP001                             pRet->SetSnapRect( aBoundRect );    // the original snaprect
//STRIP001 					}
//STRIP001 					// FillStyle != XFILL_NONE und nicht geschlossenes Polygon-Objekt?
//STRIP001 					if( pRet->ISA( SdrPathObj ) )
//STRIP001 					{
//STRIP001 						XFillStyle eFillStyle = ITEMVALUE( aSet, XATTR_FILLSTYLE, XFillStyleItem );
//STRIP001 						if( eFillStyle != XFILL_NONE )
//STRIP001 						{
//STRIP001 							// Das Polygon des Objektes muss geschlossen werden
//STRIP001 							if(!((SdrPathObj*)pRet)->IsClosed())
//STRIP001 								((SdrPathObj*)pRet)->ToggleClosed(0);
//STRIP001 						}
//STRIP001 					}
//STRIP001 					// Handelt es sich um 3D?
//STRIP001 					if( GetPropertyValue( DFF_Prop_fc3DLightFace ) & 8 )
//STRIP001 					{
//STRIP001 						// #81981# not all objects are effected by 3d effects
//STRIP001 						if ( !bGraphic )
//STRIP001 						{
//STRIP001 							SdrObject* p3d = SvxMSDffAutoShape3D::Create3DObject( pRet, *this, aSet, aBoundRect, nSpFlags );
//STRIP001 							if ( p3d )
//STRIP001 							{
//STRIP001 								nSpFlags &= ~( SP_FFLIPV | SP_FFLIPH );
//STRIP001 								nObjectRotation = 0;
//STRIP001 								delete pRet;
//STRIP001 								pRet = p3d;
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if ( pRet )
//STRIP001 				{
//STRIP001 					if( nObjectRotation && !bIsConnector )
//STRIP001 					{
//STRIP001 						double a = nObjectRotation * nPi180;
//STRIP001 						pRet->NbcRotate( aBoundRect.Center(), nObjectRotation, sin( a ), cos( a ) );
//STRIP001 					}
//STRIP001 					if ( nSpecialGroupSettings )
//STRIP001 					{
//STRIP001 						SdrObjList* pObjectList = pObjectList = pRet->GetSubList();
//STRIP001 						if ( pObjectList )
//STRIP001 						{
//STRIP001 							INT32	nCount = pObjectList->GetObjCount();
//STRIP001 							if ( nSpecialGroupSettings == 2 )
//STRIP001 							{
//STRIP001 								// a graphic was imported into impress, the fill attribute has
//STRIP001 								// to be set on the first object only
//STRIP001 								aSet.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 								for ( INT32 i = nCount; --i > 0; )
//STRIP001 								{
//STRIP001 									SdrObject*	pObj = pObjectList->GetObj( i );
//STRIP001 									if ( pObj )
//STRIP001 										pObj->SetItemSet(aSet);
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					// Horizontal gespiegelt?
//STRIP001 					if ( nSpFlags & SP_FFLIPH )
//STRIP001 					{
//STRIP001 						Rectangle aBoundRect( pRet->GetSnapRect() );
//STRIP001 						Point aTop( ( aBoundRect.Left() + aBoundRect.Right() ) >> 1, aBoundRect.Top() );
//STRIP001 						Point aBottom( aTop.X(), aTop.Y() + 1000 );
//STRIP001 						pRet->NbcMirror( aTop, aBottom );
//STRIP001 					}
//STRIP001 					// Vertikal gespiegelt?
//STRIP001 					if ( nSpFlags & SP_FFLIPV )
//STRIP001 					{
//STRIP001 						Rectangle aBoundRect( pRet->GetSnapRect() );
//STRIP001 						Point aLeft( aBoundRect.Left(), ( aBoundRect.Top() + aBoundRect.Bottom() ) >> 1 );
//STRIP001 						Point aRight( aLeft.X() + 1000, aLeft.Y() );
//STRIP001 						pRet->NbcMirror( aLeft, aRight );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		pRet =
//STRIP001 			ProcessObj( rSt, aObjData, pClientData, aTextRect, pRet);
//STRIP001     }
//STRIP001     rSt.Seek( nFPosMerk );	// FilePos restaurieren
//STRIP001     return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SdrObject* SvxMSDffManager::ProcessObj(SvStream& rSt,
//STRIP001 									   DffObjData& rObjData,
//STRIP001 									   void* pData,
//STRIP001 									   Rectangle& rTextRect,
//STRIP001 									   SdrObject* pObj
//STRIP001 									   )
//STRIP001 {
//STRIP001 	if( !rTextRect.IsEmpty() )
//STRIP001 	{
//STRIP001 		SvxMSDffImportData& rImportData = *(SvxMSDffImportData*)pData;
//STRIP001 		SvxMSDffImportRec* pImpRec = new SvxMSDffImportRec;
//STRIP001 		SvxMSDffImportRec* pTextImpRec = pImpRec;
//STRIP001 
//STRIP001 		// fill Import Record with data
//STRIP001 		pImpRec->nShapeId   = rObjData.nShapeId;
//STRIP001 		pImpRec->eShapeType = rObjData.eShapeType;
//STRIP001 
//STRIP001 		MSO_WrapMode eWrapMode( (MSO_WrapMode)GetPropertyValue(
//STRIP001 															DFF_Prop_WrapText,
//STRIP001 															mso_wrapSquare ) );
//STRIP001 		rObjData.bClientAnchor = maShapeRecords.SeekToContent( rSt,
//STRIP001 											DFF_msofbtClientAnchor,
//STRIP001 											SEEK_FROM_CURRENT_AND_RESTART );
//STRIP001 		if( rObjData.bClientAnchor )
//STRIP001 			ProcessClientAnchor( rSt,
//STRIP001 					maShapeRecords.Current()->nRecLen,
//STRIP001 					pImpRec->pClientAnchorBuffer, pImpRec->nClientAnchorLen );
//STRIP001 
//STRIP001 		rObjData.bClientData = maShapeRecords.SeekToContent( rSt,
//STRIP001 											DFF_msofbtClientData,
//STRIP001 											SEEK_FROM_CURRENT_AND_RESTART );
//STRIP001 		if( rObjData.bClientData )
//STRIP001 			ProcessClientData( rSt,
//STRIP001 					maShapeRecords.Current()->nRecLen,
//STRIP001 					pImpRec->pClientDataBuffer, pImpRec->nClientDataLen );
//STRIP001 
//STRIP001 
//STRIP001 		// process user (== Winword) defined parameters in 0xF122 record
//STRIP001 		if(    maShapeRecords.SeekToContent( rSt,
//STRIP001 											 DFF_msofbtUDefProp,
//STRIP001 											 SEEK_FROM_CURRENT_AND_RESTART )
//STRIP001 			&& maShapeRecords.Current()->nRecLen )
//STRIP001 		{
//STRIP001 			UINT32  nBytesLeft = maShapeRecords.Current()->nRecLen;
//STRIP001 			UINT32	nUDData;
//STRIP001 			UINT16  nPID;
//STRIP001 			while( 5 < nBytesLeft )
//STRIP001 			{
//STRIP001 				rSt >> nPID;
//STRIP001 				if ( rSt.GetError() != 0 )
//STRIP001 					break;
//STRIP001 				rSt >> nUDData;
//STRIP001 				switch( nPID )
//STRIP001 				{
//STRIP001 					case 0x038F: pImpRec->nXAlign = nUDData; break;
//STRIP001 					case 0x0390: pImpRec->nXRelTo = nUDData; break;
//STRIP001 					case 0x0391: pImpRec->nYAlign = nUDData; break;
//STRIP001 					case 0x0392: pImpRec->nYRelTo = nUDData; break;
//STRIP001 				}
//STRIP001 				if ( rSt.GetError() != 0 )
//STRIP001 					break;
//STRIP001 				pImpRec->bHasUDefProp = TRUE;
//STRIP001 				nBytesLeft  -= 6;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//  Textrahmen, auch Title oder Outline
//STRIP001 		SdrObject*  pOrgObj  = pObj;
//STRIP001 		SdrRectObj* pTextObj = 0;
//STRIP001 		UINT32 nTextId = GetPropertyValue( DFF_Prop_lTxid, 0 );
//STRIP001 		if( nTextId )
//STRIP001 		{
//STRIP001 			SfxItemSet aSet( pSdrModel->GetItemPool() );
//STRIP001 
//STRIP001             //Originally anything that as a mso_sptTextBox was created as a
//STRIP001             //textbox, this was changed for #88277# to be created as a simple
//STRIP001             //rect to keep impress happy. For the rest of us we'd like to turn
//STRIP001             //it back into a textbox again.
//STRIP001             FASTBOOL bTextFrame = (pImpRec->eShapeType == mso_sptTextBox);
//STRIP001             if (!bTextFrame)
//STRIP001             {
//STRIP001                 //Either
//STRIP001                 //a) its a simple text object or
//STRIP001                 //b) its a rectangle with text and square wrapping.
//STRIP001                 bTextFrame =
//STRIP001                 (
//STRIP001                     (pImpRec->eShapeType == mso_sptTextSimple) ||
//STRIP001                     (
//STRIP001                         (pImpRec->eShapeType == mso_sptRectangle)
//STRIP001                         && (eWrapMode == mso_wrapSquare)
//STRIP001                         && ShapeHasText(pImpRec->nShapeId, rObjData.nOldFilePos)
//STRIP001                     )
//STRIP001                 );
//STRIP001             }
//STRIP001 
//STRIP001             if (bTextFrame)
//STRIP001             {
//STRIP001                 delete pObj;
//STRIP001                 pObj = pOrgObj = 0;
//STRIP001             }
//STRIP001 
//STRIP001             INT32 nTextRotationAngle=0;
//STRIP001             bool bVerticalText = false;
//STRIP001             if ( IsProperty( DFF_Prop_txflTextFlow ) )
//STRIP001             {
//STRIP001                 MSO_TextFlow eTextFlow = (MSO_TextFlow)(GetPropertyValue(
//STRIP001                     DFF_Prop_txflTextFlow) & 0xFFFF);
//STRIP001                 switch( eTextFlow )
//STRIP001                 {
//STRIP001                     case mso_txflBtoT:
//STRIP001                         nTextRotationAngle = 9000;
//STRIP001                     break;
//STRIP001                     case mso_txflVertN:
//STRIP001                     case mso_txflTtoBN:
//STRIP001                         nTextRotationAngle = 27000;
//STRIP001                         break;
//STRIP001                     case mso_txflTtoBA:
//STRIP001                         bVerticalText = true;
//STRIP001                     break;
//STRIP001                     case mso_txflHorzA:
//STRIP001                         bVerticalText = true;
//STRIP001                         nTextRotationAngle = 9000;
//STRIP001                     case mso_txflHorzN:
//STRIP001                     default :
//STRIP001                         break;
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             if (nTextRotationAngle)
//STRIP001 			{
//STRIP001                 while (nTextRotationAngle > 360000)
//STRIP001                     nTextRotationAngle-=9000;
//STRIP001                 switch (nTextRotationAngle)
//STRIP001                 {
//STRIP001                     case 9000:
//STRIP001                     case 27000:
//STRIP001                         {
//STRIP001                             long nWidth = rTextRect.GetWidth();
//STRIP001                             rTextRect.Right() = rTextRect.Left() + rTextRect.GetHeight();
//STRIP001                             rTextRect.Bottom() = rTextRect.Top() + nWidth;
//STRIP001                         }
//STRIP001                     default:
//STRIP001                         break;
//STRIP001                 }
//STRIP001 			}
//STRIP001 
//STRIP001             pTextObj = new SdrRectObj(OBJ_TEXT, rTextRect);
//STRIP001             pTextImpRec = new SvxMSDffImportRec(*pImpRec);
//STRIP001 
//STRIP001             // Distance of Textbox to it's surrounding Autoshape
//STRIP001 			INT32 nTextLeft = GetPropertyValue( DFF_Prop_dxTextLeft, 91440L);
//STRIP001 			INT32 nTextRight = GetPropertyValue( DFF_Prop_dxTextRight, 91440L );
//STRIP001 			INT32 nTextTop = GetPropertyValue( DFF_Prop_dyTextTop, 45720L  );
//STRIP001 			INT32 nTextBottom = GetPropertyValue( DFF_Prop_dyTextBottom, 45720L );
//STRIP001 
//STRIP001 			ScaleEmu( nTextLeft );
//STRIP001 			ScaleEmu( nTextRight );
//STRIP001 			ScaleEmu( nTextTop );
//STRIP001 			ScaleEmu( nTextBottom );
//STRIP001 
//STRIP001 
//STRIP001             // Die vertikalen Absatzeinrueckungen sind im BoundRect mit drin,
//STRIP001             // hier rausrechnen
//STRIP001             Rectangle aNewRect(rTextRect);
//STRIP001 			aNewRect.Bottom() -= nTextTop + nTextBottom;
//STRIP001             aNewRect.Right() -= nTextLeft + nTextRight;
//STRIP001 
//STRIP001 			// Nur falls es eine einfache Textbox ist, darf der Writer
//STRIP001 			// das Objekt durch einen Rahmen ersetzen, ansonsten
//STRIP001 			if( bTextFrame )
//STRIP001 			{
//STRIP001 				SvxMSDffShapeInfo aTmpRec( 0, pImpRec->nShapeId );
//STRIP001 				aTmpRec.bSortByShapeId = TRUE;
//STRIP001 
//STRIP001 				USHORT nFound;
//STRIP001 				if( pShapeInfos->Seek_Entry( &aTmpRec, &nFound ) )
//STRIP001 				{
//STRIP001 					SvxMSDffShapeInfo& rInfo = *pShapeInfos->GetObject(nFound);
//STRIP001 					pTextImpRec->bReplaceByFly   = rInfo.bReplaceByFly;
//STRIP001 					pTextImpRec->bLastBoxInChain = rInfo.bLastBoxInChain;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if( !pObj )
//STRIP001 				ApplyAttributes( rSt, aSet, pTextObj );
//STRIP001 
//STRIP001             bool bFitText = false;
//STRIP001             if (GetPropertyValue(DFF_Prop_FitTextToShape) & 2)
//STRIP001             {
//STRIP001                 aSet.Put( SdrTextAutoGrowHeightItem( TRUE ) );
//STRIP001                 aSet.Put( SdrTextMinFrameHeightItem(
//STRIP001                     aNewRect.Bottom() - aNewRect.Top() ) );
//STRIP001                 aSet.Put( SdrTextMinFrameWidthItem(
//STRIP001                     aNewRect.Right() - aNewRect.Left() ) );
//STRIP001                 bFitText = true;
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 aSet.Put( SdrTextAutoGrowHeightItem( FALSE ) );
//STRIP001                 aSet.Put( SdrTextAutoGrowWidthItem( FALSE ) );
//STRIP001             }
//STRIP001 
//STRIP001 			switch ( (MSO_WrapMode)
//STRIP001                 GetPropertyValue( DFF_Prop_WrapText, mso_wrapSquare ) )
//STRIP001 			{
//STRIP001 				case mso_wrapNone :
//STRIP001     				aSet.Put( SdrTextAutoGrowWidthItem( TRUE ) );
//STRIP001                     if (bFitText)
//STRIP001                     {
//STRIP001                         //can't do autowidth in flys #i107184#
//STRIP001 					    pTextImpRec->bReplaceByFly = false;
//STRIP001                     }
//STRIP001 				break;
//STRIP001 				case mso_wrapByPoints :
//STRIP001 					aSet.Put( SdrTextContourFrameItem( TRUE ) );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			// Abstaende an den Raendern der Textbox setzen
//STRIP001 			aSet.Put( SdrTextLeftDistItem( nTextLeft ) );
//STRIP001 			aSet.Put( SdrTextRightDistItem( nTextRight ) );
//STRIP001 			aSet.Put( SdrTextUpperDistItem( nTextTop ) );
//STRIP001 			aSet.Put( SdrTextLowerDistItem( nTextBottom ) );
//STRIP001 			pTextImpRec->nDxTextLeft	= nTextLeft;
//STRIP001 			pTextImpRec->nDyTextTop		= nTextTop;
//STRIP001 			pTextImpRec->nDxTextRight	= nTextRight;
//STRIP001 			pTextImpRec->nDyTextBottom	= nTextBottom;
//STRIP001 
//STRIP001 			// Textverankerung lesen
//STRIP001 			if ( IsProperty( DFF_Prop_anchorText ) )
//STRIP001 			{
//STRIP001 				MSO_Anchor eTextAnchor = 
//STRIP001                     (MSO_Anchor)GetPropertyValue( DFF_Prop_anchorText );
//STRIP001 
//STRIP001 				SdrTextVertAdjust eTVA = SDRTEXTVERTADJUST_CENTER;
//STRIP001 				BOOL bTVASet(FALSE);
//STRIP001 				SdrTextHorzAdjust eTHA = SDRTEXTHORZADJUST_CENTER;
//STRIP001 				BOOL bTHASet(FALSE);
//STRIP001 
//STRIP001 				switch( eTextAnchor )
//STRIP001 				{
//STRIP001 					case mso_anchorTop:
//STRIP001 					{
//STRIP001 						eTVA = SDRTEXTVERTADJUST_TOP;
//STRIP001 						bTVASet = TRUE;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 					case mso_anchorTopCentered:
//STRIP001 					{
//STRIP001 						eTVA = SDRTEXTVERTADJUST_TOP;
//STRIP001 						bTVASet = TRUE;
//STRIP001 						bTHASet = TRUE;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					case mso_anchorMiddle:
//STRIP001 						bTVASet = TRUE;
//STRIP001 					break;
//STRIP001 					case mso_anchorMiddleCentered:
//STRIP001 					{
//STRIP001 						bTVASet = TRUE;
//STRIP001 						bTHASet = TRUE;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 					case mso_anchorBottom:
//STRIP001 					{
//STRIP001 						eTVA = SDRTEXTVERTADJUST_BOTTOM;
//STRIP001 						bTVASet = TRUE;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 					case mso_anchorBottomCentered:
//STRIP001 					{
//STRIP001 						eTVA = SDRTEXTVERTADJUST_BOTTOM;
//STRIP001 						bTVASet = TRUE;
//STRIP001 						bTHASet = TRUE;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 	/*
//STRIP001 					case mso_anchorTopBaseline:
//STRIP001 					case mso_anchorBottomBaseline:
//STRIP001 					case mso_anchorTopCenteredBaseline:
//STRIP001 					case mso_anchorBottomCenteredBaseline:
//STRIP001 					break;
//STRIP001 	*/
//STRIP001 				}
//STRIP001 				// Einsetzen
//STRIP001 				if ( bTVASet )
//STRIP001 					aSet.Put( SdrTextVertAdjustItem( eTVA ) );
//STRIP001 				if ( bTHASet )
//STRIP001 					aSet.Put( SdrTextHorzAdjustItem( eTHA ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			pTextObj->SetItemSet(aSet);
//STRIP001             pTextObj->SetModel(pSdrModel);
//STRIP001 
//STRIP001             if (bVerticalText)
//STRIP001                 pTextObj->SetVerticalWriting(sal_True);
//STRIP001 
//STRIP001             if (nTextRotationAngle)
//STRIP001 			{
//STRIP001                 long nMinWH = rTextRect.GetWidth() < rTextRect.GetHeight() ? 
//STRIP001                     rTextRect.GetWidth() : rTextRect.GetHeight();
//STRIP001                 nMinWH /= 2;
//STRIP001                 Point aPivot(rTextRect.TopLeft());
//STRIP001                 aPivot.X() += nMinWH;
//STRIP001                 aPivot.Y() += nMinWH;
//STRIP001 				double a = nTextRotationAngle * nPi180;
//STRIP001 				pTextObj->NbcRotate(aPivot, nTextRotationAngle, sin(a), cos(a));
//STRIP001 			}
//STRIP001 
//STRIP001 			// rotate text with shape ?
//STRIP001 			if ( mnFix16Angle )
//STRIP001 			{
//STRIP001 				double a = mnFix16Angle * nPi180;
//STRIP001 				pTextObj->NbcRotate( rObjData.rBoundRect.Center(), mnFix16Angle,
//STRIP001                     sin( a ), cos( a ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( !pObj )
//STRIP001 			{
//STRIP001 				pObj = pTextObj;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if( pTextObj != pObj )
//STRIP001 				{
//STRIP001 					SdrObject* pGroup = new SdrObjGroup;
//STRIP001 					pGroup->GetSubList()->NbcInsertObject( pObj );
//STRIP001 					pGroup->GetSubList()->NbcInsertObject( pTextObj );
//STRIP001                     if (pOrgObj == pObj)
//STRIP001                         pOrgObj = pGroup;
//STRIP001                     else
//STRIP001 					    pOrgObj = pObj;
//STRIP001                     pObj = pGroup;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if( !pObj )
//STRIP001 		{
//STRIP001 			// simple rectangular objects are ignored by ImportObj()  :-(
//STRIP001 			// this is OK for Draw but not for Calc and Writer
//STRIP001 			// cause here these objects have a default border
//STRIP001 			pObj = new SdrRectObj(rTextRect);
//STRIP001 			pOrgObj = pObj;
//STRIP001 			pObj->SetModel( pSdrModel );
//STRIP001             SfxItemSet aSet( pSdrModel->GetItemPool() );
//STRIP001 			ApplyAttributes( rSt, aSet, pObj );
//STRIP001 
//STRIP001 			const SfxPoolItem* pPoolItem=NULL;
//STRIP001 			SfxItemState eState = aSet.GetItemState( XATTR_FILLCOLOR,
//STRIP001 													 FALSE, &pPoolItem );
//STRIP001 			if( SFX_ITEM_DEFAULT == eState )
//STRIP001 				aSet.Put( XFillColorItem( String(),
//STRIP001 						  Color( mnDefaultColor ) ) );
//STRIP001 			pObj->SetItemSet(aSet);
//STRIP001 		}
//STRIP001 
//STRIP001         //Means that fBehindDocument is set
//STRIP001         if (GetPropertyValue(DFF_Prop_fPrint) & 0x20)
//STRIP001 		    pImpRec->bDrawHell = TRUE;
//STRIP001         else
//STRIP001 		    pImpRec->bDrawHell = FALSE;
//STRIP001 		pTextImpRec->bDrawHell	= pImpRec->bDrawHell;
//STRIP001 		pImpRec->nNextShapeId	= GetPropertyValue( DFF_Prop_hspNext, 0 );
//STRIP001 		pTextImpRec->nNextShapeId=pImpRec->nNextShapeId;
//STRIP001 
//STRIP001 		if ( nTextId )
//STRIP001 		{
//STRIP001 			pTextImpRec->aTextId.nTxBxS = (UINT16)( nTextId >> 16 );
//STRIP001 			pTextImpRec->aTextId.nSequence = (UINT16)nTextId;
//STRIP001 		}
//STRIP001 
//STRIP001 		pTextImpRec->nDxWrapDistLeft = GetPropertyValue(
//STRIP001 									DFF_Prop_dxWrapDistLeft, 114935L ) / 635L;
//STRIP001 		pTextImpRec->nDyWrapDistTop = GetPropertyValue(
//STRIP001 									DFF_Prop_dyWrapDistTop, 0 ) / 635L;
//STRIP001 		pTextImpRec->nDxWrapDistRight = GetPropertyValue(
//STRIP001 									DFF_Prop_dxWrapDistRight, 114935L ) / 635L;
//STRIP001 		pTextImpRec->nDyWrapDistBottom = GetPropertyValue(
//STRIP001 									DFF_Prop_dyWrapDistBottom, 0 ) / 635L;
//STRIP001 			// 16.16 fraction times total image width or height, as appropriate.
//STRIP001 
//STRIP001 		pImpRec->nCropFromTop = GetPropertyValue(
//STRIP001 									DFF_Prop_cropFromTop, 0 );
//STRIP001 		pImpRec->nCropFromBottom = GetPropertyValue(
//STRIP001 									DFF_Prop_cropFromBottom, 0 );
//STRIP001 		pImpRec->nCropFromLeft = GetPropertyValue(
//STRIP001 									DFF_Prop_cropFromLeft, 0 );
//STRIP001 		pImpRec->nCropFromRight = GetPropertyValue(
//STRIP001 									DFF_Prop_cropFromRight, 0 );
//STRIP001 
//STRIP001 		UINT32 nLineFlags = GetPropertyValue( DFF_Prop_fNoLineDrawDash );
//STRIP001 		pImpRec->eLineStyle = (nLineFlags & 8)
//STRIP001 							? (MSO_LineStyle)GetPropertyValue(
//STRIP001 												DFF_Prop_lineStyle,
//STRIP001 												mso_lineSimple )
//STRIP001 							: (MSO_LineStyle)USHRT_MAX;
//STRIP001 		pTextImpRec->eLineStyle = pImpRec->eLineStyle;
//STRIP001 
//STRIP001 		if( pImpRec->nShapeId )
//STRIP001 		{
//STRIP001 			// Import-Record-Liste ergaenzen
//STRIP001 			if( pOrgObj )
//STRIP001 			{
//STRIP001 				pImpRec->pObj = pOrgObj;
//STRIP001 				rImportData.aRecords.Insert( pImpRec );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( pTextObj && (pOrgObj != pTextObj) )
//STRIP001 			{
//STRIP001 				// Modify ShapeId (must be unique)
//STRIP001 				pImpRec->nShapeId |= 0x8000000;
//STRIP001 				pTextImpRec->pObj = pTextObj;
//STRIP001 				rImportData.aRecords.Insert( pTextImpRec );
//STRIP001 			}
//STRIP001 
//STRIP001 			// Eintrag in Z-Order-Liste um Zeiger auf dieses Objekt ergaenzen
//STRIP001 			/*Only store objects which are not deep inside the tree*/
//STRIP001 			if( ( rObjData.nCalledByGroup == 0 )
//STRIP001 				||
//STRIP001 				( (rObjData.nSpFlags & SP_FGROUP)
//STRIP001 				 && (rObjData.nCalledByGroup < 2) )
//STRIP001 			  )
//STRIP001 				StoreShapeOrder( pImpRec->nShapeId,
//STRIP001 								( ( (ULONG)pImpRec->aTextId.nTxBxS ) << 16 )
//STRIP001 									+ pImpRec->aTextId.nSequence, pObj );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			delete pImpRec;
//STRIP001 	}
//STRIP001 
//STRIP001 	return pObj;
//STRIP001 };
//STRIP001 
//STRIP001 void SvxMSDffManager::StoreShapeOrder(ULONG			nId,
//STRIP001 									  ULONG			nTxBx,
//STRIP001 									  SdrObject*	pObject,
//STRIP001 									  SwFlyFrmFmt*	pFly,
//STRIP001 									  short			nHdFtSection) const
//STRIP001 {
//STRIP001 	USHORT nShapeCount = pShapeOrders->Count();
//STRIP001 	for (USHORT nShapeNum=0; nShapeNum < nShapeCount; nShapeNum++)
//STRIP001 	{
//STRIP001 		SvxMSDffShapeOrder& rOrder
//STRIP001 			= *(SvxMSDffShapeOrder*)(pShapeOrders->GetObject( nShapeNum ));
//STRIP001 
//STRIP001 		if( rOrder.nShapeId == nId )
//STRIP001 		{
//STRIP001 			rOrder.nTxBxComp = nTxBx;
//STRIP001 			rOrder.pObj      = pObject;
//STRIP001 			rOrder.pFly      = pFly;
//STRIP001 			rOrder.nHdFtSection = nHdFtSection;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxMSDffManager::ExchangeInShapeOrder(	SdrObject*   pOldObject,
//STRIP001 											ULONG        nTxBx,
//STRIP001 											SwFlyFrmFmt* pFly,
//STRIP001 											SdrObject*   pObject) const
//STRIP001 {
//STRIP001 	USHORT nShapeCount = pShapeOrders->Count();
//STRIP001 	for (USHORT nShapeNum=0; nShapeNum < nShapeCount; nShapeNum++)
//STRIP001 	{
//STRIP001 		SvxMSDffShapeOrder& rOrder
//STRIP001 			= *(SvxMSDffShapeOrder*)(pShapeOrders->GetObject( nShapeNum ));
//STRIP001 
//STRIP001 		if( rOrder.pObj == pOldObject )
//STRIP001 		{
//STRIP001 			rOrder.pFly      = pFly;
//STRIP001 			rOrder.pObj      = pObject;
//STRIP001 			rOrder.nTxBxComp = nTxBx;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxMSDffManager::RemoveFromShapeOrder( SdrObject* pObject ) const
//STRIP001 {
//STRIP001 	USHORT nShapeCount = pShapeOrders->Count();
//STRIP001 	for (USHORT nShapeNum=0; nShapeNum < nShapeCount; nShapeNum++)
//STRIP001 	{
//STRIP001 		SvxMSDffShapeOrder& rOrder
//STRIP001 			= *(SvxMSDffShapeOrder*)(pShapeOrders->GetObject( nShapeNum ));
//STRIP001 
//STRIP001 		if( rOrder.pObj == pObject )
//STRIP001 		{
//STRIP001 			rOrder.pObj      = 0;
//STRIP001 			rOrder.pFly      = 0;
//STRIP001 			rOrder.nTxBxComp = 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 //  Hilfs Deklarationen
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 
//STRIP001 /*struct SvxMSDffBLIPInfo                       -> in's Header-File
//STRIP001 {
//STRIP001 	USHORT nBLIPType;       // Art des BLIP: z.B. 6 fuer PNG
//STRIP001 	ULONG  nFilePos;        // Offset des BLIP im Daten-Stream
//STRIP001 	ULONG  nBLIPSize;       // Anzahl Bytes, die der BLIP im Stream einnimmt
//STRIP001 	SvxMSDffBLIPInfo(USHORT nBType, ULONG nFPos, ULONG nBSize):
//STRIP001 		nBLIPType( nBType ), nFilePos( nFPos ), nBLIPSize( nBSize ){}
//STRIP001 };
//STRIP001 */
//STRIP001 
//STRIP001 SV_IMPL_PTRARR(			SvxMSDffBLIPInfos,		SvxMSDffBLIPInfo_Ptr	);
//STRIP001 
//STRIP001 SV_IMPL_PTRARR(			SvxMSDffShapeOrders,	SvxMSDffShapeOrder_Ptr	);
//STRIP001 
//STRIP001 SV_IMPL_OP_PTRARR_SORT(	SvxMSDffShapeInfos,		SvxMSDffShapeInfo_Ptr	);
//STRIP001 
//STRIP001 SV_IMPL_OP_PTRARR_SORT(	SvxMSDffShapeTxBxSort,	SvxMSDffShapeOrder_Ptr	);
//STRIP001 
//STRIP001 
//STRIP001 // Liste aller SvxMSDffImportRec fuer eine Gruppe
//STRIP001 SV_IMPL_OP_PTRARR_SORT(MSDffImportRecords, MSDffImportRec_Ptr)
//STRIP001 
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 //  exportierte Klasse: oeffentliche Methoden
//STRIP001 //---------------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxMSDffManager::SvxMSDffManager(SvStream& rStCtrl_,
//STRIP001 								 long      nOffsDgg_,
//STRIP001 								 SvStream* pStData_,
//STRIP001 								 SdrModel* pSdrModel_,// s. unten: SetModel()
//STRIP001 								 long      nApplicationScale,
//STRIP001 								 ColorData mnDefaultColor_,
//STRIP001 								 ULONG     nDefaultFontHeight_,
//STRIP001 								 SvStream* pStData2_)
//STRIP001 	:DffPropertyReader( *this ),
//STRIP001 	 pBLIPInfos(   new SvxMSDffBLIPInfos  ),
//STRIP001 	 pFormModel( NULL ),
//STRIP001 	 pShapeInfos(  new SvxMSDffShapeInfos ),
//STRIP001 	 pShapeOrders( new SvxMSDffShapeOrders ),
//STRIP001 	 pStData(  pStData_  ),
//STRIP001 	 pStData2( pStData2_ ),
//STRIP001 	 rStCtrl(  rStCtrl_  ),
//STRIP001 	 nOffsDgg( nOffsDgg_ ),
//STRIP001 	 mpFidcls( NULL ),
//STRIP001 	 mnDefaultColor( mnDefaultColor_),
//STRIP001 	 nDefaultFontHeight( nDefaultFontHeight_),
//STRIP001 	 nBLIPCount(  USHRT_MAX ),				// mit Error initialisieren, da wir erst pruefen,
//STRIP001 	 nShapeCount( USHRT_MAX ),              // ob Kontroll-Stream korrekte Daten enthaellt
//STRIP001 	 nSvxMSDffSettings( 0 ),
//STRIP001 	 nSvxMSDffOLEConvFlags( 0 ),
//STRIP001      pEscherBlipCache( NULL )
//STRIP001 {
//STRIP001 	SetModel( pSdrModel_, nApplicationScale );
//STRIP001 
//STRIP001 	// FilePos des/der Stream(s) merken
//STRIP001 	ULONG nOldPosCtrl = rStCtrl.Tell();
//STRIP001 	ULONG nOldPosData = pStData ? pStData->Tell() : nOldPosCtrl;
//STRIP001 
//STRIP001 	// Falls kein Datenstream angegeben, gehen wir davon aus,
//STRIP001 	// dass die BLIPs im Steuerstream stehen.
//STRIP001 	if( !pStData )
//STRIP001 		pStData = &rStCtrl;
//STRIP001 
//STRIP001 	SetDefaultPropSet( rStCtrl, nOffsDgg );
//STRIP001 
//STRIP001 	// Steuer Stream auslesen, im Erfolgsfall nBLIPCount setzen
//STRIP001 	GetCtrlData( nOffsDgg );
//STRIP001 
//STRIP001 	// Text-Box-Story-Ketten-Infos ueberpruefen
//STRIP001 	CheckTxBxStoryChain();
//STRIP001 
//STRIP001 	// alte FilePos des/der Stream(s) restaurieren
//STRIP001 	rStCtrl.Seek( nOldPosCtrl );
//STRIP001 	if( &rStCtrl != pStData )
//STRIP001 		pStData->Seek( nOldPosData );
//STRIP001 }
//STRIP001 
//STRIP001 SvxMSDffManager::SvxMSDffManager( SvStream& rStCtrl_ )
//STRIP001 	:DffPropertyReader( *this ),
//STRIP001 	 pBLIPInfos(   new SvxMSDffBLIPInfos  ),
//STRIP001 	 pFormModel( NULL ),
//STRIP001 	 pShapeInfos(  new SvxMSDffShapeInfos ),
//STRIP001 	 pShapeOrders( new SvxMSDffShapeOrders ),
//STRIP001 	 pStData( 0 ),
//STRIP001 	 pStData2( 0 ),
//STRIP001 	 mpFidcls( NULL ),
//STRIP001 	 rStCtrl(  rStCtrl_  ),
//STRIP001 	 nOffsDgg( 0 ),
//STRIP001 	 mnDefaultColor( COL_DEFAULT ),
//STRIP001 	 nDefaultFontHeight( 24 ),
//STRIP001 	 nBLIPCount(  USHRT_MAX ),				// mit Error initialisieren, da wir erst pruefen,
//STRIP001 	 nShapeCount( USHRT_MAX ),              // ob Kontroll-Stream korrekte Daten enthaellt
//STRIP001 	 nSvxMSDffSettings( 0 ),
//STRIP001 	 nSvxMSDffOLEConvFlags( 0 ),
//STRIP001      pEscherBlipCache( NULL )
//STRIP001 {
//STRIP001 	SetModel( NULL, 0 );
//STRIP001 }
//STRIP001 
//STRIP001 SvxMSDffManager::~SvxMSDffManager()
//STRIP001 {
//STRIP001     if ( pEscherBlipCache )
//STRIP001     {  
//STRIP001         void* pPtr;
//STRIP001         for ( pPtr = pEscherBlipCache->First(); pPtr; pPtr = pEscherBlipCache->Next() )
//STRIP001             delete (EscherBlipCacheEntry*)pPtr;
//STRIP001         delete pEscherBlipCache;
//STRIP001     }
//STRIP001 	delete pBLIPInfos;
//STRIP001 	delete pShapeInfos;
//STRIP001 	delete pShapeOrders;
//STRIP001 	delete pFormModel;
//STRIP001 	delete[] mpFidcls;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::InitSvxMSDffManager( long nOffsDgg_, SvStream* pStData_, sal_uInt32 nOleConvFlags )
//STRIP001 {
//STRIP001 	nOffsDgg = nOffsDgg_;
//STRIP001 	pStData = pStData_;
//STRIP001 	nSvxMSDffOLEConvFlags = nOleConvFlags;
//STRIP001 
//STRIP001 	// FilePos des/der Stream(s) merken
//STRIP001 	ULONG nOldPosCtrl = rStCtrl.Tell();
//STRIP001 
//STRIP001 	SetDefaultPropSet( rStCtrl, nOffsDgg );
//STRIP001 
//STRIP001 	// insert fidcl cluster table
//STRIP001 	GetFidclData( nOffsDgg );
//STRIP001 
//STRIP001 	// Steuer Stream auslesen, im Erfolgsfall nBLIPCount setzen
//STRIP001 	GetCtrlData( nOffsDgg );
//STRIP001 
//STRIP001 	// Text-Box-Story-Ketten-Infos ueberpruefen
//STRIP001 	CheckTxBxStoryChain();
//STRIP001 
//STRIP001 	// alte FilePos des/der Stream(s) restaurieren
//STRIP001 	rStCtrl.Seek( nOldPosCtrl );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::SetDgContainer( SvStream& rSt )
//STRIP001 {
//STRIP001 	UINT32 nFilePos = rSt.Tell();
//STRIP001 	DffRecordHeader aDgContHd;
//STRIP001 	rSt >> aDgContHd;
//STRIP001 	// insert this container only if there is also a DgAtom
//STRIP001 	if ( SeekToRec( rSt, DFF_msofbtDg, aDgContHd.GetRecEndFilePos() ) )
//STRIP001 	{
//STRIP001 		DffRecordHeader aRecHd;
//STRIP001 		rSt >> aRecHd;
//STRIP001 		UINT32 nDrawingId = aRecHd.nRecInstance;
//STRIP001 		maDgOffsetTable.Insert( nDrawingId, (void*)nFilePos );
//STRIP001 		rSt.Seek( nFilePos );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::GetFidclData( long nOffsDgg )
//STRIP001 {
//STRIP001 	if ( nOffsDgg )
//STRIP001 	{
//STRIP001 		UINT32 nDummy, nMerk = rStCtrl.Tell();
//STRIP001 		rStCtrl.Seek( nOffsDgg );
//STRIP001 
//STRIP001 		DffRecordHeader aRecHd;
//STRIP001 		rStCtrl >> aRecHd;
//STRIP001 
//STRIP001 		DffRecordHeader aDggAtomHd;
//STRIP001 		if ( SeekToRec( rStCtrl, DFF_msofbtDgg, aRecHd.GetRecEndFilePos(), &aDggAtomHd ) )
//STRIP001 		{
//STRIP001 			aDggAtomHd.SeekToContent( rStCtrl );
//STRIP001 			rStCtrl >> mnCurMaxShapeId
//STRIP001 					>> mnIdClusters
//STRIP001 					>> nDummy
//STRIP001 					>> mnDrawingsSaved;
//STRIP001 
//STRIP001 			if ( mnIdClusters-- > 2 )
//STRIP001 			{
//STRIP001 				if ( aDggAtomHd.nRecLen == ( mnIdClusters * sizeof( FIDCL ) + 16 ) )
//STRIP001 				{
//STRIP001 					mpFidcls = new FIDCL[ mnIdClusters ];
//STRIP001 					for ( UINT32 i = 0; i < mnIdClusters; i++ )
//STRIP001 					{
//STRIP001 						rStCtrl >> mpFidcls[ i ].dgid
//STRIP001 								>> mpFidcls[ i ].cspidCur;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		rStCtrl.Seek( nMerk );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffManager::CheckTxBxStoryChain()
//STRIP001 {
//STRIP001 	SvxMSDffShapeInfos* pOld = pShapeInfos;
//STRIP001 	USHORT nCount			 = pOld->Count();
//STRIP001 	pShapeInfos				 = new SvxMSDffShapeInfos( (nCount < 255)
//STRIP001 													 ? nCount
//STRIP001 													 : 255 );
//STRIP001 	// altes Info-Array ueberarbeiten
//STRIP001 	// (ist sortiert nach nTxBxComp)
//STRIP001 	ULONG nChain    = ULONG_MAX;
//STRIP001 	USHORT nObjMark = 0;
//STRIP001 	BOOL bSetReplaceFALSE = FALSE;
//STRIP001 	USHORT nObj;
//STRIP001 	for( nObj = 0; nObj < nCount; ++nObj )
//STRIP001 	{
//STRIP001 		SvxMSDffShapeInfo* pObj = pOld->GetObject( nObj );
//STRIP001 		if( pObj->nTxBxComp )
//STRIP001 		{
//STRIP001 			pObj->bLastBoxInChain = FALSE;
//STRIP001 			// Gruppenwechsel ?
//STRIP001 			if( nChain != (pObj->nTxBxComp & 0xFFFF0000) )
//STRIP001 			{
//STRIP001 				// voriger war letzter seiner Gruppe
//STRIP001 				if( nObj )
//STRIP001 					pOld->GetObject( nObj-1 )->bLastBoxInChain = TRUE;
//STRIP001 				// Merker und Hilfs-Flag zuruecksetzen
//STRIP001 				nObjMark = nObj;
//STRIP001 				nChain   = pObj->nTxBxComp & 0xFFFF0000;
//STRIP001 				bSetReplaceFALSE = !pObj->bReplaceByFly;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			if( !pObj->bReplaceByFly )
//STRIP001 			{
//STRIP001 				// Objekt, das NICHT durch Rahmen ersetzt werden darf ?
//STRIP001 				// Hilfs-Flag setzen
//STRIP001 				bSetReplaceFALSE = TRUE;
//STRIP001 				// ggfs Flag in Anfang der Gruppe austragen
//STRIP001 				for( USHORT nObj2 = nObjMark; nObj2 < nObj; ++nObj2 )
//STRIP001 					pOld->GetObject( nObj2 )->bReplaceByFly = FALSE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bSetReplaceFALSE )
//STRIP001 			{
//STRIP001 				pObj->bReplaceByFly = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// alle Shape-Info-Objekte in pShapeInfos umkopieren
//STRIP001 		// (aber nach nShapeId sortieren)
//STRIP001 		pObj->bSortByShapeId = TRUE;
//STRIP001 		pShapeInfos->Insert( pObj );
//STRIP001 	}
//STRIP001 	// voriger war letzter seiner Gruppe
//STRIP001 	if( nObj )
//STRIP001 		pOld->GetObject( nObj-1 )->bLastBoxInChain = TRUE;
//STRIP001 	// urspruengliches Array freigeben, ohne Objekte zu zerstoeren
//STRIP001 	pOld->Remove((USHORT)0, nCount);
//STRIP001 	delete pOld;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*****************************************************************************
//STRIP001 
//STRIP001 	Einlesen der Shape-Infos im Ctor:
//STRIP001 	---------------------------------
//STRIP001 	merken der Shape-Ids und zugehoerigen Blip-Nummern und TextBox-Infos
//STRIP001 			   =========                  ============	   =============
//STRIP001 	und merken des File-Offsets fuer jedes Blip
//STRIP001 				   ============
//STRIP001 ******************************************************************************/
//STRIP001 void SvxMSDffManager::GetCtrlData( long nOffsDgg_ )
//STRIP001 {
//STRIP001 	// Start Offset unbedingt merken, falls wir nochmal aufsetzen muessen
//STRIP001 	long nOffsDgg = nOffsDgg_;
//STRIP001 
//STRIP001 	// Kontroll Stream positionieren
//STRIP001 	rStCtrl.Seek( nOffsDgg );
//STRIP001 
//STRIP001 	BYTE   nVer;
//STRIP001 	USHORT nInst;
//STRIP001 	USHORT nFbt;
//STRIP001 	ULONG  nLength;
//STRIP001 	if( !this->ReadCommonRecordHeader( rStCtrl, nVer, nInst, nFbt, nLength ) ) return;
//STRIP001 
//STRIP001 	BOOL bOk;
//STRIP001 	ULONG nPos = nOffsDgg + DFF_COMMON_RECORD_HEADER_SIZE;
//STRIP001 
//STRIP001 	// Fall A: erst Drawing Group Container, dann n Mal Drawing Container
//STRIP001 	if( DFF_msofbtDggContainer == nFbt )
//STRIP001 	{
//STRIP001 		GetDrawingGroupContainerData( rStCtrl, nLength );
//STRIP001 
//STRIP001 		 rStCtrl.Seek( STREAM_SEEK_TO_END );
//STRIP001 		UINT32 nMaxStrPos = rStCtrl.Tell();
//STRIP001 
//STRIP001 		nPos += nLength;
//STRIP001 		do
//STRIP001 		{
//STRIP001 			rStCtrl.Seek( nPos );
//STRIP001 
//STRIP001 			bOk = ReadCommonRecordHeader( rStCtrl, nVer, nInst, nFbt, nLength ) && ( DFF_msofbtDgContainer == nFbt );
//STRIP001 
//STRIP001 			if( !bOk )
//STRIP001 			{
//STRIP001 				nPos++;
//STRIP001 				rStCtrl.Seek( nPos );
//STRIP001 				bOk = ReadCommonRecordHeader( rStCtrl, nVer, nInst, nFbt, nLength )
//STRIP001 						&& ( DFF_msofbtDgContainer == nFbt );
//STRIP001 			}
//STRIP001 			if( bOk )
//STRIP001 				GetDrawingContainerData( rStCtrl, nLength );
//STRIP001 			nPos += DFF_COMMON_RECORD_HEADER_SIZE + nLength;
//STRIP001 		}
//STRIP001 		while( nPos < nMaxStrPos && bOk );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // ab hier: Drawing Group Container  d.h. Dokument - weit gueltige Daten
//STRIP001 //                      =======================           ========
//STRIP001 //
//STRIP001 void SvxMSDffManager::GetDrawingGroupContainerData( SvStream& rSt, ULONG nLenDgg )
//STRIP001 {
//STRIP001 	BYTE   nVer;
//STRIP001 	USHORT nInst;
//STRIP001 	USHORT nFbt;
//STRIP001 	ULONG  nLength;
//STRIP001 
//STRIP001 	ULONG nLenBStoreCont = 0, nLenFBSE = 0, nRead = 0;
//STRIP001 
//STRIP001 	// Nach einem BStore Container suchen
//STRIP001 	do
//STRIP001 	{
//STRIP001 		if(!this->ReadCommonRecordHeader( rSt, nVer, nInst, nFbt, nLength)) return;
//STRIP001 		nRead += DFF_COMMON_RECORD_HEADER_SIZE + nLength;
//STRIP001 		if( DFF_msofbtBstoreContainer == nFbt )
//STRIP001 		{
//STRIP001 			nLenBStoreCont = nLength;       break;
//STRIP001 		}
//STRIP001 		rSt.SeekRel( nLength );
//STRIP001 	}
//STRIP001 	while( nRead < nLenDgg );
//STRIP001 
//STRIP001 	if( !nLenBStoreCont ) return;
//STRIP001 
//STRIP001 	// Im BStore Container alle Header der Container und Atome auslesen und die
//STRIP001 	// relevanten Daten aller enthaltenen FBSEs in unserem Pointer Array ablegen.
//STRIP001 	// Dabei zaehlen wir die gefundenen FBSEs im Member nBLIPCount mit.
//STRIP001 
//STRIP001 	const ULONG nSkipBLIPLen = 20;  // bis zu nBLIPLen zu ueberspringende Bytes
//STRIP001 	const ULONG nSkipBLIPPos =  4;  // dahinter bis zu nBLIPPos zu skippen
//STRIP001 
//STRIP001 	ULONG nBLIPLen = 0, nBLIPPos = 0;
//STRIP001 
//STRIP001 	nRead = 0;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		if(!this->ReadCommonRecordHeader( rSt, nVer, nInst, nFbt, nLength)) return;
//STRIP001 		nRead += DFF_COMMON_RECORD_HEADER_SIZE + nLength;
//STRIP001 		if( DFF_msofbtBSE == nFbt )
//STRIP001 		{
//STRIP001 			nLenFBSE = nLength;
//STRIP001 			// ist FBSE gross genug fuer unsere Daten
//STRIP001 			BOOL bOk = ( nSkipBLIPLen + 4 + nSkipBLIPPos + 4 <= nLenFBSE );
//STRIP001 
//STRIP001 			if( bOk )
//STRIP001 			{
//STRIP001 				rSt.SeekRel( nSkipBLIPLen );
//STRIP001 				rSt >> nBLIPLen;
//STRIP001 				rSt.SeekRel( nSkipBLIPPos );
//STRIP001 				rSt >> nBLIPPos;
//STRIP001 				bOk = rSt.GetError() == 0;
//STRIP001 
//STRIP001 				nLength -= nSkipBLIPLen+ 4 + nSkipBLIPPos + 4;
//STRIP001 				if( 0 > nLength )
//STRIP001 					nLength = 0;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bOk )
//STRIP001 			{
//STRIP001 				// Besonderheit:
//STRIP001 				// Falls nBLIPLen kleiner ist als nLenFBSE UND nBLIPPos Null ist,
//STRIP001 				// nehmen wir an, dass das Bild IM FBSE drin steht!
//STRIP001 				if( (!nBLIPPos) && (nBLIPLen < nLenFBSE) )
//STRIP001 					nBLIPPos = rSt.Tell() + 4;
//STRIP001 
//STRIP001 				// Das hat ja fein geklappt!
//STRIP001 				// Wir merken uns, dass wir einen FBSE mehr im Pointer Array haben.
//STRIP001 				nBLIPPos = Calc_nBLIPPos(nBLIPPos, rSt.Tell());
//STRIP001 
//STRIP001 				if( USHRT_MAX == nBLIPCount )
//STRIP001 					nBLIPCount = 1;
//STRIP001 				else
//STRIP001 					nBLIPCount++;
//STRIP001 
//STRIP001 				// Jetzt die Infos fuer spaetere Zugriffe speichern
//STRIP001 				pBLIPInfos->Insert( new SvxMSDffBLIPInfo( nInst, nBLIPPos, nBLIPLen ),
//STRIP001 														  pBLIPInfos->Count() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		rSt.SeekRel( nLength );
//STRIP001 	}
//STRIP001 	while( nRead < nLenBStoreCont );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // ab hier: Drawing Container  d.h. Seiten (Blatt, Dia) - weit gueltige Daten
//STRIP001 //                      =================               ======
//STRIP001 //
//STRIP001 void SvxMSDffManager::GetDrawingContainerData( SvStream& rSt, ULONG nLenDg )
//STRIP001 {
//STRIP001 	BYTE nVer;USHORT nInst;USHORT nFbt;ULONG nLength;
//STRIP001 
//STRIP001 	ULONG nReadDg = 0;
//STRIP001 
//STRIP001 	// Wir stehen in einem Drawing Container (je einer pro Seite)
//STRIP001 	// und muessen nun
//STRIP001 	// alle enthaltenen Shape Group Container abklappern
//STRIP001 	do
//STRIP001 	{
//STRIP001 		if(!this->ReadCommonRecordHeader( rSt, nVer, nInst, nFbt, nLength)) return;
//STRIP001 		nReadDg += DFF_COMMON_RECORD_HEADER_SIZE;
//STRIP001 		// Patriarch gefunden (der oberste Shape Group Container) ?
//STRIP001 		if( DFF_msofbtSpgrContainer == nFbt )
//STRIP001 		{
//STRIP001 			if(!this->GetShapeGroupContainerData( rSt, nLength, TRUE)) return;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		// blanker Shape Container ? (ausserhalb vom Shape Group Container)
//STRIP001 		if( DFF_msofbtSpContainer == nFbt )
//STRIP001 		{
//STRIP001 			if(!this->GetShapeContainerData( rSt, nLength)) return;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rSt.SeekRel( nLength );
//STRIP001 		nReadDg += nLength;
//STRIP001 	}
//STRIP001 	while( nReadDg < nLenDg );
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SvxMSDffManager::GetShapeGroupContainerData( SvStream& rSt,
//STRIP001 												  ULONG nLenShapeGroupCont,
//STRIP001 												  BOOL bPatriarch )
//STRIP001 {
//STRIP001 	BYTE nVer;USHORT nInst;USHORT nFbt;ULONG nLength;
//STRIP001 	long nStartShapeGroupCont = rSt.Tell();
//STRIP001 	// Wir stehen in einem Shape Group Container (ggfs. mehrere pro Seite)
//STRIP001 	// und muessen nun
//STRIP001 	// alle enthaltenen Shape Container abklappern
//STRIP001 	BOOL  bFirst = !bPatriarch;
//STRIP001 	ULONG nReadSpGrCont = 0;
//STRIP001 	do
//STRIP001 	{
//STRIP001 		if( !this->ReadCommonRecordHeader( rSt, nVer, nInst, nFbt, nLength ) )
//STRIP001 			return FALSE;
//STRIP001 		nReadSpGrCont += DFF_COMMON_RECORD_HEADER_SIZE;
//STRIP001 		// Shape Container ?
//STRIP001 		if( DFF_msofbtSpContainer == nFbt )
//STRIP001 		{
//STRIP001 			ULONG nGroupOffs = bFirst ? nStartShapeGroupCont - DFF_COMMON_RECORD_HEADER_SIZE : ULONG_MAX;
//STRIP001 			if ( !this->GetShapeContainerData( rSt, nLength, nGroupOffs ) )
//STRIP001 				return FALSE;
//STRIP001 			bFirst = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		// eingeschachtelter Shape Group Container ?
//STRIP001 		if( DFF_msofbtSpgrContainer == nFbt )
//STRIP001 		{
//STRIP001 			if ( !this->GetShapeGroupContainerData( rSt, nLength, FALSE ) )
//STRIP001 				return FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rSt.SeekRel( nLength );
//STRIP001 		nReadSpGrCont += nLength;
//STRIP001 	}
//STRIP001 	while( nReadSpGrCont < nLenShapeGroupCont );
//STRIP001 	// den Stream wieder korrekt positionieren
//STRIP001 	rSt.Seek( nStartShapeGroupCont + nLenShapeGroupCont );
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SvxMSDffManager::GetShapeContainerData( SvStream& rSt, ULONG nLenShapeCont, ULONG nPosGroup )
//STRIP001 {
//STRIP001 	BYTE nVer;USHORT nInst;USHORT nFbt;ULONG nLength;
//STRIP001 	long  nStartShapeCont = rSt.Tell();
//STRIP001 	// Wir stehen in einem Shape Container (ggfs. mehrere pro Sh. Group)
//STRIP001 	// und muessen nun
//STRIP001 	// die Shape Id und File-Pos (fuer spaetere, erneute Zugriffe)
//STRIP001 	// und den ersten BStore Verweis (falls vorhanden) entnehmen
//STRIP001 	ULONG nLenShapePropTbl = 0;
//STRIP001 	ULONG nReadSpCont = 0;
//STRIP001 
//STRIP001 	// File Offset des Shape-Containers bzw. der Gruppe(!) vermerken
//STRIP001 	//
//STRIP001 	ULONG nStartOffs = (ULONG_MAX > nPosGroup) ?
//STRIP001 							nPosGroup : nStartShapeCont - DFF_COMMON_RECORD_HEADER_SIZE;
//STRIP001 	SvxMSDffShapeInfo aInfo( nStartOffs );
//STRIP001 
//STRIP001 	// duerfte das Shape durch einen Rahmen ersetzt werden ?
//STRIP001 	// (vorausgesetzt, es zeigt sich, dass es eine TextBox ist,
//STRIP001 	//  und der Text nicht gedreht ist)
//STRIP001 	BOOL bCanBeReplaced = (ULONG_MAX > nPosGroup) ? FALSE : TRUE;
//STRIP001 
//STRIP001 	// wir wissen noch nicht, ob es eine TextBox ist
//STRIP001 	MSO_SPT			eShapeType		= mso_sptNil;
//STRIP001 	MSO_WrapMode	eWrapMode		= mso_wrapSquare;
//STRIP001 	BOOL			bIsTextBox		= FALSE;
//STRIP001 
//STRIP001 	// Shape analysieren
//STRIP001 	//
//STRIP001 	do
//STRIP001 	{
//STRIP001 		if(!this->ReadCommonRecordHeader( rSt, nVer, nInst, nFbt, nLength)) return FALSE;
//STRIP001 		nReadSpCont += DFF_COMMON_RECORD_HEADER_SIZE;
//STRIP001 		// FSP ?
//STRIP001 		if( ( DFF_msofbtSp == nFbt ) && ( 4 <= nLength ) )
//STRIP001 		{
//STRIP001 			// Wir haben den FSP gefunden: Shape Typ und Id vermerken!
//STRIP001 			eShapeType = (MSO_SPT)nInst;
//STRIP001 			rSt >> aInfo.nShapeId;
//STRIP001 			rSt.SeekRel( nLength - 4 );
//STRIP001 			nReadSpCont += nLength;
//STRIP001 		}
//STRIP001 		else if( DFF_msofbtOPT == nFbt ) // Shape Property Table ?
//STRIP001 		{
//STRIP001 			// Wir haben die Property Table gefunden:
//STRIP001 			// nach der Blip Property suchen!
//STRIP001 			ULONG  nPropRead = 0;
//STRIP001 			USHORT nPropId;
//STRIP001 			ULONG  nPropVal;
//STRIP001 			nLenShapePropTbl = nLength;
//STRIP001 			UINT32 nPropCount = nInst;
//STRIP001 			long nStartShapePropTbl = rSt.Tell();
//STRIP001 			UINT32 nComplexDataFilePos = nStartShapePropTbl + (nPropCount * 6);
//STRIP001 			do
//STRIP001 			{
//STRIP001 				rSt >> nPropId
//STRIP001 					>> nPropVal;
//STRIP001 				nPropRead += 6;
//STRIP001 
//STRIP001 				switch( nPropId )
//STRIP001 				{
//STRIP001 					case DFF_Prop_txflTextFlow :
//STRIP001                         //Writer can now handle vertical textflows in its
//STRIP001                         //native frames, to only need to do this for the
//STRIP001                         //other two formats
//STRIP001                       
//STRIP001                         //Writer will handle all textflow except BtoT
//STRIP001 						if (GetSvxMSDffSettings() & 
//STRIP001                             (SVXMSDFF_SETTINGS_IMPORT_PPT | 
//STRIP001                              SVXMSDFF_SETTINGS_IMPORT_EXCEL))
//STRIP001                         {
//STRIP001                             if( 0 != nPropVal )
//STRIP001                                 bCanBeReplaced = false;
//STRIP001                         }
//STRIP001                         else if (
//STRIP001                             (nPropVal != mso_txflHorzN) && 
//STRIP001                             (nPropVal != mso_txflTtoBA)
//STRIP001                                 )
//STRIP001                         {
//STRIP001                             bCanBeReplaced = false;
//STRIP001                         }
//STRIP001 					break;
//STRIP001 					case DFF_Prop_cdirFont :
//STRIP001                         //Writer can now handle right to left and left
//STRIP001                         //to right in its native frames, so only do
//STRIP001                         //this for the other two formats.
//STRIP001 						if (GetSvxMSDffSettings() & 
//STRIP001                             (SVXMSDFF_SETTINGS_IMPORT_PPT | 
//STRIP001                              SVXMSDFF_SETTINGS_IMPORT_EXCEL))
//STRIP001                         {
//STRIP001                             if( 0 != nPropVal )
//STRIP001                                 bCanBeReplaced = FALSE;
//STRIP001                         }
//STRIP001                     break;
//STRIP001 					case DFF_Prop_Rotation :
//STRIP001 						if( 0 != nPropVal )
//STRIP001 							bCanBeReplaced = FALSE;
//STRIP001 					break;
//STRIP001 
//STRIP001 					case DFF_Prop_gtextFStrikethrough :
//STRIP001 						if( ( 0x20002000 & nPropVal )  == 0x20002000 )
//STRIP001 							bCanBeReplaced = FALSE;
//STRIP001 					break;
//STRIP001 
//STRIP001 					case DFF_Prop_fc3DLightFace :
//STRIP001 						if( ( 0x00080008 & nPropVal ) == 0x00080008 )
//STRIP001 							bCanBeReplaced = FALSE;
//STRIP001 					break;
//STRIP001 
//STRIP001 					case DFF_Prop_WrapText :
//STRIP001 						eWrapMode = (MSO_WrapMode)nPropVal;
//STRIP001 					break;
//STRIP001 
//STRIP001 					default:
//STRIP001 					{
//STRIP001 						// Bit gesetzt und gueltig?
//STRIP001 						if( 0x4000 == ( nPropId & 0xC000 ) )
//STRIP001 						{
//STRIP001 							// Blip Property gefunden: BStore Idx vermerken!
//STRIP001 							nPropRead = nLenShapePropTbl;
//STRIP001 						}
//STRIP001 						else if( 0x8000 & nPropId )
//STRIP001 						{
//STRIP001 							// komplexe Prop gefunden:
//STRIP001 							// Laenge ist immer 6, nur die Laenge der nach der
//STRIP001 							// eigentlichen Prop-Table anhaengenden Extra-Daten
//STRIP001 							// ist unterschiedlich
//STRIP001 							nPropVal = 6;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 /*
//STRIP001 //JP 21.04.99: Bug 64510
//STRIP001 // alte Version, die unter OS/2 zu Compilerfehlern fuehrt und damit arge
//STRIP001 // Performance einbussen hat.
//STRIP001 
//STRIP001 				if( 0x4000 == ( nPropId & 0xC000 ) )// Bit gesetzt und gueltig?
//STRIP001 				{
//STRIP001 					// Blip Property gefunden: BStore Idx vermerken!
//STRIP001 					aInfo.nBStoreIdx = nPropVal;    // Index im BStore Container
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				if(    (    (    (DFF_Prop_txflTextFlow   == nPropId)
//STRIP001 							  || (DFF_Prop_Rotation       == nPropId)
//STRIP001 							  || (DFF_Prop_cdirFont       == nPropId) )
//STRIP001 						 && (0 != nPropVal) )
//STRIP001 
//STRIP001 					|| (    (DFF_Prop_gtextFStrikethrough == nPropId)
//STRIP001 						 && ( (0x20002000 & nPropVal)  == 0x20002000) ) // also DFF_Prop_gtextFVertical
//STRIP001 					|| (    (DFF_Prop_fc3DLightFace       == nPropId)
//STRIP001 						 && ( (0x00080008 & nPropVal)  == 0x00080008) )	// also DFF_Prop_f3D
//STRIP001 				  )
//STRIP001 				{
//STRIP001 					bCanBeReplaced = FALSE;  // Mist: gedrehter Text oder 3D-Objekt!
//STRIP001 				}
//STRIP001 				else
//STRIP001 				if( DFF_Prop_WrapText == nPropId )
//STRIP001 				{
//STRIP001 					eWrapMode = (MSO_WrapMode)nPropVal;
//STRIP001 				}
//STRIP001 				////////////////////////////////////////////////////////////////
//STRIP001 				////////////////////////////////////////////////////////////////
//STRIP001 				// keine weitere Property-Auswertung: folge beim Shape-Import //
//STRIP001 				////////////////////////////////////////////////////////////////
//STRIP001 				////////////////////////////////////////////////////////////////
//STRIP001 				else
//STRIP001 				if( 0x8000 & nPropId )
//STRIP001 				{
//STRIP001 					// komplexe Prop gefunden: Laenge lesen und ueberspringen
//STRIP001 					if(!SkipBytes( rSt, nPropVal )) return FALSE;
//STRIP001 					nPropRead += nPropVal;
//STRIP001 				}
//STRIP001 */
//STRIP001 			}
//STRIP001 			while( nPropRead < nLenShapePropTbl );
//STRIP001 			rSt.Seek( nStartShapePropTbl + nLenShapePropTbl );
//STRIP001 			nReadSpCont += nLenShapePropTbl;
//STRIP001 		}
//STRIP001 		else if( ( DFF_msofbtClientTextbox == nFbt ) && ( 4 == nLength ) )	// Text-Box-Story-Eintrag gefunden
//STRIP001 		{
//STRIP001 			rSt >> aInfo.nTxBxComp;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rSt.SeekRel( nLength );
//STRIP001 			nReadSpCont += nLength;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	while( nReadSpCont < nLenShapeCont );
//STRIP001 
//STRIP001 	//
//STRIP001 	// Jetzt ggfs. die Infos fuer spaetere Zugriffe auf das Shape speichern
//STRIP001 	//
//STRIP001 	if( aInfo.nShapeId )
//STRIP001 	{
//STRIP001 		// fuer Textboxen ggfs. ersetzen durch Rahmen erlauben
//STRIP001 		if(     bCanBeReplaced
//STRIP001 			 && aInfo.nTxBxComp
//STRIP001 			 && (
//STRIP001 					( eShapeType == mso_sptTextSimple )
//STRIP001 				 || ( eShapeType == mso_sptTextBox    )
//STRIP001 				 || (    (    ( eShapeType == mso_sptRectangle      )
//STRIP001 						   || ( eShapeType == mso_sptRoundRectangle )
//STRIP001 						 )
//STRIP001 					  && ( eWrapMode == mso_wrapSquare )
//STRIP001 				) ) )
//STRIP001 		{
//STRIP001 			aInfo.bReplaceByFly = TRUE;
//STRIP001 		}
//STRIP001 		pShapeInfos->Insert(  new SvxMSDffShapeInfo(  aInfo          ) );
//STRIP001 		pShapeOrders->Insert( new SvxMSDffShapeOrder( aInfo.nShapeId ),
//STRIP001 							  pShapeOrders->Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// und den Stream wieder korrekt positionieren
//STRIP001 	rSt.Seek( nStartShapeCont + nLenShapeCont );
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 /*****************************************************************************
//STRIP001 
//STRIP001 	Zugriff auf ein Shape zur Laufzeit (ueber die Shape-Id)
//STRIP001 	----------------------------------
//STRIP001 ******************************************************************************/
//STRIP001 BOOL SvxMSDffManager::GetShape(ULONG nId, SdrObject*&         rpShape,
//STRIP001 										  SvxMSDffImportData& rData)
//STRIP001 {
//STRIP001 	SvxMSDffShapeInfo aTmpRec(0, nId);
//STRIP001 	aTmpRec.bSortByShapeId = TRUE;
//STRIP001 
//STRIP001 	USHORT nFound;
//STRIP001 	if( pShapeInfos->Seek_Entry(&aTmpRec, &nFound) )
//STRIP001 	{
//STRIP001 		SvxMSDffShapeInfo& rInfo = *pShapeInfos->GetObject( nFound );
//STRIP001 
//STRIP001 		// eventuell altes Errorflag loeschen
//STRIP001 		if( rStCtrl.GetError() )
//STRIP001 			rStCtrl.ResetError();
//STRIP001 		// FilePos des/der Stream(s) merken
//STRIP001 		ULONG nOldPosCtrl = rStCtrl.Tell();
//STRIP001 		ULONG nOldPosData = pStData ? pStData->Tell() : nOldPosCtrl;
//STRIP001 		// das Shape im Steuer Stream anspringen
//STRIP001 		rStCtrl.Seek( rInfo.nFilePos );
//STRIP001 
//STRIP001 		// Falls missglueckt, den Fehlerstatus zuruecksetzen und Pech gehabt!
//STRIP001 		if( rStCtrl.GetError() )
//STRIP001 			rStCtrl.ResetError();
//STRIP001 		else
//STRIP001 			//rpShape = ImportObjAtCurrentStreamPos( rStCtrl, rData );
//STRIP001 			rpShape = ImportObj( rStCtrl, &rData, &rData.aParentRect );
//STRIP001 
//STRIP001 		// alte FilePos des/der Stream(s) restaurieren
//STRIP001 		rStCtrl.Seek( nOldPosCtrl );
//STRIP001 		if( &rStCtrl != pStData )
//STRIP001 			pStData->Seek( nOldPosData );
//STRIP001 		return ( 0 != rpShape );
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 /*      Zugriff auf ein BLIP zur Laufzeit (bei bereits bekannter Blip-Nr)
//STRIP001 	---------------------------------
//STRIP001 ******************************************************************************/
//STRIP001 BOOL SvxMSDffManager::GetBLIP(ULONG nIdx_, Graphic& rData) const
//STRIP001 {
//STRIP001 	BOOL bOk = FALSE;       // Ergebnisvariable initialisieren
//STRIP001 	if ( pStData )
//STRIP001 	{
//STRIP001         // check if a graphic for this blipId is already imported
//STRIP001         if ( nIdx_ && pEscherBlipCache )
//STRIP001         {
//STRIP001             EscherBlipCacheEntry* pEntry; 
//STRIP001             for ( pEntry = (EscherBlipCacheEntry*)pEscherBlipCache->First(); pEntry;
//STRIP001                     pEntry = (EscherBlipCacheEntry*)pEscherBlipCache->Next() )
//STRIP001             {
//STRIP001                 if ( pEntry->nBlip == nIdx_ )
//STRIP001                 {	/* if this entry is available, then it should be possible
//STRIP001 					to get the Graphic via GraphicObject */
//STRIP001 					GraphicObject aGraphicObject( pEntry->aUniqueID );
//STRIP001                     rData = aGraphicObject.GetGraphic();
//STRIP001 					if ( rData.GetType() != GRAPHIC_NONE )
//STRIP001 	                    bOk = sal_True;
//STRIP001 					else
//STRIP001 						delete (EscherBlipCacheEntry*)pEscherBlipCache->Remove();
//STRIP001 					break;
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         if ( !bOk )
//STRIP001         {
//STRIP001 		    USHORT nIdx = USHORT( nIdx_ );
//STRIP001 		    if( !nIdx || (pBLIPInfos->Count() < nIdx) ) return FALSE;
//STRIP001 
//STRIP001 		    // eventuell alte(s) Errorflag(s) loeschen
//STRIP001 		    if( rStCtrl.GetError() )
//STRIP001 			    rStCtrl.ResetError();
//STRIP001 		    if(    ( &rStCtrl != pStData )
//STRIP001 			    && pStData->GetError() )
//STRIP001 			    pStData->ResetError();
//STRIP001 
//STRIP001 		    // FilePos des/der Stream(s) merken
//STRIP001 		    ULONG nOldPosCtrl = rStCtrl.Tell();
//STRIP001 		    ULONG nOldPosData = pStData ? pStData->Tell() : nOldPosCtrl;
//STRIP001 
//STRIP001 		    // passende Info-Struct aus unserem Pointer Array nehmen
//STRIP001 		    SvxMSDffBLIPInfo& rInfo = *(*pBLIPInfos)[ nIdx-1 ];
//STRIP001 
//STRIP001 		    // das BLIP Atom im Daten Stream anspringen
//STRIP001 		    pStData->Seek( rInfo.nFilePos );
//STRIP001 		    // ggfs. Fehlerstatus zuruecksetzen
//STRIP001 		    if( pStData->GetError() )
//STRIP001 			    pStData->ResetError();
//STRIP001 		    else
//STRIP001 			    bOk = GetBLIPDirect( *pStData, rData );
//STRIP001 		    if( pStData2 && !bOk )
//STRIP001 		    {
//STRIP001 			    // Fehler, aber zweite Chance: es gibt noch einen zweiten
//STRIP001 			    //         Datenstream, in dem die Grafik liegen koennte!
//STRIP001 			    if( pStData2->GetError() )
//STRIP001 				    pStData2->ResetError();
//STRIP001 			    ULONG nOldPosData2 = pStData2->Tell();
//STRIP001 			    // das BLIP Atom im zweiten Daten Stream anspringen
//STRIP001 			    pStData2->Seek( rInfo.nFilePos );
//STRIP001 			    // ggfs. Fehlerstatus zuruecksetzen
//STRIP001 			    if( pStData2->GetError() )
//STRIP001 				    pStData2->ResetError();
//STRIP001 			    else
//STRIP001 				    bOk = GetBLIPDirect( *pStData2, rData );
//STRIP001 			    // alte FilePos des zweiten Daten-Stream restaurieren
//STRIP001 			    pStData2->Seek( nOldPosData2 );
//STRIP001 		    }
//STRIP001 		    // alte FilePos des/der Stream(s) restaurieren
//STRIP001 		    rStCtrl.Seek( nOldPosCtrl );
//STRIP001 		    if( &rStCtrl != pStData )
//STRIP001 		      pStData->Seek( nOldPosData );
//STRIP001 
//STRIP001             if ( bOk )
//STRIP001             {
//STRIP001                 // create new BlipCacheEntry for this graphic
//STRIP001 				GraphicObject aGraphicObject( rData );
//STRIP001                 if ( !pEscherBlipCache )
//STRIP001                     const_cast <SvxMSDffManager*> (this)->pEscherBlipCache = new List();
//STRIP001                 EscherBlipCacheEntry* pNewEntry = new EscherBlipCacheEntry( nIdx_, aGraphicObject.GetUniqueID() );
//STRIP001                 pEscherBlipCache->Insert( pNewEntry, LIST_APPEND );
//STRIP001             }
//STRIP001         }
//STRIP001 	}
//STRIP001 	return bOk;
//STRIP001 }
//STRIP001 
//STRIP001 /*      Zugriff auf ein BLIP zur Laufzeit (mit korrekt positioniertem Stream)
//STRIP001 	---------------------------------
//STRIP001 ******************************************************************************/
//STRIP001 BOOL SvxMSDffManager::GetBLIPDirect(SvStream& rBLIPStream, Graphic& rData) const
//STRIP001 {
//STRIP001 	ULONG nOldPos = rBLIPStream.Tell();
//STRIP001 
//STRIP001 	int nRes = GRFILTER_OPENERROR;  // Fehlervariable initialisieren
//STRIP001 
//STRIP001 	// nachschauen, ob es sich auch wirklich um ein BLIP handelt
//STRIP001 	ULONG  nLength;
//STRIP001 	USHORT nInst, nFbt;
//STRIP001 	BYTE   nVer;
//STRIP001 	if( ReadCommonRecordHeader( rBLIPStream, nVer, nInst, nFbt, nLength) && ( 0xF018 <= nFbt ) && ( 0xF117 >= nFbt ) )
//STRIP001 	{
//STRIP001 		Size		aMtfSize100;
//STRIP001 		BOOL		bMtfBLIP = FALSE;
//STRIP001 		BOOL		bZCodecCompression = FALSE;
//STRIP001 		// Nun exakt auf den Beginn der eingebetteten Grafik positionieren
//STRIP001 		ULONG nSkip = ( nInst & 0x0001 ) ? 32 : 16;
//STRIP001 
//STRIP001 		switch( nInst & 0xFFFE )
//STRIP001 		{
//STRIP001 			case 0x216 :			// Metafile header then compressed WMF
//STRIP001 			case 0x3D4 :			// Metafile header then compressed EMF
//STRIP001 			case 0x542 :			// Metafile hd. then compressed PICT
//STRIP001 			{
//STRIP001 				rBLIPStream.SeekRel( nSkip + 20 );
//STRIP001 
//STRIP001 				// read in size of metafile in EMUS
//STRIP001 				rBLIPStream >> aMtfSize100.Width() >> aMtfSize100.Height();
//STRIP001 
//STRIP001 				// scale to 1/100mm
//STRIP001 				aMtfSize100.Width() /= 360, aMtfSize100.Height() /= 360;
//STRIP001 
//STRIP001 				// skip rest of header
//STRIP001 				nSkip = 6;
//STRIP001 				bMtfBLIP = bZCodecCompression = TRUE;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 			case 0x46A :			// One byte tag then JPEG (= JFIF) data
//STRIP001 			case 0x6E0 :			// One byte tag then PNG data
//STRIP001 			case 0x7A8 :
//STRIP001 				nSkip += 1;			// One byte tag then DIB data
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		rBLIPStream.SeekRel( nSkip );
//STRIP001 
//STRIP001 		SvStream* pGrStream = &rBLIPStream;
//STRIP001 		SvMemoryStream* pOut = 0;
//STRIP001 		if( bZCodecCompression )
//STRIP001 		{
//STRIP001 			pOut = new SvMemoryStream( 0x8000, 0x4000 );
//STRIP001 			if ( ZCodecDecompressed( rBLIPStream, *pOut, TRUE ) )
//STRIP001 				pGrStream = pOut;
//STRIP001 		}
//STRIP001 
//STRIP001 #ifdef DBG_EXTRACTGRAPHICS
//STRIP001 
//STRIP001 		static sal_Int32 nCount;
//STRIP001 
//STRIP001 		String aFileName( String( RTL_CONSTASCII_STRINGPARAM( "dbggfx" ) ) );
//STRIP001 		aFileName.Append( String::CreateFromInt32( nCount++ ) );
//STRIP001 		switch( nInst &~ 1 )
//STRIP001 		{
//STRIP001 			case 0x216 : aFileName.Append( String( RTL_CONSTASCII_STRINGPARAM( ".wmf" ) ) ); break;
//STRIP001 			case 0x3d4 : aFileName.Append( String( RTL_CONSTASCII_STRINGPARAM( ".emf" ) ) ); break;
//STRIP001 			case 0x542 : aFileName.Append( String( RTL_CONSTASCII_STRINGPARAM( ".pct" ) ) ); break;
//STRIP001 			case 0x46a : aFileName.Append( String( RTL_CONSTASCII_STRINGPARAM( ".jpg" ) ) ); break;
//STRIP001 			case 0x6e0 : aFileName.Append( String( RTL_CONSTASCII_STRINGPARAM( ".png" ) ) ); break;
//STRIP001 			case 0x7a8 : aFileName.Append( String( RTL_CONSTASCII_STRINGPARAM( ".bmp" ) ) ); break;
//STRIP001 		}
//STRIP001 
//STRIP001 		String aURLStr;
//STRIP001 
//STRIP001 		if( ::utl::LocalFileHelper::ConvertPhysicalNameToURL( Application::GetAppFileName(), aURLStr ) )
//STRIP001 		{
//STRIP001 			INetURLObject aURL( aURLStr );
//STRIP001 
//STRIP001 			aURL.removeSegment();
//STRIP001 			aURL.removeFinalSlash();
//STRIP001 			aURL.Append( aFileName );
//STRIP001 
//STRIP001 			SvStream* pDbgOut = ::utl::UcbStreamHelper::CreateStream( aURL.GetMainURL( INetURLObject::NO_DECODE ), STREAM_TRUNC | STREAM_WRITE );
//STRIP001 
//STRIP001 			if( pDbgOut )
//STRIP001 			{
//STRIP001 				if ( bZCodecCompression )
//STRIP001 				{
//STRIP001 					pOut->Seek( STREAM_SEEK_TO_END );
//STRIP001 					pDbgOut->Write( pOut->GetData(), pOut->Tell() );
//STRIP001 					pOut->Seek( STREAM_SEEK_TO_BEGIN );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					sal_Int32 nDbgLen = nLength - nSkip;
//STRIP001 					if ( nDbgLen )
//STRIP001 					{
//STRIP001 						sal_Char* pDat = new sal_Char[ nDbgLen ];
//STRIP001 						pGrStream->Read( pDat, nDbgLen );
//STRIP001 						pDbgOut->Write( pDat, nDbgLen );
//STRIP001 						pGrStream->SeekRel( -nDbgLen );
//STRIP001 						delete[] pDat;
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				delete pDbgOut;
//STRIP001 			}
//STRIP001 		}
//STRIP001 #endif
//STRIP001 
//STRIP001 		if( ( nInst & 0xFFFE ) == 0x7A8 )
//STRIP001 		{	// DIBs direkt holen
//STRIP001 			Bitmap aNew;
//STRIP001 			if( aNew.Read( *pGrStream, FALSE ) )
//STRIP001 			{
//STRIP001 				rData = Graphic( aNew );
//STRIP001 				nRes = GRFILTER_OK;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{	// und unsere feinen Filter darauf loslassen
//STRIP001 			GraphicFilter* pGF = GetGrfFilter();
//STRIP001 			String aEmptyStr;
//STRIP001 			nRes = pGF->ImportGraphic( rData, aEmptyStr, *pGrStream, GRFILTER_FORMAT_DONTKNOW );
//STRIP001 
//STRIP001 			if( bMtfBLIP && ( GRFILTER_OK == nRes ) && ( rData.GetType() == GRAPHIC_GDIMETAFILE ) )
//STRIP001 			{
//STRIP001 				if ( ( aMtfSize100.Width() >= 1000 ) && ( aMtfSize100.Height() >= 1000 ) )
//STRIP001 				{	// #75956#, scaling does not work properly, if the graphic is less than 1cm
//STRIP001 					GDIMetaFile	aMtf( rData.GetGDIMetaFile() );
//STRIP001 					const Size	aOldSize( aMtf.GetPrefSize() );
//STRIP001 
//STRIP001 					if( aOldSize.Width() && ( aOldSize.Width() != aMtfSize100.Width() ) &&
//STRIP001 						aOldSize.Height() && ( aOldSize.Height() != aMtfSize100.Height() ) )
//STRIP001 					{
//STRIP001 						aMtf.Scale( (double) aMtfSize100.Width() / aOldSize.Width(),
//STRIP001 									(double) aMtfSize100.Height() / aOldSize.Height() );
//STRIP001 						aMtf.SetPrefSize( aMtfSize100 );
//STRIP001 						aMtf.SetPrefMapMode( MAP_100TH_MM );
//STRIP001 						rData = aMtf;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// ggfs. Fehlerstatus zuruecksetzen
//STRIP001 		if ( ERRCODE_IO_PENDING == pGrStream->GetError() )
//STRIP001 		  pGrStream->ResetError();
//STRIP001 		delete pOut;
//STRIP001 	}
//STRIP001 	rBLIPStream.Seek( nOldPos );    // alte FilePos des Streams restaurieren
//STRIP001 
//STRIP001 	return ( GRFILTER_OK == nRes ); // Ergebniss melden
//STRIP001 }
//STRIP001 
//STRIP001 /*static*/
//STRIP001 
//STRIP001 #define ZCODEC_DEC_BUFSIZE 0x4000
//STRIP001 
//STRIP001 BOOL SvxMSDffManager::ZCodecDecompressed( SvStream& rIn, SvStream& rOut, BOOL bLookForEnd )
//STRIP001 {
//STRIP001 	long nOutStartPos = rOut.Tell();
//STRIP001 	long nBytesOut = 0;
//STRIP001 
//STRIP001 	ZCodec aZCodec;
//STRIP001 	aZCodec.BeginCompression();
//STRIP001 
//STRIP001 	if( bLookForEnd )
//STRIP001 	{
//STRIP001 		BYTE* pBuf = new BYTE[ ZCODEC_DEC_BUFSIZE ];
//STRIP001 		long  nBytesRead;
//STRIP001 		while( TRUE )
//STRIP001 		{
//STRIP001 			nBytesRead = aZCodec.Read( rIn, pBuf, ZCODEC_DEC_BUFSIZE );
//STRIP001 			if( nBytesRead > 0 )
//STRIP001 			{
//STRIP001 				rOut.Write( pBuf, nBytesRead );
//STRIP001 				nBytesOut += nBytesRead;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		if( nBytesRead < 0 ) nBytesOut = 0;     // Error: Ergebnisse ungueltig !!
//STRIP001 		delete[] pBuf;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nBytesOut = aZCodec.Decompress( rIn, rOut );
//STRIP001 
//STRIP001 	aZCodec.EndCompression();
//STRIP001 
//STRIP001 	rOut.Seek( nOutStartPos );
//STRIP001 	return (0 < nBytesOut);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /* static */
//STRIP001 BOOL SvxMSDffManager::ReadCommonRecordHeader(DffRecordHeader& rRec, SvStream& rIn)
//STRIP001 {
//STRIP001 	rRec.nFilePos = rIn.Tell();
//STRIP001 	return SvxMSDffManager::ReadCommonRecordHeader( rIn,rRec.nRecVer,
//STRIP001 													rRec.nRecInstance,
//STRIP001 													rRec.nRecType,
//STRIP001 													rRec.nRecLen );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /* auch static */
//STRIP001 BOOL SvxMSDffManager::ReadCommonRecordHeader( SvStream& rSt,
//STRIP001 											  BYTE&     rVer,
//STRIP001 											  USHORT&   rInst,
//STRIP001 											  USHORT&   rFbt,
//STRIP001 											  ULONG&    rLength )
//STRIP001 {
//STRIP001 	sal_uInt16 nTmp;
//STRIP001 	rSt >> nTmp >> rFbt >> rLength;
//STRIP001 	rVer = nTmp & 15;
//STRIP001 	rInst = nTmp >> 4;
//STRIP001 	return rSt.GetError() == 0;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 BOOL SvxMSDffManager::ProcessClientAnchor(SvStream& rStData, ULONG nDatLen,
//STRIP001 										  char*& rpBuff, UINT32& rBuffLen ) const
//STRIP001 {
//STRIP001 	if( nDatLen )
//STRIP001 	{
//STRIP001 		rpBuff = new char[ nDatLen ];
//STRIP001 		rBuffLen = nDatLen;
//STRIP001 		rStData.Read( rpBuff, nDatLen );
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SvxMSDffManager::ProcessClientData(SvStream& rStData, ULONG nDatLen,
//STRIP001 										char*& rpBuff, UINT32& rBuffLen ) const
//STRIP001 {
//STRIP001 	if( nDatLen )
//STRIP001 	{
//STRIP001 		rpBuff = new char[ nDatLen ];
//STRIP001 		rBuffLen = nDatLen;
//STRIP001 		rStData.Read( rpBuff, nDatLen );
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SvxMSDffManager::ProcessClientAnchor2( SvStream& rSt, DffRecordHeader& rHd, void* pData, DffObjData& rObj )
//STRIP001 {
//STRIP001 	return;  // wird von SJ im Draw ueberladen
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 ULONG SvxMSDffManager::Calc_nBLIPPos( ULONG nOrgVal, ULONG nStreamPos ) const
//STRIP001 {
//STRIP001 	return nOrgVal;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SvxMSDffManager::GetOLEStorageName( long nOLEId, String& ,
//STRIP001 										SvStorageRef& , SvStorageRef& ) const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SvxMSDffManager::ShapeHasText( ULONG nShapeId, ULONG nFilePos ) const
//STRIP001 {
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 SdrObject* SvxMSDffManager::ImportOLE( long nOLEId, const Graphic& rGrf,
//STRIP001 										const Rectangle& rBoundRect ) const
//STRIP001 {
//STRIP001 	SdrObject* pRet = 0;
//STRIP001 	String sStorageName;
//STRIP001 	SvStorageRef xSrcStg, xDstStg;
//STRIP001 	if( GetOLEStorageName( nOLEId, sStorageName, xSrcStg, xDstStg ))
//STRIP001 		pRet = CreateSdrOLEFromStorage( sStorageName, xSrcStg, xDstStg,
//STRIP001 										rGrf, rBoundRect, pStData,
//STRIP001 										nSvxMSDffOLEConvFlags );
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 const GDIMetaFile* SvxMSDffManager::lcl_GetMetaFileFromGrf_Impl( const Graphic& rGrf,
//STRIP001 														GDIMetaFile& rMtf )
//STRIP001 {
//STRIP001 	const GDIMetaFile* pMtf;
//STRIP001 	if( GRAPHIC_BITMAP == rGrf.GetType() )
//STRIP001 	{
//STRIP001 		Point aPt;
//STRIP001         const Size aSz(lcl_GetPrefSize(rGrf, MAP_100TH_MM));
//STRIP001 
//STRIP001 		VirtualDevice aVirtDev;
//STRIP001 		aVirtDev.EnableOutput( FALSE );
//STRIP001 		MapMode aMM(MAP_100TH_MM);
//STRIP001 		aVirtDev.SetMapMode( aMM );
//STRIP001 
//STRIP001 		rMtf.Record( &aVirtDev );
//STRIP001 		rGrf.Draw( &aVirtDev, aPt, aSz );
//STRIP001 		rMtf.Stop();
//STRIP001 		rMtf.SetPrefMapMode(aMM);
//STRIP001 		rMtf.SetPrefSize( aSz );
//STRIP001 
//STRIP001 		pMtf = &rMtf;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pMtf = &rGrf.GetGDIMetaFile();
//STRIP001 	return pMtf;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 const SvInPlaceObjectRef SvxMSDffManager::CheckForConvertToSOObj( UINT32 nConvertFlags,
//STRIP001 						SvStorage& rSrcStg, SvStorage& rDestStorage,
//STRIP001 						const Graphic& rGrf )
//STRIP001 {
//STRIP001 	static struct _ObjImpType
//STRIP001 	{
//STRIP001 		UINT32 nFlag;
//STRIP001 		const char* pFactoryNm;
//STRIP001 		// GlobalNameId
//STRIP001 		UINT32 n1;
//STRIP001 		USHORT n2, n3;
//STRIP001 		BYTE b8, b9, b10, b11, b12, b13, b14, b15;
//STRIP001 	} aArr[] = {
//STRIP001 		{ OLE_MATHTYPE_2_STARMATH, "smath",
//STRIP001 			0x0002ce02L, 0x0000, 0x0000,
//STRIP001 			0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x46 },
//STRIP001 		{ OLE_MATHTYPE_2_STARMATH, "smath",
//STRIP001 			0x00021700L, 0x0000, 0x0000,
//STRIP001 			0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x46 },
//STRIP001 		{ OLE_WINWORD_2_STARWRITER, "swriter",
//STRIP001 			0x00020906L, 0x0000, 0x0000,
//STRIP001 			0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x46 },
//STRIP001 		{ OLE_EXCEL_2_STARCALC, "scalc",  				// Excel table
//STRIP001 			0x00020810L, 0x0000, 0x0000,
//STRIP001 			0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x46 },
//STRIP001 		{ OLE_EXCEL_2_STARCALC, "scalc",  				// Excel chart
//STRIP001 			0x00020820L, 0x0000, 0x0000,
//STRIP001 			0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x46 },
//STRIP001 		{ OLE_POWERPOINT_2_STARIMPRESS, "simpress",  	// PowerPoint presentation
//STRIP001 			0x64818d10L, 0x4f9b, 0x11cf,
//STRIP001 			0x86,0xea,0x00,0xaa,0x00,0xb9,0x29,0xe8 },
//STRIP001 		{ OLE_POWERPOINT_2_STARIMPRESS, "simpress",  	// PowerPoint slide
//STRIP001 			0x64818d11L, 0x4f9b, 0x11cf,
//STRIP001 			0x86,0xea,0x00,0xaa,0x00,0xb9,0x29,0xe8 },
//STRIP001 		{ 0,0 }
//STRIP001 	};
//STRIP001 
//STRIP001 	SvInPlaceObjectRef xIPObj;
//STRIP001 	SvGlobalName aStgNm;
//STRIP001 	BOOL bFirstCompare = TRUE;
//STRIP001 	for( const _ObjImpType* pArr = aArr; pArr->nFlag; ++pArr )
//STRIP001 		if( nConvertFlags & pArr->nFlag )
//STRIP001 		{
//STRIP001 			SvGlobalName aTypeName( pArr->n1, pArr->n2, pArr->n3,
//STRIP001 							pArr->b8, pArr->b9, pArr->b10, pArr->b11,
//STRIP001 							pArr->b12, pArr->b13, pArr->b14, pArr->b15 );
//STRIP001 			if( bFirstCompare )
//STRIP001 			{
//STRIP001 				aStgNm = rSrcStg.GetClassName();
//STRIP001 				bFirstCompare = FALSE;
//STRIP001 			}
//STRIP001 			if( aStgNm == aTypeName )
//STRIP001 			{
//STRIP001 				String sStarName( String::CreateFromAscii( pArr->pFactoryNm ));
//STRIP001 				const SfxObjectFactory* pFact =
//STRIP001 							SfxObjectFactory::GetFactory( sStarName );
//STRIP001 				if( pFact && pFact->GetFilterContainer() )
//STRIP001 				{
//STRIP001 					SfxMedium* pMed = new SfxMedium( &rSrcStg, FALSE );
//STRIP001 					const SfxFilter* pFilter = 0;
//STRIP001 					if( !pFact->GetFilterContainer()->
//STRIP001 						GetFilter4Content( *pMed, &pFilter ) && pFilter )
//STRIP001 					{
//STRIP001 						String aEmptyStr;
//STRIP001 
//STRIP001 						//then the StarFactory can import this storage
//STRIP001 						pMed->SetFilter( pFilter );
//STRIP001 						SvStorageRef xStor = new SvStorage( aEmptyStr);
//STRIP001 
//STRIP001 						SfxObjectShellRef xObjShell( pFact->CreateObject( SFX_CREATE_MODE_EMBEDDED ) );
//STRIP001 						if ( xObjShell.Is() )
//STRIP001 						{
//STRIP001 							xObjShell->OwnerLock( sal_True );
//STRIP001 							xIPObj = xObjShell->GetInPlaceObject();
//STRIP001 							String aDstStgName( String::CreateFromAscii(
//STRIP001 								RTL_CONSTASCII_STRINGPARAM( "MSO_OLE_Obj" )));
//STRIP001 
//STRIP001 							aDstStgName += String::CreateFromInt32( ++nMSOleObjCntr );
//STRIP001 
//STRIP001 							SvStorageRef xObjStor( rDestStorage.OpenUCBStorage(
//STRIP001 													aDstStgName,
//STRIP001 									STREAM_READWRITE| STREAM_SHARE_DENYALL));
//STRIP001 							xObjShell->DoLoad( pMed );
//STRIP001 							// JP 26.10.2001: Bug 93374 / 91928 the writer
//STRIP001 							// objects need the correct visarea needs the
//STRIP001 							// correct visarea, but this is not true for
//STRIP001 							// PowerPoint (see bugdoc 94908b)
//STRIP001 							// SJ: 19.11.2001 bug 94908, also chart objects
//STRIP001 							// needs the correct visarea
//STRIP001 							if( sStarName.EqualsAscii( "swriter" )
//STRIP001 								|| sStarName.EqualsAscii( "scalc" ) )   
//STRIP001 							{
//STRIP001 								Size aSz(lcl_GetPrefSize(rGrf, MapMode( xIPObj->GetMapUnit())));
//STRIP001 								// don't modify the object
//STRIP001 								xIPObj->EnableSetModified( FALSE );
//STRIP001 								xIPObj->SetVisArea( Rectangle( xIPObj->GetVisArea().TopLeft(), aSz ));
//STRIP001 								xIPObj->EnableSetModified( TRUE );
//STRIP001 							}
//STRIP001 							else if ( sStarName.EqualsAscii( "smath" ) )
//STRIP001 							{	// SJ: force the object to recalc its visarea
//STRIP001 								xIPObj->OnDocumentPrinterChanged( NULL );
//STRIP001 							}
//STRIP001 							xObjShell->DoSaveAs( xObjStor );
//STRIP001 							xObjShell->DoSaveCompleted( xObjStor );
//STRIP001 							pMed = 0;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					delete pMed;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	return xIPObj;
//STRIP001 }
//STRIP001 #endif
//STRIP001 
//STRIP001 SdrOle2Obj* SvxMSDffManager::CreateSdrOLEFromStorage(
//STRIP001 				const String& rStorageName,
//STRIP001 				SvStorageRef& rSrcStorage,
//STRIP001 				SvStorageRef& rDestStorage,
//STRIP001 				const Graphic& rGrf,
//STRIP001 				const Rectangle& rBoundRect,
//STRIP001 				SvStream* pDataStrm,
//STRIP001 				UINT32 nConvertFlags )
//STRIP001 {
//STRIP001 	SdrOle2Obj* pRet = 0;
//STRIP001 #ifndef SVX_LIGHT
//STRIP001 	if( rSrcStorage.Is() && rDestStorage.Is() && rStorageName.Len() )
//STRIP001 	{
//STRIP001 		// Ist der 01Ole-Stream ueberhaupt vorhanden ?
//STRIP001 		// ( ist er z.B. bei WordArt nicht )
//STRIP001 		// Wenn nicht -> Einbindung als Grafik
//STRIP001 		BOOL bValidStorage = FALSE;
//STRIP001 		String aDstStgName( String::CreateFromAscii(
//STRIP001 								RTL_CONSTASCII_STRINGPARAM( "MSO_OLE_Obj" )));
//STRIP001 
//STRIP001 		aDstStgName += String::CreateFromInt32( ++nMSOleObjCntr );
//STRIP001 		SvStorageRef xObjStor;
//STRIP001 
//STRIP001 		{
//STRIP001             SvStorageRef xObjStg = rSrcStorage->OpenStorage( rStorageName,
//STRIP001 								STREAM_READWRITE| STREAM_SHARE_DENYALL );
//STRIP001 			if( xObjStg.Is()  )
//STRIP001 			{
//STRIP001 				{
//STRIP001 					BYTE aTestA[10];	// exist the \1CompObj-Stream ?
//STRIP001 					SvStorageStreamRef xSrcTst = xObjStg->OpenStream(
//STRIP001 								String( RTL_CONSTASCII_STRINGPARAM( "\1CompObj" ),
//STRIP001 										RTL_TEXTENCODING_MS_1252 ));
//STRIP001 					bValidStorage = xSrcTst.Is() && sizeof( aTestA ) ==
//STRIP001 									xSrcTst->Read( aTestA, sizeof( aTestA ) );
//STRIP001 					if( !bValidStorage )
//STRIP001 					{
//STRIP001 						// or the \1Ole-Stream ?
//STRIP001 						xSrcTst = xObjStg->OpenStream(
//STRIP001 									String( RTL_CONSTASCII_STRINGPARAM( "\1Ole" ),
//STRIP001 											RTL_TEXTENCODING_MS_1252 ));
//STRIP001 						bValidStorage = xSrcTst.Is() && sizeof( aTestA ) ==
//STRIP001 										xSrcTst->Read( aTestA, sizeof( aTestA ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				if( bValidStorage && nConvertFlags )
//STRIP001 				{
//STRIP001 					SvInPlaceObjectRef xIPObj( CheckForConvertToSOObj(
//STRIP001 								nConvertFlags, *xObjStg, *rDestStorage, rGrf ));
//STRIP001 					if( xIPObj.Is() )
//STRIP001     			    {
//STRIP001 						pRet = new SdrOle2Obj( xIPObj, String(), rBoundRect, FALSE );
//STRIP001 						// we have the Object, don't create another
//STRIP001 						bValidStorage = FALSE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( bValidStorage )
//STRIP001 		{
//STRIP001 			rSrcStorage->CopyTo( rStorageName, rDestStorage, aDstStgName );
//STRIP001 
//STRIP001             xObjStor = rDestStorage->OpenOLEStorage( aDstStgName,
//STRIP001 								STREAM_READWRITE| STREAM_SHARE_DENYALL );
//STRIP001 			if( xObjStor.Is() && xObjStor->GetError() )
//STRIP001 			{
//STRIP001 				rDestStorage->SetError( xObjStor->GetError() );
//STRIP001 				xObjStor.Clear();
//STRIP001 				bValidStorage = FALSE;
//STRIP001 			}
//STRIP001 			else if( SVSTREAM_OK != rDestStorage->GetError() || !xObjStor.Is() )
//STRIP001 				bValidStorage = FALSE;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				GDIMetaFile aMtf;
//STRIP001 				SvEmbeddedObject::MakeContentStream( xObjStor,
//STRIP001 							*lcl_GetMetaFileFromGrf_Impl( rGrf, aMtf ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if( pDataStrm )
//STRIP001 		{
//STRIP001 			UINT32 nLen, nDummy;
//STRIP001 			*pDataStrm >> nLen >> nDummy;
//STRIP001 			if( SVSTREAM_OK != pDataStrm->GetError() ||
//STRIP001 				// Id in BugDoc - exist there other Ids?
//STRIP001 				// The ConvertToOle2 - does not check for consistent
//STRIP001 				0x30008 != nDummy )
//STRIP001 				bValidStorage = FALSE;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// or is it an OLE-1 Stream in the DataStream?
//STRIP001                 xObjStor = rDestStorage->OpenOLEStorage( aDstStgName
//STRIP001 								/*, STREAM_READWRITE | STREAM_SHARE_DENYALL*/ );
//STRIP001 
//STRIP001 				GDIMetaFile aMtf;
//STRIP001 				SotStorageRef xRef( &xObjStor );
//STRIP001 				bValidStorage = SvEmbeddedObject::ConvertToOle2(
//STRIP001 							*pDataStrm, nLen,
//STRIP001 							lcl_GetMetaFileFromGrf_Impl( rGrf, aMtf ), xRef );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( bValidStorage )
//STRIP001 		{
//STRIP001 			SvInPlaceObjectRef xInplaceObj( ((SvFactory*)SvInPlaceObject::
//STRIP001 									ClassFactory())->CreateAndLoad( xObjStor ) );
//STRIP001 			if( xInplaceObj.Is() )
//STRIP001 			{
//STRIP001 				// VisArea am OutplaceObject setzen!!
//STRIP001                 Size aSz(lcl_GetPrefSize(rGrf, 
//STRIP001                     MapMode(xInplaceObj->GetMapUnit())));
//STRIP001 				// modifiziert wollen wir nicht werden
//STRIP001 				xInplaceObj->EnableSetModified( FALSE );
//STRIP001 				xInplaceObj->SetVisArea( Rectangle( Point(), aSz ));
//STRIP001 				xInplaceObj->EnableSetModified( TRUE );
//STRIP001 				pRet = new SdrOle2Obj( xInplaceObj, aDstStgName, rBoundRect, FALSE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 #endif
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 SdrObject* SvxMSDffManager::GetAutoForm( MSO_SPT eTyp ) const
//STRIP001 {
//STRIP001 	UINT16 nNewType = 1; // Rectangle als default
//STRIP001 	SdrObject* pRet = NULL;
//STRIP001 	switch ( eTyp )
//STRIP001 	{
//STRIP001 		case mso_sptCurvedLeftArrow           : nNewType= 53; break;
//STRIP001 		case mso_sptCurvedRightArrow          : nNewType= 52; break;
//STRIP001 		case mso_sptCurvedUpArrow             : nNewType= 54; break;
//STRIP001 		case mso_sptCurvedDownArrow           : nNewType= 55; break;
//STRIP001 		case mso_sptWave                      : nNewType= 89; break;
//STRIP001 		case mso_sptDoubleWave                : nNewType= 90; break;
//STRIP001 
//STRIP001 		case mso_sptWedgeRectCallout		  : nNewType= 98; break;
//STRIP001 		case mso_sptWedgeRRectCallout		  : nNewType= 99; break;
//STRIP001 		case mso_sptWedgeEllipseCallout		  : nNewType=100; break;
//STRIP001 		case mso_sptCloudCallout              : nNewType=101; break;
//STRIP001 	}
//STRIP001 	// Model holen falls noch nicht angelegt
//STRIP001 	if( !pFormModel )
//STRIP001 	{
//STRIP001 		if ( GalleryExplorer::GetSdrObjCount( GALLERY_THEME_POWERPOINT ) )
//STRIP001 		{
//STRIP001 			((SvxMSDffManager*)this)->pFormModel = new FmFormModel();
//STRIP001 			SfxItemPool& rPool = pFormModel->GetItemPool();
//STRIP001 			rPool.FreezeIdRanges();
//STRIP001 			if ( !GalleryExplorer::GetSdrObj( GALLERY_THEME_POWERPOINT, 0, pFormModel ) && pFormModel )	// Objekte sind nicht da
//STRIP001 				delete ((SvxMSDffManager*)this)->pFormModel, ((SvxMSDffManager*)this)->pFormModel = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( pFormModel && pFormModel->GetPageCount() )	// Objekt aus dem model holen, falls es  noch klappt
//STRIP001 	{
//STRIP001 		const SdrObject* pObj = pFormModel->GetPage( 0 )->GetObj( 120 - nNewType );
//STRIP001 		if( pObj )
//STRIP001 			pRet = (SdrObject*)pObj->Clone();
//STRIP001 	}
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SvxMSDffManager::SetPropValue( const uno::Any& rAny, const uno::Reference< ::com::sun::star::beans::XPropertySet > & rXPropSet,
//STRIP001 			const String& rPropName, sal_Bool bTestPropertyAvailability )
//STRIP001 {
//STRIP001     sal_Bool bRetValue = sal_True;
//STRIP001 	if ( bTestPropertyAvailability )
//STRIP001 	{
//STRIP001 		bRetValue = sal_False;
//STRIP001 		try
//STRIP001 		{
//STRIP001 			uno::Reference< beans::XPropertySetInfo >
//STRIP001 				aXPropSetInfo( rXPropSet->getPropertySetInfo() );
//STRIP001 			if ( aXPropSetInfo.is() )
//STRIP001 				bRetValue = aXPropSetInfo->hasPropertyByName( rPropName );
//STRIP001 		}
//STRIP001 		catch( uno::Exception& )
//STRIP001 		{
//STRIP001 			bRetValue = sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( bRetValue )
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			rXPropSet->setPropertyValue( rPropName, rAny );
//STRIP001 			bRetValue = sal_True;
//STRIP001 		}
//STRIP001 		catch( uno::Exception& )
//STRIP001 		{
//STRIP001 			bRetValue = sal_False;
//STRIP001 		}
//STRIP001 	}
//STRIP001     return bRetValue;
//STRIP001 }

/* vi:set tabstop=4 shiftwidth=4 expandtab: */
}
