/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_msashape3d.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:26:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _MSASHAPE3D_HXX
#include <msashape3d.hxx>
#endif

#ifndef _TL_POLY_HXX
#include <tools/poly.hxx>
#endif
#ifndef _SVDITER_HXX
#include <svditer.hxx>
#endif
#ifndef _SVDOBJ_HXX
#include <svdobj.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
#ifndef SVX_XFILLIT0_HXX
#include <xfillit0.hxx>
#endif
#ifndef _SVX_XIT_HXX
#include <xit.hxx>
#endif
#ifndef _SVX_XBTMPIT_HXX
#include <xbtmpit.hxx>
#endif
#ifndef _SVX_XFLCLIT_HXX
#include <xflclit.hxx>
#endif
#ifndef _SVDOPATH_HXX
#include <svdopath.hxx>
#endif
#ifndef _SVDOGRP_HXX
#include <svdogrp.hxx>
#endif
#ifndef _SVDPAGE_HXX
#include <svdpage.hxx>
#endif
#ifndef _E3D_POLYSC3D_HXX
#include "polysc3d.hxx"
#endif
#ifndef _SVDDEF_HXX
#include "svddef.hxx"
#endif
#ifndef _SVX3DITEMS_HXX
#include "svx3ditems.hxx"
#endif
#ifndef _E3D_EXTRUD3D_HXX
#include "extrud3d.hxx"
#endif
#ifndef _SVX_XFLBMTIT_HXX
#include <xflbmtit.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SVX_XLNCLIT_HXX
#include <xlnclit.hxx>
#endif
namespace binfilter {

//STRIP001 #define ITEMVALUE(ItemSet,Id,Cast)  ((const Cast&)(ItemSet).Get(Id)).GetValue()
//STRIP001 
//STRIP001 double SvxMSDffAutoShape3D::Fix16ToAngle( sal_Int32 nFixAngle )
//STRIP001 {
//STRIP001 	double fAngle = 0.0;
//STRIP001 	if ( nFixAngle )
//STRIP001 	{
//STRIP001 		fAngle = nFixAngle;
//STRIP001 		fAngle /= 65536.0;
//STRIP001 	}
//STRIP001 	return fAngle;
//STRIP001 }
//STRIP001 
//STRIP001 SvxMSDffAutoShape3D::Transformation2D::Transformation2D( const DffPropSet& rPropSet, const Rectangle& rSnapRect ) :
//STRIP001 	aCenter( rSnapRect.Center() )
//STRIP001 {
//STRIP001 	bParallel = ( rPropSet.GetPropertyValue( DFF_Prop_fc3DFillHarsh, 0 ) & 4 ) != 0;
//STRIP001 	if ( bParallel )
//STRIP001 	{
//STRIP001 		fSkewAngle = Fix16ToAngle( rPropSet.GetPropertyValue( DFF_Prop_c3DSkewAngle, -135 * 65536 ) ) * F_PI180;
//STRIP001 		nSkewAmount = rPropSet.GetPropertyValue( DFF_Prop_c3DSkewAmount, 50 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		fZScreen = 0.0;
//STRIP001 		fViewPointOriginX = ((double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DOriginX, 32768 )) * rSnapRect.GetWidth()) / 65536.0;
//STRIP001 		fViewPointOriginY = ((double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DOriginY,-32768 )) * rSnapRect.GetHeight()) / 65536.0;
//STRIP001 		fViewPoint.X() = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DXViewpoint, 1250000 )) / 360;	// 360 emu = 0,01 mm
//STRIP001 		fViewPoint.Y() = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DYViewpoint,-1250000 )) / 360;
//STRIP001 		fViewPoint.W() = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DZViewpoint,-9000000 )) / 360;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffAutoShape3D::Transformation2D::ApplySkewSettings( Polygon3D& rPoly3D )
//STRIP001 {
//STRIP001 	sal_uInt16 j;
//STRIP001 	for ( j = 0; j < rPoly3D.GetPointCount(); j++ )
//STRIP001 	{
//STRIP001 		Vector3D& rPoint = rPoly3D[ j ];
//STRIP001 		double fDepth = -( rPoint.Z() * nSkewAmount ) / 100.0;
//STRIP001 		rPoint.X() += fDepth * cos( fSkewAngle );
//STRIP001 		rPoint.Y() += -( fDepth * sin( fSkewAngle ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 Point SvxMSDffAutoShape3D::Transformation2D::Transform2D( const Vector3D& rPoint3D )
//STRIP001 {
//STRIP001 	Point aPoint2D;
//STRIP001 	if ( bParallel )
//STRIP001 	{
//STRIP001 		aPoint2D.X() = (sal_Int32)rPoint3D.X();
//STRIP001 		aPoint2D.Y() = (sal_Int32)rPoint3D.Y();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		double fX = rPoint3D.X() - fViewPointOriginX;
//STRIP001 		double fY = rPoint3D.Y() - fViewPointOriginY;
//STRIP001 		double f = ( fZScreen - fViewPoint.W() ) / ( rPoint3D.Z() - fViewPoint.W() );
//STRIP001 		aPoint2D.X() = (sal_Int32)(( fX - fViewPoint.X() ) * f + fViewPoint.X() + fViewPointOriginX );
//STRIP001 		aPoint2D.Y() = (sal_Int32)(( fY - fViewPoint.Y() ) * f + fViewPoint.Y() + fViewPointOriginY );
//STRIP001 	}
//STRIP001 	aPoint2D.Move( aCenter.X(), aCenter.Y() );
//STRIP001 	return aPoint2D;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffAutoShape3D::Rotate( Vector3D& rPoint, const double x, const double y, const double z )
//STRIP001 {
//STRIP001 	// rotation z axis
//STRIP001  	Vector3D aPoint( rPoint );
//STRIP001 	rPoint.X() = aPoint.X() * cos( z ) + aPoint.Y() * sin( z );
//STRIP001 	rPoint.Y() = -( aPoint.X() * sin( z ) ) + aPoint.Y() * cos( z );
//STRIP001 
//STRIP001 	// rotation y axis
//STRIP001 	aPoint = rPoint;
//STRIP001 	rPoint.X() = aPoint.X() * cos( y ) + aPoint.Z() * sin( y );
//STRIP001 	rPoint.Z() = -( aPoint.X() * sin( y ) ) + aPoint.Z() * cos( y );
//STRIP001 
//STRIP001 	// rotation x axis
//STRIP001 	aPoint = rPoint;
//STRIP001 	rPoint.Y() = aPoint.Y() * cos( x ) + aPoint.Z() * sin( x );
//STRIP001 	rPoint.Z() = -( aPoint.Y() * sin( x ) ) + aPoint.Z() * cos( x );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxMSDffAutoShape3D::Rotate( PolyPolygon3D& rPolyPoly3D, const Point3D& rOrigin, const double x, const double y, const double z )
//STRIP001 {
//STRIP001 	sal_uInt16 i, j;
//STRIP001 	for( i = 0; i < rPolyPoly3D.Count(); i++ )
//STRIP001 	{
//STRIP001 		Polygon3D& rPoly3D = rPolyPoly3D[ i ];
//STRIP001 		for( j = 0; j < rPoly3D.GetPointCount(); j++ )
//STRIP001 		{
//STRIP001 			Vector3D& rPoint = rPoly3D[ j ];
//STRIP001 			rPoint.X() -= rOrigin.X();
//STRIP001 			rPoint.Y() -= rOrigin.Y();
//STRIP001 			rPoint.Z() -= rOrigin.W();
//STRIP001 			Rotate( rPoint, x, y, z );
//STRIP001 			rPoint.X() += rOrigin.X();
//STRIP001 			rPoint.Y() += rOrigin.Y();
//STRIP001 			rPoint.Z() += rOrigin.W();
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 SdrObject* SvxMSDffAutoShape3D::Create3DObject( const SdrObject* pObj, const DffPropSet& rPropSet,
//STRIP001 				SfxItemSet& aSet, Rectangle& rSnapRect, sal_uInt32 nSpFlags )
//STRIP001 {
//STRIP001 	SdrObject* pRet = NULL;
//STRIP001 	std::vector< E3dCompoundObject* > aPlaceholderObjectList;
//STRIP001 
//STRIP001 	double fExtrusionBackward = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DExtrudeBackward, 457200 )) / 360.0;	// in emus
//STRIP001 	double fExtrusionForward  = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DExtrudeForward, 0 )) / 360.0;
//STRIP001 	double fDepth = fExtrusionBackward - fExtrusionForward;
//STRIP001 	if ( fDepth < 1.0 )
//STRIP001 		fDepth = 1.0;
//STRIP001 	ProjectionType eProjectionType( rPropSet.GetPropertyValue( DFF_Prop_fc3DFillHarsh, 0 ) & 4 ? PR_PARALLEL : PR_PERSPECTIVE );
//STRIP001 
//STRIP001 	// pObj Umwandeln in Szene mit 3D Objekt
//STRIP001 	E3dDefaultAttributes a3DDefaultAttr;
//STRIP001 	a3DDefaultAttr.SetDefaultLatheCharacterMode( TRUE );
//STRIP001 	a3DDefaultAttr.SetDefaultExtrudeCharacterMode( TRUE );
//STRIP001 
//STRIP001 	E3dScene* pScene = new E3dPolyScene( a3DDefaultAttr );
//STRIP001 
//STRIP001 	sal_Bool bSceneHasObjects ( sal_False );
//STRIP001 	sal_Bool bUseTwoFillStyles( sal_False );
//STRIP001 
//STRIP001 	MSO_3DRenderMode eRenderMode( (MSO_3DRenderMode)rPropSet.GetPropertyValue( DFF_Prop_c3DRenderMode, mso_FullRender ) );
//STRIP001 	XFillStyle eFillStyle( ITEMVALUE( aSet, XATTR_FILLSTYLE, XFillStyleItem ) );
//STRIP001     pScene->SetItem( Svx3DShadeModeItem( 0 ) );
//STRIP001     aSet.Put( Svx3DPercentDiagonalItem( 0 ) );
//STRIP001 	aSet.Put( Svx3DTextureModeItem( 1 ) );
//STRIP001 	if ( eRenderMode == mso_Wireframe )
//STRIP001 	{
//STRIP001 		aSet.Put( XLineStyleItem( XLINE_SOLID ) );
//STRIP001 		aSet.Put( XFillStyleItem ( XFILL_NONE ) );
//STRIP001 		aSet.Put( Svx3DDoubleSidedItem( TRUE ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aSet.Put( XLineStyleItem( XLINE_NONE ) );
//STRIP001 		if ( eFillStyle == XFILL_NONE )
//STRIP001 			aSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 		else if ( ( eFillStyle == XFILL_BITMAP ) || ( eFillStyle == XFILL_GRADIENT ) )
//STRIP001 			bUseTwoFillStyles = sal_True;
//STRIP001 	}
//STRIP001 	const SdrObject* pNext = NULL;
//STRIP001 	SdrObjListIter* pIter = NULL;
//STRIP001 	if ( pObj->IsGroupObject() )
//STRIP001 	{
//STRIP001 		pIter = new SdrObjListIter( *pObj, IM_DEEPWITHGROUPS );
//STRIP001 		if ( pIter->IsMore() )
//STRIP001 			pNext = pIter->Next();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pNext = pObj;
//STRIP001 	while ( pNext )
//STRIP001 	{
//STRIP001 		sal_Bool bIsPlaceholderObject = (((XFillStyleItem&)pNext->GetItem( XATTR_FILLSTYLE )).GetValue() == XFILL_NONE )
//STRIP001 									 && (((XLineStyleItem&)pNext->GetItem( XATTR_LINESTYLE )).GetValue() == XLINE_NONE );
//STRIP001 
//STRIP001 		SdrObject* pNewObj = pNext->ConvertToPolyObj( FALSE, FALSE );
//STRIP001 		SdrPathObj* pPath = PTR_CAST( SdrPathObj, pNewObj );
//STRIP001 		if( pPath )
//STRIP001 		{
//STRIP001 			const XPolyPolygon& rPolyPolygon = pPath->GetPathPoly();
//STRIP001 			E3dCompoundObject* p3DObj = new E3dExtrudeObj( a3DDefaultAttr,
//STRIP001 				rPolyPolygon, bUseTwoFillStyles ? 1 : fDepth );
//STRIP001 			p3DObj->NbcSetLayer( pObj->GetLayer() );
//STRIP001 			p3DObj->SetItemSet( aSet );
//STRIP001 			if ( bIsPlaceholderObject )
//STRIP001 				aPlaceholderObjectList.push_back( p3DObj );
//STRIP001 			else if ( bUseTwoFillStyles )
//STRIP001 			{			
//STRIP001 				Bitmap aFillBmp;
//STRIP001 				sal_Bool bFillBmpTile = ((XFillBmpTileItem&)p3DObj->GetItem( XATTR_FILLBMP_TILE )).GetValue();
//STRIP001 				if ( bFillBmpTile )
//STRIP001 				{
//STRIP001 					const XFillBitmapItem& rBmpItm = (XFillBitmapItem&)p3DObj->GetItem( XATTR_FILLBITMAP );
//STRIP001 					const XOBitmap& rXOBmp = rBmpItm.GetValue();
//STRIP001 					aFillBmp = rXOBmp.GetBitmap();
//STRIP001 					Size aLogicalSize = aFillBmp.GetPrefSize();
//STRIP001 					if ( aFillBmp.GetPrefMapMode() == MAP_PIXEL )
//STRIP001 						aLogicalSize = Application::GetDefaultDevice()->PixelToLogic( aLogicalSize, MAP_100TH_MM ); 
//STRIP001 					else
//STRIP001 						aLogicalSize = OutputDevice::LogicToLogic( aLogicalSize, aFillBmp.GetPrefMapMode(), MAP_100TH_MM );
//STRIP001 					aLogicalSize.Width()  *= 5;			;//				:-(		nice scaling, look at engine3d/obj3d.cxx
//STRIP001 					aLogicalSize.Height() *= 5;
//STRIP001 					aFillBmp.SetPrefSize( aLogicalSize );
//STRIP001 					aFillBmp.SetPrefMapMode( MAP_100TH_MM );
//STRIP001 					p3DObj->SetItem( XFillBitmapItem( String(), aFillBmp ) );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					Rectangle aBoundRect( rPolyPolygon.GetBoundRect() );
//STRIP001 					if ( rSnapRect != aBoundRect )
//STRIP001 					{
//STRIP001 						const XFillBitmapItem& rBmpItm = (XFillBitmapItem&)p3DObj->GetItem( XATTR_FILLBITMAP );
//STRIP001 						const XOBitmap& rXOBmp = rBmpItm.GetValue();
//STRIP001 						aFillBmp = rXOBmp.GetBitmap();
//STRIP001 						Size aBmpSize( aFillBmp.GetSizePixel() );
//STRIP001 						double fXScale = (double)aBoundRect.GetWidth() / (double)rSnapRect.GetWidth();
//STRIP001 						double fYScale = (double)aBoundRect.GetHeight() / (double)rSnapRect.GetHeight();
//STRIP001 
//STRIP001 						Point aPt( (sal_Int32)( (double)( aBoundRect.Left() - rSnapRect.Left() )* (double)aBmpSize.Width() / (double)rSnapRect.GetWidth() ),
//STRIP001 											(sal_Int32)( (double)( aBoundRect.Top() - rSnapRect.Top() ) * (double)aBmpSize.Height() / (double)rSnapRect.GetHeight() ) );
//STRIP001 						Size aSize( (sal_Int32)( aBmpSize.Width() * fXScale ),
//STRIP001 												(sal_Int32)( aBmpSize.Height() * fYScale ) );
//STRIP001 						Rectangle aCropRect( aPt, aSize );
//STRIP001  						aFillBmp.Crop( aCropRect );
//STRIP001 						p3DObj->SetItem( XFillBitmapItem( String(), aFillBmp ) );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				pScene->Insert3DObj( p3DObj );
//STRIP001 				p3DObj = new E3dExtrudeObj( a3DDefaultAttr, pPath->GetPathPoly(), fDepth );
//STRIP001 				p3DObj->NbcSetLayer( pObj->GetLayer() );
//STRIP001 				p3DObj->SetItemSet( aSet );
//STRIP001 				p3DObj->SetItem( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 				p3DObj->SetItem( Svx3DCloseFrontItem( sal_False ) );
//STRIP001 				p3DObj->SetItem( Svx3DCloseBackItem( sal_False ) );
//STRIP001 				pScene->Insert3DObj( p3DObj );
//STRIP001 				p3DObj = new E3dExtrudeObj( a3DDefaultAttr, pPath->GetPathPoly(), 1 );
//STRIP001 				p3DObj->NbcSetLayer( pObj->GetLayer() );
//STRIP001 				p3DObj->SetItemSet( aSet );
//STRIP001 				Matrix4D aFrontTransform( p3DObj->GetTransform() );
//STRIP001 				aFrontTransform.Translate( 0, 0, fDepth );
//STRIP001 				p3DObj->NbcSetTransform( aFrontTransform );
//STRIP001 				if ( ( eFillStyle == XFILL_BITMAP ) && !aFillBmp.IsEmpty() )
//STRIP001 					p3DObj->SetItem( XFillBitmapItem( String(), aFillBmp ) );
//STRIP001 			}
//STRIP001 			else if ( eFillStyle == XFILL_NONE )
//STRIP001 			{
//STRIP001 				XLineColorItem& rLineColor = (XLineColorItem&)p3DObj->GetItem( XATTR_LINECOLOR );
//STRIP001 				p3DObj->SetItem( XFillColorItem( String(), rLineColor.GetValue() ) );
//STRIP001 				p3DObj->SetItem( Svx3DDoubleSidedItem( sal_True ) );
//STRIP001 				p3DObj->SetItem( Svx3DCloseFrontItem( sal_False ) );
//STRIP001 				p3DObj->SetItem( Svx3DCloseBackItem( sal_False ) );
//STRIP001 			}
//STRIP001 			pScene->Insert3DObj( p3DObj );
//STRIP001 			bSceneHasObjects = sal_True;
//STRIP001 		}
//STRIP001 		delete pNewObj;
//STRIP001 		pNext = NULL;
//STRIP001 		if ( pIter && pIter->IsMore() )
//STRIP001 			pNext = pIter->Next();
//STRIP001 	}
//STRIP001 	delete pIter;
//STRIP001 
//STRIP001 	if ( bSceneHasObjects )	// is the SdrObject properly converted
//STRIP001 	{
//STRIP001 		// then we can change the return value
//STRIP001 		pRet = pScene;
//STRIP001 
//STRIP001 		// Kameraeinstellungen, Perspektive ...
//STRIP001 		Camera3D& rCamera = (Camera3D&)pScene->GetCamera();
//STRIP001 		const Volume3D& rVolume = pScene->GetBoundVolume();
//STRIP001 		pScene->CorrectSceneDimensions();
//STRIP001 		pScene->NbcSetSnapRect( rSnapRect );
//STRIP001 
//STRIP001 		// InitScene replacement
//STRIP001 		double fW = rVolume.GetWidth();
//STRIP001 		double fH = rVolume.GetHeight();
//STRIP001 		double fCamZ = rVolume.MaxVec().Z() + ( ( fW + fH ) / 2.0 );
//STRIP001 
//STRIP001 		rCamera.SetAutoAdjustProjection( FALSE );
//STRIP001 		rCamera.SetViewWindow( -fW / 2, - fH / 2, fW, fH);
//STRIP001 		Vector3D aLookAt( 0.0, 0.0, 0.0 );
//STRIP001         Vector3D aCamPos( 0.0, 0.0, 100.0 );
//STRIP001 
//STRIP001 		rCamera.SetDefaults( Vector3D( 0.0, 0.0, 100.0 ), aLookAt, 100.0 );
//STRIP001 		rCamera.SetPosAndLookAt( aCamPos, aLookAt );
//STRIP001 		rCamera.SetFocalLength( 1.0 );
//STRIP001 		rCamera.SetProjection( eProjectionType );
//STRIP001 		pScene->SetCamera( rCamera );
//STRIP001 		pScene->SetRectsDirty();
//STRIP001 
//STRIP001 		double fViewPointOriginX = ((double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DOriginX, 32768 )) * rSnapRect.GetWidth()) / 65536.0;
//STRIP001 		double fViewPointOriginY = ((double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DOriginY,-32768 )) * rSnapRect.GetHeight()) / 65536.0;
//STRIP001 
//STRIP001 		Matrix4D aNewTransform( pScene->GetTransform() );
//STRIP001 		Point aCenter( rSnapRect.Center() );
//STRIP001 		aNewTransform.Translate( -aCenter.X(), aCenter.Y(), -pScene->GetBoundVolume().GetDepth() );
//STRIP001         double fXRotate = Fix16ToAngle( rPropSet.GetPropertyValue( DFF_Prop_c3DXRotationAngle, 0 ) );
//STRIP001 		double fYRotate = Fix16ToAngle( rPropSet.GetPropertyValue( DFF_Prop_c3DYRotationAngle, 0 ) );
//STRIP001 		double fZRotate = Fix16ToAngle( rPropSet.GetPropertyValue( DFF_Prop_Rotation, 0 ) );
//STRIP001 		if ( fZRotate != 0.0 )
//STRIP001 			aNewTransform.RotateZ( -fZRotate * F_PI180 );
//STRIP001 		if ( nSpFlags & SP_FFLIPH )
//STRIP001 			aNewTransform.ScaleX( -1 );
//STRIP001 		if ( nSpFlags & SP_FFLIPV )
//STRIP001 			aNewTransform.ScaleY( -1 );
//STRIP001 		if( fYRotate != 0.0 )
//STRIP001 			aNewTransform.RotateY( -fYRotate * F_PI180 );
//STRIP001 		if( fXRotate != 0.0 )
//STRIP001 			aNewTransform.RotateX( -fXRotate * F_PI180 );
//STRIP001 		if ( eProjectionType == PR_PARALLEL )
//STRIP001 		{
//STRIP001 			sal_Int32 nSkewAmount = rPropSet.GetPropertyValue( DFF_Prop_c3DSkewAmount, 50 );
//STRIP001 			if ( nSkewAmount )
//STRIP001 			{
//STRIP001 				sal_Int32 nSkewAngle = ((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DSkewAngle,  -135 * 65536 ) ) >> 16;
//STRIP001 
//STRIP001 				double fAlpha( (double)nSkewAngle * F_PI180 );
//STRIP001 				double fInvTanBeta( (double)nSkewAmount / 100.0 );
//STRIP001 				if(fInvTanBeta)
//STRIP001 				{
//STRIP001 					aNewTransform.ShearXY(
//STRIP001 						fInvTanBeta * cos(fAlpha), 
//STRIP001 						fInvTanBeta * sin(fAlpha));
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aNewTransform.Translate( -fViewPointOriginX, fViewPointOriginY, 0 );
//STRIP001 	        // now set correct camera position
//STRIP001 			double fViewPointOriginX = ((double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DOriginX, 32768 )) * rSnapRect.GetWidth()) / 65536.0;
//STRIP001 			double fViewPointOriginY = ((double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DOriginY,-32768 )) * rSnapRect.GetHeight()) / 65536.0;
//STRIP001 			double fViewPointX = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DXViewpoint, 1250000 )) / 360;
//STRIP001 			double fViewPointY = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DYViewpoint,-1250000 )) / 360;
//STRIP001 			double fViewPointZ = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DZViewpoint,-9000000 )) / 360;
//STRIP001 
//STRIP001 			Vector3D aLookAt( fViewPointX, -fViewPointY, 0 );
//STRIP001 			Vector3D aNewCamPos( fViewPointX, -fViewPointY, -fViewPointZ );
//STRIP001 			rCamera.SetPosAndLookAt( aNewCamPos, aLookAt );
//STRIP001 			pScene->SetCamera( rCamera );
//STRIP001 		}
//STRIP001 		pScene->NbcSetTransform( aNewTransform );
//STRIP001         pScene->FitSnapRectToBoundVol();
//STRIP001 
//STRIP001         ///////////
//STRIP001 		// light //
//STRIP001         ///////////
//STRIP001 		double fAmbientIntensity = ((double)rPropSet.GetPropertyValue( DFF_Prop_c3DAmbientIntensity, 22178 )) / 65536.0;
//STRIP001 
//STRIP001 		sal_Int32 nLightX = ((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DKeyX, 50000 )) / 360;
//STRIP001 		sal_Int32 nLightY = - ((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DKeyY, 0 )) / 360;
//STRIP001 		sal_Int32 nLightZ = - ((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DKeyZ, 10000 )) / 360;
//STRIP001 		if ( !nLightZ )
//STRIP001 			nLightZ = 1;
//STRIP001 		double fLightIntensity = ((double)rPropSet.GetPropertyValue( DFF_Prop_c3DKeyIntensity, 43712 )) / 65536.0;
//STRIP001 		sal_Bool bLightHarsh = ( rPropSet.GetPropertyValue( DFF_Prop_fc3DFillHarsh, 0 ) & 2 ) != 0;
//STRIP001 
//STRIP001 		sal_Int32 nLight2X = ((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DFillX, -50000 )) / 360;
//STRIP001 		sal_Int32 nLight2Y = - ((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DFillY, 0 )) / 360;
//STRIP001 		sal_Int32 nLight2Z = - ((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DFillZ, 10000 )) / 360;
//STRIP001 		if ( !nLight2Z )
//STRIP001 			nLight2Z = -1;
//STRIP001 		double fLight2Intensity = ((double)rPropSet.GetPropertyValue( DFF_Prop_c3DFillIntensity, 43712 )) / 65536.0;
//STRIP001 		sal_Bool bLight2Harsh = ( rPropSet.GetPropertyValue( DFF_Prop_fc3DFillHarsh, 0 ) & 1 ) != 0;
//STRIP001 		sal_Bool bLightFace = ( rPropSet.GetPropertyValue( DFF_Prop_fc3DLightFace, 0 ) & 1 ) != 0;
//STRIP001 
//STRIP001 		sal_uInt16 nAmbientColor = (sal_uInt16)( fAmbientIntensity * 255.0 );
//STRIP001 		if ( nAmbientColor > 255 )
//STRIP001 			nAmbientColor = 255;
//STRIP001 		Color aGlobalAmbientColor( (sal_uInt8)nAmbientColor, (sal_uInt8)nAmbientColor, (sal_uInt8)nAmbientColor );
//STRIP001 		pScene->SetItem( Svx3DAmbientcolorItem( aGlobalAmbientColor ) );
//STRIP001 
//STRIP001 		sal_uInt8 nSpotLight1 = (sal_uInt8)( fLightIntensity * 255.0 );
//STRIP001 		Vector3D aSpotLight1( (double)nLightX, (double)nLightY, (double)nLightZ );
//STRIP001 		aSpotLight1.Normalize();
//STRIP001 		pScene->SetItem( Svx3DLightOnOff1Item( sal_True ) );
//STRIP001         Color aAmbientSpot1Color( nSpotLight1, nSpotLight1, nSpotLight1 );
//STRIP001 		pScene->SetItem( Svx3DLightcolor1Item( aAmbientSpot1Color ) );
//STRIP001 		pScene->SetItem( Svx3DLightDirection1Item( aSpotLight1 ) );
//STRIP001 
//STRIP001 		sal_uInt8 nSpotLight2 = (sal_uInt8)( fLight2Intensity * 255.0 );
//STRIP001 		Vector3D aSpotLight2( (double)nLight2X, (double)nLight2Y, (double)nLight2Z );
//STRIP001 		aSpotLight2.Normalize();
//STRIP001 		pScene->SetItem( Svx3DLightOnOff2Item( sal_True ) );
//STRIP001         Color aAmbientSpot2Color( nSpotLight2, nSpotLight2, nSpotLight2 );
//STRIP001 		pScene->SetItem( Svx3DLightcolor2Item( aAmbientSpot2Color ) );
//STRIP001 		pScene->SetItem( Svx3DLightDirection2Item( aSpotLight2 ) );
//STRIP001 
//STRIP001 		if ( nLightX || nLightY )
//STRIP001 		{
//STRIP001 			sal_uInt8 nSpotLight3 = 70;
//STRIP001 			Vector3D aSpotLight3( 0, 0, 1 );
//STRIP001 			pScene->SetItem( Svx3DLightOnOff3Item( sal_True ) );
//STRIP001 			Color aAmbientSpot3Color( nSpotLight3, nSpotLight3, nSpotLight3 );
//STRIP001 			pScene->SetItem( Svx3DLightcolor3Item( aAmbientSpot3Color ) );
//STRIP001 			pScene->SetItem( Svx3DLightDirection3Item( aSpotLight3 ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		double fSpecular = ((double)rPropSet.GetPropertyValue( DFF_Prop_c3DSpecularAmt, 0 )) / 65536.0;
//STRIP001 		double fDiffuse = ((double)rPropSet.GetPropertyValue( DFF_Prop_c3DDiffuseAmt, 0 )) / 65536.0;
//STRIP001 		double fShininess = ((double)rPropSet.GetPropertyValue( DFF_Prop_c3DShininess, 0 )) / 65536.0;
//STRIP001 
//STRIP001 		sal_uInt16 nItensity = 25;
//STRIP001 		Color aSpecularCol( COL_BLACK );
//STRIP001 		if ( fSpecular == 0.0 )
//STRIP001 		{
//STRIP001 			aSpecularCol = Color( 51, 51, 51 );
//STRIP001 		}
//STRIP001 		else if ( fSpecular > 1.2 )
//STRIP001 		{
//STRIP001 			aSpecularCol = Color( 128, 128, 128 );
//STRIP001 		}
//STRIP001 		pScene->SetItem( Svx3DMaterialSpecularItem( aSpecularCol ) );
//STRIP001 		pScene->SetItem( Svx3DMaterialSpecularIntensityItem( nItensity ) );
//STRIP001 
//STRIP001 		pScene->SetModel( pObj->GetModel() );
//STRIP001 		pScene->InitTransformationSet();
//STRIP001 		pRet->SetSnapRect( CalculateNewSnapRect( rSnapRect, rPropSet ) );
//STRIP001 
//STRIP001 		// removing placeholder objects
//STRIP001 		std::vector< E3dCompoundObject* >::iterator aObjectListIter( aPlaceholderObjectList.begin() );
//STRIP001 		while ( aObjectListIter != aPlaceholderObjectList.end() )
//STRIP001 		{
//STRIP001 			pScene->Remove3DObj( *aObjectListIter );
//STRIP001 			delete *aObjectListIter++;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		delete pScene;
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SvxMSDffAutoShape3D::CalculateNewSnapRect( const Rectangle& rOriginalSnapRect, const DffPropSet& rPropSet )
//STRIP001 {
//STRIP001 	const Point aCenter( rOriginalSnapRect.Center() );
//STRIP001 
//STRIP001 	double fExtrusionBackward = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DExtrudeBackward, 457200 )) / 360.0;
//STRIP001 	double fExtrusionForward  = (double)((sal_Int32)rPropSet.GetPropertyValue( DFF_Prop_c3DExtrudeForward, 0 )) / 360.0;
//STRIP001 
//STRIP001 	sal_uInt16 i;
//STRIP001 
//STRIP001 	// creating initial bound volume ( without rotation. skewing.and camera )
//STRIP001 	Polygon3D aBoundVolume( 8 );
//STRIP001 	const Polygon aPolygon( rOriginalSnapRect );
//STRIP001 	for ( i = 0; i < 4; i++ )
//STRIP001 	{
//STRIP001 		aBoundVolume[ i ].X() = aPolygon[ i ].X() - aCenter.X();
//STRIP001 		aBoundVolume[ i ].Y() = aPolygon[ i ].Y() - aCenter.Y();
//STRIP001 		aBoundVolume[ i ].Z()  = fExtrusionForward;
//STRIP001 		aBoundVolume[ i + 4 ].X()  = aPolygon[ i ].X() - aCenter.X();
//STRIP001 		aBoundVolume[ i + 4 ].Y()  = aPolygon[ i ].Y() - aCenter.Y();
//STRIP001 		aBoundVolume[ i + 4 ].Z()  = fExtrusionBackward;
//STRIP001 	}
//STRIP001 
//STRIP001 	Point3D aRotateCenter;
//STRIP001 	aRotateCenter.X() = 0.0;
//STRIP001 	aRotateCenter.Y() = 0.0;
//STRIP001 	aRotateCenter.W() = rPropSet.GetPropertyValue( DFF_Prop_c3DRotationCenterZ, 0 ) / 360;
//STRIP001 
//STRIP001 	// double XCenterInGUnits = rPropSet.GetPropertyValue( DFF_Prop_c3DRotationCenterX, 0 );
//STRIP001 	// double YCenterInGUnits = rPropSet.GetPropertyValue( DFF_Prop_c3DRotationCenterY, 0 );
//STRIP001 
//STRIP001 	// sal_Int32 nRotationXAxisInProz = rPropSet.GetPropertyValue( DFF_Prop_c3DRotationAxisX, 100 );
//STRIP001 	// sal_Int32 nRotationYAxisInProz = rPropSet.GetPropertyValue( DFF_Prop_c3DRotationAxisY, 0 );
//STRIP001 	// sal_Int32 nRotationZAxisInProz = rPropSet.GetPropertyValue( DFF_Prop_c3DRotationAxisZ, 0 );
//STRIP001 
//STRIP001 	double fXRotate = Fix16ToAngle( rPropSet.GetPropertyValue( DFF_Prop_c3DXRotationAngle, 0 ) ) * F_PI180;
//STRIP001 	double fYRotate = Fix16ToAngle( rPropSet.GetPropertyValue( DFF_Prop_c3DYRotationAngle, 0 ) ) * F_PI180;
//STRIP001 	double fZRotate = -Fix16ToAngle( rPropSet.GetPropertyValue( DFF_Prop_Rotation, 0 ) ) * F_PI180;
//STRIP001 	// double fRotationAngle = Fix16ToAngle( rPropSet.GetPropertyValue( DFF_Prop_c3DRotationAngle, 0 ) );		// * F_PI180;
//STRIP001 
//STRIP001 	for( i = 0; i < 8; i++ )		// rotating bound volume
//STRIP001 	{
//STRIP001 		Vector3D& rPoint = aBoundVolume[ i ];
//STRIP001 		rPoint.X() -= aRotateCenter.X();
//STRIP001 		rPoint.Y() -= aRotateCenter.Y();
//STRIP001 		rPoint.Z() -= aRotateCenter.W();
//STRIP001 		Rotate( rPoint, fXRotate, fYRotate, fZRotate );
//STRIP001 		rPoint.X() += aRotateCenter.X();
//STRIP001 		rPoint.Y() += aRotateCenter.Y();
//STRIP001 		rPoint.Z() += aRotateCenter.W();
//STRIP001 	}
//STRIP001 	Transformation2D aTransformation2D( rPropSet, rOriginalSnapRect );
//STRIP001 	if ( aTransformation2D.IsParallel() )
//STRIP001 		aTransformation2D.ApplySkewSettings( aBoundVolume );
//STRIP001 
//STRIP001 	Polygon aTransformed( 8 );
//STRIP001 	for ( i = 0; i < 8; i++ )
//STRIP001 		aTransformed[ i ] = aTransformation2D.Transform2D( aBoundVolume[ i ] );
//STRIP001 	return aTransformed.GetBoundRect();
//STRIP001 }
}
