/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dataurl.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:24:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_DATAURL_HXX
#define _SFX_DATAURL_HXX

#ifndef _TRANSPRT_HXX
#include <so3/transprt.hxx>
#endif

#if SUPD<582
#include "sfxjs.hxx"
#endif
// auto strip #include "frame.hxx"
namespace binfilter {

//=========================================================================

class DataLockByteFactory_Impl : public SvLockBytesFactory
{
public:
	DataLockByteFactory_Impl();
	virtual SvLockBytesRef CreateLockBytes(
		const String& rName, String& rMime );
	static String Encode64( const String& );
	static String Decode64( const String& );
};

//=========================================================================

class ImageLockByteFactory_Impl : public SvLockBytesFactory
{
public:
	ImageLockByteFactory_Impl();
	virtual SvLockBytesRef CreateLockBytes(
		const String& rName, String& rMime );
};

//=========================================================================

class InfoLockByteFactory_Impl : public SvLockBytesFactory
{
public:
	InfoLockByteFactory_Impl();
	virtual SvLockBytesRef CreateLockBytes(
		const String& rName, String& rMime );
};

//=========================================================================
#if SUPD<582
class JavaScriptTransportFactory_Impl : public SvBindingTransportFactory
{
	SfxFrameWeak wFrame;

public:
	JavaScriptTransportFactory_Impl()
	{}

	void SetFrame (SfxFrame *pFrame) { wFrame = pFrame; }

	virtual BOOL HasTransport (const String &rURL);

	virtual SvBindingTransport* CreateTransport (
		const String               &rURL,
		SvBindingTransportContext  &rCtx,
		SvBindingTransportCallback *pCB);
};

class JScriptResult;

class JavaScriptTransport_Impl : public SvBindingTransport
{
	String                      aURL;
	SvBindingTransportCallback *pCB;
	SfxJSCallRef                xCall;
	String                      aBaseURL;
	SfxFrameWeak                wFrame;

public:
	JavaScriptTransport_Impl (
		SvBindingTransportCallback *pCBP,
		const String               &rURL,
		SfxFrame                   *pFrame)
		: aURL (rURL), pCB (pCBP), wFrame (pFrame)
	{}

	virtual void Start();
	virtual void Abort();

	DECL_STATIC_LINK (JavaScriptTransport_Impl, ScriptDone, JScriptResult*);
};

#endif


}//end of namespace binfilter
#endif
