/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_fsetobsh.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:13:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#if SUPD>551
// auto strip #ifndef _SFXECODE_HXX
// auto strip #include <svtools/sfxecode.hxx>
// auto strip #endif
#else
// auto strip #include <sfxecode.hxx>
#endif

#include "fsetobsh.hxx"

#pragma hdrstop

// auto strip #ifndef _SOT_EXCHANGE_HXX
// auto strip #include <sot/exchange.hxx>
// auto strip #endif
// auto strip #ifndef _SVSTOR_HXX //autogen
// auto strip #include <so3/svstor.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif

// auto strip #include <cppuhelper/weak.hxx>
// auto strip #include <osl/mutex.hxx>

// auto strip #include "sfxresid.hxx"
// auto strip #include "docfilt.hxx"

#if SUPD<613//MUSTINI
// auto strip #include "inimgr.hxx"
#endif
// auto strip #include "app.hxx"
// auto strip #include "frmdescr.hxx"
// auto strip #include "docfile.hxx"
// auto strip #include "fcontnr.hxx"
// auto strip #include "frmhtml.hxx"
// auto strip #include "frmhtmlw.hxx"
// auto strip #include "appdata.hxx"
// auto strip #include "docinf.hxx"
#if SUPD<582
// auto strip #include "sfxjs.hxx"
#endif
#include "objface.hxx"
#include "doc.hrc"

#ifdef _USE_NAMESPACE
//ASDBG using namespace usr;
using namespace ::vos;
#endif

#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

#define SfxFrameSetObjectShell
#include "so3/staticbaseurl.hxx"
namespace binfilter {
#include <sfxslots.hxx>

static const sal_uInt16 nVersion = 3;

/*N*/ TYPEINIT1(SfxFrameSetObjectShell, SfxObjectShell);

//STRIP001 class SfxFrameSetObjectShell_Impl
//STRIP001 {
//STRIP001 public:
//STRIP001 	SvStrings*	pScripts;
//STRIP001 	SvStrings*	pComments;
//STRIP001 
//STRIP001 				SfxFrameSetObjectShell_Impl()
//STRIP001 					: pScripts(0)
//STRIP001 					, pComments(0)
//STRIP001 				{}
//STRIP001 };
//STRIP001 
//STRIP001 sal_uInt32 DetectFrameSetFilter(
//STRIP001 	SfxMedium& rMedium, const SfxFilter **pFilter,
//STRIP001 	SfxFilterFlags nMust, SfxFilterFlags nDont )
//STRIP001 {
//STRIP001 	SvStream *pStm = rMedium.GetInStream();
//STRIP001 	if ( pStm )
//STRIP001 	{
//STRIP001 		pStm->Seek(0L);
//STRIP001 
//STRIP001 		// Wir laden HTML immer mit dem Writer-Filter ...
//STRIP001 		const SfxFilter *pFilt = SFX_APP()->GetFilterMatcher().GetFilter4FilterName( DEFINE_CONST_UNICODE( "HTML" ) );
//STRIP001 		if ( pFilt )
//STRIP001 		{
//STRIP001 			if (*pFilter )
//STRIP001 				*pFilter = pFilt;
//STRIP001 			sal_uInt32 nErr = pFilt->GetFilterContainer()->
//STRIP001 				GetFilter4Content( rMedium, pFilter, nMust, nDont );
//STRIP001 			if( !nErr )
//STRIP001 				return ERRCODE_SFX_FORCEQUIET;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Wenn es kein HTML-Dokument ist, kann nur noch versucht werden,
//STRIP001 	// es als eigenes Format zu "offnen
//STRIP001 	if ( rMedium.IsStorage() )
//STRIP001 	{
//STRIP001 		SvStorage *pStor = rMedium.GetStorage();
//STRIP001 		SvStorageStreamRef aStr =
//STRIP001 			pStor->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ), STREAM_STD_READ );
//STRIP001 		if ( aStr->GetError() )
//STRIP001 		{
//STRIP001 			return ERRCODE_ABORT;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			const SfxFilter *pFilt = SfxFrameSetObjectShell::Factory().
//STRIP001 						GetFilterContainer()->GetFilter(1);
//STRIP001             if ( ( pFilt->GetFilterFlags() & nMust ) == nMust &&
//STRIP001                  ( pFilt->GetFilterFlags() & nDont ) == 0 )
//STRIP001 			{
//STRIP001 				*pFilter = pFilt;
//STRIP001 				return ERRCODE_NONE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return ERRCODE_ABORT;
//STRIP001 }
//STRIP001 
//STRIP001 SFX_IMPL_INTERFACE(SfxFrameSetObjectShell,SfxObjectShell,SfxResId(0))
//STRIP001 {
//STRIP001 	// momentan keine Tools
//STRIP001 }
//STRIP001 
//STRIP001 SFX_IMPL_SIMPLE_OBJECTFACTORY(SfxFrameSetObjectShell, SFXOBJECTSHELL_STD_NORMAL, FrameSet )
//STRIP001 {
//STRIP001 	sal_uInt32 nFormat = SotExchange::RegisterFormatName( DEFINE_CONST_UNICODE( "StarFrameSetDocument" ) );
//STRIP001 
//STRIP001 	SfxFilterContainer* pFC = Factory().GetFilterContainer();
//STRIP001 
//STRIP001 	SFX_OWN_FILTER_REGISTRATION( DetectFrameSetFilter,
//STRIP001 		DEFINE_CONST_UNICODE( "HTML (FrameSet)" ),
//STRIP001 		DEFINE_CONST_UNICODE( "*.html;*.htm" ),
//STRIP001 		SFX_FILTER_EXPORT, 0,
//STRIP001 		DEFINE_CONST_UNICODE( "TEXT0" ),
//STRIP001 		DEFINE_CONST_UNICODE( "HTML-FrameSet"), 0,
//STRIP001 		DEFINE_CONST_UNICODE( "HTML" ), String() );       // MAC ?!?!?!
//STRIP001 
//STRIP001 	pFC->GetFilter4FilterName( DEFINE_CONST_UNICODE( "HTML (FrameSet)" ) )->SetUIName(
//STRIP001 		String( SfxResId( STR_FSET_FILTERNAME0 ) ) );
//STRIP001 
//STRIP001 	SFX_SIMPLE_FILTER_REGISTRATION(
//STRIP001 		DEFINE_CONST_UNICODE( "StarFrameDokument" ),
//STRIP001 		DEFINE_CONST_UNICODE( "*.sfs" ),
//STRIP001 		SFX_FILTER_OWN|SFX_FILTER_IMPORT|SFX_FILTER_EXPORT,
//STRIP001 		nFormat,
//STRIP001 		DEFINE_CONST_UNICODE( "SVfs0" ),
//STRIP001 		DEFINE_CONST_UNICODE( "StarFrameSet" ),
//STRIP001 		0, String(), String() );          // MAC ?!?!?!
//STRIP001 
//STRIP001 	pFC->GetFilter4FilterName( DEFINE_CONST_UNICODE( "StarFrameDokument" ) )->SetUIName(
//STRIP001 		String( SfxResId( STR_FSET_FILTERNAME1 ) ) );
//STRIP001 
//STRIP001 	Factory().RegisterHelpFile( DEFINE_CONST_UNICODE( SFX_DESKTOP_HELPFILE_NAME ) );
//STRIP001 }
//STRIP001 
//------------------------------------------------------------------

/*N*/ SfxFrameSetObjectShell::SfxFrameSetObjectShell(SfxObjectCreateMode eMode) :
/*N*/ 	SfxObjectShell(eMode),
/*N*/ 	pDescriptor(0L)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// da die Writerlinge sich weigern, die BaseURL anders zu "ubergeben als
//STRIP001 	// "uber das INetURLObject ...
//STRIP001 	SetBaseURL( so3::StaticBaseUrl::GetBaseURL() );
//STRIP001 	SetPool(&SFX_APP()->GetPool());
//STRIP001 	SfxFrameSetModel* pModel = new SfxFrameSetModel( this );
//STRIP001 	SetModel( pModel );
//STRIP001 	StartLoading_Impl();
/*N*/ }


//------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxFrameSetObjectShell::~SfxFrameSetObjectShell()
//STRIP001 {
//STRIP001 	SetPool(0);
//STRIP001 	delete pDescriptor;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxFrameSetObjectShell::Exec_Impl(SfxRequest&)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxFrameSetObjectShell::State_Impl(SfxItemSet&)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxFrameSetObjectShell::InitNew( SvStorage *pStor )
//STRIP001 {
//STRIP001 	if ( SvPersist::InitNew( pStor ) )
//STRIP001 	{
//STRIP001 		pDescriptor = new SfxFrameSetDescriptor;
//STRIP001 		pDescriptor->SetColSet( sal_True );
//STRIP001 		SfxFrameDescriptor *pFrame = new SfxFrameDescriptor( pDescriptor );
//STRIP001 		pFrame->SetWidthPercent( 100 );
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxFrameSetObjectShell::Load( SvStorage *pStor )
//STRIP001 {
//STRIP001 	if( SvPersist::Load( pStor ) )
//STRIP001 	{
//STRIP001 		SvStorageStreamRef aStm = pStor->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ), STREAM_STD_READ );
//STRIP001 		if ( aStm.Is() )
//STRIP001 		{
//STRIP001 			delete pDescriptor;
//STRIP001 
//STRIP001 			sal_uInt16 nFileVersion;
//STRIP001 			aStm->SetBufferSize(4096);
//STRIP001 
//STRIP001 			pDescriptor = new SfxFrameSetDescriptor;
//STRIP001 			*aStm >> nFileVersion;
//STRIP001 
//STRIP001 			// Die alpha-Version
//STRIP001 			if ( nFileVersion == 1 )
//STRIP001 				return sal_False;
//STRIP001 
//STRIP001 			String aTitle;
//STRIP001 			aStm->ReadByteString( aTitle, RTL_TEXTENCODING_UTF8 );
//STRIP001 			pDescriptor->SetDocumentTitle( aTitle );
//STRIP001 			SetTitle( aTitle );
//STRIP001 
//STRIP001 			pDescriptor->Load( *aStm, nFileVersion );
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //=========================================================================
//STRIP001 
//STRIP001 sal_Bool SfxFrameSetObjectShell::Save()
//STRIP001 {
//STRIP001 	if( SvPersist::Save() && SfxObjectShell::Save() )
//STRIP001 	{
//STRIP001 		SvStorageStreamRef aStm = GetStorage()->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ) );
//STRIP001 		if ( aStm.Is() )
//STRIP001 		{
//STRIP001 			aStm->SetSize(0);
//STRIP001 			aStm->SetBufferSize(4096);
//STRIP001 			*aStm << nVersion;
//STRIP001 			aStm->WriteByteString( pDescriptor->GetDocumentTitle(),	RTL_TEXTENCODING_UTF8 );
//STRIP001 			pDescriptor->Store( *aStm );
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxFrameSetObjectShell::SaveAs( SvStorage * pNewStg )
//STRIP001 {
//STRIP001 	if( SvPersist::SaveAs( pNewStg) && SfxObjectShell::SaveAs( pNewStg ) )
//STRIP001 	{
//STRIP001 		SvStorageStreamRef aStm = pNewStg->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ) );
//STRIP001 		if ( aStm.Is() )
//STRIP001 		{
//STRIP001 			aStm->SetSize(0);
//STRIP001 			aStm->SetBufferSize(4096);
//STRIP001 			*aStm << nVersion;
//STRIP001 			aStm->WriteByteString( pDescriptor->GetDocumentTitle(),	RTL_TEXTENCODING_UTF8 );
//STRIP001 			pDescriptor->Store( *aStm );
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxFrameSetObjectShell::FillClass( SvGlobalName * pClassName,
//STRIP001 								   sal_uInt32 * pClipFormat,
//STRIP001 								   String * pAppName,
//STRIP001 								   String * pLongUserName,
//STRIP001 								   String * pUserName ) const
//STRIP001 {
//STRIP001 	SvPersist::FillClass( pClassName,
//STRIP001 							pClipFormat,
//STRIP001 							pAppName,
//STRIP001 							pLongUserName, pUserName );
//STRIP001 	SfxObjectFactory &rFact = GetFactory();
//STRIP001 	for( sal_uInt16 n = 0; n < rFact.GetFilterCount(); n++ )
//STRIP001 	{
//STRIP001 		const SfxFilter * pFilter = rFact.GetFilter( n );
//STRIP001 		if( pFilter->IsOwnFormat() )
//STRIP001 		{
//STRIP001 			*pClassName 	= *GetSvFactory();
//STRIP001 			*pClipFormat	= pFilter->GetFormat();
//STRIP001             *pLongUserName  = pFilter->GetFilterName();
//STRIP001             *pUserName      = pFilter->GetFilterName();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	*pAppName = SFX_APP()->GetName();
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxFrameSetObjectShell::SaveCompleted( SvStorage * pStor )
//STRIP001 {
//STRIP001 	if( SvPersist::SaveCompleted( pStor ) )
//STRIP001 	{
//STRIP001 		if( !pStor )
//STRIP001 			return sal_True;
//STRIP001 		SvStorageStreamRef aStm = pStor->OpenStream( DEFINE_CONST_UNICODE( "FrameSetDocument" ) );
//STRIP001 		return aStm.Is();
//STRIP001 	}
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxFrameSetObjectShell::ConvertFrom( SfxMedium& rMed )
//STRIP001 {
//STRIP001 	// HTML-Import
//STRIP001 	delete pDescriptor;
//STRIP001 	pDescriptor = new SfxFrameSetDescriptor;
//STRIP001 
//STRIP001 	// parsen
//STRIP001 	DBG_ASSERT( rMed.GetInStream(), "Kein Stream!" );
//STRIP001 
//STRIP001 	SvParserRef xParser = new SfxFrameHTMLParser( rMed, this );
//STRIP001 
//STRIP001 	SfxItemSet *pItemSet = rMed.GetItemSet();
//STRIP001 	const SfxPoolItem *pItem;
//STRIP001 	if( pItemSet &&
//STRIP001 		SFX_ITEM_SET == pItemSet->GetItemState( SID_FSETHTMLPARSER,
//STRIP001 												sal_False, &pItem ) )
//STRIP001 	{
//STRIP001 		sal_uInt32 nVal = ((SfxUInt32Item *)pItem)->GetValue();
//STRIP001 		xParser->SetSrcEncoding( (rtl_TextEncoding)(nVal & 0x0000ffff) );
//STRIP001 		xParser->SetSrcUCS2BEncoding( (nVal & 0x00010000) != 0 );
//STRIP001 		xParser->SetSwitchToUCS2( (nVal & 0x00020000) != 0 );
//STRIP001 	}
//STRIP001 	SvParserState eState = xParser->CallParser();
//STRIP001 
//STRIP001 	if ( SVPAR_PENDING == eState )
//STRIP001 	{
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		((SfxFrameHTMLParser*)&xParser)->EndParser();
//STRIP001 
//STRIP001 	SetTitle( GetDocInfo().GetTitle() );
//STRIP001 	if( SVPAR_ACCEPTED==eState )
//STRIP001 	{
//STRIP001 		rMed.SetFilter( Factory().GetFilterContainer()->GetFilter(0) );
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxFrameSetObjectShell::ConvertTo( SfxMedium& rMed )
//STRIP001 {
//STRIP001 /*
//STRIP001 	SvStream *pStream = GetMedium()->GetInStream();
//STRIP001 	if ( ( IsReadOnly() || !IsModified() ) && pStream )
//STRIP001 	{
//STRIP001 		// HTML-Datei als ebensolche speichern; wenn das Dokument noch
//STRIP001 		// nicht ver"andert wurde, einfach den Stream kopieren. Dadurch ist
//STRIP001 		// es m"oglich, Dokumente, deren Inhalt teilweise "uber JavaScript
//STRIP001 		// aufgebaut werden, als Original zu speichern
//STRIP001 		GetMedium()->CloseInStream();
//STRIP001 		pStream = GetMedium()->GetInStream();
//STRIP001 		if ( pStream )
//STRIP001 		{
//STRIP001 			pStream->Seek(0);
//STRIP001 			(*pStream) >> (*rMed.GetOutStream());
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 */
//STRIP001 	const SfxFilter *pFilter = rMed.GetFilter();
//STRIP001 	if ( !pFilter )
//STRIP001 	{
//STRIP001 		// Woher nehmen und nicht stehlen ??
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pFilter->GetFilterName().EqualsAscii( "HTML (FrameSet)" ) ||
//STRIP001 		 pFilter->GetFilterName().EqualsAscii( "HTML" ) )
//STRIP001 	{
//STRIP001 		// HTML-Export
//STRIP001 		SvStream* pStm = rMed.GetOutStream();
//STRIP001 
//STRIP001 		SfxFrameHTMLWriter *pWriter = new SfxFrameHTMLWriter;
//STRIP001 		sal_uInt32 nErr = pWriter->Write( this, *pStm );
//STRIP001 		delete pWriter;
//STRIP001 
//STRIP001 		if( nErr==0 )
//STRIP001 			return sal_True;
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Ein Fehler !!
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SfxFrameSetObjectShell::Initialize( const String& rName )
//STRIP001 {
//STRIP001 	sal_Bool bRet = DoInitNew( NULL );
//STRIP001 	if ( bRet )
//STRIP001 		pDescriptor->GetFrame(0)->SetURL( rName );
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxFrameSetObjectShell::TakeDescriptor( SfxFrameSetDescriptor *pSet )
//STRIP001 {
//STRIP001 	delete pDescriptor;
//STRIP001 
//STRIP001 	// Den neuen Descriptor "ubernehmen
//STRIP001 	pDescriptor = pSet->Clone();
//STRIP001 	SetModified( sal_True );
//STRIP001 
//STRIP001 	// Rekursive FrameSets interessieren hier nicht
//STRIP001 	pDescriptor->CutRootSet();
//STRIP001 
//STRIP001 	// Alle Kunden informieren
//STRIP001 	Broadcast( SfxSimpleHint( SFX_HINT_DOCCHANGED ) );
//STRIP001 }
//STRIP001 
//STRIP001 //--------------------------------------------------------------------
//STRIP001 
//STRIP001 void SfxFrameSetObjectShell::ReInit_Impl( SfxFrameSetDescriptor *pSet )
//STRIP001 {
//STRIP001 	// Den alten Descriptor wegwerfen
//STRIP001 	delete pDescriptor;
//STRIP001 
//STRIP001 	// Den neuen "ubernehmen
//STRIP001 	pDescriptor = pSet->Clone();
//STRIP001 
//STRIP001 	// Rekursive FrameSets interessieren hier nicht
//STRIP001 	pDescriptor->CutRootSet();
//STRIP001 
//STRIP001 	// Alle Kunden informieren
//STRIP001 	Broadcast( SfxSimpleHint( SFX_HINT_DOCCHANGED ) );
//STRIP001 }

/*N*/ String SfxFrameSetObjectShell::GetSource()
/*N*/ {DBG_BF_ASSERT(0, "STRIP");return String(); //STRIP001 
//STRIP001 	String aStr;
//STRIP001 
//STRIP001 	// Wenn noch nicht gespeichert, ergibt GetInStream einen Error
//STRIP001 	SvStream *pStream = HasName() ? GetMedium()->GetInStream() : 0;
//STRIP001 	SvMemoryStream aStm;
//STRIP001 	if ( ( IsReadOnly() || !IsModified() ) && pStream )
//STRIP001 	{
//STRIP001 		// Unver"anderte HTML-Datei aus dem Original-Stream lesen
//STRIP001 		GetMedium()->CloseInStream();
//STRIP001 		pStream = GetMedium()->GetInStream();
//STRIP001 		if ( pStream )
//STRIP001 			pStream->Seek(0);
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SfxFrameHTMLWriter *pWriter = new SfxFrameHTMLWriter;
//STRIP001 			sal_uInt32 nErr = pWriter->Write( this, aStm );
//STRIP001 			delete pWriter;
//STRIP001 			if ( nErr == 0 )
//STRIP001 				pStream = &aStm;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxFrameHTMLWriter *pWriter = new SfxFrameHTMLWriter;
//STRIP001 		sal_uInt32 nErr = pWriter->Write( this, aStm );
//STRIP001 		delete pWriter;
//STRIP001 		if ( nErr == 0 )
//STRIP001 			pStream = &aStm;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pStream )
//STRIP001 	{
//STRIP001 		pStream->Seek(0);
//STRIP001 		ByteString aTmp;
//STRIP001 		while ( pStream->ReadLine( aTmp ) )
//STRIP001 		{
//STRIP001 			aStr += String::CreateFromAscii( aTmp.GetBuffer() );
//STRIP001 			aStr += '\n';
//STRIP001 		}
//STRIP001 		aStr.ConvertLineEnd();
//STRIP001 	}
//STRIP001 
//STRIP001 	return aStr;
/*N*/ }

/*N*/ void SfxFrameSetObjectShell::TakeSource( const String& rSource )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	delete pDescriptor;
//STRIP001 	pDescriptor = new SfxFrameSetDescriptor;
//STRIP001 
//STRIP001 	// parsen
//STRIP001 	SvMemoryStream aStream;
//STRIP001 	aStream.WriteByteString( rSource, RTL_TEXTENCODING_UTF8 );
//STRIP001 	aStream.Seek(0);
//STRIP001 	SvParserRef xParser = new SfxFrameHTMLParser( aStream, this );
//STRIP001 	SvParserState eState = xParser->CallParser();
//STRIP001 	SetTitle( GetDocInfo().GetTitle() );
//STRIP001 	SetModified( sal_True );
//STRIP001 
//STRIP001 	// Alle Kunden informieren
//STRIP001 	Broadcast( SfxSimpleHint( SFX_HINT_DOCCHANGED ) );
/*N*/ }

//STRIP001 void SfxFrameSetObjectShell::SetScriptsAndComments( SvStrings* pScripts,
//STRIP001 	SvStrings* pComments )
//STRIP001 {
//STRIP001 }

/*N*/ SfxFrameSetModel::SfxFrameSetModel( SfxFrameSetObjectShell *pShell )
/*N*/ 	: SfxBaseModel( pShell )
/*N*/ {
/*N*/ 	pDoc = pShell;
/*N*/ }
//------------------------------------------------------------------

/*N*/ SfxFrameSetModel::SfxFrameSetModel( ::com::sun::star::uno::Reference < ::com::sun::star::lang::XMultiServiceFactory > const & )
/*N*/ 	: SfxBaseModel( NULL )
/*N*/ {
/*N*/ 	DBG_ERRORFILE( "NIJ!" );
/*N*/ }
//------------------------------------------------------------------

/*N*/ SfxFrameSetModel::~SfxFrameSetModel()
/*N*/ {
/*N*/ }

//------------------------------------------------------------------

/*N*/ SFX_IMPL_XINTERFACE_2( SfxFrameSetModel, SfxBaseModel, ::com::sun::star::frame::XFrameSetModel, ::com::sun::star::lang::XServiceInfo )
/*N*/ SFX_IMPL_XTYPEPROVIDER_9( SfxFrameSetModel, ::com::sun::star::frame::XFrameSetModel, ::com::sun::star::frame::XModel, ::com::sun::star::lang::XEventListener, ::com::sun::star::view::XPrintable, ::com::sun::star::util::XModifiable, ::com::sun::star::frame::XStorable, ::com::sun::star::container::XChild, ::com::sun::star::document::XDocumentInfoSupplier, ::com::sun::star::lang::XServiceInfo )
/*N*/ SFX_IMPL_XSERVICEINFO( SfxFrameSetModel, "com.sun.star.frame.Model", "com.sun.star.comp.sfx2.FrameSetModel" )
/*N*/ SFX_IMPL_SINGLEFACTORY( SfxFrameSetModel )

/*N*/ ::rtl::OUString SAL_CALL SfxFrameSetModel::getSource() throw ( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	return pDoc->GetSource();
/*N*/ }

/*N*/ void SAL_CALL SfxFrameSetModel::setSource( const ::rtl::OUString& rSource ) throw ( ::com::sun::star::uno::RuntimeException )
/*N*/ {
/*N*/ 	pDoc->TakeSource( rSource );
/*N*/ }


}
