/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_loadenv.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:27:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SVSTOR_HXX //autogen
// auto strip #include <so3/svstor.hxx>
// auto strip #endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SBX_SBXCORE_HXX //autogen
#include <basic/sbxcore.hxx>
#endif
#ifndef _SFXECODE_HXX
#include <svtools/sfxecode.hxx>
#endif
// auto strip #ifndef _SV_MSGBOX_HXX
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif

#ifndef __FRAMEWORK_DISPATCH_INTERACTION_HXX_
#include <framework/interaction.hxx>
#endif
#ifndef _COM_SUN_STAR_TASK_ERRORCODEREQUEST_HPP_
#include <com/sun/star/task/ErrorCodeRequest.hpp>
#endif

#include <svtools/ehdl.hxx>
#include <com/sun/star/uno/Reference.h>
// auto strip #include <com/sun/star/ucb/XContent.hpp>
// auto strip #include <rtl/ustring.hxx>
#include <so3/transbnd.hxx>             // SvKeyValueIterator
// auto strip #include <svtools/securityoptions.hxx>

#include <unotools/localfilehelper.hxx>

#pragma hdrstop

// auto strip #include "doctempl.hxx"
#include "loadenv.hxx"
#include "docfile.hxx"
// auto strip #include "objitem.hxx"
#include "request.hxx"
#include "objshimp.hxx"
// auto strip #include "docfilt.hxx"
#include "openflag.hxx"
// auto strip #include "docinf.hxx"
// auto strip #include "fcontnr.hxx"
#include "fltfnc.hxx"
#include "dispatch.hxx"
// auto strip #include "frmdescr.hxx"
#include "fsetvwsh.hxx"
// auto strip #include "dataurl.hxx"
// auto strip #include "appdata.hxx"
#include "topfrm.hxx"
#include "docfac.hxx"
// auto strip #include "sfxresid.hxx"
#include "app.hrc"
namespace binfilter {

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ucb;
using namespace ::rtl;

//========================================================================

// diese Funktionen sind in appopen.cxx definiert

extern void SetTemplate_Impl( SvStorage*, const String&, const String&, SfxObjectShell* );

// class SfxLoadEnvironment ----------------------------------------------

/*N*/ SfxLoadEnvironment::SfxLoadEnvironment( LoadEnvironment_Impl* pImpl )
/*N*/ 	: _pImpl( pImpl )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	pImpl->AddRef();
/*N*/ }

/*N*/ SfxLoadEnvironment::~SfxLoadEnvironment()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	_pImpl->ReleaseRef();
/*N*/ }

//STRIP001 ErrCode SfxLoadEnvironment::DocumentDetected( SfxObjectShell* pObjSh, ErrCode nErr )
//STRIP001 {
//STRIP001     return nErr;
//STRIP001 }

//STRIP001 void SfxLoadEnvironment::SetDataAvailableLink( const Link& rLink )
//STRIP001 {
//STRIP001 	_pImpl->SetDataAvailableLink(  rLink );
//STRIP001 }

class SfxLoadCancellable : public SfxCancellable
{
	SfxFrameWeak    wFrame;
public:
					SfxLoadCancellable( SfxFrame* pFrameP, SfxMedium* pMedium )
						: wFrame( pFrameP ),
		  				SfxCancellable( pMedium->GetCancelManager_Impl(), pMedium->GetURLObject().GetURLNoPass() )
					{}
	virtual void	Cancel();
};

/*?*/ void SfxLoadCancellable::Cancel()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	SfxCancellable::Cancel();
//STRIP001 	// Damit wir beim loeschen des Frames nicht an den
//STRIP001 	// AppCancelManager wandern
//STRIP001 	SetManager( 0 );
//STRIP001 	if( wFrame.Is() )
//STRIP001 		wFrame->CancelTransfers();
/*?*/ }

/*N*/ LoadEnvironment_Impl::~LoadEnvironment_Impl()
/*N*/ {
/*N*/ 	aDecoupleLink.ClearPendingCall();
/*N*/ 
/*N*/ 	if ( aDoneLink.IsSet() )
/*N*/ 	{
/*N*/ 		SfxPoolItem* pRet;
/*?*/ 		if( !IsPlugin() && pFrame )
/*?*/ 			pRet = new SfxViewFrameItem( 0, &xDoc ? pFrame->GetCurrentViewFrame() : 0);
/*?*/ 		else
/*?*/ 			pRet = new SfxObjectShellItem( 0, xDoc );
/*?*/ 
/*?*/ 		aDoneLink.Call( pRet );
/*?*/ 		delete pRet;
/*N*/ 	}
/*N*/ 
/*N*/ 	if( pMedium )
/*N*/ 	{
/*N*/ 		Link aLink;
/*N*/ 		if( pMedium->GetDataAvailableLink() ==
/*N*/ 			LINK( this, LoadEnvironment_Impl, LoadDataAvailable_Impl ) )
/*N*/ 			pMedium->SetDataAvailableLink( aLink );
/*N*/ 		if( pMedium->GetDoneLink() ==
/*N*/ 			LINK( this, LoadEnvironment_Impl, LoadDataAvailable_Impl ) )
/*N*/ 			pMedium->SetDoneLink( aLink );
/*N*/ 		SFX_ITEMSET_ARG( pMedium->GetItemSet(), pIsChildLoad,
/*N*/ 						 SfxBoolItem, SID_ISCHILDFRAMELOAD, sal_False );
/*N*/ 		if ( pFrame && pIsChildLoad && pIsChildLoad->GetValue() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pFrame->LoadFinished_Impl();
/*N*/ 
/*N*/ 		if ( pFrame &&
/*N*/ 			 ( !pFrame->GetCurrentDocument() ||
/*N*/ 			 pFrame->GetCurrentDocument() == &xDoc && pFrame->GetCurrentDocument()->GetMedium() != pMedium ) )
/*N*/ //		if ( pFrame && pFrame->GetCurrentDocument() && pFrame->GetCurrentDocument()->GetMedium() != pMedium &&
/*N*/ //			 pFrame->GetCurrentDocument() == &xDoc )
/*N*/ 			DELETEZ( pMedium );
/*N*/ 	}
/*N*/ 
/*N*/ 	if( pFrame && pFrame->GetLoadEnvironment_Impl() == this )
/*N*/ 		pFrame->SetLoadEnvironment_Impl( 0 );
/*N*/ 	if( pFrame && (
/*N*/ 		!xDoc.Is() || xDoc->Get_Impl()->nLoadedFlags == SFX_LOADED_ALL ) )
/*N*/ 		pFrame->SetLoadCancelable_Impl( 0 );
/*N*/ 	if( bOwnsFrame && pFrame )
/*?*/ 		pFrame->DoClose();
/*N*/     delete pContext;
/*N*/ }

/*N*/ LoadEnvironment_Impl* LoadEnvironment_Impl::Create( const SfxItemSet& rConstSet, BOOL bAllowRO )
/*N*/ {
/*N*/     // File-Flags
/*N*/     SfxAllItemSet *pArgs = new SfxAllItemSet( rConstSet );
/*N*/ 
/*N*/     // File Name ermitteln
/*N*/     String aDocFileName;
/*N*/     String aErrCtxName;
/*N*/ 
/*N*/     // Template "offnen?
/*N*/     BOOL bTemplate = FALSE;
/*N*/     SFX_ITEMSET_ARG(pArgs, pTemplRegItem, SfxStringItem, SID_TEMPLATE_REGIONNAME, FALSE);
/*N*/     SFX_ITEMSET_ARG(pArgs, pTemplNamItem, SfxStringItem, SID_TEMPLATE_NAME, FALSE);
/*N*/     if( pTemplRegItem || pTemplNamItem )
/*N*/     {
/*?*/         // Template-Region
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 String aTemplateRegion;
//STRIP001 /*?*/         if ( pTemplRegItem )
//STRIP001 /*?*/             aTemplateRegion = pTemplRegItem->GetValue();
//STRIP001 /*?*/ 
//STRIP001 /*?*/         // Template-Name
//STRIP001 /*?*/         String aTemplateName;
//STRIP001 /*?*/         if ( pTemplNamItem )
//STRIP001 /*?*/             aTemplateName = pTemplNamItem->GetValue();
//STRIP001 /*?*/ 
//STRIP001 /*?*/         // File Name aus Region/TemplateName holen
//STRIP001 /*?*/         SfxDocumentTemplates aTemplates;
//STRIP001 /*?*/         if ( !aTemplates.GetFull( aTemplateRegion, aTemplateName, aDocFileName) )
//STRIP001 /*?*/         {
//STRIP001 /*?*/             aErrCtxName = aTemplateRegion;
//STRIP001 /*?*/             aErrCtxName += String::CreateFromAscii(" / ");
//STRIP001 /*?*/             aErrCtxName += aTemplateName;
//STRIP001 /*?*/         }
//STRIP001 /*?*/         else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/             INetURLObject aTestObj( aDocFileName );
//STRIP001 /*?*/             if( aTestObj.GetProtocol() == INET_PROT_NOT_VALID )
//STRIP001 /*?*/             {
//STRIP001 /*?*/                 // temp. fix until Templates are managed by UCB compatible service
//STRIP001 /*?*/                 // does NOT work with locally cached components !
//STRIP001 /*?*/                 String aTemp;
//STRIP001 /*?*/                 utl::LocalFileHelper::ConvertPhysicalNameToURL( aDocFileName, aTemp );
//STRIP001 /*?*/                 aDocFileName = aTemp;
//STRIP001 /*?*/             }
//STRIP001 /*?*/ 
//STRIP001 /*?*/             aErrCtxName = aDocFileName;
//STRIP001 /*?*/             bTemplate = TRUE;
//STRIP001 /*?*/ 		}
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         // File-Name
/*N*/         SFX_ITEMSET_ARG(pArgs, pFileNameItem, SfxStringItem, SID_FILE_NAME, FALSE);
/*N*/         DBG_ASSERT( pFileNameItem, "FileName-Arg missing" );
/*N*/ 
/*N*/ 		String aFileURL = pFileNameItem->GetValue();
/*N*/ 		aErrCtxName = aDocFileName = aFileURL;
/*N*/     }
/*N*/ 
/*N*/ 	// optional original-URL( z.B. bei Salvage )
/*N*/     String aMark;
/*N*/     SFX_ITEMSET_ARG(pArgs, pUrlItem, SfxStringItem, SID_ORIGURL, FALSE );
/*N*/ 	if ( pUrlItem )
/*N*/ 	{
/*N*/ 		// Mark von original-URL an aDocFileName anh"angen
/*?*/         INetURLObject aURL( aDocFileName );
/*?*/         DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "Illegal URL!" );
/*?*/ 		aDocFileName = aURL.GetMainURL(INetURLObject::DECODE_TO_IURI);
/*?*/         aMark = INetURLObject( pUrlItem->GetValue() ).GetMark( INetURLObject::DECODE_WITH_CHARSET );
/*N*/ 	}
/*N*/ 
/*N*/     SFX_ITEMSET_ARG(pArgs, pMarkItem, SfxStringItem, SID_JUMPMARK, FALSE );
/*N*/     if ( pMarkItem )
/*?*/         aMark = pMarkItem->GetValue();
/*N*/ 
/*N*/ 	SfxViewFrame* pCurViewFrame = SfxViewFrame::Current();
/*N*/ 
/*N*/     SFX_ITEMSET_ARG(pArgs, pFrmItem, SfxFrameItem, SID_DOCFRAME, FALSE);
/*N*/ 	SfxObjectShell *pCur = 0;
/*N*/ 	if( pFrmItem )
/*N*/         pCur = pFrmItem->GetFrame() ? pFrmItem->GetFrame()->GetCurrentDocument() : 0;
/*N*/ 	if( !pCur )
/*N*/ 		pCur = SfxObjectShell::Current();
/*N*/ 
/*N*/     // Es kommen hier entweder Marks ohne URL oder absolute URLS rein.
/*N*/     // SmartRelToAbs erlaubt ausserdem z.B. ueber Basic existente
/*N*/     // Pfadnamen..
/*N*/ 
/*N*/ 	// Marks ohne URLs duerfen sich nur auf das Target beziehen.
/*N*/ 	INetURLObject aObj;
/*N*/     if( aDocFileName.Len() && aDocFileName.GetChar(0) == '#' && pCur ) // Mark ohne URL
/*N*/     {
/*?*/         DBG_ERROR("JumpMark without URL!");
/*?*/         aMark = aDocFileName.Copy(1);
/*?*/ 		if( pCur->HasName())
/*?*/ 		{
/*?*/             aObj.SetURL( pCur->GetMedium()->GetName() );
/*?*/ 			aObj.SetMark( aMark );
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			String aURL = String::CreateFromAscii( "private:local#" );
/*?*/ 			aURL += aMark;
/*?*/ 			aObj.SetURL( aURL );
/*?*/ 		}
/*?*/ 
/*?*/ 		aErrCtxName  = aObj.GetURLNoMark();
/*?*/         aErrCtxName += aDocFileName;
/*N*/     }
/*N*/     else
/*N*/         aObj.SetURL( aDocFileName );
/*N*/ 
/*N*/     // optional filter name
/*N*/     String aFilterName;
/*N*/     SFX_ITEMSET_ARG(pArgs, pFilterItem, SfxStringItem, SID_FILTER_NAME, FALSE );
/*N*/     if ( pFilterItem )
/*N*/         aFilterName = pFilterItem->GetValue();
/*N*/ 
/*N*/     // Hidden-Item
/*N*/     BOOL bHidden = FALSE;
/*N*/     SFX_ITEMSET_ARG(pArgs, pHidItem, SfxBoolItem, SID_HIDDEN, FALSE);
/*N*/     if ( pHidItem )
/*N*/         bHidden = pHidItem->GetValue();
/*N*/ 
/*N*/     // optional read-only-flag
/*N*/     BOOL bReadOnly = FALSE;
/*N*/     SFX_ITEMSET_ARG(pArgs, pReadOnlyItem, SfxBoolItem, SID_DOC_READONLY, FALSE );
/*N*/     if ( pReadOnlyItem && pReadOnlyItem->GetValue() )
/*N*/         bReadOnly = TRUE;
/*N*/ 
/*N*/ 	if( pFrmItem && pFrmItem->FrameKilled() )
/*N*/ 	{
/*?*/ 		DBG_ERROR( "FrameHack schlaegt zu!" );
/*?*/         delete pArgs;
/*?*/         return 0;;
/*N*/ 	}
/*N*/ 
/*N*/     const SfxFilter* pFilter = 0;
/*N*/ 	if ( aFilterName.Len() )
/*N*/         pFilter = SFX_APP()->GetFilterMatcher().GetFilter(aFilterName);
/*N*/ 
/*N*/     SfxMedium* pFile = new SfxMedium(
/*N*/         aDocFileName, bReadOnly ? SFX_STREAM_READONLY : SFX_STREAM_READWRITE, FALSE, pFilter, pArgs );
/*N*/     pFile->UseInteractionHandler( TRUE );
/*N*/ 	if ( pUrlItem )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pFile->SetName( pUrlItem->GetValue(), TRUE );
//STRIP001 /*?*/ 		pFile->SetTemporary( TRUE );
/*N*/ 	}
/*N*/ 
/*N*/ 	// Soll evtl. keine View erzeugt werden ?
/*N*/ 	BOOL bCreateView = TRUE;
/*N*/     SFX_ITEMSET_ARG(pArgs, pCreateViewItem, SfxBoolItem, SID_VIEW, FALSE );
/*N*/ 	if ( pCreateViewItem && !pCreateViewItem->GetValue() )
/*N*/ 		bCreateView = FALSE;
/*N*/ 
/*N*/ 	USHORT nToDo = LEI_DETECTFILTER |  LEI_LOAD;
/*N*/ 	if ( bCreateView )
/*N*/ 		nToDo |= LEI_CREATEVIEW;
/*N*/ 
/*N*/     BOOL bUseCache = TRUE;
/*N*/     SFX_ITEMSET_ARG(pArgs, pForceReloadItem, SfxBoolItem, SID_NOCACHE, FALSE );
/*N*/ 	if ( pForceReloadItem && pForceReloadItem->GetValue() )
/*N*/ 	{
/*?*/         bUseCache = sal_False;
/*?*/         pFile->SetUsesCache( FALSE );
/*N*/ 	}
/*N*/ 
/*N*/     SFX_ITEMSET_ARG(pArgs, pFrameItem, SfxFrameItem, SID_DOCFRAME, FALSE );
/*N*/     LoadEnvironment_Impl* pLoader = new LoadEnvironment_Impl( pFile, pFrameItem ? pFrameItem->GetFrame() : NULL, nToDo, bAllowRO, bUseCache );
/*N*/ 
/*N*/     // ErrorContext aufziehen
/*N*/     pLoader->SetErrorContext( new SfxErrorContext( ERRCTX_SFX_OPENDOC, aErrCtxName ) );
/*N*/ 
/*N*/     if ( bTemplate )
/*?*/         pLoader->pMedium->GetItemSet()->Put( SfxBoolItem( SID_TEMPLATE, TRUE ) );
/*N*/     pLoader->SetMark( aMark );
/*N*/     return pLoader;
/*N*/ }


/*N*/ LoadEnvironment_Impl::LoadEnvironment_Impl( SfxMedium* pMed, SfxFrame* pFrameP, sal_uInt32 eTodoP, sal_Bool bAllowReadOnlyP, sal_Bool bAllowCache )
/*N*/ 	: pMedium( pMed )
/*N*/     , pFrame( pFrameP )
/*N*/     , pContext( NULL )
/*N*/     , bOpenTemplate( sal_False )
/*N*/     , bNewView( sal_False )
/*N*/     , bSalvage( sal_False )
/*N*/     , bReadOnly( sal_False )
/*N*/     , bAllowReadOnly( bAllowReadOnlyP )
/*N*/     , bUseCache( bAllowCache )
/*N*/ 	, nTodo( eTodoP )
/*N*/ 	, bHidden( sal_False )
/*N*/ 	, nError( 0 )
/*N*/ 	, bDocCreated( sal_False )
/*N*/ 	, nStartEvent( 0 )
/*N*/     , bLocal( sal_False )
/*N*/ 	, bIsApi( sal_False )
/*N*/ 	, bTemplate( sal_False )
/*N*/ 	, bPlugIn( sal_False )
/*N*/ 	, pNewFrame( 0 )
/*N*/ 	, bUsableForLocal( sal_False )
/*N*/     , bOwnsFrame( sal_False )
/*N*/ 	, pAntiImpl( 0 )
/*N*/ 	, aDecoupleLink( LINK( this, LoadEnvironment_Impl, LoadDataAvailable_Impl ) )
/*N*/ 	, pMatcher( &SFX_APP()->GetFilterMatcher() )
/*N*/ 	, bWaitingForFilterDetection( sal_False )
/*N*/ 	, bProcessing( sal_False )
/*N*/ {
/*N*/     SFX_ITEMSET_ARG(pMed->GetItemSet(), pNewViewItem, SfxBoolItem, SID_OPEN_NEW_VIEW, FALSE );
/*N*/     if ( pNewViewItem )
/*?*/         bNewView = pNewViewItem->GetValue();
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pSalvageItem, SfxStringItem, SID_DOC_SALVAGE, sal_False );
/*N*/     if ( pSalvageItem )
/*N*/         bSalvage = sal_True;
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG(pMed->GetItemSet(), pReadOnlyItem, SfxBoolItem, SID_DOC_READONLY, sal_False);
/*N*/ 	if ( pReadOnlyItem )
/*N*/ 		bReadOnly = pReadOnlyItem->GetValue();
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG(pMed->GetItemSet(), pHidItem, SfxBoolItem, SID_HIDDEN, sal_False);
/*N*/ 	if ( pHidItem )
/*N*/ 		bHidden = pHidItem->GetValue();
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG( pMed->GetItemSet(), pOwnsItem, SfxBoolItem, SID_OWNS_FRAME, sal_False );
/*N*/ 	if ( pOwnsItem )
/*N*/ 	{
/*?*/     	bOwnsFrame = pOwnsItem->GetValue();
/*?*/     	pMed->GetItemSet()->ClearItem( SID_OWNS_FRAME );
/*N*/ 	}
/*N*/ 
/*N*/ 	if( pFrame )
/*N*/ 		StartListening( pFrame->GetBroadcaster() );
/*N*/ 
/*N*/ 	pMed->SetTransferPriority( SFX_TFPRIO_DOC );
/*N*/ }

/*N*/ void LoadEnvironment_Impl::CancelTransfers()
/*N*/ {
/*N*/ 	// Im CancelTransfers am Medium wird die Ref xThis weggenommen
/*N*/ 	SvRefBaseRef xRef( this );
/*N*/ 	if( xDoc.Is()  )
/*N*/ 	{
/*?*/ 		// Falls im DetectFilter gecancelled wurde, gibt es noch kein Medium
/*?*/ 		if( !xDoc->GetMedium() )
/*?*/ 			xDoc.Clear();
/*?*/ 		else
/*?*/ 			xDoc->CancelTransfers();
/*N*/ 	}
/*N*/ 	else if( pMedium )
/*N*/ 	{
/*?*/ 		pMedium->CancelTransfers();
/*N*/ 	}
/*N*/ 
/*N*/ 	if( nError != ERRCODE_IO_BROKENPACKAGE )
/*N*/ 		nError = ERRCODE_ABORT;
/*N*/ 
/*N*/ 	// aktiv abbrechen, da vielleicht keine Daten mehr kommen
/*N*/ 	if( xOldEnv.Is() )
/*?*/ 		xOldEnv->CancelTransfers();
/*N*/     if ( bProcessing )
/*N*/     {
/*?*/         aDecoupleLink.ClearPendingCall();
/*?*/         aDecoupleLink.Call( this, sal_False, sal_True );
/*N*/     }
/*N*/     else
/*N*/         LoadDataAvailable();
/*N*/ }

/*N*/ sal_Bool UsableForOpen_Impl( SfxObjectShell* pShell, SfxMedium* pMedium  )
/*N*/ {
/*N*/ 	if( !pShell )
/*N*/ 		return sal_False;
/*N*/ 
/*?*/ 	SfxItemSet* pSet = pMedium->GetItemSet();
/*?*/ 
/*?*/ 	SFX_ITEMSET_ARG( pSet, pTemplateItem, SfxBoolItem, SID_TEMPLATE, sal_False );
/*?*/ 	if( pTemplateItem && pTemplateItem->GetValue() )
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	SfxMedium* pOld = pShell->GetMedium();
/*?*/ 
/*?*/ 	// Dies ist der Filename, falls nur ein Mark im Opendoc mitkam
/*?*/ 	String aLocal( DEFINE_CONST_UNICODE("private:local#") );
/*?*/ 
/*?*/ 	// Falls URLs nicht uebereinstimmen und der zu oeffnende Name nicht #xxx
/*?*/ 	// ist, nicht verwenden
/*?*/ 	if( INetURLObject( pOld->GetOrigURL()) !=
/*?*/ 		INetURLObject( pMedium->GetOrigURL() ) && pMedium->GetOrigURL().CompareIgnoreCaseToAscii( aLocal, aLocal.Len() ) != COMPARE_EQUAL )
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	const INetURLObject& rURL = pMedium->GetURLObject();
/*?*/ 
/*?*/ 	// Falls die Filter nicht uebereinstimmen oder eine ViewId mitgegeben
/*?*/ 	// wurde, nicht verwenden
/*?*/ 	if( pMedium->GetFilter() &&	pOld->GetOrigFilter() != pMedium->GetFilter() )
/*?*/ 		return sal_False;
/*?*/ 
/*?*/ 	return sal_True;
/*N*/ }

/*N*/ sal_Bool UsableForOpen_Impl( SfxFrame* pFrame, SfxMedium* pMedium  )
/*N*/ {
/*N*/ 	if( !pFrame )
/*N*/ 		return sal_False;
/*N*/ 
/*N*/ 	// View-Id
/*N*/ 	SfxItemSet* pSet = pMedium->GetItemSet();
/*N*/ 	SFX_ITEMSET_ARG( pSet, pViewIdItem, SfxUInt16Item, SID_VIEW_ID, sal_False );
/*N*/ 	if ( pViewIdItem && pFrame->GetCurrentViewFrame() &&
/*N*/ 		pViewIdItem->GetValue() != pFrame->GetCurrentViewFrame()->GetCurViewId() )
/*N*/ 		return sal_False;
/*N*/ 	return UsableForOpen_Impl( pFrame->GetCurrentDocument(), pMedium );
/*N*/ }

/*N*/ sal_Bool UsableForLocalJump_Impl( SfxFrame* pFrame, SfxMedium* pMedium )
/*N*/ {
/*N*/ 	if( !pFrame )
/*N*/ 		return sal_False;
/*N*/ 	return UsableForOpen_Impl( pFrame, pMedium );
/*N*/ }

/*N*/ void LoadEnvironment_Impl::Start()
/*N*/ {
/*N*/ 	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pRefererItem, SfxStringItem, SID_REFERER, sal_False );
/*N*/ 	if( pRefererItem )
/*N*/ 		pMedium->SetReferer( pRefererItem->GetValue() );
/*N*/ 
/*N*/ 	eState = CONNECTING;
/*N*/ 	sal_uInt32 nErr = ERRCODE_NONE;
/*N*/ 
/*N*/ 	// Eigene Ref halten
/*N*/ 	xThis = this;
/*N*/ 
/*N*/ 	// Wenn wirklich geladen werden soll, muss auf bereits geladene
/*N*/ 	// Doks geprueft werden
/*N*/ 	if( nTodo & LEI_LOAD )
/*N*/ 	{
/*N*/ 		// Security-Check
/*N*/ 		SFX_ITEMSET_ARG( pMedium->GetItemSet(), pRefererItem, SfxStringItem, SID_REFERER, sal_False );
/*N*/ 		// the bIsApi is not used any more
/*N*/ 		// DBG_ASSERT( pRefererItem || bIsApi, "SID_OPEN... without referer => macro- and slot-URLs will be denied" );
/*N*/ 
/*N*/ 		if( aMark.Len() )
/*N*/ 			bLocal = sal_True;
/*N*/ 
/*N*/ 		bUsableForLocal = sal_False;
/*N*/ 
/*N*/ 		// Dies ist der Filename, falls nur ein Mark im Opendoc mitkam
/*N*/ 		String aLocal( DEFINE_CONST_UNICODE("private:local#") );
/*N*/ 
/*N*/ 		// View-Id
/*N*/ 		// Falls ViewId mitkommt, nicht das lokale doc nehmen
/*N*/ 		SFX_ITEMSET_ARG( pMedium->GetItemSet(), pViewIdItem, SfxUInt16Item, SID_VIEW_ID, sal_False );
/*N*/ 
/*N*/ 		SfxObjectShell *pCur;
/*N*/ 		SfxFrame *pCurFrame;
/*N*/ 		if ( !pFrame || !pFrame->GetCurrentDocument() ||
/*N*/ 			pFrame->GetCurrentViewFrame()->GetViewShell()->IsImplementedAsFrameset_Impl() )
/*N*/ 		{
/*N*/ 			// Bei ContainingDocFrames ( Mail... ) ist der TargetFrame immer das
/*N*/ 			// Frameset, auch wenn ein local jump im body ausgef"uhrt werden soll
/*N*/ 			pCur = SfxObjectShell::Current();
/*N*/ 			pCurFrame = pCur ? SfxViewFrame::Current()->GetFrame() : 0;
/*N*/ 
/*N*/ 			// Wenn ein neuer Frame ge"offnet wurde, keinen Local Jump probieren
/*N*/ 			if( !bOwnsFrame && bUseCache )
/*N*/ 			{
/*N*/ 				if (bLocal)
/*N*/ 					bUsableForLocal = UsableForLocalJump_Impl( pCurFrame, pMedium );
/*N*/ 
/*N*/ 				if( !bUsableForLocal )
/*N*/ 				{
/*N*/ 					// Kein lokaler Sprung im aktuellen Document, wir bleiben
/*N*/ 					// beim "ubergebenen Frame
/*N*/ 					if ( pFrame )
/*N*/ 					{
/*N*/ 						pCurFrame = pFrame;
/*N*/ 						pCur = pFrame->GetCurrentDocument();
/*N*/ 					}
/*N*/ 
/*N*/ 					bUsableForLocal = UsableForLocalJump_Impl( pFrame, pMedium );
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					// Lokaler Sprung erw"unscht und m"oglich
/*?*/ 					pFrame = SfxViewFrame::Current()->GetFrame();
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*?*/ 			pCurFrame = pFrame;
/*?*/ 			pCur = pFrame->GetCurrentDocument();
/*?*/ 			if( !bOwnsFrame && bUseCache )
/*?*/ 				bUsableForLocal = UsableForLocalJump_Impl( pFrame, pMedium );
/*N*/ 		}
/*N*/ 
/*N*/ 		SFX_ITEMSET_ARG( pMedium->GetItemSet(), pSilentItem, SfxBoolItem, SID_SILENT, sal_False);
/*N*/ 		sal_Bool bSilent;
/*N*/ 		if( pSilentItem )
/*?*/ 			bSilent = pSilentItem->GetValue();
/*N*/ 		else
/*N*/ 			bSilent = sal_False;
/*N*/ 
/*N*/ 		// bSilent ist fuer Maltes Hilfe
/*N*/ 		if( !bUsableForLocal  )
/*N*/ 		{
/*N*/ 			if( bUseCache )
/*N*/ 			{
/*N*/ 				//! Hier besser das Itemset reinreichen und drinnen
/*N*/ 				//  UsableForLocalJump_Impl usw. fragen
                /*
                xDoc = SFX_APP()->DocAlreadyLoaded( pMedium->GetName(), bSilent, bSilent, !bSilent && !bNewView, 0 );
                if( ( bUsableForLocal = UsableForOpen_Impl( xDoc, pMedium ) ) == TRUE )
				{
					MemCache_Impl &rCache = SfxPickList_Impl::Get()->GetMemCache();
					if ( xDoc.Is() && rCache.IsObjectCached( xDoc ) )
					{
						DBG_ASSERT( !SfxViewFrame::GetFirst( &xDoc ), "visible object is cached => not allowed" );
						rCache.RemoveObject( &xDoc );
						SfxObjectShell_Impl* pDocImpl = xDoc->Get_Impl();
						pDocImpl->bPreparedForClose = sal_False;
						pDocImpl->bClosing = sal_False;
						SfxDocumentInfo &rInfo = xDoc->GetDocInfo();
						xDoc->SetAutoLoad(
							rInfo.GetReloadURL(),
							rInfo.GetReloadDelay() * 1000,
							rInfo.IsReloadEnabled() );
					}
				}
				else
                */
/*N*/ 					xDoc.Clear();
/*N*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/             xDoc = pCur;
/*N*/ 		}
/*N*/ 
/*N*/ 		if( xDoc.Is() )
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxMedium* pDocMed = xDoc->GetMedium();
//STRIP001 /*?*/ 			pMedium->SetFilter( pDocMed->GetFilter() );
//STRIP001 /*?*/ 			pDocMed->SetName( pMedium->GetName() );
//STRIP001 /*?*/ //            pDocMed->GetItemSet()->ClearItem();
//STRIP001 /*?*/ 			pDocMed->GetItemSet()->Put( *pMedium->GetItemSet() );
/*
            if( pDocMed->GetContent().is() )
                UCB_Helper::ExecuteCommand( pDocMed->GetContent(), WID_UPDATE );
 */
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if( xDoc.Is() )
/*N*/ 	{
/*?*/ 		xDoc->Get_Impl()->bIsAbortingImport = sal_False;
/*?*/ 		nTodo &= (~( LEI_DETECTFILTER | LEI_LOAD ) );
/*N*/ 	}
/*N*/     else
/*N*/ 	{
/*N*/ 		if( pFrame )
/*N*/ 		{
/*N*/ 			if( pFrame->GetLoadEnvironment_Impl() != this )
/*N*/ 			{
/*N*/ 				xOldEnv = pFrame->GetLoadEnvironment_Impl();
/*N*/ 				// Der neue Frame gehoert jetzt dem neuen Ladevorgang
/*N*/ 				if( xOldEnv.Is() )
/*N*/ 				{
/*?*/ 					bOwnsFrame = xOldEnv->bOwnsFrame;
/*?*/ 					xOldEnv->bOwnsFrame = sal_False;
/*N*/ 				}
/*N*/ 
/*N*/ 				pFrame->SetLoadEnvironment_Impl( this );
/*N*/ 			}
/*N*/ 			pMedium->SetLoadTargetFrame( pFrame );
/*N*/ 			pFrame->SetLoadCancelable_Impl(
/*N*/ 				new SfxLoadCancellable(	pFrame, pMedium ) );
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/     if( nTodo & (LEI_LOAD | LEI_DETECTFILTER ) )
/*N*/ 	{
/*N*/ 		Link aLink = LINK( this, LoadEnvironment_Impl, LoadDataAvailable_Impl );
/*N*/ 		pMedium->SetDataAvailableLink( aLink );
/*N*/ 		pMedium->SetDoneLink( aLink );
/*N*/ 	}
/*N*/ 
/*N*/ 	// Fuer diese Protokolle muss hier gecanceled werden, da
/*N*/ 	// Connections knapp sind.
/*N*/ 	INetProtocol eProt = pMedium->GetURLObject().GetProtocol();
/*N*/ 	if( pFrame && ( eProt == INET_PROT_HTTP || eProt == INET_PROT_HTTPS ) && !bUsableForLocal )
/*N*/ 	{
/*?*/ 		pFrame->CancelTransfers( sal_False );
/*?*/ 		if( xOldEnv.Is() )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			xOldEnv->CancelTransfers();
//STRIP001 /*?*/ 			xOldEnv.Clear();
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/     LoadDataAvailable();
/*N*/ }

//STRIP001 void LoadEnvironment_Impl::ConvertToTemplate()
//STRIP001 {
//STRIP001 	// Template-Name
//STRIP001     String aName( pMedium->GetName() );
//STRIP001 	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pTemplNamItem, SfxStringItem, SID_TEMPLATE_NAME, sal_False);
//STRIP001 	String aTemplateName;
//STRIP001 	if ( pTemplNamItem )
//STRIP001 		aTemplateName = pTemplNamItem->GetValue();
//STRIP001 	else
//STRIP001     {
//STRIP001 		// Interaktiv ( DClick, Contextmenu ) kommt kein Langname mit
//STRIP001 		aTemplateName = xDoc->GetDocInfo().GetTitle();
//STRIP001         if ( !aTemplateName.Len() )
//STRIP001         {
//STRIP001             INetURLObject aURL( aName );
//STRIP001             aURL.CutExtension();
//STRIP001             aTemplateName = aURL.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	pMedium->SetName( String(), sal_True );
//STRIP001 	pMedium->Init_Impl();
//STRIP001 
//STRIP001 	if( GetMedium()->GetFilter()->IsOwnFormat() )
//STRIP001 	{
//STRIP001         SvStorageRef xTmpStor = new SvStorage( (xDoc->GetStorage()->GetVersion() >= SOFFICE_FILEFORMAT_60), String() );
//STRIP001 		xDoc->GetStorage()->CopyTo( &xTmpStor );
//STRIP001 		xDoc->DoHandsOff();
//STRIP001 		pMedium->SetStorage_Impl( xTmpStor );
//STRIP001 		xDoc->ForgetMedium();
//STRIP001 		if( !xDoc->DoSaveCompleted( pMedium ) )
//STRIP001 			nError = xTmpStor->GetErrorCode();
//STRIP001         else if ( !bSalvage )
//STRIP001 			SetTemplate_Impl( xTmpStor, aName, aTemplateName, xDoc );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SetTemplate_Impl( xDoc->GetStorage(), aName, aTemplateName, xDoc);
//STRIP001 	}
//STRIP001 
//STRIP001 	pMedium->GetItemSet()->ClearItem( SID_DOC_READONLY );
//STRIP001 	pMedium->SetOpenMode( SFX_STREAM_READWRITE, sal_True, sal_True );
//STRIP001 	xDoc->Broadcast( SfxSimpleHint(SFX_HINT_MODECHANGED) );
//STRIP001 	xDoc->Broadcast( SfxDocumentInfoHint( &xDoc->GetDocInfo() ) );
//STRIP001 	xDoc->SetNoName();
//STRIP001 	xDoc->InvalidateName();
//STRIP001 	xDoc->SetModified( sal_False );
//STRIP001 }


//STRIP001 void LoadEnvironment_Impl::DetectFilter()
//STRIP001 {
//STRIP001 	SfxApplication* pApp = SFX_APP();
//STRIP001 	const SfxFilter* pFilter=0;
//STRIP001 	ErrCode nErr = pMatcher->DetectFilter( *pMedium, &pFilter, bPlugIn, bIsApi );
//STRIP001 	nError = nErr;
//STRIP001 	if ( nErr == ERRCODE_NONE || nErr == ERRCODE_IO_PENDING )
//STRIP001 	{
//STRIP001 		pMedium->SetFilter( pFilter );
//STRIP001 		if( !pMedium->GetOrigFilter( sal_True ) )
//STRIP001 			pMedium->SetOrigFilter_Impl( pFilter );
//STRIP001 	}
//STRIP001 
//STRIP001 	return;
//STRIP001 }

/*N*/ void LoadEnvironment_Impl::Load( const SfxObjectFactory *pFactory )
/*N*/ {
/*N*/ 	const SfxFilter*pFilter = pMedium->GetFilter();
/*N*/ 	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pTemplateItem, SfxBoolItem, SID_TEMPLATE, sal_False);
/*N*/     bTemplate = pTemplateItem && pTemplateItem->GetValue();
/*N*/ 				// MI: z.B. private:calendar/
/*N*/ //				( !pMedium->GetFilter() ||
/*N*/ //				  pMedium->GetFilter()->IsAllowedAsTemplate() );
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG(pMedium->GetItemSet(), pReadOnlyItem, SfxBoolItem, SID_DOC_READONLY, sal_False);
/*N*/     if( ( bReadOnly || !pReadOnlyItem ) &&  // readonly prinzipiell erlaubt
/*N*/         ( pFilter && ( pFilter->GetFilterFlags() & SFX_FILTER_OPENREADONLY ) )  // readonly n"otig / sinnvoll
/*N*/         && !bTemplate )                 // nichts als Vorlage "offnen
/*N*/ 	{
/*?*/ 		bReadOnly = sal_True;
/*?*/ 		if( pMedium->GetOpenMode() == SFX_STREAM_READWRITE )
/*?*/ 			pMedium->SetOpenMode( SFX_STREAM_READONLY, sal_False, sal_True );
/*N*/ 	}
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pObjectShellItem, SfxObjectShellItem, SID_OBJECTSHELL, sal_False);
/*N*/ 	if( !( pObjectShellItem && ( xDoc = pObjectShellItem->GetObjectShell() ).Is() )
/*N*/ 		&& pFactory )
/*N*/ 		xDoc = pFactory->CreateObject();
/*N*/ 	pMedium->GetItemSet()->ClearItem( SID_OBJECTSHELL );
/*N*/ 
/*N*/ 	if ( !nError && xDoc.Is() )
/*N*/ 	{
/*N*/ 		if ( pFrame  )
/*N*/ 		{
/*N*/ 			xDoc->SetActualSize( pFrame->GetWindow().GetOutputSizePixel() );
/*N*/ 			xDoc->SetInFrame( pFrame->GetParentFrame() != NULL );
/*N*/ 		}
/*N*/ 
/*N*/ 		// beim ersten Activate ein Open-Event verschicken
/*N*/ 		//! pPsh nur wg. Absturz im Writer
/*N*/ 		bDocCreated = sal_True;
/*N*/ 		if ( !bOpenTemplate )
/*N*/             xDoc->SetActivateEvent_Impl( bTemplate ?  SFX_EVENT_CREATEDOC : SFX_EVENT_OPENDOC );
/*N*/ 
/*N*/ 		sal_Bool bQueryLoadTemplate = sal_False;
/*N*/ 		if( !bIsApi && !bHidden )
/*?*/ 			bQueryLoadTemplate = sal_True;
/*N*/ 		// Passwort?
/*N*/ 
/*N*/ 		if( !(pMedium->GetFilter()->GetFilterFlags() & SFX_FILTER_CREATOR ))
/*N*/ 		{
/*N*/             if( pFilter->GetFilterFlags() & SFX_FILTER_ASYNC )
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				pAntiImpl = new SfxLoadEnvironment( this );
//STRIP001 /*?*/                 pMedium->SetLoadEnvironment( pAntiImpl );
/*N*/ 			}
/*N*/ 
/*N*/             // Gegen Rescheduling im DoLoad sch"utzen
/*N*/             SfxObjectShellRef xSave( xDoc );
/*N*/             SfxTopFrame* pTop = PTR_CAST( SfxTopFrame, pFrame );
/*N*/             if ( pTop )
/*N*/             {
/*N*/                 Window* pWindow = pTop->GetTopWindow_Impl();
/*N*/                 if ( pWindow )
/*N*/                 {
/*N*/                     String aTitle = xDoc->UpdateTitle( pMedium );
/*N*/                     aTitle += String::CreateFromAscii( " - " );
/*N*/                     aTitle += Application::GetDisplayName();
/*N*/                     pTop->GetTopWindow_Impl()->SetText( aTitle );
/*N*/                     if( pWindow->GetType() == WINDOW_WORKWINDOW )
/*N*/                     {
/*N*/                         SvtModuleOptions::EFactory eFactory;
/*N*/                         if( SvtModuleOptions::ClassifyFactoryByName( xDoc->GetFactory().GetDocumentServiceName(), eFactory ) )
/*N*/                         {
/*N*/                             WorkWindow* pWorkWindow = (WorkWindow*)pWindow;
/*N*/                             pWorkWindow->SetIcon( (sal_uInt16) SvtModuleOptions().GetFactoryIcon( eFactory ) );
/*N*/                         }
/*N*/                     }
/*N*/                 }
/*N*/             }
/*N*/ 
/*N*/ 			if ( !xDoc->DoLoad(pMedium))
/*N*/ 				nError=ERRCODE_IO_GENERAL;
/*N*/ 			if( xDoc->GetErrorCode() )
/*N*/ 				nError = xDoc->GetErrorCode();
/*N*/ 			if( xDoc->IsAbortingImport() )
/*N*/ 			{
/*N*/ 				nError = ERRCODE_ABORT;
/*N*/ // pFrame darf nicht auf 0 gesetzt werden, da sonst im Destruktor das
/*N*/ // Environment nicht ausgetragen wird
/*N*/ //					pFrame = 0;
/*N*/ 			}
/*N*/ 
/*N*/             if ( !nError && bSalvage )
/*N*/             {
/*?*/                 SFX_ITEMSET_ARG(pMedium->GetItemSet(), pFilterItem, SfxStringItem, SID_FILTER_NAME, sal_False );
/*?*/                 SfxFilterMatcher& rMatcher = SFX_APP()->GetFilterMatcher();
/*?*/                 const SfxFilter* pFilter = rMatcher.GetFilter( pFilterItem->GetValue() );
/*?*/                 pMedium->SetFilter( pFilter );
/*N*/             }
/*N*/ 
/*N*/             if( ERRCODE_TOERROR( nError ) )
/*N*/ 				return;
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			// Es soll nur ein leeres Doc erzeugt werden
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 xDoc->DoInitNew(0);
//STRIP001 /*?*/ 			SfxMedium *pNewMedium = xDoc->GetMedium();
//STRIP001 /*?*/ 			pNewMedium->SetOpenMode( pMedium->GetOpenMode(), sal_False );
//STRIP001 /*?*/ 			pNewMedium->SetName( pMedium->GetName() );
//STRIP001 /*?*/ 			SfxItemSet* pNewSet = new SfxAllItemSet(
//STRIP001 /*?*/ 				*pMedium->GetItemSet() );
//STRIP001 /*?*/ 			pNewMedium->SetItemSet( pNewSet );
//STRIP001 /*?*/ 			xDoc->SetTitle( pMedium->GetName() );
//STRIP001 /*?*/ 			xDoc->InvalidateName();
//STRIP001 /*?*/ 			xDoc->SetModified( sal_False );
//STRIP001 /*?*/ 			pNewMedium->SetFilter( pMedium->GetFilter() );
//STRIP001 /*?*/ 			pNewMedium->Init_Impl();
//STRIP001 /*?*/ 			pNewMedium->SetCancelManager_Impl( pMedium->GetCancelManager_Impl());
//STRIP001 /*?*/ 			pNewMedium->SetLoadTargetFrame( pMedium->GetLoadTargetFrame() );
//STRIP001 /*?*/ 			delete pMedium;
//STRIP001 /*?*/ 			pMedium = pNewMedium;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ void LoadEnvironment_Impl::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/ 	SfxSimpleHint* pHint = PTR_CAST( SfxSimpleHint, &rHint );
/*N*/ 	if( pHint && pHint->GetId() == SFX_HINT_DYING )
/*N*/ 		pFrame = 0;
/*N*/ }

//STRIP001 SfxFrame* GetTargetFrame_Impl( const SfxItemSet* pSet, BOOL& rbOwner  )
//STRIP001 {
//STRIP001 	SFX_ITEMSET_ARG(pSet, pViewItem, SfxBoolItem, SID_VIEW, FALSE);
//STRIP001 
//STRIP001 	if ( pViewItem && !pViewItem->GetValue() )
//STRIP001 		// ohne View laden
//STRIP001 		return NULL;
//STRIP001 
//STRIP001 	SFX_ITEMSET_ARG(pSet, pFrmItem, SfxFrameItem, SID_DOCFRAME, FALSE);
//STRIP001 	SFX_ITEMSET_ARG(pSet, pTargetItem, SfxStringItem, SID_TARGETNAME, FALSE);
//STRIP001 	SFX_ITEMSET_ARG(pSet, pBoolItem, SfxBoolItem, SID_ONLYSUBFRAMES, FALSE);
//STRIP001 	SFX_ITEMSET_ARG(pSet, pRefererItem, SfxStringItem, SID_REFERER, FALSE);
//STRIP001     SFX_ITEMSET_ARG(pSet, pPreviewItem, SfxBoolItem, SID_PREVIEW, FALSE);
//STRIP001 
//STRIP001 	// Frame als Parameter mitgegeben?
//STRIP001 	SfxFrame *pFrame = NULL;
//STRIP001 	if ( pFrmItem )
//STRIP001 		pFrame = pFrmItem->GetFrame();
//STRIP001 	SfxFrame *pSource = pFrame;
//STRIP001 	SfxFrame *pStart = pFrame;
//STRIP001 
//STRIP001     if ( pPreviewItem && pPreviewItem->GetValue() )
//STRIP001     {
//STRIP001         DBG_ASSERT( pFrame, "Preview without frame!" );
//STRIP001         return pFrame;
//STRIP001     }
//STRIP001 
//STRIP001 	String aTargetName;
//STRIP001     if ( pTargetItem && pTargetItem->GetValue().Len() )
//STRIP001 	{
//STRIP001 		// Wenn ein TargetItem mitgegeben wurde, aber kein Frame, den
//STRIP001 		// Current ViewFrame nehmen
//STRIP001 		SfxViewFrame* pCurViewFrame = SfxViewFrame::Current();
//STRIP001 		if ( !pCurViewFrame )
//STRIP001 			pCurViewFrame = SfxViewFrame::GetFirst();
//STRIP001 
//STRIP001 		if ( !pFrame && pCurViewFrame )
//STRIP001 		{
//STRIP001 			pFrame = pCurViewFrame->GetFrame();
//STRIP001 			pStart = pFrame;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pFrame )
//STRIP001 		{
//STRIP001 			aTargetName = pTargetItem->GetValue();
//STRIP001 
//STRIP001 			// Wenn kein TargetName, dann den vom Current Document
//STRIP001 			SfxObjectShell* pCur = SfxObjectShell::Current();
//STRIP001 			if( !aTargetName.Len() && pCur )
//STRIP001 				aTargetName = pCur->GetDocInfo().GetDefaultTarget();
//STRIP001 		}
//STRIP001 	}
//STRIP001     else if ( pFrame && (pFrame->GetFrameName().CompareToAscii("mail-body") == COMPARE_EQUAL) )
//STRIP001     {
//STRIP001         // Hack for MailDocument in Office 5.2
//STRIP001         aTargetName = String::CreateFromAscii("_blank");
//STRIP001     }
//STRIP001 
//STRIP001 	BOOL bNewTask =
//STRIP001             aTargetName.CompareToAscii("_blank")	== COMPARE_EQUAL ||
//STRIP001             aTargetName.CompareToAscii("_default")    == COMPARE_EQUAL ||
//STRIP001             aTargetName.CompareToAscii("_null")		== COMPARE_EQUAL;
//STRIP001 
//STRIP001 	if ( pFrame )
//STRIP001 	{
//STRIP001 		if ( pBoolItem && pBoolItem->GetValue() )
//STRIP001 		{
//STRIP001 			DBG_ASSERT( aTargetName.Len(), "OnlySubFrames, aber kein Name!" );
//STRIP001 			pFrame = pFrame->SearchChildrenForName_Impl( aTargetName );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( !bNewTask || pFrame->GetFrameName().Len() || pFrame->GetCurrentDocument() || pFrame->GetParentFrame() )
//STRIP001 				// Auch bei leerem TargetName suchen wg. SmartSelf
//STRIP001 				// _blank nur suchen, wenn pFrame nicht schon _blank ist!
//STRIP001 				pFrame = pFrame->SearchFrame( aTargetName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bName = ( pFrame == NULL );
//STRIP001     if ( pFrame )
//STRIP001 	{
//STRIP001 		// Es wurde ein Frame gefunden; dessen Doc darf nicht ersetzt werden,
//STRIP001 		// wenn es der Desktop ist oder wenn es embedded ist
//STRIP001 		// Ausnahme: neuerdings k"onnen wir auch innerhalb des Desktops browsen, wenn dieser ein Frameset ist
//STRIP001 		SfxObjectShell* pCur = pFrame->GetCurrentDocument();
//STRIP001         if( pCur && pCur->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED )
//STRIP001 		{
//STRIP001 			pFrame = 0;
//STRIP001 			pSource = 0;
//STRIP001 			pStart = 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Kein Frame gefunden -> Neuen Frame nehmen
//STRIP001 	if ( !pFrame )
//STRIP001 	{
//STRIP001         SFX_ITEMSET_ARG( pSet, pHiddenItem, SfxBoolItem, SID_HIDDEN, FALSE);
//STRIP001         BOOL bHidden =  pHiddenItem && pHiddenItem->GetValue();
//STRIP001         pFrame = SfxTopFrame::Create( NULL, 0, bHidden );
//STRIP001         rbOwner = TRUE;
//STRIP001 		if ( !bNewTask && bName )
//STRIP001 			pFrame->SetFrameName( aTargetName );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rbOwner = FALSE;
//STRIP001 
//STRIP001 	return pFrame;
//STRIP001 }


/*N*/ void LoadEnvironment_Impl::CreateView()
/*N*/ {
/*N*/ 	DBG_ASSERT( xDoc.Is(), "CreateView ohne Doc gferufen" );
/*N*/ 	if ( nTodo & LEI_LOAD )
/*N*/ 	{
/*N*/ 		if( bTemplate && !(pMedium->GetFilter()->GetFilterFlags() & SFX_FILTER_CREATOR ) )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ConvertToTemplate();
/*N*/ 		else
/*N*/             pMedium->SetUpdatePickList( !bIsApi && !bHidden);
/*N*/ 
/*N*/ 		if( bOpenTemplate )
/*?*/ 			xDoc->SetTemplate(sal_True);
/*N*/ 
/*N*/ 		if( xDoc.Is() && nError )
/*?*/ 			xDoc->ResetError();
/*N*/ 
/*N*/ 		// ggf. Template pr"ufen ( nur bei Dokumenten im FileSystem )
/*N*/         if ( xDoc.Is() && !bHidden && !bIsApi && ::utl::LocalFileHelper::IsLocalFile( pMedium->GetName() ) )
/*?*/ 			xDoc->UpdateFromTemplate_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( xDoc.Is() && pFrame )
/*N*/ 	{
/*N*/ 		SfxMedium &rMedium = *xDoc->GetMedium();
/*N*/ 		SvKeyValueIteratorRef xIter( xDoc->GetHeaderAttributes() );
/*N*/ 		SvKeyValue aValue;
/*N*/ 		for( sal_Bool bCont = xIter->GetFirst( aValue ); bCont; bCont = xIter->GetNext( aValue ) )
/*N*/ 		{
/*?*/ 			if ( aValue.GetKey().CompareIgnoreCaseToAscii( "Window-Target" ) == COMPARE_EQUAL )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				SfxItemSet *pSet = rMedium.GetItemSet();
//STRIP001 /*?*/ 				pSet->Put( SfxStringItem( SID_TARGETNAME, aValue.GetValue() ) );
//STRIP001 /*?*/ 				pSet->Put( SfxFrameItem( SID_DOCFRAME, pFrame ) );
//STRIP001 /*?*/ 				pSet->ClearItem( SID_ONLYSUBFRAMES );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				sal_Bool bOwns;
//STRIP001 /*?*/                 SfxFrame *pNewFrame = GetTargetFrame_Impl( pSet, bOwns );
//STRIP001 /*?*/ 				if ( pNewFrame != pFrame )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if( pFrame->GetLoadEnvironment_Impl() == this )
//STRIP001 /*?*/ 						pFrame->SetLoadEnvironment_Impl( 0 );
//STRIP001 /*?*/ 					pFrame->SetLoadCancelable_Impl( 0 );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( bOwnsFrame )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aDoneLink.Call(NULL);
//STRIP001 /*?*/ 						aDoneLink = Link();
//STRIP001 /*?*/ 						pFrame->DoClose();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					pFrame = pNewFrame;
//STRIP001 /*?*/ 					bOwnsFrame = bOwns;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					xOldEnv = pFrame->GetLoadEnvironment_Impl();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// Der neue Frame gehoert jetzt dem neuen Ladevorgang
//STRIP001 /*?*/ 					if( xOldEnv.Is() )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						bOwnsFrame = xOldEnv->bOwnsFrame;
//STRIP001 /*?*/ 						xOldEnv->bOwnsFrame = sal_False;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					pFrame->SetLoadEnvironment_Impl( this );
//STRIP001 /*?*/ 					rMedium.SetLoadTargetFrame( pFrame );
//STRIP001 /*?*/ 					pFrame->SetLoadCancelable_Impl( new SfxLoadCancellable(	pFrame, &rMedium ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if( xOldEnv.Is() )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						xOldEnv->CancelTransfers();
//STRIP001 /*?*/ 						xOldEnv.Clear();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				break;
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pUserDataItem, SfxStringItem, SID_USER_DATA, sal_False);
/*N*/ 
/*N*/ 	// Falls Lokal, History updaten.
/*N*/ 	sal_Bool bIsLocal = sal_False;
/*N*/ 	SfxViewFrame* pF = 0;
/*N*/ 	if( pFrame && pFrame->GetCurrentDocument() == &xDoc )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 bIsLocal = sal_True;
//STRIP001 /*?*/ 		String aNewName( pMedium->GetOrigURL() );
//STRIP001 /*?*/ 		pFrame->UpdatePickEntries();
//STRIP001 /*?*/ 		pFrame->UpdateHistory(	xDoc, &aNewName );
//STRIP001 /*?*/ 		if( xDoc->HasName() )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			xDoc->SetName( pMedium->GetName() );
//STRIP001 /*?*/ 			xDoc->GetMedium()->SetName( pMedium->GetName(), sal_True );
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxObjectShell* pCurDoc = pFrame ? pFrame->GetCurrentDocument() : 0;
/*N*/ 
/*N*/ 	SFX_ITEMSET_ARG( pMedium->GetItemSet(), pTargetItem, SfxStringItem, SID_TARGETNAME, sal_False);
/*N*/ 	if ( pFrame )
/*N*/ 	{
/*N*/ 		if( pFrame->GetCurrentDocument() != &xDoc )
/*N*/ 		{
/*N*/ 			// Ist es ein MDIFrame?
/*N*/ 			if( bOwnsFrame || pFrame->GetCurrentViewFrame() )
/*?*/ 				pFrame->SetItemSet_Impl( pMedium->GetItemSet() );
/*N*/ 			if( !pFrame->InsertDocument( xDoc ) )
/*N*/ 			{
/*N*/ 				nError = ERRCODE_ABORT;
/*N*/ 				return;
/*N*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*?*/             if ( pFrame->GetController().is() )
/*?*/ 			{
/*?*/                 SFX_ITEMSET_ARG( pMedium->GetItemSet(), pAny, SfxUnoAnyItem, SID_VIEW_DATA, sal_False );
/*?*/ 				if ( pAny )
/*?*/ 					pFrame->GetController()->restoreViewData( pAny->GetValue() );
/*?*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		pF = pFrame->GetCurrentViewFrame();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
/*?*/ 		// sonst View aus Doc laden bzw. neu erzeugen
//STRIP001 /*?*/         pF = SFX_APP()->CreateView_Impl( pMedium->GetItemSet(), xDoc, sal_True, bHidden );
//STRIP001 /*?*/ 		pFrame = pF->GetFrame();
/*N*/ 	}
/*N*/ 
/*N*/ 	// Ab in die Pickliste
/*N*/ 	xDoc->Get_Impl()->bWaitingForPicklist = sal_True;
/*N*/ 
/*N*/ 	// ggf. in der View zum Bookmark springen; aber nur wenn keine UserDaten mitkommen, denn die wurden
/*N*/ 	// schon beim Erzeugen der View ber"ucksichtigt ( nat"urlich nur wenn eine erzeugt wurde ! )
/*N*/ 	if ( bIsLocal && pUserDataItem )
/*N*/ 	{
/*?*/ 		pFrame->GetCurrentViewFrame()->GetViewShell()->ReadUserData( pUserDataItem->GetValue(), sal_True );
/*N*/ 	}
/*N*/ 	else if( pF && aMark.Len() && !pUserDataItem )
/*N*/ 	{
/*?*/ 		MarkData_Impl* pMark = new MarkData_Impl;
/*?*/ 		pMark->aMark = aMark;
/*?*/ 		xDoc->Get_Impl()->pMarkData = pMark;
/*?*/ 		pMark->pFrame = pF;
/*?*/ 		if( !xDoc->IsLoading() )
/*?*/ 			xDoc->PositionView_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	String aURL = xDoc->GetMedium()->GetName();
/*N*/ 
/*N*/ 	SFX_APP()->Broadcast( SfxStringHint(
/*N*/ 		SID_OPENURL, aURL ) );
/*N*/ 	if( pF )
/*N*/ 	{
/*N*/ 		if( !bDocCreated && !bLocal  )
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( xDoc->GetMedium()->IsExpired() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SfxAllItemSet aSet( SFX_APP()->GetPool() );
//STRIP001 /*?*/ 				((SfxItemSet*)&aSet)->Put(
//STRIP001 /*?*/ 					SfxBoolItem( SID_FORCERELOAD, sal_False ) );
//STRIP001 /*?*/ 				SfxRequest aReq( SID_RELOAD, SFX_CALLMODE_ASYNCHRON, aSet );
//STRIP001 /*?*/ 				pF->ExecReload_Impl( aReq, sal_True );
//STRIP001 /*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( bSalvage )
/*N*/ 		xDoc->SetModified(sal_True);
/*N*/ }


//STRIP001 sal_Bool LoadEnvironment_Impl::PrepareClose()
//STRIP001 {
//STRIP001 	if ( pFrame )
//STRIP001 	{
//STRIP001 		sal_uInt16 nRet = pFrame->PrepareClose_Impl( !bIsApi, sal_True );
//STRIP001 		if ( nRet == RET_NEWTASK )
//STRIP001 		{
//STRIP001 			if( pFrame && pFrame->GetLoadEnvironment_Impl() == this )
//STRIP001 				pFrame->SetLoadEnvironment_Impl( &xOldEnv );
//STRIP001 			xOldEnv.Clear();
//STRIP001 			if ( bOwnsFrame )
//STRIP001 			{
//STRIP001 				aDoneLink.Call(NULL);
//STRIP001 				aDoneLink = Link();
//STRIP001 				pFrame->DoClose();
//STRIP001 			}
//STRIP001 			pFrame = 0;
//STRIP001 			nRet = sal_True;
//STRIP001 		}
//STRIP001 		else if ( nRet )
//STRIP001 			pFrame->UpdatePickEntries();
//STRIP001 		return (sal_Bool) nRet;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return sal_True;
//STRIP001 }


/*N*/ IMPL_LINK( LoadEnvironment_Impl,LoadDataAvailable_Impl, void* , pVoid )
/*N*/ {
/*N*/     if ( bProcessing )
/*N*/ 	{
/*N*/ 		// keine erneuten Aufrufe von aussen, solange ein anderer Aufruf
/*N*/ 		// noch nicht komplett abgearbeitet wurde
/*N*/ 		aDecoupleLink.ClearPendingCall();
/*N*/ 		aDecoupleLink.Call( pVoid, sal_False, sal_True );
/*N*/ 	}
/*N*/     else
/*N*/     {
/*N*/         bProcessing = TRUE;
/*N*/         LoadDataAvailable();
/*N*/     }
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

/*N*/ void LoadEnvironment_Impl::LoadDataAvailable()
/*N*/ {
/*N*/     // protect against reentrance ( through multithreading or rescheduling )
/*N*/ 	bProcessing = sal_True;
/*N*/ 
/*N*/ 	LoadEnvironment_ImplRef xSave( this );
/*N*/     if ( Application::IsUICaptured() )
/*N*/ 	{
/*N*/ 		// Beim synchronen Laden k"onnten aktive UI-Elemente zerst"ort werden
/*?*/ 		if ( pMedium->IsDownloadDone_Impl() )
/*?*/ 			aDecoupleLink.Call( 0, sal_True, sal_True );
/*?*/         bProcessing = FALSE;
/*?*/         return;
/*N*/ 	}
/*N*/ 
/*N*/     if( pMedium && !nError )
/*N*/ 	{
/*N*/ 		// Auf aufgetretene Fehler testen
/*N*/ 		ErrCode nMedErr = pMedium->GetErrorCode();
/*N*/ 		if( nMedErr == ERRCODE_IO_PENDING )
/*N*/ 		{
/*N*/ 			// Pending gilt nicht als Error
/*?*/ 			nMedErr = ERRCODE_NONE;
/*?*/ 			pMedium->ResetError();
/*N*/ 		}
/*N*/ 
/*N*/ 		if( nMedErr )
/*N*/ 			// Error vom Medium auf das LoadEnvironment "ubertragen
/*N*/ 			nError = nMedErr;
/*N*/ 	}
/*N*/ 
/*N*/     if ( nError )
/*N*/         Error();
/*N*/ 
/*N*/ 	switch( eState )
/*N*/ 	{
/*N*/ 		case CONNECTING:
/*N*/ 		{
/*N*/ 			aDecoupleLink.ClearPendingCall();
/*N*/ 			eState = DETECTING;
/*N*/             pMedium->SetLoadEnvironment_Impl( this );
/*N*/             const SfxFilter* pFilter = pMedium->GetFilter();
/*N*/             if ( !pFilter )
/*N*/             {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/                 DetectFilter();
//STRIP001 /*?*/                 pFilter = pMedium->GetFilter();
/*N*/             }
/*N*/             else
/*N*/                 pMedium->StartDownload();
/*N*/ 
/*N*/             if( pFilter )
/*N*/             {
/*N*/                 if ( pMedium->IsDownloadDone_Impl() /* || ( pFilter->GetFilterFlags() & SFX_FILTER_ASYNC ) */ )
/*N*/                     // otherwise wait for Done or DataAvailable Callback
/*N*/                     LoadDataAvailable();
/*N*/             }
/*N*/             else if ( nError == ERRCODE_NONE )
/*N*/             {
/*N*/                 DBG_ERROR( "LoadEnvironment started without medium or filter!" );
/*N*/                 nError =  ERRCODE_SFX_NOFILTER;
/*N*/             }
/*N*/ 
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case DETECTING :
/*N*/ 		{
/*N*/ 			sal_Bool bHadToLoad = sal_False;
/*N*/ 			if( !xDoc.Is() )
/*N*/ 			{
/*N*/ 				if( ( nTodo & LEI_LOAD ) && !nError )
/*N*/ 				{
/*N*/ 					bHadToLoad = sal_True;
/*N*/ 
/*N*/                     // Finden der richtigen DocShell fuer den Filter
/*N*/                     const SfxObjectFactory* pFactory = &(( SfxFactoryFilterContainer *) pMedium->GetFilter()->GetFilterContainer())->GetFactory();
/*N*/                     if ( !pFactory  )
/*N*/                     {
/*N*/                         nError =  ERRCODE_SFX_NOFILTER;
/*N*/                         break;
/*N*/                     }
/*N*/ 
/*N*/                     if( pFrame )
/*N*/                         pFrame->CancelTransfers( sal_False );
/*N*/ 
/*N*/                     if( xOldEnv.Is() )
/*N*/                     {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/                         xOldEnv->CancelTransfers();
//STRIP001 /*?*/                         xOldEnv.Clear();
/*N*/                     }
/*N*/ 
/*N*/                     Load( pFactory );
/*N*/ 
/*N*/ 					// Jetzt gibt es keinen Weg zur"uck
/*N*/ 					xOldEnv.Clear();
/*N*/ 					eState = DOWNLOADING;
/*N*/ 
/*N*/ 					// JavaScript URL asynchron
/*N*/ 					if( nError == ERRCODE_IO_PENDING || nError == ERRCODE_SFX_RESTART )
/*N*/ 					{
/*?*/ 						if( nError == ERRCODE_SFX_RESTART )
/*?*/ 						{
/*?*/ 							nError = 0;
/*?*/ 							if ( !pMedium->GetFilter() )
/*?*/ 								nTodo |= LEI_DETECTFILTER;
/*?*/ 							Start();
/*?*/ 						}
/*?*/ 						else
/*?*/ 							nError = 0;
/*?*/ 						break;
/*N*/ 					}
/*N*/ 				}
/*N*/ 			}
/*N*/             else if( nError != ERRCODE_ABORT && !bUsableForLocal )
/*N*/ 				nError = ERRCODE_ABORT;
/*N*/ 
/*N*/ 			// Falls Filter synchron, gleich View erzeugen;
/*N*/             if( !bHadToLoad || pMedium->GetFilter() )
/*N*/ 				eState = CREATINGVIEW;
/*N*/             LoadDataAvailable();
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case DOWNLOADING:
/*N*/ 		{
/*?*/             if( pMedium && pMedium->IsOpen() )
/*?*/ 				aDataAvailableLink.Call( 0 );
/*?*/ 			break;
/*N*/ 		}
/*N*/ 		case CREATINGVIEW:
/*N*/ 		{
/*N*/ 			eState = DOWNLOADING;
/*N*/             if( xDoc.Is() && !ERRCODE_TOERROR( nError ) )
/*N*/             {
/*N*/                 if( nTodo & LEI_CREATEVIEW )
/*N*/                 {
/*N*/                     CreateView();
/*N*/                     if ( bHidden )
/*N*/                     {
/*N*/                         // prevent Document from being destroyed in dtor of LoadEnvironment
/*N*/                         xDoc->OwnerLock( TRUE );
/*N*/                         xDoc->Get_Impl()->bHiddenLockedByAPI = TRUE;
/*N*/                     }
/*N*/                 }
/*N*/                 else
/*N*/                 {
/*N*/                     // prevent Document from being destroyed in dtor of LoadEnvironment
/*?*/                     xDoc->OwnerLock( TRUE );
/*?*/                     xDoc->Get_Impl()->bHiddenLockedByAPI = TRUE;
/*N*/                 }
/*N*/             }
/*N*/ 
/*N*/ 			// Falls wg. UICaptured das Lesen vor"ubergehend eingestellt wurde
/*N*/ 			if( pMedium && pMedium->IsOpen() )
/*N*/ 				aDataAvailableLink.Call( 0 );
/*N*/ 
/*N*/             eState = DONE;
/*N*/             LoadDataAvailable();
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		case DONE:
/*N*/         {
/*N*/ 			// Falls wg. UICaptured das Lesen vor"ubergehend eingestellt wurde
/*N*/             if( !nError && pMedium && pMedium->IsOpen() )
/*N*/ 				aDataAvailableLink.Call( 0 );
/*N*/ 
            if( !bDocCreated && ( nTodo & LEI_LOAD ) /* ||
                pMedium && pMedium->GetFilter() &&
                ( pMedium->GetFilter()->GetFilterFlags() &
                    SFX_FILTER_CREATOR ) && !bTemplate */ )  DELETEZ( pMedium );
/*N*/ 
/*N*/             if ( aDoneLink.IsSet() )
/*N*/             {
/*N*/                 SfxPoolItem* pRet;
/*N*/                 if( pFrame )
/*N*/                     pRet = new SfxViewFrameItem( 0, &xDoc ? pFrame->GetCurrentViewFrame() : 0);
/*N*/                 else
/*?*/                     pRet = new SfxObjectShellItem( 0, xDoc );
/*N*/ 
/*N*/                 aDoneLink.Call( pRet );
/*N*/                 delete pRet;
/*N*/                 aDoneLink = Link();
/*N*/             }
/*N*/ 
/*N*/             if ( !nError )
/*N*/                 bOwnsFrame = sal_False;
/*N*/ 
/*N*/             if( pMedium )
/*N*/                 pMedium->SetLoadEnvironment( NULL );
/*N*/ 
/*N*/ 			if ( !pMedium || pMedium->IsDownloadDone_Impl() )
/*N*/             	// Von uns aus kann gel"oscht werden
/*N*/             	xThis.Clear();
/*N*/ 
/*N*/             break;
/*N*/         }
/*N*/ 	}
/*N*/ 
/*N*/ 	bProcessing = sal_False;
/*N*/ }

/*N*/ void LoadEnvironment_Impl::Error()
/*N*/ {
/*N*/     if( nError != ERRCODE_IO_ABORT && !bHidden )
/*?*/     {
/*?*/         sal_Bool bSilent = FALSE;
/*?*/ 		if ( pMedium )
/*?*/ 		{
/*?*/ 			SFX_ITEMSET_ARG( pMedium->GetItemSet(), pSilentItem, SfxBoolItem, SID_SILENT, sal_False);
/*?*/ 			if( pSilentItem )
/*?*/ 				bSilent = pSilentItem->GetValue();
/*?*/ 		}
/*?*/ 
/*?*/         // Keine Fehlermeldung beim hidden oder silent
/*?*/         if( !bIsApi )
/*?*/         {
/*?*/             if ( !bSilent && nError != ERRCODE_IO_BROKENPACKAGE )
/*?*/             {
/*?*/                 if (pMedium)
/*?*/                 {
/*?*/                     BOOL bWarning = ((nError & ERRCODE_WARNING_MASK) == ERRCODE_WARNING_MASK);
/*?*/ 
/*?*/                     ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionHandler > xHandler = pMedium->GetInteractionHandler();
/*?*/                     if (!xHandler.is() && !bWarning)
/*?*/                         nError = ERRCODE_IO_ABORT;
/*?*/                     else
/*?*/                     if (xHandler.is())
/*?*/                     {
/*?*/                         ::com::sun::star::uno::Any aInteraction;
/*?*/                         ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionContinuation > > lContinuations(2);
/*?*/                         ::framework::ContinuationAbort* pAbort = new ::framework::ContinuationAbort();
/*?*/                         ::framework::ContinuationApprove* pApprove = new ::framework::ContinuationApprove();
/*?*/                         lContinuations[0] = ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionContinuation >(static_cast< ::com::sun::star::task::XInteractionContinuation* >(pAbort), ::com::sun::star::uno::UNO_QUERY);
/*?*/                         lContinuations[1] = ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionContinuation >(static_cast< ::com::sun::star::task::XInteractionContinuation* >(pApprove), ::com::sun::star::uno::UNO_QUERY);
/*?*/ 
/*?*/                         ::com::sun::star::task::ErrorCodeRequest aErrorCode;
/*?*/                         aErrorCode.ErrCode = nError;
/*?*/                         aInteraction <<= aErrorCode;
/*?*/ 
/*?*/                         ::framework::InteractionRequest* pRequest = new ::framework::InteractionRequest(aInteraction,lContinuations);
/*?*/                         ::com::sun::star::uno::Reference< ::com::sun::star::task::XInteractionRequest > xRequest(static_cast< ::com::sun::star::task::XInteractionRequest* >(pRequest), ::com::sun::star::uno::UNO_QUERY);
/*?*/ 
/*?*/                         xHandler->handle(xRequest);
/*?*/ 
/*?*/                         if (pAbort->isSelected() && !bWarning)
/*?*/                             nError = ERRCODE_IO_ABORT;
/*?*/                     }
/*?*/                 }
/*?*/             }
/*?*/         }
/*?*/         else
/*?*/             SbxBase::SetError( nError );
/*?*/     }
/*N*/ 
/*N*/     ErrCode nFatalError = ERRCODE_TOERROR( nError );
/*N*/     if( nFatalError )
/*N*/     {
/*N*/         if( pFrame && pMedium )
/*N*/         {
/*N*/             SFX_ITEMSET_ARG( pMedium->GetItemSet(), pIsChildLoad, SfxBoolItem, SID_ISCHILDFRAMELOAD, sal_False );
/*N*/             if ( pIsChildLoad && pIsChildLoad->GetValue() )
/*?*/                 {DBG_BF_ASSERT(0, "STRIP");}//STRIP001 pFrame->LoadFinished_Impl();
/*N*/         }
/*N*/ 
/*N*/         if( xDoc.Is() )
/*N*/         {
/*?*/             pMedium = 0;
/*?*/ 			xDoc->DoClose();
/*?*/             xDoc.Clear();
/*N*/         }
/*N*/         else
/*N*/             DELETEZ( pMedium );
/*N*/     }
/*N*/     else if ( xDoc.Is() )
/*N*/     {
/*?*/         if( pMedium )
/*?*/             pMedium->SetLoadEnvironment( NULL );
/*?*/ 
/*?*/         xDoc->ResetError();
/*?*/     }
/*?*/     else if ( bIsApi )
/*?*/     {
/*?*/         // kein Doc => Warning wird zum Error
/*?*/         SbxBase::ResetError();
/*?*/         SbxBase::SetError( nError & ~ERRCODE_WARNING_MASK );
/*?*/     }
/*N*/ 
/*N*/     nError = nFatalError;
/*N*/     if ( nError )
/*N*/         eState = DONE;
/*N*/ }

}
