/*************************************************************************
 *
 *  $RCSfile: iiop.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2000/11/17 16:15:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Matthias Huetsch <matthias.huetsch@sun.com>
 *
 *
 ************************************************************************/

#ifndef __STL_USE_NEWALLOC
#define __STL_USE_NEWALLOC 1
#endif
#ifndef __UTILITY__
#include <utility>
#endif
#ifndef __MAP__
#include <map>
#endif

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _VOS_MACROS_HXX_
#include <vos/macros.hxx>
#endif

#ifndef _PROTOCOL_HXX_
#include "protocol.hxx"
#endif

#include <stdio.h>

using namespace com::sun::star::proxy;
using namespace rtl;

/*========================================================================
 *
 * OProtocolHandler internals.
 *
 *======================================================================*/
#ifndef COPYCTOR_API
#define COPYCTOR_API(C) C (const C&); C& operator= (const C&)
#endif

#define CTOHL_LSB(c) \
	(((c)[3] << 24) | ((c)[2] << 16) | \
	 ((c)[1] <<  8) | ((c)[0] <<  0)   )

#define CTOHL_MSB(c) \
	(((c)[0] << 24) | ((c)[1] << 16) | \
	 ((c)[2] <<  8) | ((c)[3] <<  0)   )

typedef NAMESPACE_STD(less)<sal_uInt32> PacketCmp;
typedef NAMESPACE_STD(map)<sal_uInt32, sal_uInt32, PacketCmp> PacketMap;

/*========================================================================
 *
 * OProtocolHandler...Impl interface.
 *
 *======================================================================*/
namespace com
{
namespace sun
{
namespace star
{
namespace proxy
{
namespace iiop
{

class OProtocolHandler_Impl : public IProtocolHandler
{
public:
	OProtocolHandler_Impl (const OString &rName);
	virtual ~OProtocolHandler_Impl (void);

	/** IProtocolHandler.
	 */
	virtual void init   (void);
	virtual void update (const sal_uInt8 *pData, sal_uInt32 nSize);
	virtual void final  (void);

private:
	/** MessageHeader (GIOP/1.1)
	 */
	struct MessageHeader
	{
		sal_Int8   magic_1;
		sal_Int8   magic_2;
		sal_Int8   magic_3;
		sal_Int8   magic_4;
		sal_Int8   version_major;
		sal_Int8   version_minor;
		sal_Int8   flags;
		sal_Int8   message_type;
		sal_uInt32 message_size;
	};

	/** Representation.
	 */
	OString    m_aName;
	PacketMap  m_aRequestMap;
	sal_uInt32 m_nOffset;

	/** Not implemented.
	 */
	COPYCTOR_API (OProtocolHandler_Impl);
};

class OProtocolHandlerFactory_Impl : public IProtocolHandlerFactory
{
public:
	OProtocolHandlerFactory_Impl (void);
	virtual ~OProtocolHandlerFactory_Impl (void);

	/** IProtocolHandlerFactory.
	 */
	virtual IProtocolHandler* createInstance (const OString &rName);

private:
	/** Representation.
	 */
	OUString m_aProtocol;

	/** Not implemented.
	 */
	COPYCTOR_API (OProtocolHandlerFactory_Impl);
};

} // iiop
} // proxy
} // star
} // sun
} // com

using namespace com::sun::star::proxy::iiop;

/*========================================================================
 *
 * OProtocolHandler_Impl implementation.
 *
 *======================================================================*/
/*
 * OProtocolHandler_Impl.
 */
OProtocolHandler_Impl::OProtocolHandler_Impl (const OString &rName)
	: m_aName (rName)
{
}

/*
 * ~OProtocolHandler_Impl.
 */
OProtocolHandler_Impl::~OProtocolHandler_Impl (void)
{
}

/*
 * init.
 */
void OProtocolHandler_Impl::init (void)
{
	// Request Size Histogram.
	m_aRequestMap.clear();

	// Request Offset.
	m_nOffset = 0;
}

/*
 * update.
 */
void OProtocolHandler_Impl::update (const sal_uInt8 *pData, sal_uInt32 nData)
{
	// Request Size Histogram.
	const sal_uInt8 *pStop = pData + nData;

	// Advance to next Offset.
	pData += m_nOffset;
	while (pData < pStop)
	{
		sal_uInt32 nSize = sizeof(MessageHeader);
		if ((pData + nSize) <= pStop)
		{
			const MessageHeader *head =
				SAL_REINTERPRET_CAST(const MessageHeader*, pData);
			if ((head->magic_1 == 'G') &&
				(head->magic_2 == 'I') &&
				(head->magic_3 == 'O') &&
				(head->magic_4 == 'P')    )
			{
				// Extract Request Size. Update Histogram.
				sal_uInt32 k = VOS_FIELDOFFSET(MessageHeader, message_size);
				if (head->flags)
					nSize += CTOHL_LSB(&pData[k]);
				else
					nSize += CTOHL_MSB(&pData[k]);
				m_aRequestMap[nSize] += 1;

				// Jump to next MessageHeader.
				m_nOffset = nSize;
			}
			else
			{
				// Crawl to next Byte. Find next MessageHeader.
				m_nOffset = 1;
			}
		}
		else
		{
			// Jump behind current MessageHeader. Skip this Request.
			m_nOffset = nSize;
		}

		// Advance to next Offset.
		pData += m_nOffset;
	}

	// Remember next Offset.
	m_nOffset = (pData - pStop);
}

/*
 * final.
 */
void OProtocolHandler_Impl::final (void)
{
	// Request Size Histogram.
	PacketMap::const_iterator first, last;
	first = m_aRequestMap.begin();
	last  = m_aRequestMap.end();
	if (first != last)
	{
		fprintf (
			stdout, "%s (Request Size Histogram)\n",
			m_aName.pData->buffer);

		sal_uInt32 nData = 0, nSizeG = 0, nSizeN = 0;
		for (PacketMap::const_iterator it = first; it != last; ++it)
		{
			sal_uInt32 k = (*it).first;
			sal_uInt32 n = (*it).second;
			fprintf (stdout, "%d: %d (%d, %d)\n", k, n, n * k, n * (k - 12));

			nData  += n;
			nSizeG += n * k;
			nSizeN += n * (k - 12);
		}

		fprintf (
			stdout, "%s (Request Size Histogram) (%d: %d, %d)\n",
			m_aName.pData->buffer, nData, nSizeG, nSizeN);
	}

	// ...
	fflush (stdout);
}

/*========================================================================
 *
 * OProtocolHandlerFactory_Impl implementation.
 *
 *======================================================================*/
/*
 * The single instance.
 */
static OProtocolHandlerFactory_Impl g_aFactory;

/*
 * OProtocolHandlerFactory_Impl.
 */
OProtocolHandlerFactory_Impl::OProtocolHandlerFactory_Impl (void)
	: m_aProtocol (OUString::createFromAscii ("iiop"))
{
	OProtocolHandlerRegistry::registerFactory (m_aProtocol, this);
}

/*
 * ~OProtocolHandlerFactory_Impl.
 */
OProtocolHandlerFactory_Impl::~OProtocolHandlerFactory_Impl (void)
{
	OProtocolHandlerRegistry::deregisterFactory (m_aProtocol, this);
}

/*
 * createInstance.
 */
IProtocolHandler*
OProtocolHandlerFactory_Impl::createInstance (const OString &rName)
{
	return new OProtocolHandler_Impl (rName);
}

