/*
OOOVirgHook : Hook the keyboard to fix the numerica separator key.
Copyright (C) 2002 - Rmi Peyronnet <remi.peyronnet@via.ecp.fr>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "stdafx.h"	
//#include <windows.h>
#include "OOVirgHook.h"
#include "hook.h"
#include <stdio.h>


//#pragma data_seg(".SHARED")

int hookLoaded = 0;
HOOKPROC hkprcSysMsg = NULL; 
HHOOK hhookSysMsg = NULL; 

HHOOK hookKeyboardProc = NULL;

// Parametres
const char iniFile[] = "hook.ini";

char strTitleTrigger[256] = "OpenOffice";
char strClassNameTrigger[256] = "OpenOffice";
char strExeNameTrigger[256] = "soffice.exe";

int allWindows = false;
int useTitle = true;
int useClassName = false;
int useExeName = false;

int strOnlyAtBeginning = false; 

//#pragma data_seg()
//#pragma comment(linker, "/section:.SHARED,rws")

/*

  This is the old Delphi code


Function _KeyboardProc (code : Integer; wParam : Integer; lParam : Longint) : LongInt; export; stdcall;
Var Wind : HWND;
Var Temp : ARRAY [0..255] of char;
Begin
 If (code < 0) Then _KeyboardProc := 0;
 If (wParam = VK_DECIMAL) Then
  Begin
   Wind := GetFocus;
   GetWindowText (Wind, Temp, 255);
   {Application.MessageBox (Temp,'WindowText',MB_OK);}
   Temp[10]:=#0;
   If StrComp (Temp,'StarOffice') = 0 Then
    Begin
     If (lParam And $80000000) = 0 Then
      Begin
       PostMessage(Wind, WM_CHAR, Ord(','), lParam);
      End;
     _KeyboardProc := -1;
    End
     Else
      _KeyboardProc := 0;
  End
   Else _Keyboardproc :=0;
End;

*/

void readSettings()
{
	allWindows = GetPrivateProfileInt("Config", "allWindows", 0, iniFile);
	
	useTitle = GetPrivateProfileInt("Config", "useTitle", 1, iniFile);
	useClassName = GetPrivateProfileInt("Config", "useClassName", 0, iniFile);
	useExeName = GetPrivateProfileInt("Config", "useExeName", 0, iniFile);

	GetPrivateProfileString("Config","strClassNameTrigger", "OpenOffice", strClassNameTrigger, 255, iniFile);
	GetPrivateProfileString("Config","strExeNameTrigger", "soffice.exe", strExeNameTrigger, 255, iniFile);
	GetPrivateProfileString("Config","strTitleTrigger", "OpenOffice", strTitleTrigger, 255, iniFile);
}

void saveSettings()
{
}


int strCompare(char * trigger, char * str)
{
	if (strOnlyAtBeginning)
	{
		if (strncmp(str, trigger, strlen(trigger)) == 0) return true;
	}
	else
	{
		if (strstr(str, trigger) != NULL) return true;
	}
	return false;
}

LRESULT CALLBACK KeyboardProc(int nCode, WPARAM wParam, LPARAM lParam) 
{ 
 
	// Test if we process the message
    if (! (nCode < 0)) 
	{
		// Test if it is VK_DECIMAL and KeyDown
		if (wParam == VK_DECIMAL) 
		{
			HWND theWnd;
			theWnd = GetFocus();

			// Detect if this is the appropriate window
			int process = 0;


			if (!allWindows)
			{
				char tempStr[256];
				// Class Name method
				if (useClassName)
				{
					GetClassName(theWnd, tempStr, 255);
					if (strCompare(strClassNameTrigger, tempStr))
						process += 1;
					else
						process -= 10;
				}
				// Exe Name method
				if (useExeName)
				{
					GetWindowModuleFileName(theWnd, tempStr, 255);
					if (strCompare(strExeNameTrigger, tempStr))
						process += 1;
					else
						process -= 10;
				}
				// Title method
				if (useTitle)
				{
					GetWindowText(theWnd, tempStr, 255);
					if (strCompare(strTitleTrigger, tempStr))
						process += 1;
					else
						process -= 10;
				}
			}
			else
			{
				// We do process all the windows
				process = 1;
			}

			// Process the key
			if (process > 0)
			{
				if ((lParam &  0x80000000) == 0) //// Grrrr KF_UP does not work !!!
				{
					PostMessage(theWnd, WM_CHAR, ',', lParam);
				}
				return true;
			}
		}
	}
    return false; // CallNextHookEx(hookKeyboardProc, nCode, wParam, lParam); 
} 

/*

//  These functions register/unregister the hook. 
//  - for a global hook, the function must be in a standalone dll, and registered from outside
//  - for a local hook, the function can be in the same module, and registered locally

void registerHook()
{
	if (!hookLoaded)
	{
		hkprcSysMsg = (HOOKPROC)KeyboardProc; 
		hhookSysMsg = SetWindowsHookEx(WH_KEYBOARD,  hkprcSysMsg, (HINSTANCE) hModule, 0); 
		hookKeyboardProc = hhookSysMsg;
	}
	hookLoaded++;
}

void unregisterHook()
{
	if (hookLoaded > 0)
	{
		hookLoaded--;
		if (!hookLoaded)
		{
			UnhookWindowsHookEx(hhookSysMsg);
			hkprcSysMsg = NULL;
		}
	}
}
*/