/*************************************************************************
 *
 *  $RCSfile: rmdrgsrc.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: obr $ $Date: 2001/07/13 07:05:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _RMDRGSRC_HXX_
#define _RMDRGSRC_HXX_

#ifndef _SV_RMEVENTS_HXX
#include <rmevents.hxx>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_DND_XDRAGSOURCE_HPP_
#include <com/sun/star/datatransfer/dnd/XDragSource.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_DND_XDRAGSOURCECONTEXT_HPP_
#include <com/sun/star/datatransfer/dnd/XDragSourceContext.hpp>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_DND_XDROPTARGET_HPP_
#include <com/sun/star/datatransfer/dnd/XDropTarget.hpp>
#endif

#ifndef _CPPUHELPER_COMPBASE2_HXX_
#include <cppuhelper/compbase2.hxx>
#endif

#ifndef _VCL_POINTR_HXX
#include <pointr.hxx>
#endif

typedef void (SAL_CALL ::com::sun::star::datatransfer::dnd::XDragSourceListener:: *dragNotification)( const ::com::sun::star::datatransfer::dnd::DragSourceDragEvent& dsde );

class Window;


class RmDragSource : public ::cppu::WeakComponentImplHelper2< 
	::com::sun::star::datatransfer::dnd::XDragSource,
	::com::sun::star::datatransfer::dnd::XDragSourceContext >
{
	::osl::Mutex m_aMutex;
    
    sal_Int8 m_nSourceActions;
    sal_Int8 m_nDropAction;
    sal_Int8 m_nUserAction;
    sal_Int16 m_nMouseButton;

    Window *m_pFrameWindow;
    Pointer m_aDragPointer;

//    sal_Int16 m_nMouseButtons;


    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable > m_xTransferable;
    ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSourceListener > m_xDragSourceListener;

    class RmDropTargetContext : public ::cppu::WeakImplHelper2< 
        ::com::sun::star::datatransfer::dnd::XDropTargetDragContext,
    	::com::sun::star::datatransfer::dnd::XDropTargetDropContext >
    {
        sal_Int8 m_nUserAction;
        sal_Int8 m_nDropAction;
        
        dragNotification m_pfnNotification;

        ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSource > m_xDragSource;
        ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSourceListener > m_xDragSourceListener;
    
    public:
        
        RmDropTargetContext( const ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSource >& source,
            const ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSourceListener >& listener,
            sal_Int8 userAction, 
            dragNotification notification );
            
        virtual ~RmDropTargetContext();
        
   	    /*
	     * XDropTargetDragContext
	     */

        virtual void SAL_CALL acceptDrag( sal_Int8 dragOperation ) throw (::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL rejectDrag(  ) throw (::com::sun::star::uno::RuntimeException);

	    /*
	     * XDropTargetDropContext
	     */

        virtual void SAL_CALL acceptDrop( sal_Int8 dragOperation ) throw (::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL rejectDrop(  ) throw (::com::sun::star::uno::RuntimeException);
        virtual void SAL_CALL dropComplete( sal_Bool success ) throw (::com::sun::star::uno::RuntimeException);
    };


    sal_Int8 getDropAction( USHORT nKeyCode );

public:

    RmDragSource();
    virtual ~RmDragSource();
    
    sal_Bool handleRemoteEvent( ExtRmEvent* );
    void dragDropEnd();
    void updateDropAction( sal_Int8 dropAction );
    
    /*
     * XDragSourceContext
     */

    virtual sal_Int32 SAL_CALL getCurrentCursor(  ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setCursor( sal_Int32 cursorId ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setImage( sal_Int32 imageId ) throw (::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL transferablesFlavorsChanged(  ) throw (::com::sun::star::uno::RuntimeException);

    /*
     * XDragSource
     */
     
    virtual sal_Bool SAL_CALL isDragImageSupported(  ) throw (::com::sun::star::uno::RuntimeException);
    virtual sal_Int32 SAL_CALL getDefaultCursor( sal_Int8 dragAction ) throw (::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL startDrag( const ::com::sun::star::datatransfer::dnd::DragGestureEvent& trigger, sal_Int8 sourceActions, sal_Int32 cursor, sal_Int32 image, const ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::XTransferable >& trans, const ::com::sun::star::uno::Reference< ::com::sun::star::datatransfer::dnd::XDragSourceListener >& listener ) throw (::com::sun::star::uno::RuntimeException);
};


//==================================================================================================
// 
//==================================================================================================

#endif
