/*************************************************************************
 *
 *  $RCSfile: rmdrgsrc.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 17:58:16 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include<rmdrgsrc.hxx>

#ifndef _RMDRPTGT_HXX_
#include <rmdrptgt.hxx>
#endif

#ifndef _COM_SUN_STAR_DATATRANSFER_DND_DNDCONSTANTS_HPP_
#include <com/sun/star/datatransfer/dnd/DNDConstants.hpp>
#endif

#ifndef _COM_SUN_STAR_AWT_MOUSEEVENT_HPP_
#include <com/sun/star/awt/MouseEvent.hpp>
#endif

#include <rmwindow.hxx>
#include <window.hxx>
#include <window.h>

using namespace ::cppu;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::datatransfer;
using namespace ::com::sun::star::datatransfer::dnd;

using ::com::sun::star::lang::IllegalArgumentException;

using ::osl::MutexGuard;
using ::osl::ClearableMutexGuard;

//==================================================================================================
// RmDragSource::RmDragSource
//==================================================================================================

RmDragSource::RmDragSource() : m_aMutex(), 
    WeakComponentImplHelper2< XDragSource, XDragSourceContext > ( m_aMutex )
{
    m_pFrameWindow = NULL;
}

//==================================================================================================
// RmDragSource::~RmDragSource
//==================================================================================================

RmDragSource::~RmDragSource()
{
}

//==================================================================================================
// RmDragSource::getCurrentCursor
//==================================================================================================

sal_Int32 SAL_CALL RmDragSource::getCurrentCursor(  ) 
    throw (RuntimeException)
{
    // FIXME
    return 0;
}

//==================================================================================================
// RmDragSource::setCursor
//==================================================================================================

void SAL_CALL RmDragSource::setCursor( sal_Int32 cursorId ) 
    throw (RuntimeException)
{
    // FIXME
}

//==================================================================================================
// RmDragSource::setImage
//==================================================================================================

void SAL_CALL RmDragSource::setImage( sal_Int32 imageId ) 
    throw (RuntimeException)
{
    // drag image is not supported
}

//==================================================================================================
// RmDragSource::transferablesFlavorsChanged
//==================================================================================================

void SAL_CALL RmDragSource::transferablesFlavorsChanged(  ) 
    throw (RuntimeException)
{
    // nothing to do here
}

//==================================================================================================
// RmDragSource::isDragImageSupported
//==================================================================================================

sal_Bool SAL_CALL RmDragSource::isDragImageSupported(  ) 
    throw (RuntimeException)
{
    return sal_False;
}

//==================================================================================================
// RmDragSource::getDefaultCursor
//==================================================================================================

sal_Int32 SAL_CALL RmDragSource::getDefaultCursor( sal_Int8 dragAction ) 
    throw (IllegalArgumentException, RuntimeException)
{
    sal_Int32 nRet = POINTER_NOTALLOWED;

    if( dragAction & DNDConstants::ACTION_MOVE )
        nRet = POINTER_MOVEDATA;
    else if( dragAction & DNDConstants::ACTION_COPY )
        nRet = POINTER_COPYDATA;
    else if( dragAction & DNDConstants::ACTION_LINK )
        nRet = POINTER_LINKDATA;

    return nRet;
}

//==================================================================================================
// RmDragSource::startDrag
//==================================================================================================

void SAL_CALL RmDragSource::startDrag( const DragGestureEvent& trigger, sal_Int8 sourceActions, sal_Int32 cursor, sal_Int32 image, const Reference< XTransferable >& trans, const Reference< XDragSourceListener >& listener ) 
    throw (RuntimeException)
{
    ClearableMutexGuard aGuard( m_aMutex );
    
    // check if drag is already running
    if( m_xDragSourceListener.is() )
    {
        aGuard.clear();
        
        // this is internal drag and drop, so no runtime exception can be thrown
        listener->dragDropEnd( DragSourceDropEvent( 
            static_cast < XDragSource * > (this), 
            static_cast < XDragSourceContext * > (this), 
            static_cast < XDragSource * > (this), 
            DNDConstants::ACTION_NONE, 
            sal_False ) );
            
        return;
    }
    
    m_xTransferable = trans;
    m_nSourceActions = sourceActions;
    m_xDragSourceListener = listener;

    m_nUserAction = DNDConstants::ACTION_NONE;
    m_nDropAction = DNDConstants::ACTION_NONE;

    ::com::sun::star::awt::MouseEvent aMouseEvent;

    // !! svtools transfer helper does not pass mouse event in !!
    if( trigger.Event >>= aMouseEvent )
        m_nMouseButton = aMouseEvent.Buttons;
    else
        m_nMouseButton = MOUSE_LEFT;
}

//==================================================================================================
// RmDragSource::handleRemoteEvent
//==================================================================================================

sal_Bool RmDragSource::handleRemoteEvent( ExtRmEvent* pEvent )
{
    if( ! pEvent->GetWindow() )
        return sal_False;

    ImplFrameData * pDropTargetFrameData = pEvent->GetWindow()->ImplGetFrameData();
    ImplFrameData * pDragEnterFrameData = NULL;
    Window * pDragExitWindow = NULL;

    Point  aMousePos;

    ClearableMutexGuard aGuard(m_aMutex);
    
    // check if in drag and drop mode
    if( ! m_xDragSourceListener.is() )
        return sal_False;

    // add a local reference on members to be able to release the mutex safely
    Reference< XTransferable > xTransferable( m_xTransferable );
    Reference< XDragSourceListener > xDragSourceListener( m_xDragSourceListener );

    sal_Bool bRet = sal_True;
    sal_Bool bDrop = sal_False;
    sal_Bool bDragEnter = sal_False;
    sal_Bool bDragOver = sal_False;
    sal_Bool bDragCancel = sal_False;
    sal_Bool bDropActionChanged = sal_False;
    
    // determine drop action from keyboard status
    sal_Int8 nUserAction = DNDConstants::ACTION_NONE;

    switch( pEvent->GetId() )
    {
        case RMEVENT_MOUSEBUTTONUP:

            if( pDropTargetFrameData->mxDropTarget.is() )
            {
                RmMouseEventData *pData = reinterpret_cast < RmMouseEventData * > ( pEvent->GetData() );

                // check the mouse button that has been released
                if( m_nMouseButton != ( pData->nCode & ( MOUSE_LEFT | MOUSE_RIGHT | MOUSE_MIDDLE ) ) )
                    return sal_True;

                aMousePos.setX( pData->nX );
                aMousePos.setY( pData->nY );

                nUserAction = getDropAction( pData->nCode );
                bDrop = sal_True;
            }
            else
            {
                bDragCancel = sal_True;
                bRet = sal_False;
            }

            break;
            
        case RMEVENT_MOUSEMOVE:

            if( pDropTargetFrameData->mxDropTarget.is() )
            {
                RmMouseEventData *pData = reinterpret_cast < RmMouseEventData * > ( pEvent->GetData() );

                // continue drag and drop only if mouse button still pressed
                if( ( pData->nMode & MOUSE_ENTERWINDOW ) && ! ( pData->nCode & m_nMouseButton ) )
                {
                    bDragCancel = sal_True;
                    bRet = sal_False;
                }
                else
                {
                    aMousePos.setX( pData->nX );
                    aMousePos.setY( pData->nY );

                    nUserAction = getDropAction( pData->nCode );
                    bDragOver = sal_True;
                }

                // stolen from winproc.cxx
                if ( pEvent->GetWindow()->ImplGetFrame() )
                    pEvent->GetWindow()->ImplGetFrame()->MouseMoveProcessed();
            }
            else
            {
                bDragCancel = sal_True;
                bRet = sal_False;
            }

            break;

        case RMEVENT_MOUSEBUTTONDOWN:
            // ignore mouse button events while in drag and drop mode
            return sal_True;

        case RMEVENT_KEYINPUT:
            {
                RmKeyEventData* pData = (RmKeyEventData*) pEvent->GetData();

                // cancel drag and drop if escape pressed
                if( KEY_ESCAPE == pData->nKeyCode )
                {
                    bRet = sal_False;
                    bDragCancel = sal_True;
                }
                else 
                    return sal_False;
            }

            break;

//        case RMEVENT_KEYUP:
//            bRet = sal_False;
//            break;


        case RMEVENT_CLOSE:

            if( pEvent->GetWindow() == m_pFrameWindow )
            {
                bRet = sal_False;
                bDragCancel = sal_True;
            }
            else
                return sal_False;

        default:
            return sal_False;
    }

    if( ! bDragCancel )
    {
        // remember the new drop target to be able to send the correct enter/exit notifications
        if( pEvent->GetWindow() != m_pFrameWindow )
        {
            // old target frame should receive exit notifcation
            if( m_pFrameWindow )
                pDragExitWindow = m_pFrameWindow;

            m_pFrameWindow = pEvent->GetWindow();
        
            if( m_pFrameWindow )
                bDragEnter = sal_True;
        }

        // modifier keys changed ?
        if( m_nUserAction != nUserAction )
        {
            m_nUserAction = nUserAction;
            bDropActionChanged = sal_True;
        }
    }

    aGuard.clear();

    // cancel any further notifications
    if( bDragCancel )
    {
        dragDropEnd();

        // this is internal drag and drop, so no runtime exception can be thrown
        xDragSourceListener->dragDropEnd( DragSourceDropEvent( 
            static_cast < XDragSource * > (this), 
            static_cast < XDragSourceContext * > (this), 
            static_cast < XDragSource * > (this), 
            DNDConstants::ACTION_NONE, 
            sal_False ) );

        return bRet;
    }

    // tell the old target frame that it can clean up its data
    if( pDragExitWindow )
    {
        pDragExitWindow->ImplGetFrame()->EnableDragMode( FALSE );

        ImplFrameData *pDragExitFrameData = pDragExitWindow->ImplGetFrameData();

        if( pDragExitFrameData->mxDropTarget.is() )
        {
            static_cast < RmDropTarget * > ( pDragExitFrameData->mxDropTarget.get() )->fireDragExitEvent();

            // notify the source listener that the target has changed
            xDragSourceListener->dragExit( DragSourceEvent( 
                static_cast < XDragSource * > (this), 
                static_cast < XDragSourceContext * > (this), 
                static_cast < XDragSource * > (this) ) );
        }
    }
    
    // send dragEnter notification
    if( bDragEnter )
    {
        RmFrameWindow * pFrame =  pEvent->GetWindow()->ImplGetFrame();
        if( pFrame )
        {
            pFrame->SetDragPointer( (USHORT) getDefaultCursor( DNDConstants::ACTION_NONE ) );
            pFrame->EnableDragMode( TRUE );
        }

        // send dragEnter notification
        static_cast < RmDropTarget * > ( pDropTargetFrameData->mxDropTarget.get() )->fireDragEnterEvent( 
            static_cast < XDropTargetDragContext * > ( 
                new RmDropTargetContext( this, xDragSourceListener, nUserAction,
                    &XDragSourceListener::dragEnter ) 
            ),
            nUserAction,
            aMousePos.X(),
            aMousePos.Y(),
            m_nSourceActions,
            xTransferable->getTransferDataFlavors()
        );
    }

    // send a dropActionChanged notification
    if( bDropActionChanged )
    {
        // send the drop target frame a drag over message
        static_cast < RmDropTarget * > ( pDropTargetFrameData->mxDropTarget.get() )->fireDropActionChangedEvent( 
            static_cast < XDropTargetDragContext * > ( 
                new RmDropTargetContext( this, xDragSourceListener, nUserAction,
                    &XDragSourceListener::dropActionChanged ) 
            ),
            nUserAction,
            aMousePos.X(),
            aMousePos.Y(),
            m_nSourceActions
        );
    }

    // send a dragOver notification
    if( bDragOver  )
    {

        // send the drop target frame a drag over message
        static_cast < RmDropTarget * > ( pDropTargetFrameData->mxDropTarget.get() )->fireDragOverEvent( 
            static_cast < XDropTargetDragContext * > ( 
                new RmDropTargetContext( this, xDragSourceListener, nUserAction,
                    &XDragSourceListener::dragOver ) 
            ),
            nUserAction,
            aMousePos.X(),
            aMousePos.Y(),
            m_nSourceActions
        );
    }


    // send a drop notification
    if( bDrop )
    {
        dragDropEnd();

        // execute drop operation
        static_cast < RmDropTarget * > ( pDropTargetFrameData->mxDropTarget.get() )->fireDropEvent( 
            static_cast < XDropTargetDropContext * > ( 
                new RmDropTargetContext( this, xDragSourceListener, nUserAction, NULL ) 
            ),
            nUserAction,
            aMousePos.X(),
            aMousePos.Y(),
            m_nSourceActions,
            xTransferable
        );
    }

    return bRet;
}


//==================================================================================================
// RmDragSource::getDropAction
//==================================================================================================

sal_Int8 RmDragSource::getDropAction( USHORT nKeyCode )
{
    USHORT nModifierState = nKeyCode & (KEY_SHIFT | KEY_MOD1 | KEY_MOD2);

    // determine drop action from keyboard status
    sal_Int8 nDropAction = DNDConstants::ACTION_NONE;

    // shift key pressed -> move
    if( nModifierState == KEY_SHIFT )
        nDropAction = DNDConstants::ACTION_MOVE;

    // ctrl key pressed -> copy
    else if( nModifierState == KEY_MOD1 )
        nDropAction = DNDConstants::ACTION_COPY;

    // alt key pressed -> link
    else if( ( nModifierState == ( KEY_SHIFT | KEY_MOD1 ) ) || ( nModifierState == KEY_MOD2 ) )
        nDropAction = DNDConstants::ACTION_LINK;

    // no keys pressed - query source actions
    else if( m_nSourceActions & DNDConstants::ACTION_MOVE )
        nDropAction = ( DNDConstants::ACTION_MOVE | DNDConstants::ACTION_DEFAULT );

    else if( m_nSourceActions & DNDConstants::ACTION_COPY )
        nDropAction = ( DNDConstants::ACTION_COPY | DNDConstants::ACTION_DEFAULT );

    else if( m_nSourceActions & DNDConstants::ACTION_LINK )
        nDropAction = ( DNDConstants::ACTION_LINK | DNDConstants::ACTION_DEFAULT );

    return nDropAction;
}

//==================================================================================================
// RmDragSource::updateDropAction
//==================================================================================================

void RmDragSource::updateDropAction( sal_Int8 dropAction )
{
    if( m_nDropAction != dropAction )
    {
        MutexGuard aGuard(m_aMutex);

        m_nDropAction = dropAction;

        if( m_pFrameWindow )
            m_pFrameWindow->ImplGetFrame()->SetDragPointer( (USHORT) getDefaultCursor( dropAction ) );
    }
}

//==================================================================================================
// RmDragSource::dragDropEnd
//==================================================================================================

void RmDragSource::dragDropEnd()
{
    MutexGuard aGuard(m_aMutex);

    if( m_pFrameWindow )
        m_pFrameWindow->ImplGetFrame()->EnableDragMode( FALSE );

    // drag operation is finished
    m_xDragSourceListener.clear();
    m_xTransferable.clear();
    m_pFrameWindow = NULL;
}

//==================================================================================================
// RmDragSource::RmDropTargetContext::RmDropTargetContext
//==================================================================================================

RmDragSource::RmDropTargetContext::RmDropTargetContext( 
    const Reference< XDragSource >& source,  
    const Reference< XDragSourceListener >& listener,
    sal_Int8 userAction, 
    dragNotification notification ) :
    m_xDragSource( source ),
    m_xDragSourceListener( listener ),
    m_nUserAction( userAction ),
    m_pfnNotification( notification )
{
    m_nDropAction = DNDConstants::ACTION_NONE;
}

//==================================================================================================
// RmDragSource::RmDropTargetContext::~RmDropTargetContext
//==================================================================================================
            
RmDragSource::RmDropTargetContext::~RmDropTargetContext()
{
    // if the function pointer is set, this is the time to send the notification to the drag source listener
    if( m_pfnNotification )
    {
        static_cast < RmDragSource * > ( m_xDragSource.get() )->updateDropAction( m_nDropAction );

        ( m_xDragSourceListener.get()->*m_pfnNotification )( 
            DragSourceDragEvent( 
                m_xDragSource,  
                Reference< XDragSourceContext > ( m_xDragSource, UNO_QUERY ), 
                m_xDragSource,
                m_nDropAction, 
                m_nUserAction ) );
    }
}

//==================================================================================================
// RmDragSource::RmDropTargetContext::acceptDrag
//==================================================================================================

void SAL_CALL RmDragSource::RmDropTargetContext::acceptDrag( sal_Int8 dragOperation ) 
    throw (RuntimeException)
{
    m_nDropAction = dragOperation;
}

//==================================================================================================
// RmDragSource::RmDropTargetContext::rejectDrag
//==================================================================================================

void SAL_CALL RmDragSource::RmDropTargetContext::rejectDrag(  ) 
    throw (RuntimeException)
{
}

//==================================================================================================
// RmDragSource::RmDropTargetContext::acceptDrop
//==================================================================================================

void SAL_CALL RmDragSource::RmDropTargetContext::acceptDrop( sal_Int8 dragOperation )
     throw (RuntimeException)
{
    m_nDropAction = dragOperation;
}

//==================================================================================================
// RmDragSource::RmDropTargetContext::rejectDrag
//==================================================================================================

void SAL_CALL RmDragSource::RmDropTargetContext::rejectDrop(  ) 
    throw (RuntimeException)
{
}

//==================================================================================================
// RmDragSource::RmDropTargetContext::dropComplete
//==================================================================================================

void SAL_CALL RmDragSource::RmDropTargetContext::dropComplete( sal_Bool success ) 
    throw (RuntimeException)
{
    m_xDragSourceListener->dragDropEnd( 
        DragSourceDropEvent( 
            m_xDragSource, 
            Reference< XDragSourceContext > ( m_xDragSource, UNO_QUERY ),
            m_xDragSource, 
            m_nDropAction, 
            success ) );
}