/*************************************************************************
 *
 *  $RCSfile: ooffice.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: pl $ $Date: 2001/12/19 14:55:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "rmprint.hxx"
#include <rversion.h>
#include <outdev.h>
#include <svdata.hxx>
#include <svapp.hxx>
#include <wrkwin.hxx>
#include <unowrap.hxx>
#include <tools/debug.hxx>
#include <vos/conditn.hxx>
#include <vos/timer.hxx>
#include "ooffice.hxx"
#include <unotools/atom.hxx>
#include <rversion.h>
#include <print.hxx> // for QueueInfo


#include <com/sun/star/portal/client/StarOfficeServerType.hpp>
#include <com/sun/star/portal/client/_StartUpError.hpp>

using namespace com::sun::star::uno;
using namespace com::sun::star::lang;
using namespace com::sun::star::portal::client;
using namespace rtl;

// -----------
// - Statics -
// -----------

static WorkWindow*	pDummyWorkWindow = NULL;
BOOL				CORmStarOffice::m_isStarOneServer = FALSE;
BOOL				CORmStarOffice::m_isBeanServer = FALSE;
BOOL				CORmStarOffice::m_isStarted = FALSE;


// --------------
// - Prototypes -
// --------------

void									createRemoteBitmapCache( const Sequence< Any >& );
void									createRemoteWindowCache( const Sequence< Any >& );
void									createRemoteVirdevCache( const Sequence< Any >& );
void									createRemoteSoundCache( const Sequence< Any >& );
void									eraseRemoteBitmapCache();
void									eraseRemoteWindowCache();
void									eraseRemoteVirdevCache();
void									eraseRemoteSoundCache();
::vos::OThreadData*						getThreadLocalEnvironment();
WorkWindow*								getDummyWorkWindow() { return pDummyWorkWindow;	}	

// -------------
// - Functions -
// -------------

void CORmStarOffice::eraseRemoteCaches()
{
	eraseRemoteSoundCache();
	eraseRemoteBitmapCache();
	eraseRemoteWindowCache();
	eraseRemoteVirdevCache();
}

static void ImplInitAppFontData( Window* pWindow )
{
	ImplSVData* pSVData = ImplGetSVData();
	Size aSize( pWindow->GetTextWidth( String( RTL_CONSTASCII_USTRINGPARAM( "aemnnxEM" ) ) ), pWindow->GetTextHeight() );
	long nSymHeight = aSize.Height()*4;
	// Falls Font zu schmal ist, machen wir die Basis breiter,
	// damit die Dialoge symetrisch aussehen und nicht zu schmal
	// werden. Wenn der Dialog die gleiche breite hat, geben wir
	// noch etwas Spielraum dazu, da etwas mehr Platz besser ist.
	if ( nSymHeight > aSize.Width() )
		aSize.Width() = nSymHeight;
	else if ( nSymHeight+5 > aSize.Width() )
		aSize.Width() = nSymHeight+5;
	pSVData->maGDIData.mnAppFontX = aSize.Width() * 10 / 8;
	pSVData->maGDIData.mnAppFontY = aSize.Height() * 10;

	if ( pSVData->maAppData.mnDialogScaleX )
		pSVData->maGDIData.mnAppFontX += (pSVData->maGDIData.mnAppFontX*pSVData->maAppData.mnDialogScaleX)/100;
}

// ------------------
// - CORmStarOffice -
// ------------------

CORmStarOffice::CORmStarOffice() 
{
}

// -----------------------------------------------------------------------------

CORmStarOffice::~CORmStarOffice()
{
}

// -----------------------------------------------------------------------------

StartUpError SAL_CALL
CORmStarOffice::Start( const StartupData& aStartupData ) throw()
{
	StartUpError eRet;

    ImplSVData* pSVData = ImplGetSVData();
	if( !m_isStarted )
	{	
		pSVData->mxClientFactory = aStartupData.xClientFactory;
		pSVData->mxMultiFactory  = aStartupData.xMultiClientFactory;

		// init references
		pSVData->mpRVPNormalSync		= new RVPSync( aStartupData.xRVPSyncNormal );
		pSVData->mpRVPSoundSync			= new RVPSync( aStartupData.xRVPSyncSound );
		pSVData->mxStatus				= aStartupData.xClientStatus;
		pSVData->mpAtoms				= new ::utl::AtomClient( aStartupData.xClientAtoms );
		pSVData->mnRemoteVersion		= aStartupData.nRemoteVersion;
		
		// init client printer infos
        *pSVData->mpPrinterEnvironment	= aStartupData.aPrinterEnvironment;
        pSVData->mxRmPrinterEnvironment	= aStartupData.xClientPrinterEnvironment;

		// create the remote caches
		createRemoteBitmapCache( aStartupData.aBitmapInterfaceSeq );
		createRemoteWindowCache( aStartupData.aWindowInterfaceSeq );
		createRemoteVirdevCache( aStartupData.aVirtualDeviceInterfaceSeq );

		// init work area
		pSVData->maWorkArea.SetEmpty();

		m_isStarted = TRUE;

		switch( aStartupData.aStarOfficeServerType )
		{
			case StarOfficeServerType::APPSERVER:
			{
				if( !pDummyWorkWindow )
					pDummyWorkWindow = pSVData->maWinData.mpAppWin;
			}
			break;
			case StarOfficeServerType::BEANSERVER:
			{
				m_isBeanServer = TRUE;
			}
			break;
			case StarOfficeServerType::ONESERVER:
			{
				Application::EnableDialogCancel( TRUE );
				m_isStarOneServer = TRUE;
			}
			break;
		}

		if( pSVData->mpStartUpCond )
			pSVData->mpStartUpCond->set();
		
		if ( aStartupData.nRemoteVersion == REMOTE_VCLVERSION )
			eRet = _StartUpError_SOFFICE_NO_ERROR;
		else
			eRet = _StartUpError_SOFFICE_WRONG_CLIENT_VERSION;
	}
	else
		eRet = _StartUpError_SOFFICE_ALREADY_STARTED;

    CHECK_FOR_RVPSYNC_NORMAL();
    try
    {
        pSVData->mxRmPrinterEnvironment->SetObserver( new ORmPrinterObserver() );
    }
    catch( RuntimeException &e )
    {
        rvpExceptionHandler();
    }

	return eRet;
}

// -----------------------------------------------------------------------------

REF( XInterface ) CORmStarOffice::CreateBeanWindow( const REF( XRmFrameWindow )& rxFrameWin, 
                                                    const REF( XMultiServiceFactory )& rxFactory,
                                                    const Any& aSystemWindowToken ) throw()
{
	REF( XInterface ) xRet;

	if( m_isBeanServer || m_isStarOneServer )
	{
		ImplSVData* pSVData = ImplGetSVData();

		Application::EnableDialogCancel(FALSE);
		
		// ts vorerst gehackt:
		// die ClientFactory wird sich weiterhin global gemerkt
		// und nicht an jedem BeanWindow
		// d.h. createBeanWindow laesst sich nur einmal aufrufen !!!!

		if( !pSVData->mxClientFactory.is() )
		{
			pSVData->mxClientFactory = rxFactory;

			if( rxFactory.is() )
			{
				const REF( NMSP_CLIENT::XMultiInstanceFactory ) xMultiFactory( rxFactory, UNO_QUERY );

				if( xMultiFactory.is() )
					pSVData->mxMultiFactory = xMultiFactory;
			}

			eraseRemoteCaches();
		}
		else if( !m_isStarted )
		{
			pSVData->mxClientFactory = rxFactory;

			if( rxFactory.is() )
			{
				const REF( NMSP_CLIENT::XMultiInstanceFactory ) xMultiFactory( rxFactory, UNO_QUERY );

				if( xMultiFactory.is() )
					pSVData->mxMultiFactory = xMultiFactory;
			}

			eraseRemoteCaches();
		}
		else if( m_isStarOneServer )
		{
			m_isStarOneServer = FALSE;
			
			pSVData->mxClientFactory = rxFactory;

			if( rxFactory.is() )
			{
				const REF( NMSP_CLIENT::XMultiInstanceFactory ) xMultiFactory( rxFactory, UNO_QUERY );

				if( xMultiFactory.is() )
					pSVData->mxMultiFactory = xMultiFactory;
			}

			eraseRemoteCaches();
		}


		UnoWrapperBase* pWrapper = Application::GetUnoWrapper();
		
		if( pWrapper ) 
		{			
			WorkWindow* pWindow = new WorkWindow( (Window*) NULL, aSystemWindowToken, WB_STDWORK );

			if( !pDummyWorkWindow )
				pDummyWorkWindow = pSVData->maWinData.mpAppWin;

			{
				::vos::OGuard guard( pSVData->maAppData.mpSolarMutex );
				pSVData->maWinData.mpAppWin = pWindow;
				OutputDevice::ImplUpdateAllFontData( TRUE );
				ImplInitAppFontData(pWindow);
			}

			xRet = pWrapper->GetWindowInterface( pWindow , sal_True );
			pWindow->Show();
		}

		if( !m_isStarted )
		{
			//Initialisierung des RemoteFSys-Singletons und der RemoteFileStream-Factory fuer das RFS (remote file system)
//  			RemoteFSys::createInstance( pSVData->mpXFactory );
//  			RemoteFileStreamFactory::buildFactory( pSVData->mpXFactory );
			m_isStarted = TRUE;
			if (pSVData->mpStartUpCond)
				pSVData->mpStartUpCond->set();
		}
	}

	return xRet;
}

// -----------------------------------------------------------------------------

void CORmStarOffice::resetState()
{
	if( m_isBeanServer )
	{
		m_isBeanServer = FALSE;		
		m_isStarted = TRUE;
		m_isStarOneServer = TRUE;
	}
}	
