/*************************************************************************
 *
 *  $RCSfile: salmain.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>

#define INCL_DOSEXCEPTIONS
#include <tools\svpm.h>

#define _SV_SALMAIN_CXX

#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif
#ifndef _SV_SALINST_HXX
#include <salinst.hxx>
#endif

// =======================================================================

// liegt in OSL
PM_ULONG APIENTRY SignalHandlerFunction( PEXCEPTIONREPORTRECORD pERepRec,
										 PEXCEPTIONREGISTRATIONRECORD,
										 PCONTEXTRECORD, PVOID );

// =======================================================================

#ifdef __cplusplus
extern "C" {
#endif

typedef char* SAL_PCHAR;

int main( int argc, char* argv[] )
{
	HAB hAB;
	HMQ hMQ;
	SalData* pData = GetAppSalData();

	// Wir wollen mehr File-Handles, da unsere Resourcen und Dokumente
	// alle geoeffnet bleiben.
	// In einer Nicht-Produkt-Version nehmen wir weniger, damit
	// evt. Fehler gefunden werden, wenn wir vergessen ein File
	// zu schliessen
	PM_ULONG	nCurMaxFH;
	long		nAddFH;
#ifdef DBG_UTIL
	nAddFH = 150;
#else
	nAddFH = 500;
#endif
	DosSetRelMaxFH( &nAddFH, &nCurMaxFH );

	// create anchor block
	hAB = WinInitialize( 0 );
	if ( !hAB )
		return 0;

	// create message queue
	hMQ = WinCreateMsgQueue( hAB, 60 );
	if ( !hMQ )
	{
		WinTerminate( hAB );
		return 0;
	}

	if ( pData ) // Im AppServer NULL
	{
		// Ankerblock und Messagequeue merken
		pData->mhAB = hAB;
		pData->mhMQ = hMQ;

		// Commandozeile merken
		pData->mnArgc = argc;
		pData->mpArgv = new SAL_PCHAR[argc];
		memcpy( pData->mpArgv, argv, argc*sizeof(char*) );
	}

	EXCEPTIONREGISTRATIONRECORD aExcptHandler = { 0, SignalHandlerFunction };
	DosSetExceptionHandler( &aExcptHandler );

	// Aufruf von StarView-Main
	SVMain();

	DosUnsetExceptionHandler( &aExcptHandler );

	// destroy message queue and anchor block
	WinDestroyMsgQueue( hMQ );
	WinTerminate( hAB );

	return 0;
}

#ifdef __cplusplus
}
#endif
