/*************************************************************************
 *
 *  $RCSfile: salvd.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#include <svmac.h>



#define _SV_SALVD_CXX



#ifndef _DEBUG_HXX

#include <tools/debug.hxx>

#endif

#ifndef _SV_SALDATA_HXX

#include <saldata.hxx>

#endif

#ifndef _SV_SALINST_HXX

#include <salinst.hxx>

#endif

#ifndef _SV_SALGDI_HXX

#include <salgdi.hxx>

#endif

#ifndef _SV_MEMORY_H

#include <SV_Memory.H>

#endif



#ifndef _SV_SALVD_HXX

#include <salvd.hxx>

#endif



// =======================================================================



static GWorldPtr ImplCreateGWorld( long nDX, long nDY, USHORT nBitCount )

{

    SalData*    pSalData = GetSalData();

	Rect		aRect;

	GWorldFlags	aFlags = 0;

	GWorldPtr	pNewWorld = 0L;



	SetRect( &aRect, 0, 0, nDX, nDY );

	if ( pSalData->mpMemData->bIsLowMem )

		aFlags = useTempMem;

	else

		aFlags = 0;

	// avoid unnescessary NewHandler call

	BOOL bOldVal = pSalData->mpMemData->bCallNewHdl;

	pSalData->mpMemData->bCallNewHdl = FALSE;

	QDErr nErr = NewGWorld( (GWorldPtr*) &pNewWorld, nBitCount, &aRect, nil, nil, aFlags );

	pSalData->mpMemData->bCallNewHdl = bOldVal;



	// second try

	if ( pNewWorld == 0L || nErr & gwFlagErr )

	{

		if ( aFlags & useTempMem )

			aFlags = 0;

		else

			aFlags = useTempMem;



		nErr = NewGWorld( (GWorldPtr*) &pNewWorld, nBitCount, &aRect, nil, nil, aFlags );

	}



	return pNewWorld;

}



// -----------------------------------------------------------------------



static void EraseVirtualDevice( GWorldPtr pNewWorld )

{

	// Setzt den GPort auf updateWin und restauriert im DTor wieder die alten Werte

	MacTempGWorld aSavedWorld( (CGrafPort*) pNewWorld );

	PenNormal();

	ForeColor( blackColor );

	BackColor( whiteColor );



	LockPixels( GetGWorldPixMap( pNewWorld ) );

	EraseRect( &pNewWorld->portRect );

	UnlockPixels( GetGWorldPixMap( pNewWorld ) );

}



// =======================================================================



SalVirtualDevice* SalInstance::CreateVirtualDevice( SalGraphics* pGraphics,

                                                    long nDX, long nDY,

                                                    USHORT nBitCount )

{

	MAC_SAL_TRACE("SalInstance::CreateVirtualDevice");

	GWorldPtr	pNewWorld = ImplCreateGWorld( nDX, nDY, nBitCount );



    if ( pNewWorld )

    {

		PixMapHandle 		hPixmap = GetGWorldPixMap( pNewWorld );

        SalVirtualDevice*   pVDev = new SalVirtualDevice;

        SalGraphics*        pVirGraphics = new SalGraphics;

		//

        pVDev->maVirDevData.mpGraphics  = pVirGraphics;

        pVDev->maVirDevData.mnBitCount  = nBitCount;

        pVDev->maVirDevData.mbGraphics  = FALSE;

		pVDev->maVirDevData.StoreGWorld( pNewWorld );

		//

        pVirGraphics->maGraphicsData.mbPrinter = FALSE;

        pVirGraphics->maGraphicsData.mbVirDev  = TRUE;

        pVirGraphics->maGraphicsData.mbWindow  = FALSE;

        pVirGraphics->maGraphicsData.mbScreen  = pGraphics->maGraphicsData.mbScreen;



		pVirGraphics->maGraphicsData.mnXRes = (**hPixmap).hRes;

		pVirGraphics->maGraphicsData.mnYRes = (**hPixmap).vRes;

		// hier fehlt noch dither kram

		

		//

        ImplSalInitGraphics( &(pVirGraphics->maGraphicsData) );

		EraseVirtualDevice( pNewWorld );



		// 

        return pVDev;

    }

	return NULL;

}



// -----------------------------------------------------------------------



void SalInstance::DestroyVirtualDevice( SalVirtualDevice* pDevice )

{

	MAC_SAL_TRACE("SalInstance::DestroyVirtualDevice");

    delete pDevice;

}



// =======================================================================



SalVirtualDevice::SalVirtualDevice()

{	// leer da 3 SalGraphics: screen, vd, prn

	MAC_SAL_TRACE("SalVirtualDevice::__ct");

}



// -----------------------------------------------------------------------

// last changed:	dv	05.12.97



SalVirtualDevice::~SalVirtualDevice()

{

	MAC_SAL_TRACE("SalVirtualDevice::__dt");

    ImplSalDeInitGraphics( &(maVirDevData.mpGraphics->maGraphicsData) );

	maVirDevData.ImplVDUnLockPixels();



	// destroy GWorld

	if ( maVirDevData.GetGWorldPtr() )

	{

		CGrafPtr	pOldPort;

		GDHandle	hOldDevice;

		CGrafPtr	pOldVirtPort;



		GetGWorld( &pOldPort, &hOldDevice );

		pOldVirtPort = maVirDevData.GetGWorldPtr();

		

		DisposeGWorld( pOldVirtPort );

		

		// Wenn das VirtualDevice identisch mit dem aktuellen GrafPort

		// ist, dann setzen wir den Port auf den WindowMgrPort

		if ( pOldVirtPort == pOldPort )

		{

			GetCWMgrPort( &pOldPort );

			SetGWorld( pOldPort, NULL );

		}

	}

    delete maVirDevData.mpGraphics;

}



// -----------------------------------------------------------------------



SalGraphics* SalVirtualDevice::GetGraphics()

{

    if ( maVirDevData.mbGraphics )

        return NULL;



    if ( maVirDevData.mpGraphics )

        maVirDevData.mbGraphics = TRUE;



    return maVirDevData.mpGraphics;

}



// -----------------------------------------------------------------------



void SalVirtualDevice::ReleaseGraphics( SalGraphics* pGraphics )

{

    maVirDevData.mbGraphics = FALSE;

}



// -----------------------------------------------------------------------

// last changed:	dv	05.12.97



BOOL SalVirtualDevice::SetSize( long nDX, long nDY )

{

	MAC_SAL_TRACE("SalVirtualDevice::SetSize");

	CGrafPtr	pOldPort;

	GDHandle	hOldDevice;

	CGrafPtr	pOldVirtPort;

	MacRect		aRect;

	BOOL		bSetCGrafPtr = FALSE;

	BOOL		bRet = FALSE;

	

	GetGWorld( &pOldPort, &hOldDevice );

	pOldVirtPort = maVirDevData.GetGWorldPtr();



	if ( pOldPort == pOldVirtPort )

		bSetCGrafPtr = TRUE;



	// delete old gworld

	if ( pOldVirtPort )

	{	

		aRect = pOldVirtPort->portRect;

	    ImplSalDeInitGraphics( &(maVirDevData.mpGraphics->maGraphicsData) );

		maVirDevData.ImplVDUnLockPixels();

		DisposeGWorld( pOldVirtPort );

		maVirDevData.ReSetGWorld();

	}



	GWorldPtr pNewWorld = ImplCreateGWorld( nDX, nDY, maVirDevData.mnBitCount );



    if ( ! pNewWorld && pOldVirtPort )

    	pNewWorld = ImplCreateGWorld( aRect.Width(), aRect.Height(), maVirDevData.mnBitCount );



    if ( pNewWorld )

    {

		maVirDevData.StoreGWorld( pNewWorld );

		ImplSalInitGraphics( &(maVirDevData.mpGraphics->maGraphicsData) );

//		maVirDevData.ImplVDLockPixels();

		bRet = TRUE;

	}

	

	if ( bRet && bSetCGrafPtr )

		maVirDevData.mpGraphics->maGraphicsData.CheckDrawMode( DRAW_SETPORT );

		

	return bRet;

}




