/*************************************************************************
 *
 *  $RCSfile: macmain.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "mac_start.h"
#include <OSUtils.h>
#include "mac_end.h"


#include <svmac.h>

#include <stdlib.h>

#include <tools/solar.h>
#include <tools/time.hxx>
#include <tools/debug.hxx>

#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif

#include "SVApp.hxx"

#ifndef _SV_SALFRAME_HXX
#include <salframe.hxx>
#endif
#ifndef _SV_KEYCOES_HXX
#include <keycodes.hxx>
#endif
#ifndef _SV_TIMER_HXX
#include <timer.hxx>
#endif

// #include <macexchg.hxx>
#include <getsys.hxx>

#include "main.h"

// =======================================================================

/*	kTopLeft - This is for positioning the Disk Initialization dialogs. */
#define kDITop					0x0050
#define kDILeft					0x0070

// =======================================================================

void DoEvent( EventRecord *pEvent );

void DoMouseMove( EventRecord *pEvent );
void DoMouseUp( EventRecord *pEvent );
void DoMouseDown( EventRecord *pEvent );
void DoKey( EventRecord *pEvent );
void DoUpdate( EventRecord *pEvent );
void DoActivate( WindowPtr pWindow, BOOL bActivate );
void DoHighLevelEvent( EventRecord *pEvent );
void DoInDrag( EventRecord *pEvent, WindowPtr pMacWin );
void DoGrowWindow( EventRecord *pEvent, WindowPtr pMacWin );
void DoMenu( long msel );
long ImplHandleFocusMsg( WindowPtr pFocusWin, USHORT nEvent );
void DoCheckColorDept();

// =======================================================================

static void DoSuspendResume( EventRecord *pEvent, BOOL becomingActive );
static void DoCloseWindow( WindowPtr pWindow );
static void ImplHandleKeyModMsg( USHORT nModCode, WindowPtr pWin );
static void DrawClippedGrowIcon( WindowPtr pMacWin );
static BOOL ImplMacDecodeModifier( EventRecord *pEvent, USHORT &nCode );

// =======================================================================

extern MAC_Point gLastMousePos; // in salinst.cxx

RgnHandle hMouseRgn = NULL;

// =======================================================================

void DoMenu( long msel )
{
	int item = LoWord(msel);
	int menu = HiWord(msel);
	int nQuitMenuPressed = MenuDispatch( menu, item );
	if ( nQuitMenuPressed )
		GetSalData()->mbEnde = TRUE;
}

// -----------------------------------------------------------------------

void DoKey( EventRecord *pEvent )
{
	static BOOL		KeyPressed = false;	// true most recent event is a keyDown event
	static char		KeyValue = 0;		// the ascii code of the most recent key down

	char c = (char)pEvent->message & charCodeMask;

	SalData*	pSalData = GetSalData();

	KeyPressed = true;
	KeyValue = c;
	WindowPtr	pFocusWin = pSalData->mpFocusWin;

	if ( pFocusWin )
	{	ImplHandleKeyMsg( pEvent, ImplGetFrameFromMacWin( pFocusWin ));
	}

	// hier wird ggfs. die Applikation beendet, wenn CMD-Q gedrueckt wurde
	if ( pEvent->modifiers & cmdKey )	// quit menu
	{
		DoMenu(MenuKey(pEvent->message & charCodeMask));
	}
}

// -----------------------------------------------------------------------

// =======================================================================

#define kModifierMask			controlKey+cmdKey+shiftKey+optionKey

// =======================================================================

// Uebersetzungstabelle von System-Keycodes in StarView-Keycodes
#define KEY_TAB_SIZE     (USHORT)128

static USHORT aImplTranslateKeyTab[KEY_TAB_SIZE] =
{
	// StarView-Code      Mac-Code                           Index
	0,                    // NUL                              0
	KEY_HOME,             // SOH(Home)                        1
	0,                    // STX                              2
	KEY_RETURN,           // ETX(NumPad Enter)                3
	KEY_END,              // EOT(End)                         4
	0,                    // ENQ                              5
	0,                    // ACK                              6
	0,                    // BEL                              7
	KEY_BACKSPACE,        // Backspace                        8
	KEY_TAB,              // HTAB                             9
	0,                    // LF                               10
	KEY_PAGEUP,           // VT (PageUp)                      11
	KEY_PAGEDOWN,         // FF (PageDown)                    12
	KEY_RETURN,           // RETURN                           13
	0,                    // SO                               14
	0,                    // SI                               15
	0,                    // DLE                              16
	0,                    // DC1                              17
	0,                    // DC2                              18
	0,                    // DC3                              19
	0,                    // DC4                              20
	0,                    // NAK                              21
	0,                    // SYN                              22
	0,                    // ETB                              23
	0,                    // CAN                              24
	0,                    // EM                               25
	0,                    // SUB                              26
	KEY_ESCAPE,           // ESCAPE                           27
	KEY_LEFT,             // LEFT ARROW                       28
	KEY_RIGHT,            // RIGHT ARROW                      29
	KEY_UP,               // UP ARROW                         30
	KEY_DOWN,             // DOWN ARROW                       31
	KEY_SPACE,            // SPACE                            32
	0,                    // !                                33
	0,                    // "                                34
	0,                    // #                                35
	0,                    // $                                36
	0,                    // %                                37
	0,                    // &                                38
	0,                    // '                                39
	0,                    // (                                40
	0,                    // )                                41
	KEY_MULTIPLY,         // *                                42
	KEY_ADD,              // +                                43
	KEY_COMMA,            // ,                                44
	KEY_SUBTRACT,         // -                                45
	KEY_POINT,            // .                                46
	KEY_DIVIDE,           // /                                47
	KEY_0,                // 0                                48
	KEY_1,                // 1                                49
	KEY_2,                // 2                                50
	KEY_3,                // 3                                51
	KEY_4,                // 4                                52
	KEY_5,                // 5                                53
	KEY_6,                // 6                                54
	KEY_7,                // 7                                55
	KEY_8,                // 8                                56
	KEY_9,                // 9                                57
	0,                    // :                                58
	0,                    // ;                                59
	KEY_LESS,             // <                                60
	KEY_EQUAL,            // =                                61
	KEY_GREATER,          // >                                62
	0,                    // ?                                63
	0,                    // KLAMMERAFFE                      64
	KEY_A,                // A                                65
	KEY_B,                // B                                66
	KEY_C,                // C                                67
	KEY_D,                // D                                68
	KEY_E,                // E                                69
	KEY_F,                // F                                70
	KEY_G,                // G                                71
	KEY_H,                // H                                72
	KEY_I,                // I                                73
	KEY_J,                // J                                74
	KEY_K,                // K                                75
	KEY_L,                // L                                76
	KEY_M,                // M                                77
	KEY_N,                // N                                78
	KEY_O,                // O                                79
	KEY_P,                // P                                80
	KEY_Q,                // Q                                81
	KEY_R,                // R                                82
	KEY_S,                // S                                83
	KEY_T,                // T                                84
	KEY_U,                // U                                85
	KEY_V,                // V                                86
	KEY_W,                // W                                87
	KEY_X,                // X                                88
	KEY_Y,                // Y                                89
	KEY_Z,                // Z                                90
	0,                    // [                                91
	0,                    // \                                92
	0,                    // ]                                93
	0,                    // ^                                94
	0,                    // _                                95
	0,                    // `                                96
	KEY_A,                // a                                97
	KEY_B,                // b                                98
	KEY_C,                // c                                99
	KEY_D,                // d                               100
	KEY_E,                // e                               101
	KEY_F,                // f                               102
	KEY_G,                // g                               103
	KEY_H,                // h                               104
	KEY_I,                // i                               105
	KEY_J,                // j                               106
	KEY_K,                // k                               107
	KEY_L,                // l                               108
	KEY_M,                // m                               109
	KEY_N,                // n                               110
	KEY_O,                // o                               111
	KEY_P,                // p                               112
	KEY_Q,                // q                               113
	KEY_R,                // r                               114
	KEY_S,                // s                               115
	KEY_T,                // t                               116
	KEY_U,                // u                               117
	KEY_V,                // v                               118
	KEY_W,                // w                               119
	KEY_X,                // x                               120
	KEY_Y,                // y                               121
	KEY_Z,                // x                               122
	0,                    // {                               123
	0,                    // |                               124
	0,                    // }                               125
	0,                    // ~                               126
	KEY_DELETE            // DEL                             127
};


static USHORT GetFKey( USHORT nMacKeyCode )
{
	switch ( nMacKeyCode ) {
		case 0x60: return KEY_F5;
		case 0x61: return KEY_F6;
		case 0x62: return KEY_F7;
		case 0x63: return KEY_F3;
		case 0x64: return KEY_F8;
		case 0x65: return KEY_F9;
		case 0x67: return KEY_F11;
		case 0x69: return KEY_F13;
		case 0x6b: return KEY_F14;
		case 0x6d: return KEY_F10;
		case 0x6f: return KEY_F12;
		case 0x71: return KEY_F15;
		case 0x76: return KEY_F4;
		case 0x78: return KEY_F2;
		case 0x7A: return KEY_F1;
	}
	return 0;
}

// 
// 
// 

// -----------------------------------------------------------------------
// last changed:	dv	03.11.97

long ImplHandleMouseMsg( EventRecord *pEvent, SalFrame* pFrame )
{
	if ( !pFrame )
		return 0L;

	static USHORT	nLastMBDown = MOUSE_LEFT;
	SalData			*pSalData = GetSalData();
	MAC_Point		aPoint = pEvent->where;
	SalMouseEvent   aMouseEvt;
	USHORT			nCode;
	USHORT          nEvent=0;

	{	// Neuer Block um temporaer den GrafPort zu setzen
		// Setzt den GPort auf updateWin und restauriert im DTor wieder die alten Werte
		MacTempGWorld aSavedWorld( (CGrafPort*) ( pFrame->maFrameData.mpMacWin ) );
		GlobalToLocal( &aPoint );
	}

	aMouseEvt.mnX       = (short)aPoint.h;
	aMouseEvt.mnY       = (short)aPoint.v;
	aMouseEvt.mnTime    = GetMilliSecsFromTicks( pEvent->when );

	BOOL bWasCtrl = ImplMacDecodeModifier( pEvent, nCode );

	aMouseEvt.mnCode = nCode;
	aMouseEvt.mnButton = 0;

	switch (pEvent->what)
	{
		case nullEvent:					// == WM_MOUSEMOVE
			DBG_ERRORFILE( "Wo kommt das Null-Event her?" );
		case osEvt:						// == WM_MOUSEMOVE
			pSalData->mpWantLeaveMsg = pFrame;
			nEvent = SALEVENT_MOUSEMOVE;
			break;
		case SAL_MSG_MOUSELEAVE:
			if ( pSalData->mpWantLeaveMsg && pSalData->mpWantLeaveMsg == pFrame )
			{
				pSalData->mpWantLeaveMsg = 0;
				nEvent = SALEVENT_MOUSELEAVE;
			}
			break;
		case mouseDown:
			if ( bWasCtrl )
				nLastMBDown = MOUSE_RIGHT;
			else
				nLastMBDown = MOUSE_LEFT;
			aMouseEvt.mnButton = nLastMBDown;
			nEvent = SALEVENT_MOUSEBUTTONDOWN;
			break;

		case mouseUp:
			aMouseEvt.mnButton = nLastMBDown;
			aMouseEvt.mnCode |= nLastMBDown;
			nLastMBDown = 0;
			nEvent = SALEVENT_MOUSEBUTTONUP;
			break;
	}// switch (pEvent->what) end

	aMouseEvt.mnCode |= nLastMBDown;

	return pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst, pFrame,
									   nEvent, &aMouseEvt );
}

// -----------------------------------------------------------------------
// last changed:	dv	12.11.97

long ImplHandleFocusMsg( WindowPtr pFocusWin, USHORT nEvent )
{
	SalData		*pSalData = GetSalData();
	SalFrame	*pFrame;

	if ( !pFocusWin ) return 0L;

	pFrame = ImplGetFrameFromMacWin( pFocusWin );

	if ( !pFrame ) return 0L;

	if ( nEvent == SALEVENT_GETFOCUS )	// Dem letzten Fokus-Fenster ein LOSEFOCUS schicken
	{
		if ( pSalData->mpFocusWin )
		{
			SalFrame	*pLastFrame = ImplGetFrameFromMacWin( pSalData->mpFocusWin );

			pLastFrame->maFrameData.mpProc(	pLastFrame->maFrameData.mpInst,
											pLastFrame, SALEVENT_LOSEFOCUS, 0 );
		}
		pSalData->mpFocusWin = pFocusWin;
	}
	else
		pSalData->mpFocusWin = 0L;

	return pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst,
									   pFrame, nEvent, 0 );
}

// -----------------------------------------------------------------------
// last changed:	dv	05.12.97

long ImplHandleShutDownMsg()
{
	static BOOL	bHandlingShutdown = FALSE;
	long	 	nRet = 0;
	
	if ( ! bHandlingShutdown )
	{
		bHandlingShutdown = TRUE;

		SalFrame   *pFrame = GetSalData()->mpFirstFrame;
	
		while ( pFrame && !nRet )
		{
			SalFrame *pNextFrame = pFrame->maFrameData.mpNextFrame;
			nRet = pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst,
											   pFrame, SALEVENT_CLOSE, 0 );
			pFrame = pNextFrame;
		}
		bHandlingShutdown = FALSE;
		GetSalData()->mbEnde = FALSE;
	}
	return nRet;
}

// -----------------------------------------------------------------------

long ImplHandleCloseMsg( SalFrame* pFrame )
{
	if ( ! pFrame )
	{	// exit(0); // sollte nicht noetig sein exit(0);
		return 0L;
	}
	return pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst, pFrame,
									   SALEVENT_CLOSE, 0 );
}

// -----------------------------------------------------------------------
// last changed:	dv	25.09.97

long ImplHandleSettingsChangeMsg( USHORT nSalSettingsEvent )
{
	long	nRet = 0;
	USHORT  nSalEvent = SALEVENT_SETTINGSCHANGED;

	if ( nSalSettingsEvent )
		nSalEvent = nSalSettingsEvent;

	SalFrame* pFrame = GetSalData()->mpFirstFrame;
	while ( pFrame )
	{
		nRet = pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst, pFrame,
										   nSalEvent, 0 );
		pFrame = pFrame->maFrameData.mpNextFrame;
	}

	return nRet;
}

// -----------------------------------------------------------------------
// last changed:	dv	31.10.97

static BOOL ImplMacDecodeModifier( EventRecord *pEvent, USHORT &nCode )
{
	BOOL	bWasCtrl = FALSE;
	short	nLastMMod = pEvent->modifiers & kModifierMask;

	nCode = 0;

	if ( nLastMMod & shiftKey )
		nCode |= KEY_SHIFT;
	if (nLastMMod & cmdKey)
		nCode |= KEY_MOD1;
	if (nLastMMod & optionKey)
		nCode |= KEY_MOD2;

	if ( nLastMMod & controlKey )
		bWasCtrl = TRUE;
	else
		bWasCtrl = FALSE;

	return bWasCtrl;
}

// -----------------------------------------------------------------------
// last changed:	dv	24.09.97

static void ImplHandleKeyModMsg( USHORT nModCode, WindowPtr pWin )
{
	SalFrame *pFrame = ImplGetFrameFromMacWin( pWin );

	if ( pFrame )
	{
		SalKeyModEvent aModEvt;
		aModEvt.mnTime = Time::GetSystemTicks();
		aModEvt.mnCode = nModCode;

		pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst, pFrame,
									SALEVENT_KEYMODCHANGE, &aModEvt );
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	05.11.97

void ImplHandlePaintMsg( SalFrame* pFrame )
{
	// Bounding Rect holen
	Rect aMacRect = ( *( ((WindowPtr)(pFrame->maFrameData.mpMacWin))->visRgn) )->rgnBBox;

	SalPaintEvent	aPEvt;

	aPEvt.mnBoundX      = aMacRect.left;
	aPEvt.mnBoundY      = aMacRect.top;
	aPEvt.mnBoundWidth  = aMacRect.right-aMacRect.left;
	aPEvt.mnBoundHeight = aMacRect.bottom-aMacRect.top;

	// Paint Event verschicken
	pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst, pFrame,
								SALEVENT_PAINT, &aPEvt );
}

// -----------------------------------------------------------------------

void ImplHandleUserEvent( SalFrame* pFrame, void* pEventData )
{
	if ( ! pFrame )
		pFrame = GetSalData()->mpFirstFrame;

	if ( ! pFrame )
		return;

	pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst, pFrame,
								SALEVENT_USEREVENT, (void*)pEventData );
}

// -----------------------------------------------------------------------
// last changed:	dv	31.10.97

long ImplHandleKeyMsg(  EventRecord *pEvent, SalFrame* pFrame )
{
	if ( !pFrame )
		 return 0L;

	USHORT	nModCode;
	USHORT	nCharCode = (USHORT) (pEvent->message & charCodeMask);
	USHORT	nMacKeyCode = (USHORT) ((pEvent->message & keyCodeMask) >> 8);
	USHORT	nRepeat = ( pEvent->what == autoKey );
	long	nRet=0L;
	
	ImplMacDecodeModifier( pEvent, nModCode );

	USHORT nSVCode = 0;
	if ( nCharCode == 16 )
	{	nSVCode = GetFKey( nMacKeyCode );
	}
	else
	{
		long nTemp = 0;
		long nKTRet;
		void* pKCHRPtr = (void*) GetScriptManagerVariable( smKCHRCache );
		nKTRet = KeyTranslate( pKCHRPtr, nMacKeyCode,(UInt32 *) &nTemp );
		if ( nKTRet & 0xffff0000 )
			nMacKeyCode = ((USHORT) nKTRet >> 16 );
		else
			nMacKeyCode =  (USHORT) ( nKTRet & 0x0ffff );

		// MAC-KeyCode in StarView-KeyCode uebersetzen
		if ( nMacKeyCode >= KEY_TAB_SIZE )
			nSVCode = 0;
		else
		{	nSVCode = aImplTranslateKeyTab[ nMacKeyCode ];

			if ( (nMacKeyCode >= '0') && (nMacKeyCode <= '9') )
				nSVCode = KEYGROUP_NUM + nMacKeyCode - '0';
			else if ( (nMacKeyCode >= 'A') && (nMacKeyCode <= 'Z') )
				nSVCode = KEYGROUP_ALPHA + nMacKeyCode - 'A';
			else if ( (nMacKeyCode >= 'a') && (nMacKeyCode <= 'z') )
				nSVCode = KEYGROUP_ALPHA + nMacKeyCode - 'a';

		}
	}
	if ( TRUE )
	{	SalKeyEvent	aKeyEvt;  memset(&aKeyEvt,0,sizeof(aKeyEvt));
		USHORT		nEvent;
		if ( pEvent->what == keyUp )
			nEvent = SALEVENT_KEYUP;
		else
			nEvent = SALEVENT_KEYINPUT;

		aKeyEvt.mnCode      = nSVCode;
		aKeyEvt.mnTime      = Time::GetSystemTicks();
		aKeyEvt.mnCode     |= nModCode;
		aKeyEvt.mnCharCode  = nCharCode;
		aKeyEvt.mnRepeat    = nRepeat;
		nRet = pFrame->maFrameData.mpProc( pFrame->maFrameData.mpInst, pFrame,
												nEvent, &aKeyEvt );
	}
	return nRet;
}

// -----------------------------------------------------------------------
// last changed:	dv	12.11.97

SalFrame * ImplGetFrameFromMacWin( WindowPtr pMacWin )
{
	if ( ! pMacWin )
		return NULL;

	SalFrame *pFrame = GetSalData()->mpFirstFrame;
	SalFrame *pMacFrame = (SalFrame *) GetWRefCon( pMacWin );

	while ( pFrame && ( pFrame != pMacFrame ) )
	{
		pFrame = pFrame->maFrameData.mpNextFrame;
	}
	
	return pFrame;
}


// =======================================================================
// last changed:	dv	31.10.97

BOOL SV_EventLoop()
{
	static short	nTimerCount = 0;
	static USHORT	nLastModifier = 0;
	short			nEventMask = everyEvent;
	SalData*		pSalData = GetSalData();
	EventRecord		event;
	USHORT			nModifier;
	BOOL			gotEvent;

	if ( ! hMouseRgn )
	{
		hMouseRgn = NewRgn();
		SetRectRgn( hMouseRgn, 0, 0, 1, 1 );
	}

	gotEvent = WaitNextEvent( nEventMask, &event, 1L, hMouseRgn );

	if ( gotEvent )
		DoEvent( &event );

	// Modifier Changed Event erzeugen
	ImplMacDecodeModifier( &event, nModifier );
	if ( ( nLastModifier != nModifier ) && pSalData->mpFocusWin )
	{
		nLastModifier = nModifier;
		ImplHandleKeyModMsg( nModifier, pSalData->mpFocusWin );
	}

	// Eventuell aufgetretene Timeouts behandeln
	if ( pSalData->mnTimerId && ( pSalData->mnTimerId < Time::GetSystemTicks() ) )
	{
		if ( (event.what == nullEvent) || (nTimerCount++ == 4) )
		{
			// Notify the time Manager that a timeout has occured
			SalTimerProc();
			nTimerCount = 0;
			gotEvent = TRUE;
		}
	}

	if ( pSalData->mbEnde )
	{	ImplHandleShutDownMsg();
	}

	pSalData->maLastEventRec = event;
	
	return gotEvent;
}

// -----------------------------------------------------------------------
// last changed:	dv	29.10.97

void DoEvent( EventRecord *pEvent )
{
	GetSalData()->mpMacEvent = pEvent;

	switch (pEvent->what) {
		case nullEvent :
//			DoMouseMove( pEvent );
			break;
		case mouseUp :
			DoMouseUp( pEvent );
			break;
		case mouseDown :
			DoMouseDown( pEvent );
			break;
		case keyDown :
			DoKey( pEvent );
			break;
		case keyUp :
			DoKey( pEvent );
			break;
		case autoKey :
			DoKey( pEvent );
			break;
		case updateEvt :
			DoUpdate( pEvent );
			break;
		case activateEvt :
			DoActivate( (WindowPtr) pEvent->message,
						(pEvent->modifiers & activeFlag) != 0 );
			break;

		case diskEvt:
			if ( HiWord(pEvent->message) != noErr )
			{
				MAC_Point aPoint;
				SetPt(&aPoint, kDILeft, kDITop);
				DIBadMount(aPoint, pEvent->message);
			}
			DBG_ERROR( "New Disk inserted event missing, NYI" );
			break;
		case osEvt:
			switch ((pEvent->message >> 24) & 0x0FF)
			{
				case suspendResumeMessage:
					DoSuspendResume(pEvent,(pEvent->message & resumeFlag) == 1);
				break;
				case mouseMovedMessage:
					DoMouseMove( pEvent );
				break;
			}
			break;
		case kHighLevelEvent:
			DoHighLevelEvent( pEvent );
			break;
		default :
			break;
	} // end switch (pEvent->what)
}

// -----------------------------------------------------------------------
// last changed:	dv	13.11.97

void DoMouseMove( EventRecord *pEvent )
{
	SalData		*pSalData = GetSalData();
	SalFrame	*pCaptureFrame = pSalData->mpCaptureFrame;
	MacPoint	aPoint( pEvent->where );

	DBG_ASSERT( hMouseRgn, "Keine MouseRgn aber ein MouseMove?" );
	
	SetRectRgn( hMouseRgn, aPoint.h, aPoint.v,
				aPoint.h + 1, aPoint.v + 1 );
	
	gLastMousePos = pEvent->where;

	if ( pCaptureFrame )
	{
		if ( pSalData->mbInForeground )
		{	// egal wo
			ImplHandleMouseMsg( pEvent, pCaptureFrame );
		}
	}
	else
	{
		WindowPtr	pMacWin=0L;
		INT16		partCode = FindWindow( aPoint, &pMacWin );
		SalFrame	*pFrame = ImplGetFrameFromMacWin( pMacWin );

		if ( pSalData->mpWantLeaveMsg )
		{
			// Mouse leave message
			if ( ( partCode != inContent ) ||
				 ( pSalData->mpWantLeaveMsg != pFrame ) )
			{
				EventRecord aTmpEvent = *pEvent;
				aTmpEvent.what = SAL_MSG_MOUSELEAVE;
				ImplHandleMouseMsg( &aTmpEvent, pSalData->mpWantLeaveMsg );
			}
		}
		// only foreground mouse move events
		if ( pSalData->mbInForeground && ( partCode == inContent ) )
		{
			ImplHandleMouseMsg( pEvent, pFrame );
		}
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	23.09.97

void DoMouseUp( EventRecord *pEvent )
{
	SalData* 	pSalData = GetSalData();
	SalFrame*	pCaptureFrame = pSalData->mpCaptureFrame;

	pSalData->mbMouseButtonDown = FALSE;

	if ( pCaptureFrame )
	{
		ImplHandleMouseMsg( pEvent, pCaptureFrame );
	}
	else
	{
		WindowPtr	pMacWin=0L;
		INT16		partCode = FindWindow( pEvent->where, &pMacWin );

		if ( pMacWin && partCode == inContent )
			ImplHandleMouseMsg( pEvent, ImplGetFrameFromMacWin( pMacWin ) );
	}
}

// -----------------------------------------------------------------------
// last changed:	hro	15.12.97

void DoMouseDown( EventRecord *pEvent )
{
	SalData* 	pSalData = GetSalData();
	SalFrame*	pCaptureFrame = pSalData->mpCaptureFrame;
	WindowPtr	pMacWin=0L;

	pSalData->maLastMouseDown = *pEvent;
	
	if ( pCaptureFrame )
	{
		pSalData->mbMouseButtonDown = TRUE;
		ImplHandleMouseMsg( pEvent, pCaptureFrame );
	}
	else
	{
		INT16 partCode = FindWindow( pEvent->where, &pMacWin );

		if ( pMacWin )
		{
			SalData* pSalData = GetSalData();

			if ( partCode != inContent )
				MAC_SetCursor( &(qd.arrow) );

			switch (partCode)
			{
				case inDesk :
				break;
				case inSysWindow: // DA: let the system handle the mouseDown
					SystemClick( pEvent, pMacWin );
				break;
				case inGoAway :
					if ( TrackGoAway( pMacWin, pEvent->where ) )
					{	DoCloseWindow( pMacWin );
					}
				break;
				case inDrag :
					DoInDrag( pEvent, pMacWin );
				break;
				case inContent :
				{
					if ( pMacWin != FrontWindow() )
						SelectWindow( pMacWin );
					else
					{
						pSalData->mbMouseButtonDown = TRUE;
						ImplHandleMouseMsg( pEvent, ImplGetFrameFromMacWin( pMacWin ) );
					}
				}
				break;
				case inGrow :
					DoGrowWindow(pEvent,pMacWin);
				break;
				case inZoomIn :
				case inZoomOut :
					Impl_DoZoom( pEvent, pMacWin, partCode );
				break;
				default:
				break;
			}
		}
		else
		{	MAC_SetCursor( &(qd.arrow) );
			switch ( partCode )
			{
				case inMenuBar :
					DoMenu( MenuSelect( pEvent->where ) );
				break;
			}
		}
	}
}

// -----------------------------------------------------------------------
// last changed:	hro	07.06.98


extern void MacClipboardHasChanged();
extern void UpdateMacClipboard( BOOL );

void DoSuspendResume( EventRecord *pEvent, BOOL becomingActive )
{
	SalData		*pSalData = GetSalData();

	DBG_ASSERT(!pSalData->ImplIsInSuspendResume(), "Nested Suspend/Resume handling ?");

	MAC_SetCursor( &(qd.arrow) );

	pSalData->ImplSetInSuspendResume( TRUE );
	pSalData->mbInForeground = becomingActive;

	if ( becomingActive )
	{
		ImplHandleFocusMsg( FrontWindow(), SALEVENT_GETFOCUS );

		// Wenn eine andere Application das Clipboard verndert hat das Office benachrichtigen
		
		if (pEvent->message & convertClipboardFlag)
			MacClipboardHasChanged();
	}
	else
	{
		ImplHandleFocusMsg( pSalData->mpFocusWin, SALEVENT_LOSEFOCUS );

		// Mouse leave message
		if ( pSalData->mpWantLeaveMsg )
		{
			pSalData->ImplSendMessage( pSalData->mpWantLeaveMsg,
									   (void*)0L, SAL_MSG_MOUSELEAVE );
		}
		
		// Beim wechsel zu einer anderen Application schreiben wir jetzt erst mal nur die
		// System-relevanten Formate ins Clipboard
		
		UpdateMacClipboard(FALSE); 	// TRUE -> alle registrierten Formate
									// FALSE -> nur Standardformate TEXT,PICT
	}

	pSalData->ImplSetInSuspendResume( FALSE );
}

// -----------------------------------------------------------------------
// last changed:	dv	24.09.97

void DoActivate( WindowPtr pWindow, BOOL bActivate )
{
	if ( bActivate )
		ImplHandleFocusMsg( pWindow, SALEVENT_GETFOCUS );
	else
		ImplHandleFocusMsg( pWindow, SALEVENT_LOSEFOCUS );
}

// -----------------------------------------------------------------------

void DoHighLevelEvent( EventRecord *pEvent )
{
	OSErr aErr;

	aErr = AEProcessAppleEvent( pEvent );
}

// -----------------------------------------------------------------------

void DoCloseWindow( WindowPtr pMacWin )
{
	/* DA windows have negative windowKinds */
	if ( ((WindowPeek) pMacWin)->windowKind < 0 )
		CloseDeskAcc( ((WindowPeek) pMacWin)->windowKind );
	else
		ImplHandleCloseMsg( ImplGetFrameFromMacWin( pMacWin ) );
}

// -----------------------------------------------------------------------

void DoInDrag( EventRecord *pEvent, WindowPtr pMacWin )
{
	Rect aRect = ( **GetGrayRgn() ).rgnBBox;
	if ( ! ( pEvent->modifiers & cmdKey ) )
	{
		SelectWindow( pMacWin );
	}
	DragWindow( pMacWin, pEvent->where, &aRect );
}

// -----------------------------------------------------------------------

void DoGrowWindow( EventRecord *pEvent, WindowPtr pMacWin )
{
	INT32	newSize;
	INT16	newHeight,newWidth;
	Rect	growLimitSizes;

	growLimitSizes.top = 80;			/* min height */
	growLimitSizes.bottom = 32767;		/* max height */
	growLimitSizes.left = 120; 			/* min width */
	growLimitSizes.right = 32767;		/* max width */

	newSize = GrowWindow(pMacWin,pEvent->where,&growLimitSizes);
	newHeight = HiWord( newSize );
	newWidth = LoWord( newSize );
	SizeWindow( pMacWin, newWidth, newHeight, TRUE );
	ImplHandleSizeMsg( pMacWin );
}

// -----------------------------------------------------------------------
// last changed:	dv	05.11.97

void DoZoomWindow( WindowPtr pMacWin )
{
	GDHandle	gdNthDevice, gdZoomOnThisDevice;
	Rect		windRect, zoomRect, theSect;
	long		sectArea, greatestArea;
	short		wTitleHeight;
	BOOL		sectFlag;

	MacTempGWorld aSavedWorld( (CGrafPort*) pMacWin );

	windRect = pMacWin->portRect;
	LocalToGlobal( (MAC_Point*) &windRect.top );	// convert to global coordinates
	LocalToGlobal( (MAC_Point*) &windRect.bottom );

	// calculate height of window's title bar
	wTitleHeight = windRect.top - 1 - 
				   (**(((WindowPeek)pMacWin)->strucRgn)).rgnBBox.top;

	if ( 0 /* !gbHasColorQD */ )
	{
		zoomRect = qd.screenBits.bounds;
		wTitleHeight += GetMBarHeight();
	}
	else
	{
		windRect.top = windRect.top - wTitleHeight;
		gdNthDevice = GetDeviceList();
		greatestArea = 0;								// initialize to 0

		// check window against all gdRects in gDevice list and remember
		// which gdRect contains largest area of window
		while (	gdNthDevice != nil )
		{
			if ( TestDeviceAttribute( gdNthDevice, screenDevice ) &&
				 TestDeviceAttribute( gdNthDevice, screenActive ) )
			{
				// The SectRect routine calculates the intersection
				// of the window rectangle and this gDevice
				// rectangle and returns TRUE if the rectangles intersect,
				// FALSE if they don't.
				sectFlag = SectRect( &windRect, &(**gdNthDevice).gdRect, &theSect );

				// determine which screen holds greatest window area
				// first, calculate area of rectangle on current device
				if ( sectFlag )
				{
					sectArea = (long)( theSect.right - theSect.left ) *
							   (long)( theSect.bottom - theSect.top );
					if ( sectArea > greatestArea )
					{
						greatestArea = sectArea;			// set greatest area so far
						gdZoomOnThisDevice = gdNthDevice;	// set zoom device
					}
				}
			}
			gdNthDevice = GetNextDevice(gdNthDevice);
		} // end of while

		// if gdZoomOnThisDevice is on main device, allow for menu bar height
		if ( gdZoomOnThisDevice == GetMainDevice() )
			wTitleHeight = wTitleHeight + GetMBarHeight();
		
		zoomRect = (**gdZoomOnThisDevice).gdRect;
	}
	// set up the WStateData record for this window
	zoomRect.top += wTitleHeight;
	zoomRect.top -= 4;
	InsetRect( &zoomRect, 4, 4 );
	( ** (WStateDataHandle) (((WindowPeek)pMacWin)->dataHandle) ).stdState = zoomRect;
}

// -----------------------------------------------------------------------
// last changed:	dv	07.11.97

void Impl_DoZoom( EventRecord *pEvent, WindowPtr pMacWin, int part )
{
	BOOL bResizeWin = TRUE;
	
	if ( pEvent )
		bResizeWin = TrackBox( pMacWin, pEvent->where, part );

	if ( bResizeWin )
	{
		if ( part == inZoomOut )
			DoZoomWindow( pMacWin );

		ZoomWindow( pMacWin, part, true );
		ImplHandleSizeMsg( pMacWin );
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	24.09.97

void DoCheckColorDept()
{
	static short nLastPixelSize = 0;
	// Hat sich die Farbaufloesung geaendert?
	GDHandle hMainDev = GetMainDevice();
	short nActPixelSize = (*(*hMainDev)->gdPMap)->pixelSize;

	if ( nActPixelSize != nLastPixelSize )
	{
		if ( nLastPixelSize )
			ImplHandleSettingsChangeMsg( SALEVENT_DISPLAYCHANGED );
		nLastPixelSize = nActPixelSize;
	}
}

// -----------------------------------------------------------------------
// last changed:	dv	24.09.97

void DrawClippedGrowIcon( WindowPtr pMacWin )
{
	Rect		  clip;
	RgnHandle	  oldClip;

	// Setzt den GPort auf pMacWin und restauriert im DTor wieder die alten Werte
	MacTempGWorld aSavedWorld( (CGrafPort*) pMacWin );

	oldClip = NewRgn();
	GetClip( oldClip );
	clip = pMacWin->portRect;
	clip.left = clip.right - 15;
	clip.top = clip.bottom - 15;

	PenNormal();
	ClipRect( &clip );
	DrawGrowIcon( pMacWin );
	SetClip( oldClip );
	DisposeRgn( oldClip );
}

// -----------------------------------------------------------------------
// last changed:	dv	30.10.97

void DoUpdate(EventRecord *pEvent)
{
	static BOOL	bInUpdate = FALSE;

	if ( bInUpdate )
		return;

	bInUpdate = TRUE;

	// Pruefen, ob sich die Farbaufloesung geaendert hat
	DoCheckColorDept();

	WindowPtr updateWin = (WindowPtr)pEvent->message;

	if ( ! EmptyRgn( ((WindowPeek)updateWin)->updateRgn ) )
	{
		SalFrame *pFrame = ImplGetFrameFromMacWin( updateWin );

		BeginUpdate( updateWin );
		if ( pFrame )
		{
			// Setzt den GPort auf updateWin und restauriert im DTor wieder die alten Werte
			MacTempGWorld aSavedWorld( (CGrafPort*) updateWin );
			ImplHandlePaintMsg( pFrame );
			if ( pFrame->maFrameData.mbHasGrowArea )
				DrawClippedGrowIcon( updateWin );
		}
		EndUpdate( updateWin );
	}
#ifdef DBG_UTIL
	else
	{
		DBG_ERROR( "DoUpdate1 EmptyRgn ");
	}
#endif

	bInUpdate = FALSE;
}
