/*************************************************************************
 *
 *  $RCSfile: NoSharMain.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/10/12 16:24:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#include <svmac.h>



#include "Mac_Start.h"



#include <PLStringFuncs.h>



#ifndef __LIMITS__

  #include <limits.h>

#endif



#include "Mac_end.h"



#include <SVAPP.HXX>

#include <main.h>

#include <stdlib.h>



#include <MEMINIT.hxx>

#include <algorithm>



// -----------------------------------------------------------------------

// Initialisierung der Mac Speicherverwaltung 



SVMemInit::SVMemInit()

{

	if (!bMacMemInit)

	{

			// Set the Stacksize to 0xC000

		long newLimit = (long)LMGetCurStackBase() - 0xC000;

		if ((long)GetApplLimit() > newLimit)

			SetApplLimit((MAC_Ptr)newLimit);



		MaxApplZone();



		THz applZone;

		short oldMoreMast;

		const short callMoreMasters = 44;

		

		// Here is a trick suggested by Jerome C.--it allocates one 

		// large block of master pointers

		applZone = ApplicationZone();

		oldMoreMast = applZone->moreMast;

		long numMasterPointersDesired = oldMoreMast * callMoreMasters;

		do {

			applZone->moreMast = (short) std::min(numMasterPointersDesired, SHRT_MAX);

			MoreMasters();

			numMasterPointersDesired -= applZone->moreMast;

		} while (numMasterPointersDesired > 0);

		applZone->moreMast = oldMoreMast;



		// HACK to make make malloc alloc a large block

		#define kMiniBlockSize	8

		

		char* miniBlock  = new char[kMiniBlockSize];

		// OK OK kMiniBlockSize bytes are lost in miniBlock,



		bMacMemInit = TRUE;

	}

}



// -----------------------------------------------------------------------



SVMemInit::~SVMemInit()

{

}



// -----------------------------------------------------------------------



SVMemInit aMemInit;	// Mac Speicherverwaltung in Gang setzten ...






