/*************************************************************************
 *
 *  $RCSfile: i_enum.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: np $ $Date: 2002/05/14 08:29:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef UDM_ENUM_HXX
#define UDM_ENUM_HXX


// USED SERVICES
	// BASE CLASSES
#include <udm/data.hxx>
	// COMPONENTS
	// PARAMETERS

namespace udm
{



class EnumInfo
{
  public:
    typedef ::csv::String                  id;
    typedef std::pair<intt,::csv::String>  value;
    typedef std::vector<value>      value_vector;

    const value &   operator[](
                        intt                    i_n ) const;
    const value &   operator[](
                        const ::csv::String &          i_str ) const;

    id              name() const;
    const value_vector &
                    values() const;

    static const EnumInfo &
                    get_info_(
                        const id &              i_sEnumTypeName );
    static const EnumInfo &
                    create_info_(
                        const id &              i_sEnumTypeName,    /// Must not yet exist.
                        const int *             i_nBegin,           /// Start of vector of i_nCount size.
                        const ::csv::String *     i_sBegin,           /// Start of vector of i_nCount size.
                        unsigned int            i_nCount );
  private:
    typedef std::map< intt, value* >        MapByInt;
    typedef std::map< ::csv::String, value* > MapByStr;

    // Locals
    static const value &
                    ValueNone_();
    // Data
    value_vector    aValues;
    MapByInt        aMap_byInt;
    MapByStr        aMap_byStr;
    ::csv::String     aName;
};



class Enum : public Data
{
  public:
    virtual             ~Enum() {}

    // OPERATIONS
    Enum &              operator++();
    Enum &              operator--();
                        operator bool() const;

    // OPERATIONS
    void                assign(
                            intt                i_n );
    void                assign(
                            const ::csv::String & i_str );
    void                assign_first_value();
    void                assign_last_value();

    // INQUIRY
    intt                v_int() const;
    ::csv::String         v_str() const;
    const EnumInfo &    enum_info() const;

  private:
    // Interface Data:
    virtual accessor_type
                        inq_Type() const;
    // Locals
    virtual void        do_assign(
                            const EnumInfo::value &
                                                i_rValue ) = 0;
    virtual const EnumInfo::value &
                        inq_V() const = 0;
    virtual const EnumInfo &
                        inq_EnumInfo() const = 0;
};





}   // namespace udm


#endif




