/*************************************************************************
 *
 *  $RCSfile: remotecontentproviderscontrol.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/20 07:48:19 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCBHELPER_REMOTECONTENTPROVIDERSCONTROL_HXX_
#define _UCBHELPER_REMOTECONTENTPROVIDERSCONTROL_HXX_

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _OSL_MUTEX_HXX_
#include "osl/mutex.hxx"
#endif
#ifndef _RTL_REF_HXX_
#include "rtl/ref.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#ifndef _SALHELPER_SIMPLEREFERENCEOBJECT_HXX_
#include "salhelper/simplereferenceobject.hxx"
#endif

#ifndef INCLUDED_MAP
#include <map>
#define INCLUDED_MAP
#endif

namespace com { namespace sun { namespace star {
    namespace bridge { class XBridge; }
    namespace connection { class XConnection; }
    namespace lang { class XMultiServiceFactory; }
} } }

namespace ucb
{

/** A helper class to disconnect from any distributors of remote content
	providers once the com.sun.star.ucb.RemoteContentProviderAcceptor service
	no longer needs them.
 */
class RemoteContentProvidersControl: public salhelper::SimpleReferenceObject
{
public:
	RemoteContentProvidersControl(
		com::sun::star::uno::Reference<
				com::sun::star::lang::XMultiServiceFactory > const &
			rServiceFactory);

	/** This method must be called for each relevant connection, to track its
		lifetime.

        @descr
        This method must be called before detectDistributionConnection() is
        called.

		@descr
        The methods addConnection() and detectDistributionConnection()
        together count the number of total open connections and the number of
        connections that are only used to distribute remote content providers.
        If the number of open connections ever drops so that only
        'distribution' connections remain open, the
        com.sun.star.ucb.RemoteContentProviderAcceptor is informed about this,
        so that it in turn can tell all the 'distributors' to close the
        connections.
	 */
	void
	addConnection(
		com::sun::star::uno::Reference<
				com::sun::star::connection::XConnection > const &
			rConnection);

    /** This method must be called for each relevant connection, to find out
        whether the connection is used to distribute remote content providers.

        @descr
        This method must be called after addConnection() has already been
        called.
     */
    void
    detectDistributionConnection(
        com::sun::star::uno::Reference<
                com::sun::star::connection::XConnection > const &
            rConnection,
        com::sun::star::uno::Reference<
                com::sun::star::bridge::XBridge > const &
            rBridge);

private:
    class Listener;

    typedef std::map< com::sun::star::uno::Reference<
                          com::sun::star::connection::XConnection >,
                      rtl::Reference< Listener > >
    Listeners;

    osl::Mutex m_aMutex;
    Listeners m_aListeners;
	com::sun::star::uno::Reference<
			com::sun::star::lang::XMultiServiceFactory >
		m_xServiceFactory;
    sal_Int32 m_nNonDistributions;
    sal_Int32 m_nDistributions;

    virtual ~RemoteContentProvidersControl() SAL_THROW(());

    void closed(Listeners::iterator aIt, bool bDistribution);

    friend Listener; // to access Listeners, setClosed()
};

}

#endif //  _UCBHELPER_REMOTECONTENTPROVIDERSCONTROL_HXX_
