/*************************************************************************
 *
 *  $RCSfile: rapofflinestoragedatastream.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:58:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEDATASTREAM_HXX
#include "rapofflinestoragedatastream.hxx"
#endif

#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include "com/sun/star/util/DateTime.hpp"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif
#ifndef _RTL_STRING_HXX_
#include "rtl/string.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif

#include <memory>

using namespace com::sun;
using ucprmt::offline::StorageDataStream;
using ucprmt::offline::StorageError;

void StorageDataStream::readBuffer(void * pBuffer, sal_uInt32 nSize)
    SAL_THROW((StorageError))
{
    for (sal_uInt32 i = 0; i < nSize;)
    {
        sal_uInt32 nDone;
        storeError eError = m_aStream.readAt(m_nOffset + i,
                                             static_cast< char * >(pBuffer)
                                                 + i,
                                             nSize - i,
                                             nDone);
        if (eError != store_E_None)
            throw StorageError(eError);
        i += nDone;
    }
    m_nOffset += nSize;
}

void StorageDataStream::writeBuffer(void const * pBuffer, sal_uInt32 nSize)
    SAL_THROW((StorageError))
{
    for (sal_uInt32 i = 0; i < nSize;)
    {
        sal_uInt32 nDone;
        storeError eError
            = m_aStream.writeAt(m_nOffset + i,
                                static_cast< char const * >(pBuffer) + i,
                                nSize - i,
                                nDone);
        if (eError != store_E_None)
            throw StorageError(eError);
        i += nDone;
    }
    m_nOffset += nSize;
}

bool StorageDataStream::readBoolean() SAL_THROW((StorageError))
{
    unsigned char aBuffer[1];
    readBuffer(aBuffer, 1);
    return aBuffer[0] != 0;
}

sal_uInt32 StorageDataStream::readInteger() SAL_THROW((StorageError))
{
    unsigned char aBuffer[4];
    readBuffer(aBuffer, 4);
    return aBuffer[0]
               + (aBuffer[1] << 8)
               + (aBuffer[2] << 16)
               + (aBuffer[3] << 24);
}

star::util::DateTime StorageDataStream::readDateTime()
    SAL_THROW((StorageError))
{
    sal_uInt32 nTime = readInteger();
    sal_uInt32 nDate = readInteger();
    return
        star::util::DateTime(static_cast< sal_Int16 >(nTime % 100),
                             static_cast< sal_Int16 >(nTime / 100 % 100),
                             static_cast< sal_Int16 >(nTime / 10000 % 100),
                             static_cast< sal_Int16 >(nTime / 1000000),
                             static_cast< sal_Int16 >(nDate % 100),
                             static_cast< sal_Int16 >(nDate / 100 % 100),
                             static_cast< sal_Int16 >(nDate / 10000 % 100));
        //TODO! range checks
}

rtl::OUString StorageDataStream::readString() SAL_THROW((StorageError))
{
    sal_uInt32 nLength = readInteger();
    std::auto_ptr< sal_Char > xBuffer(new sal_Char[nLength]);
        //TODO! out of memory
    readBuffer(xBuffer.get(), nLength);
    return rtl::OUString(xBuffer.get(), nLength, RTL_TEXTENCODING_UTF8);
}

star::uno::Sequence< rtl::OUString > StorageDataStream::readStrings()
    SAL_THROW((StorageError))
{
    sal_uInt32 nLength = readInteger();
    if (nLength > 0x7FFFFFFF)
        throw StorageError(store_E_Unknown); //TODO! better exception
    star::uno::Sequence< rtl::OUString >
        aSequence(static_cast< sal_Int32 >(nLength));
    for (sal_Int32 i = 0; i < static_cast< sal_Int32 >(nLength); ++i)
        aSequence[i] = readString();
    return aSequence;
}

void StorageDataStream::writeBoolean(bool bValue) SAL_THROW((StorageError))
{
    unsigned char aBuffer[1];
    aBuffer[0] = bValue;
    writeBuffer(aBuffer, 1);
}

void StorageDataStream::writeInteger(sal_uInt32 nValue)
    SAL_THROW((StorageError))
{
    unsigned char aBuffer[4];
    aBuffer[0] = static_cast< unsigned char >(nValue & 0xFF);
    aBuffer[1] = static_cast< unsigned char >((nValue >> 8) & 0xFF);
    aBuffer[2] = static_cast< unsigned char >((nValue >> 16) & 0xFF);
    aBuffer[3] = static_cast< unsigned char >((nValue >> 24) & 0xFF);
    writeBuffer(aBuffer, 4);
}

void StorageDataStream::writeDateTime(star::util::DateTime const & rValue)
    SAL_THROW((StorageError))
{
    writeInteger(rValue.HundredthSeconds
                     + 100 * rValue.Seconds
                     + 10000 * rValue.Minutes
                     + 1000000 * rValue.Hours);
    writeInteger(rValue.Day + 100 * rValue.Month + 10000 * rValue.Year);
}

void StorageDataStream::writeString(rtl::OUString const & rValue)
    SAL_THROW((StorageError))
{
    rtl::OString
        aBuffer(rValue.getStr(), rValue.getLength(), RTL_TEXTENCODING_UTF8);
    writeInteger(aBuffer.getLength());
    writeBuffer(aBuffer.getStr(), aBuffer.getLength());
}

void
StorageDataStream::writeStrings(star::uno::Sequence< rtl::OUString > const &
                                    rValue)
    SAL_THROW((StorageError))
{
    OSL_ASSERT(rValue.getLength() >= 0 && rValue.getLength() <= 0xFFFFFFFF);
    writeInteger(static_cast< sal_uInt32 >(rValue.getLength()));
    for (sal_Int32 i = 0; i < rValue.getLength(); ++i)
        writeString(rValue[i]);
}
