/*************************************************************************
 *
 *  $RCSfile: dbmem.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef DBG_UTIL

#include <debug.hxx>

// =======================================================================

#define DBG_MEM_ALLOC( n )												\
	DbgMemAlloc( n )

#define DBG_MEM_FREE( p )												\
	p = DbgMemFree( p );												\
	if ( !p )															\
		return;

#define DBG_MEM_SYSALLOC( n )											\
	DbgSysMemAlloc( n )

#define DBG_MEM_SYSFREE( p )											\
	DbgSysMemFree( p );

#define DBG_MEM_INIT( p, n, bFree ) 									\
	DbgMemInit( p, n, bFree );

#define DBG_MEM_ADDFREEBLOCK( n )										\
	DbgMemAddFreeBlock( n );

#define DBG_MEM_REMOVEFREEBLOCK( n )									\
	DbgMemRemoveFreeBlock( n );

#define DBG_MEM_SEARCHFREEBLOCK()										\
	DbgMemSearchFreeBlock();

// =======================================================================

#define DBG_MEMERR_OVERWRITE_BEFOR			1
#define DBG_MEMERR_OVERWRITE_BEHIND 		2
#define DBG_MEMERR_OVERWRITE_FREE			3
#define DBG_MEMERR_UNKNOWN_PTR				4

// =======================================================================

#define DBG_TEST_MEM_SPEZIAL	(DBG_TEST_MEM_OVERWRITE |				\
								 DBG_TEST_MEM_OVERWRITEFREE |			\
								 DBG_TEST_MEM_POINTER | 				\
								 DBG_TEST_MEM_REPORT |					\
								 DBG_TEST_MEM_TRACE |					\
								 DBG_TEST_MEM_LEAKREPORT)
#define DBG_TEST_MEM_EXTRA		(DBG_TEST_MEM_OVERWRITE |				\
								 DBG_TEST_MEM_OVERWRITEFREE |			\
								 DBG_TEST_MEM_POINTER)
#define DBG_TEST_MEM_ALLREPORT	(DBG_TEST_MEM_REPORT |					\
								 DBG_TEST_MEM_LEAKREPORT)

// =======================================================================

struct DbgMemBlock
{
	DbgMemBlock*		pNext;					// Naechster TestBlock
	void*				pStackTree; 			// Pointer auf den StackTrace
	ULONG				nSize;					// Groesse des Blocks
	ULONG				nSignature; 			// Signature vor Block
};

struct DbgMemReportBlock
{
	DbgMemReportBlock*	pNext;					// Naechster TestBlock
	ULONG				nSize;					// Groesse des Blocks
};

struct DbgMemLeakBlock
{
	void*				pStackTree; 			// Pointer auf den StackTrace
	ULONG				nSize;					// Groesse des Blocks
};

static void* MemAlloc( ULONG nAlloc );

// =======================================================================

static ULONG				nDbgCountAlloc = 0;
static ULONG				nDbgCountFree = 0;
static ULONG				nDbgAllAlloc = 0;
static ULONG				nDbgAllFree = 0;
static ULONG				nDbgMaxCountAlloc = 0;
static ULONG				nDbgMaxAlloc = 0;
static ULONG				nDbgMaxBlock = 0;
static ULONG				nDbgLess5 = 0;
static ULONG				nDbgLess9 = 0;
static ULONG				nDbgLess13 = 0;
static ULONG				nDbgLess17 = 0;
static ULONG				nDbgLess25 = 0;
static ULONG				nDbgLess33 = 0;
static ULONG				nDbgLess49 = 0;
static ULONG				nDbgLess65 = 0;
static ULONG				nDbgLess257 = 0;
static ULONG				nDbgLess513 = 0;
static ULONG				nDbgLess1025 = 0;
static ULONG				nDbgLess4097 = 0;
static ULONG				nDbgLess8193 = 0;
static ULONG				nDbgLess32769 = 0;
static ULONG				nDbgGreater32768 = 0;
static ULONG				nDbgFreeLess5 = 0;
static ULONG				nDbgFreeLess9 = 0;
static ULONG				nDbgFreeLess13 = 0;
static ULONG				nDbgFreeLess17 = 0;
static ULONG				nDbgFreeLess25 = 0;
static ULONG				nDbgFreeLess33 = 0;
static ULONG				nDbgFreeLess49 = 0;
static ULONG				nDbgFreeLess65 = 0;
static ULONG				nDbgFreeLess257 = 0;
static ULONG				nDbgFreeLess513 = 0;
static ULONG				nDbgFreeLess1025 = 0;
static ULONG				nDbgFreeLess4097 = 0;
static ULONG				nDbgFreeLess8193 = 0;
static ULONG				nDbgFreeLess32769 = 0;
static ULONG				nDbgFreeGreater32768 = 0;
static ULONG				nDbgCountFreeBlock = 0;
static ULONG				nDbgMaxCountFreeBlock = 0;
static ULONG				nDbgSearchFreeBlock = 0;
static ULONG				nDbgFreeBlockBytes = 0;
static ULONG				nDbgMaxFreeBlockBytes = 0;
static ULONG				nDbgCountSysAlloc = 0;
static ULONG				nDbgCountSysFree = 0;
static ULONG				nDbgAllSysAlloc = 0;
static ULONG				nDbgAllSysFree = 0;
static ULONG				nDbgMaxCountSysAlloc = 0;
static ULONG				nDbgMaxSysAlloc = 0;
static ULONG				nDbgMaxOverhead = 0;
static ULONG				nDbgMaxOverheadPercent = 0;
static DbgMemBlock* 		pFirstDbgBlock = NULL;
static DbgMemReportBlock*	pFirstDbgReportBlock = NULL;

// =======================================================================

static void DbgMemError( int nError,
						 void* p, void* p2 = NULL, void* pStackTree = NULL,
						 ULONG nSize = 0 )
{
	sal_Char aBuf[100];
	long n;

	switch ( nError )
	{
		case DBG_MEMERR_OVERWRITE_BEFOR:
			n =  ((long)p2) - ((long)p);
			sprintf( aBuf, "MemMgr - Write befor Block (Block: %p / Size: %lu / Offset: %ld)",
					 p, nSize, n );
			break;

		case DBG_MEMERR_OVERWRITE_BEHIND:
			n =  ((long)p2) - ((long)p);
			sprintf( aBuf, "MemMgr - Write behind Block (Block: %p / Size: %lu / Offset: %ld)",
					 p, nSize, n );
			break;

		case DBG_MEMERR_OVERWRITE_FREE:
			sprintf( aBuf, "MemMgr - Overwrite free memory: %p", p );
			break;

		case DBG_MEMERR_UNKNOWN_PTR:
			sprintf( aBuf, "MemMgr - Unknown Pointer: %p", p );
			break;
	}

	DbgError( aBuf );

	// Stack-Trace ausgeben, wo der Block angelegt wurde
	if ( (nError == DBG_MEMERR_OVERWRITE_BEFOR) ||
		 (nError == DBG_MEMERR_OVERWRITE_BEHIND) )
	{
		// Ausgaben ins File umleiten
		DbgData* pData = DbgGetData();
		if ( pData->nTestFlags & DBG_TEST_MEM_LEAKREPORT )
		{
			ULONG nOldOut = pData->nTraceOut;
			pData->nTraceOut = DBG_OUT_FILE;
			DbgTrace( aBuf );
			DbgPrintStackTree( pStackTree );
			pData->nTraceOut = nOldOut;
		}
	}
}

// -----------------------------------------------------------------------

static void DbgImpCheckBound( DbgMemBlock* pBlock )
{
	DbgData*	pData = DbgGetData();
#ifdef WIN
	BYTE huge*	pComp;
#else
	BYTE*		pComp;
#endif
	BYTE*		p;
	int 		i;

	pComp = (BYTE*)&(pBlock->nSignature);
	for ( i = 0; i < sizeof( ULONG ); i++ )
	{
		if ( *pComp != pData->bMemBound )
		{
			p = (((BYTE*)pBlock)+sizeof( DbgMemBlock ));
			DbgMemError( DBG_MEMERR_OVERWRITE_BEFOR, p, pComp, pBlock->pStackTree, pBlock->nSize );
			break;
		}
		pComp++;
	}

	pComp = (BYTE*)pBlock;
	pComp += sizeof( DbgMemBlock ) + pBlock->nSize;
	for ( i = 0; i < sizeof( ULONG ); i++ )
	{
		if ( *pComp != pData->bMemBound )
		{
			p = (((BYTE*)pBlock)+sizeof( DbgMemBlock ));
			DbgMemError( DBG_MEMERR_OVERWRITE_BEHIND, p, pComp, pBlock->pStackTree, pBlock->nSize );
			break;
		}
		pComp++;
	}
}

// -----------------------------------------------------------------------

static void DbgImpCheckFreeMemory( FreeBlock* pBlock )
{
	DbgData* pData = DbgGetData();

	while ( pBlock )
	{
		if ( (pBlock->nSize > MEMBLOCK_SIZE) ||
			 (pBlock->nSize < MEMBLOCK_MINSIZE) )
			DbgMemError( DBG_MEMERR_OVERWRITE_FREE, &(pBlock->nSize) );
		if ( pBlock->nPrev > MEMBLOCK_MAXSIZE )
			DbgMemError( DBG_MEMERR_OVERWRITE_FREE, &(pBlock->nPrev) );

		BYTE*  p = (BYTE*)pBlock;
		USHORT n = pBlock->nSize-sizeof(FreeBlock);
		p += sizeof( FreeBlock );
		while ( n )
		{
			// Freier Speicherblock ueberschrieben
			if ( *p != pData->bMemFree )
				DbgMemError( DBG_MEMERR_OVERWRITE_FREE, p );

			p++;
			n--;
		}

		pBlock = pBlock->pNext;
	}
}

// -----------------------------------------------------------------------

static void DbgImpCheckGenFreeMemory( FreeBlock* pBlock )
{
	DbgData* pData = DbgGetData();

	if ( pBlock )
	{
		FreeBlock* pStartBlock = pBlock;
		do
		{
			if ( (pBlock->nSize > MEMBLOCK_SIZE) ||
				 (pBlock->nSize < MEMBLOCK_MINSIZE) )
				DbgMemError( DBG_MEMERR_OVERWRITE_FREE, &(pBlock->nSize) );
			if ( pBlock->nPrev > MEMBLOCK_MAXSIZE )
				DbgMemError( DBG_MEMERR_OVERWRITE_FREE, &(pBlock->nPrev) );

			BYTE*  p = (BYTE*)pBlock;
			USHORT n = pBlock->nSize-sizeof(FreeBlock);
			p += sizeof( FreeBlock );
			while ( n )
			{
				// Freier Speicherblock ueberschrieben
				if ( *p != pData->bMemFree )
					DbgMemError( DBG_MEMERR_OVERWRITE_FREE, p );

				p++;
				n--;
			}

			pBlock = pBlock->pNext;
		}
		while ( pBlock != pStartBlock );
	}
}

// -----------------------------------------------------------------------

static void DbgImpCheckAllFreeMemory()
{
	MEM_SEMSTART();

	FreeBlock** ppFirstBlock = GetMemData()->pFirstBlocks;
	USHORT		n = 0;
	do
	{
		DbgImpCheckFreeMemory( *ppFirstBlock );
		ppFirstBlock++;
		n++;
	}
	while ( n < MEM_FREELIST_COUNT-1 );

	// Generelle Freispeicherliste pruefen
	ppFirstBlock = GetMemData()->pFirstBlocks+MEM_FREELIST_GENERAL;
	DbgImpCheckGenFreeMemory( *ppFirstBlock );

	MEM_SEMEND();
}

// -----------------------------------------------------------------------

void DbgImpCheckMemory( void* p = NULL )
{
	DbgData* pData = DbgGetData();

	if ( !pData )
		return;

	MEM_SEMSTART();

	if ( (pData->nTestFlags & DBG_TEST_MEM_OVERWRITE) ||
		 ((pData->nTestFlags & DBG_TEST_MEM_POINTER) && p) )
	{
		BOOL bFound = FALSE;
		DbgMemBlock* pBlock = (DbgMemBlock*)pFirstDbgBlock;
		while ( pBlock )
		{
			void* pTemp = (void*)(((BYTE*)pBlock)+sizeof( DbgMemBlock ));
			if ( pTemp == p )
				bFound = TRUE;

			if ( pData->nTestFlags & DBG_TEST_MEM_OVERWRITE )
				DbgImpCheckBound( pBlock );

			pBlock = pBlock->pNext;
		}

		if ( !bFound && p )
		{
			if ( pData->nTestFlags & DBG_TEST_MEM_POINTER )
				DbgMemError( DBG_MEMERR_UNKNOWN_PTR, p );
		}
	}

	if ( pData->nTestFlags & DBG_TEST_MEM_OVERWRITEFREE )
		DbgImpCheckAllFreeMemory();

	MEM_SEMEND();
}

// -----------------------------------------------------------------------

static void DbgTraceSize( sal_Char* pBuf, ULONG nSize )
{
	// Alloc-Size in String umwandeln und dranhaengen
	sal_Char	aSize[11];
	sal_Char*	pSize = &aSize[9];
	ULONG		i;
	memset( aSize, 0, sizeof( aSize ) );
	do
	{
		i = nSize % 10;
		pSize--;
		*(pSize) = (sal_Char)i + 48;
		nSize /= 10;
	}
	while ( nSize );
	strcat( pBuf, pSize );
}

// -----------------------------------------------------------------------

static void Dbghmemset( void* p, BYTE n, ULONG nSize )
{
#ifdef WIN
	BYTE huge* pTemp = (BYTE*)p;
	while ( nSize > 0xFFFF )
	{
		memset( pTemp, n, (size_t)0xFFFF );
		pTemp += 0xFFFF;
		nSize -= 0xFFFF;
	}
	memset( pTemp, n, (size_t)nSize );
#else
	memset( p, n, nSize );
#endif
}

// -----------------------------------------------------------------------

static void DbgMemInit( void* p, ULONG nSize, int bFree )
{
	DbgData* pData = DbgGetData();
	if ( pData && p )
	{
		if ( pData->nTestFlags & (DBG_TEST_MEM_INIT | DBG_TEST_MEM_OVERWRITEFREE) )
		{
			if ( bFree )
				Dbghmemset( p, pData->bMemFree, nSize );
			else
				Dbghmemset( p, pData->bMemInit, nSize );
		}
	}
}

// -----------------------------------------------------------------------

static void* DbgMemAlloc( ULONG nAlloc )
{
	DbgData*	pData = DbgGetData();
	void*		p;

	if ( pData && (pData->nTestFlags & DBG_TEST_MEM_SPEZIAL) )
	{
		MEM_SEMSTART();

		ULONG nSize = nAlloc;

		// Trace ausgaben
		if ( pData->nTestFlags & DBG_TEST_MEM_TRACE )
		{
			sal_Char aDbgOutBuf[20];
			strcpy( aDbgOutBuf, "Alloc: " );
			DbgTraceSize( aDbgOutBuf, nAlloc );
			DbgTrace( aDbgOutBuf );
		}

		// Overwrite-Test
		if ( pData->nTestFlags & (DBG_TEST_MEM_NEWDEL | DBG_TEST_MEM_POINTER) )
			DbgImpCheckMemory();
		else if ( pData->nTestFlags & DBG_TEST_MEM_OVERWRITEFREE )
			DbgImpCheckAllFreeMemory();

		// Bei Debug-Verwaltung, ein paar Bytes dazurechnen
		if ( (pData->nTestFlags & DBG_TEST_MEM_EXTRA) ||
			 ((pData->nTestFlags & DBG_TEST_MEM_ALLREPORT) == DBG_TEST_MEM_ALLREPORT) )
			nSize += sizeof( DbgMemBlock ) + sizeof( ULONG );
		else if ( pData->nTestFlags & DBG_TEST_MEM_REPORT )
			nSize += sizeof( DbgMemReportBlock );
		else if ( pData->nTestFlags & DBG_TEST_MEM_LEAKREPORT )
			nSize += sizeof( DbgMemLeakBlock );

		// Speicher anfordern
		p = MemAlloc( nSize );

		// Wenn Speicher angefordert werden konnte, dann in die Verwaltung
		// aufnehmen und Pointer anpassen
		if ( p )
		{
			if ( pData->nTestFlags & DBG_TEST_MEM_REPORT )
			{
				if ( nAlloc < 5 )
					nDbgLess5++;
				else if ( nAlloc < 9 )
					nDbgLess9++;
				else if ( nAlloc < 13 )
					nDbgLess13++;
				else if ( nAlloc < 17 )
					nDbgLess17++;
				else if ( nAlloc < 25 )
					nDbgLess25++;
				else if ( nAlloc < 33 )
					nDbgLess33++;
				else if ( nAlloc < 49 )
					nDbgLess49++;
				else if ( nAlloc < 65 )
					nDbgLess65++;
				else if ( nAlloc < 257 )
					nDbgLess257++;
				else if ( nAlloc < 513 )
					nDbgLess513++;
				else if ( nAlloc < 1025 )
					nDbgLess1025++;
				else if ( nAlloc < 4097 )
					nDbgLess4097++;
				else if ( nAlloc < 8193 )
					nDbgLess8193++;
				else if ( nAlloc < 32768 )
					nDbgLess32769++;
				else
					nDbgGreater32768++;
				if ( nAlloc > nDbgMaxBlock )
					nDbgMaxBlock = nAlloc;

				nDbgCountAlloc++;
				nDbgAllAlloc += nAlloc;
				if ( nDbgAllAlloc-nDbgAllFree > nDbgMaxAlloc )
				{
					nDbgMaxAlloc = nDbgAllAlloc-nDbgAllFree;
					nDbgMaxCountAlloc = nDbgCountAlloc-nDbgCountFree;

					ULONG nAllMem = nDbgAllAlloc-nDbgAllFree;
					ULONG nAllSysMem = (nDbgAllSysAlloc-nDbgAllSysFree)-
									   ((nDbgCountAlloc-nDbgCountFree)*(nSize-nAlloc));
					ULONG nOverhead = nAllSysMem-nAllMem;
					if ( nOverhead > nDbgMaxOverhead )
					{
						nDbgMaxOverhead = nOverhead;
						nDbgMaxOverheadPercent = (nAllSysMem*100/nAllMem)-100;
					}
				}
			}

			void* pStackTree;
			if ( pData->nTestFlags & DBG_TEST_MEM_LEAKREPORT )
				pStackTree = DbgGetStackTree( nAlloc );
			else
				pStackTree = NULL;

			if ( (pData->nTestFlags & DBG_TEST_MEM_EXTRA) ||
				 ((pData->nTestFlags & DBG_TEST_MEM_ALLREPORT) == DBG_TEST_MEM_ALLREPORT) )
			{
				DbgMemBlock* pBlock = (DbgMemBlock*)p;
				pBlock->pNext			= pFirstDbgBlock;
				pBlock->pStackTree		= pStackTree;
				pBlock->nSize			= nAlloc;
				memset( &(pBlock->nSignature), pData->bMemBound, sizeof( ULONG ) );
				pFirstDbgBlock = pBlock;
				pBlock++;
				p = (void*)pBlock;

#ifdef WIN
				BYTE huge* pTemp = (BYTE*)p;
				pTemp += nAlloc;
				for ( int i = 0; i < sizeof( ULONG ); i++ )
				{
					*pTemp = pData->bMemBound;
					pTemp++;
				}
#else
				BYTE* pTemp = (BYTE*)p;
				pTemp += nAlloc;
				memset( pTemp, pData->bMemBound, sizeof( ULONG ) );
#endif
			}
			else if ( pData->nTestFlags & DBG_TEST_MEM_REPORT )
			{
				DbgMemReportBlock* pBlock = (DbgMemReportBlock*)p;
				pBlock->pNext		= pFirstDbgReportBlock;
				pBlock->nSize		= nAlloc;
				pFirstDbgReportBlock= pBlock;
				pBlock++;
				p = (void*)pBlock;
			}
			else if ( pData->nTestFlags & DBG_TEST_MEM_LEAKREPORT )
			{
				DbgMemLeakBlock* pBlock = (DbgMemLeakBlock*)p;
				pBlock->pStackTree	= pStackTree;
				pBlock->nSize		= nAlloc;
				pBlock++;
				p = (void*)pBlock;
			}
		}

		MEM_SEMEND();

		return p;
	}

	return MemAlloc( nAlloc );
}

// -----------------------------------------------------------------------

static void* DbgMemFree( void* p )
{
	DbgData* pData = DbgGetData();

	if ( pData && (pData->nTestFlags & DBG_TEST_MEM_SPEZIAL) )
	{
		MEM_SEMSTART();

		ULONG nSize = 0;

		if ( pData->nTestFlags & DBG_TEST_MEM_NEWDEL )
			DbgImpCheckMemory( p );
		else if ( pData->nTestFlags & DBG_TEST_MEM_OVERWRITEFREE )
			DbgImpCheckAllFreeMemory();

		if ( (pData->nTestFlags & DBG_TEST_MEM_EXTRA) ||
			 ((pData->nTestFlags & DBG_TEST_MEM_ALLREPORT) == DBG_TEST_MEM_ALLREPORT) )
		{
			DbgMemBlock* pPrev = NULL;
			DbgMemBlock* pTemp = pFirstDbgBlock;
			while ( pTemp )
			{
				if ( p == (void*)(((BYTE*)pTemp)+sizeof( DbgMemBlock )) )
				{
					if ( !(pData->nTestFlags & DBG_TEST_MEM_NEWDEL) &&
						 (pData->nTestFlags & DBG_TEST_MEM_OVERWRITE) )
						DbgImpCheckBound( pTemp );

					if ( pPrev )
						pPrev->pNext = pTemp->pNext;
					else
						pFirstDbgBlock = pTemp->pNext;
					break;
				}

				pPrev = pTemp;
				pTemp = pTemp->pNext;
			}

			if ( !pTemp )
			{
				if ( pData->nTestFlags & DBG_TEST_MEM_POINTER )
					DbgMemError( DBG_MEMERR_UNKNOWN_PTR, p );
				return NULL;
			}

			DbgMemBlock* pBlock = (DbgMemBlock*)p;
			pBlock--;
			p = (void*)pBlock;
			nSize = pBlock->nSize;

			if ( pData->nTestFlags & DBG_TEST_MEM_LEAKREPORT )
				DbgFreeStackTree( pBlock->pStackTree, nSize );
		}
		else  if ( pData->nTestFlags & DBG_TEST_MEM_REPORT )
		{
			DbgMemReportBlock* pPrev = NULL;
			DbgMemReportBlock* pTemp = pFirstDbgReportBlock;
			while ( pTemp )
			{
				if ( p == (void*)(((BYTE*)pTemp)+sizeof( DbgMemReportBlock )) )
				{
					if ( pPrev )
						pPrev->pNext = pTemp->pNext;
					else
						pFirstDbgReportBlock = pTemp->pNext;
					break;
				}

				pPrev = pTemp;
				pTemp = pTemp->pNext;
			}

			if ( !pTemp )
			{
				if ( pData->nTestFlags & DBG_TEST_MEM_POINTER )
					DbgMemError( DBG_MEMERR_UNKNOWN_PTR, p );
				return NULL;
			}

			DbgMemReportBlock* pBlock = (DbgMemReportBlock*)p;
			pBlock--;
			p = (void*)pBlock;
			nSize = pBlock->nSize;
		}
		else  if ( pData->nTestFlags & DBG_TEST_MEM_LEAKREPORT )
		{
			DbgMemLeakBlock* pBlock = (DbgMemLeakBlock*)p;
			pBlock--;
			p = (void*)pBlock;
			nSize = pBlock->nSize;
			DbgFreeStackTree( pBlock->pStackTree, nSize );
		}

		if ( pData->nTestFlags & DBG_TEST_MEM_TRACE )
		{
			sal_Char aDbgOutBuf[20];
			strcpy( aDbgOutBuf, "Free: " );
			DbgTraceSize( aDbgOutBuf, nSize );
			DbgTrace( aDbgOutBuf );
		}

		nDbgCountFree++;
		nDbgAllFree += nSize;

		if ( pData->nTestFlags & DBG_TEST_MEM_REPORT )
		{
			if ( nSize < 5 )
				nDbgFreeLess5++;
			else if ( nSize < 9 )
				nDbgFreeLess9++;
			else if ( nSize < 13 )
				nDbgFreeLess13++;
			else if ( nSize < 17 )
				nDbgFreeLess17++;
			else if ( nSize < 25 )
				nDbgFreeLess25++;
			else if ( nSize < 33 )
				nDbgFreeLess33++;
			else if ( nSize < 49 )
				nDbgFreeLess49++;
			else if ( nSize < 65 )
				nDbgFreeLess65++;
			else if ( nSize < 257 )
				nDbgFreeLess257++;
			else if ( nSize < 513 )
				nDbgFreeLess513++;
			else if ( nSize < 1025 )
				nDbgFreeLess1025++;
			else if ( nSize < 4097 )
				nDbgFreeLess4097++;
			else if ( nSize < 8193 )
				nDbgFreeLess8193++;
			else if ( nSize < 32768 )
				nDbgFreeLess32769++;
			else
				nDbgFreeGreater32768++;
		}

		MEM_SEMEND();
	}

	return p;
}

// -----------------------------------------------------------------------

static void DbgMemAddFreeBlock( ULONG n )
{
	nDbgCountFreeBlock++;
	nDbgFreeBlockBytes += n;
	if ( nDbgCountFreeBlock > nDbgMaxCountFreeBlock )
	{
		nDbgMaxCountFreeBlock = nDbgCountFreeBlock;
		if ( nDbgFreeBlockBytes > nDbgMaxFreeBlockBytes )
			nDbgMaxFreeBlockBytes = nDbgFreeBlockBytes;
	}
}

// -----------------------------------------------------------------------

inline void DbgMemRemoveFreeBlock( ULONG n )
{
	nDbgCountFreeBlock--;
	nDbgFreeBlockBytes -= n;
}

// -----------------------------------------------------------------------

inline void DbgMemSearchFreeBlock()
{
	nDbgSearchFreeBlock++;
}

// -----------------------------------------------------------------------

static void* DbgSysMemAlloc( ULONG nAlloc )
{
	DbgData* pData = DbgGetData();

	if ( pData )
	{
		if ( pData->nTestFlags & DBG_TEST_MEM_REPORT )
		{
			nDbgCountSysAlloc++;
			nDbgAllSysAlloc += nAlloc;
			if ( nDbgAllSysAlloc-nDbgAllSysFree > nDbgMaxSysAlloc )
			{
				nDbgMaxCountSysAlloc = nDbgCountSysAlloc-nDbgCountSysFree;
				nDbgMaxSysAlloc = nDbgAllSysAlloc-nDbgAllSysFree;
			}

			ULONG nSize = nAlloc + sizeof( ULONG );
			void* p = AllocMemory( nSize );
			ULONG* pBlock = (ULONG*)p;
			*pBlock = nAlloc;
			p = (void*)(((BYTE*)p)+sizeof(ULONG));
			return p;
		}
	}

	return AllocMemory( nAlloc );
}

// -----------------------------------------------------------------------

static void DbgSysMemFree( void* p )
{
	DbgData* pData = DbgGetData();

	if ( pData )
	{
		if ( pData->nTestFlags & DBG_TEST_MEM_REPORT )
		{
			p = (void*)(((BYTE*)p)-sizeof(ULONG));
			ULONG nAlloc = *((ULONG*)p);
			nDbgCountSysFree++;
			nDbgAllSysFree += nAlloc;
		}
	}

	FreeMemory( p );
}

// -----------------------------------------------------------------------

void DbgImpMemoryInfo( sal_Char* pBuf )
{
	DbgData* pData = DbgGetData();

	if ( pData )
	{
		if ( (pData->nTestFlags & DBG_TEST_MEM_REPORT) && nDbgCountAlloc )
		{
			ULONG nAvg;
			ULONG nPercentCount = nDbgCountAlloc-nDbgCountFree;
			if ( !nPercentCount )
				nPercentCount = 0xFFFFFFFF;
			ImpDbgOutfBuf( pBuf, "------------------------------------------------------------------------------" );
			ImpDbgOutfBuf( pBuf, "Memory Report" );
			ImpDbgOutfBuf( pBuf, "------------------------------------------------------------------------------" );
			ImpDbgOutfBuf( pBuf, "         < 5 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess5, nDbgLess5*100/nDbgCountAlloc, (nDbgLess5-nDbgFreeLess5), (nDbgLess5-nDbgFreeLess5)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "   5 -     8 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess9, nDbgLess9*100/nDbgCountAlloc, (nDbgLess9-nDbgFreeLess9), (nDbgLess9-nDbgFreeLess9)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "   9 -    12 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess13, nDbgLess13*100/nDbgCountAlloc, (nDbgLess13-nDbgFreeLess13), (nDbgLess13-nDbgFreeLess13)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "  13 -    16 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess17, nDbgLess17*100/nDbgCountAlloc, (nDbgLess17-nDbgFreeLess17), (nDbgLess17-nDbgFreeLess17)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "  17 -    24 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess25, nDbgLess25*100/nDbgCountAlloc, (nDbgLess25-nDbgFreeLess25), (nDbgLess25-nDbgFreeLess25)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "  25 -    32 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess33, nDbgLess33*100/nDbgCountAlloc, (nDbgLess33-nDbgFreeLess33), (nDbgLess33-nDbgFreeLess33)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "  33 -    48 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess49, nDbgLess49*100/nDbgCountAlloc, (nDbgLess49-nDbgFreeLess49), (nDbgLess49-nDbgFreeLess49)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "  49 -    64 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess65, nDbgLess65*100/nDbgCountAlloc, (nDbgLess65-nDbgFreeLess65), (nDbgLess65-nDbgFreeLess65)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "  65 -   256 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess257, nDbgLess257*100/nDbgCountAlloc, (nDbgLess257-nDbgFreeLess257), (nDbgLess257-nDbgFreeLess257)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, " 257 -   512 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess513, nDbgLess513*100/nDbgCountAlloc, (nDbgLess513-nDbgFreeLess513), (nDbgLess513-nDbgFreeLess513)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, " 512 -  1024 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess1025, nDbgLess1025*100/nDbgCountAlloc, (nDbgLess1025-nDbgFreeLess1025), (nDbgLess1025-nDbgFreeLess1025)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "1025 -  4096 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess4097, nDbgLess4097*100/nDbgCountAlloc, (nDbgLess4097-nDbgFreeLess4097), (nDbgLess4097-nDbgFreeLess4097)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "4097 -  8192 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess8193, nDbgLess8193*100/nDbgCountAlloc, (nDbgLess8193-nDbgFreeLess8193), (nDbgLess8193-nDbgFreeLess8193)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "8193 - 32768 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess32769, nDbgLess32769*100/nDbgCountAlloc, (nDbgLess32769-nDbgFreeLess32769), (nDbgLess32769-nDbgFreeLess32769)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "     > 32768 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgGreater32768, nDbgGreater32768*100/nDbgCountAlloc, (nDbgGreater32768-nDbgGreater32768), (nDbgGreater32768-nDbgGreater32768)*100/nPercentCount );
			ImpDbgOutfBuf( pBuf, "Largest in Bytes:   %10lu", nDbgMaxBlock );
			ImpDbgOutfBuf( pBuf, "------------------------------------------------------------------------------" );
			nAvg = nDbgSearchFreeBlock / nDbgCountAlloc;
			ImpDbgOutfBuf( pBuf, "Search:   %10lu     Avg.:  %10lu", nDbgSearchFreeBlock, nAvg );
			if ( nDbgMaxCountFreeBlock )
				nAvg = nDbgMaxFreeBlockBytes / nDbgMaxCountFreeBlock;
			else
				nAvg = 0;
			ImpDbgOutfBuf( pBuf, "MaxFree:  %10lu     Bytes: %10lu     Avg: %lu", nDbgMaxCountFreeBlock, nDbgMaxFreeBlockBytes, nAvg );
			if ( nDbgCountFreeBlock )
				nAvg = nDbgFreeBlockBytes / nDbgCountFreeBlock;
			else
				nAvg = 0;
			ImpDbgOutfBuf( pBuf, "CurFree:  %10lu     Bytes: %10lu     Avg: %lu", nDbgCountFreeBlock, nDbgFreeBlockBytes, nAvg );
			ImpDbgOutfBuf( pBuf, "Overhead: %9lu%%     Bytes: %10lu", nDbgMaxOverheadPercent, nDbgMaxOverhead );
			ImpDbgOutfBuf( pBuf, "------------------------------------------------------------------------------" );
			nAvg = nDbgAllSysAlloc / nDbgCountSysAlloc;
			ImpDbgOutfBuf( pBuf, "SysAlloc: %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountSysAlloc, nDbgAllSysAlloc, nAvg );
			if ( nDbgCountSysFree )
				nAvg = nDbgAllSysFree / nDbgCountSysFree;
			else
				nAvg = 0;
			ImpDbgOutfBuf( pBuf, "SysFree:  %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountSysFree, nDbgAllSysFree, nAvg );
			nAvg = nDbgMaxSysAlloc / nDbgMaxCountSysAlloc;
			ImpDbgOutfBuf( pBuf, "SysMax:   %10lu     Bytes: %10lu     Avg.: %lu", nDbgMaxCountSysAlloc, nDbgMaxSysAlloc, nAvg );
			if ( nDbgAllSysAlloc != nDbgAllSysFree )
			{
				nAvg = (nDbgAllSysAlloc-nDbgAllSysFree) / (nDbgCountSysAlloc-nDbgCountSysFree);
				ImpDbgOutfBuf( pBuf, "SysCur:   %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountSysAlloc-nDbgCountSysFree, nDbgAllSysAlloc-nDbgAllSysFree, nAvg );
			}
			ImpDbgOutfBuf( pBuf, "------------------------------------------------------------------------------" );
			nAvg = nDbgAllAlloc / nDbgCountAlloc;
			ImpDbgOutfBuf( pBuf, "Alloc:    %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountAlloc, nDbgAllAlloc, nAvg );
			if ( nDbgCountFree )
				nAvg = nDbgAllFree / nDbgCountFree;
			else
				nAvg = 0;
			ImpDbgOutfBuf( pBuf, "Free:     %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountFree, nDbgAllFree, nAvg );
			nAvg = nDbgMaxAlloc / nDbgMaxCountAlloc;
			ImpDbgOutfBuf( pBuf, "Max:      %10lu     Bytes: %10lu     Avg.: %lu", nDbgMaxCountAlloc, nDbgMaxAlloc, nAvg );
			if ( nDbgAllAlloc != nDbgAllFree )
				nAvg = (nDbgAllAlloc-nDbgAllFree) / (nDbgCountAlloc-nDbgCountFree);
			else
				nAvg = 0;
			ImpDbgOutfBuf( pBuf, "Cur:      %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountAlloc-nDbgCountFree, nDbgAllAlloc-nDbgAllFree, nAvg );
			ImpDbgOutfBuf( pBuf, "------------------------------------------------------------------------------" );
			ImpDbgOutfBuf( pBuf, "" );
		}
	}
}

// -----------------------------------------------------------------------

void DbgImpCheckMemoryDeInit()
{
	DbgData* pData = DbgGetData();

	if ( pData )
	{
		if ( (pData->nTestFlags & DBG_TEST_MEM_REPORT) && nDbgCountAlloc )
		{
			ULONG nAvg;
			ULONG nPercentCount = nDbgCountAlloc-nDbgCountFree;
			if ( !nPercentCount )
				nPercentCount = 0xFFFFFFFF;
			DbgOutf( "------------------------------------------------------------------------------" );
			DbgOutf( "Memory Report" );
			DbgOutf( "------------------------------------------------------------------------------" );
			DbgOutf( "         < 5 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess5, nDbgLess5*100/nDbgCountAlloc, (nDbgLess5-nDbgFreeLess5), (nDbgLess5-nDbgFreeLess5)*100/nPercentCount );
			DbgOutf( "   5 -     8 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess9, nDbgLess9*100/nDbgCountAlloc, (nDbgLess9-nDbgFreeLess9), (nDbgLess9-nDbgFreeLess9)*100/nPercentCount );
			DbgOutf( "   9 -    12 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess13, nDbgLess13*100/nDbgCountAlloc, (nDbgLess13-nDbgFreeLess13), (nDbgLess13-nDbgFreeLess13)*100/nPercentCount );
			DbgOutf( "  13 -    16 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess17, nDbgLess17*100/nDbgCountAlloc, (nDbgLess17-nDbgFreeLess17), (nDbgLess17-nDbgFreeLess17)*100/nPercentCount );
			DbgOutf( "  17 -    24 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess25, nDbgLess25*100/nDbgCountAlloc, (nDbgLess25-nDbgFreeLess25), (nDbgLess25-nDbgFreeLess25)*100/nPercentCount );
			DbgOutf( "  25 -    32 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess33, nDbgLess33*100/nDbgCountAlloc, (nDbgLess33-nDbgFreeLess33), (nDbgLess33-nDbgFreeLess33)*100/nPercentCount );
			DbgOutf( "  33 -    48 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess49, nDbgLess49*100/nDbgCountAlloc, (nDbgLess49-nDbgFreeLess49), (nDbgLess49-nDbgFreeLess49)*100/nPercentCount );
			DbgOutf( "  49 -    64 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess65, nDbgLess65*100/nDbgCountAlloc, (nDbgLess65-nDbgFreeLess65), (nDbgLess65-nDbgFreeLess65)*100/nPercentCount );
			DbgOutf( "  65 -   256 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess257, nDbgLess257*100/nDbgCountAlloc, (nDbgLess257-nDbgFreeLess257), (nDbgLess257-nDbgFreeLess257)*100/nPercentCount );
			DbgOutf( " 257 -   512 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess513, nDbgLess513*100/nDbgCountAlloc, (nDbgLess513-nDbgFreeLess513), (nDbgLess513-nDbgFreeLess513)*100/nPercentCount );
			DbgOutf( " 512 -  1024 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess1025, nDbgLess1025*100/nDbgCountAlloc, (nDbgLess1025-nDbgFreeLess1025), (nDbgLess1025-nDbgFreeLess1025)*100/nPercentCount );
			DbgOutf( "1025 -  4096 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess4097, nDbgLess4097*100/nDbgCountAlloc, (nDbgLess4097-nDbgFreeLess4097), (nDbgLess4097-nDbgFreeLess4097)*100/nPercentCount );
			DbgOutf( "4097 -  8192 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess8193, nDbgLess8193*100/nDbgCountAlloc, (nDbgLess8193-nDbgFreeLess8193), (nDbgLess8193-nDbgFreeLess8193)*100/nPercentCount );
			DbgOutf( "8193 - 32768 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgLess32769, nDbgLess32769*100/nDbgCountAlloc, (nDbgLess32769-nDbgFreeLess32769), (nDbgLess32769-nDbgFreeLess32769)*100/nPercentCount );
			DbgOutf( "     > 32768 Bytes: %10lu (%3lu%%)     [%10lu (%3lu%%)]", nDbgGreater32768, nDbgGreater32768*100/nDbgCountAlloc, (nDbgGreater32768-nDbgGreater32768), (nDbgGreater32768-nDbgGreater32768)*100/nPercentCount );
			DbgOutf( "Largest in Bytes:   %10lu", nDbgMaxBlock );
			DbgOutf( "------------------------------------------------------------------------------" );
			nAvg = nDbgSearchFreeBlock / nDbgCountAlloc;
			DbgOutf( "Search:   %10lu     Avg.:  %10lu", nDbgSearchFreeBlock, nAvg );
			if ( nDbgMaxCountFreeBlock )
				nAvg = nDbgMaxFreeBlockBytes / nDbgMaxCountFreeBlock;
			else
				nAvg = 0;
			DbgOutf( "MaxFree:  %10lu     Bytes: %10lu     Avg: %lu", nDbgMaxCountFreeBlock, nDbgMaxFreeBlockBytes, nAvg );
			if ( nDbgCountFreeBlock )
				nAvg = nDbgFreeBlockBytes / nDbgCountFreeBlock;
			else
				nAvg = 0;
			DbgOutf( "Overhead: %9lu%%     Bytes: %10lu", nDbgMaxOverheadPercent, nDbgMaxOverhead );
			DbgOutf( "------------------------------------------------------------------------------" );
			nAvg = nDbgAllSysAlloc / nDbgCountSysAlloc;
			DbgOutf( "SysAlloc: %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountSysAlloc, nDbgAllSysAlloc, nAvg );
			if ( nDbgCountSysFree )
				nAvg = nDbgAllSysFree / nDbgCountSysFree;
			else
				nAvg = 0;
			DbgOutf( "SysFree:  %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountSysFree, nDbgAllSysFree, nAvg );
			nAvg = nDbgMaxSysAlloc / nDbgMaxCountSysAlloc;
			DbgOutf( "SysMax:   %10lu     Bytes: %10lu     Avg.: %lu", nDbgMaxCountSysAlloc, nDbgMaxSysAlloc, nAvg );
			if ( nDbgAllSysAlloc != nDbgAllSysFree )
			{
				nAvg = (nDbgAllSysAlloc-nDbgAllSysFree) / (nDbgCountSysAlloc-nDbgCountSysFree);
				DbgOutf( "SysLeaks: %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountSysAlloc-nDbgCountSysFree, nDbgAllSysAlloc-nDbgAllSysFree, nAvg );
			}
			DbgOutf( "------------------------------------------------------------------------------" );
			nAvg = nDbgAllAlloc / nDbgCountAlloc;
			DbgOutf( "Alloc:    %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountAlloc, nDbgAllAlloc, nAvg );
			if ( nDbgCountFree )
				nAvg = nDbgAllFree / nDbgCountFree;
			else
				nAvg = 0;
			DbgOutf( "Free:     %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountFree, nDbgAllFree, nAvg );
			nAvg = nDbgMaxAlloc / nDbgMaxCountAlloc;
			DbgOutf( "Max:      %10lu     Bytes: %10lu     Avg.: %lu", nDbgMaxCountAlloc, nDbgMaxAlloc, nAvg );
			DbgOutf( "------------------------------------------------------------------------------" );
			if ( nDbgCountFree < nDbgCountAlloc )
			{
				nAvg = (nDbgAllAlloc-nDbgAllFree) / (nDbgCountAlloc-nDbgCountFree);
				DbgOutf( "Leaks:    %10lu     Bytes: %10lu     Avg.: %lu", nDbgCountAlloc-nDbgCountFree, nDbgAllAlloc-nDbgAllFree, nAvg );
				DbgOutf( "------------------------------------------------------------------------------" );
				// Nicht freigegebene Speicherbloecke ausgeben
				if ( (pData->nTestFlags & DBG_TEST_MEM_EXTRA) ||
					 ((pData->nTestFlags & DBG_TEST_MEM_ALLREPORT) == DBG_TEST_MEM_ALLREPORT) )
				{
					DbgMemBlock* pBlock = pFirstDbgBlock;
					while ( pBlock )
					{
						DbgOutf( "%10lu", pBlock->nSize );
						pBlock = pBlock->pNext;
					}
				}
				else
				{
					DbgMemReportBlock* pBlock = pFirstDbgReportBlock;
					while ( pBlock )
					{
						DbgOutf( "%10lu", pBlock->nSize );
						pBlock = pBlock->pNext;
					}
				}
				DbgOutf( "------------------------------------------------------------------------------" );
			}
		}
	}
}

// =======================================================================

#else

#define DBG_MEM_ALLOC( n )			MemAlloc( n )
#define DBG_MEM_FREE( p )
#define DBG_MEM_SYSALLOC( n )		AllocMemory( n )
#define DBG_MEM_SYSFREE( p )		FreeMemory( p )
#define DBG_MEM_INIT( p, n, bFree )
#define DBG_MEM_FREESET( p, n )
#define DBG_MEM_ADDFREEBLOCK( n )
#define DBG_MEM_REMOVEFREEBLOCK( n )
#define DBG_MEM_SEARCHFREEBLOCK()

#endif
