/*************************************************************************
 *
 *  $RCSfile: intnunx.cxx,v $
 *
 *  $Revision: 1.7.12.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 19:05:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdlib.h>  // for getenv()
#include <stdio.h>

#ifndef _STRING_HXX
#include <string.hxx>
#endif
#ifndef _INTNTAB_HXX
#include <intntab.hxx>
#endif
#ifndef _ISOLANG_HXX
#include <isolang.hxx>
#endif

#ifdef MACOSX
#ifndef _OSL_PROCESS_H_
#include <osl/process.h>
#endif
#ifndef _RTL_LOCALE_H_
#include <rtl/locale.h>
#endif
#endif

// =======================================================================

static LanguageType eImplSystemLanguage = LANGUAGE_DONTKNOW;

// =======================================================================

void SetSystemLanguage( LanguageType eLang )
{
    eImplSystemLanguage = eLang;
}

// =======================================================================

USHORT ImplGetSystemLanguageCount()
{
    return 0;
}

// -----------------------------------------------------------------------

// Get locale of category LC_CTYPE of environment variables
static sal_Char* GetLangFromEnvironment()
{
    static sal_Char* pFallback = "C";
    sal_Char *pLang = NULL;

    pLang = getenv ( "LC_ALL" );
    if (! pLang)
        pLang = getenv ( "LC_CTYPE" );
    if (! pLang)
        pLang = getenv( "LANG" );
    if (! pLang)
        pLang = pFallback;

    return pLang;
}

// -----------------------------------------------------------------------

// Get locale of category LC_MESSAGES of environment variables
static sal_Char* GetUILangFromEnvironment()
{
    static sal_Char* pFallback = "C";
    sal_Char *pLang = NULL;

    pLang = getenv ( "LANGUAGE" );      // respect the GNU extension
    if (! pLang)
        pLang = getenv ( "LC_ALL" );
    if (! pLang)
        pLang = getenv ( "LC_MESSAGES" );
    if (! pLang)
        pLang = getenv( "LANG" );
    if (! pLang)
        pLang = pFallback;

    return pLang;
}

// -----------------------------------------------------------------------

LanguageType GetSystemLanguage( USHORT nIndex )
{
    /* get the language from the user environment */
    if (nIndex == INTERNATIONAL_SYSTEM_DEFAULT)
    {
        if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
        {
#ifdef MACOSX
            rtl_Locale    *procLocale;
            
            if ( osl_getProcessLocale(&procLocale) == osl_Process_E_None )
            {
                UniString     rLang( procLocale->Language->buffer );
                UniString     rCountry( procLocale->Country->buffer );
            
                eImplSystemLanguage = ConvertIsoNamesToLanguage( rLang, rCountry );
#ifdef DEBUG
                if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
                    fprintf( stderr, "intnunx.cxx:  failed to convert osl_getProcessLocale() language to system language.\n" );
#endif
            }
#else   /* MACOSX */
            ByteString aUnxLang (GetLangFromEnvironment());
            eImplSystemLanguage = ConvertUnxByteStringToLanguage( aUnxLang );
#endif  /* MACOSX */
        }
        return eImplSystemLanguage;
    }

    return LANGUAGE_DONTKNOW;
}

// -----------------------------------------------------------------------

LanguageType GetSystemUILanguage( USHORT nIndex )
{
    /* get the language from the user environment */
    if (nIndex == INTERNATIONAL_SYSTEM_DEFAULT)
    {
        if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
        {
#ifdef MACOSX
            rtl_Locale    *procLocale;
            
            if ( osl_getProcessLocale(&procLocale) == osl_Process_E_None )
            {
                UniString     rLang( procLocale->Language->buffer );
                UniString     rCountry( procLocale->Country->buffer );
            
                eImplSystemLanguage = ConvertIsoNamesToLanguage( rLang, rCountry );
#ifdef DEBUG
                if ( eImplSystemLanguage == LANGUAGE_DONTKNOW )
                    fprintf( stderr, "intnunx.cxx:  failed to convert osl_getProcessLocale() language to system language.\n" );
#endif
            }
#else   /* MACOSX */
            ByteString aUnxLang (GetUILangFromEnvironment());
            eImplSystemLanguage = ConvertUnxByteStringToLanguage( aUnxLang );
#endif  /* MACOSX */
        }
        return eImplSystemLanguage;
    }

    return LANGUAGE_DONTKNOW;
}

// =======================================================================

void ImplUpdateSystemLanguage( LanguageType, LanguageTable* )
{
}

// =======================================================================

USHORT ImplGetSystemFormatCount()
{
    return 0;
}

// -----------------------------------------------------------------------

LanguageType GetSystemFormatLanguage( USHORT nIndex )
{
    return GetSystemLanguage( nIndex );
}

// -----------------------------------------------------------------------

void ImplUpdateSystemFormat( LanguageType, FormatTable* )
{
}
