/*************************************************************************
 *
 *  $RCSfile: updmake.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: nf $ $Date: 2001/02/15 15:20:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _UPDMAKE_HXX
#define _UPDMAKE_HXX

#include "string.hxx"
#include "list.hxx"

class SvFileStream;
class Star;
class GenericInformationList;

//
// class UPDDependencies
//

/******************************************************************************
* Purpose: handles dependencies of an directory
******************************************************************************/

class UPDDependencies : public ByteString
{
private:
	ByteString sLogName;
	ByteString sDependencies;

public:
	UPDDependencies( ByteString &rDir, ByteString &rLog );

	ByteString &GetDependencies() { return sDependencies; }
	USHORT GetDependCount() { return sDependencies.GetTokenCount(); }

	void AddDepend( ByteString &rDpc );
	BOOL RemoveDepend( ByteString &rDpc );

	ByteString &GetLogFile() { return sLogName; }
};

//
// class UPDDirectory
//

/******************************************************************************
* Purpose: holds path of an dir an handles building that dir
******************************************************************************/

class UPDDirectory : public ByteString
{
private:
	ByteString sMakeCommand;

protected:
	virtual void PrintStatus( const char * cStatus ) {};

public:
	UPDDirectory( const ByteString &rDir , const ByteString &rCommand );

	void SetMakeCommand( ByteString &rMakeCommand )
		{ sMakeCommand = rMakeCommand; }
	BOOL Build( ByteString &rSwitches );
};

DECLARE_LIST( DependenciesList, UPDDependencies * );
DECLARE_LIST( DirectoryList, UPDDirectory * );

//
// class UPDMake
//

/******************************************************************************
* Purpose: handles building a StarDivision project
******************************************************************************/

class UPDMake : public DirectoryList
{
private:
	USHORT nErrorCode;
	ByteString sPathAdd;
	ByteString sMakeCommand;
	ByteString sFileName;
    ByteString sProject;
    ByteString sWorkStamp;
	BOOL   bGetProjectFromCvs;  	/// Default is FALSE.

protected:
	virtual void PrintStatus( const char * cStatus ) {};

public:
						UPDMake(
							const ByteString &rProject,
							const ByteString &rWorkStamp,
							const ByteString &rMakeCommand,
							const ByteString &rFileName,
							Star *pStar = 0 );
	void				Set_GetProjectFromCvs(
							BOOL i_bDoGet );
						~UPDMake();

	USHORT 				GetErrorCode()
							{ return nErrorCode; }

	BOOL   				WriteScript(
							ByteString &rSwitches );
	void 				WriteScriptInto(				/// @descr writes as second last line: "cd <projroot></>prj ", last line is "<on error exit>".
							SvFileStream &o_rBatchFile,	/// Has to be open and won't be closed .
							const ByteString &i_rSwitches );

	USHORT              Build();

//	static USHORT	 	GetLocalSolarListPath(
//							ByteString &o_rLocalSolarlistPath,
//							const ByteString &i_sWorkstamp);
	static USHORT 		GetStar( Star **pStar, const ByteString &rVersion, BOOL bRecursive = FALSE, GenericInformationList *pStandLst = NULL );
};

inline void
UPDMake::Set_GetProjectFromCvs( BOOL i_bDoGet )
	{ bGetProjectFromCvs = i_bDoGet; }

#endif
