/*************************************************************************
 *
 *  $RCSfile: uu.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

typedef unsigned char  uchar;

#define OFF      0
#define ON       ~OFF

int uu_init();
int decode_line (char *indata, char *outdata);
int decode_cell (char *indata, char *outdata);
int encode_line (uchar *indata, uchar *outdata, int bytes_in);
int encode_cell (uchar *indata, uchar *outdata);
int build_table (void);
void build_uu_chars (void);

uchar  xx_chars[] = "+-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
uchar  uu_chars[65];
uchar *char_set = uu_chars,
       table[128];

int       xx_set = OFF;
int ext_set = OFF;

int uu_init()
{
   if (xx_set)
      char_set = xx_chars;
   build_uu_chars ();
   build_table ();

   return 0;
}

encode_line (indata, outdata, bytes_in)
uchar *indata;
uchar *outdata;
int   bytes_in;
{
   int     bytes_out = 0,
           i;

   *outdata++ = char_set[bytes_in];      /* Encode the line length          */

   for (i = 0; i < bytes_in; i += 3)     /* Encode the data line, 1 cell at */
   {                                     /* a time, until all done.         */
      encode_cell (indata, outdata);     /* This is what actually does the  */
      indata += 3;                       /* encoding of each cell!          */
      outdata += 4;                      /* increment all pointers and the  */
      bytes_out += 4;                    /* number of output bytes.         */
   }

   *outdata++ = '\n';                    /* terminate the line with a LF    */ 

   return bytes_out + 2;                 /* bytes_out + 1(count) + 1(LF)    */ 
}


encode_cell (indata, outdata)
uchar  *indata;
uchar  *outdata;
{

/* This is just a simple table look-up into the table created earlier. */

   outdata[0] = char_set [((indata[0] >> 2) & 63)];
   outdata[1] = char_set [(((indata[0] << 4) | (indata[1] >> 4)) & 63)];
   outdata[2] = char_set [(((indata[1] << 2) | (indata[2] >> 6)) & 63)];
   outdata[3] = char_set [(indata[2] & 63)];

   return 0;
}


int decode_line (indata, outdata)
char  *indata;
char  *outdata;
{
   int     num_bytes,
           i;
   char   *dataptr;

   dataptr = outdata;

   /* decode the number of bytes to be output..again, see the long commen at
    * the end of the source module.
    */

   num_bytes = table [*indata];

   indata++;                               /* advance past the counter byte */
   for (i = 0; i < num_bytes; i += 3)      /* loop over output byte count   */
   {                                       /* Next line does the work.      */
      decode_cell (indata, dataptr);
      indata += 4;                         /* increment pointers & counters */
      dataptr += 3;
   }

   return num_bytes;
}


int decode_cell (indata, outdata)
char   *indata;
char   *outdata;
{
   int    i;
   char  *iptr,
          ochar;

   /* see the big comment at the end. */

   iptr = indata;
   for (i = 0; i < 4; i++)
   {
      ochar = table[*iptr];
      if (ochar > 64)
      {
         printf ("\nFile corrupted!  Bad data on line %i: %c",
                    i, *iptr);
         //curses_refresh ();
         return -1;
      }
      else
         *iptr = table[*iptr];
      iptr++;
   }

   outdata[0] = (indata[0] << 2) | (indata[1] >> 4);
   outdata[1] = (indata[1] << 4) | (indata[2] >> 2);
   outdata[2] = (indata[2] << 6) | indata[3];
   outdata[3] = '\0';

   return 0;
}



int build_table ()
{
   char  *ptr;
   int    i,
          entry;

   ptr = (char *)table;           /* clear table */
   for (i = 0; i < 128; i++)
     *(ptr++) = 127;

   ptr = (char *) char_set;       /* fill table */
   for (i = 0; i < 64; i++)
   {
      entry = *(ptr++) & 127;
      if (table [entry] != 127)
         return -1;
      table [entry] = i;
   }

   if (!(xx_set || ext_set))      /* i.e. we're using the standard 'uu' set */
      table[' '] = 0;             /* make it decode ' ' the same as `       */

   return 0;
}


void build_uu_chars ()
{
   int i;

   for (i = 0; i < 64; i++)
     uu_chars [i] = i + 32;

   uu_chars[0] = 96;      /* use ` instead of space */

   return;
}


