#!/bin/sh

# check for command line parameters
# FIXME: temporarily increased number of valid parameters to 5
if [ $# -lt 3 -o $# -gt 5 ]; then
  echo "Usage: $0 <office_inst_path> <singleproductname> <productversion> <default_language>"
  echo "Usage: $0 -remove <singleproductname> <productversion>"
  exit 1
fi

# remove all files of this product in types
if [ -d $HOME/.dt/types ]; then
  rm -f "$HOME/.dt/types/$2_$3_"* 2>/dev/null
  
  # remove vnd. files that contain product name
  for SOURCE in `grep -l "$2_$3" $HOME/.dt/types/* 2>/dev/null`; do
    rm -f $SOURCE
  done  

  # remove all files in fp_dynamic sub-dir that contain product name 
  # - the user may have deleted the panel entry manually.
  for SOURCE in `grep -l "$2_$3" $HOME/.dt/types/fp_dynamic/* 2>/dev/null`; do
    rm -f $SOURCE
  done  
fi

# remove all files of this product in icons
if [ -d $HOME/.dt/icons ]; then
  rm -f "$HOME/.dt/icons/$2_$3_*" 2>/dev/null
fi

# check if only remove should be done
if [ "$1" = "-remove" ]; then
    exit 0
fi

# get locale from environment
if [ $LC_ALL ]; then 
  LOCALE=$LC_ALL
elif [ $LC_CTYPE ]; then 
  LOCALE=$LC_CTYPE
elif [ $LANG ]; then 
  LOCALE=$LANG
else
  LOCALE="C"
fi

if [ "$LOCALE" = "C" ]; then
    # forth parameter should be the default locale of the office installation
  echo "$0: locale not set - defaulting to $4."
  LOCALE=$4
elif [ ! -d "$1/share/cde/types/$LOCALE" ]; then 
  CHARSET=`echo $LOCALE | sed "s/.*\././"`

  # extract charset  
  if [ "$LOCALE" = "$CHARSET" ]; then
    CHARSET=""
  fi

  # extract language
  LANGUAGE=`echo $LOCALE | sed "s/_.*//"` 
  
  if [ -d "$1/share/cde/types/$LANGUAGE$CHARSET" ]; then
#    echo "$0: files for locale $LOCALE not installed - defaulting to $LANGUAGE$CHARSET."
    LOCALE=$LANGUAGE$CHARSET
  elif [ -d "$1/share/cde/types/$LANGUAGE" ]; then
#    echo "$0: files for locale $LOCALE not installed - defaulting to $LANGUAGE."
    LOCALE=$LANGUAGE
  else
#    echo "$0: files for locale $LOCALE not installed - defaulting to $4."
    LOCALE=$4
  fi
fi

# check if a least this directory exists
if [ ! -d "$1/share/cde/types/$LOCALE" ]; then 
  echo "$0: installation error: $1/share/cde/types/$LOCALE not found."
  exit 1
fi

# append resource to $HOME/.Xdefaults if necessary
# to install reasonable TRANSIEN_FOR behaviour
resline="Dtwm*VCLSalFrame*secondariesOnTop: True"
fgrep "$resline" $HOME/.Xdefaults >/dev/null 2>&1
if [ $? != 0 ]; then
    echo "$resline" >>$HOME/.Xdefaults
fi

# assume a global CDE integration already available
# if $1/dt/appconfig/types/$LOCALE exists
if [ -d "$1/dt/appconfig/types/$LOCALE" ]; then
  exit 0;
fi

# create $HOME/.dt/types if necessary
if [ ! -d $HOME/.dt/types ]; then
  mkdir -p $HOME/.dt/types;
fi

# create $HOME/.dt/icons if necessary
if [ ! -d $HOME/.dt/icons ]; then
  mkdir $HOME/.dt/icons;
fi

# copy language specific types files
cp "$1/share/cde/types/$LOCALE/group.fp" $HOME/.dt/types/$2_$3_group.fp
cp "$1/share/cde/types/$LOCALE/group.dt" $HOME/.dt/types/$2_$3_group.dt

for SOURCE in writer calc draw impress math; do
  if [ -f "$1/share/cde/types/$LOCALE/$SOURCE.fp" ]; then
    cp "$1/share/cde/types/$LOCALE/$SOURCE.fp" $HOME/.dt/types/$2_$3_$SOURCE.fp
    cp "$1/share/cde/types/$LOCALE/$SOURCE.dt" $HOME/.dt/types/$2_$3_$SOURCE.dt
    cp "$1/share/cde/types/$LOCALE/vnd.stardivision.$SOURCE.dt" $HOME/.dt/types/
    cp "$1/share/cde/types/$LOCALE/vnd.sun.xml.$SOURCE.dt" $HOME/.dt/types/
    
    if [ "$SOURCE" = "writer" ]; then
      cp "$1/share/cde/types/$LOCALE/vnd.stardivision.writer-global.dt" $HOME/.dt/types/
      cp "$1/share/cde/types/$LOCALE/vnd.sun.xml.writer.global.dt" $HOME/.dt/types/
      cp "$1/share/cde/types/$LOCALE/ms-word.dt" $HOME/.dt/types/
      cp "$1/share/cde/types/$LOCALE/richtext.dt" $HOME/.dt/types/

    elif [ "$SOURCE" = "calc" ]; then
      cp "$1/share/cde/types/$LOCALE/vnd.stardivision.chart.dt" $HOME/.dt/types/
      cp "$1/share/cde/types/$LOCALE/ms-excel.dt" $HOME/.dt/types/

    elif [ "$SOURCE" = "impress" ]; then
      cp "$1/share/cde/types/$LOCALE/ms-powerpoint.dt" $HOME/.dt/types/

    elif [ "$SOURCE" = "math" ]; then
      cp "$1/share/cde/types/$LOCALE/vnd.stardivision.math.dt" $HOME/.dt/types/
      cp "$1/share/cde/types/$LOCALE/vnd.sun.xml.math.dt" $HOME/.dt/types/
    fi
  fi
done

# copy icons files if necessary, assume icons are globaly available 
# if $1/dt/appconfig/icons exists
if [ ! -d $1/dt/appconfig/icons/C ]; then
  for SOURCE in `ls "$1/share/cde/icons"`; do
    ICON=`echo $SOURCE | sed "s/.xpm/.pm/"`
    cp "$1/share/cde/icons/$SOURCE" "$HOME/.dt/icons/$2_$3_$ICON"
  done
fi

# the following tests are necessary to supress any error message
# caused by calling dtaction from a X server not running CDE or
# not running on the same machine

# check if dtaction is accessible
if [ ! -x /usr/dt/bin/dtaction ]; then
  exit 0
fi

# check if cde currently running and if it is running locally
# Fixme: is there another way to detect rlogin -l ??
if [ -x /usr/bin/X11/xlsatoms ]; then
CDE_RUNNING=`/usr/bin/X11/xlsatoms | grep _DT_WM_READY 2>/dev/null`
elif [ -x /usr/openwin/bin/xlsatoms ]; then
CDE_RUNNING=`/usr/openwin/bin/xlsatoms | grep _DT_WM_READY 2>/dev/null`
else
  exit 0
fi

# have to destinguish between linux and solaris here
if [ -f /usr/bin/whoami ]; then
  CDE_USER=`/usr/bin/whoami`
elif [ -f /usr/ucb/whoami ]; then
  CDE_USER=`/usr/ucb/whoami`
else
  exit 0
fi

CDE_LOCAL=`ps -ef | grep $CDE_USER | grep dtwm | grep -v grep`
if [ -n "$CDE_RUNNING" ] && [ -n "$CDE_LOCAL" ]; then
    /usr/dt/bin/dtaction ReloadActions 2>&1 >/dev/null
fi
