/*************************************************************************
 *
 *  $RCSfile: actctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/06/30 15:55:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop


#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#include "actctrl.hxx"



void NumEditAction::Action()
{
	aActionLink.Call( this );
}


long NumEditAction::Notify( NotifyEvent& rNEvt )
{
	long nHandled = 0;

	if ( rNEvt.GetType() == EVENT_KEYINPUT )
	{
		const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
		const KeyCode aKeyCode = pKEvt->GetKeyCode();
		const USHORT nModifier = aKeyCode.GetModifier();
		if( aKeyCode.GetCode() == KEY_RETURN &&
				!nModifier)
		{
			Action();
			nHandled = 1;
		}

	}
	if(!nHandled)
		NumericField::Notify( rNEvt );
	return nHandled;
}

/*------------------------------------------------------------------------
 Beschreibung:	KeyInput fuer ShortName - Edits ohne Spaces
------------------------------------------------------------------------*/


void NoSpaceEdit::KeyInput(const KeyEvent& rEvt)
{
	BOOL bCallParent = TRUE;
	if(rEvt.GetCharCode())
	{
		String sKey = rEvt.GetCharCode();
		if(	STRING_NOTFOUND != sForbiddenChars.Search(sKey))
			bCallParent = FALSE;
	}
	if(bCallParent)
		Edit::KeyInput(rEvt);
}
/* -----------------------------11.02.00 15:28--------------------------------

 ---------------------------------------------------------------------------*/
void NoSpaceEdit::Modify()
{
	Selection aSel = GetSelection();
	String sTemp = GetText();
	for(USHORT i = 0; i < sForbiddenChars.Len(); i++)
	{
		sTemp.EraseAllChars( sForbiddenChars.GetChar(i) );
	}
	USHORT nDiff = GetText().Len() - sTemp.Len();
	if(nDiff)
	{
		aSel.setMin(aSel.getMin() - nDiff);
		aSel.setMax(aSel.getMin());
		SetText(sTemp);
		SetSelection(aSel);
	}
	if(GetModifyHdl().IsSet())
		GetModifyHdl().Call(this);
}
/* -----------------25.06.2003 15:57-----------------

 --------------------------------------------------*/
ReturnActionEdit::~ReturnActionEdit()
{
}            
/* -----------------25.06.2003 15:58-----------------

 --------------------------------------------------*/
void ReturnActionEdit::KeyInput( const KeyEvent& rEvt)
{
    const KeyCode aKeyCode = rEvt.GetKeyCode();
    const USHORT nModifier = aKeyCode.GetModifier();
    if( aKeyCode.GetCode() == KEY_RETURN &&
            !nModifier)
    {
        if(aReturnActionLink.IsSet())
            aReturnActionLink.Call(this);
    }    
    else 
        Edit::KeyInput(rEvt);
}            


