/*************************************************************************
 *
 *  $RCSfile: sw3block.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 14:18:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SV_FONTTYPE_HXX //autogen
#include <vcl/fonttype.hxx>
#endif
#ifndef _SV_FONT_HXX //autogen
#include <vcl/font.hxx>
#endif
#ifndef _TOOLS_TENCCVT_HXX //autogen
#include <tools/tenccvt.hxx>
#endif
#ifndef _SVSTOR_HXX //autogen
#include <so3/svstor.hxx>
#endif
#ifndef _SOT_STORINFO_HXX //autogen
#include <sot/storinfo.hxx>
#endif
#ifndef _SO_CLSIDS_HXX
#include <so3/clsids.hxx>
#endif
#ifndef _UNOTOOLS_CHARCLASS_HXX
#include <unotools/charclass.hxx>
#endif
#ifndef _SFXMACITEM_HXX
#include <svtools/macitem.hxx>
#endif

#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
#ifndef _SW3IO_HXX
#include <sw3io.hxx>
#endif
#ifndef _SW3IMP_HXX
#include <sw3imp.hxx>
#endif
#ifndef _SWBLOCKS_HXX
#include <swblocks.hxx>
#endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>
#endif
#ifndef _POOLFMT_HXX
#include <poolfmt.hxx>
#endif

#ifndef _SWSWERROR_H
#include <swerror.h>
#endif

#define STREAM_STGREAD  ( STREAM_READ | STREAM_SHARE_DENYWRITE | STREAM_NOCREATE )
#define STREAM_STGWRITE ( STREAM_READ | STREAM_WRITE | STREAM_SHARE_DENYWRITE )

sal_Char __FAR_DATA N_BLOCKINFO[] = "AutotextInfo";

void Sw3IoImp::InitBlockMode( SvStorage* pStg, BOOL bRdWr )
{
	bBlock = TRUE;
	pBlkRoot = pStg;
	pRoot.Clear();
}

void Sw3IoImp::ResetBlockMode()
{
	bBlock = FALSE;
	pRoot.Clear();
	pBlkRoot.Clear();
}

/*************************************************************************
*
* 	Enumeration aller Textbausteine
*
*************************************************************************/

// Das Directory enthaelt die Kurz- und Langnamen der Bausteine. Die
// Bausteine selbst sind unter ihrem Kurznamen in eigenen Streams
// abgelegt. Die Namen selbst sind nach folgender Konvention aufgebaut:
// 1. Zeichen: #
// ! == 0x01
// / == 0x0F
// \ == 0x0C
// : == 0x0A
// . == 0x0E

void lcl_EncryptBlockName( String& rName )
{
	rName.Insert( '#', 0 );
	xub_StrLen nPos = 1;
	sal_Unicode pDelims[] = { '!', '/', ':', '.', '\\', 0 };
	while( STRING_NOTFOUND != ( nPos = rName.SearchChar( pDelims, nPos )))
	{
		rName.SetChar( nPos, rName.GetChar( nPos ) & 0x0f );
		++nPos;
	}
}

void lcl_DecryptBlockName( String& rName )
{
	if( '#' == rName.GetChar( 0 ) )
	{
		rName.Erase( 0, 1 );

		sal_Unicode c;
		xub_StrLen nLen = rName.Len();
		while( nLen-- )
		{
			switch( rName.GetChar( nLen ) )
			{
			case 0x01:	c = '!';	break;
			case 0x0A:	c = ':';	break;
			case 0x0C:	c = '\\';	break;
			case 0x0E:	c = '.';	break;
			case 0x0F:	c = '/';	break;
			default:	c = 0; 		break;
			}
			if( c )
				rName.SetChar( nLen, c );
		}
	}
}

void Sw3IoImp::DetectAndSetFFVersion( SvStorage *pRoot )
{
	ULONG nClipId = pRoot->GetFormat();
	ASSERT( SOT_FORMATSTR_ID_STARWRITER_30 == nClipId ||
			SOT_FORMATSTR_ID_STARWRITER_40 == nClipId ||
			SOT_FORMATSTR_ID_STARWRITER_50 == nClipId,
			"Textbaustein-Storage hat unzulaessige Clipboard-Id" );

	if( SOT_FORMATSTR_ID_STARWRITER_30 == nClipId )
	{
		pRoot->SetVersion( SOFFICE_FILEFORMAT_31 );
	}
	else if( SOT_FORMATSTR_ID_STARWRITER_40 == nClipId ||
			 SOT_FORMATSTR_ID_STARWRITERWEB_40 == nClipId ||
			 SOT_FORMATSTR_ID_STARWRITERGLOB_40 == nClipId )
	{
		pRoot->SetVersion( SOFFICE_FILEFORMAT_40 );
	}
	else if( SOT_FORMATSTR_ID_STARWRITER_50 == nClipId ||
			 SOT_FORMATSTR_ID_STARWRITERWEB_50 == nClipId ||
			 SOT_FORMATSTR_ID_STARWRITERGLOB_50 == nClipId )
	{
		pRoot->SetVersion( SOFFICE_FILEFORMAT_50 );
	}
	else
	{
		ASSERT( !this, "Textbaustein hat unbekannte Clipboard-Id" );
		// In der 4.0-Auslieferung gab es eine Standard-Bau mit dieser
		// recht merkwuerdigen Clipboard-Id (geschrieben mit einer 332e)
		// (bug #49310#)
		SvGlobalName aWhatEver( 0xC24CC4E0, 0x73DF, 0x101B, 0x80, 0x4C,
								0xFD, 0xFD, 0xFD, 0xFD, 0xFD, 0xFD );
		if( aWhatEver == pRoot->GetClassName() )
		{
			ASSERT( !this, "Textbaustein hat merkwuerdigen Classname" );
			pRoot->SetVersion( SOFFICE_FILEFORMAT_31 );
		}
		else
			pRoot->SetVersion( SOFFICE_FILEFORMAT_50 );
	}
}

ULONG Sw3IoImp::FirstBlockName( String& rShort, String& rLong )
{
	delete pBlkList;

	// This is just an initialization where we need any valid 1 byte
	// text encoding. It is used only if there are errors reading
	// at least the first text block. We assume the encoding that is used
	// for writing then, allthough this most probably is wrong.
	eBlkDirSet = GetSOStoreTextEncoding( gsl_getSystemTextEncoding(),
										 SOFFICE_FILEFORMAT_50 );

	if( pBlkRoot->IsStream( N_BLOCKDIR ) )
	{
		pBlkDir = pBlkRoot->OpenStream( N_BLOCKDIR, STREAM_STGREAD );
		if( pBlkDir->GetError() != SVSTREAM_OK )
		{
			pBlkDir.Clear();
			pBlkRoot->Remove( N_BLOCKDIR );
		}
		else
		{
			pBlkDir->SetBufferSize( SW3_BSR_BLKDIR );

			String aDummy;
			InString( *pBlkDir, aDummy );
			if( aDummy.Len() )
			{
				// alter Stream (ohne Header)
				// Char-Set aus erstem Dokument holen
				SvStorageStreamRef pSaveBlkDir( pBlkDir );
				pBlkDir.Clear();

				pBlkList = new SvStorageInfoList;
				nCurBlk  = -1;
				pBlkRoot->FillInfoList( pBlkList );

				String aShort, aLong;
				if ( !NextBlockName( aShort, aLong ) )
					eBlkDirSet = eSrcSet;

				delete pBlkList; pBlkList = NULL;
				pBlkDir = pSaveBlkDir;
				pBlkDir->Seek( 0L );
			}
			else
			{
				// neuer Stream (mit Header)
				ULONG nOld = pBlkDir->Tell();

				BYTE cLen, cSet;
				USHORT nVersion;
				*pBlkDir >> cLen >> nVersion >> cSet;
				eBlkDirSet = GetSOLoadTextEncoding( (rtl_TextEncoding)cSet,
												 	SOFFICE_FILEFORMAT_50 );

				ULONG nNew = pBlkDir->Tell();
				nOld += cLen;
				if( nOld != nNew )
					pBlkDir->Seek( nOld );
			}
		}
	}
	else
	{
		pBlkList = new SvStorageInfoList;
		nCurBlk  = -1;
		pBlkRoot->FillInfoList( pBlkList );
	}
	return NextBlockName( rShort, rLong );
}

// Der Fehlercode wird zurueckgeliefert. Das Ende der Liste
// wird durch einen leeren Short-Namen angezeigt.

ULONG Sw3IoImp::NextBlockName( String& rShort, String& rLong )
{
	ULONG n = 0;
	rShort.Erase();
	if( pBlkDir )
	{
		pBlkDir->ReadByteString( rShort, eBlkDirSet );
		pBlkDir->ReadByteString( rLong, eBlkDirSet );
		if( pBlkDir->IsEof() || pBlkDir->GetError() != SVSTREAM_OK )
		{
			n = ( pBlkDir->GetError() == SVSTREAM_OK )
			  ? 0 : ERR_SWG_READ_ERROR;
			rShort.Erase();
			pBlkDir->SetBufferSize( 0 );
			pBlkDir.Clear();
		}
	}
	else
	{
		if( !pBlkList )
			return 0;
		while( ++nCurBlk < (short) pBlkList->Count() )
		{
			SvStorageInfo& rInfo = pBlkList->GetObject( nCurBlk );
			String aShort = rInfo.GetName();
			if( '#' == aShort.GetChar( 0 ) )
			{
				Reset2();
				// Langnamen einlesen
				if( rInfo.IsStream() )
				{
					// Kurzform!
					pContents = pBlkRoot->OpenStream( aShort, STREAM_STGREAD );
				}
				else
				{
					pRoot = pBlkRoot->OpenStorage( aShort, STREAM_STGREAD );

					if( pRoot.Is() )
						DetectAndSetFFVersion( pRoot );

					pContents = pRoot->OpenStream( N_DOC, STREAM_STGREAD );
				}
				pContents->SetBufferSize( SW3_BSR_CONTENTS_HEADER );
				if( pContents->GetError() == SVSTREAM_OK )
				{
					pStrm = pContents;
					bOut = FALSE;
					InHeader();
					n = nRes;
					if( n )
						break;
				}
				pStrm = NULL;
				pContents->SetBufferSize( 0 );
				pContents.Clear();
				pRoot.Clear();
				rShort = aShort;
				lcl_DecryptBlockName( rShort );
				rLong = aBlkName;
				return n;
			}
		}
		delete pBlkList; pBlkList = NULL;
	}
	return n;
}

/*************************************************************************
*
* 	I/O einzelner Textbausteine
*
*************************************************************************/

ULONG Sw3IoImp::GetBlock( const String& rShort, sal_Bool bConvertMode )
{
	ULONG n = 0;
	String aName ( rShort );
	lcl_EncryptBlockName( aName );
	if( pBlkRoot->IsStream( aName ) )
	{
		// Kurzform!
		ByteString aText;
		pContents = pBlkRoot->OpenStream( aName, STREAM_STGREAD );
		pContents->SetBufferSize( SW3_BSR_CONTENTS_FLAT );
		pStrm = pContents;
		bOut = FALSE;
		InHeader();
		OpenRec( SWG_BLOCKTEXT );
		pStrm->ReadByteString( aText );
		CloseRec( SWG_BLOCKTEXT );
		if( pBlkRoot->GetError() != SVSTREAM_OK
		 || pStrm->GetError() != SVSTREAM_OK )
			n = ERR_SWG_READ_ERROR;
		else
			n = IsError( nRes ) ? nRes : 0;
		pStrm = NULL;
		pContents->SetBufferSize( 0 );
		pContents.Clear();
		if( !n )
			MakeBlockText( aText );
	}
	else
	{
		SvStorageRef refRoot = pBlkRoot->OpenStorage( aName, STREAM_STGREAD );

		// Fuer 3.1-Textbausteine muss die FF-Version noch umgeschossen
		// werden.
		if( refRoot.Is() )
			DetectAndSetFFVersion( refRoot );

		ClearPersist();
		SwPaM *pPaM = 0;
		if( bConvertMode )
		{
			SwNodeIndex aPos( pDoc->GetNodes().GetEndOfContent(), -1 );
			pPaM = new SwPaM( aPos );
		}
		n = rIo.Load( refRoot, pPaM );
		delete pPaM;
		if( !IsError( n ))
			n = 0;
	}
	return n;
}

ULONG Sw3IoImp::GetBlockText( const String& rShort, String& rText )
{
	ULONG n = 0;
	String aName( rShort );
	lcl_EncryptBlockName( aName );
	if( pBlkRoot->IsStream( aName ) )
	{
		// Kurzform!
		pContents = pBlkRoot->OpenStream( aName, STREAM_STGREAD );
		pContents->SetBufferSize( SW3_BSR_CONTENTS_FLAT );
		pStrm = pContents;
		bOut = FALSE;
		InHeader();
		OpenRec( SWG_BLOCKTEXT );
		InString( *pStrm, rText );
		CloseRec( SWG_BLOCKTEXT );
		if( pBlkRoot->GetError() != SVSTREAM_OK
		 || pStrm->GetError() != SVSTREAM_OK )
			n = ERR_SWG_READ_ERROR;
		else
			n = IsError( nRes ) ? nRes : 0;
		pStrm = NULL;
		pContents->SetBufferSize( 0 );
		pContents.Clear();
	}
	else
	{
		pRoot = pBlkRoot->OpenStorage( aName, STREAM_STGREAD );

		// Fuer 3.1-Textbausteine muss die FF-Version noch umgeschossen
		// werden.
		if( pRoot.Is() )
			DetectAndSetFFVersion( pRoot );

		if( OpenStreams( FALSE ) )
		{
			pStrm = pContents;
			pStrm->SetBufferSize( SW3_BSR_CONTENTS );
			LoadDocText( rText );
			pStrm->SetBufferSize( 0 );
			pStrm = NULL;
			CheckStreams();
			n = IsError( nRes ) ? nRes : 0;
			CloseStreams();
		}
		else
			rText.Erase();				// bug fix #24980#
		pRoot.Clear();
	}
	return n;
}

void Sw3IoImp::MakeBlockText( const ByteString& rText )
{
	SwTxtNode* pTxtNode = pDoc->GetNodes()[ pDoc->GetNodes().GetEndOfContent().
										GetIndex() - 1 ]->GetTxtNode();
	//JP 18.09.98: Bug 56706 - Standard sollte zumindest gesetzt sein!
	if( pTxtNode->GetTxtColl() == pDoc->GetDfltTxtFmtColl() )
		pTxtNode->ChgFmtColl( pDoc->GetTxtCollFromPool( RES_POOLCOLL_STANDARD ));

	xub_StrLen nPos = 0;
	do {
		if( nPos )
		{
//			SwIndex aSplitIdx( pTxtNode, pTxtNode->GetTxt().Len() );
//			pTxtNode->SplitNode( SwPosition( *pTxtNode, aSplitIdx ));

			pTxtNode = (SwTxtNode*)pTxtNode->AppendNode(
									SwPosition( *pTxtNode ));
		}

		SwIndex aIdx( pTxtNode );
		ByteString sText8( rText.GetToken( 0, '\015', nPos ) );
		String sText( sText8, eSrcSet );
		pTxtNode->Insert( sText, aIdx );
		ConvertText( *pTxtNode, sText8, 0, 0, 0 );

	} while( STRING_NOTFOUND != nPos );
}

ULONG Sw3IoImp::GetBlockMacroTable( const String& rShort,
									SvxMacroTableDtor& rMacroTbl )
{
	ULONG nRes = 0;
	String aName ( rShort );
	lcl_EncryptBlockName( aName );
	// Wenn der Baustein nur aus einem Stream besteht kann er auch keine
	// Macros enthalten.
	if( !pBlkRoot->IsStream( aName ) )
	{
		SvStorageRef xRoot = pBlkRoot->OpenStorage( aName, STREAM_STGREAD );

		// Fuer 3.1-Textbausteine muss die FF-Version noch umgeschossen
		// werden.
		if( xRoot.Is() )
		{
			DetectAndSetFFVersion( xRoot );
			nRes = rIo.GetMacroTable( xRoot, rMacroTbl );
		}
	}

	return nRes;
}

////////////////////////////////////////////////////////////////////////////

Sw3TextBlocks::Sw3TextBlocks( const String& rFile )
			 : SwImpBlocks( rFile ), bAutocorrBlock( FALSE )
{
	pDoc = new SwDoc;
	pDoc->AddLink();
	pIo3 = new Sw3Io( *pDoc );
	pImp = pIo3->GetImp();
	pDoc->DoUndo( FALSE );		// immer auf FALSE !!

	BOOL bIsStg = SvStorage::IsStorageFile( rFile );

	// erstmal versuchen schreibend zu oeffen:
	// 	Klappt das, dann ist es kein ReadOnly Document
	SvStorageRef refStg = new SvStorage( aFile, STREAM_STD_READWRITE, STORAGE_TRANSACTED );
	bReadOnly = 0 != refStg->GetError();
	refStg.Clear();

	if( !bIsStg || !aDateModified.GetDate() || !aTimeModified.GetTime() )
		Touch();		// falls neu angelegt -> neuen ZeitStempel besorgen

	refStg = new SvStorage( rFile, STREAM_READ | STREAM_SHARE_DENYNONE );

	pImp->InitBlockMode( refStg, TRUE );

	if( bIsStg )
	{
		const CharClass& rCC = GetAppCharClass();
		String aShort, aLong;
		ULONG nErr = pImp->FirstBlockName( aShort, aLong );
		if( !nErr && aShort.Len() )
		{
			do {
				String aShortUpr( rCC.upper( aShort ) );
				SwBlockName* pNew = new SwBlockName( aShortUpr, aLong, 0L );
				aNames.C40_PTR_INSERT( SwBlockName, pNew );
			}
			while( 0 == ( nErr = pImp->NextBlockName( aShort, aLong ) )
					&& aShort.Len() );
		}
		ReadInfo();
	}
	pImp->ResetBlockMode();
}

Sw3TextBlocks::Sw3TextBlocks( SvStorage& rStg )
	: SwImpBlocks( rStg.GetName() ),
	bAutocorrBlock( TRUE )
{
// JP 18.10.96: Kruecke fuer die SVX(SW)-Autokorrektur
//				eine Namensliste gibt es nicht; es wird nur PutDoc/GetText
//				benutzt!!!!
	pDoc = new SwDoc;
	pDoc->AddLink();
	pIo3 = new Sw3Io( *pDoc );
	pImp = pIo3->GetImp();
	pDoc->DoUndo( FALSE );		// immer auf FALSE !!

	bReadOnly = FALSE;
	SvStorageRef refStg = &rStg;
	pImp->InitBlockMode( refStg, TRUE );
	ReadInfo();
}

Sw3TextBlocks::~Sw3TextBlocks()
{
	pImp->ResetBlockMode();
	if( pDoc && !pDoc->RemoveLink() )
		delete pDoc;
	delete pIo3;
}

short Sw3TextBlocks::GetFileType ( void ) const
{
	return SWBLK_SW3;
}

ULONG Sw3TextBlocks::Delete( USHORT )
{
	return ERR_SWG_OLD_GLOSSARY;
}

ULONG Sw3TextBlocks::Rename( USHORT, const String&, const String& )
{
	return ERR_SWG_OLD_GLOSSARY;
}

ULONG Sw3TextBlocks::CopyBlock( SwImpBlocks& rDestImp, String& rShort,
													const String& rLong)
{
	return ERR_SWG_OLD_GLOSSARY;
}

void Sw3TextBlocks::SetDoc ( SwDoc * pNewDoc )
{
	pDoc = pNewDoc;
	pImp->SetDoc ( *pNewDoc );
}

ULONG Sw3TextBlocks::GetDoc( USHORT nIdx )
{
	return pImp->GetBlock( aNames[ nIdx ]->aShort );
}

ULONG Sw3TextBlocks::GetDocForConversion( USHORT nIdx )
{
	return pImp->GetBlock( aNames[ nIdx ]->aShort, sal_True );
}

ULONG Sw3TextBlocks::BeginPutDoc( const String& rShort, const String& rLong )
{
	return ERR_SWG_OLD_GLOSSARY;
}

ULONG Sw3TextBlocks::PutDoc()
{
	return ERR_SWG_OLD_GLOSSARY;
}

ULONG Sw3TextBlocks::GetText( USHORT nIdx, String& rText )
{
	return pImp->GetBlockText( aNames[ nIdx ]->aShort, rText );
}

ULONG Sw3TextBlocks::GetText( const String& rShort, String& rText )
{
	return pImp->GetBlockText( rShort, rText );
}

ULONG Sw3TextBlocks::PutText( const String&, const String&,
								const String& )
{
	return ERR_SWG_OLD_GLOSSARY;
}

ULONG Sw3TextBlocks::MakeBlockList()
{
	return ERR_SWG_OLD_GLOSSARY;
}

// Textbaustein-Konversionsmode ein/ausschalten
// Das Flag verhindert das Commit auf die Root nach dem Schreiben
// eines Textbausteins; daher wird hier committed, wenn das
// Flag geloescht wird.

ULONG Sw3TextBlocks::SetConvertMode( BOOL bOn )
{
	if( bOn )
		pImp->nGblFlags |= SW3F_CONVBLOCK;
	else
	{
		pImp->nGblFlags &= ~SW3F_CONVBLOCK;
		if( pImp->pBlkRoot.Is() )
		{
			pImp->pBlkRoot->Commit();
			if( pImp->pBlkRoot->GetError() != SVSTREAM_OK )
				return ERR_SWG_WRITE_ERROR;
		}
	}
	return 0;
}


// ggf. eine SvPersist-Instanz einrichten

BOOL Sw3IoImp::CheckPersist()
{
	// Haben wir schon einen Persist?
	if( pDoc->GetPersist() )
		return TRUE;
	pPersist = new Sw3Persist;
	if( pPersist->DoOwnerLoad( pRoot ) )
	{
		pDoc->SetPersist( pPersist );
		return TRUE;
	}
	else
		return FALSE;
}

// ggf. eine SvPersist-Instanz freigeben

void Sw3IoImp::ClearPersist()
{
	if( pPersist.Is() )
	{
		pDoc->SetPersist( NULL );
		pPersist.Clear();
	}
}

ULONG Sw3TextBlocks::OpenFile( BOOL bReadOnly )
{
	if( bAutocorrBlock )
		return 0;

	if( !bReadOnly )
		return ERR_SWG_OLD_GLOSSARY;

	pImp->ResetBlockMode();
	SvStorageRef refStg = new SvStorage( aFile,
										 (STREAM_READ | STREAM_SHARE_DENYNONE));
	pImp->InitBlockMode( refStg, TRUE );
	return refStg->GetError();
}

void Sw3TextBlocks::CloseFile()
{
	if( !bAutocorrBlock )
	{
		pImp->ResetBlockMode();
	}
}

BOOL Sw3TextBlocks::IsOnlyTextBlock( const String& rShort ) const
{
	String aShName( rShort );
	lcl_EncryptBlockName( aShName );
	return pImp->pBlkRoot->IsStream( aShName );
}

ULONG Sw3TextBlocks::GetMacroTable( USHORT nIdx, SvxMacroTableDtor& rMacroTbl,
									sal_Bool bFileAlreadyOpen )
{
	ULONG nRes = 0;

	if ( bFileAlreadyOpen )
	{
		nRes = pImp->GetBlockMacroTable( aNames[nIdx]->aShort, rMacroTbl );
	}
	else
	{
		nRes = OpenFile( TRUE );
		if( 0 == nRes )
		{
			nRes = pImp->GetBlockMacroTable( aNames[nIdx]->aShort, rMacroTbl );
			CloseFile();
		}
	}

	return nRes;
}

ULONG Sw3TextBlocks::SetMacroTable( USHORT,
									const SvxMacroTableDtor&,
									sal_Bool )
{
	return ERR_SWG_OLD_GLOSSARY;
}

void Sw3TextBlocks::ReadInfo()
{
	const String sBlockInfo( String::CreateFromAscii(N_BLOCKINFO) );
	if( pImp->pBlkRoot.Is() && pImp->pBlkRoot->IsStream( sBlockInfo ) )
	{
		SvStorageStreamRef xStrm( pImp->pBlkRoot->OpenStream( sBlockInfo,
												STREAM_STGREAD ));
		xStrm->SetSize( 0 );
		xStrm->SetBufferSize( SW3_BSW_BLKDIR );

		BYTE nLen, nChrSet;
		USHORT nVersion;
		*xStrm >> nLen				// Laenge des Headers
			   >> nVersion			// Version des Streams
			   >> nChrSet			// der Zeichensatz
			   ;

		xStrm->ReadByteString( aName, GetSOLoadTextEncoding( (rtl_TextEncoding)nChrSet, SOFFICE_FILEFORMAT_50 ) );
	}
}

//////////////////////////////////////////////////////////////////////////

Sw3Persist::Sw3Persist() : SvPersist()
{}

void __EXPORT Sw3Persist::FillClass( SvGlobalName * pClassName,
							ULONG * pClipFormat,
							String * pAppName,
							String * pLongUserName,
							String * pUserName,
							long nFileFormat ) const
{
	//JP 12.02.97: es sollte erstmal versucht, ueber eine offene DocShell
	//				an diese Information zu gelangen. Dafuer muss der SFX
	//				herhalten.
	TypeId aTId( TYPE ( SwDocShell ));

	// Irgendeine Shell suchen, die keine Web- oder Globaldokument
	// DocShell ist.
	SwDocShell*	pObjSh = (SwDocShell*)SfxObjectShell::GetFirst( &aTId, FALSE );
	while( pObjSh && aTId != pObjSh->Type() )
		pObjSh = (SwDocShell*)SfxObjectShell::GetNext( *pObjSh, &aTId, FALSE );

	if( pObjSh )
	{
		pObjSh->SwDocShell::FillClass( pClassName, pClipFormat, pAppName,
									pLongUserName, pUserName, nFileFormat );
		return ;
	}

	// MUSS NOCH ANGEPASST WERDEN, IST GEHACKT!!!
// 3.0
//	0xDC5C7E40L, 0xB35C, 0x101B, 0x99, 0x61, 0x04, 0x02, 0x1C, 0x00, 0x70,0x02)
//	pClassName->MakeId( "DC5C7E40-B35C-101B-9961-04021c007002" );
// 4.0
//	0x8b04e9b0,  0x420e, 0x11d0, 0xa4, 0x5e, 0x0,  0xa0, 0x24, 0x9d, 0x57,0xb1);
//	pClassName->MakeId( "8B04E9B0-420E-11D0-A45E-00A0249D57B1" );
	*pClassName = SvGlobalName( SO3_SW_CLASSID );
	pAppName->AssignAscii( "StarWriter 5.0" );
	pUserName->AssignAscii( "Text" );
	pLongUserName->AssignAscii( "StarOffice 6.0 Text" );
	*pClipFormat = SOT_FORMATSTR_ID_STARWRITER_60;
}

BOOL __EXPORT Sw3Persist::Save()
{
	if( SaveChilds() )
		return SvPersist::Save();
	else
		return FALSE;
}

BOOL __EXPORT Sw3Persist::SaveCompleted( SvStorage * pStor )
{
	if( SaveCompletedChilds( pStor ) )
		return SvPersist::SaveCompleted( pStor );
	else
		return FALSE;
}


