/*************************************************************************
 *
 *  $RCSfile: crsrsh1.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/17 13:44:39 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _SV_POLY_HXX //autogen
#include <vcl/poly.hxx>
#endif
#ifndef _SVDOBJ_HXX //autogen
#include <svx/svdobj.hxx>
#endif

#include "crsrsh.hxx"
#include "rootfrm.hxx"
#include "viewimp.hxx"
#include "pam.hxx"
#include "errhdl.hxx"			// fuer ASSERT
#include "dview.hxx"
#include "viscrs.hxx"
#include "swregion.hxx"


// erfrage die selektierte "Region" aller Cursor (fuer D&D auf Mac)
Region SwCrsrShell::GetCrsrRegion() const
{
	SwShellCrsr* pTmp = (SwShellCrsr*)pCurCrsr;
	PolyPolygon aPP;

	// sind Flys selektiert ??
	BOOL bSelFly = Imp()->GetDrawView() && Imp()->GetDrawView()->HasMarkedObj();

	if( bSelFly )
	{
		Rectangle aRect( VisArea().SVRect() );
		// hole den zuletzt selk. Fly
		const SdrMarkList &rMrkList = Imp()->GetDrawView()->GetMarkList();
		SdrObject *pObj = rMrkList.GetMark( rMrkList.GetMarkCount()-1 )->GetObj();
		ASSERT( pObj && pObj->IsVirtualObj(), "UUPs, kein oder kein virtuales Obj" );

		aRect.Intersection( pObj->GetSnapRect() );
		aPP.Insert( Polygon( aRect ) );
	}
	else if( pTblCrsr )
	{
		pTblCrsr->FillRects();
		for( USHORT n = pTblCrsr->Count(); n; )
		{
			Polygon aTmpPoly( (*pTblCrsr)[ --n ].SVRect() );
			aPP.Insert( aTmpPoly );
		}
	}
	else
	{
		SwRootFrm* pTmpFrm = GetLayout();
		BOOL bIsTblMode = IsTableMode();
		do {
			if( pTmp->HasMark() )
			{
				SwShellCrsr aTmp( *(SwCrsrShell*)this, *pTmp->GetPoint(),
									pTmp->GetPtPos() );
				aTmp.SetMark();
				*aTmp.GetMark() = *pTmp->GetMark();
				aTmp.GetMkPos() = pTmp->GetMkPos();

				pTmpFrm->CalcFrmRects( aTmp, bIsTblMode );
				for( USHORT n = 0; n < aTmp.Count(); ++n )
				{
					Polygon aTmpPoly( aTmp[ n ].SVRect() );
					aPP.Insert( aTmpPoly );
				}
				aTmp.Remove( 0, aTmp.Count() );
			}
		} while( pCurCrsr != ( pTmp = (SwShellCrsr*)*((SwCursor*)pTmp->GetNext() )));
	}
	return aPP;
}



