/*************************************************************************
 *
 *  $RCSfile: msfiltertracer.cxx,v $
 *
 *  $Revision: 1.2.206.2 $
 *
 *  last change: $Author: vg $ $Date: 2004/02/13 13:56:20 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _MS_FILTERTRACER_HXX
#include "msfiltertracer.hxx"
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_H_
#include <com/sun/star/uno/Sequence.h>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_LOGGING_LOGLEVEL_HPP_
#include <com/sun/star/util/logging/LogLevel.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_SEARCHALGORITHMS_HPP_
#include <com/sun/star/util/SearchAlgorithms.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_SEARCHFLAGS_HPP_
#include <com/sun/star/util/SearchFlags.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _FILTER_CONFIG_ITEM_HXX_
#include <svtools/FilterConfigItem.hxx>
#endif
#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif
#ifndef _UNTOOLS_UCBSTREAMHELPER_HXX
#include <unotools/ucbstreamhelper.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx> // helper for implementations
#endif
#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XATTRIBUTELIST_HPP_
#include <com/sun/star/xml/sax/XAttributeList.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_INPUTSOURCE_HPP_
#include <com/sun/star/xml/sax/InputSource.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

using namespace ::com::sun::star;


// MSFilterTracerImporter is only copying one xml stream into another
class MSFilterTracerImporter : public cppu::WeakImplHelper1	< com::sun::star::xml::sax::XDocumentHandler >
{
	enum ImportState
	{
		e_Root,
		e_DocumentURL
	};

public:
	MSFilterTracerImporter( com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& xMSF,
							com::sun::star::uno::Reference < com::sun::star::xml::sax::XDocumentHandler > xOutHd,
							const rtl::OUString rDocumentURL );
	virtual ~MSFilterTracerImporter( void );

	static void doAppend( com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& xMSF,
					com::sun::star::uno::Reference < com::sun::star::io::XInputStream > xIS,
					com::sun::star::uno::Reference < com::sun::star::xml::sax::XDocumentHandler > xOutHd,
					const rtl::OUString& rDocumentURL );

	// XDocumentHandler
    virtual void SAL_CALL startDocument(  ) 	
		throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL endDocument(  ) 	
		throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL startElement( const ::rtl::OUString& aName, const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttribs ) 	
		throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL endElement( const ::rtl::OUString& aName ) 	
		throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL characters( const ::rtl::OUString& aChars ) 	
		throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL ignorableWhitespace( const ::rtl::OUString& aWhitespaces ) 	
		throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL processingInstruction( const ::rtl::OUString& aTarget, const ::rtl::OUString& aData ) 	
		throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
    virtual void SAL_CALL setDocumentLocator( const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XLocator >& xLocator ) 	
		throw(::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);


private:

	com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > mxMSF;
	com::sun::star::uno::Reference< com::sun::star::xml::sax::XDocumentHandler > mxOutHd;

	rtl::OUString	maDocumentURL;

	rtl::OUString	msFile;
	rtl::OUString	msFileURL;
	rtl::OUString	msDocument;

	ImportState		meImportState;
};

// --------------
// - Namespaces -
// --------------

MSFilterTracerImporter::MSFilterTracerImporter( uno::Reference< lang::XMultiServiceFactory >& xMSF,
											   uno::Reference < xml::sax::XDocumentHandler > xOutHd,
											   const rtl::OUString rDocumentURL ) :
	mxOutHd			( xOutHd ),
	mxMSF			( xMSF ),
	maDocumentURL	( rDocumentURL ),
	meImportState	( e_Root ),
	msFile			( rtl::OUString::createFromAscii( "File" ) ),
	msFileURL		( rtl::OUString::createFromAscii( "FileURL" ) ),
	msDocument		( rtl::OUString::createFromAscii( "Document" ) )
{
}
MSFilterTracerImporter::~MSFilterTracerImporter( void )
{
}
void MSFilterTracerImporter::doAppend( uno::Reference< lang::XMultiServiceFactory >& xMSF, 
										uno::Reference< io::XInputStream > xIS,
											uno::Reference< xml::sax::XDocumentHandler > xOutHd,
												const rtl::OUString& rDocumentURL )
{	
	try
	{
		uno::Reference< xml::sax::XParser > xParser( xMSF->createInstance( rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Parser" ) ), uno::UNO_QUERY );
		if( xParser.is() )
		{
			MSFilterTracerImporter* pImporter = new MSFilterTracerImporter( xMSF, xOutHd, rDocumentURL );
			uno::Reference < xml::sax::XDocumentHandler > xDocHandler( pImporter );
			xParser->setDocumentHandler( xDocHandler );
			xml::sax::InputSource source;
			source.aInputStream = xIS;

			// start parsing 
			xParser->parseStream( source );
		}
	}
	catch( uno::Exception& )
	{
		DBG_ERROR( "MSFilterTracerImporter::doAppend exception !" );
	}
}
void SAL_CALL MSFilterTracerImporter::startDocument()
		throw( xml::sax::SAXException, uno::RuntimeException )
{
	// ignoring
}
void SAL_CALL MSFilterTracerImporter::endDocument()
		throw( xml::sax::SAXException, uno::RuntimeException )
{
	// ignoring
}
void SAL_CALL MSFilterTracerImporter::startElement( const rtl::OUString& aName,
		const uno::Reference< xml::sax::XAttributeList >& xAttribs )
		throw( xml::sax::SAXException, uno::RuntimeException )
{
	if ( !aName.equals( msDocument ) )
	{
		if ( aName.equals( msFile ) && xAttribs.is() )
		{
			rtl::OUString aString( xAttribs->getValueByName( msFileURL ) );
			if ( aString.equals( maDocumentURL ) )		// we will generate only one elements
				meImportState = e_DocumentURL;			// for each DocumentURL
		}
		if ( mxOutHd.is() && ( meImportState != e_DocumentURL ) )
			mxOutHd->startElement( aName, xAttribs );
	}
}
void SAL_CALL MSFilterTracerImporter::endElement( const rtl::OUString& aName )
	throw( xml::sax::SAXException, uno::RuntimeException )
{
	if ( meImportState == e_DocumentURL )
	{
		if ( aName.equals( msFile ) )
			meImportState = e_Root;
	}
	else
	{
		if ( !aName.equals( msDocument ) )
		{
			if ( mxOutHd.is() )
				mxOutHd->endElement( aName );
		}
	}
}
void SAL_CALL MSFilterTracerImporter::characters( const rtl::OUString& aChars ) 	
		throw( xml::sax::SAXException, uno::RuntimeException )
{
	if ( mxOutHd.is() && ( meImportState != e_DocumentURL ) )
		mxOutHd->characters( aChars );
}
void SAL_CALL MSFilterTracerImporter::ignorableWhitespace( const rtl::OUString& aWhitespaces )
		throw( xml::sax::SAXException, uno::RuntimeException )
{
	if ( mxOutHd.is() && ( meImportState != e_DocumentURL ) )
		mxOutHd->ignorableWhitespace( aWhitespaces );
}
void SAL_CALL MSFilterTracerImporter::processingInstruction( const rtl::OUString& aTarget, const rtl::OUString& aData ) 	
		throw( xml::sax::SAXException, uno::RuntimeException )
{
	if ( mxOutHd.is() && ( meImportState != e_DocumentURL ) )
		mxOutHd->processingInstruction( aTarget, aData );
}
void SAL_CALL MSFilterTracerImporter::setDocumentLocator( const uno::Reference< xml::sax::XLocator >& xLocator ) 	
		throw( xml::sax::SAXException, uno::RuntimeException )
{
	if ( mxOutHd.is() && ( meImportState != e_DocumentURL ) )
		mxOutHd->setDocumentLocator( xLocator );
}

MSFilterTracer::MSFilterTracer( const ::rtl::OUString& rConfigPath, uno::Sequence< beans::PropertyValue >* pConfigData ) :
	mpCfgItem( new FilterConfigItem( rConfigPath, pConfigData ) ),
	mpAttributeList( new SvXMLAttributeList() ),
	mpStream( NULL ),
	mbEnabled( sal_False )	// will be set to true in StartTracing()
{
	sal_Int8*		pInputStreamBuffer = NULL;
	SvMemoryStream* pInputStream = NULL;

	if ( mpCfgItem->ReadBool( rtl::OUString::createFromAscii( "On" ), sal_False ) )
	{
		uno::Reference< lang::XMultiServiceFactory > xMgr( ::comphelper::getProcessServiceFactory() );
		if ( xMgr.is() )
		{
			/* the following methods try to read a property, if it is not available it will put the second
			parameter as default into the property sequence of the FilterConfigItem. It means we ensure that
			the property is available by trying to read it (the return value of the method is ignored) */
			::rtl::OUString aEmptyString;
			mpCfgItem->ReadInt32( rtl::OUString::createFromAscii( "LogLevel" ), util::logging::LogLevel::ALL );
			mpCfgItem->ReadString( rtl::OUString::createFromAscii( "ClassFilter" ), aEmptyString );
			mpCfgItem->ReadString( rtl::OUString::createFromAscii( "MethodFilter" ), aEmptyString );
			mpCfgItem->ReadString( rtl::OUString::createFromAscii( "MessageFilter" ), aEmptyString );
			util::SearchAlgorithms eSearchAlgorithm = (util::SearchAlgorithms)
				mpCfgItem->ReadInt32( rtl::OUString::createFromAscii( "SearchAlgorithm" ), util::SearchAlgorithms_ABSOLUTE );

			// creating the name of the log file
			String aPath( mpCfgItem->ReadString( rtl::OUString::createFromAscii( "Path" ), aEmptyString ) );
			String aName( mpCfgItem->ReadString( rtl::OUString::createFromAscii( "Name" ), aEmptyString ) );
			String aDocumentURL( mpCfgItem->ReadString( rtl::OUString::createFromAscii( "DocumentURL" ), aEmptyString ) );
			INetURLObject aLogFile( aDocumentURL );
			sal_Bool bAppendLog( mpCfgItem->ReadBool( rtl::OUString::createFromAscii( "AppendLog" ), sal_True ) );

			// create the log file url (aLogFile)
			if ( aLogFile.GetMainURL( INetURLObject::NO_DECODE ).Len() )
			{
				if ( aPath.Len() )
				{
					String aOldName( aLogFile.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::NO_DECODE ) );
					aLogFile = INetURLObject( aPath );
					aLogFile.insertName( aOldName );
				}
				if ( aName.Len() )
					aLogFile.setName( aName );
			}
			else
			{
				if ( aPath.Len() )
					aLogFile = INetURLObject( aPath );
				else
				{
					String aURLStr;
					if( ::utl::LocalFileHelper::ConvertPhysicalNameToURL( Application::GetAppFileName(), aURLStr ) )
					{
						aLogFile = aURLStr;
						aLogFile .removeSegment();
						aLogFile .removeFinalSlash();
					}
				}
				if ( !aName.Len() )
					aName = rtl::OUString::createFromAscii( "tracer" );
				aLogFile.insertName( aName );
			}
			aLogFile.setExtension( rtl::OUString::createFromAscii( "log" ) );

			// try to read the existing log, so that we can copy it later
			if ( bAppendLog )
			{
				SvStream* pStrm = ::utl::UcbStreamHelper::CreateStream( aLogFile.GetMainURL( INetURLObject::NO_DECODE ), STREAM_READ );
				if ( pStrm && ( pStrm->GetError() == ERRCODE_NONE ) )
				{
					pStrm->Seek( STREAM_SEEK_TO_END );
					sal_Int32 nLen = pStrm->Tell();
					pStrm->Seek( STREAM_SEEK_TO_BEGIN );
					if ( nLen )
					{
						pInputStreamBuffer = new sal_Int8[ nLen ];
						pStrm->Read( pInputStreamBuffer, nLen );
						pInputStream = new SvMemoryStream( pInputStreamBuffer, nLen, STREAM_READ );
						pInputStream->ObjectOwnsMemory( sal_False );

						// pInput Stream is now the copy of the original log file
					}
					delete pStrm;
				}
			}

			// creating the file stream
			mpStream = ::utl::UcbStreamHelper::CreateStream( aLogFile.GetMainURL( INetURLObject::NO_DECODE ), STREAM_WRITE | STREAM_TRUNC | STREAM_SHARE_DENYNONE );
			if ( mpStream && !mpStream->GetError() )
			{
				// creating a wrapper for our stream
				utl::OOutputStreamWrapper* pHelper = new ::utl::OOutputStreamWrapper( *mpStream );
				uno::Reference< io::XOutputStream > xOutputStream( pHelper );

				// instanciating the DocumentHandler, then setting the OutputStream
				mxHandler = uno::Reference< xml::sax::XDocumentHandler >( xMgr->createInstance( rtl::OUString::createFromAscii( "com.sun.star.xml.sax.Writer" ) ), uno::UNO_QUERY );
				uno::Reference< io::XActiveDataSource > xDocSrc( mxHandler, uno::UNO_QUERY );
				xDocSrc->setOutputStream( xOutputStream );
				mxHandler->startDocument();
				mxHandler->ignorableWhitespace ( rtl::OUString::createFromAscii( " " ) );

				// writing the "DocumentHandler" property, so the FilterTracer component
				// will use it for the output
				uno::Any aAny;
				aAny <<= xDocSrc;
				mpCfgItem->WriteAny( rtl::OUString::createFromAscii( "DocumentHandler" ), aAny );
				mxHandler->startElement( rtl::OUString::createFromAscii( "Document" ), NULL );

				// copy the old log file into the new one
				if ( bAppendLog && pInputStream )
				{
					// creating a wrapper for our Input Stream
					utl::OInputStreamWrapper* pHelper = new ::utl::OInputStreamWrapper( *pInputStream );
					uno::Reference< io::XInputStream > xInputStream( pHelper );
					MSFilterTracerImporter::doAppend( xMgr, xInputStream, mxHandler, aDocumentURL );
				}

				SvXMLAttributeList* pAttrList = new SvXMLAttributeList;
				pAttrList->AddAttribute( rtl::OUString::createFromAscii( "FileURL" ), aDocumentURL );
				uno::Reference < xml::sax::XAttributeList > xAttributeList(pAttrList);
				mxHandler->startElement( rtl::OUString::createFromAscii( "File" ), xAttributeList );
			}

			uno::Sequence< uno::Any > aArgument( 1 );
			uno::Sequence< beans::PropertyValue > aPropValues( mpCfgItem->GetFilterData() );
			aArgument[ 0 ] <<= aPropValues;
			mxFilterTracer = xMgr->createInstanceWithArguments( rtl::OUString::createFromAscii( "com.sun.star.util.FilterTracer" ), aArgument );
			if ( mxFilterTracer.is() )
			{				
				mxTextSearch = uno::Reference< util::XTextSearch >( mxFilterTracer, uno::UNO_QUERY );
				mxLogger = uno::Reference< util::logging::XLogger >( mxFilterTracer, uno::UNO_QUERY );
				if ( mxTextSearch.is() )
				{
					maSearchOptions.algorithmType = eSearchAlgorithm;
					mxTextSearch->setOptions( maSearchOptions );
				}
			}
		}
	}
	delete pInputStream;
	delete[] pInputStreamBuffer;
}

MSFilterTracer::~MSFilterTracer()
{
	mxLogger = NULL;
	mxFilterTracer = NULL;
	if ( mxHandler.is() )
	{
		mxHandler->ignorableWhitespace ( rtl::OUString::createFromAscii( " " ) );
		mxHandler->endElement( rtl::OUString::createFromAscii( "File" ) );
		mxHandler->ignorableWhitespace ( rtl::OUString::createFromAscii( " " ) );
		mxHandler->endElement( rtl::OUString::createFromAscii( "Document" ) );
		mxHandler->ignorableWhitespace ( rtl::OUString::createFromAscii( " " ) );
		mxHandler->endDocument();
		mxHandler = NULL;
	}
	delete mpAttributeList;
	delete mpCfgItem;
	delete mpStream;
}

void MSFilterTracer::StartTracing()
{
	mbEnabled = mpCfgItem->ReadBool( rtl::OUString::createFromAscii( "On" ), sal_False );
}

void MSFilterTracer::EndTracing()
{
	mbEnabled = sal_False;
}

void MSFilterTracer::StartElement( const rtl::OUString& rName, uno::Reference< xml::sax::XAttributeList > xAttribs )
{
	if ( mxHandler.is() )
		mxHandler->startElement( rName, xAttribs );
}

void MSFilterTracer::EndElement( const rtl::OUString& rName )
{
	if ( mxHandler.is() )
		mxHandler->endElement( rName );
}

void MSFilterTracer::Trace( const rtl::OUString& rElement, const rtl::OUString& rMessage )
{
	if ( mbEnabled && mxLogger.is() )
	{
		sal_Bool bFilter = sal_False;
		if ( rMessage.getLength() && mxTextSearch.is() )
		{
			maSearchOptions.searchString = rMessage;
			mxTextSearch->setOptions(  maSearchOptions );
			util::SearchResult aSearchResult = mxTextSearch->searchForward( rMessage, 0, rMessage.getLength() );
			bFilter = aSearchResult.subRegExpressions != 0;
		}
		if ( !bFilter )
		{
			uno::Reference < xml::sax::XAttributeList > xAttrList( new SvXMLAttributeList( *mpAttributeList ) );
			if ( mxHandler.is() )
				mxHandler->startElement( rElement, xAttrList );
			if ( rMessage.getLength() )
			{
				rtl::OUString aEmpty;
				mxLogger->logp( 0, aEmpty, aEmpty, rMessage );
			}
			if ( mxHandler.is() )
				mxHandler->endElement( rElement );
		}
	}
}

void MSFilterTracer::AddAttribute( const ::rtl::OUString& sName , const ::rtl::OUString& sValue )
{
	if ( mbEnabled )
		mpAttributeList->AddAttribute( sName, sValue );
}
void MSFilterTracer::ClearAttributes()
{
	if ( mbEnabled )
		mpAttributeList->Clear();
}

void MSFilterTracer::RemoveAttribute( const ::rtl::OUString& sName )
{
	if ( mbEnabled )
		mpAttributeList->RemoveAttribute( sName );
}

uno::Any MSFilterTracer::GetProperty( const rtl::OUString& rPropName, const uno::Any* pDefault ) const
{
	uno::Any aDefault;
	if ( pDefault )
		aDefault = *pDefault;
	return mpCfgItem->ReadAny( rPropName, aDefault );
}

void MSFilterTracer::SetProperty( const ::rtl::OUString& rPropName, const uno::Any& rProperty )
{
	mpCfgItem->WriteAny( rPropName, rProperty );
}

