/*************************************************************************
 *
 *  $RCSfile: ctrdial.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 14:59:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SVX_CTRDIAL_HXX
#define	_SVX_CTRDIAL_HXX

#ifndef _SV_CTRL_HXX //autogen
#include <vcl/ctrl.hxx>
#endif

#ifndef _SV_VIRDEV_HXX //autogen
#include <vcl/virdev.hxx>
#endif

class SvxCtrDialBmp : public VirtualDevice
{
    private:
        Rectangle				aDrawRect;
        const Window&           mrParent;
        short					nCenterX;
        short					nCenterY;

        inline const StyleSettings& GetStyleSettings() const;

		inline void		GetColors( Color& rBackGround, Color& rText ) const;
		inline Color	GetBackgroundColor( void ) const;
		inline Color	GetTextColor( void ) const;
		inline Color	GetButtonTextColor( void ) const;
		inline Color	GetHighlightColor( void ) const;
		inline Color	GetNonHighlightColor( void ) const;
		inline Color	GetDisabledColor( void ) const;
        void            InitBitmap( const Size& rSize );
        void            DrawBackground( BOOL bEnabled );
        void            DrawShadow( BOOL bEnabled );
        void            DrawCalibration( BOOL bEnabled );

    public:
		inline			SvxCtrDialBmp( const Window& rParent );
        void            InitBitmap( const Size& rSize, const Font& rFont );
        void            DrawBackgrBitmap( const Size& rSize, BOOL bEnabled );
        void            DrawBackgrBitmap( const SvxCtrDialBmp& rSrc );
        void            DrawElements( const String& rText, short nDelta, BOOL bEnabled );
};


inline SvxCtrDialBmp::SvxCtrDialBmp( const Window& rParent ) :
    mrParent( rParent )
{
    EnableRTL( false );
}

inline const StyleSettings& SvxCtrDialBmp::GetStyleSettings() const
{
    return mrParent.GetSettings().GetStyleSettings();
}



class SvxCtrDial : public Control
{
	private:
		Link            aCtrModifiedLink;
		Link			aMouseUpLink;

        SvxCtrDialBmp   aEnabledBmp;
        SvxCtrDialBmp   aDisabledBmp;
        SvxCtrDialBmp   aBufferBmp;
		short			nDelta;
		Font			aRotFont;
        short           nCenterX;
        short           nCenterY;
        Size            aWinSize;
        bool            bNoSel;

		inline void		GetColors( Color& rBackGround, Color& rText ) const;
        void            Init();
        void            Paint( const Rectangle& rRect );

    public:
                        SvxCtrDial( Window* pParent,Size aSize, Font aFont, WinBits nWinStyle = 0);
                        SvxCtrDial( Window* pParent,Size aSize, WinBits nWinStyle = 0);
                        SvxCtrDial( Window* pWindow, const ResId& rResId);

        virtual void    Invalidate();

        virtual bool    HasOrientation() const;
        virtual USHORT  GetOrientation();
		virtual void	SetOrientation(short alpha);
        virtual void    SetNoOrientation();

        virtual void    DataChanged( const DataChangedEvent& rDCEvt );

		virtual void	MouseMove( const MouseEvent& rMEvt );
		virtual void	MouseButtonDown( const MouseEvent& rMEvt );
		virtual void	MouseButtonUp( const MouseEvent& rMEvt );

		virtual void    CtrModified();
		virtual void	CtrMouseUp();

		void            SetCtrModifiedHdl( const Link& rLink ) { aCtrModifiedLink = rLink; }
		const Link&     GetCtrModifiedHdl() const { return aCtrModifiedLink; }
		void            SetMouseUpHdl( const Link& rLink ) { aMouseUpLink = rLink; }
		const Link&     GetMouseUpLink() const { return aMouseUpLink; }
};


#endif
