/*************************************************************************
 *
 *  $RCSfile: privsplt.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "privsplt.hxx"

// -----------------------------------------------------------------------

SvPrivatSplit::SvPrivatSplit( Window* pParent, const ResId& rResId, PRIVSPLIT_DIRECTION eSplit ) :

	FixedLine( pParent, rResId )

{
	Point aPos=GetPosPixel();
	nOldX=(short)aPos.X();
	nOldY=(short)aPos.Y();
	nNewX=(short)aPos.X();
	nNewY=(short)aPos.Y();
	eAdrSplit=eSplit;
	aXMovingRange.Min()=nNewX;
	aXMovingRange.Max()=nNewX;
	aYMovingRange.Min()=nNewY;
	aYMovingRange.Max()=nNewY;

	aWinPointer=GetPointer();

	aMovingFlag=FALSE;
	if(eAdrSplit==PRIVSPLIT_HORZ)
	{
		aWinPointer=Pointer(POINTER_HSPLIT);
	}
	else
	{
		aWinPointer=Pointer(POINTER_VSPLIT);
	}
	SetPointer(aWinPointer);
}

// -----------------------------------------------------------------------

SvPrivatSplit::SvPrivatSplit( Window* pParent, PRIVSPLIT_DIRECTION eSplit, WinBits nStyle ) :

	FixedLine( pParent, nStyle )

{
	nOldX=0;
	nOldY=0;
	nNewX=0;
	nNewY=0;
	eAdrSplit=eSplit;
	aXMovingRange.Min()=nNewX;
	aXMovingRange.Max()=nNewX;
	aYMovingRange.Min()=nNewY;
	aYMovingRange.Max()=nNewY;

	aWinPointer=GetPointer();

	aMovingFlag=FALSE;
	if(eAdrSplit==PRIVSPLIT_HORZ)
	{
		aWinPointer=Pointer(POINTER_HSPLIT);
	}
	else
	{
		aWinPointer=Pointer(POINTER_VSPLIT);
	}
	SetPointer(aWinPointer);

}

// -----------------------------------------------------------------------

void SvPrivatSplit::MouseButtonDown( const MouseEvent& rMEvt )
{
	if ( rMEvt.IsLeft())
	{
		Point aPos=LogicToPixel(rMEvt.GetPosPixel());

		nOldX=(short)aPos.X();
		nOldY=(short)aPos.Y();

		StartTracking();
	}
}

// -----------------------------------------------------------------------

void SvPrivatSplit::Tracking( const TrackingEvent& rTEvt )
{

	const MouseEvent& rMEvt=rTEvt.GetMouseEvent();
	Point aPos=LogicToPixel(rMEvt.GetPosPixel());
	Point a2Pos=GetPosPixel();
	Point a3Pos=a2Pos;

	if(eAdrSplit==PRIVSPLIT_HORZ)
	{
		nNewX=(short)aPos.X();
		nDeltaX=nNewX-nOldX;
		a2Pos.X()+=nDeltaX;

		if(a2Pos.X()<aXMovingRange.Min())
		{
			nDeltaX=(short)(aXMovingRange.Min()-a3Pos.X());
			a2Pos.X()=aXMovingRange.Min();
		}
		else if(a2Pos.X()>aXMovingRange.Max())
		{
			nDeltaX=(short)(aXMovingRange.Max()-a3Pos.X());
			a2Pos.X()=aXMovingRange.Max();
		}
	}
	else
	{
		nNewY=(short)aPos.Y();
		nDeltaY=nNewY-nOldY;
		a2Pos.Y()+=nDeltaY;

		if(a2Pos.Y()<aYMovingRange.Min())
		{
			nDeltaY=(short)(aYMovingRange.Min()-a3Pos.Y());
			a2Pos.Y()=aYMovingRange.Min();
		}
		else if(a2Pos.Y()>aYMovingRange.Max())
		{
			nDeltaY=(short)(aYMovingRange.Max()-a3Pos.Y());
			a2Pos.Y()=aYMovingRange.Max();
		}
	}

	SetPosPixel(a2Pos);

	if(!rMEvt.IsSynthetic())CtrModified();
	//Invalidate();
	//Update();
}

// -----------------------------------------------------------------------

void SvPrivatSplit::SetXRange(Range cRgeX)
{
	aXMovingRange=cRgeX;
}

// -----------------------------------------------------------------------

void SvPrivatSplit::SetYRange(Range cRgeY)
{
	aYMovingRange=cRgeY;
}

// -----------------------------------------------------------------------

short SvPrivatSplit::GetDeltaX()
{
	return nDeltaX;
}

// -----------------------------------------------------------------------

short SvPrivatSplit::GetDeltaY()
{
	return nDeltaY;
}

// -----------------------------------------------------------------------

void SvPrivatSplit::CtrModified()
{
	aCtrModifiedLink.Call( this );
}

// -----------------------------------------------------------------------

void SvPrivatSplit::MoveSplitTo(Point aPos)
{
	Point a2Pos=GetPosPixel();
	nOldX=(short)a2Pos.X();
	nOldY=(short)a2Pos.Y();
	Point a3Pos=a2Pos;

	if(eAdrSplit==PRIVSPLIT_HORZ)
	{
		nNewX=(short)aPos.X();
		nDeltaX=nNewX-nOldX;
		a2Pos.X()+=nDeltaX;
		if(a2Pos.X()<aXMovingRange.Min())
		{
			nDeltaX=(short)(aXMovingRange.Min()-a3Pos.X());
			a2Pos.X()=aXMovingRange.Min();
		}
		else if(a2Pos.X()>aXMovingRange.Max())
		{
			nDeltaX=(short)(aXMovingRange.Max()-a3Pos.X());
			a2Pos.X()=aXMovingRange.Max();
		}
	}
	else
	{
		nNewY=(short)aPos.Y();
		nDeltaY=nNewY-nOldY;
		a2Pos.Y()+=nDeltaY;
		if(a2Pos.Y()<aYMovingRange.Min())
		{
			nDeltaY=(short)(aYMovingRange.Min()-a3Pos.Y());
			a2Pos.Y()=aYMovingRange.Min();
		}
		else if(a2Pos.Y()>aYMovingRange.Max())
		{
			nDeltaY=(short)(aYMovingRange.Max()-a3Pos.Y());
			a2Pos.Y()=aYMovingRange.Max();
		}
	}
	SetPosPixel(a2Pos);
	//Invalidate();
	//Update();
	CtrModified();
}

// -----------------------------------------------------------------------

void SvPrivatSplit::ImplInitSettings( BOOL bFont, BOOL bForeground, BOOL bBackground )
{
	const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();

	if ( bFont )
	{
		Font aFont = rStyleSettings.GetAppFont();
		if ( IsControlFont() )
			aFont.Merge( GetControlFont() );
		SetFont( aFont );
	}

	if ( bFont || bForeground )
	{
		Color aTextColor = rStyleSettings.GetButtonTextColor();
		if ( IsControlForeground() )
			aTextColor = GetControlForeground();
		SetTextColor( aTextColor );
	}

	if ( bBackground )
	{
		SetBackground( rStyleSettings.GetFaceColor() );
	}

	SetFillColor( GetBackground().GetColor() );
	SetBackground();
	Invalidate();
}

// -----------------------------------------------------------------------

void SvPrivatSplit::StateChanged( StateChangedType nType )
{
	if ( (nType == STATE_CHANGE_ZOOM) ||
		 (nType == STATE_CHANGE_CONTROLFONT) )
	{
		ImplInitSettings( TRUE, FALSE, FALSE );
		Invalidate();
	}
	if ( nType == STATE_CHANGE_CONTROLFOREGROUND )
	{
		ImplInitSettings( FALSE, TRUE, FALSE );
		Invalidate();
	}
	else if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
	{
		ImplInitSettings( FALSE, FALSE, TRUE );
		Invalidate();
	}

	Control::StateChanged( nType );
}

// -----------------------------------------------------------------------

void SvPrivatSplit::DataChanged( const DataChangedEvent& rDCEvt )
{
	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
		 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
	{
		ImplInitSettings( TRUE, TRUE, TRUE );
		Invalidate();
	}
	else
		Window::DataChanged( rDCEvt );
}


