/*************************************************************************
 *
 *  $RCSfile: OfficeLog.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: kz $ $Date: 2003/05/13 10:28:22 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// __________ Imports __________

// structs, const, ...
import com.sun.star.beans.PropertyValue;
import com.sun.star.bridge.XUnoUrlResolver;

// exceptions
import com.sun.star.container.NoSuchElementException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import java.io.IOException;
import java.lang.InterruptedException;
import java.net.ConnectException;

// interfaces
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;

// helper
import com.sun.star.uno.IBridge;
import com.sun.star.uno.UnoRuntime;

// others
import java.lang.*;
import java.io.*;

// __________ Implementation __________

/**
 * If we start our own office instance as a sub process of us
 * we have to read from his stdout/stderr. Otherwhise it can be, that
 * this office will be blocked.
 * see documentation of java.lang.Process too!
 *
 * Currently we are not interessted on any information, available inside
 * these streams. But of course they can be used to write log files for
 * better debug ... We forward it to our own std. channels of this
 * java process only.
 *
 * @author      Andreas Schlns
 * @modified    11.07.2002 07:25
 */
public class OfficeLog extends Thread
{
    // ____________________

    /**
     * @member m_aOffice    the external office process, which output should be logged
     */
    private Process m_aOffice;
    private int     m_ci;
    private int     m_ce;

    // ____________________

    /**
     * ctor
     * It's initialize an object of this class with the neccessary process instance of the
     * remote office. We will safe this reference and use it inside our run() method later.
     *
     * @param aOffice
     *          the remote office process instance
     */
    public OfficeLog( Process aOffice )
    {
        m_aOffice = aOffice;
    }

    // ____________________

    /**
     * thread func
     * Here we use the given office process instance to get her (from java mapped)
     * std. in/out/error streams. Currently we read from these streams and put it out
     * on our own std. channels. Of course real logging into files will be ppossible too.
     */
    public void run()
    {
        try
        {
            System.out.println("office log was started ...");
            InputStream      aIn      = m_aOffice.getInputStream();
            InputStream      aErr     = m_aOffice.getErrorStream();
            FileOutputStream aLogFile = null;
	    aLogFile = null;
/*
            try
            {
                aLogFile = new FileOutputStream(OfficeLog.impl_generateUniqueLogFile());

            }
            catch(java.io.FileNotFoundException exNotFound) {}
*/

            if (aLogFile==null)
                System.out.println("no log file!");

            try
            {
                int    ci = 0;
                int    ce = 0;
                byte[] li = null;
                byte[] le = null;

                while (true)
                {
                    synchronized(this)
                    {
                        this.wait(100);
                        m_ci = aIn.available();
                        m_ce = aErr.available();
                        ci   = m_ci;
                        ce   = m_ce;
                    }

                    if (ci>0)
                    {
                        li = new byte[ci+1];
                        aIn.read(li,0,ci);
                        if (aLogFile!=null)
                            aLogFile.write(li);
                    }

                    if (ce>0)
                    {
                        le = new byte[ce+1];
                        aErr.read(le,0,ce);
                        if (aLogFile!=null)
                            aLogFile.write(le);
                    }
                }
            }
            catch( java.io.IOException exIO ) {}
        }
        catch( java.lang.InterruptedException exInterrupt ) {}

        m_aOffice = null;

        System.out.println("log finished!");
    }

    public boolean isBusy()
    {
        boolean bIsBusy = false;
        synchronized(this)
        {
            bIsBusy = (m_ci>0 || m_ce>0);
        }
        if (bIsBusy)
            System.out.println("is busy!");
        else
            System.out.println("is ready!");
        return bIsBusy;
    }

    private static final String BASENAME  = "officelog_";
    private static final String EXTENSION = ".log"      ;
    private static       long   m_nNr     = 0           ;

    private static File impl_generateUniqueLogFile()
    {
        File aLogFile = null;
        while(aLogFile==null)
        {
            String sFileName = BASENAME + String.valueOf(m_nNr) + EXTENSION;
                   aLogFile  = new File(sFileName);

            if (aLogFile.exists())
                aLogFile=null;

            ++m_nNr;
        }
        return aLogFile;
    }
}
