/*************************************************************************
 *
 *  $RCSfile: tbxopdlg.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: hr $ $Date: 2003/04/04 17:39:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef MSC
#pragma warning (disable:4355)
#endif

//========================================================================

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <so3/svstor.hxx>
#pragma hdrstop

#include "resmgr.hxx"
#include "tbxopdlg.hxx"
#include "tbxopdlg.hrc"
#include "msgpool.hxx"
#include "cfgmgr.hxx"
#include "sfxresid.hxx"
#include "dispatch.hxx"
#include "tbxconf.hxx"
#include "objsh.hxx"
#include "objface.hxx"
#include "cfg.hxx"
#include "tbxmgr.hxx"
#include "sfxtypes.hxx"
#include "viewfrm.hxx"
#include "bindings.hxx"
#include "request.hxx"

#define NEW_SFX_TOOLBOX_MAX 4

//========================================================================
// Der "Index" bezeichnet die Lage in der TreeListBox,
// die "Position" ist der Identifier des Bereiches ( SFX_OBJECTBAR_...)

USHORT PosToIndex_Impl( USHORT n )
{
	// Konvertiert Domain-Identifier in TreeListBox-Index
	if ( n <= SFX_OBJECTBAR_OPTIONS )
		// Alte Positionen
		return n;
	else if ( n>SFX_OBJECTBAR_USERDEF4 )
		// Neue Positionen
		return n - SFX_OBJECTBAR_USERDEF4 + SFX_OBJECTBAR_OPTIONS;
	else
		// UserDefToolboxen
		return n + SFX_OBJECTBAR_MAX - SFX_OBJECTBAR_USERDEF4 - 1;
}

USHORT IndexToPos_Impl( USHORT n )
{
	// Konvertiert TreeListBox-Index in Domain-Identifier
	if ( n <= SFX_OBJECTBAR_OPTIONS )
		// Alte Positionen
		return n;
	else if ( n < SFX_OBJECTBAR_OPTIONS + SFX_OBJECTBAR_MAX - SFX_OBJECTBAR_USERDEF4 )
		// Neue Positionen
		return n + SFX_OBJECTBAR_USERDEF4 - SFX_OBJECTBAR_OPTIONS;
	else
		// UserDefToolboxen
		return n - SFX_OBJECTBAR_MAX + SFX_OBJECTBAR_USERDEF4 + 1;
}


#define USERDEF_DOMAIN SFX_OBJECTBAR_USERDEF1

struct SfxTBOptions_Impl
{
	USHORT          nIndex;
	USHORT          nId;
	USHORT          nDomain;
	String          aName;
	SfxInterface*   pIFace;
	BOOL			bVisible;
	String			aUserName;
	USHORT          nOldDomain;
	String          aOldName;
	SfxInterface*   pOldIFace;
	BOOL			bWasVisible;
	ButtonType		eOldType;
	ButtonType		eType;
	BOOL			bDeleted;
	String			aOldUserName;

	SfxTBOptions_Impl(USHORT n, USHORT nID, USHORT nPos, String aString,
							BOOL bVis, SfxInterface *pIF, ButtonType eTyp ) :
		nIndex(n),
		nId(nID),
		nDomain(nPos),
		aName(aString),
		bVisible(bVis),
		pIFace(pIF),
		nOldDomain(nPos),
		aOldName(aString),
		pOldIFace(pIF),
		bWasVisible(bVis),
		eType( eTyp ),
		eOldType( eTyp ),
		bDeleted( FALSE )
	{}
};

//========================================================================

DECL_PTRARRAY(SfxTBOptArr_Impl, SfxTBOptions_Impl*, 6, 3);

//========================================================================

SfxObjectBarLB_Impl::SfxObjectBarLB_Impl( Window* pParent, WinBits nWinStyle) :
	SvTreeListBox(pParent, nWinStyle),
	bModified (FALSE)
{
}

//------------------------------------------------------------------------

SfxObjectBarLB_Impl::SfxObjectBarLB_Impl( Window* pParent, const ResId& rId) :
    SvTreeListBox( pParent, rId ),
	bModified (FALSE)
{
}

void SfxObjectBarLB_Impl::KeyInput( const KeyEvent& rKEvt )
{
	USHORT aCode = rKEvt.GetKeyCode().GetCode();
	if( aCode == KEY_SPACE )
	{
		SvLBoxEntry* pEntry = (SvLBoxEntry*) FirstSelected();
		if( pEntry && (GetCheckButtonState( pEntry ) == SV_BUTTON_UNCHECKED) )
			SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
		else
			SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);
		GetCheckButtonHdl().Call(this);
	}
	else if( aCode == KEY_ADD )
		return;
	else
		SvTreeListBox::KeyInput( rKEvt );
}

//------------------------------------------------------------------------

BOOL SfxObjectBarLB_Impl::NotifyMoving
(
	SvLBoxEntry* pTarget,
	SvLBoxEntry* pEntry,
	SvLBoxEntry*& rpNewParent,
	ULONG& rNewChildPos
)
{
	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
	if (!pTO->pIFace)
		return FALSE;

	SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pTarget->GetUserData();

	if (!GetParent(pTarget))
	{									// Einfuegen nach einem Begrenzer
		rpNewParent = pTarget;
		rNewChildPos = 0L;
										// solange VISIBILITY ueber Position geht
		USHORT nMask = pTO->nDomain & SFX_VISIBILITY_MASK;
		pTO->nDomain = pT->nDomain | nMask;
		bModified = TRUE;

		if (GetChildCount(pTarget) == 0)
			return 2;                   // Patch, da SvLBox nicht anders aufklappt
		else
			return TRUE;
	}
	else
	{
										// Bereich vom neuen Vorgaenger holen
		USHORT nMask = pTO->nDomain & SFX_VISIBILITY_MASK;
		pTO->nDomain = IndexToPos_Impl( (USHORT) GetModel()->GetRelPos(GetParent(pTarget)) ) | nMask;
		bModified = TRUE;

		return
		SvTreeListBox::NotifyMoving(pTarget, pEntry, rpNewParent, rNewChildPos);
	}
}

//------------------------------------------------------------------------

BOOL SfxObjectBarLB_Impl::NotifyQueryDrop( SvLBoxEntry* pEntry )
{
	if (pEntry == 0)
		return FALSE;
										// selektierte Toolbox samt Daten
	SvLBoxEntry *pSelected = FirstSelected();

	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pSelected->GetUserData();
	if (!pTO->pIFace)
		return FALSE;
										// neue Domain holen
	SvLBoxEntry *pParent = GetParent(pEntry);
	if (pParent == 0)                   // Einschieben nach einem Begrenzer
		pParent = pEntry;
										// alle childs nach dem
										// selektierten Kontext absuchen
	BOOL bError = FALSE;
	SvLBoxEntry *pChild = FirstChild(pParent);
	while (pChild)
	{
		SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pChild->GetUserData();
		if (pT->pIFace == pTO->pIFace)
		{
			bError = TRUE;              // Domain enthaelt schon eine ToolBox
			break;                      // mit gleichem Kontext
		}

		pChild = NextSibling(pChild);
	}

	return !bError;
}

//------------------------------------------------------------------------

BOOL SfxObjectBarLB_Impl::EditingEntry( SvLBoxEntry* pEntry, Selection& )
{
	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
	((SfxObjectBarConfigPage*) Window::GetParent())->StartEditing();
	
	if ( pTO->nId && pTO->nDomain >= SFX_OBJECTBAR_USERDEF1 && pTO->nDomain <= SFX_OBJECTBAR_USERDEF4 )
		return TRUE;
	else
		return FALSE;
}

//------------------------------------------------------------------------

BOOL SfxObjectBarLB_Impl::EditedEntry( SvLBoxEntry* pEntry, const String& rNewText )
{
	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
	if ( pTO->nId && pTO->nDomain >= SFX_OBJECTBAR_USERDEF1 && pTO->nDomain <= SFX_OBJECTBAR_USERDEF4 )
	{
		pTO->aUserName = rNewText;
		((SfxObjectBarConfigPage*) Window::GetParent())->EndEditing();
		bModified = TRUE;
		return TRUE;
	}
	else
		return FALSE;
}

//------------------------------------------------------------------------

BOOL SfxObjectBarLB_Impl::DoubleClickHdl()
{
	return FALSE;                       // kein Expandieren/Kollabieren
}

//------------------------------------------------------------------------

// SfxObjectBarConfigPage::Ctor() *********************************************

SfxObjectBarConfigPage::SfxObjectBarConfigPage( Window *pParent, const SfxItemSet& rSet ) :

	SfxTabPage ( pParent, SfxResId( TP_CONFIG_OBJECTBAR), rSet ),

	aObjectBarBox   ( this, ResId( BOX_OBJBARS ) ),
	aGBAssign       ( this, ResId( GB_ASSIGN ) ),
	aNewButton      ( this, ResId( BTN_NEW ) ),
	aDeleteButton   ( this, ResId( BTN_DELETE ) ),
	aCustButton 	( this, ResId( BTN_CUSTOMIZE ) ),
//	aDefaultButton	( this, ResId( BTN_DEFAULT ) ),
	aContentText    ( this, ResId( FT_CONTENT ) ),
	aContentBox     ( this, ResId( LB_CONTENT ) ),
	aContextText    ( this, ResId( FT_CONTEXT ) ),
	aContextBox     ( this, ResId( LB_CONTEXT ) ),
	aGBOptions      ( this, ResId( GB_OPTIONS ) ),
	aLoadButton 	( this, ResId( BTN_LOAD	) ),
	aSaveButton 	( this, ResId( BTN_SAVE	) ),
	aResetButton	( this, ResId( BTN_RESET ) ),
	aDomainStr      (       ResId( STR_DOMAIN   ) ),
	pTbxConfig		( NULL ),

	pArr			( NULL ),
	bModified		( FALSE ),
    bDefault		( TRUE )
{
	aContentBox.InsertEntry(String(SfxResId(STR_SYMBOL)));
	aContentBox.InsertEntry(String(SfxResId(STR_TEXT)));
	aContentBox.InsertEntry(String(SfxResId(STR_SYMBOLTEXT)));

	FreeResource();

	pButton = new SvLBoxButtonData( &aObjectBarBox );
	aObjectBarBox.EnableCheckButton(pButton);

//	  DragDropMode aDDMode = SV_DRAGDROP_CTRL_MOVE;
//	  aObjectBarBox.SetDragDropMode( aDDMode );

	aObjectBarBox.SetSelectHdl( LINK(this,SfxObjectBarConfigPage,SelectHdl));
	aContentBox.SetSelectHdl( LINK(this,SfxObjectBarConfigPage,SelectContent));
	aContextBox.SetSelectHdl( LINK(this,SfxObjectBarConfigPage,SelectContext));
	aNewButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,NewHdl));
	aDeleteButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,DeleteHdl));
	aObjectBarBox.SetCheckButtonHdl( LINK(this,SfxObjectBarConfigPage,CheckHdl));
//	aDefaultButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,DefaultHdl));
	aResetButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,Default));
	aCustButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,CustHdl));
	aLoadButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,Load));
	aSaveButton.SetClickHdl( LINK(this,SfxObjectBarConfigPage,Save));

	aDeleteButton.Disable();
	aContextText.Disable();
	aContextBox.Disable();
	aContextText.Hide();
	aContextBox.Hide();
//	aDefaultButton.Disable();

	pArr = new SfxTBOptArr_Impl;
	aObjectBarBox.EnableInplaceEditing(TRUE);
}

//------------------------------------------------------------------------


SfxObjectBarConfigPage::~SfxObjectBarConfigPage()
{
	Exit();
	delete pArr;
	delete pButton;
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, CheckHdl, SvTreeListBox *, pSvTreeListBox )
{
	SvLBoxEntry *pEntry 	= aObjectBarBox.GetHdlEntry();
	BOOL bVis = (aObjectBarBox.GetCheckButtonState(pEntry) == SV_BUTTON_CHECKED);

	SfxTBOptions_Impl *pTO  = (SfxTBOptions_Impl*) pEntry->GetUserData();
	bModified = TRUE;
	bDefault = FALSE;
	if ( aObjectBarBox.GetChildCount(pEntry) == 1 )
	{
		// Ausschalten kollabierter Bereiche wirkt nur auf den Bereich,
		// Einschalten wirkt immer auf Bereich und Objektleiste
		if ( bVis )
			pTO->bVisible = bVis;		// Objektleiste
		pEntry = aObjectBarBox.FirstChild(pEntry);
		pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
		pTO->bVisible = bVis;			// Bereich
	}
	else
		pTO->bVisible = bVis;			// Objektleiste
	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, SelectHdl, SvTreeListBox *, pBox )
{
										// selektierten Eintrag holen
	SvLBoxEntry *pEntry = pBox->FirstSelected();

										// deselektiert
	if (pEntry == 0)
	{
		aContextBox.SetNoSelection();
//		aDefaultButton.Disable();
		aDeleteButton.Disable();
		aContextText.Disable();
		aContextBox.Disable();
	}
	else
	{                                   // Name und Kontext uebertragen

		SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
		aContentBox.SelectEntryPos( (USHORT) pTO->eType );
		if (pTO->pIFace == 0)
		{								// Trenner selektiert
			aContextBox.SetNoSelection();
		}
		else
		{
			aContextBox.SelectEntry(pTO->pIFace->GetName());
//			aContextText.Enable( bCondition );
//			aContextBox.Enable( bCondition );
		}

//		aDefaultButton.Enable();
		BOOL bCondition = SfxToolBoxManager::IsUserDefToolBox_Impl(pTO->nId);
		aDeleteButton.Enable( bCondition );
	}
	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, SelectContext, ListBox *, pBox )
{
										// selektierten Kontext ermitteln
	USHORT nPos = pBox->GetSelectEntryPos();

										// selektierte ToolBox holen
	SvLBoxEntry *pSelected = aObjectBarBox.FirstSelected();
	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pSelected->GetUserData();

										// Wenn Bereich selektiert ...
	if (pSelected && !pTO->pIFace)
		pSelected = 0;

	if (!pSelected)                     // keine ToolBox, keine Anzeige
	{
		pBox->SetNoSelection();
		return 0;
	}
										// ToolBox ohne Kontext geht nicht
	if (pBox->GetSelectEntryCount() == 0)
	{
		aObjectBarBox.SelectAll(FALSE,TRUE);
		return 0;
	}
										// alle Geschwister nach dem
										// selektierten Kontext absuchen
	SvLBoxEntry *pParent = aObjectBarBox.GetParent(pSelected);
	if (!pParent)
		pParent = pSelected;
	SvLBoxEntry *pChild = aObjectBarBox.FirstChild(pParent);

	BOOL bError = FALSE;
	while (pChild)
	{
		if (pChild == pSelected)
		{
			pChild = aObjectBarBox.NextSibling(pChild);
			if (!pChild) break;
		}

		SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pChild->GetUserData();
		if (pT->pIFace ==(SfxInterface*)  pBox->GetEntryData(nPos))
		{
			bError = TRUE;
			break;
		}

		pChild = aObjectBarBox.NextSibling(pChild);
	}

	if (bError)
	{
										// alter Kontext bleibt erhalten
		pBox->SelectEntry(pTO->pIFace->GetName());
	}
	else
	{
										// neuen Kontext eintragen
		pTO->pIFace = (SfxInterface*) pBox->GetEntryData(nPos);
		bModified = TRUE;
		bDefault = FALSE;
	}
	return 0;
}


//------------------------------------------------------------------------

void SfxObjectBarConfigPage::Apply( SfxToolBoxConfig* pTbxCfg, BOOL bIsDefault )
{
	if ( bIsDefault )
	{
		pTbxCfg->UseDefault();
		pTbxCfg->SetDefault( TRUE );

		SvUShorts aListOfIds;
		USHORT n=0;

        // copy all toolbox configurations as they were before starting the configuration dialog
        // don't copy immediately, put the IDs into a list and copy later
        // userdefined toolboxes start a new interface iterating loop, and these loops are
        // not reentrant
		SfxInterface *pIFace;
		SfxConfigManager* pCfgMgr = pTbxCfg->GetConfigManager();
		for ( pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0; pIFace = SFX_SLOTPOOL().NextInterface() )
		{
			if ( pIFace->HasName() )
			{
				for ( USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++ )
				{
					USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
					aListOfIds.Insert(nId, n++);
				}
			}
		}

        // copy items collected
		for ( USHORT i=0; i<n; i++ )
		{
			pCfgMgr->ResetConfigItem( aListOfIds[i] );
			pCfgMgr->ReInitialize( aListOfIds[i] );
		}

        // copy user defined toolboxes also
        for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
		{
            pCfgMgr->ResetConfigItem( nId );
			pCfgMgr->ReInitialize( nId );
		}

		return;
	}

//	pTbxConfig->SetDefault( FALSE );
	for ( USHORT n=pArr->Count(); n>0; n-- )
	{
		// R"uckw"arts, damit zuerst die gel"oschten UserDefToolBoxen abgemeldet
		// werden, bevor neue etvl. mit der gleichen Id angemeldet werden!
		SfxTBOptions_Impl *pTO = (*pArr)[n-1];
		if ( pTO == 0 )
			continue;

		USHORT nId = pTO->nId;
		SfxInterface* pIFace = pTO->pIFace;
										// Wurde der Kontext gewechselt ?
		if ( pIFace != pTO->pOldIFace )
		{
			if ( pIFace )				// Neuer Kontext
			{							// Gibt es einen alten Kontext ??
				pIFace->TransferObjectBar( pTO->nDomain, nId, pTO->pOldIFace, &pTO->aName );
				pIFace->SetObjectBarVisible( pTO->bVisible, nId );
			}
			else if ( pTO->pOldIFace )	// nur abmelden
			{
				pTO->pOldIFace->ReleaseObjectBar( nId );
				if ( !pIFace && SfxToolBoxManager::IsUserDefToolBox_Impl( nId ) )
				{
										// selbstdefinierte Toolboxen, die in
										// keinem Interface mehr registriert
										// sind, koennen entfernt werden
                    pTbxCfg->GetConfigManager()->ResetConfigItem( nId );
				}
			}
		}
		else if ( pIFace )
		{
			if ( pTO->nDomain != pTO->nOldDomain )
				pIFace->SetObjectBarPos( pTO->nDomain, nId );

			if ( pTO->aName != pTO->aOldName )
				pIFace->SetObjectBarName( pTO->aName, nId );

			if ( pTO->bVisible != pTO->bWasVisible )
				pIFace->SetObjectBarVisible( pTO->bVisible, nId );
			
			if ( SfxToolBoxManager::IsUserDefToolBox_Impl( nId ) && pTO->aOldUserName != pTO->aUserName )
				pTbxCfg->SetToolBoxPositionUserName( pTO->nDomain, pTO->aUserName );
		}
		else
		{
			USHORT nDomain = pTO->nDomain;
			if ( pTO->eType != pTO->eOldType )
				pTbxCfg->SetButtonType( nDomain, pTO->eType );

			if ( pTO->bVisible != pTO->bWasVisible )
				pTbxCfg->SetToolBoxPositionVisible( nDomain, pTO->bVisible );

			if ( pTO->nId && nDomain >= SFX_OBJECTBAR_USERDEF1 && nDomain <= SFX_OBJECTBAR_USERDEF4 )
			{
				if ( pTO->bDeleted )
					SfxToolBoxManager::RemoveConfiguration( pTbxCfg->GetConfigManager(), pTO->nId );
				else
					SfxToolBoxManager::CreateConfiguration( pTbxCfg->GetConfigManager(), pTO->nId );

				if ( SfxToolBoxManager::IsUserDefToolBox_Impl( nId ) && pTO->aOldUserName != pTO->aUserName )
				{
					pTbxCfg->SetToolBoxPositionUserName( pTO->nDomain, pTO->aUserName );
				}
			}

//			if ( pTO->aName != pTO->aOldName )
//				pTbxCfg->SetToolBoxPositionName( nDomain, &pTO->aName );
		}
	}
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, CustHdl, PushButton *, pButton )
{
	((SfxTabDialog*)GetParent()->GetParent())->OK_Impl();
	((SfxConfigDialog*)GetParent()->GetParent())->Ok();
	((SfxTabDialog*)GetParent()->GetParent())->EndDialog(3);
	return 0;
}

//------------------------------------------------------------------------

void SfxObjectBarConfigPage::Exit()
{
	for (USHORT i=0; i<pArr->Count(); i++)
	{
		SfxTBOptions_Impl *pTO = (*pArr)[i];
		if (pTO)
			delete pTO;
	}

	pArr->Remove(0, pArr->Count());
}


//------------------------------------------------------------------------

typedef SvLBoxEntry* EntryPtr;

void SfxObjectBarConfigPage::Init(USHORT nSelectedId, BOOL bLoadedCfg )
{
	SvLBoxEntry *pSelectedEntry=0;

	// Zun"achst Platz f"ur selbstdefinierte Toolboxen schaffen
	USHORT nIndex;
	for ( nIndex=0; nIndex<NEW_SFX_TOOLBOX_MAX; nIndex++ )
		pArr->Append( (SfxTBOptions_Impl*)0 );

	SfxInterface            *pIFace;
	SfxTBOptions_Impl       *pTO;       // ToolBox-Arbeitsdaten
	USHORT                  n=0;        // Interface-Zaehler
	String					aEmpty;

	// Aus allen auffindbaren Interfaces die Toolboxen einsammeln
	SfxSlotPool& rSlotPool = SFX_SLOTPOOL();
	for ( pIFace = rSlotPool.FirstInterface(); pIFace != 0;
		  pIFace = rSlotPool.NextInterface() )
	{
		// Nur Interfaces mit Namen sind anzeigbare Kontexte
		if ( pIFace->HasName() )
		{
			aContextBox.InsertEntry(pIFace->GetName());
			aContextBox.SetEntryData(n++, pIFace);

			for ( USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++ )
			{
				// F"ur jede Objectbar ein Options-struct anlegen und in das
				// array einf"ugen
				pTO = new SfxTBOptions_Impl(nIndex,
											pIFace->GetObjectBarResId(nNo).GetId(),
											pIFace->GetObjectBarPos(nNo),
										  *(pIFace->GetObjectBarName(nNo)),
											pIFace->IsObjectBarVisible(nNo),
											pIFace,
											BUTTON_SYMBOL );	// Erst mal defaulten, wird unten vom Bereich geholt

				nIndex++;
				pArr->Append(pTO);
			}
		}
	}

	SfxConfigManager* pMgr = GetTabDialog()->GetViewFrame()->GetObjectShell()->GetConfigManager();
	USHORT nMask = SFX_VISIBILITY_CLIENT | SFX_VISIBILITY_STANDARD;
	if ( !pMgr )
	{
		pMgr = SFX_APP()->GetConfigManager_Impl();
		nMask = SFX_VISIBILITY_SERVER | SFX_VISIBILITY_STANDARD;
	}

	for ( USHORT nUser=0; nUser<4; nUser++ )
	{
		USHORT nType = nUser + RID_SFX_TOOLBOX_START + 10;
		if ( pMgr->HasConfigItem( nType ) )
		{
			pTO = new SfxTBOptions_Impl(nUser,
										nType,
										SFX_OBJECTBAR_USERDEF1 + nUser,
										pTbxConfig->GetToolBoxPositionName( SFX_OBJECTBAR_USERDEF1 + nUser ),
										pTbxConfig->IsToolBoxPositionVisible( SFX_OBJECTBAR_USERDEF1 + nUser ),
										NULL,
										BUTTON_SYMBOL );	// Erst mal defaulten, wird unten vom Bereich geholt

			pTO->aUserName = pTbxConfig->GetToolBoxPositionUserName( SFX_OBJECTBAR_USERDEF1 + nUser );
			if ( !bLoadedCfg )
			{
				// Set old and new user name identical only if haven't loaded a configuration! Otherwise
				// we won't store a new user name because they are identical!
				pTO->aOldUserName = pTO->aUserName;
			}
			(*pArr)[nUser] = pTO;
		}
	}

	SvLBoxEntry* pEntry;
	SvLBoxEntry* pParentEntry;
	EntryPtr *pEntryArr = new EntryPtr[SFX_OBJECTBAR_MAX];

	// Jede Objectbar-Position ist ein entsprechender Bereich in der Listbox
	for (n=0; n<SFX_OBJECTBAR_MAX; n++ )
	{
		USHORT nDomain = IndexToPos_Impl(n);
		String aStr = pTbxConfig->GetToolBoxPositionName( nDomain );
		pEntry = aObjectBarBox.InsertEntry( aStr );
		pEntryArr[n] = pEntry;

		// Eigenschaften des Bereiches
		pTO = new SfxTBOptions_Impl(n, 0, nDomain, aStr,
				pTbxConfig->IsToolBoxPositionVisible( nDomain ), 0,
				pTbxConfig->GetButtonType( nDomain ) );
		
		// Sichtbarkeits-Status auf den entsprechenden Checkbutton "ubertragen
		if ( pTO->bVisible )
			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
		else
			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);

		pArr->Append(pTO);
		pEntry->SetUserData(pTO);
	}

	// F"ur jede Objectbar den entsprechenden entry aus dem array holen
	for (n=0; n<pArr->Count();  n++)
	{
		pTO = (*pArr)[n];
		if ( pTO && pTO->nId )
		{
			USHORT nIndex = PosToIndex_Impl( pTO->nDomain & SFX_POSITION_MASK );
			pParentEntry = pEntryArr[ nIndex ];
			pEntry = aObjectBarBox.InsertEntry( pTO->aName, pParentEntry );
			pEntry->SetUserData(pTO);

			// Buttontype vom Bereich auf die Objectbar "ubertragen
			pTO->eType = pTO->eOldType = ((SfxTBOptions_Impl*)pParentEntry->GetUserData())->eType;

			// Sichtbarkeits-Status auf den entsprechenden Checkbutton "ubertragen
			if (pTO->bVisible)
				aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
			else
				aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);

			// Falls eine Id "ubergeben wurde, soll sie die Objectbar mit
			// diese Id gleich selektiert werden
			if ( pTO->nId == nSelectedId )
				pSelectedEntry = pEntry;
		}
	}

	// Alle Bereiche untersuchen, ob sie mehr als einen ChildEntry enthalten;
	// anderenfalls wird der Entry f"ur den Bereich durch den seines childs
	// ersetzt
	for (n=0; n<SFX_OBJECTBAR_MAX; n++ )
	{
		pParentEntry = pEntryArr[n];
		if ( aObjectBarBox.GetChildCount(pParentEntry) == 1 )
		{
			pEntry = aObjectBarBox.FirstChild( pParentEntry );
			SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
			SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pParentEntry->GetUserData();
			pParentEntry->SetUserData(pTO);
			pEntry->SetUserData(pT);

			if ( pT->bVisible )
				aObjectBarBox.SetCheckButtonState( pParentEntry, aObjectBarBox.GetCheckButtonState(pEntry) );

			if ( bLoadedCfg )
			{
				// Force update if we loaded a configuration
				if ( pT->bVisible )
					pT->bWasVisible = FALSE;
				else
					pT->bWasVisible = TRUE;
			}

			if ( pTO->aName.Len() )
			{
				if ( pTO->nDomain >= SFX_OBJECTBAR_USERDEF1 && pTO->nDomain <= SFX_OBJECTBAR_USERDEF4 && pTO->aUserName.Len() )
					aObjectBarBox.SetEntryText(pParentEntry,pTO->aUserName);
				else
					aObjectBarBox.SetEntryText(pParentEntry,pTO->aName);
				if (pEntry == pSelectedEntry)
					pSelectedEntry = pParentEntry;
			}
			else
				// Keine namenlosen Toolboxen ...
				aObjectBarBox.GetModel()->Remove(pParentEntry);
		}
		else if ( aObjectBarBox.GetChildCount(pParentEntry) == 0 )
			// Keine leeren Bereiche ...
			aObjectBarBox.GetModel()->Remove(pParentEntry);
		else
		{
			SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pParentEntry->GetUserData();
			if ( bLoadedCfg )
			{
				// Force update if we loaded a configuration
				if ( pT->bVisible )
					pT->bWasVisible = FALSE;
				else
					pT->bWasVisible = TRUE;
			}
		}
//		else
//			// Alle gef"ullten Bereiche werden auch aufgeklappt angezeigt
//			aObjectBarBox.Expand (pParentEntry);
	}

	delete []pEntryArr;

	if ( pSelectedEntry )
		aObjectBarBox.SetCurEntry( pSelectedEntry );
}

//------------------------------------------------------------------------

void SfxObjectBarConfigPage::SetObjectBarId(USHORT nId)
{
	SvLBoxEntry *pEntry  = aObjectBarBox.First();
	SvLBoxEntry *pLast	 = pEntry;

	while (pEntry)
	{
		pLast  = pEntry;				// letzte ToolBox merken
		SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();

		if (pTO->pIFace)				// eine ToolBox
		{
			if (pTO->nId == nId)		// gefunden!
				break;
										// sonst naechste ToolBox
			pEntry = aObjectBarBox.NextSibling(pEntry);

			if (!pEntry)				// gibt's nicht, also nach oben
			{
				pEntry = aObjectBarBox.GetParent(pLast);
				pLast = pEntry;
				if (pEntry) 			// es geht noch weiter
					pEntry = aObjectBarBox.NextSibling(pEntry);
			}
		}
		else							// ein Bereich, also nach unten
			pEntry = aObjectBarBox.FirstChild(pEntry);
	}

	if (pEntry)
		aObjectBarBox.SetCurEntry(pEntry);
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, NewHdl, PushButton *, pPushButton )
{
										// freien Platz suchen
	USHORT nIndex;
	SfxTBOptions_Impl* pTO;
	for (nIndex=0; nIndex<NEW_SFX_TOOLBOX_MAX; nIndex++)
	{
		pTO = (*pArr)[nIndex];
		if ( !pTO || pTO->bDeleted )
			break;
	}

	if ( nIndex == NEW_SFX_TOOLBOX_MAX )      // alle Plaetze belegt
	{
		InfoBox( this, SfxResId(IBX_TBXOPT_OVERFLOW) ).Execute();
		return 0;
	}

	USHORT nDomain = SFX_OBJECTBAR_USERDEF1 + nIndex;
	USHORT nParent;
	for ( nParent=0; nParent<pArr->Count(); nParent++ )
		if ((*pArr)[nParent] && (*pArr)[nParent]->nDomain == nDomain ) break;

	if ( pTO )
		pTO->bDeleted = FALSE;
	else
		pTO = new SfxTBOptions_Impl( nIndex,
									RID_SFX_TOOLBOX_START + 10 + nIndex,
									nDomain,
									pTbxConfig->GetToolBoxPositionName( nDomain ),
									TRUE,
									NULL,
									BUTTON_SYMBOL );	// Erst mal defaulten, wird unten vom Bereich geholt
	(*pArr)[nIndex] = pTO;
	bModified = TRUE;
	bDefault = FALSE;

	SvLBoxEntry *pParent = aObjectBarBox.InsertEntry( pTO->aName, 0, FALSE, PosToIndex_Impl( nDomain ), pTO );
	SvLBoxEntry *pEntry = aObjectBarBox.InsertEntry( pTO->aName, pParent, FALSE, PosToIndex_Impl( nDomain ), (*pArr)[nParent] );
	aObjectBarBox.SetCheckButtonState( pParent, SV_BUTTON_CHECKED );
	aObjectBarBox.SetCheckButtonState( pEntry, SV_BUTTON_CHECKED );
	aObjectBarBox.SetCurEntry( pParent );
/*
										// Name und Id mit default vorbelegen
	USHORT nId = RID_SFX_TOOLBOX_USERSTART + nIndex;
	String aName = String (SfxResId(STR_TB_USERDEF_NAME));
	aName += String::CreateFromInt32(nIndex+1);

	USHORT nPos=0;                      // Bereich und Kontext (Interface)
	USHORT n=0;                         // durch Suche ermitteln
	BOOL bError;
										// mit erstem Bereich starten
	SvLBoxEntry *pParent = aObjectBarBox.First();
	USHORT nCount=1;

	SvLBoxEntry *pEntry = aObjectBarBox.FirstSelected();

	SfxTBOptions_Impl* pPTO = (SfxTBOptions_Impl*)pParent->GetUserData();
	nPos = PosToIndex_Impl( pPTO->nDomain & SFX_POSITION_MASK );

	while ( nPos < PosToIndex_Impl(USERDEF_DOMAIN) )
	{									// zum ersten UserDef-Bereich
		pParent = aObjectBarBox.NextSibling(pParent);
		if (pParent)
		{
			pPTO = (SfxTBOptions_Impl*)pParent->GetUserData();
			nPos = PosToIndex_Impl( pPTO->nDomain & SFX_POSITION_MASK );
			nCount++;
		}
		else							// gibt es noch nicht
			nPos = PosToIndex_Impl(USERDEF_DOMAIN);
	}

	USHORT nLastCount = nCount;
	SvLBoxEntry *pFirstUserDef = pParent;

	if (pEntry) 						// einfuegen in selektierten Bereich
	{
		SfxTBOptions_Impl* pETO = (SfxTBOptions_Impl*)pEntry->GetUserData();
		USHORT i = PosToIndex_Impl( pETO->nDomain & SFX_POSITION_MASK );
		if ( i > PosToIndex_Impl(USERDEF_DOMAIN) )
		{
			nPos = i;
			pParent = aObjectBarBox.GetParent(pEntry) ?
					  aObjectBarBox.GetParent(pEntry) : pEntry;
		}
	}

	do
	{
		do
		{
			if (!pParent)
			{
				String aStr = pTbxConfig->GetToolBoxPositionName(n);
				if (!aStr.Len())
					aStr = aName;
				pParent = aObjectBarBox.InsertEntry( aStr,0,FALSE,nCount );
				USHORT nDom = IndexToPos_Impl( nPos );
				SfxTBOptions_Impl *pTO =
					new SfxTBOptions_Impl(nPos, 0, nDom, aName,
						pTbxConfig->IsToolBoxPositionVisible(nPos),
						0, BUTTON_SYMBOL);
				pTO->bVisible = TRUE;

				aObjectBarBox.SetCheckButtonState(pParent, SV_BUTTON_CHECKED);
				pArr->Append(pTO);
				pParent->SetUserData(pTO);
				if (!pFirstUserDef)
					pFirstUserDef = pParent;
			}

			SvLBoxEntry *pChild = aObjectBarBox.FirstChild(pParent);

			bError = FALSE;
			while (pChild)
			{
				SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pChild->GetUserData();
				if (!pT->pIFace)
					pT = (SfxTBOptions_Impl*) pParent->GetUserData();
				if (pT->pIFace == (SfxInterface*) aContextBox.GetEntryData(n))
				{
					bError = TRUE;
					break;
				}

				pChild = aObjectBarBox.NextSibling(pChild);
			}

			if (bError)                 // in diesem Bereich gibt es schon eine
			{                           // Toolbox mit gewuenschtem Interface
				if ( pEntry && nPos != 0 && nPos != PosToIndex_Impl(USERDEF_DOMAIN) )
				{						// von vorne anfangen
					nPos = PosToIndex_Impl(USERDEF_DOMAIN);
					pParent = pFirstUserDef;
					nCount = nLastCount;
				}
				else
				{
					pEntry = 0;
					pParent = aObjectBarBox.NextSibling(pParent);
					nPos++;
					if (pParent)
					{
						SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*)
							pParent->GetUserData();
						if ( PosToIndex_Impl( pT->nDomain & SFX_POSITION_MASK ) > nPos )
							pParent = 0;
						else
							nCount++;
					}
				}
			}
		}
		while (bError && nPos < SFX_OBJECTBAR_MAX);

		if (bError && n<aContextBox.GetEntryCount() - 1)
		{
			n++;						// naechsten Kontext ausprobieren
			nPos = PosToIndex_Impl(USERDEF_DOMAIN);
			pParent = pFirstUserDef;
			nCount = nLastCount;
			pEntry = 0; 				// von vorne anfangen
		}
	}
	while (bError && nPos < SFX_OBJECTBAR_MAX);

	if (bError)
	{
		InfoBox( this, SfxResId(IBX_TBXOPT_OVERFLOW) ).Execute();
		return 0;
	}
										// neuer Eintrag ohne altes Interface
	USHORT nTbxPos = IndexToPos_Impl( nPos );
	SfxTBOptions_Impl* pTO = new SfxTBOptions_Impl(nIndex,nId,nTbxPos,aName,TRUE,0,BUTTON_SYMBOL);
	(*pArr)[nIndex] = pTO;
	pTO->pIFace = (SfxInterface*) aContextBox.GetEntryData(n);
	bModified = TRUE;

	if (aObjectBarBox.GetChildCount(pParent) == 0)
	{
										// erstes Child: auf Top Level
		SfxTBOptions_Impl *pTp = (SfxTBOptions_Impl*) pParent->GetUserData();

		pParent->SetUserData(pTO);
		aObjectBarBox.SetEntryText(pParent,pTO->aName);
		aObjectBarBox.SetCurEntry(pParent);

		pEntry = aObjectBarBox.InsertEntry( pTO->aName, pParent );
		pEntry->SetUserData(pTp);
		if (pTp->bVisible)
			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
		else
			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);
	}
	else if (aObjectBarBox.GetChildCount(pParent) == 1)
	{
										// zweites Child: erstes Child auf
										// niedrigeren Level ziehen
		pEntry = aObjectBarBox.FirstChild(pParent);
		SfxTBOptions_Impl *pTp = (SfxTBOptions_Impl*) pParent->GetUserData();
		SfxTBOptions_Impl *pT  = (SfxTBOptions_Impl*) pEntry->GetUserData();

		pParent->SetUserData(pT);
		aObjectBarBox.SetEntryText(pParent,pT->aName);
		if (pT->bVisible)
			aObjectBarBox.SetCheckButtonState(pParent, SV_BUTTON_CHECKED);
		else
			aObjectBarBox.SetCheckButtonState(pParent, SV_BUTTON_UNCHECKED);

		pEntry->SetUserData(pTp);
		aObjectBarBox.SetEntryText(pEntry,pTp->aName);
		if (pTp->bVisible)
			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
		else
			aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_UNCHECKED);

		pEntry = aObjectBarBox.InsertEntry( pTO->aName, pParent );
		pEntry->SetUserData(pTO);
		aObjectBarBox.SetCheckButtonState(pEntry, SV_BUTTON_CHECKED);
		aObjectBarBox.SetCurEntry(pEntry);
		aObjectBarBox.ShowEntry(pEntry);
	}
 */
	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, DeleteHdl, PushButton *, pPushButton )
{
	SvLBoxEntry *pEntry = aObjectBarBox.FirstSelected();

	if (pEntry)
	{
		SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
		if ( !SfxToolBoxManager::IsUserDefToolBox_Impl(pTO->nId) )
		{
			InfoBox( this, SfxResId(IBX_TBXOPT_NOUSERDEF) ).Execute();
			return 0;
		}

		pTO->pIFace = 0;
		if (pTO->pOldIFace == 0)        // geloeschter Eintrag war noch bei
		{                               // keinem Interface angemeldet
//			(*pArr)[pTO->nIndex] = 0;
//			delete pTO;
			pTO->bDeleted = TRUE;
		}
		else
		{
			pArr->Append(pTO);          // geloeschter Eintrag war angemeldet;
			(*pArr)[pTO->nIndex] = 0;   // aufheben zum spaeteren Abmelden
			pTO->nIndex = pArr->Count() - 1;
		}

		SvLBoxEntry *pParentEntry = aObjectBarBox.GetParent(pEntry);
		aObjectBarBox.GetModel()->Remove(pEntry);
		bModified = TRUE;
		bDefault = FALSE;

		if (pParentEntry && aObjectBarBox.GetChildCount(pParentEntry) == 1)
		{
			pEntry = aObjectBarBox.FirstChild(pParentEntry);
			SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
			SfxTBOptions_Impl *pT = (SfxTBOptions_Impl*) pParentEntry->GetUserData();
			pEntry->SetUserData(pT);

			pParentEntry->SetUserData(pTO);
			aObjectBarBox.SetEntryText(pParentEntry,pTO->aName);
			if (pTO->bVisible && pT->bVisible)
				aObjectBarBox.SetCheckButtonState(pParentEntry, SV_BUTTON_CHECKED);
			else
				aObjectBarBox.SetCheckButtonState(pParentEntry, SV_BUTTON_UNCHECKED);
			aObjectBarBox.Collapse(pParentEntry);
		}
	}
	return 0;
}

//------------------------------------------------------------------------

void SfxObjectBarConfigPage::StartEditing()
{
	aNewButton.Disable();
	aDeleteButton.Disable();
}

//------------------------------------------------------------------------

void SfxObjectBarConfigPage::EndEditing()
{
	aNewButton.Enable();
	aDeleteButton.Enable();
	bModified = TRUE;
	bDefault = FALSE;
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, DefaultHdl, PushButton *, pPushButton )
{
	SvLBoxEntry *pEntry = aObjectBarBox.FirstSelected();
	if (!pEntry)
		return 0;

	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
	if (!pTO->pIFace)
		return 0;

    pTbxConfig->GetConfigManager()->ResetConfigItem(pTO->nId);
	return 0;
}

//------------------------------------------------------------------------


IMPL_LINK( SfxObjectBarConfigPage, Load, Button *, pButton )
{
	String aCfgName = SfxConfigDialog::FileDialog_Impl( this,
		WB_OPEN | WB_STDMODAL | WB_3DLOOK, String( SfxResId( STR_LOADTBXCONFIG) ) );
	if ( aCfgName.Len() )
	{
		GetTabDialog()->EnterWait();
		BOOL bCreated = FALSE;
		BOOL bLoadedDocument = FALSE;
		SfxObjectShellRef xDoc;

        SfxConfigManager* pCfgMgr = SFX_APP()->GetConfigManager_Impl();
		if ( pCfgMgr->GetURL() != aCfgName )
		{
			// it was not the global configuration manager
			// first check if URL points to a document already loaded
			xDoc = SFX_APP()->DocAlreadyLoaded( aCfgName, TRUE, TRUE );
			if ( !xDoc.Is() )
				// try to load a document from the URL
				xDoc = MakeObjectShellForOrganizer_Impl( aCfgName, TRUE );
			
			if ( xDoc.Is() )
			{
				// get config manager, force creation if there was none before
				bLoadedDocument = TRUE;
				pCfgMgr = xDoc->GetConfigManager( TRUE );
			}
			else
			{
				// URL doesn't point to a document, must be a single storage
				bCreated = TRUE;
        		SvStorageRef xStor = new SvStorage( aCfgName, STREAM_STD_READ );
				if ( xStor->GetError() == ERRCODE_NONE )
					pCfgMgr = new SfxConfigManager( xStor );
				else
					pCfgMgr = NULL;
			}
		}

		if ( pCfgMgr )
		{
			SvUShorts aListOfIds;
			USHORT n=0;

            // copy all toolbox configurations as they were before starting the configuration dialog
            // don't copy immediately, put the IDs into a list and copy later
            // userdefined toolboxes start a new interface iterating loop, and these loops are
            // not reentrant
			SfxInterface *pIFace;
			for ( pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0; pIFace = SFX_SLOTPOOL().NextInterface() )
			{
				if ( pIFace->HasName() )
				{
					for ( USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++ )
					{
						USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
						aListOfIds.Insert(nId, n++);
					}
				}
			}

			// copy items collected
			SfxConfigManager& rMgr = *SFX_APP()->GetConfigManager_Impl();

			SfxImageManager::CopyConfiguration_Impl( *pCfgMgr, rMgr );

			for ( USHORT i=0; i<n; i++ )
				rMgr.CopyConfigItem( *pCfgMgr, aListOfIds[i] );

            // copy userdefined toolboxes also
			for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
                rMgr.CopyConfigItem( *pCfgMgr, nId );

			// Reinitialize image list configuration
			rMgr.ReInitialize( SFX_ITEMTYPE_IMAGELIST );
			rMgr.StoreConfiguration();
			
			SfxToolBoxConfig *pTbxCfg = new SfxToolBoxConfig( *pTbxConfig, pCfgMgr );
			SfxToolBoxConfig* pOld = pTbxConfig;

			// Use loaded configuration to fill controls
			pTbxConfig = pTbxCfg;
			
			aObjectBarBox.SetUpdateMode(FALSE);
			aObjectBarBox.Clear();
			aContextBox.Clear();
			Exit();
			Init( 0, TRUE ); // configuration loaded
			aObjectBarBox.SetUpdateMode(TRUE);
			aObjectBarBox.Invalidate();
			bModified = TRUE;
			bDefault = FALSE;

			pTbxConfig = pOld;

			delete pTbxCfg;
			if ( bCreated )
				delete pCfgMgr;
            
			// Reinitialize all dependent toolboxes
			for ( i=0; i<n; i++ )
				rMgr.ReInitialize( aListOfIds[i] );
		}

		GetTabDialog()->LeaveWait();
	}

	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, Save, Button *, pButton )
{
	String aCfgName = SfxConfigDialog::FileDialog_Impl( this,
		WB_SAVEAS | WB_STDMODAL | WB_3DLOOK, String( SfxResId( STR_SAVETBXCONFIG) ) );
	if ( aCfgName.Len() )
	{
		GetTabDialog()->EnterWait();
		BOOL bCreated = FALSE;
		BOOL bLoadedDocument = FALSE;
		SfxObjectShellRef xDoc;

        SfxConfigManager* pCfgMgr = SFX_APP()->GetConfigManager_Impl();
		if ( pCfgMgr->GetURL() != aCfgName )
		{
			// it was not the global configuration manager
			// first check if URL points to a document already loaded
			xDoc = SFX_APP()->DocAlreadyLoaded( aCfgName, TRUE, TRUE );
			if ( xDoc.Is() )
				bLoadedDocument = TRUE;
			else
				// try to load a document from the URL
				xDoc = MakeObjectShellForOrganizer_Impl( aCfgName, TRUE );
			if ( xDoc.Is() )
			{
				// get config manager, force creation if there was none before
				pCfgMgr = xDoc->GetConfigManager( TRUE );
			}
			else
			{
				// URL doesn't point to a document, must be a single storage
				bCreated = TRUE;
        		SvStorageRef xStor = new SvStorage( aCfgName, STREAM_STD_WRITE, STORAGE_TRANSACTED );
				if ( xStor->GetError() == ERRCODE_NONE )
					pCfgMgr = new SfxConfigManager( xStor );
				else
					pCfgMgr = NULL;
			}
		}

		if ( pCfgMgr )
		{
			SvUShorts aListOfIds;
			USHORT n=0;

            // copy all toolbox configurations as they were before starting the configuration dialog
            // don't copy immediately, put the IDs into a list and copy later
            // userdefined toolboxes start a new interface iterating loop, and these loops are
            // not reentrant
			SfxInterface *pIFace;
			for ( pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0; pIFace = SFX_SLOTPOOL().NextInterface() )
			{
				if ( pIFace->HasName() )
				{
					for ( USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++ )
					{
						USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
						aListOfIds.Insert(nId, n++);
					}
				}
			}

            // copy items collected
			SfxConfigManager* pMgr    = SFX_APP()->GetConfigManager_Impl();
			SfxConfigManager* pDocMgr = GetTabDialog()->GetViewFrame()->GetObjectShell()->GetConfigManager();

			for ( USHORT i=0; i<n; i++ )
				if ( pDocMgr && pDocMgr->HasConfigItem( aListOfIds[i] ) )
					pCfgMgr->CopyConfigItem( *pDocMgr, aListOfIds[i] );
			    else
					pCfgMgr->CopyConfigItem( *pMgr, aListOfIds[i] );

            // copy user defined toolboxes also
            for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
				if ( pDocMgr && pDocMgr->HasConfigItem( nId ) )
					pCfgMgr->CopyConfigItem( *pDocMgr, nId );
			    else
					pCfgMgr->CopyConfigItem( *pMgr, nId );

            SfxImageManager::CopyConfiguration_Impl( *GetTabDialog()->GetViewFrame()->GetImageManager()->GetConfigManager(), *pCfgMgr );

            // apply changes
            SfxToolBoxConfig *pTbxCfg = new SfxToolBoxConfig( *pTbxConfig, pCfgMgr );
			Apply( pTbxCfg, FALSE );
//			pTbxCfg->SetDefault(FALSE);
			pCfgMgr->StoreAlwaysConfigItem( *pTbxCfg );

            // save configuration
            if ( bLoadedDocument )
            {
                SfxRequest aReq( SID_SAVEDOC, SFX_CALLMODE_SYNCHRON, xDoc->GetPool() );
                xDoc->ExecuteSlot( aReq );
            }
            else
				pCfgMgr->StoreConfiguration();

            // cleanup
			delete pTbxCfg;
			if ( bCreated )
				delete pCfgMgr;
			else
			{
				pCfgMgr->ReInitialize( pTbxConfig->GetType() );
				for ( USHORT i=0; i<n; i++ )
					pCfgMgr->ReInitialize( aListOfIds[i] );

				for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
					pCfgMgr->ReInitialize( nId );
				pCfgMgr->ReInitialize( xDoc->GetImageManager_Impl()->GetType() );
			}

            if ( bLoadedDocument )
			{
				// config item has global configuration until now, must be changed
				if ( !xDoc->GetConfigManager()->HasConfigItem( pTbxConfig->GetType() ) )
                	xDoc->GetToolBoxConfig_Impl()->GetConfigManager()->ReConnect( pTbxConfig->GetType(), pCfgMgr );

				for ( USHORT i=0; i<n; i++ )
					if ( !xDoc->GetConfigManager()->HasConfigItem( aListOfIds[i] ) )
						pMgr->ReConnect( aListOfIds[i], pCfgMgr );

				for ( USHORT nId = RID_SFX_TOOLBOX_USERSTART; nId <= RID_SFX_TOOLBOX_USEREND; nId++ )
					if ( !xDoc->GetConfigManager()->HasConfigItem( nId ) )
						pMgr->ReConnect( nId, pCfgMgr );

				if ( xDoc->GetImageManager_Impl()->GetConfigManager() != pCfgMgr )
					pMgr->ReConnect( xDoc->GetImageManager_Impl()->GetType(), pCfgMgr );
			}
		}

		GetTabDialog()->LeaveWait();
	}

	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, CheckButtonHdl, Button *, pButton )
{
	bModified = TRUE;
	bDefault = FALSE;
	return 0;
}

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, Default, PushButton *, pPushButton )
{
	// creating a ConfigItem without ConfigManager forces it to use its default
	SfxToolBoxConfig *pTbxCfg = new SfxToolBoxConfig( *pTbxConfig, NULL );
	SfxToolBoxConfig* pOld = pTbxConfig;
	pTbxConfig = pTbxCfg;

	aObjectBarBox.SetUpdateMode(FALSE);
	aObjectBarBox.Clear();
	aContextBox.Clear();
	Exit();
	Init(0);
	aObjectBarBox.SetUpdateMode(TRUE);
	aObjectBarBox.Invalidate();
	bModified = TRUE;
	bDefault = TRUE;

	pTbxConfig = pOld;
	delete pTbxCfg;
	return 0;

/*
	USHORT nId;
	for (nId = RID_SFX_TOOLBOX_USERSTART; nId<= RID_SFX_TOOLBOX_USEREND; nId++ )
		SFX_CFGMANAGER()->Remove(nId);

	SfxInterface *pIFace;
	for (pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0;
		 pIFace = SFX_SLOTPOOL().NextInterface())
	{
		if (pIFace->HasName())
		{
			SFX_CFGMANAGER()->ResetConfigItem(pIFace->GetConfigId());

			for (USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++)
			{
				nId = pIFace->GetObjectBarResId(nNo).GetId();
				SFX_CFGMANAGER()->ResetConfigItem(nId);
			}
		}
	}

	SFX_CFGMANAGER()->ResetConfigItem(SFX_IMAGEMANAGER()->GetType());
*/
	return 0;
}

//------------------------------------------------------------------------
#if 0

void SfxObjectBarConfigPage::CopyToolBoxes(
		SfxConfigManager *pSrcMgr,
		SfxConfigManager *pDstMgr)
{
	// Imagelist kopieren
    SfxImageManager *pImgMgr = SFX_APP()->GetImageManager();
    pImgMgr->GetConfigManager_Impl()->CopyItem(pImgMgr->GetType(), pSrcMgr);

	SvUShorts aListOfIds;
	USHORT n=0;

	// Alle Toolboxen kopieren
	SfxInterface *pIFace;
	for (pIFace = SFX_SLOTPOOL().FirstInterface(); pIFace != 0;
		 pIFace = SFX_SLOTPOOL().NextInterface())
	{
		if (pIFace->HasName())
		{
			// Zuerst die Interface-Konfiguration kopieren
            if (pSrcMgr->HasConfigItem(pIFace->GetConfigId()))
                pIFace->GetConfig_Impl()->GetConfigManager()->
                        CopyItem(pIFace->GetConfigId(), pSrcMgr);

			// dann Konfigurationen f"ur alle ObjectBars des Interface kopieren
			for (USHORT nNo=0; nNo<pIFace->GetObjectBarCount(); nNo++)
			{
				// Nicht sofort kopieren, falls userdefined Toolboxen dabei
				// sind, denn die machen eine neue Interface-Loop auf, und
				// die ist leider nicht reentrant !!
				USHORT nId = pIFace->GetObjectBarResId(nNo).GetId();
				aListOfIds.Insert(nId, n++);
			}
		}
	}

	for ( USHORT i=0; i<n; i++ )
		pDstMgr->CopyItem(aListOfIds[i], pSrcMgr);
}
#endif

//------------------------------------------------------------------------

IMPL_LINK( SfxObjectBarConfigPage, SelectContent, ListBox *, pBox )
{
	// selektierte ToolBox und Daten holen
	SvLBoxEntry *pSelected = aObjectBarBox.GetHdlEntry();
	SfxTBOptions_Impl *pTO = (SfxTBOptions_Impl*) pSelected->GetUserData();

	// Buttontype setzen
	pTO->eType = (ButtonType) aContentBox.GetSelectEntryPos();

	// Wenn kein Bereich selektiert, auch den Bereich bearbeiten
	if ( pSelected && aObjectBarBox.GetParent( pSelected ) )
	{
		pSelected = aObjectBarBox.GetParent( pSelected );
		pTO = (SfxTBOptions_Impl*) pSelected->GetUserData();
		pTO->eType = (ButtonType) aContentBox.GetSelectEntryPos();
	}
	else if ( aObjectBarBox.GetChildCount(pSelected) == 1 )
	{
		// Wenn der Bereich kollabiert ist, auch child bearbeiten
		SvLBoxEntry *pEntry = aObjectBarBox.FirstChild(pSelected);
		pTO = (SfxTBOptions_Impl*) pEntry->GetUserData();
		pTO->eType = (ButtonType) aContentBox.GetSelectEntryPos();

	}

	bModified = TRUE;
	bDefault = FALSE;
	return 0;
}


BOOL SfxObjectBarConfigPage::FillItemSet( SfxItemSet& )
{
    if ( bModified || aObjectBarBox.bModified )
	{
		Apply( pTbxConfig, bDefault );
		pTbxConfig->StoreConfig();
		bModified = FALSE;
        aObjectBarBox.bModified = FALSE;
		return TRUE;
	}

	return FALSE;
}


void SfxObjectBarConfigPage::Reset( const SfxItemSet& )
{
    if ( !pTbxConfig )
    {
        pTbxConfig = GetTabDialog()->GetViewFrame()->GetBindings().GetToolBoxConfig();
        Init(0);
        aObjectBarBox.GrabFocus();
    }
}

