/*************************************************************************
 *
 *  $RCSfile: pprofile.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:09:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef _CONFIG_HXX
#include <tools/config.hxx>
#endif

#include "maindlg.hxx"
#include "script.hxx"
#include "decltor.hxx"
#include "environ.hxx"
#include "respfile.hxx"

#include "pprofile.hxx"
#include "pprofile.hrc"

PageProfile::PageProfile( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aFTInfo3		( this, ResId(FT_INFO3, rResId.GetResMgr()) ),
	aFLDelim		( this, ResId(FL_DELIM, rResId.GetResMgr()) ),
	aLBProfiles		( this, ResId(LB_PROFILES, rResId.GetResMgr()) ),
	aEDNewProfile	( this, ResId(ED_NEWPROFILE, rResId.GetResMgr()) ),
	aPBModify		( this, ResId(PB_MODIFY, rResId.GetResMgr()) ),
	aPBDelete		( this, ResId(PB_DELETE, rResId.GetResMgr()) ),
	aPBAdd			( this, ResId(PB_ADDNEW, rResId.GetResMgr()) ),
	aStrOneAtAll	( ResId(STR_ONEATALL, rResId.GetResMgr()) ),
	aStrNoName		( ResId(STR_NONAME, rResId.GetResMgr()) ),
	aStrExists		( ResId(STR_EXISTS, rResId.GetResMgr()) )
{
	String aText( ResId(STR_TITLE, rResId.GetResMgr()) );
	pParent->SetTitleStr( aText );
	FreeResource();

	pEnv = GETDLG()->GetEnv();
	pCScript = GETDLG()->GetCScript();

	aPBModify.SetClickHdl( LINK(this, PageProfile, ClickHdl) );
	aPBDelete.SetClickHdl( LINK(this, PageProfile, ClickHdl) );
	aPBAdd.SetClickHdl( LINK(this, PageProfile, ClickHdl) );

	if( pEnv->GetActiveModuleSet() )
	{
		BOOL bNewOne = TRUE;
		SiModuleSetList& rLst = pEnv->GetModuleSetList();
		for( USHORT i = 0; i < rLst.Count(); ++i )
			if( rLst.GetObject(i)->Name().CompareIgnoreCaseToAscii(
				pEnv->GetActiveModuleSet()->Name()) == COMPARE_EQUAL )
			{
				bNewOne = FALSE;
				break;
			}
		if( bNewOne )
			pEnv->AddModuleSet( pEnv->GetActiveModuleSet() );
		pEnv->SetActiveModuleSet( NULL );
	}
	UpdateLB();
}

PageProfile::~PageProfile()
{
}

//	=============================================================

SvAgentPage* PageProfile::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageProfile( pParent, rResId );
}

//	=============================================================

BOOL PageProfile::AllowNext()
{
	if( !pEnv->GetActiveModuleSet() &&
		!pEnv->GetModuleSetList().Count() )
	{
		ErrorBox(this, WB_OK, aStrOneAtAll).Execute();
		return FALSE;
	}
	return TRUE;
}

//	=============================================================

USHORT PageProfile::GetReturnVal()
{
	if( pEnv->GetActiveModuleSet() )
		return RETURN_ADDNEW;
	return RETURN_NEXT;
}

//	=============================================================

void PageProfile::UpdateLB()
{
	aLBProfiles.Clear();

	SiModuleSetList& rLst = pEnv->GetModuleSetList();
	for( USHORT i = 0; i < rLst.Count(); ++i )
	{
		SiModuleSet* pSet = rLst.GetObject(i);
		USHORT nPos = aLBProfiles.InsertEntry( UniString(pSet->Name(), osl_getThreadTextEncoding()) );
		aLBProfiles.SetEntryData( nPos, (void*)pSet );
	}
}

//	=============================================================

IMPL_LINK( PageProfile, ClickHdl, Button*, pBtn )
{
	//	=============================================================
	//		MODIFY
	//	=============================================================
	if( pBtn == &aPBModify )
	{
		if( aLBProfiles.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
			return 0;

		USHORT nIdx = aLBProfiles.GetSelectEntryPos();
		SiModuleSet* pSet = (SiModuleSet*)aLBProfiles.GetEntryData( nIdx );

		pEnv->SetActiveModuleSet( pSet );
		pCScript->GetRootModule()->Select( SiModule::ALL_UNSEL );

		ModList& rModList = pSet->GetModList();
		for( USHORT x = 0; x < rModList.Count(); ++x )
			rModList.GetObject(x)->Select( SiModule::THIS_SEL );

		pEnv->SetActiveModuleSet( pSet );
		GETDLG()->PerformNext();
	}

	//	=============================================================
	//		DELETE
	//	=============================================================
	else if( pBtn == &aPBDelete )
	{
		if( aLBProfiles.GetSelectEntryPos() == LISTBOX_ENTRY_NOTFOUND )
			return 0;

		USHORT nIdx = aLBProfiles.GetSelectEntryPos();
		SiModuleSet* pSet = (SiModuleSet*)aLBProfiles.GetEntryData( nIdx );

		pEnv->GetModuleSetList().Remove( pSet );
		aLBProfiles.RemoveEntry( nIdx );

		Config aCfg( UniString(pEnv->GetResponseFilename(), osl_getThreadTextEncoding()) );
		aCfg.SetGroup( RESPSEC_MODULE_SPECIFY );
		aCfg.DeleteKey( pSet->Name() );

		delete pSet;

		UpdateLB();
	}

	//	=============================================================
	//		ADDNEW
	//	=============================================================
	else if( pBtn == &aPBAdd )
	{
		ByteString aName( aEDNewProfile.GetText(), osl_getThreadTextEncoding() );
		if( !aName.Len() )
		{
			ErrorBox(this, WB_OK, aStrNoName).Execute();
			return 0;
		}

		SiModuleSetList& rLst = pEnv->GetModuleSetList();
		for( USHORT i = 0; i < rLst.Count(); ++i )
			if( ((SiModuleSet*)rLst.GetObject(i))->Name().CompareIgnoreCaseToAscii(aName) == COMPARE_EQUAL )
			{
				ErrorBox(this, WB_OK, aStrExists).Execute();
				return 0;
			}

		SiModuleSet* pNewSet = new SiModuleSet(aName);
		pEnv->SetActiveModuleSet( pNewSet );
		pCScript->GetRootModule()->Select( SiModule::ALL_UNSEL );
		GETDLG()->PerformNext();
	}
	return 0;
}

