/*************************************************************************
 *
 *  $RCSfile: pasreins.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:08:48 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "maindlg.hxx"
#include "environ.hxx"

#include "pasreins.hxx"
#include "pasreins.hrc"

#define PROP_ADDUSER	1
#define PROP_CHANGE		2
#define PROP_DEINSTALL	3

PageASrvReInstallation::PageASrvReInstallation( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aRBAddUser		( this, ResId(RB_ADDUSER, rResId.GetResMgr()) ),
	aRBChange		( this, ResId(RB_CHANGEINST, rResId.GetResMgr()) ),
	aRBUnistall		( this, ResId(RB_UNINSTALL, rResId.GetResMgr()) ),
	aFTAddUser		( this, ResId(FT_ADDUSER, rResId.GetResMgr()) ),
	aFTChange		( this, ResId(FT_CHANGEINST, rResId.GetResMgr()) ),
	aFTUnistall		( this, ResId(FT_UNINSTALL, rResId.GetResMgr()) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
				UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	pParent->SetTitleStr( aTitle );

	FreeResource();

	aRBAddUser.Hide(TRUE);
	aFTAddUser.Hide(TRUE);

	aRBChange.Hide();
	aFTChange.Hide();
	aRBChange.Enable(FALSE);
	aFTChange.Enable(FALSE);

	Font aBold( aRBAddUser.GetFont() );
	aBold.SetWeight(WEIGHT_BOLD);

	aRBAddUser.SetFont(aBold);
	aRBChange.SetFont(aBold);
	aRBUnistall.SetFont(aBold);

	String aText( aFTInfo1.GetText() );
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"),
				UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );
	aFTInfo1.SetText( aText );
}

PageASrvReInstallation::~PageASrvReInstallation()
{
}

SvAgentPage* PageASrvReInstallation::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageASrvReInstallation( pParent, rResId );
}

USHORT PageASrvReInstallation::GetReturnVal()
{
/*	if(	aRBAddUser.IsChecked() )
		return RETURN_APS_ADDUSER;
	else if( aRBChange.IsChecked() )
		return RETURN_APS_CHANGE;
	else
	*/
	if( aRBUnistall.IsChecked() )
		return RETURN_APS_DEINSTALL;
	return RETURN_APS_ADDUSER;
}

BOOL PageASrvReInstallation::AllowNext()
{
	if( !aRBUnistall.IsChecked() )
	{
		GETDLG()->EndAgentDlg(FALSE);
		return FALSE;
	}

	SiEnvironment* pEnv = GETDLG()->GetEnv();
	pEnv->SetInstallType( IT_UNINSTALL );

	return TRUE;
}

ULONG PageASrvReInstallation::GetProperty()
{
	if(	aRBAddUser.IsChecked() )
		return PROP_ADDUSER;
	else if( aRBChange.IsChecked() )
		return PROP_CHANGE;
	else if( aRBUnistall.IsChecked() )
		return PROP_DEINSTALL;

	return PROP_NOTSET;
}

void PageASrvReInstallation::InitProperty(ULONG nProp)
{
	if( nProp == PROP_NOTSET ||
		nProp == PROP_ADDUSER )
		aRBAddUser.Check(TRUE);
	else if( nProp == PROP_CHANGE )
		aRBChange.Check();
	else if( nProp == PROP_DEINSTALL )
		aRBUnistall.Check();
}

