/*************************************************************************
 *
 *  $RCSfile: overdlg.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 11:04:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif
#ifndef _UNOTOOLS_CALENDARWRAPPER_HXX
#include <unotools/calendarwrapper.hxx>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#include <com/sun/star/uno/XComponentContext.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>

#include <cppuhelper/bootstrap.hxx>

#include "chainwidthbuilder.hxx"

#include "main.hxx"

#include "overdlg.hxx"
#include "dialog.hrc"

using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;
using namespace ::cppu;

#ifndef BUTTON_WIDTH
#define BUTTON_WIDTH 40
#endif
#ifndef BUTTON_HEIGHT
#define BUTTON_HEIGHT 14
#endif

OverwriteFileDialog::OverwriteFileDialog(Window* pParent) :
	ModalDialog		( pParent, ResId(RESID_DLG_OVERWRITE) ),
	m_aLogoImg		( this, ResId(1) ),
	m_aInfo1		( this, ResId(2) ),
	m_aInfoDest		( this, ResId(3) ),
	m_aGenDest		( this, ResId(4) ),
	m_aDest1		( this, ResId(5) ),
	m_aDest2		( this, ResId(6) ),
	m_aInfoSrc		( this, ResId(7) ),
	m_aGenSrc		( this, ResId(8) ),
	m_aSrc1			( this, ResId(9) ),
	m_aSrc2			( this, ResId(10) ),
	m_aYes			( this, ResId(11) ),
	m_aEver			( this, ResId(12) ),
	m_aNo			( this, ResId(13) ),
	m_aNever		( this, ResId(14) ),
	m_aKB			( ResId(2) ),
	m_aByte			( ResId(3) )
{
	SetText( String(ResId(1)) );
	FreeResource();

	m_aYes.SetClickHdl( LINK(this, OverwriteFileDialog, ClickHdl) );
	m_aEver.SetClickHdl( LINK(this, OverwriteFileDialog, ClickHdl) );
	m_aNo.SetClickHdl( LINK(this, OverwriteFileDialog, ClickHdl) );
	m_aNever.SetClickHdl( LINK(this, OverwriteFileDialog, ClickHdl) );


	Size aSize (LogicToPixel(Size(BUTTON_WIDTH, BUTTON_HEIGHT), MAP_APPFONT));

	setup::ChainWidthBuilder<PushButton> aChain(this, aSize.Width() );
	aChain.append(&m_aYes);
	aChain.append(&m_aEver);
	aChain.append(&m_aNo);
	aChain.append(&m_aNever);

	aChain.calc();
	aChain.setSize();
}

IMPL_LINK(OverwriteFileDialog,ClickHdl,Button*,pBtn)
{
	if( pBtn == &m_aYes )
		m_nStatus = STATUS_YES;
	else if( pBtn == &m_aEver )
		m_nStatus = STATUS_EVER;
	else if( pBtn == &m_aNo )
		m_nStatus = STATUS_NO;
	else if( pBtn == &m_aNever )
		m_nStatus = STATUS_NEVER;

	EndDialog();
	return 1;
}

void OverwriteFileDialog::SetExistFile(const SiDirEntry& rFile)
{
	SiDirEntry aEntry(rFile);
	aEntry.ToAbs();

	String aText(m_aInfo1.GetText());
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), aEntry.GetPath().GetFull() );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), aEntry.GetNameUni() );
	m_aInfo1.SetText(aText);

	FileStat aStat(aEntry);

	ULONG nSz = aStat.GetSize();
	String aStr( m_aByte );
	if( nSz > 2048 ) {
		nSz /= 1024;
		aStr = m_aKB;
	}

	aText = m_aDest1.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), UniString::CreateFromInt32(nSz) );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), aStr);
	m_aDest1.SetText(aText);

    CalendarWrapper aCal( comphelper::getProcessServiceFactory() );
    const LocaleDataWrapper& rWrap = Application::GetSettings().GetUILocaleDataWrapper();
    aCal.loadDefaultCalendar( rWrap.getLocale() );

    String aDateTimeStr( rWrap.getLongDate( aStat.DateModified(), aCal ) );
    aDateTimeStr += UniString::CreateFromAscii("; ");
    aDateTimeStr += rWrap.getTime( aStat.TimeModified() );

	aText = m_aDest2.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), aDateTimeStr );
	m_aDest2.SetText( aText );
}

void OverwriteFileDialog::SetSourceFile(ULONG nSize, const Date& rDate, const Time& rTime)
{
	ULONG nSz = nSize;
	String aStr( m_aByte );
	if( nSz > 2048 ) {
		nSz /= 1024;
		aStr = m_aKB;
	}

	String aText( m_aSrc1.GetText() );
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), UniString::CreateFromInt32(nSz) );
	aText.SearchAndReplace( UniString::CreateFromAscii("%2"), aStr );
	m_aSrc1.SetText( aText );

    CalendarWrapper aCal( comphelper::getProcessServiceFactory() );
    const LocaleDataWrapper& rWrap = Application::GetSettings().GetUILocaleDataWrapper();
    aCal.loadDefaultCalendar( rWrap.getLocale() );

    String aDateTimeStr( rWrap.getLongDate( rDate, aCal ) );
    aDateTimeStr += UniString::CreateFromAscii("; ");
    aDateTimeStr += rWrap.getTime( rTime );

	aText = m_aSrc2.GetText();
	aText.SearchAndReplace( UniString::CreateFromAscii("%1"), aDateTimeStr );
	m_aSrc2.SetText( aText );
}

