/*************************************************************************
 *
 *  $RCSfile: convert.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:50:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tlgen.hxx>
#include <tlstream.hxx>
#include "hashtbl.hxx"

// forwards
//
class SiDeclarator;
class SiDataCarrier;
class SiDirectory;
class SiFile;
class SiModule;
class SiFolder;
class SiCompiledScript;
class SiCompiler;

DECLARE_HASHTABLE(SiFileDict,ByteString,SiFile*)

class SiConverter
{
	SvFileStream	  &m_aStream;
	ByteString			   m_aCurrentLine;
	SiCompiler		  *m_pCompiler;
	SiCompiledScript  *m_pCS;
	HashTable		   m_Profiles;
	SiFileDict		   m_SpezialFiles;
	ByteString			   m_CLSIDSections;
	BOOL			   m_bRootOnly;

	void			CreateSystemObjects();
	BOOL			CreateRootModule(ByteString const& aName);
	SiDirectory*	GetDirectory(ByteString const& rName);
	SiModule*		GetModule(ByteString const& rValue);
	SiDataCarrier*	GetArchive(ByteString const& aArchive, SiDataCarrier *pDisk);
	SiFolder*		GetFolder(ByteString const& rID);
	static ByteString MakeID(ByteString const& rName);

	SiDeclarator* Find(ByteString const& rID);

	BOOL ReadLine(ByteString &aLine);

	// Phase 1
	BOOL ConvertProgramSection();
	BOOL ConvertSlidesSection();
	BOOL ConvertDiskSection();
	BOOL ConvertFilesSection();
	BOOL ConvertCopySection();
	BOOL ConvertOsSystemSection();
	BOOL ConvertSystemSection();
	BOOL ConvertDirectoriesSection();
	BOOL ConvertArchive(USHORT nNo);
	BOOL ConvertProgMod(USHORT nNo);
	BOOL ConvertModule(USHORT nNo);
	BOOL ConvertOption(USHORT nNo);

	// Phase 1 Reg.inf
	BOOL ConvertRegDBSection();
	BOOL ConvertCLSIDKeysSection();
	BOOL ConvertCLSIDSectionSection();

	// Phase 2
	BOOL ConvertFontsSection();
	BOOL ConvertMinimalDefaultSection(BOOL bMinimal);
	BOOL ConvertProfilesSection();
	BOOL ConvertProfileItemSection(ByteString const& aProfileID);
	BOOL ConvertProgmanSection();

	// Phase 2 Os/2
	BOOL ConvertFolderSection();
	BOOL ConvertWPSSection();
	BOOL ConvertObjectsSection();
	BOOL ConvertTemplatesSection();
	BOOL ConvertEASection();

	// Phase 2 Mac
	BOOL ConvertApplicationSection();

	BOOL Pass1();
	BOOL Pass2();

public:
	SiConverter(SvFileStream&, SiCompiler*);

	BOOL ConvertTo(SiCompiledScript*);
	BOOL ConvertRegTo(SiCompiledScript*);
};
